<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$purchase_a_edit = new purchase_a_edit();

// Run the page
$purchase_a_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$purchase_a_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fpurchase_aedit = currentForm = new ew.Form("fpurchase_aedit", "edit");

// Validate form
fpurchase_aedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($purchase_a_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->id->caption(), $purchase_a->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->supplier->Required) { ?>
			elm = this.getElements("x" + infix + "_supplier");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->supplier->caption(), $purchase_a->supplier->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->booking_reference->Required) { ?>
			elm = this.getElements("x" + infix + "_booking_reference");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->booking_reference->caption(), $purchase_a->booking_reference->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->rid->caption(), $purchase_a->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lot_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->lot_no->caption(), $purchase_a->lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->gross_weight->Required) { ?>
			elm = this.getElements("x" + infix + "_gross_weight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->gross_weight->caption(), $purchase_a->gross_weight->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_gross_weight");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->gross_weight->errorMessage()) ?>");
		<?php if ($purchase_a_edit->net_weight->Required) { ?>
			elm = this.getElements("x" + infix + "_net_weight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->net_weight->caption(), $purchase_a->net_weight->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_net_weight");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->net_weight->errorMessage()) ?>");
		<?php if ($purchase_a_edit->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->packets->caption(), $purchase_a->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->packets->errorMessage()) ?>");
		<?php if ($purchase_a_edit->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->packing_type->caption(), $purchase_a->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->containers->Required) { ?>
			elm = this.getElements("x" + infix + "_containers");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->containers->caption(), $purchase_a->containers->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_containers");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->containers->errorMessage()) ?>");
		<?php if ($purchase_a_edit->shipping_line->Required) { ?>
			elm = this.getElements("x" + infix + "_shipping_line");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->shipping_line->caption(), $purchase_a->shipping_line->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->port_arrival_date->Required) { ?>
			elm = this.getElements("x" + infix + "_port_arrival_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->port_arrival_date->caption(), $purchase_a->port_arrival_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_port_arrival_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->port_arrival_date->errorMessage()) ?>");
		<?php if ($purchase_a_edit->godown_arrival_date->Required) { ?>
			elm = this.getElements("x" + infix + "_godown_arrival_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->godown_arrival_date->caption(), $purchase_a->godown_arrival_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_godown_arrival_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->godown_arrival_date->errorMessage()) ?>");
		<?php if ($purchase_a_edit->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->godown->caption(), $purchase_a->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->rack->Required) { ?>
			elm = this.getElements("x" + infix + "_rack");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->rack->caption(), $purchase_a->rack->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->invoice_details->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->invoice_details->caption(), $purchase_a->invoice_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->invoice_value->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_value");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->invoice_value->caption(), $purchase_a->invoice_value->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_invoice_value");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->invoice_value->errorMessage()) ?>");
		<?php if ($purchase_a_edit->currency_rate->Required) { ?>
			elm = this.getElements("x" + infix + "_currency_rate");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->currency_rate->caption(), $purchase_a->currency_rate->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_currency_rate");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->currency_rate->errorMessage()) ?>");
		<?php if ($purchase_a_edit->purchase_amount_inr->Required) { ?>
			elm = this.getElements("x" + infix + "_purchase_amount_inr");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->purchase_amount_inr->caption(), $purchase_a->purchase_amount_inr->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_purchase_amount_inr");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->purchase_amount_inr->errorMessage()) ?>");
		<?php if ($purchase_a_edit->duty_paid_by->Required) { ?>
			elm = this.getElements("x" + infix + "_duty_paid_by");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->duty_paid_by->caption(), $purchase_a->duty_paid_by->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->custom_duty->Required) { ?>
			elm = this.getElements("x" + infix + "_custom_duty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->custom_duty->caption(), $purchase_a->custom_duty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_custom_duty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->custom_duty->errorMessage()) ?>");
		<?php if ($purchase_a_edit->transportation_charges->Required) { ?>
			elm = this.getElements("x" + infix + "_transportation_charges");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->transportation_charges->caption(), $purchase_a->transportation_charges->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_transportation_charges");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->transportation_charges->errorMessage()) ?>");
		<?php if ($purchase_a_edit->port_clearing_charge->Required) { ?>
			elm = this.getElements("x" + infix + "_port_clearing_charge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->port_clearing_charge->caption(), $purchase_a->port_clearing_charge->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_port_clearing_charge");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->port_clearing_charge->errorMessage()) ?>");
		<?php if ($purchase_a_edit->cha_commission->Required) { ?>
			elm = this.getElements("x" + infix + "_cha_commission");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->cha_commission->caption(), $purchase_a->cha_commission->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_cha_commission");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->cha_commission->errorMessage()) ?>");
		<?php if ($purchase_a_edit->cha_agent->Required) { ?>
			elm = this.getElements("x" + infix + "_cha_agent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->cha_agent->caption(), $purchase_a->cha_agent->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->clearance_bank->Required) { ?>
			elm = this.getElements("x" + infix + "_clearance_bank");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->clearance_bank->caption(), $purchase_a->clearance_bank->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->bank_charges->Required) { ?>
			elm = this.getElements("x" + infix + "_bank_charges");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->bank_charges->caption(), $purchase_a->bank_charges->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->importer->Required) { ?>
			elm = this.getElements("x" + infix + "_importer");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->importer->caption(), $purchase_a->importer->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->remarks->caption(), $purchase_a->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->fiba_fibd->Required) { ?>
			elm = this.getElements("x" + infix + "_fiba_fibd");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->fiba_fibd->caption(), $purchase_a->fiba_fibd->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->fibc->Required) { ?>
			elm = this.getElements("x" + infix + "_fibc");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->fibc->caption(), $purchase_a->fibc->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->operator->caption(), $purchase_a->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->datetime->caption(), $purchase_a->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->qc_remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_qc_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->qc_remarks->caption(), $purchase_a->qc_remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_a_edit->qc_status->Required) { ?>
			elm = this.getElements("x" + infix + "_qc_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->qc_status->caption(), $purchase_a->qc_status->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qc_status");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->qc_status->errorMessage()) ?>");
		<?php if ($purchase_a_edit->qc_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_qc_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->qc_operator->caption(), $purchase_a->qc_operator->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qc_operator");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->qc_operator->errorMessage()) ?>");
		<?php if ($purchase_a_edit->qc_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_qc_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->qc_datetime->caption(), $purchase_a->qc_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qc_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->qc_datetime->errorMessage()) ?>");
		<?php if ($purchase_a_edit->rbi_compliance_date->Required) { ?>
			elm = this.getElements("x" + infix + "_rbi_compliance_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->rbi_compliance_date->caption(), $purchase_a->rbi_compliance_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_rbi_compliance_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->rbi_compliance_date->errorMessage()) ?>");
		<?php if ($purchase_a_edit->age->Required) { ?>
			elm = this.getElements("x" + infix + "_age");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_a->age->caption(), $purchase_a->age->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_age");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_a->age->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpurchase_aedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_aedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_aedit.lists["x_supplier"] = <?php echo $purchase_a_edit->supplier->Lookup->toClientList() ?>;
fpurchase_aedit.lists["x_supplier"].options = <?php echo JsonEncode($purchase_a_edit->supplier->lookupOptions()) ?>;
fpurchase_aedit.lists["x_booking_reference"] = <?php echo $purchase_a_edit->booking_reference->Lookup->toClientList() ?>;
fpurchase_aedit.lists["x_booking_reference"].options = <?php echo JsonEncode($purchase_a_edit->booking_reference->lookupOptions()) ?>;
fpurchase_aedit.lists["x_rid"] = <?php echo $purchase_a_edit->rid->Lookup->toClientList() ?>;
fpurchase_aedit.lists["x_rid"].options = <?php echo JsonEncode($purchase_a_edit->rid->lookupOptions()) ?>;
fpurchase_aedit.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_aedit.lists["x_packing_type"] = <?php echo $purchase_a_edit->packing_type->Lookup->toClientList() ?>;
fpurchase_aedit.lists["x_packing_type"].options = <?php echo JsonEncode($purchase_a_edit->packing_type->lookupOptions()) ?>;
fpurchase_aedit.lists["x_shipping_line"] = <?php echo $purchase_a_edit->shipping_line->Lookup->toClientList() ?>;
fpurchase_aedit.lists["x_shipping_line"].options = <?php echo JsonEncode($purchase_a_edit->shipping_line->lookupOptions()) ?>;
fpurchase_aedit.lists["x_godown"] = <?php echo $purchase_a_edit->godown->Lookup->toClientList() ?>;
fpurchase_aedit.lists["x_godown"].options = <?php echo JsonEncode($purchase_a_edit->godown->lookupOptions()) ?>;
fpurchase_aedit.lists["x_duty_paid_by"] = <?php echo $purchase_a_edit->duty_paid_by->Lookup->toClientList() ?>;
fpurchase_aedit.lists["x_duty_paid_by"].options = <?php echo JsonEncode($purchase_a_edit->duty_paid_by->options(FALSE, TRUE)) ?>;
fpurchase_aedit.lists["x_cha_agent"] = <?php echo $purchase_a_edit->cha_agent->Lookup->toClientList() ?>;
fpurchase_aedit.lists["x_cha_agent"].options = <?php echo JsonEncode($purchase_a_edit->cha_agent->lookupOptions()) ?>;
fpurchase_aedit.lists["x_clearance_bank"] = <?php echo $purchase_a_edit->clearance_bank->Lookup->toClientList() ?>;
fpurchase_aedit.lists["x_clearance_bank"].options = <?php echo JsonEncode($purchase_a_edit->clearance_bank->lookupOptions()) ?>;
fpurchase_aedit.lists["x_importer"] = <?php echo $purchase_a_edit->importer->Lookup->toClientList() ?>;
fpurchase_aedit.lists["x_importer"].options = <?php echo JsonEncode($purchase_a_edit->importer->lookupOptions()) ?>;
fpurchase_aedit.lists["x_operator"] = <?php echo $purchase_a_edit->operator->Lookup->toClientList() ?>;
fpurchase_aedit.lists["x_operator"].options = <?php echo JsonEncode($purchase_a_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $purchase_a_edit->showPageHeader(); ?>
<?php
$purchase_a_edit->showMessage();
?>
<form name="fpurchase_aedit" id="fpurchase_aedit" class="<?php echo $purchase_a_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($purchase_a_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $purchase_a_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="purchase_a">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$purchase_a_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($purchase_a->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_purchase_a_id" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->id->caption() ?><?php echo ($purchase_a->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->id->cellAttributes() ?>>
<span id="el_purchase_a_id">
<span<?php echo $purchase_a->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($purchase_a->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="purchase_a" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($purchase_a->id->CurrentValue) ?>">
<?php echo $purchase_a->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->supplier->Visible) { // supplier ?>
	<div id="r_supplier" class="form-group row">
		<label id="elh_purchase_a_supplier" for="x_supplier" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->supplier->caption() ?><?php echo ($purchase_a->supplier->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->supplier->cellAttributes() ?>>
<span id="el_purchase_a_supplier">
<span<?php echo $purchase_a->supplier->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_a->supplier->EditValue)) && $purchase_a->supplier->linkAttributes() <> "") { ?>
<a<?php echo $purchase_a->supplier->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($purchase_a->supplier->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($purchase_a->supplier->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="purchase_a" data-field="x_supplier" name="x_supplier" id="x_supplier" value="<?php echo HtmlEncode($purchase_a->supplier->CurrentValue) ?>">
<?php echo $purchase_a->supplier->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->booking_reference->Visible) { // booking_reference ?>
	<div id="r_booking_reference" class="form-group row">
		<label id="elh_purchase_a_booking_reference" for="x_booking_reference" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->booking_reference->caption() ?><?php echo ($purchase_a->booking_reference->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->booking_reference->cellAttributes() ?>>
<span id="el_purchase_a_booking_reference">
<span<?php echo $purchase_a->booking_reference->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($purchase_a->booking_reference->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="purchase_a" data-field="x_booking_reference" name="x_booking_reference" id="x_booking_reference" value="<?php echo HtmlEncode($purchase_a->booking_reference->CurrentValue) ?>">
<?php echo $purchase_a->booking_reference->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_purchase_a_rid" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->rid->caption() ?><?php echo ($purchase_a->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->rid->cellAttributes() ?>>
<span id="el_purchase_a_rid">
<span<?php echo $purchase_a->rid->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_a->rid->EditValue)) && $purchase_a->rid->linkAttributes() <> "") { ?>
<a<?php echo $purchase_a->rid->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($purchase_a->rid->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($purchase_a->rid->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="purchase_a" data-field="x_rid" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($purchase_a->rid->CurrentValue) ?>">
<?php echo $purchase_a->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label id="elh_purchase_a_lot_no" for="x_lot_no" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->lot_no->caption() ?><?php echo ($purchase_a->lot_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->lot_no->cellAttributes() ?>>
<span id="el_purchase_a_lot_no">
<span<?php echo $purchase_a->lot_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($purchase_a->lot_no->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="purchase_a" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" value="<?php echo HtmlEncode($purchase_a->lot_no->CurrentValue) ?>">
<?php echo $purchase_a->lot_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->gross_weight->Visible) { // gross_weight ?>
	<div id="r_gross_weight" class="form-group row">
		<label id="elh_purchase_a_gross_weight" for="x_gross_weight" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->gross_weight->caption() ?><?php echo ($purchase_a->gross_weight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->gross_weight->cellAttributes() ?>>
<span id="el_purchase_a_gross_weight">
<input type="text" data-table="purchase_a" data-field="x_gross_weight" name="x_gross_weight" id="x_gross_weight" size="30" placeholder="<?php echo HtmlEncode($purchase_a->gross_weight->getPlaceHolder()) ?>" value="<?php echo $purchase_a->gross_weight->EditValue ?>"<?php echo $purchase_a->gross_weight->editAttributes() ?>>
</span>
<?php echo $purchase_a->gross_weight->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->net_weight->Visible) { // net_weight ?>
	<div id="r_net_weight" class="form-group row">
		<label id="elh_purchase_a_net_weight" for="x_net_weight" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->net_weight->caption() ?><?php echo ($purchase_a->net_weight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->net_weight->cellAttributes() ?>>
<span id="el_purchase_a_net_weight">
<input type="text" data-table="purchase_a" data-field="x_net_weight" name="x_net_weight" id="x_net_weight" size="30" placeholder="<?php echo HtmlEncode($purchase_a->net_weight->getPlaceHolder()) ?>" value="<?php echo $purchase_a->net_weight->EditValue ?>"<?php echo $purchase_a->net_weight->editAttributes() ?>>
</span>
<?php echo $purchase_a->net_weight->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label id="elh_purchase_a_packets" for="x_packets" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->packets->caption() ?><?php echo ($purchase_a->packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->packets->cellAttributes() ?>>
<span id="el_purchase_a_packets">
<input type="text" data-table="purchase_a" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($purchase_a->packets->getPlaceHolder()) ?>" value="<?php echo $purchase_a->packets->EditValue ?>"<?php echo $purchase_a->packets->editAttributes() ?>>
</span>
<?php echo $purchase_a->packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_purchase_a_packing_type" for="x_packing_type" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->packing_type->caption() ?><?php echo ($purchase_a->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->packing_type->cellAttributes() ?>>
<span id="el_purchase_a_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_packing_type" data-value-separator="<?php echo $purchase_a->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $purchase_a->packing_type->editAttributes() ?>>
		<?php echo $purchase_a->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "packing_type") && !$purchase_a->packing_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_packing_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $purchase_a->packing_type->caption() ?>" data-title="<?php echo $purchase_a->packing_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_packing_type',url:'packing_typeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $purchase_a->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $purchase_a->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->containers->Visible) { // containers ?>
	<div id="r_containers" class="form-group row">
		<label id="elh_purchase_a_containers" for="x_containers" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->containers->caption() ?><?php echo ($purchase_a->containers->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->containers->cellAttributes() ?>>
<span id="el_purchase_a_containers">
<input type="text" data-table="purchase_a" data-field="x_containers" name="x_containers" id="x_containers" size="30" placeholder="<?php echo HtmlEncode($purchase_a->containers->getPlaceHolder()) ?>" value="<?php echo $purchase_a->containers->EditValue ?>"<?php echo $purchase_a->containers->editAttributes() ?>>
</span>
<?php echo $purchase_a->containers->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->shipping_line->Visible) { // shipping_line ?>
	<div id="r_shipping_line" class="form-group row">
		<label id="elh_purchase_a_shipping_line" for="x_shipping_line" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->shipping_line->caption() ?><?php echo ($purchase_a->shipping_line->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->shipping_line->cellAttributes() ?>>
<span id="el_purchase_a_shipping_line">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_shipping_line" data-value-separator="<?php echo $purchase_a->shipping_line->displayValueSeparatorAttribute() ?>" id="x_shipping_line" name="x_shipping_line"<?php echo $purchase_a->shipping_line->editAttributes() ?>>
		<?php echo $purchase_a->shipping_line->selectOptionListHtml("x_shipping_line") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "shipping_line") && !$purchase_a->shipping_line->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_shipping_line" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $purchase_a->shipping_line->caption() ?>" data-title="<?php echo $purchase_a->shipping_line->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_shipping_line',url:'shipping_lineaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $purchase_a->shipping_line->Lookup->getParamTag("p_x_shipping_line") ?>
</span>
<?php echo $purchase_a->shipping_line->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->port_arrival_date->Visible) { // port_arrival_date ?>
	<div id="r_port_arrival_date" class="form-group row">
		<label id="elh_purchase_a_port_arrival_date" for="x_port_arrival_date" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->port_arrival_date->caption() ?><?php echo ($purchase_a->port_arrival_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->port_arrival_date->cellAttributes() ?>>
<span id="el_purchase_a_port_arrival_date">
<input type="text" data-table="purchase_a" data-field="x_port_arrival_date" name="x_port_arrival_date" id="x_port_arrival_date" placeholder="<?php echo HtmlEncode($purchase_a->port_arrival_date->getPlaceHolder()) ?>" value="<?php echo $purchase_a->port_arrival_date->EditValue ?>"<?php echo $purchase_a->port_arrival_date->editAttributes() ?>>
<?php if (!$purchase_a->port_arrival_date->ReadOnly && !$purchase_a->port_arrival_date->Disabled && !isset($purchase_a->port_arrival_date->EditAttrs["readonly"]) && !isset($purchase_a->port_arrival_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_aedit", "x_port_arrival_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $purchase_a->port_arrival_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->godown_arrival_date->Visible) { // godown_arrival_date ?>
	<div id="r_godown_arrival_date" class="form-group row">
		<label id="elh_purchase_a_godown_arrival_date" for="x_godown_arrival_date" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->godown_arrival_date->caption() ?><?php echo ($purchase_a->godown_arrival_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->godown_arrival_date->cellAttributes() ?>>
<span id="el_purchase_a_godown_arrival_date">
<input type="text" data-table="purchase_a" data-field="x_godown_arrival_date" name="x_godown_arrival_date" id="x_godown_arrival_date" placeholder="<?php echo HtmlEncode($purchase_a->godown_arrival_date->getPlaceHolder()) ?>" value="<?php echo $purchase_a->godown_arrival_date->EditValue ?>"<?php echo $purchase_a->godown_arrival_date->editAttributes() ?>>
<?php if (!$purchase_a->godown_arrival_date->ReadOnly && !$purchase_a->godown_arrival_date->Disabled && !isset($purchase_a->godown_arrival_date->EditAttrs["readonly"]) && !isset($purchase_a->godown_arrival_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_aedit", "x_godown_arrival_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $purchase_a->godown_arrival_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_purchase_a_godown" for="x_godown" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->godown->caption() ?><?php echo ($purchase_a->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->godown->cellAttributes() ?>>
<span id="el_purchase_a_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_godown" data-value-separator="<?php echo $purchase_a->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $purchase_a->godown->editAttributes() ?>>
		<?php echo $purchase_a->godown->selectOptionListHtml("x_godown") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "godown_table") && !$purchase_a->godown->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_godown" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $purchase_a->godown->caption() ?>" data-title="<?php echo $purchase_a->godown->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_godown',url:'godown_tableaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $purchase_a->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $purchase_a->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->rack->Visible) { // rack ?>
	<div id="r_rack" class="form-group row">
		<label id="elh_purchase_a_rack" for="x_rack" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->rack->caption() ?><?php echo ($purchase_a->rack->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->rack->cellAttributes() ?>>
<span id="el_purchase_a_rack">
<input type="text" data-table="purchase_a" data-field="x_rack" name="x_rack" id="x_rack" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($purchase_a->rack->getPlaceHolder()) ?>" value="<?php echo $purchase_a->rack->EditValue ?>"<?php echo $purchase_a->rack->editAttributes() ?>>
</span>
<?php echo $purchase_a->rack->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->invoice_details->Visible) { // invoice_details ?>
	<div id="r_invoice_details" class="form-group row">
		<label id="elh_purchase_a_invoice_details" for="x_invoice_details" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->invoice_details->caption() ?><?php echo ($purchase_a->invoice_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->invoice_details->cellAttributes() ?>>
<span id="el_purchase_a_invoice_details">
<input type="text" data-table="purchase_a" data-field="x_invoice_details" name="x_invoice_details" id="x_invoice_details" placeholder="<?php echo HtmlEncode($purchase_a->invoice_details->getPlaceHolder()) ?>" value="<?php echo $purchase_a->invoice_details->EditValue ?>"<?php echo $purchase_a->invoice_details->editAttributes() ?>>
</span>
<?php echo $purchase_a->invoice_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->invoice_value->Visible) { // invoice_value ?>
	<div id="r_invoice_value" class="form-group row">
		<label id="elh_purchase_a_invoice_value" for="x_invoice_value" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->invoice_value->caption() ?><?php echo ($purchase_a->invoice_value->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->invoice_value->cellAttributes() ?>>
<span id="el_purchase_a_invoice_value">
<input type="text" data-table="purchase_a" data-field="x_invoice_value" name="x_invoice_value" id="x_invoice_value" size="30" placeholder="<?php echo HtmlEncode($purchase_a->invoice_value->getPlaceHolder()) ?>" value="<?php echo $purchase_a->invoice_value->EditValue ?>"<?php echo $purchase_a->invoice_value->editAttributes() ?>>
</span>
<?php echo $purchase_a->invoice_value->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->currency_rate->Visible) { // currency_rate ?>
	<div id="r_currency_rate" class="form-group row">
		<label id="elh_purchase_a_currency_rate" for="x_currency_rate" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->currency_rate->caption() ?><?php echo ($purchase_a->currency_rate->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->currency_rate->cellAttributes() ?>>
<span id="el_purchase_a_currency_rate">
<input type="text" data-table="purchase_a" data-field="x_currency_rate" name="x_currency_rate" id="x_currency_rate" size="30" placeholder="<?php echo HtmlEncode($purchase_a->currency_rate->getPlaceHolder()) ?>" value="<?php echo $purchase_a->currency_rate->EditValue ?>"<?php echo $purchase_a->currency_rate->editAttributes() ?>>
</span>
<?php echo $purchase_a->currency_rate->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->purchase_amount_inr->Visible) { // purchase_amount_inr ?>
	<div id="r_purchase_amount_inr" class="form-group row">
		<label id="elh_purchase_a_purchase_amount_inr" for="x_purchase_amount_inr" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->purchase_amount_inr->caption() ?><?php echo ($purchase_a->purchase_amount_inr->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->purchase_amount_inr->cellAttributes() ?>>
<span id="el_purchase_a_purchase_amount_inr">
<input type="text" data-table="purchase_a" data-field="x_purchase_amount_inr" name="x_purchase_amount_inr" id="x_purchase_amount_inr" size="30" placeholder="<?php echo HtmlEncode($purchase_a->purchase_amount_inr->getPlaceHolder()) ?>" value="<?php echo $purchase_a->purchase_amount_inr->EditValue ?>"<?php echo $purchase_a->purchase_amount_inr->editAttributes() ?>>
</span>
<?php echo $purchase_a->purchase_amount_inr->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->duty_paid_by->Visible) { // duty_paid_by ?>
	<div id="r_duty_paid_by" class="form-group row">
		<label id="elh_purchase_a_duty_paid_by" for="x_duty_paid_by" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->duty_paid_by->caption() ?><?php echo ($purchase_a->duty_paid_by->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->duty_paid_by->cellAttributes() ?>>
<span id="el_purchase_a_duty_paid_by">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_duty_paid_by" data-value-separator="<?php echo $purchase_a->duty_paid_by->displayValueSeparatorAttribute() ?>" id="x_duty_paid_by" name="x_duty_paid_by"<?php echo $purchase_a->duty_paid_by->editAttributes() ?>>
		<?php echo $purchase_a->duty_paid_by->selectOptionListHtml("x_duty_paid_by") ?>
	</select>
</div>
</span>
<?php echo $purchase_a->duty_paid_by->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->custom_duty->Visible) { // custom_duty ?>
	<div id="r_custom_duty" class="form-group row">
		<label id="elh_purchase_a_custom_duty" for="x_custom_duty" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->custom_duty->caption() ?><?php echo ($purchase_a->custom_duty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->custom_duty->cellAttributes() ?>>
<span id="el_purchase_a_custom_duty">
<input type="text" data-table="purchase_a" data-field="x_custom_duty" name="x_custom_duty" id="x_custom_duty" size="30" placeholder="<?php echo HtmlEncode($purchase_a->custom_duty->getPlaceHolder()) ?>" value="<?php echo $purchase_a->custom_duty->EditValue ?>"<?php echo $purchase_a->custom_duty->editAttributes() ?>>
</span>
<?php echo $purchase_a->custom_duty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->transportation_charges->Visible) { // transportation_charges ?>
	<div id="r_transportation_charges" class="form-group row">
		<label id="elh_purchase_a_transportation_charges" for="x_transportation_charges" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->transportation_charges->caption() ?><?php echo ($purchase_a->transportation_charges->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->transportation_charges->cellAttributes() ?>>
<span id="el_purchase_a_transportation_charges">
<input type="text" data-table="purchase_a" data-field="x_transportation_charges" name="x_transportation_charges" id="x_transportation_charges" size="30" placeholder="<?php echo HtmlEncode($purchase_a->transportation_charges->getPlaceHolder()) ?>" value="<?php echo $purchase_a->transportation_charges->EditValue ?>"<?php echo $purchase_a->transportation_charges->editAttributes() ?>>
</span>
<?php echo $purchase_a->transportation_charges->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->port_clearing_charge->Visible) { // port_clearing_charge ?>
	<div id="r_port_clearing_charge" class="form-group row">
		<label id="elh_purchase_a_port_clearing_charge" for="x_port_clearing_charge" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->port_clearing_charge->caption() ?><?php echo ($purchase_a->port_clearing_charge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->port_clearing_charge->cellAttributes() ?>>
<span id="el_purchase_a_port_clearing_charge">
<input type="text" data-table="purchase_a" data-field="x_port_clearing_charge" name="x_port_clearing_charge" id="x_port_clearing_charge" size="30" placeholder="<?php echo HtmlEncode($purchase_a->port_clearing_charge->getPlaceHolder()) ?>" value="<?php echo $purchase_a->port_clearing_charge->EditValue ?>"<?php echo $purchase_a->port_clearing_charge->editAttributes() ?>>
</span>
<?php echo $purchase_a->port_clearing_charge->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->cha_commission->Visible) { // cha_commission ?>
	<div id="r_cha_commission" class="form-group row">
		<label id="elh_purchase_a_cha_commission" for="x_cha_commission" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->cha_commission->caption() ?><?php echo ($purchase_a->cha_commission->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->cha_commission->cellAttributes() ?>>
<span id="el_purchase_a_cha_commission">
<input type="text" data-table="purchase_a" data-field="x_cha_commission" name="x_cha_commission" id="x_cha_commission" size="30" placeholder="<?php echo HtmlEncode($purchase_a->cha_commission->getPlaceHolder()) ?>" value="<?php echo $purchase_a->cha_commission->EditValue ?>"<?php echo $purchase_a->cha_commission->editAttributes() ?>>
</span>
<?php echo $purchase_a->cha_commission->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->cha_agent->Visible) { // cha_agent ?>
	<div id="r_cha_agent" class="form-group row">
		<label id="elh_purchase_a_cha_agent" for="x_cha_agent" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->cha_agent->caption() ?><?php echo ($purchase_a->cha_agent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->cha_agent->cellAttributes() ?>>
<span id="el_purchase_a_cha_agent">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_cha_agent" data-value-separator="<?php echo $purchase_a->cha_agent->displayValueSeparatorAttribute() ?>" id="x_cha_agent" name="x_cha_agent"<?php echo $purchase_a->cha_agent->editAttributes() ?>>
		<?php echo $purchase_a->cha_agent->selectOptionListHtml("x_cha_agent") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "cha_agent") && !$purchase_a->cha_agent->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_cha_agent" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $purchase_a->cha_agent->caption() ?>" data-title="<?php echo $purchase_a->cha_agent->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_cha_agent',url:'cha_agentaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $purchase_a->cha_agent->Lookup->getParamTag("p_x_cha_agent") ?>
</span>
<?php echo $purchase_a->cha_agent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->clearance_bank->Visible) { // clearance_bank ?>
	<div id="r_clearance_bank" class="form-group row">
		<label id="elh_purchase_a_clearance_bank" for="x_clearance_bank" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->clearance_bank->caption() ?><?php echo ($purchase_a->clearance_bank->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->clearance_bank->cellAttributes() ?>>
<span id="el_purchase_a_clearance_bank">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_clearance_bank" data-value-separator="<?php echo $purchase_a->clearance_bank->displayValueSeparatorAttribute() ?>" id="x_clearance_bank" name="x_clearance_bank"<?php echo $purchase_a->clearance_bank->editAttributes() ?>>
		<?php echo $purchase_a->clearance_bank->selectOptionListHtml("x_clearance_bank") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "bank") && !$purchase_a->clearance_bank->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_clearance_bank" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $purchase_a->clearance_bank->caption() ?>" data-title="<?php echo $purchase_a->clearance_bank->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_clearance_bank',url:'bankaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $purchase_a->clearance_bank->Lookup->getParamTag("p_x_clearance_bank") ?>
</span>
<?php echo $purchase_a->clearance_bank->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->bank_charges->Visible) { // bank_charges ?>
	<div id="r_bank_charges" class="form-group row">
		<label id="elh_purchase_a_bank_charges" for="x_bank_charges" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->bank_charges->caption() ?><?php echo ($purchase_a->bank_charges->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->bank_charges->cellAttributes() ?>>
<span id="el_purchase_a_bank_charges">
<input type="text" data-table="purchase_a" data-field="x_bank_charges" name="x_bank_charges" id="x_bank_charges" size="30" placeholder="<?php echo HtmlEncode($purchase_a->bank_charges->getPlaceHolder()) ?>" value="<?php echo $purchase_a->bank_charges->EditValue ?>"<?php echo $purchase_a->bank_charges->editAttributes() ?>>
</span>
<?php echo $purchase_a->bank_charges->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->importer->Visible) { // importer ?>
	<div id="r_importer" class="form-group row">
		<label id="elh_purchase_a_importer" for="x_importer" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->importer->caption() ?><?php echo ($purchase_a->importer->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->importer->cellAttributes() ?>>
<span id="el_purchase_a_importer">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_importer" data-value-separator="<?php echo $purchase_a->importer->displayValueSeparatorAttribute() ?>" id="x_importer" name="x_importer"<?php echo $purchase_a->importer->editAttributes() ?>>
		<?php echo $purchase_a->importer->selectOptionListHtml("x_importer") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "importer") && !$purchase_a->importer->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_importer" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $purchase_a->importer->caption() ?>" data-title="<?php echo $purchase_a->importer->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_importer',url:'importeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $purchase_a->importer->Lookup->getParamTag("p_x_importer") ?>
</span>
<?php echo $purchase_a->importer->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_purchase_a_remarks" for="x_remarks" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->remarks->caption() ?><?php echo ($purchase_a->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->remarks->cellAttributes() ?>>
<span id="el_purchase_a_remarks">
<textarea data-table="purchase_a" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?php echo HtmlEncode($purchase_a->remarks->getPlaceHolder()) ?>"<?php echo $purchase_a->remarks->editAttributes() ?>><?php echo $purchase_a->remarks->EditValue ?></textarea>
</span>
<?php echo $purchase_a->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->fiba_fibd->Visible) { // fiba_fibd ?>
	<div id="r_fiba_fibd" class="form-group row">
		<label id="elh_purchase_a_fiba_fibd" for="x_fiba_fibd" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->fiba_fibd->caption() ?><?php echo ($purchase_a->fiba_fibd->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->fiba_fibd->cellAttributes() ?>>
<span id="el_purchase_a_fiba_fibd">
<input type="text" data-table="purchase_a" data-field="x_fiba_fibd" name="x_fiba_fibd" id="x_fiba_fibd" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($purchase_a->fiba_fibd->getPlaceHolder()) ?>" value="<?php echo $purchase_a->fiba_fibd->EditValue ?>"<?php echo $purchase_a->fiba_fibd->editAttributes() ?>>
</span>
<?php echo $purchase_a->fiba_fibd->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->fibc->Visible) { // fibc ?>
	<div id="r_fibc" class="form-group row">
		<label id="elh_purchase_a_fibc" for="x_fibc" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->fibc->caption() ?><?php echo ($purchase_a->fibc->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->fibc->cellAttributes() ?>>
<span id="el_purchase_a_fibc">
<input type="text" data-table="purchase_a" data-field="x_fibc" name="x_fibc" id="x_fibc" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($purchase_a->fibc->getPlaceHolder()) ?>" value="<?php echo $purchase_a->fibc->EditValue ?>"<?php echo $purchase_a->fibc->editAttributes() ?>>
</span>
<?php echo $purchase_a->fibc->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->qc_remarks->Visible) { // qc_remarks ?>
	<div id="r_qc_remarks" class="form-group row">
		<label id="elh_purchase_a_qc_remarks" for="x_qc_remarks" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->qc_remarks->caption() ?><?php echo ($purchase_a->qc_remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->qc_remarks->cellAttributes() ?>>
<span id="el_purchase_a_qc_remarks">
<textarea data-table="purchase_a" data-field="x_qc_remarks" name="x_qc_remarks" id="x_qc_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($purchase_a->qc_remarks->getPlaceHolder()) ?>"<?php echo $purchase_a->qc_remarks->editAttributes() ?>><?php echo $purchase_a->qc_remarks->EditValue ?></textarea>
</span>
<?php echo $purchase_a->qc_remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->qc_status->Visible) { // qc_status ?>
	<div id="r_qc_status" class="form-group row">
		<label id="elh_purchase_a_qc_status" for="x_qc_status" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->qc_status->caption() ?><?php echo ($purchase_a->qc_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->qc_status->cellAttributes() ?>>
<span id="el_purchase_a_qc_status">
<input type="text" data-table="purchase_a" data-field="x_qc_status" name="x_qc_status" id="x_qc_status" size="30" placeholder="<?php echo HtmlEncode($purchase_a->qc_status->getPlaceHolder()) ?>" value="<?php echo $purchase_a->qc_status->EditValue ?>"<?php echo $purchase_a->qc_status->editAttributes() ?>>
</span>
<?php echo $purchase_a->qc_status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->qc_operator->Visible) { // qc_operator ?>
	<div id="r_qc_operator" class="form-group row">
		<label id="elh_purchase_a_qc_operator" for="x_qc_operator" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->qc_operator->caption() ?><?php echo ($purchase_a->qc_operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->qc_operator->cellAttributes() ?>>
<span id="el_purchase_a_qc_operator">
<input type="text" data-table="purchase_a" data-field="x_qc_operator" name="x_qc_operator" id="x_qc_operator" size="30" placeholder="<?php echo HtmlEncode($purchase_a->qc_operator->getPlaceHolder()) ?>" value="<?php echo $purchase_a->qc_operator->EditValue ?>"<?php echo $purchase_a->qc_operator->editAttributes() ?>>
</span>
<?php echo $purchase_a->qc_operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->qc_datetime->Visible) { // qc_datetime ?>
	<div id="r_qc_datetime" class="form-group row">
		<label id="elh_purchase_a_qc_datetime" for="x_qc_datetime" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->qc_datetime->caption() ?><?php echo ($purchase_a->qc_datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->qc_datetime->cellAttributes() ?>>
<span id="el_purchase_a_qc_datetime">
<input type="text" data-table="purchase_a" data-field="x_qc_datetime" name="x_qc_datetime" id="x_qc_datetime" placeholder="<?php echo HtmlEncode($purchase_a->qc_datetime->getPlaceHolder()) ?>" value="<?php echo $purchase_a->qc_datetime->EditValue ?>"<?php echo $purchase_a->qc_datetime->editAttributes() ?>>
<?php if (!$purchase_a->qc_datetime->ReadOnly && !$purchase_a->qc_datetime->Disabled && !isset($purchase_a->qc_datetime->EditAttrs["readonly"]) && !isset($purchase_a->qc_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_aedit", "x_qc_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $purchase_a->qc_datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->rbi_compliance_date->Visible) { // rbi_compliance_date ?>
	<div id="r_rbi_compliance_date" class="form-group row">
		<label id="elh_purchase_a_rbi_compliance_date" for="x_rbi_compliance_date" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->rbi_compliance_date->caption() ?><?php echo ($purchase_a->rbi_compliance_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->rbi_compliance_date->cellAttributes() ?>>
<span id="el_purchase_a_rbi_compliance_date">
<input type="text" data-table="purchase_a" data-field="x_rbi_compliance_date" name="x_rbi_compliance_date" id="x_rbi_compliance_date" placeholder="<?php echo HtmlEncode($purchase_a->rbi_compliance_date->getPlaceHolder()) ?>" value="<?php echo $purchase_a->rbi_compliance_date->EditValue ?>"<?php echo $purchase_a->rbi_compliance_date->editAttributes() ?>>
<?php if (!$purchase_a->rbi_compliance_date->ReadOnly && !$purchase_a->rbi_compliance_date->Disabled && !isset($purchase_a->rbi_compliance_date->EditAttrs["readonly"]) && !isset($purchase_a->rbi_compliance_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_aedit", "x_rbi_compliance_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $purchase_a->rbi_compliance_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->age->Visible) { // age ?>
	<div id="r_age" class="form-group row">
		<label id="elh_purchase_a_age" for="x_age" class="<?php echo $purchase_a_edit->LeftColumnClass ?>"><?php echo $purchase_a->age->caption() ?><?php echo ($purchase_a->age->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_a_edit->RightColumnClass ?>"><div<?php echo $purchase_a->age->cellAttributes() ?>>
<span id="el_purchase_a_age">
<input type="text" data-table="purchase_a" data-field="x_age" name="x_age" id="x_age" size="30" placeholder="<?php echo HtmlEncode($purchase_a->age->getPlaceHolder()) ?>" value="<?php echo $purchase_a->age->EditValue ?>"<?php echo $purchase_a->age->editAttributes() ?>>
</span>
<?php echo $purchase_a->age->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$purchase_a_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $purchase_a_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $purchase_a_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$purchase_a_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$purchase_a_edit->terminate();
?>