<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$purchase_a_list = new purchase_a_list();

// Run the page
$purchase_a_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$purchase_a_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$purchase_a->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpurchase_alist = currentForm = new ew.Form("fpurchase_alist", "list");
fpurchase_alist.formKeyCountName = '<?php echo $purchase_a_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpurchase_alist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_alist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_alist.lists["x_rid"] = <?php echo $purchase_a_list->rid->Lookup->toClientList() ?>;
fpurchase_alist.lists["x_rid"].options = <?php echo JsonEncode($purchase_a_list->rid->lookupOptions()) ?>;
fpurchase_alist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_alist.lists["x_packing_type"] = <?php echo $purchase_a_list->packing_type->Lookup->toClientList() ?>;
fpurchase_alist.lists["x_packing_type"].options = <?php echo JsonEncode($purchase_a_list->packing_type->lookupOptions()) ?>;
fpurchase_alist.lists["x_godown"] = <?php echo $purchase_a_list->godown->Lookup->toClientList() ?>;
fpurchase_alist.lists["x_godown"].options = <?php echo JsonEncode($purchase_a_list->godown->lookupOptions()) ?>;
fpurchase_alist.lists["x_duty_paid_by"] = <?php echo $purchase_a_list->duty_paid_by->Lookup->toClientList() ?>;
fpurchase_alist.lists["x_duty_paid_by"].options = <?php echo JsonEncode($purchase_a_list->duty_paid_by->options(FALSE, TRUE)) ?>;
fpurchase_alist.lists["x_cha_agent"] = <?php echo $purchase_a_list->cha_agent->Lookup->toClientList() ?>;
fpurchase_alist.lists["x_cha_agent"].options = <?php echo JsonEncode($purchase_a_list->cha_agent->lookupOptions()) ?>;
fpurchase_alist.lists["x_importer"] = <?php echo $purchase_a_list->importer->Lookup->toClientList() ?>;
fpurchase_alist.lists["x_importer"].options = <?php echo JsonEncode($purchase_a_list->importer->lookupOptions()) ?>;
fpurchase_alist.lists["x_operator"] = <?php echo $purchase_a_list->operator->Lookup->toClientList() ?>;
fpurchase_alist.lists["x_operator"].options = <?php echo JsonEncode($purchase_a_list->operator->lookupOptions()) ?>;

// Form object for search
var fpurchase_alistsrch = currentSearchForm = new ew.Form("fpurchase_alistsrch");

// Filters
fpurchase_alistsrch.filterList = <?php echo $purchase_a_list->getFilterList() ?>;

// Init search panel as collapsed
fpurchase_alistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$purchase_a->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($purchase_a_list->TotalRecs > 0 && $purchase_a_list->ExportOptions->visible()) { ?>
<?php $purchase_a_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($purchase_a_list->ImportOptions->visible()) { ?>
<?php $purchase_a_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($purchase_a_list->SearchOptions->visible()) { ?>
<?php $purchase_a_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($purchase_a_list->FilterOptions->visible()) { ?>
<?php $purchase_a_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$purchase_a_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$purchase_a->isExport() && !$purchase_a->CurrentAction) { ?>
<form name="fpurchase_alistsrch" id="fpurchase_alistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($purchase_a_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpurchase_alistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="purchase_a">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($purchase_a_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($purchase_a_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $purchase_a_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($purchase_a_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($purchase_a_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($purchase_a_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($purchase_a_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $purchase_a_list->showPageHeader(); ?>
<?php
$purchase_a_list->showMessage();
?>
<?php if ($purchase_a_list->TotalRecs > 0 || $purchase_a->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($purchase_a_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> purchase_a">
<?php if (!$purchase_a->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$purchase_a->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($purchase_a_list->Pager)) $purchase_a_list->Pager = new PrevNextPager($purchase_a_list->StartRec, $purchase_a_list->DisplayRecs, $purchase_a_list->TotalRecs, $purchase_a_list->AutoHidePager) ?>
<?php if ($purchase_a_list->Pager->RecordCount > 0 && $purchase_a_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($purchase_a_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $purchase_a_list->pageUrl() ?>start=<?php echo $purchase_a_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($purchase_a_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $purchase_a_list->pageUrl() ?>start=<?php echo $purchase_a_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $purchase_a_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($purchase_a_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $purchase_a_list->pageUrl() ?>start=<?php echo $purchase_a_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($purchase_a_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $purchase_a_list->pageUrl() ?>start=<?php echo $purchase_a_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $purchase_a_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($purchase_a_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $purchase_a_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $purchase_a_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $purchase_a_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($purchase_a_list->TotalRecs > 0 && (!$purchase_a_list->AutoHidePageSizeSelector || $purchase_a_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="purchase_a">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($purchase_a_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($purchase_a_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($purchase_a_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($purchase_a_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($purchase_a_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($purchase_a->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $purchase_a_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpurchase_alist" id="fpurchase_alist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($purchase_a_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $purchase_a_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="purchase_a">
<div id="gmp_purchase_a" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($purchase_a_list->TotalRecs > 0 || $purchase_a->isGridEdit()) { ?>
<table id="tbl_purchase_alist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$purchase_a_list->RowType = ROWTYPE_HEADER;

// Render list options
$purchase_a_list->renderListOptions();

// Render list options (header, left)
$purchase_a_list->ListOptions->render("header", "left");
?>
<?php if ($purchase_a->id->Visible) { // id ?>
	<?php if ($purchase_a->sortUrl($purchase_a->id) == "") { ?>
		<th data-name="id" class="<?php echo $purchase_a->id->headerCellClass() ?>"><div id="elh_purchase_a_id" class="purchase_a_id"><div class="ew-table-header-caption"><?php echo $purchase_a->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $purchase_a->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->id) ?>',2);"><div id="elh_purchase_a_id" class="purchase_a_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->rid->Visible) { // rid ?>
	<?php if ($purchase_a->sortUrl($purchase_a->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $purchase_a->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_purchase_a_rid" class="purchase_a_rid"><div class="ew-table-header-caption"><?php echo $purchase_a->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $purchase_a->rid->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->rid) ?>',2);"><div id="elh_purchase_a_rid" class="purchase_a_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->lot_no->Visible) { // lot_no ?>
	<?php if ($purchase_a->sortUrl($purchase_a->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $purchase_a->lot_no->headerCellClass() ?>"><div id="elh_purchase_a_lot_no" class="purchase_a_lot_no"><div class="ew-table-header-caption"><?php echo $purchase_a->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $purchase_a->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->lot_no) ?>',2);"><div id="elh_purchase_a_lot_no" class="purchase_a_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->lot_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->net_weight->Visible) { // net_weight ?>
	<?php if ($purchase_a->sortUrl($purchase_a->net_weight) == "") { ?>
		<th data-name="net_weight" class="<?php echo $purchase_a->net_weight->headerCellClass() ?>"><div id="elh_purchase_a_net_weight" class="purchase_a_net_weight"><div class="ew-table-header-caption"><?php echo $purchase_a->net_weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="net_weight" class="<?php echo $purchase_a->net_weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->net_weight) ?>',2);"><div id="elh_purchase_a_net_weight" class="purchase_a_net_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->net_weight->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->net_weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->net_weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->packing_type->Visible) { // packing_type ?>
	<?php if ($purchase_a->sortUrl($purchase_a->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $purchase_a->packing_type->headerCellClass() ?>"><div id="elh_purchase_a_packing_type" class="purchase_a_packing_type"><div class="ew-table-header-caption"><?php echo $purchase_a->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $purchase_a->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->packing_type) ?>',2);"><div id="elh_purchase_a_packing_type" class="purchase_a_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->godown_arrival_date->Visible) { // godown_arrival_date ?>
	<?php if ($purchase_a->sortUrl($purchase_a->godown_arrival_date) == "") { ?>
		<th data-name="godown_arrival_date" class="<?php echo $purchase_a->godown_arrival_date->headerCellClass() ?>"><div id="elh_purchase_a_godown_arrival_date" class="purchase_a_godown_arrival_date"><div class="ew-table-header-caption"><?php echo $purchase_a->godown_arrival_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown_arrival_date" class="<?php echo $purchase_a->godown_arrival_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->godown_arrival_date) ?>',2);"><div id="elh_purchase_a_godown_arrival_date" class="purchase_a_godown_arrival_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->godown_arrival_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->godown_arrival_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->godown_arrival_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->godown->Visible) { // godown ?>
	<?php if ($purchase_a->sortUrl($purchase_a->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $purchase_a->godown->headerCellClass() ?>"><div id="elh_purchase_a_godown" class="purchase_a_godown"><div class="ew-table-header-caption"><?php echo $purchase_a->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $purchase_a->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->godown) ?>',2);"><div id="elh_purchase_a_godown" class="purchase_a_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->rack->Visible) { // rack ?>
	<?php if ($purchase_a->sortUrl($purchase_a->rack) == "") { ?>
		<th data-name="rack" class="<?php echo $purchase_a->rack->headerCellClass() ?>"><div id="elh_purchase_a_rack" class="purchase_a_rack"><div class="ew-table-header-caption"><?php echo $purchase_a->rack->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rack" class="<?php echo $purchase_a->rack->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->rack) ?>',2);"><div id="elh_purchase_a_rack" class="purchase_a_rack">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->rack->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->rack->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->rack->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->invoice_details->Visible) { // invoice_details ?>
	<?php if ($purchase_a->sortUrl($purchase_a->invoice_details) == "") { ?>
		<th data-name="invoice_details" class="<?php echo $purchase_a->invoice_details->headerCellClass() ?>"><div id="elh_purchase_a_invoice_details" class="purchase_a_invoice_details"><div class="ew-table-header-caption"><?php echo $purchase_a->invoice_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="invoice_details" class="<?php echo $purchase_a->invoice_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->invoice_details) ?>',2);"><div id="elh_purchase_a_invoice_details" class="purchase_a_invoice_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->invoice_details->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->invoice_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->invoice_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->invoice_value->Visible) { // invoice_value ?>
	<?php if ($purchase_a->sortUrl($purchase_a->invoice_value) == "") { ?>
		<th data-name="invoice_value" class="<?php echo $purchase_a->invoice_value->headerCellClass() ?>"><div id="elh_purchase_a_invoice_value" class="purchase_a_invoice_value"><div class="ew-table-header-caption"><?php echo $purchase_a->invoice_value->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="invoice_value" class="<?php echo $purchase_a->invoice_value->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->invoice_value) ?>',2);"><div id="elh_purchase_a_invoice_value" class="purchase_a_invoice_value">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->invoice_value->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->invoice_value->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->invoice_value->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->currency_rate->Visible) { // currency_rate ?>
	<?php if ($purchase_a->sortUrl($purchase_a->currency_rate) == "") { ?>
		<th data-name="currency_rate" class="<?php echo $purchase_a->currency_rate->headerCellClass() ?>"><div id="elh_purchase_a_currency_rate" class="purchase_a_currency_rate"><div class="ew-table-header-caption"><?php echo $purchase_a->currency_rate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency_rate" class="<?php echo $purchase_a->currency_rate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->currency_rate) ?>',2);"><div id="elh_purchase_a_currency_rate" class="purchase_a_currency_rate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->currency_rate->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->currency_rate->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->currency_rate->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->purchase_amount_inr->Visible) { // purchase_amount_inr ?>
	<?php if ($purchase_a->sortUrl($purchase_a->purchase_amount_inr) == "") { ?>
		<th data-name="purchase_amount_inr" class="<?php echo $purchase_a->purchase_amount_inr->headerCellClass() ?>"><div id="elh_purchase_a_purchase_amount_inr" class="purchase_a_purchase_amount_inr"><div class="ew-table-header-caption"><?php echo $purchase_a->purchase_amount_inr->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="purchase_amount_inr" class="<?php echo $purchase_a->purchase_amount_inr->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->purchase_amount_inr) ?>',2);"><div id="elh_purchase_a_purchase_amount_inr" class="purchase_a_purchase_amount_inr">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->purchase_amount_inr->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->purchase_amount_inr->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->purchase_amount_inr->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->duty_paid_by->Visible) { // duty_paid_by ?>
	<?php if ($purchase_a->sortUrl($purchase_a->duty_paid_by) == "") { ?>
		<th data-name="duty_paid_by" class="<?php echo $purchase_a->duty_paid_by->headerCellClass() ?>"><div id="elh_purchase_a_duty_paid_by" class="purchase_a_duty_paid_by"><div class="ew-table-header-caption"><?php echo $purchase_a->duty_paid_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="duty_paid_by" class="<?php echo $purchase_a->duty_paid_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->duty_paid_by) ?>',2);"><div id="elh_purchase_a_duty_paid_by" class="purchase_a_duty_paid_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->duty_paid_by->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->duty_paid_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->duty_paid_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->custom_duty->Visible) { // custom_duty ?>
	<?php if ($purchase_a->sortUrl($purchase_a->custom_duty) == "") { ?>
		<th data-name="custom_duty" class="<?php echo $purchase_a->custom_duty->headerCellClass() ?>"><div id="elh_purchase_a_custom_duty" class="purchase_a_custom_duty"><div class="ew-table-header-caption"><?php echo $purchase_a->custom_duty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="custom_duty" class="<?php echo $purchase_a->custom_duty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->custom_duty) ?>',2);"><div id="elh_purchase_a_custom_duty" class="purchase_a_custom_duty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->custom_duty->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->custom_duty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->custom_duty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->port_clearing_charge->Visible) { // port_clearing_charge ?>
	<?php if ($purchase_a->sortUrl($purchase_a->port_clearing_charge) == "") { ?>
		<th data-name="port_clearing_charge" class="<?php echo $purchase_a->port_clearing_charge->headerCellClass() ?>"><div id="elh_purchase_a_port_clearing_charge" class="purchase_a_port_clearing_charge"><div class="ew-table-header-caption"><?php echo $purchase_a->port_clearing_charge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="port_clearing_charge" class="<?php echo $purchase_a->port_clearing_charge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->port_clearing_charge) ?>',2);"><div id="elh_purchase_a_port_clearing_charge" class="purchase_a_port_clearing_charge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->port_clearing_charge->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->port_clearing_charge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->port_clearing_charge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->cha_commission->Visible) { // cha_commission ?>
	<?php if ($purchase_a->sortUrl($purchase_a->cha_commission) == "") { ?>
		<th data-name="cha_commission" class="<?php echo $purchase_a->cha_commission->headerCellClass() ?>"><div id="elh_purchase_a_cha_commission" class="purchase_a_cha_commission"><div class="ew-table-header-caption"><?php echo $purchase_a->cha_commission->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cha_commission" class="<?php echo $purchase_a->cha_commission->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->cha_commission) ?>',2);"><div id="elh_purchase_a_cha_commission" class="purchase_a_cha_commission">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->cha_commission->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->cha_commission->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->cha_commission->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->cha_agent->Visible) { // cha_agent ?>
	<?php if ($purchase_a->sortUrl($purchase_a->cha_agent) == "") { ?>
		<th data-name="cha_agent" class="<?php echo $purchase_a->cha_agent->headerCellClass() ?>"><div id="elh_purchase_a_cha_agent" class="purchase_a_cha_agent"><div class="ew-table-header-caption"><?php echo $purchase_a->cha_agent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cha_agent" class="<?php echo $purchase_a->cha_agent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->cha_agent) ?>',2);"><div id="elh_purchase_a_cha_agent" class="purchase_a_cha_agent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->cha_agent->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->cha_agent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->cha_agent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->bank_charges->Visible) { // bank_charges ?>
	<?php if ($purchase_a->sortUrl($purchase_a->bank_charges) == "") { ?>
		<th data-name="bank_charges" class="<?php echo $purchase_a->bank_charges->headerCellClass() ?>"><div id="elh_purchase_a_bank_charges" class="purchase_a_bank_charges"><div class="ew-table-header-caption"><?php echo $purchase_a->bank_charges->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bank_charges" class="<?php echo $purchase_a->bank_charges->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->bank_charges) ?>',2);"><div id="elh_purchase_a_bank_charges" class="purchase_a_bank_charges">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->bank_charges->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->bank_charges->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->bank_charges->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->importer->Visible) { // importer ?>
	<?php if ($purchase_a->sortUrl($purchase_a->importer) == "") { ?>
		<th data-name="importer" class="<?php echo $purchase_a->importer->headerCellClass() ?>"><div id="elh_purchase_a_importer" class="purchase_a_importer"><div class="ew-table-header-caption"><?php echo $purchase_a->importer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="importer" class="<?php echo $purchase_a->importer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->importer) ?>',2);"><div id="elh_purchase_a_importer" class="purchase_a_importer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->importer->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->importer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->importer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->remarks->Visible) { // remarks ?>
	<?php if ($purchase_a->sortUrl($purchase_a->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $purchase_a->remarks->headerCellClass() ?>"><div id="elh_purchase_a_remarks" class="purchase_a_remarks"><div class="ew-table-header-caption"><?php echo $purchase_a->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $purchase_a->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->remarks) ?>',2);"><div id="elh_purchase_a_remarks" class="purchase_a_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->fiba_fibd->Visible) { // fiba_fibd ?>
	<?php if ($purchase_a->sortUrl($purchase_a->fiba_fibd) == "") { ?>
		<th data-name="fiba_fibd" class="<?php echo $purchase_a->fiba_fibd->headerCellClass() ?>"><div id="elh_purchase_a_fiba_fibd" class="purchase_a_fiba_fibd"><div class="ew-table-header-caption"><?php echo $purchase_a->fiba_fibd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fiba_fibd" class="<?php echo $purchase_a->fiba_fibd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->fiba_fibd) ?>',2);"><div id="elh_purchase_a_fiba_fibd" class="purchase_a_fiba_fibd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->fiba_fibd->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->fiba_fibd->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->fiba_fibd->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->fibc->Visible) { // fibc ?>
	<?php if ($purchase_a->sortUrl($purchase_a->fibc) == "") { ?>
		<th data-name="fibc" class="<?php echo $purchase_a->fibc->headerCellClass() ?>"><div id="elh_purchase_a_fibc" class="purchase_a_fibc"><div class="ew-table-header-caption"><?php echo $purchase_a->fibc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fibc" class="<?php echo $purchase_a->fibc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->fibc) ?>',2);"><div id="elh_purchase_a_fibc" class="purchase_a_fibc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->fibc->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->fibc->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->fibc->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->operator->Visible) { // operator ?>
	<?php if ($purchase_a->sortUrl($purchase_a->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $purchase_a->operator->headerCellClass() ?>"><div id="elh_purchase_a_operator" class="purchase_a_operator"><div class="ew-table-header-caption"><?php echo $purchase_a->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $purchase_a->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->operator) ?>',2);"><div id="elh_purchase_a_operator" class="purchase_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->datetime->Visible) { // datetime ?>
	<?php if ($purchase_a->sortUrl($purchase_a->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $purchase_a->datetime->headerCellClass() ?>"><div id="elh_purchase_a_datetime" class="purchase_a_datetime"><div class="ew-table-header-caption"><?php echo $purchase_a->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $purchase_a->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->datetime) ?>',2);"><div id="elh_purchase_a_datetime" class="purchase_a_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->qc_status->Visible) { // qc_status ?>
	<?php if ($purchase_a->sortUrl($purchase_a->qc_status) == "") { ?>
		<th data-name="qc_status" class="<?php echo $purchase_a->qc_status->headerCellClass() ?>"><div id="elh_purchase_a_qc_status" class="purchase_a_qc_status"><div class="ew-table-header-caption"><?php echo $purchase_a->qc_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qc_status" class="<?php echo $purchase_a->qc_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->qc_status) ?>',2);"><div id="elh_purchase_a_qc_status" class="purchase_a_qc_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->qc_status->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->qc_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->qc_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->qc_operator->Visible) { // qc_operator ?>
	<?php if ($purchase_a->sortUrl($purchase_a->qc_operator) == "") { ?>
		<th data-name="qc_operator" class="<?php echo $purchase_a->qc_operator->headerCellClass() ?>"><div id="elh_purchase_a_qc_operator" class="purchase_a_qc_operator"><div class="ew-table-header-caption"><?php echo $purchase_a->qc_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qc_operator" class="<?php echo $purchase_a->qc_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->qc_operator) ?>',2);"><div id="elh_purchase_a_qc_operator" class="purchase_a_qc_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->qc_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->qc_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->qc_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->qc_datetime->Visible) { // qc_datetime ?>
	<?php if ($purchase_a->sortUrl($purchase_a->qc_datetime) == "") { ?>
		<th data-name="qc_datetime" class="<?php echo $purchase_a->qc_datetime->headerCellClass() ?>"><div id="elh_purchase_a_qc_datetime" class="purchase_a_qc_datetime"><div class="ew-table-header-caption"><?php echo $purchase_a->qc_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qc_datetime" class="<?php echo $purchase_a->qc_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->qc_datetime) ?>',2);"><div id="elh_purchase_a_qc_datetime" class="purchase_a_qc_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->qc_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->qc_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->qc_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->rbi_compliance_date->Visible) { // rbi_compliance_date ?>
	<?php if ($purchase_a->sortUrl($purchase_a->rbi_compliance_date) == "") { ?>
		<th data-name="rbi_compliance_date" class="<?php echo $purchase_a->rbi_compliance_date->headerCellClass() ?>"><div id="elh_purchase_a_rbi_compliance_date" class="purchase_a_rbi_compliance_date"><div class="ew-table-header-caption"><?php echo $purchase_a->rbi_compliance_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rbi_compliance_date" class="<?php echo $purchase_a->rbi_compliance_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->rbi_compliance_date) ?>',2);"><div id="elh_purchase_a_rbi_compliance_date" class="purchase_a_rbi_compliance_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->rbi_compliance_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->rbi_compliance_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->rbi_compliance_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_a->age->Visible) { // age ?>
	<?php if ($purchase_a->sortUrl($purchase_a->age) == "") { ?>
		<th data-name="age" class="<?php echo $purchase_a->age->headerCellClass() ?>"><div id="elh_purchase_a_age" class="purchase_a_age"><div class="ew-table-header-caption"><?php echo $purchase_a->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $purchase_a->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_a->SortUrl($purchase_a->age) ?>',2);"><div id="elh_purchase_a_age" class="purchase_a_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_a->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_a->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_a->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$purchase_a_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($purchase_a->ExportAll && $purchase_a->isExport()) {
	$purchase_a_list->StopRec = $purchase_a_list->TotalRecs;
} else {

	// Set the last record to display
	if ($purchase_a_list->TotalRecs > $purchase_a_list->StartRec + $purchase_a_list->DisplayRecs - 1)
		$purchase_a_list->StopRec = $purchase_a_list->StartRec + $purchase_a_list->DisplayRecs - 1;
	else
		$purchase_a_list->StopRec = $purchase_a_list->TotalRecs;
}
$purchase_a_list->RecCnt = $purchase_a_list->StartRec - 1;
if ($purchase_a_list->Recordset && !$purchase_a_list->Recordset->EOF) {
	$purchase_a_list->Recordset->moveFirst();
	$selectLimit = $purchase_a_list->UseSelectLimit;
	if (!$selectLimit && $purchase_a_list->StartRec > 1)
		$purchase_a_list->Recordset->move($purchase_a_list->StartRec - 1);
} elseif (!$purchase_a->AllowAddDeleteRow && $purchase_a_list->StopRec == 0) {
	$purchase_a_list->StopRec = $purchase_a->GridAddRowCount;
}

// Initialize aggregate
$purchase_a->RowType = ROWTYPE_AGGREGATEINIT;
$purchase_a->resetAttributes();
$purchase_a_list->renderRow();
while ($purchase_a_list->RecCnt < $purchase_a_list->StopRec) {
	$purchase_a_list->RecCnt++;
	if ($purchase_a_list->RecCnt >= $purchase_a_list->StartRec) {
		$purchase_a_list->RowCnt++;

		// Set up key count
		$purchase_a_list->KeyCount = $purchase_a_list->RowIndex;

		// Init row class and style
		$purchase_a->resetAttributes();
		$purchase_a->CssClass = "";
		if ($purchase_a->isGridAdd()) {
		} else {
			$purchase_a_list->loadRowValues($purchase_a_list->Recordset); // Load row values
		}
		$purchase_a->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$purchase_a->RowAttrs = array_merge($purchase_a->RowAttrs, array('data-rowindex'=>$purchase_a_list->RowCnt, 'id'=>'r' . $purchase_a_list->RowCnt . '_purchase_a', 'data-rowtype'=>$purchase_a->RowType));

		// Render row
		$purchase_a_list->renderRow();

		// Render list options
		$purchase_a_list->renderListOptions();
?>
	<tr<?php echo $purchase_a->rowAttributes() ?>>
<?php

// Render list options (body, left)
$purchase_a_list->ListOptions->render("body", "left", $purchase_a_list->RowCnt);
?>
	<?php if ($purchase_a->id->Visible) { // id ?>
		<td data-name="id"<?php echo $purchase_a->id->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_id" class="purchase_a_id">
<span<?php echo $purchase_a->id->viewAttributes() ?>>
<?php echo $purchase_a->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $purchase_a->rid->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_rid" class="purchase_a_rid">
<span<?php echo $purchase_a->rid->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_a->rid->getViewValue())) && $purchase_a->rid->linkAttributes() <> "") { ?>
<a<?php echo $purchase_a->rid->linkAttributes() ?>><?php echo $purchase_a->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_a->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $purchase_a->lot_no->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_lot_no" class="purchase_a_lot_no">
<span<?php echo $purchase_a->lot_no->viewAttributes() ?>>
<?php echo $purchase_a->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->net_weight->Visible) { // net_weight ?>
		<td data-name="net_weight"<?php echo $purchase_a->net_weight->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_net_weight" class="purchase_a_net_weight">
<span<?php echo $purchase_a->net_weight->viewAttributes() ?>>
<?php echo $purchase_a->net_weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $purchase_a->packing_type->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_packing_type" class="purchase_a_packing_type">
<span<?php echo $purchase_a->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_a->packing_type->getViewValue())) && $purchase_a->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $purchase_a->packing_type->linkAttributes() ?>><?php echo $purchase_a->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_a->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->godown_arrival_date->Visible) { // godown_arrival_date ?>
		<td data-name="godown_arrival_date"<?php echo $purchase_a->godown_arrival_date->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_godown_arrival_date" class="purchase_a_godown_arrival_date">
<span<?php echo $purchase_a->godown_arrival_date->viewAttributes() ?>>
<?php echo $purchase_a->godown_arrival_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $purchase_a->godown->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_godown" class="purchase_a_godown">
<span<?php echo $purchase_a->godown->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_a->godown->getViewValue())) && $purchase_a->godown->linkAttributes() <> "") { ?>
<a<?php echo $purchase_a->godown->linkAttributes() ?>><?php echo $purchase_a->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_a->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->rack->Visible) { // rack ?>
		<td data-name="rack"<?php echo $purchase_a->rack->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_rack" class="purchase_a_rack">
<span<?php echo $purchase_a->rack->viewAttributes() ?>>
<?php echo $purchase_a->rack->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->invoice_details->Visible) { // invoice_details ?>
		<td data-name="invoice_details"<?php echo $purchase_a->invoice_details->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_invoice_details" class="purchase_a_invoice_details">
<span<?php echo $purchase_a->invoice_details->viewAttributes() ?>>
<?php echo $purchase_a->invoice_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->invoice_value->Visible) { // invoice_value ?>
		<td data-name="invoice_value"<?php echo $purchase_a->invoice_value->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_invoice_value" class="purchase_a_invoice_value">
<span<?php echo $purchase_a->invoice_value->viewAttributes() ?>>
<?php echo $purchase_a->invoice_value->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->currency_rate->Visible) { // currency_rate ?>
		<td data-name="currency_rate"<?php echo $purchase_a->currency_rate->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_currency_rate" class="purchase_a_currency_rate">
<span<?php echo $purchase_a->currency_rate->viewAttributes() ?>>
<?php echo $purchase_a->currency_rate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->purchase_amount_inr->Visible) { // purchase_amount_inr ?>
		<td data-name="purchase_amount_inr"<?php echo $purchase_a->purchase_amount_inr->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_purchase_amount_inr" class="purchase_a_purchase_amount_inr">
<span<?php echo $purchase_a->purchase_amount_inr->viewAttributes() ?>>
<?php echo $purchase_a->purchase_amount_inr->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->duty_paid_by->Visible) { // duty_paid_by ?>
		<td data-name="duty_paid_by"<?php echo $purchase_a->duty_paid_by->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_duty_paid_by" class="purchase_a_duty_paid_by">
<span<?php echo $purchase_a->duty_paid_by->viewAttributes() ?>>
<?php echo $purchase_a->duty_paid_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->custom_duty->Visible) { // custom_duty ?>
		<td data-name="custom_duty"<?php echo $purchase_a->custom_duty->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_custom_duty" class="purchase_a_custom_duty">
<span<?php echo $purchase_a->custom_duty->viewAttributes() ?>>
<?php echo $purchase_a->custom_duty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->port_clearing_charge->Visible) { // port_clearing_charge ?>
		<td data-name="port_clearing_charge"<?php echo $purchase_a->port_clearing_charge->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_port_clearing_charge" class="purchase_a_port_clearing_charge">
<span<?php echo $purchase_a->port_clearing_charge->viewAttributes() ?>>
<?php echo $purchase_a->port_clearing_charge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->cha_commission->Visible) { // cha_commission ?>
		<td data-name="cha_commission"<?php echo $purchase_a->cha_commission->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_cha_commission" class="purchase_a_cha_commission">
<span<?php echo $purchase_a->cha_commission->viewAttributes() ?>>
<?php echo $purchase_a->cha_commission->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->cha_agent->Visible) { // cha_agent ?>
		<td data-name="cha_agent"<?php echo $purchase_a->cha_agent->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_cha_agent" class="purchase_a_cha_agent">
<span<?php echo $purchase_a->cha_agent->viewAttributes() ?>>
<?php echo $purchase_a->cha_agent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->bank_charges->Visible) { // bank_charges ?>
		<td data-name="bank_charges"<?php echo $purchase_a->bank_charges->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_bank_charges" class="purchase_a_bank_charges">
<span<?php echo $purchase_a->bank_charges->viewAttributes() ?>>
<?php echo $purchase_a->bank_charges->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->importer->Visible) { // importer ?>
		<td data-name="importer"<?php echo $purchase_a->importer->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_importer" class="purchase_a_importer">
<span<?php echo $purchase_a->importer->viewAttributes() ?>>
<?php echo $purchase_a->importer->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $purchase_a->remarks->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_remarks" class="purchase_a_remarks">
<span<?php echo $purchase_a->remarks->viewAttributes() ?>>
<?php echo $purchase_a->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->fiba_fibd->Visible) { // fiba_fibd ?>
		<td data-name="fiba_fibd"<?php echo $purchase_a->fiba_fibd->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_fiba_fibd" class="purchase_a_fiba_fibd">
<span<?php echo $purchase_a->fiba_fibd->viewAttributes() ?>>
<?php echo $purchase_a->fiba_fibd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->fibc->Visible) { // fibc ?>
		<td data-name="fibc"<?php echo $purchase_a->fibc->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_fibc" class="purchase_a_fibc">
<span<?php echo $purchase_a->fibc->viewAttributes() ?>>
<?php echo $purchase_a->fibc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $purchase_a->operator->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_operator" class="purchase_a_operator">
<span<?php echo $purchase_a->operator->viewAttributes() ?>>
<?php echo $purchase_a->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $purchase_a->datetime->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_datetime" class="purchase_a_datetime">
<span<?php echo $purchase_a->datetime->viewAttributes() ?>>
<?php echo $purchase_a->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->qc_status->Visible) { // qc_status ?>
		<td data-name="qc_status"<?php echo $purchase_a->qc_status->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_qc_status" class="purchase_a_qc_status">
<span<?php echo $purchase_a->qc_status->viewAttributes() ?>>
<?php echo $purchase_a->qc_status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->qc_operator->Visible) { // qc_operator ?>
		<td data-name="qc_operator"<?php echo $purchase_a->qc_operator->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_qc_operator" class="purchase_a_qc_operator">
<span<?php echo $purchase_a->qc_operator->viewAttributes() ?>>
<?php echo $purchase_a->qc_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->qc_datetime->Visible) { // qc_datetime ?>
		<td data-name="qc_datetime"<?php echo $purchase_a->qc_datetime->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_qc_datetime" class="purchase_a_qc_datetime">
<span<?php echo $purchase_a->qc_datetime->viewAttributes() ?>>
<?php echo $purchase_a->qc_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->rbi_compliance_date->Visible) { // rbi_compliance_date ?>
		<td data-name="rbi_compliance_date"<?php echo $purchase_a->rbi_compliance_date->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_rbi_compliance_date" class="purchase_a_rbi_compliance_date">
<span<?php echo $purchase_a->rbi_compliance_date->viewAttributes() ?>>
<?php echo $purchase_a->rbi_compliance_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_a->age->Visible) { // age ?>
		<td data-name="age"<?php echo $purchase_a->age->cellAttributes() ?>>
<span id="el<?php echo $purchase_a_list->RowCnt ?>_purchase_a_age" class="purchase_a_age">
<span<?php echo $purchase_a->age->viewAttributes() ?>>
<?php echo $purchase_a->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$purchase_a_list->ListOptions->render("body", "right", $purchase_a_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$purchase_a->isGridAdd())
		$purchase_a_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$purchase_a->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($purchase_a_list->Recordset)
	$purchase_a_list->Recordset->Close();
?>
<?php if (!$purchase_a->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$purchase_a->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($purchase_a_list->Pager)) $purchase_a_list->Pager = new PrevNextPager($purchase_a_list->StartRec, $purchase_a_list->DisplayRecs, $purchase_a_list->TotalRecs, $purchase_a_list->AutoHidePager) ?>
<?php if ($purchase_a_list->Pager->RecordCount > 0 && $purchase_a_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($purchase_a_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $purchase_a_list->pageUrl() ?>start=<?php echo $purchase_a_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($purchase_a_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $purchase_a_list->pageUrl() ?>start=<?php echo $purchase_a_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $purchase_a_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($purchase_a_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $purchase_a_list->pageUrl() ?>start=<?php echo $purchase_a_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($purchase_a_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $purchase_a_list->pageUrl() ?>start=<?php echo $purchase_a_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $purchase_a_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($purchase_a_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $purchase_a_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $purchase_a_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $purchase_a_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($purchase_a_list->TotalRecs > 0 && (!$purchase_a_list->AutoHidePageSizeSelector || $purchase_a_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="purchase_a">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($purchase_a_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($purchase_a_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($purchase_a_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($purchase_a_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($purchase_a_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($purchase_a->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $purchase_a_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($purchase_a_list->TotalRecs == 0 && !$purchase_a->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $purchase_a_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$purchase_a_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$purchase_a->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$purchase_a->isExport()) { ?>
<script>
ew.scrollableTable("gmp_purchase_a", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$purchase_a_list->terminate();
?>