<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$purchase_a_search = new purchase_a_search();

// Run the page
$purchase_a_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$purchase_a_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($purchase_a_search->IsModal) { ?>
var fpurchase_asearch = currentAdvancedSearchForm = new ew.Form("fpurchase_asearch", "search");
<?php } else { ?>
var fpurchase_asearch = currentForm = new ew.Form("fpurchase_asearch", "search");
<?php } ?>

// Form_CustomValidate event
fpurchase_asearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_asearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_asearch.lists["x_supplier"] = <?php echo $purchase_a_search->supplier->Lookup->toClientList() ?>;
fpurchase_asearch.lists["x_supplier"].options = <?php echo JsonEncode($purchase_a_search->supplier->lookupOptions()) ?>;
fpurchase_asearch.lists["x_booking_reference"] = <?php echo $purchase_a_search->booking_reference->Lookup->toClientList() ?>;
fpurchase_asearch.lists["x_booking_reference"].options = <?php echo JsonEncode($purchase_a_search->booking_reference->lookupOptions()) ?>;
fpurchase_asearch.lists["x_packing_type"] = <?php echo $purchase_a_search->packing_type->Lookup->toClientList() ?>;
fpurchase_asearch.lists["x_packing_type"].options = <?php echo JsonEncode($purchase_a_search->packing_type->lookupOptions()) ?>;
fpurchase_asearch.lists["x_shipping_line"] = <?php echo $purchase_a_search->shipping_line->Lookup->toClientList() ?>;
fpurchase_asearch.lists["x_shipping_line"].options = <?php echo JsonEncode($purchase_a_search->shipping_line->lookupOptions()) ?>;
fpurchase_asearch.lists["x_godown"] = <?php echo $purchase_a_search->godown->Lookup->toClientList() ?>;
fpurchase_asearch.lists["x_godown"].options = <?php echo JsonEncode($purchase_a_search->godown->lookupOptions()) ?>;
fpurchase_asearch.lists["x_duty_paid_by"] = <?php echo $purchase_a_search->duty_paid_by->Lookup->toClientList() ?>;
fpurchase_asearch.lists["x_duty_paid_by"].options = <?php echo JsonEncode($purchase_a_search->duty_paid_by->options(FALSE, TRUE)) ?>;
fpurchase_asearch.lists["x_cha_agent"] = <?php echo $purchase_a_search->cha_agent->Lookup->toClientList() ?>;
fpurchase_asearch.lists["x_cha_agent"].options = <?php echo JsonEncode($purchase_a_search->cha_agent->lookupOptions()) ?>;
fpurchase_asearch.lists["x_clearance_bank"] = <?php echo $purchase_a_search->clearance_bank->Lookup->toClientList() ?>;
fpurchase_asearch.lists["x_clearance_bank"].options = <?php echo JsonEncode($purchase_a_search->clearance_bank->lookupOptions()) ?>;
fpurchase_asearch.lists["x_importer"] = <?php echo $purchase_a_search->importer->Lookup->toClientList() ?>;
fpurchase_asearch.lists["x_importer"].options = <?php echo JsonEncode($purchase_a_search->importer->lookupOptions()) ?>;
fpurchase_asearch.lists["x_operator"] = <?php echo $purchase_a_search->operator->Lookup->toClientList() ?>;
fpurchase_asearch.lists["x_operator"].options = <?php echo JsonEncode($purchase_a_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpurchase_asearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_gross_weight");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->gross_weight->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_net_weight");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->net_weight->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_containers");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->containers->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_port_arrival_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->port_arrival_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_godown_arrival_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->godown_arrival_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_invoice_value");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->invoice_value->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_currency_rate");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->currency_rate->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_purchase_amount_inr");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->purchase_amount_inr->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_custom_duty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->custom_duty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_transportation_charges");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->transportation_charges->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_port_clearing_charge");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->port_clearing_charge->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cha_commission");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->cha_commission->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qc_status");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->qc_status->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qc_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->qc_operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qc_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->qc_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_rbi_compliance_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->rbi_compliance_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_age");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_a->age->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $purchase_a_search->showPageHeader(); ?>
<?php
$purchase_a_search->showMessage();
?>
<form name="fpurchase_asearch" id="fpurchase_asearch" class="<?php echo $purchase_a_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($purchase_a_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $purchase_a_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="purchase_a">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$purchase_a_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($purchase_a->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_id"><?php echo $purchase_a->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->id->cellAttributes() ?>>
			<span id="el_purchase_a_id">
<input type="text" data-table="purchase_a" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($purchase_a->id->getPlaceHolder()) ?>" value="<?php echo $purchase_a->id->EditValue ?>"<?php echo $purchase_a->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->supplier->Visible) { // supplier ?>
	<div id="r_supplier" class="form-group row">
		<label for="x_supplier" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_supplier"><?php echo $purchase_a->supplier->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_supplier" id="z_supplier" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->supplier->cellAttributes() ?>>
			<span id="el_purchase_a_supplier">
<?php $purchase_a->supplier->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$purchase_a->supplier->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_supplier" data-value-separator="<?php echo $purchase_a->supplier->displayValueSeparatorAttribute() ?>" id="x_supplier" name="x_supplier"<?php echo $purchase_a->supplier->editAttributes() ?>>
		<?php echo $purchase_a->supplier->selectOptionListHtml("x_supplier") ?>
	</select>
</div>
<?php echo $purchase_a->supplier->Lookup->getParamTag("p_x_supplier") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->booking_reference->Visible) { // booking_reference ?>
	<div id="r_booking_reference" class="form-group row">
		<label for="x_booking_reference" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_booking_reference"><?php echo $purchase_a->booking_reference->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_booking_reference" id="z_booking_reference" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->booking_reference->cellAttributes() ?>>
			<span id="el_purchase_a_booking_reference">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_booking_reference" data-value-separator="<?php echo $purchase_a->booking_reference->displayValueSeparatorAttribute() ?>" id="x_booking_reference" name="x_booking_reference"<?php echo $purchase_a->booking_reference->editAttributes() ?>>
		<?php echo $purchase_a->booking_reference->selectOptionListHtml("x_booking_reference") ?>
	</select>
</div>
<?php echo $purchase_a->booking_reference->Lookup->getParamTag("p_x_booking_reference") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label for="x_lot_no" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_lot_no"><?php echo $purchase_a->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->lot_no->cellAttributes() ?>>
			<span id="el_purchase_a_lot_no">
<input type="text" data-table="purchase_a" data-field="x_lot_no" name="x_lot_no" id="x_lot_no" size="30" placeholder="<?php echo HtmlEncode($purchase_a->lot_no->getPlaceHolder()) ?>" value="<?php echo $purchase_a->lot_no->EditValue ?>"<?php echo $purchase_a->lot_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->gross_weight->Visible) { // gross_weight ?>
	<div id="r_gross_weight" class="form-group row">
		<label for="x_gross_weight" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_gross_weight"><?php echo $purchase_a->gross_weight->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gross_weight" id="z_gross_weight" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->gross_weight->cellAttributes() ?>>
			<span id="el_purchase_a_gross_weight">
<input type="text" data-table="purchase_a" data-field="x_gross_weight" name="x_gross_weight" id="x_gross_weight" size="30" placeholder="<?php echo HtmlEncode($purchase_a->gross_weight->getPlaceHolder()) ?>" value="<?php echo $purchase_a->gross_weight->EditValue ?>"<?php echo $purchase_a->gross_weight->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->net_weight->Visible) { // net_weight ?>
	<div id="r_net_weight" class="form-group row">
		<label for="x_net_weight" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_net_weight"><?php echo $purchase_a->net_weight->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->net_weight->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_net_weight" id="z_net_weight" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_a->net_weight->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_a->net_weight->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_a->net_weight->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_a->net_weight->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_a->net_weight->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_a->net_weight->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($purchase_a->net_weight->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_a_net_weight">
<input type="text" data-table="purchase_a" data-field="x_net_weight" name="x_net_weight" id="x_net_weight" size="30" placeholder="<?php echo HtmlEncode($purchase_a->net_weight->getPlaceHolder()) ?>" value="<?php echo $purchase_a->net_weight->EditValue ?>"<?php echo $purchase_a->net_weight->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_net_weight d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_a_net_weight" class="btw1_net_weight d-none">
<input type="text" data-table="purchase_a" data-field="x_net_weight" name="y_net_weight" id="y_net_weight" size="30" placeholder="<?php echo HtmlEncode($purchase_a->net_weight->getPlaceHolder()) ?>" value="<?php echo $purchase_a->net_weight->EditValue2 ?>"<?php echo $purchase_a->net_weight->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_packets"><?php echo $purchase_a->packets->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->packets->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_packets" id="z_packets" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_a->packets->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_a->packets->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_a->packets->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_a->packets->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_a->packets->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_a->packets->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($purchase_a->packets->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($purchase_a->packets->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($purchase_a->packets->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_a_packets">
<input type="text" data-table="purchase_a" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($purchase_a->packets->getPlaceHolder()) ?>" value="<?php echo $purchase_a->packets->EditValue ?>"<?php echo $purchase_a->packets->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_packets d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_a_packets" class="btw1_packets d-none">
<input type="text" data-table="purchase_a" data-field="x_packets" name="y_packets" id="y_packets" size="30" placeholder="<?php echo HtmlEncode($purchase_a->packets->getPlaceHolder()) ?>" value="<?php echo $purchase_a->packets->EditValue2 ?>"<?php echo $purchase_a->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_packing_type"><?php echo $purchase_a->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->packing_type->cellAttributes() ?>>
			<span id="el_purchase_a_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_packing_type" data-value-separator="<?php echo $purchase_a->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $purchase_a->packing_type->editAttributes() ?>>
		<?php echo $purchase_a->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $purchase_a->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->containers->Visible) { // containers ?>
	<div id="r_containers" class="form-group row">
		<label for="x_containers" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_containers"><?php echo $purchase_a->containers->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->containers->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_containers" id="z_containers" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_a->containers->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_a->containers->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_a->containers->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_a->containers->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_a->containers->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_a->containers->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($purchase_a->containers->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_a_containers">
<input type="text" data-table="purchase_a" data-field="x_containers" name="x_containers" id="x_containers" size="30" placeholder="<?php echo HtmlEncode($purchase_a->containers->getPlaceHolder()) ?>" value="<?php echo $purchase_a->containers->EditValue ?>"<?php echo $purchase_a->containers->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_containers d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_a_containers" class="btw1_containers d-none">
<input type="text" data-table="purchase_a" data-field="x_containers" name="y_containers" id="y_containers" size="30" placeholder="<?php echo HtmlEncode($purchase_a->containers->getPlaceHolder()) ?>" value="<?php echo $purchase_a->containers->EditValue2 ?>"<?php echo $purchase_a->containers->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->shipping_line->Visible) { // shipping_line ?>
	<div id="r_shipping_line" class="form-group row">
		<label for="x_shipping_line" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_shipping_line"><?php echo $purchase_a->shipping_line->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_shipping_line" id="z_shipping_line" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->shipping_line->cellAttributes() ?>>
			<span id="el_purchase_a_shipping_line">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_shipping_line" data-value-separator="<?php echo $purchase_a->shipping_line->displayValueSeparatorAttribute() ?>" id="x_shipping_line" name="x_shipping_line"<?php echo $purchase_a->shipping_line->editAttributes() ?>>
		<?php echo $purchase_a->shipping_line->selectOptionListHtml("x_shipping_line") ?>
	</select>
</div>
<?php echo $purchase_a->shipping_line->Lookup->getParamTag("p_x_shipping_line") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->port_arrival_date->Visible) { // port_arrival_date ?>
	<div id="r_port_arrival_date" class="form-group row">
		<label for="x_port_arrival_date" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_port_arrival_date"><?php echo $purchase_a->port_arrival_date->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->port_arrival_date->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_port_arrival_date" id="z_port_arrival_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_a->port_arrival_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_a->port_arrival_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_a->port_arrival_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_a->port_arrival_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_a->port_arrival_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_a->port_arrival_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($purchase_a->port_arrival_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($purchase_a->port_arrival_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($purchase_a->port_arrival_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_a_port_arrival_date">
<input type="text" data-table="purchase_a" data-field="x_port_arrival_date" name="x_port_arrival_date" id="x_port_arrival_date" placeholder="<?php echo HtmlEncode($purchase_a->port_arrival_date->getPlaceHolder()) ?>" value="<?php echo $purchase_a->port_arrival_date->EditValue ?>"<?php echo $purchase_a->port_arrival_date->editAttributes() ?>>
<?php if (!$purchase_a->port_arrival_date->ReadOnly && !$purchase_a->port_arrival_date->Disabled && !isset($purchase_a->port_arrival_date->EditAttrs["readonly"]) && !isset($purchase_a->port_arrival_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_asearch", "x_port_arrival_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_port_arrival_date d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_a_port_arrival_date" class="btw1_port_arrival_date d-none">
<input type="text" data-table="purchase_a" data-field="x_port_arrival_date" name="y_port_arrival_date" id="y_port_arrival_date" placeholder="<?php echo HtmlEncode($purchase_a->port_arrival_date->getPlaceHolder()) ?>" value="<?php echo $purchase_a->port_arrival_date->EditValue2 ?>"<?php echo $purchase_a->port_arrival_date->editAttributes() ?>>
<?php if (!$purchase_a->port_arrival_date->ReadOnly && !$purchase_a->port_arrival_date->Disabled && !isset($purchase_a->port_arrival_date->EditAttrs["readonly"]) && !isset($purchase_a->port_arrival_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_asearch", "y_port_arrival_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->godown_arrival_date->Visible) { // godown_arrival_date ?>
	<div id="r_godown_arrival_date" class="form-group row">
		<label for="x_godown_arrival_date" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_godown_arrival_date"><?php echo $purchase_a->godown_arrival_date->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->godown_arrival_date->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_godown_arrival_date" id="z_godown_arrival_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_a->godown_arrival_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_a->godown_arrival_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_a->godown_arrival_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_a->godown_arrival_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_a->godown_arrival_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_a->godown_arrival_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($purchase_a->godown_arrival_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($purchase_a->godown_arrival_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($purchase_a->godown_arrival_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_a_godown_arrival_date">
<input type="text" data-table="purchase_a" data-field="x_godown_arrival_date" name="x_godown_arrival_date" id="x_godown_arrival_date" placeholder="<?php echo HtmlEncode($purchase_a->godown_arrival_date->getPlaceHolder()) ?>" value="<?php echo $purchase_a->godown_arrival_date->EditValue ?>"<?php echo $purchase_a->godown_arrival_date->editAttributes() ?>>
<?php if (!$purchase_a->godown_arrival_date->ReadOnly && !$purchase_a->godown_arrival_date->Disabled && !isset($purchase_a->godown_arrival_date->EditAttrs["readonly"]) && !isset($purchase_a->godown_arrival_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_asearch", "x_godown_arrival_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_godown_arrival_date d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_a_godown_arrival_date" class="btw1_godown_arrival_date d-none">
<input type="text" data-table="purchase_a" data-field="x_godown_arrival_date" name="y_godown_arrival_date" id="y_godown_arrival_date" placeholder="<?php echo HtmlEncode($purchase_a->godown_arrival_date->getPlaceHolder()) ?>" value="<?php echo $purchase_a->godown_arrival_date->EditValue2 ?>"<?php echo $purchase_a->godown_arrival_date->editAttributes() ?>>
<?php if (!$purchase_a->godown_arrival_date->ReadOnly && !$purchase_a->godown_arrival_date->Disabled && !isset($purchase_a->godown_arrival_date->EditAttrs["readonly"]) && !isset($purchase_a->godown_arrival_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_asearch", "y_godown_arrival_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_godown"><?php echo $purchase_a->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->godown->cellAttributes() ?>>
			<span id="el_purchase_a_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_godown" data-value-separator="<?php echo $purchase_a->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $purchase_a->godown->editAttributes() ?>>
		<?php echo $purchase_a->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $purchase_a->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->rack->Visible) { // rack ?>
	<div id="r_rack" class="form-group row">
		<label for="x_rack" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_rack"><?php echo $purchase_a->rack->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rack" id="z_rack" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->rack->cellAttributes() ?>>
			<span id="el_purchase_a_rack">
<input type="text" data-table="purchase_a" data-field="x_rack" name="x_rack" id="x_rack" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($purchase_a->rack->getPlaceHolder()) ?>" value="<?php echo $purchase_a->rack->EditValue ?>"<?php echo $purchase_a->rack->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->invoice_details->Visible) { // invoice_details ?>
	<div id="r_invoice_details" class="form-group row">
		<label for="x_invoice_details" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_invoice_details"><?php echo $purchase_a->invoice_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_invoice_details" id="z_invoice_details" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->invoice_details->cellAttributes() ?>>
			<span id="el_purchase_a_invoice_details">
<input type="text" data-table="purchase_a" data-field="x_invoice_details" name="x_invoice_details" id="x_invoice_details" placeholder="<?php echo HtmlEncode($purchase_a->invoice_details->getPlaceHolder()) ?>" value="<?php echo $purchase_a->invoice_details->EditValue ?>"<?php echo $purchase_a->invoice_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->invoice_value->Visible) { // invoice_value ?>
	<div id="r_invoice_value" class="form-group row">
		<label for="x_invoice_value" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_invoice_value"><?php echo $purchase_a->invoice_value->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_invoice_value" id="z_invoice_value" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->invoice_value->cellAttributes() ?>>
			<span id="el_purchase_a_invoice_value">
<input type="text" data-table="purchase_a" data-field="x_invoice_value" name="x_invoice_value" id="x_invoice_value" size="30" placeholder="<?php echo HtmlEncode($purchase_a->invoice_value->getPlaceHolder()) ?>" value="<?php echo $purchase_a->invoice_value->EditValue ?>"<?php echo $purchase_a->invoice_value->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->currency_rate->Visible) { // currency_rate ?>
	<div id="r_currency_rate" class="form-group row">
		<label for="x_currency_rate" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_currency_rate"><?php echo $purchase_a->currency_rate->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_currency_rate" id="z_currency_rate" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->currency_rate->cellAttributes() ?>>
			<span id="el_purchase_a_currency_rate">
<input type="text" data-table="purchase_a" data-field="x_currency_rate" name="x_currency_rate" id="x_currency_rate" size="30" placeholder="<?php echo HtmlEncode($purchase_a->currency_rate->getPlaceHolder()) ?>" value="<?php echo $purchase_a->currency_rate->EditValue ?>"<?php echo $purchase_a->currency_rate->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->purchase_amount_inr->Visible) { // purchase_amount_inr ?>
	<div id="r_purchase_amount_inr" class="form-group row">
		<label for="x_purchase_amount_inr" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_purchase_amount_inr"><?php echo $purchase_a->purchase_amount_inr->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->purchase_amount_inr->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_purchase_amount_inr" id="z_purchase_amount_inr" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_a->purchase_amount_inr->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_a->purchase_amount_inr->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_a->purchase_amount_inr->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_a->purchase_amount_inr->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_a->purchase_amount_inr->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_a->purchase_amount_inr->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($purchase_a->purchase_amount_inr->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($purchase_a->purchase_amount_inr->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($purchase_a->purchase_amount_inr->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_a_purchase_amount_inr">
<input type="text" data-table="purchase_a" data-field="x_purchase_amount_inr" name="x_purchase_amount_inr" id="x_purchase_amount_inr" size="30" placeholder="<?php echo HtmlEncode($purchase_a->purchase_amount_inr->getPlaceHolder()) ?>" value="<?php echo $purchase_a->purchase_amount_inr->EditValue ?>"<?php echo $purchase_a->purchase_amount_inr->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_purchase_amount_inr d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_a_purchase_amount_inr" class="btw1_purchase_amount_inr d-none">
<input type="text" data-table="purchase_a" data-field="x_purchase_amount_inr" name="y_purchase_amount_inr" id="y_purchase_amount_inr" size="30" placeholder="<?php echo HtmlEncode($purchase_a->purchase_amount_inr->getPlaceHolder()) ?>" value="<?php echo $purchase_a->purchase_amount_inr->EditValue2 ?>"<?php echo $purchase_a->purchase_amount_inr->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->duty_paid_by->Visible) { // duty_paid_by ?>
	<div id="r_duty_paid_by" class="form-group row">
		<label for="x_duty_paid_by" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_duty_paid_by"><?php echo $purchase_a->duty_paid_by->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_duty_paid_by" id="z_duty_paid_by" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->duty_paid_by->cellAttributes() ?>>
			<span id="el_purchase_a_duty_paid_by">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_duty_paid_by" data-value-separator="<?php echo $purchase_a->duty_paid_by->displayValueSeparatorAttribute() ?>" id="x_duty_paid_by" name="x_duty_paid_by"<?php echo $purchase_a->duty_paid_by->editAttributes() ?>>
		<?php echo $purchase_a->duty_paid_by->selectOptionListHtml("x_duty_paid_by") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->custom_duty->Visible) { // custom_duty ?>
	<div id="r_custom_duty" class="form-group row">
		<label for="x_custom_duty" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_custom_duty"><?php echo $purchase_a->custom_duty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_custom_duty" id="z_custom_duty" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->custom_duty->cellAttributes() ?>>
			<span id="el_purchase_a_custom_duty">
<input type="text" data-table="purchase_a" data-field="x_custom_duty" name="x_custom_duty" id="x_custom_duty" size="30" placeholder="<?php echo HtmlEncode($purchase_a->custom_duty->getPlaceHolder()) ?>" value="<?php echo $purchase_a->custom_duty->EditValue ?>"<?php echo $purchase_a->custom_duty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->transportation_charges->Visible) { // transportation_charges ?>
	<div id="r_transportation_charges" class="form-group row">
		<label for="x_transportation_charges" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_transportation_charges"><?php echo $purchase_a->transportation_charges->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_transportation_charges" id="z_transportation_charges" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->transportation_charges->cellAttributes() ?>>
			<span id="el_purchase_a_transportation_charges">
<input type="text" data-table="purchase_a" data-field="x_transportation_charges" name="x_transportation_charges" id="x_transportation_charges" size="30" placeholder="<?php echo HtmlEncode($purchase_a->transportation_charges->getPlaceHolder()) ?>" value="<?php echo $purchase_a->transportation_charges->EditValue ?>"<?php echo $purchase_a->transportation_charges->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->port_clearing_charge->Visible) { // port_clearing_charge ?>
	<div id="r_port_clearing_charge" class="form-group row">
		<label for="x_port_clearing_charge" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_port_clearing_charge"><?php echo $purchase_a->port_clearing_charge->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_port_clearing_charge" id="z_port_clearing_charge" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->port_clearing_charge->cellAttributes() ?>>
			<span id="el_purchase_a_port_clearing_charge">
<input type="text" data-table="purchase_a" data-field="x_port_clearing_charge" name="x_port_clearing_charge" id="x_port_clearing_charge" size="30" placeholder="<?php echo HtmlEncode($purchase_a->port_clearing_charge->getPlaceHolder()) ?>" value="<?php echo $purchase_a->port_clearing_charge->EditValue ?>"<?php echo $purchase_a->port_clearing_charge->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->cha_commission->Visible) { // cha_commission ?>
	<div id="r_cha_commission" class="form-group row">
		<label for="x_cha_commission" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_cha_commission"><?php echo $purchase_a->cha_commission->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cha_commission" id="z_cha_commission" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->cha_commission->cellAttributes() ?>>
			<span id="el_purchase_a_cha_commission">
<input type="text" data-table="purchase_a" data-field="x_cha_commission" name="x_cha_commission" id="x_cha_commission" size="30" placeholder="<?php echo HtmlEncode($purchase_a->cha_commission->getPlaceHolder()) ?>" value="<?php echo $purchase_a->cha_commission->EditValue ?>"<?php echo $purchase_a->cha_commission->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->cha_agent->Visible) { // cha_agent ?>
	<div id="r_cha_agent" class="form-group row">
		<label for="x_cha_agent" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_cha_agent"><?php echo $purchase_a->cha_agent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cha_agent" id="z_cha_agent" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->cha_agent->cellAttributes() ?>>
			<span id="el_purchase_a_cha_agent">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_cha_agent" data-value-separator="<?php echo $purchase_a->cha_agent->displayValueSeparatorAttribute() ?>" id="x_cha_agent" name="x_cha_agent"<?php echo $purchase_a->cha_agent->editAttributes() ?>>
		<?php echo $purchase_a->cha_agent->selectOptionListHtml("x_cha_agent") ?>
	</select>
</div>
<?php echo $purchase_a->cha_agent->Lookup->getParamTag("p_x_cha_agent") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->clearance_bank->Visible) { // clearance_bank ?>
	<div id="r_clearance_bank" class="form-group row">
		<label for="x_clearance_bank" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_clearance_bank"><?php echo $purchase_a->clearance_bank->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_clearance_bank" id="z_clearance_bank" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->clearance_bank->cellAttributes() ?>>
			<span id="el_purchase_a_clearance_bank">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_clearance_bank" data-value-separator="<?php echo $purchase_a->clearance_bank->displayValueSeparatorAttribute() ?>" id="x_clearance_bank" name="x_clearance_bank"<?php echo $purchase_a->clearance_bank->editAttributes() ?>>
		<?php echo $purchase_a->clearance_bank->selectOptionListHtml("x_clearance_bank") ?>
	</select>
</div>
<?php echo $purchase_a->clearance_bank->Lookup->getParamTag("p_x_clearance_bank") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->bank_charges->Visible) { // bank_charges ?>
	<div id="r_bank_charges" class="form-group row">
		<label for="x_bank_charges" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_bank_charges"><?php echo $purchase_a->bank_charges->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_bank_charges" id="z_bank_charges" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->bank_charges->cellAttributes() ?>>
			<span id="el_purchase_a_bank_charges">
<input type="text" data-table="purchase_a" data-field="x_bank_charges" name="x_bank_charges" id="x_bank_charges" size="30" placeholder="<?php echo HtmlEncode($purchase_a->bank_charges->getPlaceHolder()) ?>" value="<?php echo $purchase_a->bank_charges->EditValue ?>"<?php echo $purchase_a->bank_charges->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->importer->Visible) { // importer ?>
	<div id="r_importer" class="form-group row">
		<label for="x_importer" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_importer"><?php echo $purchase_a->importer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_importer" id="z_importer" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->importer->cellAttributes() ?>>
			<span id="el_purchase_a_importer">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_importer" data-value-separator="<?php echo $purchase_a->importer->displayValueSeparatorAttribute() ?>" id="x_importer" name="x_importer"<?php echo $purchase_a->importer->editAttributes() ?>>
		<?php echo $purchase_a->importer->selectOptionListHtml("x_importer") ?>
	</select>
</div>
<?php echo $purchase_a->importer->Lookup->getParamTag("p_x_importer") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_remarks"><?php echo $purchase_a->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->remarks->cellAttributes() ?>>
			<span id="el_purchase_a_remarks">
<input type="text" data-table="purchase_a" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($purchase_a->remarks->getPlaceHolder()) ?>" value="<?php echo $purchase_a->remarks->EditValue ?>"<?php echo $purchase_a->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->fiba_fibd->Visible) { // fiba_fibd ?>
	<div id="r_fiba_fibd" class="form-group row">
		<label for="x_fiba_fibd" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_fiba_fibd"><?php echo $purchase_a->fiba_fibd->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_fiba_fibd" id="z_fiba_fibd" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->fiba_fibd->cellAttributes() ?>>
			<span id="el_purchase_a_fiba_fibd">
<input type="text" data-table="purchase_a" data-field="x_fiba_fibd" name="x_fiba_fibd" id="x_fiba_fibd" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($purchase_a->fiba_fibd->getPlaceHolder()) ?>" value="<?php echo $purchase_a->fiba_fibd->EditValue ?>"<?php echo $purchase_a->fiba_fibd->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->fibc->Visible) { // fibc ?>
	<div id="r_fibc" class="form-group row">
		<label for="x_fibc" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_fibc"><?php echo $purchase_a->fibc->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_fibc" id="z_fibc" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->fibc->cellAttributes() ?>>
			<span id="el_purchase_a_fibc">
<input type="text" data-table="purchase_a" data-field="x_fibc" name="x_fibc" id="x_fibc" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($purchase_a->fibc->getPlaceHolder()) ?>" value="<?php echo $purchase_a->fibc->EditValue ?>"<?php echo $purchase_a->fibc->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_operator"><?php echo $purchase_a->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->operator->cellAttributes() ?>>
			<span id="el_purchase_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_a" data-field="x_operator" data-value-separator="<?php echo $purchase_a->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $purchase_a->operator->editAttributes() ?>>
		<?php echo $purchase_a->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $purchase_a->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_datetime"><?php echo $purchase_a->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_a->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_a->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_a->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_a->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_a->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_a->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($purchase_a->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($purchase_a->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($purchase_a->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_a_datetime">
<input type="text" data-table="purchase_a" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($purchase_a->datetime->getPlaceHolder()) ?>" value="<?php echo $purchase_a->datetime->EditValue ?>"<?php echo $purchase_a->datetime->editAttributes() ?>>
<?php if (!$purchase_a->datetime->ReadOnly && !$purchase_a->datetime->Disabled && !isset($purchase_a->datetime->EditAttrs["readonly"]) && !isset($purchase_a->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_asearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_a_datetime" class="btw1_datetime d-none">
<input type="text" data-table="purchase_a" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($purchase_a->datetime->getPlaceHolder()) ?>" value="<?php echo $purchase_a->datetime->EditValue2 ?>"<?php echo $purchase_a->datetime->editAttributes() ?>>
<?php if (!$purchase_a->datetime->ReadOnly && !$purchase_a->datetime->Disabled && !isset($purchase_a->datetime->EditAttrs["readonly"]) && !isset($purchase_a->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_asearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->qc_remarks->Visible) { // qc_remarks ?>
	<div id="r_qc_remarks" class="form-group row">
		<label for="x_qc_remarks" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_qc_remarks"><?php echo $purchase_a->qc_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_qc_remarks" id="z_qc_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->qc_remarks->cellAttributes() ?>>
			<span id="el_purchase_a_qc_remarks">
<input type="text" data-table="purchase_a" data-field="x_qc_remarks" name="x_qc_remarks" id="x_qc_remarks" size="35" placeholder="<?php echo HtmlEncode($purchase_a->qc_remarks->getPlaceHolder()) ?>" value="<?php echo $purchase_a->qc_remarks->EditValue ?>"<?php echo $purchase_a->qc_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->qc_status->Visible) { // qc_status ?>
	<div id="r_qc_status" class="form-group row">
		<label for="x_qc_status" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_qc_status"><?php echo $purchase_a->qc_status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qc_status" id="z_qc_status" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->qc_status->cellAttributes() ?>>
			<span id="el_purchase_a_qc_status">
<input type="text" data-table="purchase_a" data-field="x_qc_status" name="x_qc_status" id="x_qc_status" size="30" placeholder="<?php echo HtmlEncode($purchase_a->qc_status->getPlaceHolder()) ?>" value="<?php echo $purchase_a->qc_status->EditValue ?>"<?php echo $purchase_a->qc_status->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->qc_operator->Visible) { // qc_operator ?>
	<div id="r_qc_operator" class="form-group row">
		<label for="x_qc_operator" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_qc_operator"><?php echo $purchase_a->qc_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qc_operator" id="z_qc_operator" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->qc_operator->cellAttributes() ?>>
			<span id="el_purchase_a_qc_operator">
<input type="text" data-table="purchase_a" data-field="x_qc_operator" name="x_qc_operator" id="x_qc_operator" size="30" placeholder="<?php echo HtmlEncode($purchase_a->qc_operator->getPlaceHolder()) ?>" value="<?php echo $purchase_a->qc_operator->EditValue ?>"<?php echo $purchase_a->qc_operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->qc_datetime->Visible) { // qc_datetime ?>
	<div id="r_qc_datetime" class="form-group row">
		<label for="x_qc_datetime" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_qc_datetime"><?php echo $purchase_a->qc_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qc_datetime" id="z_qc_datetime" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->qc_datetime->cellAttributes() ?>>
			<span id="el_purchase_a_qc_datetime">
<input type="text" data-table="purchase_a" data-field="x_qc_datetime" name="x_qc_datetime" id="x_qc_datetime" placeholder="<?php echo HtmlEncode($purchase_a->qc_datetime->getPlaceHolder()) ?>" value="<?php echo $purchase_a->qc_datetime->EditValue ?>"<?php echo $purchase_a->qc_datetime->editAttributes() ?>>
<?php if (!$purchase_a->qc_datetime->ReadOnly && !$purchase_a->qc_datetime->Disabled && !isset($purchase_a->qc_datetime->EditAttrs["readonly"]) && !isset($purchase_a->qc_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_asearch", "x_qc_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->rbi_compliance_date->Visible) { // rbi_compliance_date ?>
	<div id="r_rbi_compliance_date" class="form-group row">
		<label for="x_rbi_compliance_date" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_rbi_compliance_date"><?php echo $purchase_a->rbi_compliance_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rbi_compliance_date" id="z_rbi_compliance_date" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->rbi_compliance_date->cellAttributes() ?>>
			<span id="el_purchase_a_rbi_compliance_date">
<input type="text" data-table="purchase_a" data-field="x_rbi_compliance_date" name="x_rbi_compliance_date" id="x_rbi_compliance_date" placeholder="<?php echo HtmlEncode($purchase_a->rbi_compliance_date->getPlaceHolder()) ?>" value="<?php echo $purchase_a->rbi_compliance_date->EditValue ?>"<?php echo $purchase_a->rbi_compliance_date->editAttributes() ?>>
<?php if (!$purchase_a->rbi_compliance_date->ReadOnly && !$purchase_a->rbi_compliance_date->Disabled && !isset($purchase_a->rbi_compliance_date->EditAttrs["readonly"]) && !isset($purchase_a->rbi_compliance_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_asearch", "x_rbi_compliance_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_a->age->Visible) { // age ?>
	<div id="r_age" class="form-group row">
		<label for="x_age" class="<?php echo $purchase_a_search->LeftColumnClass ?>"><span id="elh_purchase_a_age"><?php echo $purchase_a->age->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_age" id="z_age" value="="></span>
		</label>
		<div class="<?php echo $purchase_a_search->RightColumnClass ?>"><div<?php echo $purchase_a->age->cellAttributes() ?>>
			<span id="el_purchase_a_age">
<input type="text" data-table="purchase_a" data-field="x_age" name="x_age" id="x_age" size="30" placeholder="<?php echo HtmlEncode($purchase_a->age->getPlaceHolder()) ?>" value="<?php echo $purchase_a->age->EditValue ?>"<?php echo $purchase_a->age->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$purchase_a_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $purchase_a_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$purchase_a_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$purchase_a_search->terminate();
?>