<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$purchase_a_view = new purchase_a_view();

// Run the page
$purchase_a_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$purchase_a_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$purchase_a->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpurchase_aview = currentForm = new ew.Form("fpurchase_aview", "view");

// Form_CustomValidate event
fpurchase_aview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_aview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_aview.lists["x_supplier"] = <?php echo $purchase_a_view->supplier->Lookup->toClientList() ?>;
fpurchase_aview.lists["x_supplier"].options = <?php echo JsonEncode($purchase_a_view->supplier->lookupOptions()) ?>;
fpurchase_aview.lists["x_booking_reference"] = <?php echo $purchase_a_view->booking_reference->Lookup->toClientList() ?>;
fpurchase_aview.lists["x_booking_reference"].options = <?php echo JsonEncode($purchase_a_view->booking_reference->lookupOptions()) ?>;
fpurchase_aview.lists["x_packing_type"] = <?php echo $purchase_a_view->packing_type->Lookup->toClientList() ?>;
fpurchase_aview.lists["x_packing_type"].options = <?php echo JsonEncode($purchase_a_view->packing_type->lookupOptions()) ?>;
fpurchase_aview.lists["x_shipping_line"] = <?php echo $purchase_a_view->shipping_line->Lookup->toClientList() ?>;
fpurchase_aview.lists["x_shipping_line"].options = <?php echo JsonEncode($purchase_a_view->shipping_line->lookupOptions()) ?>;
fpurchase_aview.lists["x_godown"] = <?php echo $purchase_a_view->godown->Lookup->toClientList() ?>;
fpurchase_aview.lists["x_godown"].options = <?php echo JsonEncode($purchase_a_view->godown->lookupOptions()) ?>;
fpurchase_aview.lists["x_duty_paid_by"] = <?php echo $purchase_a_view->duty_paid_by->Lookup->toClientList() ?>;
fpurchase_aview.lists["x_duty_paid_by"].options = <?php echo JsonEncode($purchase_a_view->duty_paid_by->options(FALSE, TRUE)) ?>;
fpurchase_aview.lists["x_cha_agent"] = <?php echo $purchase_a_view->cha_agent->Lookup->toClientList() ?>;
fpurchase_aview.lists["x_cha_agent"].options = <?php echo JsonEncode($purchase_a_view->cha_agent->lookupOptions()) ?>;
fpurchase_aview.lists["x_clearance_bank"] = <?php echo $purchase_a_view->clearance_bank->Lookup->toClientList() ?>;
fpurchase_aview.lists["x_clearance_bank"].options = <?php echo JsonEncode($purchase_a_view->clearance_bank->lookupOptions()) ?>;
fpurchase_aview.lists["x_importer"] = <?php echo $purchase_a_view->importer->Lookup->toClientList() ?>;
fpurchase_aview.lists["x_importer"].options = <?php echo JsonEncode($purchase_a_view->importer->lookupOptions()) ?>;
fpurchase_aview.lists["x_operator"] = <?php echo $purchase_a_view->operator->Lookup->toClientList() ?>;
fpurchase_aview.lists["x_operator"].options = <?php echo JsonEncode($purchase_a_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$purchase_a->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $purchase_a_view->ExportOptions->render("body") ?>
<?php $purchase_a_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $purchase_a_view->showPageHeader(); ?>
<?php
$purchase_a_view->showMessage();
?>
<form name="fpurchase_aview" id="fpurchase_aview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($purchase_a_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $purchase_a_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="purchase_a">
<input type="hidden" name="modal" value="<?php echo (int)$purchase_a_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($purchase_a->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_id"><?php echo $purchase_a->id->caption() ?></span></td>
		<td data-name="id"<?php echo $purchase_a->id->cellAttributes() ?>>
<span id="el_purchase_a_id">
<span<?php echo $purchase_a->id->viewAttributes() ?>>
<?php echo $purchase_a->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->supplier->Visible) { // supplier ?>
	<tr id="r_supplier">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_supplier"><?php echo $purchase_a->supplier->caption() ?></span></td>
		<td data-name="supplier"<?php echo $purchase_a->supplier->cellAttributes() ?>>
<span id="el_purchase_a_supplier">
<span<?php echo $purchase_a->supplier->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_a->supplier->getViewValue())) && $purchase_a->supplier->linkAttributes() <> "") { ?>
<a<?php echo $purchase_a->supplier->linkAttributes() ?>><?php echo $purchase_a->supplier->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_a->supplier->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->booking_reference->Visible) { // booking_reference ?>
	<tr id="r_booking_reference">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_booking_reference"><?php echo $purchase_a->booking_reference->caption() ?></span></td>
		<td data-name="booking_reference"<?php echo $purchase_a->booking_reference->cellAttributes() ?>>
<span id="el_purchase_a_booking_reference">
<span<?php echo $purchase_a->booking_reference->viewAttributes() ?>>
<?php echo $purchase_a->booking_reference->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->lot_no->Visible) { // lot_no ?>
	<tr id="r_lot_no">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_lot_no"><?php echo $purchase_a->lot_no->caption() ?></span></td>
		<td data-name="lot_no"<?php echo $purchase_a->lot_no->cellAttributes() ?>>
<span id="el_purchase_a_lot_no">
<span<?php echo $purchase_a->lot_no->viewAttributes() ?>>
<?php echo $purchase_a->lot_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->gross_weight->Visible) { // gross_weight ?>
	<tr id="r_gross_weight">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_gross_weight"><?php echo $purchase_a->gross_weight->caption() ?></span></td>
		<td data-name="gross_weight"<?php echo $purchase_a->gross_weight->cellAttributes() ?>>
<span id="el_purchase_a_gross_weight">
<span<?php echo $purchase_a->gross_weight->viewAttributes() ?>>
<?php echo $purchase_a->gross_weight->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->net_weight->Visible) { // net_weight ?>
	<tr id="r_net_weight">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_net_weight"><?php echo $purchase_a->net_weight->caption() ?></span></td>
		<td data-name="net_weight"<?php echo $purchase_a->net_weight->cellAttributes() ?>>
<span id="el_purchase_a_net_weight">
<span<?php echo $purchase_a->net_weight->viewAttributes() ?>>
<?php echo $purchase_a->net_weight->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->packets->Visible) { // packets ?>
	<tr id="r_packets">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_packets"><?php echo $purchase_a->packets->caption() ?></span></td>
		<td data-name="packets"<?php echo $purchase_a->packets->cellAttributes() ?>>
<span id="el_purchase_a_packets">
<span<?php echo $purchase_a->packets->viewAttributes() ?>>
<?php echo $purchase_a->packets->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_packing_type"><?php echo $purchase_a->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $purchase_a->packing_type->cellAttributes() ?>>
<span id="el_purchase_a_packing_type">
<span<?php echo $purchase_a->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_a->packing_type->getViewValue())) && $purchase_a->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $purchase_a->packing_type->linkAttributes() ?>><?php echo $purchase_a->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_a->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->containers->Visible) { // containers ?>
	<tr id="r_containers">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_containers"><?php echo $purchase_a->containers->caption() ?></span></td>
		<td data-name="containers"<?php echo $purchase_a->containers->cellAttributes() ?>>
<span id="el_purchase_a_containers">
<span<?php echo $purchase_a->containers->viewAttributes() ?>>
<?php echo $purchase_a->containers->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->shipping_line->Visible) { // shipping_line ?>
	<tr id="r_shipping_line">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_shipping_line"><?php echo $purchase_a->shipping_line->caption() ?></span></td>
		<td data-name="shipping_line"<?php echo $purchase_a->shipping_line->cellAttributes() ?>>
<span id="el_purchase_a_shipping_line">
<span<?php echo $purchase_a->shipping_line->viewAttributes() ?>>
<?php echo $purchase_a->shipping_line->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->port_arrival_date->Visible) { // port_arrival_date ?>
	<tr id="r_port_arrival_date">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_port_arrival_date"><?php echo $purchase_a->port_arrival_date->caption() ?></span></td>
		<td data-name="port_arrival_date"<?php echo $purchase_a->port_arrival_date->cellAttributes() ?>>
<span id="el_purchase_a_port_arrival_date">
<span<?php echo $purchase_a->port_arrival_date->viewAttributes() ?>>
<?php echo $purchase_a->port_arrival_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->godown_arrival_date->Visible) { // godown_arrival_date ?>
	<tr id="r_godown_arrival_date">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_godown_arrival_date"><?php echo $purchase_a->godown_arrival_date->caption() ?></span></td>
		<td data-name="godown_arrival_date"<?php echo $purchase_a->godown_arrival_date->cellAttributes() ?>>
<span id="el_purchase_a_godown_arrival_date">
<span<?php echo $purchase_a->godown_arrival_date->viewAttributes() ?>>
<?php echo $purchase_a->godown_arrival_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->godown->Visible) { // godown ?>
	<tr id="r_godown">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_godown"><?php echo $purchase_a->godown->caption() ?></span></td>
		<td data-name="godown"<?php echo $purchase_a->godown->cellAttributes() ?>>
<span id="el_purchase_a_godown">
<span<?php echo $purchase_a->godown->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_a->godown->getViewValue())) && $purchase_a->godown->linkAttributes() <> "") { ?>
<a<?php echo $purchase_a->godown->linkAttributes() ?>><?php echo $purchase_a->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_a->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->rack->Visible) { // rack ?>
	<tr id="r_rack">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_rack"><?php echo $purchase_a->rack->caption() ?></span></td>
		<td data-name="rack"<?php echo $purchase_a->rack->cellAttributes() ?>>
<span id="el_purchase_a_rack">
<span<?php echo $purchase_a->rack->viewAttributes() ?>>
<?php echo $purchase_a->rack->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->invoice_details->Visible) { // invoice_details ?>
	<tr id="r_invoice_details">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_invoice_details"><?php echo $purchase_a->invoice_details->caption() ?></span></td>
		<td data-name="invoice_details"<?php echo $purchase_a->invoice_details->cellAttributes() ?>>
<span id="el_purchase_a_invoice_details">
<span<?php echo $purchase_a->invoice_details->viewAttributes() ?>>
<?php echo $purchase_a->invoice_details->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->invoice_value->Visible) { // invoice_value ?>
	<tr id="r_invoice_value">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_invoice_value"><?php echo $purchase_a->invoice_value->caption() ?></span></td>
		<td data-name="invoice_value"<?php echo $purchase_a->invoice_value->cellAttributes() ?>>
<span id="el_purchase_a_invoice_value">
<span<?php echo $purchase_a->invoice_value->viewAttributes() ?>>
<?php echo $purchase_a->invoice_value->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->currency_rate->Visible) { // currency_rate ?>
	<tr id="r_currency_rate">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_currency_rate"><?php echo $purchase_a->currency_rate->caption() ?></span></td>
		<td data-name="currency_rate"<?php echo $purchase_a->currency_rate->cellAttributes() ?>>
<span id="el_purchase_a_currency_rate">
<span<?php echo $purchase_a->currency_rate->viewAttributes() ?>>
<?php echo $purchase_a->currency_rate->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->purchase_amount_inr->Visible) { // purchase_amount_inr ?>
	<tr id="r_purchase_amount_inr">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_purchase_amount_inr"><?php echo $purchase_a->purchase_amount_inr->caption() ?></span></td>
		<td data-name="purchase_amount_inr"<?php echo $purchase_a->purchase_amount_inr->cellAttributes() ?>>
<span id="el_purchase_a_purchase_amount_inr">
<span<?php echo $purchase_a->purchase_amount_inr->viewAttributes() ?>>
<?php echo $purchase_a->purchase_amount_inr->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->duty_paid_by->Visible) { // duty_paid_by ?>
	<tr id="r_duty_paid_by">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_duty_paid_by"><?php echo $purchase_a->duty_paid_by->caption() ?></span></td>
		<td data-name="duty_paid_by"<?php echo $purchase_a->duty_paid_by->cellAttributes() ?>>
<span id="el_purchase_a_duty_paid_by">
<span<?php echo $purchase_a->duty_paid_by->viewAttributes() ?>>
<?php echo $purchase_a->duty_paid_by->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->custom_duty->Visible) { // custom_duty ?>
	<tr id="r_custom_duty">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_custom_duty"><?php echo $purchase_a->custom_duty->caption() ?></span></td>
		<td data-name="custom_duty"<?php echo $purchase_a->custom_duty->cellAttributes() ?>>
<span id="el_purchase_a_custom_duty">
<span<?php echo $purchase_a->custom_duty->viewAttributes() ?>>
<?php echo $purchase_a->custom_duty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->transportation_charges->Visible) { // transportation_charges ?>
	<tr id="r_transportation_charges">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_transportation_charges"><?php echo $purchase_a->transportation_charges->caption() ?></span></td>
		<td data-name="transportation_charges"<?php echo $purchase_a->transportation_charges->cellAttributes() ?>>
<span id="el_purchase_a_transportation_charges">
<span<?php echo $purchase_a->transportation_charges->viewAttributes() ?>>
<?php echo $purchase_a->transportation_charges->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->port_clearing_charge->Visible) { // port_clearing_charge ?>
	<tr id="r_port_clearing_charge">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_port_clearing_charge"><?php echo $purchase_a->port_clearing_charge->caption() ?></span></td>
		<td data-name="port_clearing_charge"<?php echo $purchase_a->port_clearing_charge->cellAttributes() ?>>
<span id="el_purchase_a_port_clearing_charge">
<span<?php echo $purchase_a->port_clearing_charge->viewAttributes() ?>>
<?php echo $purchase_a->port_clearing_charge->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->cha_commission->Visible) { // cha_commission ?>
	<tr id="r_cha_commission">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_cha_commission"><?php echo $purchase_a->cha_commission->caption() ?></span></td>
		<td data-name="cha_commission"<?php echo $purchase_a->cha_commission->cellAttributes() ?>>
<span id="el_purchase_a_cha_commission">
<span<?php echo $purchase_a->cha_commission->viewAttributes() ?>>
<?php echo $purchase_a->cha_commission->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->cha_agent->Visible) { // cha_agent ?>
	<tr id="r_cha_agent">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_cha_agent"><?php echo $purchase_a->cha_agent->caption() ?></span></td>
		<td data-name="cha_agent"<?php echo $purchase_a->cha_agent->cellAttributes() ?>>
<span id="el_purchase_a_cha_agent">
<span<?php echo $purchase_a->cha_agent->viewAttributes() ?>>
<?php echo $purchase_a->cha_agent->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->clearance_bank->Visible) { // clearance_bank ?>
	<tr id="r_clearance_bank">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_clearance_bank"><?php echo $purchase_a->clearance_bank->caption() ?></span></td>
		<td data-name="clearance_bank"<?php echo $purchase_a->clearance_bank->cellAttributes() ?>>
<span id="el_purchase_a_clearance_bank">
<span<?php echo $purchase_a->clearance_bank->viewAttributes() ?>>
<?php echo $purchase_a->clearance_bank->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->bank_charges->Visible) { // bank_charges ?>
	<tr id="r_bank_charges">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_bank_charges"><?php echo $purchase_a->bank_charges->caption() ?></span></td>
		<td data-name="bank_charges"<?php echo $purchase_a->bank_charges->cellAttributes() ?>>
<span id="el_purchase_a_bank_charges">
<span<?php echo $purchase_a->bank_charges->viewAttributes() ?>>
<?php echo $purchase_a->bank_charges->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->importer->Visible) { // importer ?>
	<tr id="r_importer">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_importer"><?php echo $purchase_a->importer->caption() ?></span></td>
		<td data-name="importer"<?php echo $purchase_a->importer->cellAttributes() ?>>
<span id="el_purchase_a_importer">
<span<?php echo $purchase_a->importer->viewAttributes() ?>>
<?php echo $purchase_a->importer->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_remarks"><?php echo $purchase_a->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $purchase_a->remarks->cellAttributes() ?>>
<span id="el_purchase_a_remarks">
<span<?php echo $purchase_a->remarks->viewAttributes() ?>>
<?php echo $purchase_a->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->fiba_fibd->Visible) { // fiba_fibd ?>
	<tr id="r_fiba_fibd">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_fiba_fibd"><?php echo $purchase_a->fiba_fibd->caption() ?></span></td>
		<td data-name="fiba_fibd"<?php echo $purchase_a->fiba_fibd->cellAttributes() ?>>
<span id="el_purchase_a_fiba_fibd">
<span<?php echo $purchase_a->fiba_fibd->viewAttributes() ?>>
<?php echo $purchase_a->fiba_fibd->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->fibc->Visible) { // fibc ?>
	<tr id="r_fibc">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_fibc"><?php echo $purchase_a->fibc->caption() ?></span></td>
		<td data-name="fibc"<?php echo $purchase_a->fibc->cellAttributes() ?>>
<span id="el_purchase_a_fibc">
<span<?php echo $purchase_a->fibc->viewAttributes() ?>>
<?php echo $purchase_a->fibc->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_operator"><?php echo $purchase_a->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $purchase_a->operator->cellAttributes() ?>>
<span id="el_purchase_a_operator">
<span<?php echo $purchase_a->operator->viewAttributes() ?>>
<?php echo $purchase_a->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_datetime"><?php echo $purchase_a->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $purchase_a->datetime->cellAttributes() ?>>
<span id="el_purchase_a_datetime">
<span<?php echo $purchase_a->datetime->viewAttributes() ?>>
<?php echo $purchase_a->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->updated->Visible) { // updated ?>
	<tr id="r_updated">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_updated"><?php echo $purchase_a->updated->caption() ?></span></td>
		<td data-name="updated"<?php echo $purchase_a->updated->cellAttributes() ?>>
<span id="el_purchase_a_updated">
<span<?php echo $purchase_a->updated->viewAttributes() ?>>
<?php echo $purchase_a->updated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->qc_remarks->Visible) { // qc_remarks ?>
	<tr id="r_qc_remarks">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_qc_remarks"><?php echo $purchase_a->qc_remarks->caption() ?></span></td>
		<td data-name="qc_remarks"<?php echo $purchase_a->qc_remarks->cellAttributes() ?>>
<span id="el_purchase_a_qc_remarks">
<span<?php echo $purchase_a->qc_remarks->viewAttributes() ?>>
<?php echo $purchase_a->qc_remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->qc_status->Visible) { // qc_status ?>
	<tr id="r_qc_status">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_qc_status"><?php echo $purchase_a->qc_status->caption() ?></span></td>
		<td data-name="qc_status"<?php echo $purchase_a->qc_status->cellAttributes() ?>>
<span id="el_purchase_a_qc_status">
<span<?php echo $purchase_a->qc_status->viewAttributes() ?>>
<?php echo $purchase_a->qc_status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->qc_operator->Visible) { // qc_operator ?>
	<tr id="r_qc_operator">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_qc_operator"><?php echo $purchase_a->qc_operator->caption() ?></span></td>
		<td data-name="qc_operator"<?php echo $purchase_a->qc_operator->cellAttributes() ?>>
<span id="el_purchase_a_qc_operator">
<span<?php echo $purchase_a->qc_operator->viewAttributes() ?>>
<?php echo $purchase_a->qc_operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->qc_datetime->Visible) { // qc_datetime ?>
	<tr id="r_qc_datetime">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_qc_datetime"><?php echo $purchase_a->qc_datetime->caption() ?></span></td>
		<td data-name="qc_datetime"<?php echo $purchase_a->qc_datetime->cellAttributes() ?>>
<span id="el_purchase_a_qc_datetime">
<span<?php echo $purchase_a->qc_datetime->viewAttributes() ?>>
<?php echo $purchase_a->qc_datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->rbi_compliance_date->Visible) { // rbi_compliance_date ?>
	<tr id="r_rbi_compliance_date">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_rbi_compliance_date"><?php echo $purchase_a->rbi_compliance_date->caption() ?></span></td>
		<td data-name="rbi_compliance_date"<?php echo $purchase_a->rbi_compliance_date->cellAttributes() ?>>
<span id="el_purchase_a_rbi_compliance_date">
<span<?php echo $purchase_a->rbi_compliance_date->viewAttributes() ?>>
<?php echo $purchase_a->rbi_compliance_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_a->age->Visible) { // age ?>
	<tr id="r_age">
		<td class="<?php echo $purchase_a_view->TableLeftColumnClass ?>"><span id="elh_purchase_a_age"><?php echo $purchase_a->age->caption() ?></span></td>
		<td data-name="age"<?php echo $purchase_a->age->cellAttributes() ?>>
<span id="el_purchase_a_age">
<span<?php echo $purchase_a->age->viewAttributes() ?>>
<?php echo $purchase_a->age->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$purchase_a_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$purchase_a->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$purchase_a_view->terminate();
?>