<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$purchase_l_audit_old_list = new purchase_l_audit_old_list();

// Run the page
$purchase_l_audit_old_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$purchase_l_audit_old_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$purchase_l_audit_old->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpurchase_l_audit_oldlist = currentForm = new ew.Form("fpurchase_l_audit_oldlist", "list");
fpurchase_l_audit_oldlist.formKeyCountName = '<?php echo $purchase_l_audit_old_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpurchase_l_audit_oldlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_l_audit_oldlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_l_audit_oldlist.lists["x_supplier"] = <?php echo $purchase_l_audit_old_list->supplier->Lookup->toClientList() ?>;
fpurchase_l_audit_oldlist.lists["x_supplier"].options = <?php echo JsonEncode($purchase_l_audit_old_list->supplier->lookupOptions()) ?>;
fpurchase_l_audit_oldlist.autoSuggests["x_supplier"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_l_audit_oldlist.lists["x_company_id"] = <?php echo $purchase_l_audit_old_list->company_id->Lookup->toClientList() ?>;
fpurchase_l_audit_oldlist.lists["x_company_id"].options = <?php echo JsonEncode($purchase_l_audit_old_list->company_id->lookupOptions()) ?>;
fpurchase_l_audit_oldlist.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_l_audit_oldlist.lists["x_type"] = <?php echo $purchase_l_audit_old_list->type->Lookup->toClientList() ?>;
fpurchase_l_audit_oldlist.lists["x_type"].options = <?php echo JsonEncode($purchase_l_audit_old_list->type->lookupOptions()) ?>;
fpurchase_l_audit_oldlist.lists["x_rid"] = <?php echo $purchase_l_audit_old_list->rid->Lookup->toClientList() ?>;
fpurchase_l_audit_oldlist.lists["x_rid"].options = <?php echo JsonEncode($purchase_l_audit_old_list->rid->lookupOptions()) ?>;
fpurchase_l_audit_oldlist.lists["x_lot_no"] = <?php echo $purchase_l_audit_old_list->lot_no->Lookup->toClientList() ?>;
fpurchase_l_audit_oldlist.lists["x_lot_no"].options = <?php echo JsonEncode($purchase_l_audit_old_list->lot_no->lookupOptions()) ?>;
fpurchase_l_audit_oldlist.autoSuggests["x_lot_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_l_audit_oldlist.lists["x_packing_type"] = <?php echo $purchase_l_audit_old_list->packing_type->Lookup->toClientList() ?>;
fpurchase_l_audit_oldlist.lists["x_packing_type"].options = <?php echo JsonEncode($purchase_l_audit_old_list->packing_type->lookupOptions()) ?>;
fpurchase_l_audit_oldlist.lists["x_godown"] = <?php echo $purchase_l_audit_old_list->godown->Lookup->toClientList() ?>;
fpurchase_l_audit_oldlist.lists["x_godown"].options = <?php echo JsonEncode($purchase_l_audit_old_list->godown->lookupOptions()) ?>;
fpurchase_l_audit_oldlist.lists["x_operator"] = <?php echo $purchase_l_audit_old_list->operator->Lookup->toClientList() ?>;
fpurchase_l_audit_oldlist.lists["x_operator"].options = <?php echo JsonEncode($purchase_l_audit_old_list->operator->lookupOptions()) ?>;
fpurchase_l_audit_oldlist.lists["x_audit"] = <?php echo $purchase_l_audit_old_list->audit->Lookup->toClientList() ?>;
fpurchase_l_audit_oldlist.lists["x_audit"].options = <?php echo JsonEncode($purchase_l_audit_old_list->audit->options(FALSE, TRUE)) ?>;

// Form object for search
var fpurchase_l_audit_oldlistsrch = currentSearchForm = new ew.Form("fpurchase_l_audit_oldlistsrch");

// Validate function for search
fpurchase_l_audit_oldlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_supplier");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l_audit_old->supplier->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpurchase_l_audit_oldlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_l_audit_oldlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_l_audit_oldlistsrch.lists["x_supplier"] = <?php echo $purchase_l_audit_old_list->supplier->Lookup->toClientList() ?>;
fpurchase_l_audit_oldlistsrch.lists["x_supplier"].options = <?php echo JsonEncode($purchase_l_audit_old_list->supplier->lookupOptions()) ?>;
fpurchase_l_audit_oldlistsrch.autoSuggests["x_supplier"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_l_audit_oldlistsrch.lists["x_type"] = <?php echo $purchase_l_audit_old_list->type->Lookup->toClientList() ?>;
fpurchase_l_audit_oldlistsrch.lists["x_type"].options = <?php echo JsonEncode($purchase_l_audit_old_list->type->lookupOptions()) ?>;
fpurchase_l_audit_oldlistsrch.lists["x_audit"] = <?php echo $purchase_l_audit_old_list->audit->Lookup->toClientList() ?>;
fpurchase_l_audit_oldlistsrch.lists["x_audit"].options = <?php echo JsonEncode($purchase_l_audit_old_list->audit->options(FALSE, TRUE)) ?>;

// Filters
fpurchase_l_audit_oldlistsrch.filterList = <?php echo $purchase_l_audit_old_list->getFilterList() ?>;

// Init search panel as collapsed
fpurchase_l_audit_oldlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$purchase_l_audit_old->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($purchase_l_audit_old_list->TotalRecs > 0 && $purchase_l_audit_old_list->ExportOptions->visible()) { ?>
<?php $purchase_l_audit_old_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($purchase_l_audit_old_list->ImportOptions->visible()) { ?>
<?php $purchase_l_audit_old_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($purchase_l_audit_old_list->SearchOptions->visible()) { ?>
<?php $purchase_l_audit_old_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($purchase_l_audit_old_list->FilterOptions->visible()) { ?>
<?php $purchase_l_audit_old_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$purchase_l_audit_old_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$purchase_l_audit_old->isExport() && !$purchase_l_audit_old->CurrentAction) { ?>
<form name="fpurchase_l_audit_oldlistsrch" id="fpurchase_l_audit_oldlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($purchase_l_audit_old_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpurchase_l_audit_oldlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="purchase_l_audit_old">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$purchase_l_audit_old_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$purchase_l_audit_old->RowType = ROWTYPE_SEARCH;

// Render row
$purchase_l_audit_old->resetAttributes();
$purchase_l_audit_old_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($purchase_l_audit_old->supplier->Visible) { // supplier ?>
	<div id="xsc_supplier" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $purchase_l_audit_old->supplier->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_supplier" id="z_supplier" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$purchase_l_audit_old->supplier->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l_audit_old->supplier->EditAttrs["onchange"] = "";
?>
<span id="as_x_supplier" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_supplier" id="sv_x_supplier" value="<?php echo RemoveHtml($purchase_l_audit_old->supplier->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->supplier->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l_audit_old->supplier->getPlaceHolder()) ?>"<?php echo $purchase_l_audit_old->supplier->editAttributes() ?>>
</span>
<input type="hidden" data-table="purchase_l_audit_old" data-field="x_supplier" data-value-separator="<?php echo $purchase_l_audit_old->supplier->displayValueSeparatorAttribute() ?>" name="x_supplier" id="x_supplier" value="<?php echo HtmlEncode($purchase_l_audit_old->supplier->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_l_audit_oldlistsrch.createAutoSuggest({"id":"x_supplier","forceSelect":true});
</script>
<?php echo $purchase_l_audit_old->supplier->Lookup->getParamTag("p_x_supplier") ?>
</span>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->type->Visible) { // type ?>
	<div id="xsc_type" class="ew-cell form-group">
		<label for="x_type" class="ew-search-caption ew-label"><?php echo $purchase_l_audit_old->type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit_old" data-field="x_type" data-value-separator="<?php echo $purchase_l_audit_old->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $purchase_l_audit_old->type->editAttributes() ?>>
		<?php echo $purchase_l_audit_old->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $purchase_l_audit_old->type->Lookup->getParamTag("p_x_type") ?>
</span>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->invoice_details->Visible) { // invoice_details ?>
	<div id="xsc_invoice_details" class="ew-cell form-group">
		<label for="x_invoice_details" class="ew-search-caption ew-label"><?php echo $purchase_l_audit_old->invoice_details->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_invoice_details" id="z_invoice_details" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="purchase_l_audit_old" data-field="x_invoice_details" name="x_invoice_details" id="x_invoice_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->invoice_details->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->invoice_details->EditValue ?>"<?php echo $purchase_l_audit_old->invoice_details->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($purchase_l_audit_old->audit->Visible) { // audit ?>
	<div id="xsc_audit" class="ew-cell form-group">
		<label for="x_audit" class="ew-search-caption ew-label"><?php echo $purchase_l_audit_old->audit->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_audit" id="z_audit" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit_old" data-field="x_audit" data-value-separator="<?php echo $purchase_l_audit_old->audit->displayValueSeparatorAttribute() ?>" id="x_audit" name="x_audit"<?php echo $purchase_l_audit_old->audit->editAttributes() ?>>
		<?php echo $purchase_l_audit_old->audit->selectOptionListHtml("x_audit") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($purchase_l_audit_old_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($purchase_l_audit_old_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $purchase_l_audit_old_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($purchase_l_audit_old_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($purchase_l_audit_old_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($purchase_l_audit_old_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($purchase_l_audit_old_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $purchase_l_audit_old_list->showPageHeader(); ?>
<?php
$purchase_l_audit_old_list->showMessage();
?>
<?php if ($purchase_l_audit_old_list->TotalRecs > 0 || $purchase_l_audit_old->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($purchase_l_audit_old_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> purchase_l_audit_old">
<?php if (!$purchase_l_audit_old->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$purchase_l_audit_old->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($purchase_l_audit_old_list->Pager)) $purchase_l_audit_old_list->Pager = new PrevNextPager($purchase_l_audit_old_list->StartRec, $purchase_l_audit_old_list->DisplayRecs, $purchase_l_audit_old_list->TotalRecs, $purchase_l_audit_old_list->AutoHidePager) ?>
<?php if ($purchase_l_audit_old_list->Pager->RecordCount > 0 && $purchase_l_audit_old_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($purchase_l_audit_old_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $purchase_l_audit_old_list->pageUrl() ?>start=<?php echo $purchase_l_audit_old_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($purchase_l_audit_old_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $purchase_l_audit_old_list->pageUrl() ?>start=<?php echo $purchase_l_audit_old_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $purchase_l_audit_old_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($purchase_l_audit_old_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $purchase_l_audit_old_list->pageUrl() ?>start=<?php echo $purchase_l_audit_old_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($purchase_l_audit_old_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $purchase_l_audit_old_list->pageUrl() ?>start=<?php echo $purchase_l_audit_old_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $purchase_l_audit_old_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($purchase_l_audit_old_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $purchase_l_audit_old_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $purchase_l_audit_old_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $purchase_l_audit_old_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($purchase_l_audit_old_list->TotalRecs > 0 && (!$purchase_l_audit_old_list->AutoHidePageSizeSelector || $purchase_l_audit_old_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="purchase_l_audit_old">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($purchase_l_audit_old_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($purchase_l_audit_old_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($purchase_l_audit_old_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($purchase_l_audit_old_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($purchase_l_audit_old_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($purchase_l_audit_old->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $purchase_l_audit_old_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpurchase_l_audit_oldlist" id="fpurchase_l_audit_oldlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($purchase_l_audit_old_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $purchase_l_audit_old_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="purchase_l_audit_old">
<div id="gmp_purchase_l_audit_old" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($purchase_l_audit_old_list->TotalRecs > 0 || $purchase_l_audit_old->isGridEdit()) { ?>
<table id="tbl_purchase_l_audit_oldlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$purchase_l_audit_old_list->RowType = ROWTYPE_HEADER;

// Render list options
$purchase_l_audit_old_list->renderListOptions();

// Render list options (header, left)
$purchase_l_audit_old_list->ListOptions->render("header", "left");
?>
<?php if ($purchase_l_audit_old->id->Visible) { // id ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->id) == "") { ?>
		<th data-name="id" class="<?php echo $purchase_l_audit_old->id->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_id" class="purchase_l_audit_old_id"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $purchase_l_audit_old->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->id) ?>',2);"><div id="elh_purchase_l_audit_old_id" class="purchase_l_audit_old_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->supplier->Visible) { // supplier ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->supplier) == "") { ?>
		<th data-name="supplier" class="<?php echo $purchase_l_audit_old->supplier->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_supplier" class="purchase_l_audit_old_supplier"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->supplier->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="supplier" class="<?php echo $purchase_l_audit_old->supplier->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->supplier) ?>',2);"><div id="elh_purchase_l_audit_old_supplier" class="purchase_l_audit_old_supplier">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->supplier->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->supplier->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->supplier->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->company_id->Visible) { // company_id ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $purchase_l_audit_old->company_id->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_company_id" class="purchase_l_audit_old_company_id"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $purchase_l_audit_old->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->company_id) ?>',2);"><div id="elh_purchase_l_audit_old_company_id" class="purchase_l_audit_old_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->type->Visible) { // type ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->type) == "") { ?>
		<th data-name="type" class="<?php echo $purchase_l_audit_old->type->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_type" class="purchase_l_audit_old_type"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $purchase_l_audit_old->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->type) ?>',2);"><div id="elh_purchase_l_audit_old_type" class="purchase_l_audit_old_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->rid->Visible) { // rid ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $purchase_l_audit_old->rid->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_rid" class="purchase_l_audit_old_rid"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $purchase_l_audit_old->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->rid) ?>',2);"><div id="elh_purchase_l_audit_old_rid" class="purchase_l_audit_old_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->rid->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->lot_no->Visible) { // lot_no ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $purchase_l_audit_old->lot_no->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_lot_no" class="purchase_l_audit_old_lot_no"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $purchase_l_audit_old->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->lot_no) ?>',2);"><div id="elh_purchase_l_audit_old_lot_no" class="purchase_l_audit_old_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->_barcode->Visible) { // barcode ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $purchase_l_audit_old->_barcode->headerCellClass() ?>"><div id="elh_purchase_l_audit_old__barcode" class="purchase_l_audit_old__barcode"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $purchase_l_audit_old->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->_barcode) ?>',2);"><div id="elh_purchase_l_audit_old__barcode" class="purchase_l_audit_old__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->net_weight->Visible) { // net_weight ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->net_weight) == "") { ?>
		<th data-name="net_weight" class="<?php echo $purchase_l_audit_old->net_weight->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_net_weight" class="purchase_l_audit_old_net_weight"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->net_weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="net_weight" class="<?php echo $purchase_l_audit_old->net_weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->net_weight) ?>',2);"><div id="elh_purchase_l_audit_old_net_weight" class="purchase_l_audit_old_net_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->net_weight->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->net_weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->net_weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->packets->Visible) { // packets ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $purchase_l_audit_old->packets->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_packets" class="purchase_l_audit_old_packets"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $purchase_l_audit_old->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->packets) ?>',2);"><div id="elh_purchase_l_audit_old_packets" class="purchase_l_audit_old_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->packets->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->packing_type->Visible) { // packing_type ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $purchase_l_audit_old->packing_type->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_packing_type" class="purchase_l_audit_old_packing_type"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $purchase_l_audit_old->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->packing_type) ?>',2);"><div id="elh_purchase_l_audit_old_packing_type" class="purchase_l_audit_old_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->amount->Visible) { // amount ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $purchase_l_audit_old->amount->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_amount" class="purchase_l_audit_old_amount"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $purchase_l_audit_old->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->amount) ?>',2);"><div id="elh_purchase_l_audit_old_amount" class="purchase_l_audit_old_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->godown->Visible) { // godown ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $purchase_l_audit_old->godown->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_godown" class="purchase_l_audit_old_godown"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $purchase_l_audit_old->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->godown) ?>',2);"><div id="elh_purchase_l_audit_old_godown" class="purchase_l_audit_old_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->dated->Visible) { // dated ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $purchase_l_audit_old->dated->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_dated" class="purchase_l_audit_old_dated"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $purchase_l_audit_old->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->dated) ?>',2);"><div id="elh_purchase_l_audit_old_dated" class="purchase_l_audit_old_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->goods_inward->Visible) { // goods_inward ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->goods_inward) == "") { ?>
		<th data-name="goods_inward" class="<?php echo $purchase_l_audit_old->goods_inward->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_goods_inward" class="purchase_l_audit_old_goods_inward"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->goods_inward->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="goods_inward" class="<?php echo $purchase_l_audit_old->goods_inward->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->goods_inward) ?>',2);"><div id="elh_purchase_l_audit_old_goods_inward" class="purchase_l_audit_old_goods_inward">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->goods_inward->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->goods_inward->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->goods_inward->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->invoice_details->Visible) { // invoice_details ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->invoice_details) == "") { ?>
		<th data-name="invoice_details" class="<?php echo $purchase_l_audit_old->invoice_details->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_invoice_details" class="purchase_l_audit_old_invoice_details"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->invoice_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="invoice_details" class="<?php echo $purchase_l_audit_old->invoice_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->invoice_details) ?>',2);"><div id="elh_purchase_l_audit_old_invoice_details" class="purchase_l_audit_old_invoice_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->invoice_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->invoice_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->invoice_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->invoice_dated->Visible) { // invoice_dated ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->invoice_dated) == "") { ?>
		<th data-name="invoice_dated" class="<?php echo $purchase_l_audit_old->invoice_dated->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_invoice_dated" class="purchase_l_audit_old_invoice_dated"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->invoice_dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="invoice_dated" class="<?php echo $purchase_l_audit_old->invoice_dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->invoice_dated) ?>',2);"><div id="elh_purchase_l_audit_old_invoice_dated" class="purchase_l_audit_old_invoice_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->invoice_dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->invoice_dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->invoice_dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->return_details->Visible) { // return_details ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->return_details) == "") { ?>
		<th data-name="return_details" class="<?php echo $purchase_l_audit_old->return_details->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_return_details" class="purchase_l_audit_old_return_details"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->return_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="return_details" class="<?php echo $purchase_l_audit_old->return_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->return_details) ?>',2);"><div id="elh_purchase_l_audit_old_return_details" class="purchase_l_audit_old_return_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->return_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->return_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->return_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->operator->Visible) { // operator ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $purchase_l_audit_old->operator->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_operator" class="purchase_l_audit_old_operator"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $purchase_l_audit_old->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->operator) ?>',2);"><div id="elh_purchase_l_audit_old_operator" class="purchase_l_audit_old_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->datetime->Visible) { // datetime ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $purchase_l_audit_old->datetime->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_datetime" class="purchase_l_audit_old_datetime"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $purchase_l_audit_old->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->datetime) ?>',2);"><div id="elh_purchase_l_audit_old_datetime" class="purchase_l_audit_old_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->remarks->Visible) { // remarks ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $purchase_l_audit_old->remarks->headerCellClass() ?>"><div id="elh_purchase_l_audit_old_remarks" class="purchase_l_audit_old_remarks"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $purchase_l_audit_old->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->remarks) ?>',2);"><div id="elh_purchase_l_audit_old_remarks" class="purchase_l_audit_old_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->audit->Visible) { // audit ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->audit) == "") { ?>
		<th data-name="audit" class="<?php echo $purchase_l_audit_old->audit->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_purchase_l_audit_old_audit" class="purchase_l_audit_old_audit"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->audit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="audit" class="<?php echo $purchase_l_audit_old->audit->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->audit) ?>',2);"><div id="elh_purchase_l_audit_old_audit" class="purchase_l_audit_old_audit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->audit->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->audit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->audit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->a_operator->Visible) { // a_operator ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $purchase_l_audit_old->a_operator->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_purchase_l_audit_old_a_operator" class="purchase_l_audit_old_a_operator"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $purchase_l_audit_old->a_operator->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->a_operator) ?>',2);"><div id="elh_purchase_l_audit_old_a_operator" class="purchase_l_audit_old_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_audit_old->a_datetime->Visible) { // a_datetime ?>
	<?php if ($purchase_l_audit_old->sortUrl($purchase_l_audit_old->a_datetime) == "") { ?>
		<th data-name="a_datetime" class="<?php echo $purchase_l_audit_old->a_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_purchase_l_audit_old_a_datetime" class="purchase_l_audit_old_a_datetime"><div class="ew-table-header-caption"><?php echo $purchase_l_audit_old->a_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_datetime" class="<?php echo $purchase_l_audit_old->a_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_audit_old->SortUrl($purchase_l_audit_old->a_datetime) ?>',2);"><div id="elh_purchase_l_audit_old_a_datetime" class="purchase_l_audit_old_a_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_audit_old->a_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_audit_old->a_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_audit_old->a_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$purchase_l_audit_old_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($purchase_l_audit_old->ExportAll && $purchase_l_audit_old->isExport()) {
	$purchase_l_audit_old_list->StopRec = $purchase_l_audit_old_list->TotalRecs;
} else {

	// Set the last record to display
	if ($purchase_l_audit_old_list->TotalRecs > $purchase_l_audit_old_list->StartRec + $purchase_l_audit_old_list->DisplayRecs - 1)
		$purchase_l_audit_old_list->StopRec = $purchase_l_audit_old_list->StartRec + $purchase_l_audit_old_list->DisplayRecs - 1;
	else
		$purchase_l_audit_old_list->StopRec = $purchase_l_audit_old_list->TotalRecs;
}
$purchase_l_audit_old_list->RecCnt = $purchase_l_audit_old_list->StartRec - 1;
if ($purchase_l_audit_old_list->Recordset && !$purchase_l_audit_old_list->Recordset->EOF) {
	$purchase_l_audit_old_list->Recordset->moveFirst();
	$selectLimit = $purchase_l_audit_old_list->UseSelectLimit;
	if (!$selectLimit && $purchase_l_audit_old_list->StartRec > 1)
		$purchase_l_audit_old_list->Recordset->move($purchase_l_audit_old_list->StartRec - 1);
} elseif (!$purchase_l_audit_old->AllowAddDeleteRow && $purchase_l_audit_old_list->StopRec == 0) {
	$purchase_l_audit_old_list->StopRec = $purchase_l_audit_old->GridAddRowCount;
}

// Initialize aggregate
$purchase_l_audit_old->RowType = ROWTYPE_AGGREGATEINIT;
$purchase_l_audit_old->resetAttributes();
$purchase_l_audit_old_list->renderRow();
while ($purchase_l_audit_old_list->RecCnt < $purchase_l_audit_old_list->StopRec) {
	$purchase_l_audit_old_list->RecCnt++;
	if ($purchase_l_audit_old_list->RecCnt >= $purchase_l_audit_old_list->StartRec) {
		$purchase_l_audit_old_list->RowCnt++;

		// Set up key count
		$purchase_l_audit_old_list->KeyCount = $purchase_l_audit_old_list->RowIndex;

		// Init row class and style
		$purchase_l_audit_old->resetAttributes();
		$purchase_l_audit_old->CssClass = "";
		if ($purchase_l_audit_old->isGridAdd()) {
		} else {
			$purchase_l_audit_old_list->loadRowValues($purchase_l_audit_old_list->Recordset); // Load row values
		}
		$purchase_l_audit_old->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$purchase_l_audit_old->RowAttrs = array_merge($purchase_l_audit_old->RowAttrs, array('data-rowindex'=>$purchase_l_audit_old_list->RowCnt, 'id'=>'r' . $purchase_l_audit_old_list->RowCnt . '_purchase_l_audit_old', 'data-rowtype'=>$purchase_l_audit_old->RowType));

		// Render row
		$purchase_l_audit_old_list->renderRow();

		// Render list options
		$purchase_l_audit_old_list->renderListOptions();
?>
	<tr<?php echo $purchase_l_audit_old->rowAttributes() ?>>
<?php

// Render list options (body, left)
$purchase_l_audit_old_list->ListOptions->render("body", "left", $purchase_l_audit_old_list->RowCnt);
?>
	<?php if ($purchase_l_audit_old->id->Visible) { // id ?>
		<td data-name="id"<?php echo $purchase_l_audit_old->id->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_id" class="purchase_l_audit_old_id">
<span<?php echo $purchase_l_audit_old->id->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->supplier->Visible) { // supplier ?>
		<td data-name="supplier"<?php echo $purchase_l_audit_old->supplier->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_supplier" class="purchase_l_audit_old_supplier">
<span<?php echo $purchase_l_audit_old->supplier->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l_audit_old->supplier->getViewValue())) && $purchase_l_audit_old->supplier->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l_audit_old->supplier->linkAttributes() ?>><?php echo $purchase_l_audit_old->supplier->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l_audit_old->supplier->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $purchase_l_audit_old->company_id->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_company_id" class="purchase_l_audit_old_company_id">
<span<?php echo $purchase_l_audit_old->company_id->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->type->Visible) { // type ?>
		<td data-name="type"<?php echo $purchase_l_audit_old->type->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_type" class="purchase_l_audit_old_type">
<span<?php echo $purchase_l_audit_old->type->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $purchase_l_audit_old->rid->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_rid" class="purchase_l_audit_old_rid">
<span<?php echo $purchase_l_audit_old->rid->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l_audit_old->rid->getViewValue())) && $purchase_l_audit_old->rid->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l_audit_old->rid->linkAttributes() ?>><?php echo $purchase_l_audit_old->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l_audit_old->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $purchase_l_audit_old->lot_no->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_lot_no" class="purchase_l_audit_old_lot_no">
<span<?php echo $purchase_l_audit_old->lot_no->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $purchase_l_audit_old->_barcode->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old__barcode" class="purchase_l_audit_old__barcode">
<span<?php echo $purchase_l_audit_old->_barcode->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->net_weight->Visible) { // net_weight ?>
		<td data-name="net_weight"<?php echo $purchase_l_audit_old->net_weight->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_net_weight" class="purchase_l_audit_old_net_weight">
<span<?php echo $purchase_l_audit_old->net_weight->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->net_weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $purchase_l_audit_old->packets->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_packets" class="purchase_l_audit_old_packets">
<span<?php echo $purchase_l_audit_old->packets->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $purchase_l_audit_old->packing_type->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_packing_type" class="purchase_l_audit_old_packing_type">
<span<?php echo $purchase_l_audit_old->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l_audit_old->packing_type->getViewValue())) && $purchase_l_audit_old->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l_audit_old->packing_type->linkAttributes() ?>><?php echo $purchase_l_audit_old->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l_audit_old->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $purchase_l_audit_old->amount->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_amount" class="purchase_l_audit_old_amount">
<span<?php echo $purchase_l_audit_old->amount->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $purchase_l_audit_old->godown->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_godown" class="purchase_l_audit_old_godown">
<span<?php echo $purchase_l_audit_old->godown->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l_audit_old->godown->getViewValue())) && $purchase_l_audit_old->godown->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l_audit_old->godown->linkAttributes() ?>><?php echo $purchase_l_audit_old->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l_audit_old->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $purchase_l_audit_old->dated->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_dated" class="purchase_l_audit_old_dated">
<span<?php echo $purchase_l_audit_old->dated->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->goods_inward->Visible) { // goods_inward ?>
		<td data-name="goods_inward"<?php echo $purchase_l_audit_old->goods_inward->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_goods_inward" class="purchase_l_audit_old_goods_inward">
<span<?php echo $purchase_l_audit_old->goods_inward->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->goods_inward->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->invoice_details->Visible) { // invoice_details ?>
		<td data-name="invoice_details"<?php echo $purchase_l_audit_old->invoice_details->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_invoice_details" class="purchase_l_audit_old_invoice_details">
<span<?php echo $purchase_l_audit_old->invoice_details->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l_audit_old->invoice_details->getViewValue())) && $purchase_l_audit_old->invoice_details->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l_audit_old->invoice_details->linkAttributes() ?>><?php echo $purchase_l_audit_old->invoice_details->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l_audit_old->invoice_details->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->invoice_dated->Visible) { // invoice_dated ?>
		<td data-name="invoice_dated"<?php echo $purchase_l_audit_old->invoice_dated->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_invoice_dated" class="purchase_l_audit_old_invoice_dated">
<span<?php echo $purchase_l_audit_old->invoice_dated->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l_audit_old->invoice_dated->getViewValue())) && $purchase_l_audit_old->invoice_dated->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l_audit_old->invoice_dated->linkAttributes() ?>><?php echo $purchase_l_audit_old->invoice_dated->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l_audit_old->invoice_dated->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->return_details->Visible) { // return_details ?>
		<td data-name="return_details"<?php echo $purchase_l_audit_old->return_details->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_return_details" class="purchase_l_audit_old_return_details">
<span<?php echo $purchase_l_audit_old->return_details->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->return_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $purchase_l_audit_old->operator->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_operator" class="purchase_l_audit_old_operator">
<span<?php echo $purchase_l_audit_old->operator->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $purchase_l_audit_old->datetime->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_datetime" class="purchase_l_audit_old_datetime">
<span<?php echo $purchase_l_audit_old->datetime->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $purchase_l_audit_old->remarks->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_remarks" class="purchase_l_audit_old_remarks">
<span<?php echo $purchase_l_audit_old->remarks->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->audit->Visible) { // audit ?>
		<td data-name="audit"<?php echo $purchase_l_audit_old->audit->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_audit" class="purchase_l_audit_old_audit">
<span<?php echo $purchase_l_audit_old->audit->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->audit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $purchase_l_audit_old->a_operator->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_a_operator" class="purchase_l_audit_old_a_operator">
<span<?php echo $purchase_l_audit_old->a_operator->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->a_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime"<?php echo $purchase_l_audit_old->a_datetime->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_audit_old_list->RowCnt ?>_purchase_l_audit_old_a_datetime" class="purchase_l_audit_old_a_datetime">
<span<?php echo $purchase_l_audit_old->a_datetime->viewAttributes() ?>>
<?php echo $purchase_l_audit_old->a_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$purchase_l_audit_old_list->ListOptions->render("body", "right", $purchase_l_audit_old_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$purchase_l_audit_old->isGridAdd())
		$purchase_l_audit_old_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$purchase_l_audit_old->RowType = ROWTYPE_AGGREGATE;
$purchase_l_audit_old->resetAttributes();
$purchase_l_audit_old_list->renderRow();
?>
<?php if ($purchase_l_audit_old_list->TotalRecs > 0 && !$purchase_l_audit_old->isGridAdd() && !$purchase_l_audit_old->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$purchase_l_audit_old_list->renderListOptions();

// Render list options (footer, left)
$purchase_l_audit_old_list->ListOptions->render("footer", "left");
?>
	<?php if ($purchase_l_audit_old->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $purchase_l_audit_old->id->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_id" class="purchase_l_audit_old_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->supplier->Visible) { // supplier ?>
		<td data-name="supplier" class="<?php echo $purchase_l_audit_old->supplier->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_supplier" class="purchase_l_audit_old_supplier">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $purchase_l_audit_old->company_id->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_company_id" class="purchase_l_audit_old_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $purchase_l_audit_old->type->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_type" class="purchase_l_audit_old_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $purchase_l_audit_old->rid->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_rid" class="purchase_l_audit_old_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $purchase_l_audit_old->lot_no->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_lot_no" class="purchase_l_audit_old_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode" class="<?php echo $purchase_l_audit_old->_barcode->footerCellClass() ?>"><span id="elf_purchase_l_audit_old__barcode" class="purchase_l_audit_old__barcode">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->net_weight->Visible) { // net_weight ?>
		<td data-name="net_weight" class="<?php echo $purchase_l_audit_old->net_weight->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_net_weight" class="purchase_l_audit_old_net_weight">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $purchase_l_audit_old->net_weight->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $purchase_l_audit_old->packets->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_packets" class="purchase_l_audit_old_packets">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $purchase_l_audit_old->packets->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $purchase_l_audit_old->packing_type->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_packing_type" class="purchase_l_audit_old_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->amount->Visible) { // amount ?>
		<td data-name="amount" class="<?php echo $purchase_l_audit_old->amount->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_amount" class="purchase_l_audit_old_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $purchase_l_audit_old->amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $purchase_l_audit_old->godown->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_godown" class="purchase_l_audit_old_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $purchase_l_audit_old->dated->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_dated" class="purchase_l_audit_old_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->goods_inward->Visible) { // goods_inward ?>
		<td data-name="goods_inward" class="<?php echo $purchase_l_audit_old->goods_inward->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_goods_inward" class="purchase_l_audit_old_goods_inward">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->invoice_details->Visible) { // invoice_details ?>
		<td data-name="invoice_details" class="<?php echo $purchase_l_audit_old->invoice_details->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_invoice_details" class="purchase_l_audit_old_invoice_details">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->invoice_dated->Visible) { // invoice_dated ?>
		<td data-name="invoice_dated" class="<?php echo $purchase_l_audit_old->invoice_dated->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_invoice_dated" class="purchase_l_audit_old_invoice_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->return_details->Visible) { // return_details ?>
		<td data-name="return_details" class="<?php echo $purchase_l_audit_old->return_details->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_return_details" class="purchase_l_audit_old_return_details">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $purchase_l_audit_old->operator->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_operator" class="purchase_l_audit_old_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $purchase_l_audit_old->datetime->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_datetime" class="purchase_l_audit_old_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $purchase_l_audit_old->remarks->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_remarks" class="purchase_l_audit_old_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->audit->Visible) { // audit ?>
		<td data-name="audit" class="<?php echo $purchase_l_audit_old->audit->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_audit" class="purchase_l_audit_old_audit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator" class="<?php echo $purchase_l_audit_old->a_operator->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_a_operator" class="purchase_l_audit_old_a_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l_audit_old->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime" class="<?php echo $purchase_l_audit_old->a_datetime->footerCellClass() ?>"><span id="elf_purchase_l_audit_old_a_datetime" class="purchase_l_audit_old_a_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$purchase_l_audit_old_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$purchase_l_audit_old->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($purchase_l_audit_old_list->Recordset)
	$purchase_l_audit_old_list->Recordset->Close();
?>
<?php if (!$purchase_l_audit_old->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$purchase_l_audit_old->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($purchase_l_audit_old_list->Pager)) $purchase_l_audit_old_list->Pager = new PrevNextPager($purchase_l_audit_old_list->StartRec, $purchase_l_audit_old_list->DisplayRecs, $purchase_l_audit_old_list->TotalRecs, $purchase_l_audit_old_list->AutoHidePager) ?>
<?php if ($purchase_l_audit_old_list->Pager->RecordCount > 0 && $purchase_l_audit_old_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($purchase_l_audit_old_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $purchase_l_audit_old_list->pageUrl() ?>start=<?php echo $purchase_l_audit_old_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($purchase_l_audit_old_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $purchase_l_audit_old_list->pageUrl() ?>start=<?php echo $purchase_l_audit_old_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $purchase_l_audit_old_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($purchase_l_audit_old_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $purchase_l_audit_old_list->pageUrl() ?>start=<?php echo $purchase_l_audit_old_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($purchase_l_audit_old_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $purchase_l_audit_old_list->pageUrl() ?>start=<?php echo $purchase_l_audit_old_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $purchase_l_audit_old_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($purchase_l_audit_old_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $purchase_l_audit_old_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $purchase_l_audit_old_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $purchase_l_audit_old_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($purchase_l_audit_old_list->TotalRecs > 0 && (!$purchase_l_audit_old_list->AutoHidePageSizeSelector || $purchase_l_audit_old_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="purchase_l_audit_old">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($purchase_l_audit_old_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($purchase_l_audit_old_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($purchase_l_audit_old_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($purchase_l_audit_old_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($purchase_l_audit_old_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($purchase_l_audit_old->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $purchase_l_audit_old_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($purchase_l_audit_old_list->TotalRecs == 0 && !$purchase_l_audit_old->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $purchase_l_audit_old_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$purchase_l_audit_old_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$purchase_l_audit_old->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$purchase_l_audit_old_list->terminate();
?>