<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$purchase_l_audit_old_search = new purchase_l_audit_old_search();

// Run the page
$purchase_l_audit_old_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$purchase_l_audit_old_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($purchase_l_audit_old_search->IsModal) { ?>
var fpurchase_l_audit_oldsearch = currentAdvancedSearchForm = new ew.Form("fpurchase_l_audit_oldsearch", "search");
<?php } else { ?>
var fpurchase_l_audit_oldsearch = currentForm = new ew.Form("fpurchase_l_audit_oldsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpurchase_l_audit_oldsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_l_audit_oldsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_l_audit_oldsearch.lists["x_type"] = <?php echo $purchase_l_audit_old_search->type->Lookup->toClientList() ?>;
fpurchase_l_audit_oldsearch.lists["x_type"].options = <?php echo JsonEncode($purchase_l_audit_old_search->type->lookupOptions()) ?>;
fpurchase_l_audit_oldsearch.lists["x_rid"] = <?php echo $purchase_l_audit_old_search->rid->Lookup->toClientList() ?>;
fpurchase_l_audit_oldsearch.lists["x_rid"].options = <?php echo JsonEncode($purchase_l_audit_old_search->rid->lookupOptions()) ?>;
fpurchase_l_audit_oldsearch.lists["x_rid_return"] = <?php echo $purchase_l_audit_old_search->rid_return->Lookup->toClientList() ?>;
fpurchase_l_audit_oldsearch.lists["x_rid_return"].options = <?php echo JsonEncode($purchase_l_audit_old_search->rid_return->lookupOptions()) ?>;
fpurchase_l_audit_oldsearch.lists["x_grp"] = <?php echo $purchase_l_audit_old_search->grp->Lookup->toClientList() ?>;
fpurchase_l_audit_oldsearch.lists["x_grp"].options = <?php echo JsonEncode($purchase_l_audit_old_search->grp->lookupOptions()) ?>;
fpurchase_l_audit_oldsearch.lists["x_s_grp"] = <?php echo $purchase_l_audit_old_search->s_grp->Lookup->toClientList() ?>;
fpurchase_l_audit_oldsearch.lists["x_s_grp"].options = <?php echo JsonEncode($purchase_l_audit_old_search->s_grp->lookupOptions()) ?>;
fpurchase_l_audit_oldsearch.lists["x_product"] = <?php echo $purchase_l_audit_old_search->product->Lookup->toClientList() ?>;
fpurchase_l_audit_oldsearch.lists["x_product"].options = <?php echo JsonEncode($purchase_l_audit_old_search->product->lookupOptions()) ?>;
fpurchase_l_audit_oldsearch.lists["x_lot_no"] = <?php echo $purchase_l_audit_old_search->lot_no->Lookup->toClientList() ?>;
fpurchase_l_audit_oldsearch.lists["x_lot_no"].options = <?php echo JsonEncode($purchase_l_audit_old_search->lot_no->lookupOptions()) ?>;
fpurchase_l_audit_oldsearch.autoSuggests["x_lot_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_l_audit_oldsearch.lists["x_packing_type"] = <?php echo $purchase_l_audit_old_search->packing_type->Lookup->toClientList() ?>;
fpurchase_l_audit_oldsearch.lists["x_packing_type"].options = <?php echo JsonEncode($purchase_l_audit_old_search->packing_type->lookupOptions()) ?>;
fpurchase_l_audit_oldsearch.lists["x_godown"] = <?php echo $purchase_l_audit_old_search->godown->Lookup->toClientList() ?>;
fpurchase_l_audit_oldsearch.lists["x_godown"].options = <?php echo JsonEncode($purchase_l_audit_old_search->godown->lookupOptions()) ?>;
fpurchase_l_audit_oldsearch.lists["x_operator"] = <?php echo $purchase_l_audit_old_search->operator->Lookup->toClientList() ?>;
fpurchase_l_audit_oldsearch.lists["x_operator"].options = <?php echo JsonEncode($purchase_l_audit_old_search->operator->lookupOptions()) ?>;
fpurchase_l_audit_oldsearch.lists["x_audit"] = <?php echo $purchase_l_audit_old_search->audit->Lookup->toClientList() ?>;
fpurchase_l_audit_oldsearch.lists["x_audit"].options = <?php echo JsonEncode($purchase_l_audit_old_search->audit->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fpurchase_l_audit_oldsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l_audit_old->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_supplier");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l_audit_old->supplier->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_net_weight");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l_audit_old->net_weight->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l_audit_old->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__40");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l_audit_old->_40->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l_audit_old->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l_audit_old->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_a_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l_audit_old->a_operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_a_datetime");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l_audit_old->a_datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $purchase_l_audit_old_search->showPageHeader(); ?>
<?php
$purchase_l_audit_old_search->showMessage();
?>
<form name="fpurchase_l_audit_oldsearch" id="fpurchase_l_audit_oldsearch" class="<?php echo $purchase_l_audit_old_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($purchase_l_audit_old_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $purchase_l_audit_old_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="purchase_l_audit_old">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$purchase_l_audit_old_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($purchase_l_audit_old->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_id"><?php echo $purchase_l_audit_old->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->id->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_id">
<input type="text" data-table="purchase_l_audit_old" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->id->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->id->EditValue ?>"<?php echo $purchase_l_audit_old->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_type"><?php echo $purchase_l_audit_old->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->type->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit_old" data-field="x_type" data-value-separator="<?php echo $purchase_l_audit_old->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $purchase_l_audit_old->type->editAttributes() ?>>
		<?php echo $purchase_l_audit_old->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $purchase_l_audit_old->type->Lookup->getParamTag("p_x_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label for="x_rid" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_rid"><?php echo $purchase_l_audit_old->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->rid->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_rid">
<input type="text" data-table="purchase_l_audit_old" data-field="x_rid" name="x_rid" id="x_rid" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->rid->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->rid->EditValue ?>"<?php echo $purchase_l_audit_old->rid->editAttributes() ?>>
<?php echo $purchase_l_audit_old->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->rid_return->Visible) { // rid_return ?>
	<div id="r_rid_return" class="form-group row">
		<label for="x_rid_return" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_rid_return"><?php echo $purchase_l_audit_old->rid_return->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid_return" id="z_rid_return" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->rid_return->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_rid_return">
<input type="text" data-table="purchase_l_audit_old" data-field="x_rid_return" name="x_rid_return" id="x_rid_return" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->rid_return->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->rid_return->EditValue ?>"<?php echo $purchase_l_audit_old->rid_return->editAttributes() ?>>
<?php echo $purchase_l_audit_old->rid_return->Lookup->getParamTag("p_x_rid_return") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_grp"><?php echo $purchase_l_audit_old->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->grp->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_grp">
<?php $purchase_l_audit_old->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$purchase_l_audit_old->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit_old" data-field="x_grp" data-value-separator="<?php echo $purchase_l_audit_old->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $purchase_l_audit_old->grp->editAttributes() ?>>
		<?php echo $purchase_l_audit_old->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $purchase_l_audit_old->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_s_grp"><?php echo $purchase_l_audit_old->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->s_grp->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_s_grp">
<?php $purchase_l_audit_old->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$purchase_l_audit_old->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit_old" data-field="x_s_grp" data-value-separator="<?php echo $purchase_l_audit_old->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $purchase_l_audit_old->s_grp->editAttributes() ?>>
		<?php echo $purchase_l_audit_old->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $purchase_l_audit_old->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_product"><?php echo $purchase_l_audit_old->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->product->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_product">
<?php $purchase_l_audit_old->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$purchase_l_audit_old->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit_old" data-field="x_product" data-value-separator="<?php echo $purchase_l_audit_old->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $purchase_l_audit_old->product->editAttributes() ?>>
		<?php echo $purchase_l_audit_old->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $purchase_l_audit_old->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_lot_no"><?php echo $purchase_l_audit_old->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->lot_no->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_lot_no">
<?php
$wrkonchange = "" . trim(@$purchase_l_audit_old->lot_no->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l_audit_old->lot_no->EditAttrs["onchange"] = "";
?>
<span id="as_x_lot_no" class="text-nowrap" style="z-index: 8890">
	<input type="text" class="form-control" name="sv_x_lot_no" id="sv_x_lot_no" value="<?php echo RemoveHtml($purchase_l_audit_old->lot_no->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->lot_no->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l_audit_old->lot_no->getPlaceHolder()) ?>"<?php echo $purchase_l_audit_old->lot_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="purchase_l_audit_old" data-field="x_lot_no" data-value-separator="<?php echo $purchase_l_audit_old->lot_no->displayValueSeparatorAttribute() ?>" name="x_lot_no" id="x_lot_no" value="<?php echo HtmlEncode($purchase_l_audit_old->lot_no->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_l_audit_oldsearch.createAutoSuggest({"id":"x_lot_no","forceSelect":false});
</script>
<?php echo $purchase_l_audit_old->lot_no->Lookup->getParamTag("p_x_lot_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old__barcode"><?php echo $purchase_l_audit_old->_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__barcode" id="z__barcode" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->_barcode->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old__barcode">
<input type="text" data-table="purchase_l_audit_old" data-field="x__barcode" name="x__barcode" id="x__barcode" size="35" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->_barcode->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->_barcode->EditValue ?>"<?php echo $purchase_l_audit_old->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->net_weight->Visible) { // net_weight ?>
	<div id="r_net_weight" class="form-group row">
		<label for="x_net_weight" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_net_weight"><?php echo $purchase_l_audit_old->net_weight->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->net_weight->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_net_weight" id="z_net_weight" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_l_audit_old->net_weight->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_l_audit_old->net_weight->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_l_audit_old->net_weight->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_l_audit_old->net_weight->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_l_audit_old->net_weight->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_l_audit_old->net_weight->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($purchase_l_audit_old->net_weight->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($purchase_l_audit_old->net_weight->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($purchase_l_audit_old->net_weight->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_l_audit_old_net_weight">
<input type="text" data-table="purchase_l_audit_old" data-field="x_net_weight" name="x_net_weight" id="x_net_weight" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->net_weight->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->net_weight->EditValue ?>"<?php echo $purchase_l_audit_old->net_weight->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_net_weight d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_l_audit_old_net_weight" class="btw1_net_weight d-none">
<input type="text" data-table="purchase_l_audit_old" data-field="x_net_weight" name="y_net_weight" id="y_net_weight" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->net_weight->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->net_weight->EditValue2 ?>"<?php echo $purchase_l_audit_old->net_weight->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_packets"><?php echo $purchase_l_audit_old->packets->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->packets->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_packets" id="z_packets" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_l_audit_old->packets->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_l_audit_old->packets->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_l_audit_old->packets->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_l_audit_old->packets->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_l_audit_old->packets->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_l_audit_old->packets->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($purchase_l_audit_old->packets->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($purchase_l_audit_old->packets->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($purchase_l_audit_old->packets->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_l_audit_old_packets">
<input type="text" data-table="purchase_l_audit_old" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->packets->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->packets->EditValue ?>"<?php echo $purchase_l_audit_old->packets->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_packets d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_l_audit_old_packets" class="btw1_packets d-none">
<input type="text" data-table="purchase_l_audit_old" data-field="x_packets" name="y_packets" id="y_packets" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->packets->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->packets->EditValue2 ?>"<?php echo $purchase_l_audit_old->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_packing_type"><?php echo $purchase_l_audit_old->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->packing_type->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit_old" data-field="x_packing_type" data-value-separator="<?php echo $purchase_l_audit_old->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $purchase_l_audit_old->packing_type->editAttributes() ?>>
		<?php echo $purchase_l_audit_old->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $purchase_l_audit_old->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->_40->Visible) { // _@ ?>
	<div id="r__40" class="form-group row">
		<label for="x__40" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old__40"><?php echo $purchase_l_audit_old->_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__40" id="z__40" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->_40->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old__40">
<input type="text" data-table="purchase_l_audit_old" data-field="x__40" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->_40->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->_40->EditValue ?>"<?php echo $purchase_l_audit_old->_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_amount"><?php echo $purchase_l_audit_old->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->amount->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_amount">
<input type="text" data-table="purchase_l_audit_old" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->amount->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->amount->EditValue ?>"<?php echo $purchase_l_audit_old->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_godown"><?php echo $purchase_l_audit_old->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->godown->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_godown">
<?php $purchase_l_audit_old->godown->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$purchase_l_audit_old->godown->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit_old" data-field="x_godown" data-value-separator="<?php echo $purchase_l_audit_old->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $purchase_l_audit_old->godown->editAttributes() ?>>
		<?php echo $purchase_l_audit_old->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $purchase_l_audit_old->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->rack->Visible) { // rack ?>
	<div id="r_rack" class="form-group row">
		<label for="x_rack" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_rack"><?php echo $purchase_l_audit_old->rack->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rack" id="z_rack" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->rack->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_rack">
<input type="text" data-table="purchase_l_audit_old" data-field="x_rack" name="x_rack" id="x_rack" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->rack->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->rack->EditValue ?>"<?php echo $purchase_l_audit_old->rack->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_dated"><?php echo $purchase_l_audit_old->dated->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_l_audit_old->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_l_audit_old->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_l_audit_old->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_l_audit_old->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_l_audit_old->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_l_audit_old->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($purchase_l_audit_old->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($purchase_l_audit_old->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($purchase_l_audit_old->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_l_audit_old_dated">
<input type="text" data-table="purchase_l_audit_old" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->dated->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->dated->EditValue ?>"<?php echo $purchase_l_audit_old->dated->editAttributes() ?>>
<?php if (!$purchase_l_audit_old->dated->ReadOnly && !$purchase_l_audit_old->dated->Disabled && !isset($purchase_l_audit_old->dated->EditAttrs["readonly"]) && !isset($purchase_l_audit_old->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_l_audit_oldsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_l_audit_old_dated" class="btw1_dated d-none">
<input type="text" data-table="purchase_l_audit_old" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->dated->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->dated->EditValue2 ?>"<?php echo $purchase_l_audit_old->dated->editAttributes() ?>>
<?php if (!$purchase_l_audit_old->dated->ReadOnly && !$purchase_l_audit_old->dated->Disabled && !isset($purchase_l_audit_old->dated->EditAttrs["readonly"]) && !isset($purchase_l_audit_old->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_l_audit_oldsearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->goods_inward->Visible) { // goods_inward ?>
	<div id="r_goods_inward" class="form-group row">
		<label for="x_goods_inward" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_goods_inward"><?php echo $purchase_l_audit_old->goods_inward->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_goods_inward" id="z_goods_inward" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->goods_inward->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_goods_inward">
<input type="text" data-table="purchase_l_audit_old" data-field="x_goods_inward" name="x_goods_inward" id="x_goods_inward" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->goods_inward->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->goods_inward->EditValue ?>"<?php echo $purchase_l_audit_old->goods_inward->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->invoice_details->Visible) { // invoice_details ?>
	<div id="r_invoice_details" class="form-group row">
		<label for="x_invoice_details" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_invoice_details"><?php echo $purchase_l_audit_old->invoice_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_invoice_details" id="z_invoice_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->invoice_details->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_invoice_details">
<input type="text" data-table="purchase_l_audit_old" data-field="x_invoice_details" name="x_invoice_details" id="x_invoice_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->invoice_details->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->invoice_details->EditValue ?>"<?php echo $purchase_l_audit_old->invoice_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->return_details->Visible) { // return_details ?>
	<div id="r_return_details" class="form-group row">
		<label for="x_return_details" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_return_details"><?php echo $purchase_l_audit_old->return_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_return_details" id="z_return_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->return_details->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_return_details">
<input type="text" data-table="purchase_l_audit_old" data-field="x_return_details" name="x_return_details" id="x_return_details" maxlength="250" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->return_details->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->return_details->EditValue ?>"<?php echo $purchase_l_audit_old->return_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_operator"><?php echo $purchase_l_audit_old->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->operator->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit_old" data-field="x_operator" data-value-separator="<?php echo $purchase_l_audit_old->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $purchase_l_audit_old->operator->editAttributes() ?>>
		<?php echo $purchase_l_audit_old->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $purchase_l_audit_old->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_datetime"><?php echo $purchase_l_audit_old->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_l_audit_old->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_l_audit_old->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_l_audit_old->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_l_audit_old->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_l_audit_old->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_l_audit_old->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($purchase_l_audit_old->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($purchase_l_audit_old->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($purchase_l_audit_old->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_l_audit_old_datetime">
<input type="text" data-table="purchase_l_audit_old" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->datetime->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->datetime->EditValue ?>"<?php echo $purchase_l_audit_old->datetime->editAttributes() ?>>
<?php if (!$purchase_l_audit_old->datetime->ReadOnly && !$purchase_l_audit_old->datetime->Disabled && !isset($purchase_l_audit_old->datetime->EditAttrs["readonly"]) && !isset($purchase_l_audit_old->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_l_audit_oldsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_l_audit_old_datetime" class="btw1_datetime d-none">
<input type="text" data-table="purchase_l_audit_old" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->datetime->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->datetime->EditValue2 ?>"<?php echo $purchase_l_audit_old->datetime->editAttributes() ?>>
<?php if (!$purchase_l_audit_old->datetime->ReadOnly && !$purchase_l_audit_old->datetime->Disabled && !isset($purchase_l_audit_old->datetime->EditAttrs["readonly"]) && !isset($purchase_l_audit_old->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_l_audit_oldsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_remarks"><?php echo $purchase_l_audit_old->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->remarks->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_remarks">
<input type="text" data-table="purchase_l_audit_old" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->remarks->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->remarks->EditValue ?>"<?php echo $purchase_l_audit_old->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->audit->Visible) { // audit ?>
	<div id="r_audit" class="form-group row">
		<label for="x_audit" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_audit"><?php echo $purchase_l_audit_old->audit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_audit" id="z_audit" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->audit->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_audit">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit_old" data-field="x_audit" data-value-separator="<?php echo $purchase_l_audit_old->audit->displayValueSeparatorAttribute() ?>" id="x_audit" name="x_audit"<?php echo $purchase_l_audit_old->audit->editAttributes() ?>>
		<?php echo $purchase_l_audit_old->audit->selectOptionListHtml("x_audit") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->a_operator->Visible) { // a_operator ?>
	<div id="r_a_operator" class="form-group row">
		<label for="x_a_operator" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_a_operator"><?php echo $purchase_l_audit_old->a_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_operator" id="z_a_operator" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->a_operator->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_a_operator">
<input type="text" data-table="purchase_l_audit_old" data-field="x_a_operator" name="x_a_operator" id="x_a_operator" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->a_operator->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->a_operator->EditValue ?>"<?php echo $purchase_l_audit_old->a_operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit_old->a_datetime->Visible) { // a_datetime ?>
	<div id="r_a_datetime" class="form-group row">
		<label for="x_a_datetime" class="<?php echo $purchase_l_audit_old_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_a_datetime"><?php echo $purchase_l_audit_old->a_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_datetime" id="z_a_datetime" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_audit_old_search->RightColumnClass ?>"><div<?php echo $purchase_l_audit_old->a_datetime->cellAttributes() ?>>
			<span id="el_purchase_l_audit_old_a_datetime">
<input type="text" data-table="purchase_l_audit_old" data-field="x_a_datetime" name="x_a_datetime" id="x_a_datetime" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit_old->a_datetime->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit_old->a_datetime->EditValue ?>"<?php echo $purchase_l_audit_old->a_datetime->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$purchase_l_audit_old_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $purchase_l_audit_old_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$purchase_l_audit_old_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$purchase_l_audit_old_search->terminate();
?>