<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$purchase_l_audit_add = new purchase_l_audit_add();

// Run the page
$purchase_l_audit_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$purchase_l_audit_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpurchase_l_auditadd = currentForm = new ew.Form("fpurchase_l_auditadd", "add");

// Validate form
fpurchase_l_auditadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($purchase_l_audit_add->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->type->caption(), $purchase_l_audit->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_audit_add->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->company_id->caption(), $purchase_l_audit->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l_audit->company_id->errorMessage()) ?>");
		<?php if ($purchase_l_audit_add->supplier->Required) { ?>
			elm = this.getElements("x" + infix + "_supplier");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->supplier->caption(), $purchase_l_audit->supplier->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_supplier");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l_audit->supplier->errorMessage()) ?>");
		<?php if ($purchase_l_audit_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->rid->caption(), $purchase_l_audit->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_audit_add->rid_return->Required) { ?>
			elm = this.getElements("x" + infix + "_rid_return");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->rid_return->caption(), $purchase_l_audit->rid_return->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_audit_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->grp->caption(), $purchase_l_audit->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_audit_add->s_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_s_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->s_grp->caption(), $purchase_l_audit->s_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_audit_add->product->Required) { ?>
			elm = this.getElements("x" + infix + "_product");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->product->caption(), $purchase_l_audit->product->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_audit_add->lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lot_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->lot_no->caption(), $purchase_l_audit->lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_audit_add->net_weight->Required) { ?>
			elm = this.getElements("x" + infix + "_net_weight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->net_weight->caption(), $purchase_l_audit->net_weight->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_net_weight");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l_audit->net_weight->errorMessage()) ?>");
		<?php if ($purchase_l_audit_add->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->packets->caption(), $purchase_l_audit->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l_audit->packets->errorMessage()) ?>");
		<?php if ($purchase_l_audit_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->packing_type->caption(), $purchase_l_audit->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_audit_add->_40->Required) { ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->_40->caption(), $purchase_l_audit->_40->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l_audit->_40->errorMessage()) ?>");
		<?php if ($purchase_l_audit_add->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->amount->caption(), $purchase_l_audit->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l_audit->amount->errorMessage()) ?>");
		<?php if ($purchase_l_audit_add->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->godown->caption(), $purchase_l_audit->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_audit_add->rack->Required) { ?>
			elm = this.getElements("x" + infix + "_rack");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->rack->caption(), $purchase_l_audit->rack->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_audit_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->dated->caption(), $purchase_l_audit->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l_audit->dated->errorMessage()) ?>");
		<?php if ($purchase_l_audit_add->goods_inward->Required) { ?>
			elm = this.getElements("x" + infix + "_goods_inward");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->goods_inward->caption(), $purchase_l_audit->goods_inward->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_audit_add->invoice_details->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->invoice_details->caption(), $purchase_l_audit->invoice_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_audit_add->invoice_dated->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->invoice_dated->caption(), $purchase_l_audit->invoice_dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_invoice_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l_audit->invoice_dated->errorMessage()) ?>");
		<?php if ($purchase_l_audit_add->return_details->Required) { ?>
			elm = this.getElements("x" + infix + "_return_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->return_details->caption(), $purchase_l_audit->return_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_audit_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->operator->caption(), $purchase_l_audit->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_audit_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->datetime->caption(), $purchase_l_audit->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_audit_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_audit->remarks->caption(), $purchase_l_audit->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpurchase_l_auditadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_l_auditadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_l_auditadd.lists["x_type"] = <?php echo $purchase_l_audit_add->type->Lookup->toClientList() ?>;
fpurchase_l_auditadd.lists["x_type"].options = <?php echo JsonEncode($purchase_l_audit_add->type->lookupOptions()) ?>;
fpurchase_l_auditadd.lists["x_company_id"] = <?php echo $purchase_l_audit_add->company_id->Lookup->toClientList() ?>;
fpurchase_l_auditadd.lists["x_company_id"].options = <?php echo JsonEncode($purchase_l_audit_add->company_id->lookupOptions()) ?>;
fpurchase_l_auditadd.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_l_auditadd.lists["x_supplier"] = <?php echo $purchase_l_audit_add->supplier->Lookup->toClientList() ?>;
fpurchase_l_auditadd.lists["x_supplier"].options = <?php echo JsonEncode($purchase_l_audit_add->supplier->lookupOptions()) ?>;
fpurchase_l_auditadd.autoSuggests["x_supplier"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_l_auditadd.lists["x_rid"] = <?php echo $purchase_l_audit_add->rid->Lookup->toClientList() ?>;
fpurchase_l_auditadd.lists["x_rid"].options = <?php echo JsonEncode($purchase_l_audit_add->rid->lookupOptions()) ?>;
fpurchase_l_auditadd.lists["x_rid_return"] = <?php echo $purchase_l_audit_add->rid_return->Lookup->toClientList() ?>;
fpurchase_l_auditadd.lists["x_rid_return"].options = <?php echo JsonEncode($purchase_l_audit_add->rid_return->lookupOptions()) ?>;
fpurchase_l_auditadd.lists["x_grp"] = <?php echo $purchase_l_audit_add->grp->Lookup->toClientList() ?>;
fpurchase_l_auditadd.lists["x_grp"].options = <?php echo JsonEncode($purchase_l_audit_add->grp->lookupOptions()) ?>;
fpurchase_l_auditadd.lists["x_s_grp"] = <?php echo $purchase_l_audit_add->s_grp->Lookup->toClientList() ?>;
fpurchase_l_auditadd.lists["x_s_grp"].options = <?php echo JsonEncode($purchase_l_audit_add->s_grp->lookupOptions()) ?>;
fpurchase_l_auditadd.lists["x_product"] = <?php echo $purchase_l_audit_add->product->Lookup->toClientList() ?>;
fpurchase_l_auditadd.lists["x_product"].options = <?php echo JsonEncode($purchase_l_audit_add->product->lookupOptions()) ?>;
fpurchase_l_auditadd.lists["x_lot_no"] = <?php echo $purchase_l_audit_add->lot_no->Lookup->toClientList() ?>;
fpurchase_l_auditadd.lists["x_lot_no"].options = <?php echo JsonEncode($purchase_l_audit_add->lot_no->lookupOptions()) ?>;
fpurchase_l_auditadd.autoSuggests["x_lot_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_l_auditadd.lists["x_packing_type"] = <?php echo $purchase_l_audit_add->packing_type->Lookup->toClientList() ?>;
fpurchase_l_auditadd.lists["x_packing_type"].options = <?php echo JsonEncode($purchase_l_audit_add->packing_type->lookupOptions()) ?>;
fpurchase_l_auditadd.lists["x_godown"] = <?php echo $purchase_l_audit_add->godown->Lookup->toClientList() ?>;
fpurchase_l_auditadd.lists["x_godown"].options = <?php echo JsonEncode($purchase_l_audit_add->godown->lookupOptions()) ?>;
fpurchase_l_auditadd.lists["x_operator"] = <?php echo $purchase_l_audit_add->operator->Lookup->toClientList() ?>;
fpurchase_l_auditadd.lists["x_operator"].options = <?php echo JsonEncode($purchase_l_audit_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $purchase_l_audit_add->showPageHeader(); ?>
<?php
$purchase_l_audit_add->showMessage();
?>
<form name="fpurchase_l_auditadd" id="fpurchase_l_auditadd" class="<?php echo $purchase_l_audit_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($purchase_l_audit_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $purchase_l_audit_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="purchase_l_audit">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$purchase_l_audit_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($purchase_l_audit->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_purchase_l_audit_type" for="x_type" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->type->caption() ?><?php echo ($purchase_l_audit->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->type->cellAttributes() ?>>
<span id="el_purchase_l_audit_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit" data-field="x_type" data-value-separator="<?php echo $purchase_l_audit->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $purchase_l_audit->type->editAttributes() ?>>
		<?php echo $purchase_l_audit->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $purchase_l_audit->type->Lookup->getParamTag("p_x_type") ?>
</span>
<?php echo $purchase_l_audit->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_purchase_l_audit_company_id" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->company_id->caption() ?><?php echo ($purchase_l_audit->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->company_id->cellAttributes() ?>>
<span id="el_purchase_l_audit_company_id">
<?php
$wrkonchange = "" . trim(@$purchase_l_audit->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l_audit->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($purchase_l_audit->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l_audit->company_id->getPlaceHolder()) ?>"<?php echo $purchase_l_audit->company_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($purchase_l_audit->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_company_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($purchase_l_audit->company_id->ReadOnly || $purchase_l_audit->company_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="purchase_l_audit" data-field="x_company_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $purchase_l_audit->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($purchase_l_audit->company_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_l_auditadd.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $purchase_l_audit->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
<?php echo $purchase_l_audit->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->supplier->Visible) { // supplier ?>
	<div id="r_supplier" class="form-group row">
		<label id="elh_purchase_l_audit_supplier" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->supplier->caption() ?><?php echo ($purchase_l_audit->supplier->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->supplier->cellAttributes() ?>>
<span id="el_purchase_l_audit_supplier">
<?php
$wrkonchange = "" . trim(@$purchase_l_audit->supplier->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l_audit->supplier->EditAttrs["onchange"] = "";
?>
<span id="as_x_supplier" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_supplier" id="sv_x_supplier" value="<?php echo RemoveHtml($purchase_l_audit->supplier->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit->supplier->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l_audit->supplier->getPlaceHolder()) ?>"<?php echo $purchase_l_audit->supplier->editAttributes() ?>>
</span>
<input type="hidden" data-table="purchase_l_audit" data-field="x_supplier" data-value-separator="<?php echo $purchase_l_audit->supplier->displayValueSeparatorAttribute() ?>" name="x_supplier" id="x_supplier" value="<?php echo HtmlEncode($purchase_l_audit->supplier->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_l_auditadd.createAutoSuggest({"id":"x_supplier","forceSelect":true});
</script>
<?php echo $purchase_l_audit->supplier->Lookup->getParamTag("p_x_supplier") ?>
</span>
<?php echo $purchase_l_audit->supplier->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_purchase_l_audit_rid" for="x_rid" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->rid->caption() ?><?php echo ($purchase_l_audit->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->rid->cellAttributes() ?>>
<span id="el_purchase_l_audit_rid">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_rid"><?php echo strval($purchase_l_audit->rid->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($purchase_l_audit->rid->ViewValue) : $purchase_l_audit->rid->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($purchase_l_audit->rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($purchase_l_audit->rid->ReadOnly || $purchase_l_audit->rid->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_rid',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $purchase_l_audit->rid->Lookup->getParamTag("p_x_rid") ?>
<input type="hidden" data-table="purchase_l_audit" data-field="x_rid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $purchase_l_audit->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo $purchase_l_audit->rid->CurrentValue ?>"<?php echo $purchase_l_audit->rid->editAttributes() ?>>
</span>
<?php echo $purchase_l_audit->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->rid_return->Visible) { // rid_return ?>
	<div id="r_rid_return" class="form-group row">
		<label id="elh_purchase_l_audit_rid_return" for="x_rid_return" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->rid_return->caption() ?><?php echo ($purchase_l_audit->rid_return->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->rid_return->cellAttributes() ?>>
<span id="el_purchase_l_audit_rid_return">
<?php $purchase_l_audit->rid_return->EditAttrs["onchange"] = "ew.autoFill(this);" . @$purchase_l_audit->rid_return->EditAttrs["onchange"]; ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_rid_return"><?php echo strval($purchase_l_audit->rid_return->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($purchase_l_audit->rid_return->ViewValue) : $purchase_l_audit->rid_return->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($purchase_l_audit->rid_return->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($purchase_l_audit->rid_return->ReadOnly || $purchase_l_audit->rid_return->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_rid_return',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $purchase_l_audit->rid_return->Lookup->getParamTag("p_x_rid_return") ?>
<input type="hidden" data-table="purchase_l_audit" data-field="x_rid_return" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $purchase_l_audit->rid_return->displayValueSeparatorAttribute() ?>" name="x_rid_return" id="x_rid_return" value="<?php echo $purchase_l_audit->rid_return->CurrentValue ?>"<?php echo $purchase_l_audit->rid_return->editAttributes() ?>>
</span>
<?php echo $purchase_l_audit->rid_return->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_purchase_l_audit_grp" for="x_grp" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->grp->caption() ?><?php echo ($purchase_l_audit->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->grp->cellAttributes() ?>>
<span id="el_purchase_l_audit_grp">
<?php $purchase_l_audit->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$purchase_l_audit->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit" data-field="x_grp" data-value-separator="<?php echo $purchase_l_audit->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $purchase_l_audit->grp->editAttributes() ?>>
		<?php echo $purchase_l_audit->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $purchase_l_audit->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $purchase_l_audit->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label id="elh_purchase_l_audit_s_grp" for="x_s_grp" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->s_grp->caption() ?><?php echo ($purchase_l_audit->s_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->s_grp->cellAttributes() ?>>
<span id="el_purchase_l_audit_s_grp">
<?php $purchase_l_audit->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$purchase_l_audit->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit" data-field="x_s_grp" data-value-separator="<?php echo $purchase_l_audit->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $purchase_l_audit->s_grp->editAttributes() ?>>
		<?php echo $purchase_l_audit->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $purchase_l_audit->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
<?php echo $purchase_l_audit->s_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label id="elh_purchase_l_audit_product" for="x_product" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->product->caption() ?><?php echo ($purchase_l_audit->product->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->product->cellAttributes() ?>>
<span id="el_purchase_l_audit_product">
<?php $purchase_l_audit->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$purchase_l_audit->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit" data-field="x_product" data-value-separator="<?php echo $purchase_l_audit->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $purchase_l_audit->product->editAttributes() ?>>
		<?php echo $purchase_l_audit->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $purchase_l_audit->product->Lookup->getParamTag("p_x_product") ?>
</span>
<?php echo $purchase_l_audit->product->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label id="elh_purchase_l_audit_lot_no" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->lot_no->caption() ?><?php echo ($purchase_l_audit->lot_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->lot_no->cellAttributes() ?>>
<span id="el_purchase_l_audit_lot_no">
<?php
$wrkonchange = "" . trim(@$purchase_l_audit->lot_no->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l_audit->lot_no->EditAttrs["onchange"] = "";
?>
<span id="as_x_lot_no" class="text-nowrap" style="z-index: 8890">
	<input type="text" class="form-control" name="sv_x_lot_no" id="sv_x_lot_no" value="<?php echo RemoveHtml($purchase_l_audit->lot_no->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit->lot_no->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l_audit->lot_no->getPlaceHolder()) ?>"<?php echo $purchase_l_audit->lot_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="purchase_l_audit" data-field="x_lot_no" data-value-separator="<?php echo $purchase_l_audit->lot_no->displayValueSeparatorAttribute() ?>" name="x_lot_no" id="x_lot_no" value="<?php echo HtmlEncode($purchase_l_audit->lot_no->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_l_auditadd.createAutoSuggest({"id":"x_lot_no","forceSelect":false});
</script>
<?php echo $purchase_l_audit->lot_no->Lookup->getParamTag("p_x_lot_no") ?>
</span>
<?php echo $purchase_l_audit->lot_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->net_weight->Visible) { // net_weight ?>
	<div id="r_net_weight" class="form-group row">
		<label id="elh_purchase_l_audit_net_weight" for="x_net_weight" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->net_weight->caption() ?><?php echo ($purchase_l_audit->net_weight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->net_weight->cellAttributes() ?>>
<span id="el_purchase_l_audit_net_weight">
<input type="text" data-table="purchase_l_audit" data-field="x_net_weight" name="x_net_weight" id="x_net_weight" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit->net_weight->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit->net_weight->EditValue ?>"<?php echo $purchase_l_audit->net_weight->editAttributes() ?>>
</span>
<?php echo $purchase_l_audit->net_weight->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label id="elh_purchase_l_audit_packets" for="x_packets" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->packets->caption() ?><?php echo ($purchase_l_audit->packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->packets->cellAttributes() ?>>
<span id="el_purchase_l_audit_packets">
<input type="text" data-table="purchase_l_audit" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit->packets->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit->packets->EditValue ?>"<?php echo $purchase_l_audit->packets->editAttributes() ?>>
</span>
<?php echo $purchase_l_audit->packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_purchase_l_audit_packing_type" for="x_packing_type" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->packing_type->caption() ?><?php echo ($purchase_l_audit->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->packing_type->cellAttributes() ?>>
<span id="el_purchase_l_audit_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit" data-field="x_packing_type" data-value-separator="<?php echo $purchase_l_audit->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $purchase_l_audit->packing_type->editAttributes() ?>>
		<?php echo $purchase_l_audit->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "packing_type") && !$purchase_l_audit->packing_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_packing_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $purchase_l_audit->packing_type->caption() ?>" data-title="<?php echo $purchase_l_audit->packing_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_packing_type',url:'packing_typeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $purchase_l_audit->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $purchase_l_audit->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->_40->Visible) { // @ ?>
	<div id="r__40" class="form-group row">
		<label id="elh_purchase_l_audit__40" for="x__40" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->_40->caption() ?><?php echo ($purchase_l_audit->_40->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->_40->cellAttributes() ?>>
<span id="el_purchase_l_audit__40">
<input type="text" data-table="purchase_l_audit" data-field="x__40" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit->_40->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit->_40->EditValue ?>"<?php echo $purchase_l_audit->_40->editAttributes() ?>>
</span>
<?php echo $purchase_l_audit->_40->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_purchase_l_audit_amount" for="x_amount" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->amount->caption() ?><?php echo ($purchase_l_audit->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->amount->cellAttributes() ?>>
<span id="el_purchase_l_audit_amount">
<input type="text" data-table="purchase_l_audit" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($purchase_l_audit->amount->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit->amount->EditValue ?>"<?php echo $purchase_l_audit->amount->editAttributes() ?>>
</span>
<?php echo $purchase_l_audit->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_purchase_l_audit_godown" for="x_godown" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->godown->caption() ?><?php echo ($purchase_l_audit->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->godown->cellAttributes() ?>>
<span id="el_purchase_l_audit_godown">
<?php $purchase_l_audit->godown->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$purchase_l_audit->godown->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit" data-field="x_godown" data-value-separator="<?php echo $purchase_l_audit->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $purchase_l_audit->godown->editAttributes() ?>>
		<?php echo $purchase_l_audit->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $purchase_l_audit->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $purchase_l_audit->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->rack->Visible) { // rack ?>
	<div id="r_rack" class="form-group row">
		<label id="elh_purchase_l_audit_rack" for="x_rack" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->rack->caption() ?><?php echo ($purchase_l_audit->rack->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->rack->cellAttributes() ?>>
<span id="el_purchase_l_audit_rack">
<input type="text" data-table="purchase_l_audit" data-field="x_rack" name="x_rack" id="x_rack" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($purchase_l_audit->rack->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit->rack->EditValue ?>"<?php echo $purchase_l_audit->rack->editAttributes() ?>>
</span>
<?php echo $purchase_l_audit->rack->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_purchase_l_audit_dated" for="x_dated" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->dated->caption() ?><?php echo ($purchase_l_audit->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->dated->cellAttributes() ?>>
<span id="el_purchase_l_audit_dated">
<input type="text" data-table="purchase_l_audit" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($purchase_l_audit->dated->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit->dated->EditValue ?>"<?php echo $purchase_l_audit->dated->editAttributes() ?>>
<?php if (!$purchase_l_audit->dated->ReadOnly && !$purchase_l_audit->dated->Disabled && !isset($purchase_l_audit->dated->EditAttrs["readonly"]) && !isset($purchase_l_audit->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_l_auditadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $purchase_l_audit->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->goods_inward->Visible) { // goods_inward ?>
	<div id="r_goods_inward" class="form-group row">
		<label id="elh_purchase_l_audit_goods_inward" for="x_goods_inward" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->goods_inward->caption() ?><?php echo ($purchase_l_audit->goods_inward->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->goods_inward->cellAttributes() ?>>
<span id="el_purchase_l_audit_goods_inward">
<input type="text" data-table="purchase_l_audit" data-field="x_goods_inward" name="x_goods_inward" id="x_goods_inward" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($purchase_l_audit->goods_inward->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit->goods_inward->EditValue ?>"<?php echo $purchase_l_audit->goods_inward->editAttributes() ?>>
</span>
<?php echo $purchase_l_audit->goods_inward->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->invoice_details->Visible) { // invoice_details ?>
	<div id="r_invoice_details" class="form-group row">
		<label id="elh_purchase_l_audit_invoice_details" for="x_invoice_details" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->invoice_details->caption() ?><?php echo ($purchase_l_audit->invoice_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->invoice_details->cellAttributes() ?>>
<span id="el_purchase_l_audit_invoice_details">
<input type="text" data-table="purchase_l_audit" data-field="x_invoice_details" name="x_invoice_details" id="x_invoice_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($purchase_l_audit->invoice_details->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit->invoice_details->EditValue ?>"<?php echo $purchase_l_audit->invoice_details->editAttributes() ?>>
</span>
<?php echo $purchase_l_audit->invoice_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->invoice_dated->Visible) { // invoice_dated ?>
	<div id="r_invoice_dated" class="form-group row">
		<label id="elh_purchase_l_audit_invoice_dated" for="x_invoice_dated" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->invoice_dated->caption() ?><?php echo ($purchase_l_audit->invoice_dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->invoice_dated->cellAttributes() ?>>
<span id="el_purchase_l_audit_invoice_dated">
<input type="text" data-table="purchase_l_audit" data-field="x_invoice_dated" name="x_invoice_dated" id="x_invoice_dated" placeholder="<?php echo HtmlEncode($purchase_l_audit->invoice_dated->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit->invoice_dated->EditValue ?>"<?php echo $purchase_l_audit->invoice_dated->editAttributes() ?>>
<?php if (!$purchase_l_audit->invoice_dated->ReadOnly && !$purchase_l_audit->invoice_dated->Disabled && !isset($purchase_l_audit->invoice_dated->EditAttrs["readonly"]) && !isset($purchase_l_audit->invoice_dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_l_auditadd", "x_invoice_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $purchase_l_audit->invoice_dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->return_details->Visible) { // return_details ?>
	<div id="r_return_details" class="form-group row">
		<label id="elh_purchase_l_audit_return_details" for="x_return_details" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->return_details->caption() ?><?php echo ($purchase_l_audit->return_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->return_details->cellAttributes() ?>>
<span id="el_purchase_l_audit_return_details">
<textarea data-table="purchase_l_audit" data-field="x_return_details" name="x_return_details" id="x_return_details" cols="35" rows="3" placeholder="<?php echo HtmlEncode($purchase_l_audit->return_details->getPlaceHolder()) ?>"<?php echo $purchase_l_audit->return_details->editAttributes() ?>><?php echo $purchase_l_audit->return_details->EditValue ?></textarea>
</span>
<?php echo $purchase_l_audit->return_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label id="elh_purchase_l_audit_operator" for="x_operator" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->operator->caption() ?><?php echo ($purchase_l_audit->operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->operator->cellAttributes() ?>>
<span id="el_purchase_l_audit_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_audit" data-field="x_operator" data-value-separator="<?php echo $purchase_l_audit->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $purchase_l_audit->operator->editAttributes() ?>>
		<?php echo $purchase_l_audit->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $purchase_l_audit->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
<?php echo $purchase_l_audit->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label id="elh_purchase_l_audit_datetime" for="x_datetime" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->datetime->caption() ?><?php echo ($purchase_l_audit->datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->datetime->cellAttributes() ?>>
<span id="el_purchase_l_audit_datetime">
<input type="text" data-table="purchase_l_audit" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($purchase_l_audit->datetime->getPlaceHolder()) ?>" value="<?php echo $purchase_l_audit->datetime->EditValue ?>"<?php echo $purchase_l_audit->datetime->editAttributes() ?>>
<?php if (!$purchase_l_audit->datetime->ReadOnly && !$purchase_l_audit->datetime->Disabled && !isset($purchase_l_audit->datetime->EditAttrs["readonly"]) && !isset($purchase_l_audit->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_l_auditadd", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $purchase_l_audit->datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_audit->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_purchase_l_audit_remarks" for="x_remarks" class="<?php echo $purchase_l_audit_add->LeftColumnClass ?>"><?php echo $purchase_l_audit->remarks->caption() ?><?php echo ($purchase_l_audit->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_audit_add->RightColumnClass ?>"><div<?php echo $purchase_l_audit->remarks->cellAttributes() ?>>
<span id="el_purchase_l_audit_remarks">
<textarea data-table="purchase_l_audit" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?php echo HtmlEncode($purchase_l_audit->remarks->getPlaceHolder()) ?>"<?php echo $purchase_l_audit->remarks->editAttributes() ?>><?php echo $purchase_l_audit->remarks->EditValue ?></textarea>
</span>
<?php echo $purchase_l_audit->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$purchase_l_audit_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $purchase_l_audit_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $purchase_l_audit_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$purchase_l_audit_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$purchase_l_audit_add->terminate();
?>