<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$purchase_l_bc_add = new purchase_l_bc_add();

// Run the page
$purchase_l_bc_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$purchase_l_bc_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpurchase_l_bcadd = currentForm = new ew.Form("fpurchase_l_bcadd", "add");

// Validate form
fpurchase_l_bcadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($purchase_l_bc_add->supplier->Required) { ?>
			elm = this.getElements("x" + infix + "_supplier");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_bc->supplier->caption(), $purchase_l_bc->supplier->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_bc_add->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_bc->godown->caption(), $purchase_l_bc->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_bc_add->net_weight->Required) { ?>
			elm = this.getElements("x" + infix + "_net_weight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_bc->net_weight->caption(), $purchase_l_bc->net_weight->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_net_weight");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l_bc->net_weight->errorMessage()) ?>");
		<?php if ($purchase_l_bc_add->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_bc->packets->caption(), $purchase_l_bc->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l_bc->packets->errorMessage()) ?>");
		<?php if ($purchase_l_bc_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_bc->packing_type->caption(), $purchase_l_bc->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_bc_add->rack->Required) { ?>
			elm = this.getElements("x" + infix + "_rack");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_bc->rack->caption(), $purchase_l_bc->rack->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_bc_add->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_bc->_barcode->caption(), $purchase_l_bc->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_bc_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_bc->operator->caption(), $purchase_l_bc->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_bc_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l_bc->datetime->caption(), $purchase_l_bc->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpurchase_l_bcadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_l_bcadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_l_bcadd.lists["x_supplier"] = <?php echo $purchase_l_bc_add->supplier->Lookup->toClientList() ?>;
fpurchase_l_bcadd.lists["x_supplier"].options = <?php echo JsonEncode($purchase_l_bc_add->supplier->lookupOptions()) ?>;
fpurchase_l_bcadd.autoSuggests["x_supplier"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_l_bcadd.lists["x_godown"] = <?php echo $purchase_l_bc_add->godown->Lookup->toClientList() ?>;
fpurchase_l_bcadd.lists["x_godown"].options = <?php echo JsonEncode($purchase_l_bc_add->godown->lookupOptions()) ?>;
fpurchase_l_bcadd.lists["x_packing_type"] = <?php echo $purchase_l_bc_add->packing_type->Lookup->toClientList() ?>;
fpurchase_l_bcadd.lists["x_packing_type"].options = <?php echo JsonEncode($purchase_l_bc_add->packing_type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $purchase_l_bc_add->showPageHeader(); ?>
<?php
$purchase_l_bc_add->showMessage();
?>
<form name="fpurchase_l_bcadd" id="fpurchase_l_bcadd" class="<?php echo $purchase_l_bc_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($purchase_l_bc_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $purchase_l_bc_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="purchase_l_bc">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$purchase_l_bc_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($purchase_l_bc->supplier->Visible) { // supplier ?>
	<div id="r_supplier" class="form-group row">
		<label id="elh_purchase_l_bc_supplier" class="<?php echo $purchase_l_bc_add->LeftColumnClass ?>"><?php echo $purchase_l_bc->supplier->caption() ?><?php echo ($purchase_l_bc->supplier->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_bc_add->RightColumnClass ?>"><div<?php echo $purchase_l_bc->supplier->cellAttributes() ?>>
<span id="el_purchase_l_bc_supplier">
<?php
$wrkonchange = "" . trim(@$purchase_l_bc->supplier->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l_bc->supplier->EditAttrs["onchange"] = "";
?>
<span id="as_x_supplier" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_supplier" id="sv_x_supplier" value="<?php echo RemoveHtml($purchase_l_bc->supplier->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l_bc->supplier->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l_bc->supplier->getPlaceHolder()) ?>"<?php echo $purchase_l_bc->supplier->editAttributes() ?>>
</span>
<input type="hidden" data-table="purchase_l_bc" data-field="x_supplier" data-value-separator="<?php echo $purchase_l_bc->supplier->displayValueSeparatorAttribute() ?>" name="x_supplier" id="x_supplier" value="<?php echo HtmlEncode($purchase_l_bc->supplier->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_l_bcadd.createAutoSuggest({"id":"x_supplier","forceSelect":true});
</script>
<?php echo $purchase_l_bc->supplier->Lookup->getParamTag("p_x_supplier") ?>
</span>
<?php echo $purchase_l_bc->supplier->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_bc->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_purchase_l_bc_godown" for="x_godown" class="<?php echo $purchase_l_bc_add->LeftColumnClass ?>"><?php echo $purchase_l_bc->godown->caption() ?><?php echo ($purchase_l_bc->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_bc_add->RightColumnClass ?>"><div<?php echo $purchase_l_bc->godown->cellAttributes() ?>>
<span id="el_purchase_l_bc_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_bc" data-field="x_godown" data-value-separator="<?php echo $purchase_l_bc->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $purchase_l_bc->godown->editAttributes() ?>>
		<?php echo $purchase_l_bc->godown->selectOptionListHtml("x_godown") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "godown_table") && !$purchase_l_bc->godown->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_godown" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $purchase_l_bc->godown->caption() ?>" data-title="<?php echo $purchase_l_bc->godown->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_godown',url:'godown_tableaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $purchase_l_bc->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $purchase_l_bc->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_bc->net_weight->Visible) { // net_weight ?>
	<div id="r_net_weight" class="form-group row">
		<label id="elh_purchase_l_bc_net_weight" for="x_net_weight" class="<?php echo $purchase_l_bc_add->LeftColumnClass ?>"><?php echo $purchase_l_bc->net_weight->caption() ?><?php echo ($purchase_l_bc->net_weight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_bc_add->RightColumnClass ?>"><div<?php echo $purchase_l_bc->net_weight->cellAttributes() ?>>
<span id="el_purchase_l_bc_net_weight">
<input type="text" data-table="purchase_l_bc" data-field="x_net_weight" name="x_net_weight" id="x_net_weight" size="30" placeholder="<?php echo HtmlEncode($purchase_l_bc->net_weight->getPlaceHolder()) ?>" value="<?php echo $purchase_l_bc->net_weight->EditValue ?>"<?php echo $purchase_l_bc->net_weight->editAttributes() ?>>
</span>
<?php echo $purchase_l_bc->net_weight->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_bc->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label id="elh_purchase_l_bc_packets" for="x_packets" class="<?php echo $purchase_l_bc_add->LeftColumnClass ?>"><?php echo $purchase_l_bc->packets->caption() ?><?php echo ($purchase_l_bc->packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_bc_add->RightColumnClass ?>"><div<?php echo $purchase_l_bc->packets->cellAttributes() ?>>
<span id="el_purchase_l_bc_packets">
<input type="text" data-table="purchase_l_bc" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($purchase_l_bc->packets->getPlaceHolder()) ?>" value="<?php echo $purchase_l_bc->packets->EditValue ?>"<?php echo $purchase_l_bc->packets->editAttributes() ?>>
</span>
<?php echo $purchase_l_bc->packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_bc->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_purchase_l_bc_packing_type" for="x_packing_type" class="<?php echo $purchase_l_bc_add->LeftColumnClass ?>"><?php echo $purchase_l_bc->packing_type->caption() ?><?php echo ($purchase_l_bc->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_bc_add->RightColumnClass ?>"><div<?php echo $purchase_l_bc->packing_type->cellAttributes() ?>>
<span id="el_purchase_l_bc_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_bc" data-field="x_packing_type" data-value-separator="<?php echo $purchase_l_bc->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $purchase_l_bc->packing_type->editAttributes() ?>>
		<?php echo $purchase_l_bc->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "packing_type") && !$purchase_l_bc->packing_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_packing_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $purchase_l_bc->packing_type->caption() ?>" data-title="<?php echo $purchase_l_bc->packing_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_packing_type',url:'packing_typeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $purchase_l_bc->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $purchase_l_bc->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_bc->rack->Visible) { // rack ?>
	<div id="r_rack" class="form-group row">
		<label id="elh_purchase_l_bc_rack" for="x_rack" class="<?php echo $purchase_l_bc_add->LeftColumnClass ?>"><?php echo $purchase_l_bc->rack->caption() ?><?php echo ($purchase_l_bc->rack->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_bc_add->RightColumnClass ?>"><div<?php echo $purchase_l_bc->rack->cellAttributes() ?>>
<span id="el_purchase_l_bc_rack">
<input type="text" data-table="purchase_l_bc" data-field="x_rack" name="x_rack" id="x_rack" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($purchase_l_bc->rack->getPlaceHolder()) ?>" value="<?php echo $purchase_l_bc->rack->EditValue ?>"<?php echo $purchase_l_bc->rack->editAttributes() ?>>
</span>
<?php echo $purchase_l_bc->rack->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_bc->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_purchase_l_bc__barcode" for="x__barcode" class="<?php echo $purchase_l_bc_add->LeftColumnClass ?>"><?php echo $purchase_l_bc->_barcode->caption() ?><?php echo ($purchase_l_bc->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_bc_add->RightColumnClass ?>"><div<?php echo $purchase_l_bc->_barcode->cellAttributes() ?>>
<span id="el_purchase_l_bc__barcode">
<input type="text" data-table="purchase_l_bc" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($purchase_l_bc->_barcode->getPlaceHolder()) ?>" value="<?php echo $purchase_l_bc->_barcode->EditValue ?>"<?php echo $purchase_l_bc->_barcode->editAttributes() ?>>
</span>
<?php echo $purchase_l_bc->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$purchase_l_bc_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $purchase_l_bc_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $purchase_l_bc_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$purchase_l_bc_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

$("#fpurchase_l_bcadd #btn-action").attr("disabled","disabled");
</script>
<?php include_once "footer.php" ?>
<?php
$purchase_l_bc_add->terminate();
?>