<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$purchase_l_bc_list = new purchase_l_bc_list();

// Run the page
$purchase_l_bc_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$purchase_l_bc_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$purchase_l_bc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpurchase_l_bclist = currentForm = new ew.Form("fpurchase_l_bclist", "list");
fpurchase_l_bclist.formKeyCountName = '<?php echo $purchase_l_bc_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpurchase_l_bclist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_l_bclist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_l_bclist.lists["x_supplier"] = <?php echo $purchase_l_bc_list->supplier->Lookup->toClientList() ?>;
fpurchase_l_bclist.lists["x_supplier"].options = <?php echo JsonEncode($purchase_l_bc_list->supplier->lookupOptions()) ?>;
fpurchase_l_bclist.autoSuggests["x_supplier"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_l_bclist.lists["x_godown"] = <?php echo $purchase_l_bc_list->godown->Lookup->toClientList() ?>;
fpurchase_l_bclist.lists["x_godown"].options = <?php echo JsonEncode($purchase_l_bc_list->godown->lookupOptions()) ?>;
fpurchase_l_bclist.lists["x_packing_type"] = <?php echo $purchase_l_bc_list->packing_type->Lookup->toClientList() ?>;
fpurchase_l_bclist.lists["x_packing_type"].options = <?php echo JsonEncode($purchase_l_bc_list->packing_type->lookupOptions()) ?>;

// Form object for search
var fpurchase_l_bclistsrch = currentSearchForm = new ew.Form("fpurchase_l_bclistsrch");

// Filters
fpurchase_l_bclistsrch.filterList = <?php echo $purchase_l_bc_list->getFilterList() ?>;

// Init search panel as collapsed
fpurchase_l_bclistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$purchase_l_bc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($purchase_l_bc_list->TotalRecs > 0 && $purchase_l_bc_list->ExportOptions->visible()) { ?>
<?php $purchase_l_bc_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($purchase_l_bc_list->ImportOptions->visible()) { ?>
<?php $purchase_l_bc_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($purchase_l_bc_list->SearchOptions->visible()) { ?>
<?php $purchase_l_bc_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($purchase_l_bc_list->FilterOptions->visible()) { ?>
<?php $purchase_l_bc_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$purchase_l_bc_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$purchase_l_bc->isExport() && !$purchase_l_bc->CurrentAction) { ?>
<form name="fpurchase_l_bclistsrch" id="fpurchase_l_bclistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($purchase_l_bc_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpurchase_l_bclistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="purchase_l_bc">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($purchase_l_bc_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($purchase_l_bc_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $purchase_l_bc_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($purchase_l_bc_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($purchase_l_bc_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($purchase_l_bc_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($purchase_l_bc_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $purchase_l_bc_list->showPageHeader(); ?>
<?php
$purchase_l_bc_list->showMessage();
?>
<?php if ($purchase_l_bc_list->TotalRecs > 0 || $purchase_l_bc->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($purchase_l_bc_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> purchase_l_bc">
<?php if (!$purchase_l_bc->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$purchase_l_bc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($purchase_l_bc_list->Pager)) $purchase_l_bc_list->Pager = new PrevNextPager($purchase_l_bc_list->StartRec, $purchase_l_bc_list->DisplayRecs, $purchase_l_bc_list->TotalRecs, $purchase_l_bc_list->AutoHidePager) ?>
<?php if ($purchase_l_bc_list->Pager->RecordCount > 0 && $purchase_l_bc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($purchase_l_bc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $purchase_l_bc_list->pageUrl() ?>start=<?php echo $purchase_l_bc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($purchase_l_bc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $purchase_l_bc_list->pageUrl() ?>start=<?php echo $purchase_l_bc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $purchase_l_bc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($purchase_l_bc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $purchase_l_bc_list->pageUrl() ?>start=<?php echo $purchase_l_bc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($purchase_l_bc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $purchase_l_bc_list->pageUrl() ?>start=<?php echo $purchase_l_bc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $purchase_l_bc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($purchase_l_bc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $purchase_l_bc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $purchase_l_bc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $purchase_l_bc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($purchase_l_bc_list->TotalRecs > 0 && (!$purchase_l_bc_list->AutoHidePageSizeSelector || $purchase_l_bc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="purchase_l_bc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($purchase_l_bc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($purchase_l_bc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($purchase_l_bc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($purchase_l_bc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($purchase_l_bc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($purchase_l_bc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $purchase_l_bc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpurchase_l_bclist" id="fpurchase_l_bclist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($purchase_l_bc_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $purchase_l_bc_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="purchase_l_bc">
<div id="gmp_purchase_l_bc" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($purchase_l_bc_list->TotalRecs > 0 || $purchase_l_bc->isGridEdit()) { ?>
<table id="tbl_purchase_l_bclist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$purchase_l_bc_list->RowType = ROWTYPE_HEADER;

// Render list options
$purchase_l_bc_list->renderListOptions();

// Render list options (header, left)
$purchase_l_bc_list->ListOptions->render("header", "left");
?>
<?php if ($purchase_l_bc->id->Visible) { // id ?>
	<?php if ($purchase_l_bc->sortUrl($purchase_l_bc->id) == "") { ?>
		<th data-name="id" class="<?php echo $purchase_l_bc->id->headerCellClass() ?>"><div id="elh_purchase_l_bc_id" class="purchase_l_bc_id"><div class="ew-table-header-caption"><?php echo $purchase_l_bc->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $purchase_l_bc->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_bc->SortUrl($purchase_l_bc->id) ?>',2);"><div id="elh_purchase_l_bc_id" class="purchase_l_bc_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_bc->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_bc->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_bc->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_bc->supplier->Visible) { // supplier ?>
	<?php if ($purchase_l_bc->sortUrl($purchase_l_bc->supplier) == "") { ?>
		<th data-name="supplier" class="<?php echo $purchase_l_bc->supplier->headerCellClass() ?>"><div id="elh_purchase_l_bc_supplier" class="purchase_l_bc_supplier"><div class="ew-table-header-caption"><?php echo $purchase_l_bc->supplier->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="supplier" class="<?php echo $purchase_l_bc->supplier->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_bc->SortUrl($purchase_l_bc->supplier) ?>',2);"><div id="elh_purchase_l_bc_supplier" class="purchase_l_bc_supplier">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_bc->supplier->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_bc->supplier->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_bc->supplier->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_bc->godown->Visible) { // godown ?>
	<?php if ($purchase_l_bc->sortUrl($purchase_l_bc->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $purchase_l_bc->godown->headerCellClass() ?>"><div id="elh_purchase_l_bc_godown" class="purchase_l_bc_godown"><div class="ew-table-header-caption"><?php echo $purchase_l_bc->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $purchase_l_bc->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_bc->SortUrl($purchase_l_bc->godown) ?>',2);"><div id="elh_purchase_l_bc_godown" class="purchase_l_bc_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_bc->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_bc->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_bc->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_bc->net_weight->Visible) { // net_weight ?>
	<?php if ($purchase_l_bc->sortUrl($purchase_l_bc->net_weight) == "") { ?>
		<th data-name="net_weight" class="<?php echo $purchase_l_bc->net_weight->headerCellClass() ?>"><div id="elh_purchase_l_bc_net_weight" class="purchase_l_bc_net_weight"><div class="ew-table-header-caption"><?php echo $purchase_l_bc->net_weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="net_weight" class="<?php echo $purchase_l_bc->net_weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_bc->SortUrl($purchase_l_bc->net_weight) ?>',2);"><div id="elh_purchase_l_bc_net_weight" class="purchase_l_bc_net_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_bc->net_weight->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_bc->net_weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_bc->net_weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_bc->packets->Visible) { // packets ?>
	<?php if ($purchase_l_bc->sortUrl($purchase_l_bc->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $purchase_l_bc->packets->headerCellClass() ?>"><div id="elh_purchase_l_bc_packets" class="purchase_l_bc_packets"><div class="ew-table-header-caption"><?php echo $purchase_l_bc->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $purchase_l_bc->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_bc->SortUrl($purchase_l_bc->packets) ?>',2);"><div id="elh_purchase_l_bc_packets" class="purchase_l_bc_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_bc->packets->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_bc->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_bc->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_bc->packing_type->Visible) { // packing_type ?>
	<?php if ($purchase_l_bc->sortUrl($purchase_l_bc->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $purchase_l_bc->packing_type->headerCellClass() ?>"><div id="elh_purchase_l_bc_packing_type" class="purchase_l_bc_packing_type"><div class="ew-table-header-caption"><?php echo $purchase_l_bc->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $purchase_l_bc->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_bc->SortUrl($purchase_l_bc->packing_type) ?>',2);"><div id="elh_purchase_l_bc_packing_type" class="purchase_l_bc_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_bc->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_bc->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_bc->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_bc->rack->Visible) { // rack ?>
	<?php if ($purchase_l_bc->sortUrl($purchase_l_bc->rack) == "") { ?>
		<th data-name="rack" class="<?php echo $purchase_l_bc->rack->headerCellClass() ?>"><div id="elh_purchase_l_bc_rack" class="purchase_l_bc_rack"><div class="ew-table-header-caption"><?php echo $purchase_l_bc->rack->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rack" class="<?php echo $purchase_l_bc->rack->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_bc->SortUrl($purchase_l_bc->rack) ?>',2);"><div id="elh_purchase_l_bc_rack" class="purchase_l_bc_rack">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_bc->rack->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_bc->rack->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_bc->rack->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_bc->_barcode->Visible) { // barcode ?>
	<?php if ($purchase_l_bc->sortUrl($purchase_l_bc->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $purchase_l_bc->_barcode->headerCellClass() ?>"><div id="elh_purchase_l_bc__barcode" class="purchase_l_bc__barcode"><div class="ew-table-header-caption"><?php echo $purchase_l_bc->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $purchase_l_bc->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_bc->SortUrl($purchase_l_bc->_barcode) ?>',2);"><div id="elh_purchase_l_bc__barcode" class="purchase_l_bc__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_bc->_barcode->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_bc->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_bc->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_bc->operator->Visible) { // operator ?>
	<?php if ($purchase_l_bc->sortUrl($purchase_l_bc->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $purchase_l_bc->operator->headerCellClass() ?>"><div id="elh_purchase_l_bc_operator" class="purchase_l_bc_operator"><div class="ew-table-header-caption"><?php echo $purchase_l_bc->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $purchase_l_bc->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_bc->SortUrl($purchase_l_bc->operator) ?>',2);"><div id="elh_purchase_l_bc_operator" class="purchase_l_bc_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_bc->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_bc->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_bc->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l_bc->datetime->Visible) { // datetime ?>
	<?php if ($purchase_l_bc->sortUrl($purchase_l_bc->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $purchase_l_bc->datetime->headerCellClass() ?>"><div id="elh_purchase_l_bc_datetime" class="purchase_l_bc_datetime"><div class="ew-table-header-caption"><?php echo $purchase_l_bc->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $purchase_l_bc->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l_bc->SortUrl($purchase_l_bc->datetime) ?>',2);"><div id="elh_purchase_l_bc_datetime" class="purchase_l_bc_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l_bc->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l_bc->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l_bc->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$purchase_l_bc_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($purchase_l_bc->ExportAll && $purchase_l_bc->isExport()) {
	$purchase_l_bc_list->StopRec = $purchase_l_bc_list->TotalRecs;
} else {

	// Set the last record to display
	if ($purchase_l_bc_list->TotalRecs > $purchase_l_bc_list->StartRec + $purchase_l_bc_list->DisplayRecs - 1)
		$purchase_l_bc_list->StopRec = $purchase_l_bc_list->StartRec + $purchase_l_bc_list->DisplayRecs - 1;
	else
		$purchase_l_bc_list->StopRec = $purchase_l_bc_list->TotalRecs;
}
$purchase_l_bc_list->RecCnt = $purchase_l_bc_list->StartRec - 1;
if ($purchase_l_bc_list->Recordset && !$purchase_l_bc_list->Recordset->EOF) {
	$purchase_l_bc_list->Recordset->moveFirst();
	$selectLimit = $purchase_l_bc_list->UseSelectLimit;
	if (!$selectLimit && $purchase_l_bc_list->StartRec > 1)
		$purchase_l_bc_list->Recordset->move($purchase_l_bc_list->StartRec - 1);
} elseif (!$purchase_l_bc->AllowAddDeleteRow && $purchase_l_bc_list->StopRec == 0) {
	$purchase_l_bc_list->StopRec = $purchase_l_bc->GridAddRowCount;
}

// Initialize aggregate
$purchase_l_bc->RowType = ROWTYPE_AGGREGATEINIT;
$purchase_l_bc->resetAttributes();
$purchase_l_bc_list->renderRow();
while ($purchase_l_bc_list->RecCnt < $purchase_l_bc_list->StopRec) {
	$purchase_l_bc_list->RecCnt++;
	if ($purchase_l_bc_list->RecCnt >= $purchase_l_bc_list->StartRec) {
		$purchase_l_bc_list->RowCnt++;

		// Set up key count
		$purchase_l_bc_list->KeyCount = $purchase_l_bc_list->RowIndex;

		// Init row class and style
		$purchase_l_bc->resetAttributes();
		$purchase_l_bc->CssClass = "";
		if ($purchase_l_bc->isGridAdd()) {
		} else {
			$purchase_l_bc_list->loadRowValues($purchase_l_bc_list->Recordset); // Load row values
		}
		$purchase_l_bc->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$purchase_l_bc->RowAttrs = array_merge($purchase_l_bc->RowAttrs, array('data-rowindex'=>$purchase_l_bc_list->RowCnt, 'id'=>'r' . $purchase_l_bc_list->RowCnt . '_purchase_l_bc', 'data-rowtype'=>$purchase_l_bc->RowType));

		// Render row
		$purchase_l_bc_list->renderRow();

		// Render list options
		$purchase_l_bc_list->renderListOptions();
?>
	<tr<?php echo $purchase_l_bc->rowAttributes() ?>>
<?php

// Render list options (body, left)
$purchase_l_bc_list->ListOptions->render("body", "left", $purchase_l_bc_list->RowCnt);
?>
	<?php if ($purchase_l_bc->id->Visible) { // id ?>
		<td data-name="id"<?php echo $purchase_l_bc->id->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_bc_list->RowCnt ?>_purchase_l_bc_id" class="purchase_l_bc_id">
<span<?php echo $purchase_l_bc->id->viewAttributes() ?>>
<?php echo $purchase_l_bc->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_bc->supplier->Visible) { // supplier ?>
		<td data-name="supplier"<?php echo $purchase_l_bc->supplier->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_bc_list->RowCnt ?>_purchase_l_bc_supplier" class="purchase_l_bc_supplier">
<span<?php echo $purchase_l_bc->supplier->viewAttributes() ?>>
<?php echo $purchase_l_bc->supplier->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_bc->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $purchase_l_bc->godown->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_bc_list->RowCnt ?>_purchase_l_bc_godown" class="purchase_l_bc_godown">
<span<?php echo $purchase_l_bc->godown->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l_bc->godown->getViewValue())) && $purchase_l_bc->godown->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l_bc->godown->linkAttributes() ?>><?php echo $purchase_l_bc->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l_bc->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_bc->net_weight->Visible) { // net_weight ?>
		<td data-name="net_weight"<?php echo $purchase_l_bc->net_weight->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_bc_list->RowCnt ?>_purchase_l_bc_net_weight" class="purchase_l_bc_net_weight">
<span<?php echo $purchase_l_bc->net_weight->viewAttributes() ?>>
<?php echo $purchase_l_bc->net_weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_bc->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $purchase_l_bc->packets->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_bc_list->RowCnt ?>_purchase_l_bc_packets" class="purchase_l_bc_packets">
<span<?php echo $purchase_l_bc->packets->viewAttributes() ?>>
<?php echo $purchase_l_bc->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_bc->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $purchase_l_bc->packing_type->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_bc_list->RowCnt ?>_purchase_l_bc_packing_type" class="purchase_l_bc_packing_type">
<span<?php echo $purchase_l_bc->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l_bc->packing_type->getViewValue())) && $purchase_l_bc->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l_bc->packing_type->linkAttributes() ?>><?php echo $purchase_l_bc->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l_bc->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_bc->rack->Visible) { // rack ?>
		<td data-name="rack"<?php echo $purchase_l_bc->rack->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_bc_list->RowCnt ?>_purchase_l_bc_rack" class="purchase_l_bc_rack">
<span<?php echo $purchase_l_bc->rack->viewAttributes() ?>>
<?php echo $purchase_l_bc->rack->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_bc->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $purchase_l_bc->_barcode->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_bc_list->RowCnt ?>_purchase_l_bc__barcode" class="purchase_l_bc__barcode">
<span<?php echo $purchase_l_bc->_barcode->viewAttributes() ?>>
<?php echo $purchase_l_bc->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_bc->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $purchase_l_bc->operator->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_bc_list->RowCnt ?>_purchase_l_bc_operator" class="purchase_l_bc_operator">
<span<?php echo $purchase_l_bc->operator->viewAttributes() ?>>
<?php echo $purchase_l_bc->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l_bc->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $purchase_l_bc->datetime->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_bc_list->RowCnt ?>_purchase_l_bc_datetime" class="purchase_l_bc_datetime">
<span<?php echo $purchase_l_bc->datetime->viewAttributes() ?>>
<?php echo $purchase_l_bc->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$purchase_l_bc_list->ListOptions->render("body", "right", $purchase_l_bc_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$purchase_l_bc->isGridAdd())
		$purchase_l_bc_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$purchase_l_bc->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($purchase_l_bc_list->Recordset)
	$purchase_l_bc_list->Recordset->Close();
?>
<?php if (!$purchase_l_bc->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$purchase_l_bc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($purchase_l_bc_list->Pager)) $purchase_l_bc_list->Pager = new PrevNextPager($purchase_l_bc_list->StartRec, $purchase_l_bc_list->DisplayRecs, $purchase_l_bc_list->TotalRecs, $purchase_l_bc_list->AutoHidePager) ?>
<?php if ($purchase_l_bc_list->Pager->RecordCount > 0 && $purchase_l_bc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($purchase_l_bc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $purchase_l_bc_list->pageUrl() ?>start=<?php echo $purchase_l_bc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($purchase_l_bc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $purchase_l_bc_list->pageUrl() ?>start=<?php echo $purchase_l_bc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $purchase_l_bc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($purchase_l_bc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $purchase_l_bc_list->pageUrl() ?>start=<?php echo $purchase_l_bc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($purchase_l_bc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $purchase_l_bc_list->pageUrl() ?>start=<?php echo $purchase_l_bc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $purchase_l_bc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($purchase_l_bc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $purchase_l_bc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $purchase_l_bc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $purchase_l_bc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($purchase_l_bc_list->TotalRecs > 0 && (!$purchase_l_bc_list->AutoHidePageSizeSelector || $purchase_l_bc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="purchase_l_bc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($purchase_l_bc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($purchase_l_bc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($purchase_l_bc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($purchase_l_bc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($purchase_l_bc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($purchase_l_bc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $purchase_l_bc_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($purchase_l_bc_list->TotalRecs == 0 && !$purchase_l_bc->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $purchase_l_bc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$purchase_l_bc_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$purchase_l_bc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$purchase_l_bc->isExport()) { ?>
<script>
ew.scrollableTable("gmp_purchase_l_bc", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$purchase_l_bc_list->terminate();
?>