<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$purchase_l_bc_search = new purchase_l_bc_search();

// Run the page
$purchase_l_bc_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$purchase_l_bc_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($purchase_l_bc_search->IsModal) { ?>
var fpurchase_l_bcsearch = currentAdvancedSearchForm = new ew.Form("fpurchase_l_bcsearch", "search");
<?php } else { ?>
var fpurchase_l_bcsearch = currentForm = new ew.Form("fpurchase_l_bcsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpurchase_l_bcsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_l_bcsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_l_bcsearch.lists["x_supplier"] = <?php echo $purchase_l_bc_search->supplier->Lookup->toClientList() ?>;
fpurchase_l_bcsearch.lists["x_supplier"].options = <?php echo JsonEncode($purchase_l_bc_search->supplier->lookupOptions()) ?>;
fpurchase_l_bcsearch.autoSuggests["x_supplier"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_l_bcsearch.lists["x_godown"] = <?php echo $purchase_l_bc_search->godown->Lookup->toClientList() ?>;
fpurchase_l_bcsearch.lists["x_godown"].options = <?php echo JsonEncode($purchase_l_bc_search->godown->lookupOptions()) ?>;
fpurchase_l_bcsearch.lists["x_packing_type"] = <?php echo $purchase_l_bc_search->packing_type->Lookup->toClientList() ?>;
fpurchase_l_bcsearch.lists["x_packing_type"].options = <?php echo JsonEncode($purchase_l_bc_search->packing_type->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpurchase_l_bcsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l_bc->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_net_weight");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l_bc->net_weight->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l_bc->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l_bc->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l_bc->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $purchase_l_bc_search->showPageHeader(); ?>
<?php
$purchase_l_bc_search->showMessage();
?>
<form name="fpurchase_l_bcsearch" id="fpurchase_l_bcsearch" class="<?php echo $purchase_l_bc_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($purchase_l_bc_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $purchase_l_bc_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="purchase_l_bc">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$purchase_l_bc_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($purchase_l_bc->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $purchase_l_bc_search->LeftColumnClass ?>"><span id="elh_purchase_l_bc_id"><?php echo $purchase_l_bc->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_bc_search->RightColumnClass ?>"><div<?php echo $purchase_l_bc->id->cellAttributes() ?>>
			<span id="el_purchase_l_bc_id">
<input type="text" data-table="purchase_l_bc" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($purchase_l_bc->id->getPlaceHolder()) ?>" value="<?php echo $purchase_l_bc->id->EditValue ?>"<?php echo $purchase_l_bc->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_bc->supplier->Visible) { // supplier ?>
	<div id="r_supplier" class="form-group row">
		<label class="<?php echo $purchase_l_bc_search->LeftColumnClass ?>"><span id="elh_purchase_l_bc_supplier"><?php echo $purchase_l_bc->supplier->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_supplier" id="z_supplier" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_bc_search->RightColumnClass ?>"><div<?php echo $purchase_l_bc->supplier->cellAttributes() ?>>
			<span id="el_purchase_l_bc_supplier">
<?php
$wrkonchange = "" . trim(@$purchase_l_bc->supplier->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l_bc->supplier->EditAttrs["onchange"] = "";
?>
<span id="as_x_supplier" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_supplier" id="sv_x_supplier" value="<?php echo RemoveHtml($purchase_l_bc->supplier->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l_bc->supplier->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l_bc->supplier->getPlaceHolder()) ?>"<?php echo $purchase_l_bc->supplier->editAttributes() ?>>
</span>
<input type="hidden" data-table="purchase_l_bc" data-field="x_supplier" data-value-separator="<?php echo $purchase_l_bc->supplier->displayValueSeparatorAttribute() ?>" name="x_supplier" id="x_supplier" value="<?php echo HtmlEncode($purchase_l_bc->supplier->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_l_bcsearch.createAutoSuggest({"id":"x_supplier","forceSelect":false});
</script>
<?php echo $purchase_l_bc->supplier->Lookup->getParamTag("p_x_supplier") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_bc->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $purchase_l_bc_search->LeftColumnClass ?>"><span id="elh_purchase_l_bc_godown"><?php echo $purchase_l_bc->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_bc_search->RightColumnClass ?>"><div<?php echo $purchase_l_bc->godown->cellAttributes() ?>>
			<span id="el_purchase_l_bc_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_bc" data-field="x_godown" data-value-separator="<?php echo $purchase_l_bc->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $purchase_l_bc->godown->editAttributes() ?>>
		<?php echo $purchase_l_bc->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $purchase_l_bc->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_bc->net_weight->Visible) { // net_weight ?>
	<div id="r_net_weight" class="form-group row">
		<label for="x_net_weight" class="<?php echo $purchase_l_bc_search->LeftColumnClass ?>"><span id="elh_purchase_l_bc_net_weight"><?php echo $purchase_l_bc->net_weight->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_l_bc_search->RightColumnClass ?>"><div<?php echo $purchase_l_bc->net_weight->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_net_weight" id="z_net_weight" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_l_bc->net_weight->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_l_bc->net_weight->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_l_bc->net_weight->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_l_bc->net_weight->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_l_bc->net_weight->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_l_bc->net_weight->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($purchase_l_bc->net_weight->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($purchase_l_bc->net_weight->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($purchase_l_bc->net_weight->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_l_bc_net_weight">
<input type="text" data-table="purchase_l_bc" data-field="x_net_weight" name="x_net_weight" id="x_net_weight" size="30" placeholder="<?php echo HtmlEncode($purchase_l_bc->net_weight->getPlaceHolder()) ?>" value="<?php echo $purchase_l_bc->net_weight->EditValue ?>"<?php echo $purchase_l_bc->net_weight->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_net_weight d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_l_bc_net_weight" class="btw1_net_weight d-none">
<input type="text" data-table="purchase_l_bc" data-field="x_net_weight" name="y_net_weight" id="y_net_weight" size="30" placeholder="<?php echo HtmlEncode($purchase_l_bc->net_weight->getPlaceHolder()) ?>" value="<?php echo $purchase_l_bc->net_weight->EditValue2 ?>"<?php echo $purchase_l_bc->net_weight->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_bc->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $purchase_l_bc_search->LeftColumnClass ?>"><span id="elh_purchase_l_bc_packets"><?php echo $purchase_l_bc->packets->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_l_bc_search->RightColumnClass ?>"><div<?php echo $purchase_l_bc->packets->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_packets" id="z_packets" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_l_bc->packets->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_l_bc->packets->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_l_bc->packets->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_l_bc->packets->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_l_bc->packets->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_l_bc->packets->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($purchase_l_bc->packets->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($purchase_l_bc->packets->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($purchase_l_bc->packets->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_l_bc_packets">
<input type="text" data-table="purchase_l_bc" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($purchase_l_bc->packets->getPlaceHolder()) ?>" value="<?php echo $purchase_l_bc->packets->EditValue ?>"<?php echo $purchase_l_bc->packets->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_packets d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_l_bc_packets" class="btw1_packets d-none">
<input type="text" data-table="purchase_l_bc" data-field="x_packets" name="y_packets" id="y_packets" size="30" placeholder="<?php echo HtmlEncode($purchase_l_bc->packets->getPlaceHolder()) ?>" value="<?php echo $purchase_l_bc->packets->EditValue2 ?>"<?php echo $purchase_l_bc->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_bc->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $purchase_l_bc_search->LeftColumnClass ?>"><span id="elh_purchase_l_bc_packing_type"><?php echo $purchase_l_bc->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_bc_search->RightColumnClass ?>"><div<?php echo $purchase_l_bc->packing_type->cellAttributes() ?>>
			<span id="el_purchase_l_bc_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l_bc" data-field="x_packing_type" data-value-separator="<?php echo $purchase_l_bc->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $purchase_l_bc->packing_type->editAttributes() ?>>
		<?php echo $purchase_l_bc->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $purchase_l_bc->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_bc->rack->Visible) { // rack ?>
	<div id="r_rack" class="form-group row">
		<label for="x_rack" class="<?php echo $purchase_l_bc_search->LeftColumnClass ?>"><span id="elh_purchase_l_bc_rack"><?php echo $purchase_l_bc->rack->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rack" id="z_rack" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_l_bc_search->RightColumnClass ?>"><div<?php echo $purchase_l_bc->rack->cellAttributes() ?>>
			<span id="el_purchase_l_bc_rack">
<input type="text" data-table="purchase_l_bc" data-field="x_rack" name="x_rack" id="x_rack" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($purchase_l_bc->rack->getPlaceHolder()) ?>" value="<?php echo $purchase_l_bc->rack->EditValue ?>"<?php echo $purchase_l_bc->rack->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_bc->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $purchase_l_bc_search->LeftColumnClass ?>"><span id="elh_purchase_l_bc__barcode"><?php echo $purchase_l_bc->_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__barcode" id="z__barcode" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_bc_search->RightColumnClass ?>"><div<?php echo $purchase_l_bc->_barcode->cellAttributes() ?>>
			<span id="el_purchase_l_bc__barcode">
<input type="text" data-table="purchase_l_bc" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($purchase_l_bc->_barcode->getPlaceHolder()) ?>" value="<?php echo $purchase_l_bc->_barcode->EditValue ?>"<?php echo $purchase_l_bc->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_bc->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $purchase_l_bc_search->LeftColumnClass ?>"><span id="elh_purchase_l_bc_operator"><?php echo $purchase_l_bc->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_bc_search->RightColumnClass ?>"><div<?php echo $purchase_l_bc->operator->cellAttributes() ?>>
			<span id="el_purchase_l_bc_operator">
<input type="text" data-table="purchase_l_bc" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($purchase_l_bc->operator->getPlaceHolder()) ?>" value="<?php echo $purchase_l_bc->operator->EditValue ?>"<?php echo $purchase_l_bc->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l_bc->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $purchase_l_bc_search->LeftColumnClass ?>"><span id="elh_purchase_l_bc_datetime"><?php echo $purchase_l_bc->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_bc_search->RightColumnClass ?>"><div<?php echo $purchase_l_bc->datetime->cellAttributes() ?>>
			<span id="el_purchase_l_bc_datetime">
<input type="text" data-table="purchase_l_bc" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($purchase_l_bc->datetime->getPlaceHolder()) ?>" value="<?php echo $purchase_l_bc->datetime->EditValue ?>"<?php echo $purchase_l_bc->datetime->editAttributes() ?>>
<?php if (!$purchase_l_bc->datetime->ReadOnly && !$purchase_l_bc->datetime->Disabled && !isset($purchase_l_bc->datetime->EditAttrs["readonly"]) && !isset($purchase_l_bc->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_l_bcsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$purchase_l_bc_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $purchase_l_bc_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$purchase_l_bc_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$purchase_l_bc_search->terminate();
?>