<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$purchase_l_bc_view = new purchase_l_bc_view();

// Run the page
$purchase_l_bc_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$purchase_l_bc_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$purchase_l_bc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fpurchase_l_bcview = currentForm = new ew.Form("fpurchase_l_bcview", "view");

// Form_CustomValidate event
fpurchase_l_bcview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_l_bcview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_l_bcview.lists["x_supplier"] = <?php echo $purchase_l_bc_view->supplier->Lookup->toClientList() ?>;
fpurchase_l_bcview.lists["x_supplier"].options = <?php echo JsonEncode($purchase_l_bc_view->supplier->lookupOptions()) ?>;
fpurchase_l_bcview.autoSuggests["x_supplier"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_l_bcview.lists["x_godown"] = <?php echo $purchase_l_bc_view->godown->Lookup->toClientList() ?>;
fpurchase_l_bcview.lists["x_godown"].options = <?php echo JsonEncode($purchase_l_bc_view->godown->lookupOptions()) ?>;
fpurchase_l_bcview.lists["x_packing_type"] = <?php echo $purchase_l_bc_view->packing_type->Lookup->toClientList() ?>;
fpurchase_l_bcview.lists["x_packing_type"].options = <?php echo JsonEncode($purchase_l_bc_view->packing_type->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$purchase_l_bc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $purchase_l_bc_view->ExportOptions->render("body") ?>
<?php $purchase_l_bc_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $purchase_l_bc_view->showPageHeader(); ?>
<?php
$purchase_l_bc_view->showMessage();
?>
<form name="fpurchase_l_bcview" id="fpurchase_l_bcview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($purchase_l_bc_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $purchase_l_bc_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="purchase_l_bc">
<input type="hidden" name="modal" value="<?php echo (int)$purchase_l_bc_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($purchase_l_bc->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $purchase_l_bc_view->TableLeftColumnClass ?>"><span id="elh_purchase_l_bc_id"><?php echo $purchase_l_bc->id->caption() ?></span></td>
		<td data-name="id"<?php echo $purchase_l_bc->id->cellAttributes() ?>>
<span id="el_purchase_l_bc_id">
<span<?php echo $purchase_l_bc->id->viewAttributes() ?>>
<?php echo $purchase_l_bc->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_l_bc->supplier->Visible) { // supplier ?>
	<tr id="r_supplier">
		<td class="<?php echo $purchase_l_bc_view->TableLeftColumnClass ?>"><span id="elh_purchase_l_bc_supplier"><?php echo $purchase_l_bc->supplier->caption() ?></span></td>
		<td data-name="supplier"<?php echo $purchase_l_bc->supplier->cellAttributes() ?>>
<span id="el_purchase_l_bc_supplier">
<span<?php echo $purchase_l_bc->supplier->viewAttributes() ?>>
<?php echo $purchase_l_bc->supplier->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_l_bc->godown->Visible) { // godown ?>
	<tr id="r_godown">
		<td class="<?php echo $purchase_l_bc_view->TableLeftColumnClass ?>"><span id="elh_purchase_l_bc_godown"><?php echo $purchase_l_bc->godown->caption() ?></span></td>
		<td data-name="godown"<?php echo $purchase_l_bc->godown->cellAttributes() ?>>
<span id="el_purchase_l_bc_godown">
<span<?php echo $purchase_l_bc->godown->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l_bc->godown->getViewValue())) && $purchase_l_bc->godown->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l_bc->godown->linkAttributes() ?>><?php echo $purchase_l_bc->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l_bc->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_l_bc->net_weight->Visible) { // net_weight ?>
	<tr id="r_net_weight">
		<td class="<?php echo $purchase_l_bc_view->TableLeftColumnClass ?>"><span id="elh_purchase_l_bc_net_weight"><?php echo $purchase_l_bc->net_weight->caption() ?></span></td>
		<td data-name="net_weight"<?php echo $purchase_l_bc->net_weight->cellAttributes() ?>>
<span id="el_purchase_l_bc_net_weight">
<span<?php echo $purchase_l_bc->net_weight->viewAttributes() ?>>
<?php echo $purchase_l_bc->net_weight->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_l_bc->packets->Visible) { // packets ?>
	<tr id="r_packets">
		<td class="<?php echo $purchase_l_bc_view->TableLeftColumnClass ?>"><span id="elh_purchase_l_bc_packets"><?php echo $purchase_l_bc->packets->caption() ?></span></td>
		<td data-name="packets"<?php echo $purchase_l_bc->packets->cellAttributes() ?>>
<span id="el_purchase_l_bc_packets">
<span<?php echo $purchase_l_bc->packets->viewAttributes() ?>>
<?php echo $purchase_l_bc->packets->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_l_bc->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $purchase_l_bc_view->TableLeftColumnClass ?>"><span id="elh_purchase_l_bc_packing_type"><?php echo $purchase_l_bc->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $purchase_l_bc->packing_type->cellAttributes() ?>>
<span id="el_purchase_l_bc_packing_type">
<span<?php echo $purchase_l_bc->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l_bc->packing_type->getViewValue())) && $purchase_l_bc->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l_bc->packing_type->linkAttributes() ?>><?php echo $purchase_l_bc->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l_bc->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_l_bc->rack->Visible) { // rack ?>
	<tr id="r_rack">
		<td class="<?php echo $purchase_l_bc_view->TableLeftColumnClass ?>"><span id="elh_purchase_l_bc_rack"><?php echo $purchase_l_bc->rack->caption() ?></span></td>
		<td data-name="rack"<?php echo $purchase_l_bc->rack->cellAttributes() ?>>
<span id="el_purchase_l_bc_rack">
<span<?php echo $purchase_l_bc->rack->viewAttributes() ?>>
<?php echo $purchase_l_bc->rack->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_l_bc->_barcode->Visible) { // barcode ?>
	<tr id="r__barcode">
		<td class="<?php echo $purchase_l_bc_view->TableLeftColumnClass ?>"><span id="elh_purchase_l_bc__barcode"><?php echo $purchase_l_bc->_barcode->caption() ?></span></td>
		<td data-name="_barcode"<?php echo $purchase_l_bc->_barcode->cellAttributes() ?>>
<span id="el_purchase_l_bc__barcode">
<span<?php echo $purchase_l_bc->_barcode->viewAttributes() ?>>
<?php echo $purchase_l_bc->_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_l_bc->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $purchase_l_bc_view->TableLeftColumnClass ?>"><span id="elh_purchase_l_bc_operator"><?php echo $purchase_l_bc->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $purchase_l_bc->operator->cellAttributes() ?>>
<span id="el_purchase_l_bc_operator">
<span<?php echo $purchase_l_bc->operator->viewAttributes() ?>>
<?php echo $purchase_l_bc->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($purchase_l_bc->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $purchase_l_bc_view->TableLeftColumnClass ?>"><span id="elh_purchase_l_bc_datetime"><?php echo $purchase_l_bc->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $purchase_l_bc->datetime->cellAttributes() ?>>
<span id="el_purchase_l_bc_datetime">
<span<?php echo $purchase_l_bc->datetime->viewAttributes() ?>>
<?php echo $purchase_l_bc->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$purchase_l_bc_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$purchase_l_bc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$purchase_l_bc_view->terminate();
?>