<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$purchase_l_add = new purchase_l_add();

// Run the page
$purchase_l_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$purchase_l_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fpurchase_ladd = currentForm = new ew.Form("fpurchase_ladd", "add");

// Validate form
fpurchase_ladd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($purchase_l_add->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->type->caption(), $purchase_l->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_add->supplier->Required) { ?>
			elm = this.getElements("x" + infix + "_supplier");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->supplier->caption(), $purchase_l->supplier->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_supplier");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l->supplier->errorMessage()) ?>");
		<?php if ($purchase_l_add->po->Required) { ?>
			elm = this.getElements("x" + infix + "_po");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->po->caption(), $purchase_l->po->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_add->po_return->Required) { ?>
			elm = this.getElements("x" + infix + "_po_return");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->po_return->caption(), $purchase_l->po_return->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_po_return");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l->po_return->errorMessage()) ?>");
		<?php if ($purchase_l_add->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->company_id->caption(), $purchase_l->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l->company_id->errorMessage()) ?>");
		<?php if ($purchase_l_add->rid_return->Required) { ?>
			elm = this.getElements("x" + infix + "_rid_return");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->rid_return->caption(), $purchase_l->rid_return->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_add->rid->Required) { ?>
			elm = this.getElements("x" + infix + "_rid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->rid->caption(), $purchase_l->rid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->packing_type->caption(), $purchase_l->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_add->lot_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lot_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->lot_no->caption(), $purchase_l->lot_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_add->packets->Required) { ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->packets->caption(), $purchase_l->packets->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_packets");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l->packets->errorMessage()) ?>");
		<?php if ($purchase_l_add->net_weight->Required) { ?>
			elm = this.getElements("x" + infix + "_net_weight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->net_weight->caption(), $purchase_l->net_weight->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_net_weight");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l->net_weight->errorMessage()) ?>");
		<?php if ($purchase_l_add->_40->Required) { ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->_40->caption(), $purchase_l->_40->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l->_40->errorMessage()) ?>");
		<?php if ($purchase_l_add->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->amount->caption(), $purchase_l->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l->amount->errorMessage()) ?>");
		<?php if ($purchase_l_add->godown->Required) { ?>
			elm = this.getElements("x" + infix + "_godown");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->godown->caption(), $purchase_l->godown->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->dated->caption(), $purchase_l->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l->dated->errorMessage()) ?>");
		<?php if ($purchase_l_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->operator->caption(), $purchase_l->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_add->rack->Required) { ?>
			elm = this.getElements("x" + infix + "_rack");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->rack->caption(), $purchase_l->rack->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->datetime->caption(), $purchase_l->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->remarks->caption(), $purchase_l->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_add->goods_inward->Required) { ?>
			elm = this.getElements("x" + infix + "_goods_inward");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->goods_inward->caption(), $purchase_l->goods_inward->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_add->invoice_details->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->invoice_details->caption(), $purchase_l->invoice_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_add->invoice_dated->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->invoice_dated->caption(), $purchase_l->invoice_dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_invoice_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l->invoice_dated->errorMessage()) ?>");
		<?php if ($purchase_l_add->return_details->Required) { ?>
			elm = this.getElements("x" + infix + "_return_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->return_details->caption(), $purchase_l->return_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_add->qc_remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_qc_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->qc_remarks->caption(), $purchase_l->qc_remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($purchase_l_add->qc_status->Required) { ?>
			elm = this.getElements("x" + infix + "_qc_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->qc_status->caption(), $purchase_l->qc_status->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qc_status");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l->qc_status->errorMessage()) ?>");
		<?php if ($purchase_l_add->qc_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_qc_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->qc_operator->caption(), $purchase_l->qc_operator->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qc_operator");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l->qc_operator->errorMessage()) ?>");
		<?php if ($purchase_l_add->qc_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_qc_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->qc_datetime->caption(), $purchase_l->qc_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_qc_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l->qc_datetime->errorMessage()) ?>");
		<?php if ($purchase_l_add->age->Required) { ?>
			elm = this.getElements("x" + infix + "_age");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $purchase_l->age->caption(), $purchase_l->age->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_age");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($purchase_l->age->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpurchase_ladd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_ladd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_ladd.lists["x_type"] = <?php echo $purchase_l_add->type->Lookup->toClientList() ?>;
fpurchase_ladd.lists["x_type"].options = <?php echo JsonEncode($purchase_l_add->type->lookupOptions()) ?>;
fpurchase_ladd.lists["x_supplier"] = <?php echo $purchase_l_add->supplier->Lookup->toClientList() ?>;
fpurchase_ladd.lists["x_supplier"].options = <?php echo JsonEncode($purchase_l_add->supplier->lookupOptions()) ?>;
fpurchase_ladd.autoSuggests["x_supplier"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_ladd.lists["x_po"] = <?php echo $purchase_l_add->po->Lookup->toClientList() ?>;
fpurchase_ladd.lists["x_po"].options = <?php echo JsonEncode($purchase_l_add->po->lookupOptions()) ?>;
fpurchase_ladd.autoSuggests["x_po"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_ladd.lists["x_po_return"] = <?php echo $purchase_l_add->po_return->Lookup->toClientList() ?>;
fpurchase_ladd.lists["x_po_return"].options = <?php echo JsonEncode($purchase_l_add->po_return->lookupOptions()) ?>;
fpurchase_ladd.autoSuggests["x_po_return"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_ladd.lists["x_company_id"] = <?php echo $purchase_l_add->company_id->Lookup->toClientList() ?>;
fpurchase_ladd.lists["x_company_id"].options = <?php echo JsonEncode($purchase_l_add->company_id->lookupOptions()) ?>;
fpurchase_ladd.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_ladd.lists["x_rid_return"] = <?php echo $purchase_l_add->rid_return->Lookup->toClientList() ?>;
fpurchase_ladd.lists["x_rid_return"].options = <?php echo JsonEncode($purchase_l_add->rid_return->lookupOptions()) ?>;
fpurchase_ladd.lists["x_rid"] = <?php echo $purchase_l_add->rid->Lookup->toClientList() ?>;
fpurchase_ladd.lists["x_rid"].options = <?php echo JsonEncode($purchase_l_add->rid->lookupOptions()) ?>;
fpurchase_ladd.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_ladd.lists["x_packing_type"] = <?php echo $purchase_l_add->packing_type->Lookup->toClientList() ?>;
fpurchase_ladd.lists["x_packing_type"].options = <?php echo JsonEncode($purchase_l_add->packing_type->lookupOptions()) ?>;
fpurchase_ladd.lists["x_lot_no"] = <?php echo $purchase_l_add->lot_no->Lookup->toClientList() ?>;
fpurchase_ladd.lists["x_lot_no"].options = <?php echo JsonEncode($purchase_l_add->lot_no->lookupOptions()) ?>;
fpurchase_ladd.autoSuggests["x_lot_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_ladd.lists["x_godown"] = <?php echo $purchase_l_add->godown->Lookup->toClientList() ?>;
fpurchase_ladd.lists["x_godown"].options = <?php echo JsonEncode($purchase_l_add->godown->lookupOptions()) ?>;
fpurchase_ladd.lists["x_operator"] = <?php echo $purchase_l_add->operator->Lookup->toClientList() ?>;
fpurchase_ladd.lists["x_operator"].options = <?php echo JsonEncode($purchase_l_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $purchase_l_add->showPageHeader(); ?>
<?php
$purchase_l_add->showMessage();
?>
<form name="fpurchase_ladd" id="fpurchase_ladd" class="<?php echo $purchase_l_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($purchase_l_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $purchase_l_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="purchase_l">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$purchase_l_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($purchase_l->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_purchase_l_type" for="x_type" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->type->caption() ?><?php echo ($purchase_l->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->type->cellAttributes() ?>>
<span id="el_purchase_l_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l" data-field="x_type" data-value-separator="<?php echo $purchase_l->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $purchase_l->type->editAttributes() ?>>
		<?php echo $purchase_l->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $purchase_l->type->Lookup->getParamTag("p_x_type") ?>
</span>
<?php echo $purchase_l->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->supplier->Visible) { // supplier ?>
	<div id="r_supplier" class="form-group row">
		<label id="elh_purchase_l_supplier" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->supplier->caption() ?><?php echo ($purchase_l->supplier->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->supplier->cellAttributes() ?>>
<span id="el_purchase_l_supplier">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$purchase_l->supplier->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l->supplier->EditAttrs["onchange"] = "";
?>
<span id="as_x_supplier" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_supplier" id="sv_x_supplier" value="<?php echo RemoveHtml($purchase_l->supplier->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l->supplier->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l->supplier->getPlaceHolder()) ?>"<?php echo $purchase_l->supplier->editAttributes() ?>>
</span>
<input type="hidden" data-table="purchase_l" data-field="x_supplier" data-value-separator="<?php echo $purchase_l->supplier->displayValueSeparatorAttribute() ?>" name="x_supplier" id="x_supplier" value="<?php echo HtmlEncode($purchase_l->supplier->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_ladd.createAutoSuggest({"id":"x_supplier","forceSelect":true});
</script>
<?php echo $purchase_l->supplier->Lookup->getParamTag("p_x_supplier") ?>
</span>
<?php echo $purchase_l->supplier->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label id="elh_purchase_l_po" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->po->caption() ?><?php echo ($purchase_l->po->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->po->cellAttributes() ?>>
<span id="el_purchase_l_po">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$purchase_l->po->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l->po->EditAttrs["onchange"] = "";
?>
<span id="as_x_po" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_po" id="sv_x_po" value="<?php echo RemoveHtml($purchase_l->po->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l->po->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l->po->getPlaceHolder()) ?>"<?php echo $purchase_l->po->editAttributes() ?>>
</span>
<input type="hidden" data-table="purchase_l" data-field="x_po" data-value-separator="<?php echo $purchase_l->po->displayValueSeparatorAttribute() ?>" name="x_po" id="x_po" value="<?php echo HtmlEncode($purchase_l->po->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_ladd.createAutoSuggest({"id":"x_po","forceSelect":true});
</script>
<?php echo $purchase_l->po->Lookup->getParamTag("p_x_po") ?>
</span>
<?php echo $purchase_l->po->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->po_return->Visible) { // po_return ?>
	<div id="r_po_return" class="form-group row">
		<label id="elh_purchase_l_po_return" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->po_return->caption() ?><?php echo ($purchase_l->po_return->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->po_return->cellAttributes() ?>>
<span id="el_purchase_l_po_return">
<?php
$wrkonchange = "" . trim(@$purchase_l->po_return->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l->po_return->EditAttrs["onchange"] = "";
?>
<span id="as_x_po_return" class="text-nowrap" style="z-index: 8950">
	<input type="text" class="form-control" name="sv_x_po_return" id="sv_x_po_return" value="<?php echo RemoveHtml($purchase_l->po_return->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l->po_return->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l->po_return->getPlaceHolder()) ?>"<?php echo $purchase_l->po_return->editAttributes() ?>>
</span>
<input type="hidden" data-table="purchase_l" data-field="x_po_return" data-value-separator="<?php echo $purchase_l->po_return->displayValueSeparatorAttribute() ?>" name="x_po_return" id="x_po_return" value="<?php echo HtmlEncode($purchase_l->po_return->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_ladd.createAutoSuggest({"id":"x_po_return","forceSelect":true});
</script>
<?php echo $purchase_l->po_return->Lookup->getParamTag("p_x_po_return") ?>
</span>
<?php echo $purchase_l->po_return->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_purchase_l_company_id" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->company_id->caption() ?><?php echo ($purchase_l->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->company_id->cellAttributes() ?>>
<span id="el_purchase_l_company_id">
<?php
$wrkonchange = "" . trim(@$purchase_l->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8940">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($purchase_l->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l->company_id->getPlaceHolder()) ?>"<?php echo $purchase_l->company_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($purchase_l->company_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_company_id',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($purchase_l->company_id->ReadOnly || $purchase_l->company_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="purchase_l" data-field="x_company_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $purchase_l->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($purchase_l->company_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_ladd.createAutoSuggest({"id":"x_company_id","forceSelect":true});
</script>
<?php echo $purchase_l->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
<?php echo $purchase_l->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->rid_return->Visible) { // rid_return ?>
	<div id="r_rid_return" class="form-group row">
		<label id="elh_purchase_l_rid_return" for="x_rid_return" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->rid_return->caption() ?><?php echo ($purchase_l->rid_return->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->rid_return->cellAttributes() ?>>
<span id="el_purchase_l_rid_return">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_rid_return"><?php echo strval($purchase_l->rid_return->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($purchase_l->rid_return->ViewValue) : $purchase_l->rid_return->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($purchase_l->rid_return->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($purchase_l->rid_return->ReadOnly || $purchase_l->rid_return->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_rid_return',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $purchase_l->rid_return->Lookup->getParamTag("p_x_rid_return") ?>
<input type="hidden" data-table="purchase_l" data-field="x_rid_return" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $purchase_l->rid_return->displayValueSeparatorAttribute() ?>" name="x_rid_return" id="x_rid_return" value="<?php echo $purchase_l->rid_return->CurrentValue ?>"<?php echo $purchase_l->rid_return->editAttributes() ?>>
</span>
<?php echo $purchase_l->rid_return->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label id="elh_purchase_l_rid" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->rid->caption() ?><?php echo ($purchase_l->rid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->rid->cellAttributes() ?>>
<span id="el_purchase_l_rid">
<?php
$wrkonchange = "" . trim(@$purchase_l->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8890">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($purchase_l->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l->rid->getPlaceHolder()) ?>"<?php echo $purchase_l->rid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($purchase_l->rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_rid',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($purchase_l->rid->ReadOnly || $purchase_l->rid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="purchase_l" data-field="x_rid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $purchase_l->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($purchase_l->rid->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_ladd.createAutoSuggest({"id":"x_rid","forceSelect":true});
</script>
<?php echo $purchase_l->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
<?php echo $purchase_l->rid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_purchase_l_packing_type" for="x_packing_type" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->packing_type->caption() ?><?php echo ($purchase_l->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->packing_type->cellAttributes() ?>>
<span id="el_purchase_l_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l" data-field="x_packing_type" data-value-separator="<?php echo $purchase_l->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $purchase_l->packing_type->editAttributes() ?>>
		<?php echo $purchase_l->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "packing_type") && !$purchase_l->packing_type->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_packing_type" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $purchase_l->packing_type->caption() ?>" data-title="<?php echo $purchase_l->packing_type->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_packing_type',url:'packing_typeaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $purchase_l->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
<?php echo $purchase_l->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label id="elh_purchase_l_lot_no" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->lot_no->caption() ?><?php echo ($purchase_l->lot_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->lot_no->cellAttributes() ?>>
<span id="el_purchase_l_lot_no">
<?php
$wrkonchange = "" . trim(@$purchase_l->lot_no->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l->lot_no->EditAttrs["onchange"] = "";
?>
<span id="as_x_lot_no" class="text-nowrap" style="z-index: 8870">
	<input type="text" class="form-control" name="sv_x_lot_no" id="sv_x_lot_no" value="<?php echo RemoveHtml($purchase_l->lot_no->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l->lot_no->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l->lot_no->getPlaceHolder()) ?>"<?php echo $purchase_l->lot_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="purchase_l" data-field="x_lot_no" data-value-separator="<?php echo $purchase_l->lot_no->displayValueSeparatorAttribute() ?>" name="x_lot_no" id="x_lot_no" value="<?php echo HtmlEncode($purchase_l->lot_no->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_ladd.createAutoSuggest({"id":"x_lot_no","forceSelect":false});
</script>
<?php echo $purchase_l->lot_no->Lookup->getParamTag("p_x_lot_no") ?>
</span>
<?php echo $purchase_l->lot_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label id="elh_purchase_l_packets" for="x_packets" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->packets->caption() ?><?php echo ($purchase_l->packets->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->packets->cellAttributes() ?>>
<span id="el_purchase_l_packets">
<input type="text" data-table="purchase_l" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($purchase_l->packets->getPlaceHolder()) ?>" value="<?php echo $purchase_l->packets->EditValue ?>"<?php echo $purchase_l->packets->editAttributes() ?>>
</span>
<?php echo $purchase_l->packets->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->net_weight->Visible) { // net_weight ?>
	<div id="r_net_weight" class="form-group row">
		<label id="elh_purchase_l_net_weight" for="x_net_weight" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->net_weight->caption() ?><?php echo ($purchase_l->net_weight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->net_weight->cellAttributes() ?>>
<span id="el_purchase_l_net_weight">
<input type="text" data-table="purchase_l" data-field="x_net_weight" name="x_net_weight" id="x_net_weight" size="30" placeholder="<?php echo HtmlEncode($purchase_l->net_weight->getPlaceHolder()) ?>" value="<?php echo $purchase_l->net_weight->EditValue ?>"<?php echo $purchase_l->net_weight->editAttributes() ?>>
</span>
<?php echo $purchase_l->net_weight->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->_40->Visible) { // @ ?>
	<div id="r__40" class="form-group row">
		<label id="elh_purchase_l__40" for="x__40" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->_40->caption() ?><?php echo ($purchase_l->_40->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->_40->cellAttributes() ?>>
<span id="el_purchase_l__40">
<input type="text" data-table="purchase_l" data-field="x__40" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($purchase_l->_40->getPlaceHolder()) ?>" value="<?php echo $purchase_l->_40->EditValue ?>"<?php echo $purchase_l->_40->editAttributes() ?>>
</span>
<?php echo $purchase_l->_40->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_purchase_l_amount" for="x_amount" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->amount->caption() ?><?php echo ($purchase_l->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->amount->cellAttributes() ?>>
<span id="el_purchase_l_amount">
<input type="text" data-table="purchase_l" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($purchase_l->amount->getPlaceHolder()) ?>" value="<?php echo $purchase_l->amount->EditValue ?>"<?php echo $purchase_l->amount->editAttributes() ?>>
</span>
<?php echo $purchase_l->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label id="elh_purchase_l_godown" for="x_godown" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->godown->caption() ?><?php echo ($purchase_l->godown->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->godown->cellAttributes() ?>>
<span id="el_purchase_l_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l" data-field="x_godown" data-value-separator="<?php echo $purchase_l->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $purchase_l->godown->editAttributes() ?>>
		<?php echo $purchase_l->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $purchase_l->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
<?php echo $purchase_l->godown->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_purchase_l_dated" for="x_dated" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->dated->caption() ?><?php echo ($purchase_l->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->dated->cellAttributes() ?>>
<span id="el_purchase_l_dated">
<input type="text" data-table="purchase_l" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($purchase_l->dated->getPlaceHolder()) ?>" value="<?php echo $purchase_l->dated->EditValue ?>"<?php echo $purchase_l->dated->editAttributes() ?>>
<?php if (!$purchase_l->dated->ReadOnly && !$purchase_l->dated->Disabled && !isset($purchase_l->dated->EditAttrs["readonly"]) && !isset($purchase_l->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_ladd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $purchase_l->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->rack->Visible) { // rack ?>
	<div id="r_rack" class="form-group row">
		<label id="elh_purchase_l_rack" for="x_rack" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->rack->caption() ?><?php echo ($purchase_l->rack->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->rack->cellAttributes() ?>>
<span id="el_purchase_l_rack">
<input type="text" data-table="purchase_l" data-field="x_rack" name="x_rack" id="x_rack" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($purchase_l->rack->getPlaceHolder()) ?>" value="<?php echo $purchase_l->rack->EditValue ?>"<?php echo $purchase_l->rack->editAttributes() ?>>
</span>
<?php echo $purchase_l->rack->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_purchase_l_remarks" for="x_remarks" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->remarks->caption() ?><?php echo ($purchase_l->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->remarks->cellAttributes() ?>>
<span id="el_purchase_l_remarks">
<textarea data-table="purchase_l" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?php echo HtmlEncode($purchase_l->remarks->getPlaceHolder()) ?>"<?php echo $purchase_l->remarks->editAttributes() ?>><?php echo $purchase_l->remarks->EditValue ?></textarea>
</span>
<?php echo $purchase_l->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->goods_inward->Visible) { // goods_inward ?>
	<div id="r_goods_inward" class="form-group row">
		<label id="elh_purchase_l_goods_inward" for="x_goods_inward" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->goods_inward->caption() ?><?php echo ($purchase_l->goods_inward->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->goods_inward->cellAttributes() ?>>
<span id="el_purchase_l_goods_inward">
<input type="text" data-table="purchase_l" data-field="x_goods_inward" name="x_goods_inward" id="x_goods_inward" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($purchase_l->goods_inward->getPlaceHolder()) ?>" value="<?php echo $purchase_l->goods_inward->EditValue ?>"<?php echo $purchase_l->goods_inward->editAttributes() ?>>
</span>
<?php echo $purchase_l->goods_inward->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->invoice_details->Visible) { // invoice_details ?>
	<div id="r_invoice_details" class="form-group row">
		<label id="elh_purchase_l_invoice_details" for="x_invoice_details" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->invoice_details->caption() ?><?php echo ($purchase_l->invoice_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->invoice_details->cellAttributes() ?>>
<span id="el_purchase_l_invoice_details">
<input type="text" data-table="purchase_l" data-field="x_invoice_details" name="x_invoice_details" id="x_invoice_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($purchase_l->invoice_details->getPlaceHolder()) ?>" value="<?php echo $purchase_l->invoice_details->EditValue ?>"<?php echo $purchase_l->invoice_details->editAttributes() ?>>
</span>
<?php echo $purchase_l->invoice_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->invoice_dated->Visible) { // invoice_dated ?>
	<div id="r_invoice_dated" class="form-group row">
		<label id="elh_purchase_l_invoice_dated" for="x_invoice_dated" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->invoice_dated->caption() ?><?php echo ($purchase_l->invoice_dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->invoice_dated->cellAttributes() ?>>
<span id="el_purchase_l_invoice_dated">
<input type="text" data-table="purchase_l" data-field="x_invoice_dated" name="x_invoice_dated" id="x_invoice_dated" placeholder="<?php echo HtmlEncode($purchase_l->invoice_dated->getPlaceHolder()) ?>" value="<?php echo $purchase_l->invoice_dated->EditValue ?>"<?php echo $purchase_l->invoice_dated->editAttributes() ?>>
<?php if (!$purchase_l->invoice_dated->ReadOnly && !$purchase_l->invoice_dated->Disabled && !isset($purchase_l->invoice_dated->EditAttrs["readonly"]) && !isset($purchase_l->invoice_dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_ladd", "x_invoice_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $purchase_l->invoice_dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->return_details->Visible) { // return_details ?>
	<div id="r_return_details" class="form-group row">
		<label id="elh_purchase_l_return_details" for="x_return_details" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->return_details->caption() ?><?php echo ($purchase_l->return_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->return_details->cellAttributes() ?>>
<span id="el_purchase_l_return_details">
<textarea data-table="purchase_l" data-field="x_return_details" name="x_return_details" id="x_return_details" cols="35" rows="3" placeholder="<?php echo HtmlEncode($purchase_l->return_details->getPlaceHolder()) ?>"<?php echo $purchase_l->return_details->editAttributes() ?>><?php echo $purchase_l->return_details->EditValue ?></textarea>
</span>
<?php echo $purchase_l->return_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->qc_remarks->Visible) { // qc_remarks ?>
	<div id="r_qc_remarks" class="form-group row">
		<label id="elh_purchase_l_qc_remarks" for="x_qc_remarks" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->qc_remarks->caption() ?><?php echo ($purchase_l->qc_remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->qc_remarks->cellAttributes() ?>>
<span id="el_purchase_l_qc_remarks">
<textarea data-table="purchase_l" data-field="x_qc_remarks" name="x_qc_remarks" id="x_qc_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($purchase_l->qc_remarks->getPlaceHolder()) ?>"<?php echo $purchase_l->qc_remarks->editAttributes() ?>><?php echo $purchase_l->qc_remarks->EditValue ?></textarea>
</span>
<?php echo $purchase_l->qc_remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->qc_status->Visible) { // qc_status ?>
	<div id="r_qc_status" class="form-group row">
		<label id="elh_purchase_l_qc_status" for="x_qc_status" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->qc_status->caption() ?><?php echo ($purchase_l->qc_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->qc_status->cellAttributes() ?>>
<span id="el_purchase_l_qc_status">
<input type="text" data-table="purchase_l" data-field="x_qc_status" name="x_qc_status" id="x_qc_status" size="30" placeholder="<?php echo HtmlEncode($purchase_l->qc_status->getPlaceHolder()) ?>" value="<?php echo $purchase_l->qc_status->EditValue ?>"<?php echo $purchase_l->qc_status->editAttributes() ?>>
</span>
<?php echo $purchase_l->qc_status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->qc_operator->Visible) { // qc_operator ?>
	<div id="r_qc_operator" class="form-group row">
		<label id="elh_purchase_l_qc_operator" for="x_qc_operator" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->qc_operator->caption() ?><?php echo ($purchase_l->qc_operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->qc_operator->cellAttributes() ?>>
<span id="el_purchase_l_qc_operator">
<input type="text" data-table="purchase_l" data-field="x_qc_operator" name="x_qc_operator" id="x_qc_operator" size="30" placeholder="<?php echo HtmlEncode($purchase_l->qc_operator->getPlaceHolder()) ?>" value="<?php echo $purchase_l->qc_operator->EditValue ?>"<?php echo $purchase_l->qc_operator->editAttributes() ?>>
</span>
<?php echo $purchase_l->qc_operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->qc_datetime->Visible) { // qc_datetime ?>
	<div id="r_qc_datetime" class="form-group row">
		<label id="elh_purchase_l_qc_datetime" for="x_qc_datetime" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->qc_datetime->caption() ?><?php echo ($purchase_l->qc_datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->qc_datetime->cellAttributes() ?>>
<span id="el_purchase_l_qc_datetime">
<input type="text" data-table="purchase_l" data-field="x_qc_datetime" name="x_qc_datetime" id="x_qc_datetime" placeholder="<?php echo HtmlEncode($purchase_l->qc_datetime->getPlaceHolder()) ?>" value="<?php echo $purchase_l->qc_datetime->EditValue ?>"<?php echo $purchase_l->qc_datetime->editAttributes() ?>>
<?php if (!$purchase_l->qc_datetime->ReadOnly && !$purchase_l->qc_datetime->Disabled && !isset($purchase_l->qc_datetime->EditAttrs["readonly"]) && !isset($purchase_l->qc_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_ladd", "x_qc_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $purchase_l->qc_datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->age->Visible) { // age ?>
	<div id="r_age" class="form-group row">
		<label id="elh_purchase_l_age" for="x_age" class="<?php echo $purchase_l_add->LeftColumnClass ?>"><?php echo $purchase_l->age->caption() ?><?php echo ($purchase_l->age->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $purchase_l_add->RightColumnClass ?>"><div<?php echo $purchase_l->age->cellAttributes() ?>>
<span id="el_purchase_l_age">
<input type="text" data-table="purchase_l" data-field="x_age" name="x_age" id="x_age" size="30" placeholder="<?php echo HtmlEncode($purchase_l->age->getPlaceHolder()) ?>" value="<?php echo $purchase_l->age->EditValue ?>"<?php echo $purchase_l->age->editAttributes() ?>>
</span>
<?php echo $purchase_l->age->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$purchase_l_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $purchase_l_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $purchase_l_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$purchase_l_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

				 	$("#r_return_details").hide();
				 	$("#r_rid_return").hide();
				 	$("#r_po_return").hide();
</script>
<?php include_once "footer.php" ?>
<?php
$purchase_l_add->terminate();
?>