<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$purchase_l_list = new purchase_l_list();

// Run the page
$purchase_l_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$purchase_l_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$purchase_l->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fpurchase_llist = currentForm = new ew.Form("fpurchase_llist", "list");
fpurchase_llist.formKeyCountName = '<?php echo $purchase_l_list->FormKeyCountName ?>';

// Form_CustomValidate event
fpurchase_llist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_llist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_llist.lists["x_type"] = <?php echo $purchase_l_list->type->Lookup->toClientList() ?>;
fpurchase_llist.lists["x_type"].options = <?php echo JsonEncode($purchase_l_list->type->lookupOptions()) ?>;
fpurchase_llist.lists["x_supplier"] = <?php echo $purchase_l_list->supplier->Lookup->toClientList() ?>;
fpurchase_llist.lists["x_supplier"].options = <?php echo JsonEncode($purchase_l_list->supplier->lookupOptions()) ?>;
fpurchase_llist.autoSuggests["x_supplier"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_llist.lists["x_po"] = <?php echo $purchase_l_list->po->Lookup->toClientList() ?>;
fpurchase_llist.lists["x_po"].options = <?php echo JsonEncode($purchase_l_list->po->lookupOptions()) ?>;
fpurchase_llist.autoSuggests["x_po"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_llist.lists["x_company_id"] = <?php echo $purchase_l_list->company_id->Lookup->toClientList() ?>;
fpurchase_llist.lists["x_company_id"].options = <?php echo JsonEncode($purchase_l_list->company_id->lookupOptions()) ?>;
fpurchase_llist.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_llist.lists["x_rid"] = <?php echo $purchase_l_list->rid->Lookup->toClientList() ?>;
fpurchase_llist.lists["x_rid"].options = <?php echo JsonEncode($purchase_l_list->rid->lookupOptions()) ?>;
fpurchase_llist.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_llist.lists["x_packing_type"] = <?php echo $purchase_l_list->packing_type->Lookup->toClientList() ?>;
fpurchase_llist.lists["x_packing_type"].options = <?php echo JsonEncode($purchase_l_list->packing_type->lookupOptions()) ?>;
fpurchase_llist.lists["x_lot_no"] = <?php echo $purchase_l_list->lot_no->Lookup->toClientList() ?>;
fpurchase_llist.lists["x_lot_no"].options = <?php echo JsonEncode($purchase_l_list->lot_no->lookupOptions()) ?>;
fpurchase_llist.autoSuggests["x_lot_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_llist.lists["x_godown"] = <?php echo $purchase_l_list->godown->Lookup->toClientList() ?>;
fpurchase_llist.lists["x_godown"].options = <?php echo JsonEncode($purchase_l_list->godown->lookupOptions()) ?>;
fpurchase_llist.lists["x_operator"] = <?php echo $purchase_l_list->operator->Lookup->toClientList() ?>;
fpurchase_llist.lists["x_operator"].options = <?php echo JsonEncode($purchase_l_list->operator->lookupOptions()) ?>;

// Form object for search
var fpurchase_llistsrch = currentSearchForm = new ew.Form("fpurchase_llistsrch");

// Validate function for search
fpurchase_llistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_supplier");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->supplier->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fpurchase_llistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_llistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_llistsrch.lists["x_type"] = <?php echo $purchase_l_list->type->Lookup->toClientList() ?>;
fpurchase_llistsrch.lists["x_type"].options = <?php echo JsonEncode($purchase_l_list->type->lookupOptions()) ?>;
fpurchase_llistsrch.lists["x_supplier"] = <?php echo $purchase_l_list->supplier->Lookup->toClientList() ?>;
fpurchase_llistsrch.lists["x_supplier"].options = <?php echo JsonEncode($purchase_l_list->supplier->lookupOptions()) ?>;
fpurchase_llistsrch.autoSuggests["x_supplier"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
fpurchase_llistsrch.filterList = <?php echo $purchase_l_list->getFilterList() ?>;

// Init search panel as collapsed
fpurchase_llistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$purchase_l->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($purchase_l_list->TotalRecs > 0 && $purchase_l_list->ExportOptions->visible()) { ?>
<?php $purchase_l_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($purchase_l_list->ImportOptions->visible()) { ?>
<?php $purchase_l_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($purchase_l_list->SearchOptions->visible()) { ?>
<?php $purchase_l_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($purchase_l_list->FilterOptions->visible()) { ?>
<?php $purchase_l_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$purchase_l_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$purchase_l->isExport() && !$purchase_l->CurrentAction) { ?>
<form name="fpurchase_llistsrch" id="fpurchase_llistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($purchase_l_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fpurchase_llistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="purchase_l">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$purchase_l_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$purchase_l->RowType = ROWTYPE_SEARCH;

// Render row
$purchase_l->resetAttributes();
$purchase_l_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($purchase_l->type->Visible) { // type ?>
	<div id="xsc_type" class="ew-cell form-group">
		<label for="x_type" class="ew-search-caption ew-label"><?php echo $purchase_l->type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l" data-field="x_type" data-value-separator="<?php echo $purchase_l->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $purchase_l->type->editAttributes() ?>>
		<?php echo $purchase_l->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $purchase_l->type->Lookup->getParamTag("p_x_type") ?>
</span>
	</div>
<?php } ?>
<?php if ($purchase_l->supplier->Visible) { // supplier ?>
	<div id="xsc_supplier" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $purchase_l->supplier->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_supplier" id="z_supplier" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$purchase_l->supplier->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l->supplier->EditAttrs["onchange"] = "";
?>
<span id="as_x_supplier" class="text-nowrap" style="z-index: 8970">
	<input type="text" class="form-control" name="sv_x_supplier" id="sv_x_supplier" value="<?php echo RemoveHtml($purchase_l->supplier->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l->supplier->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l->supplier->getPlaceHolder()) ?>"<?php echo $purchase_l->supplier->editAttributes() ?>>
</span>
<input type="hidden" data-table="purchase_l" data-field="x_supplier" data-value-separator="<?php echo $purchase_l->supplier->displayValueSeparatorAttribute() ?>" name="x_supplier" id="x_supplier" value="<?php echo HtmlEncode($purchase_l->supplier->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_llistsrch.createAutoSuggest({"id":"x_supplier","forceSelect":true});
</script>
<?php echo $purchase_l->supplier->Lookup->getParamTag("p_x_supplier") ?>
</span>
	</div>
<?php } ?>
<?php if ($purchase_l->invoice_details->Visible) { // invoice_details ?>
	<div id="xsc_invoice_details" class="ew-cell form-group">
		<label for="x_invoice_details" class="ew-search-caption ew-label"><?php echo $purchase_l->invoice_details->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_invoice_details" id="z_invoice_details" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="purchase_l" data-field="x_invoice_details" name="x_invoice_details" id="x_invoice_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($purchase_l->invoice_details->getPlaceHolder()) ?>" value="<?php echo $purchase_l->invoice_details->EditValue ?>"<?php echo $purchase_l->invoice_details->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($purchase_l_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($purchase_l_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $purchase_l_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($purchase_l_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($purchase_l_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($purchase_l_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($purchase_l_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $purchase_l_list->showPageHeader(); ?>
<?php
$purchase_l_list->showMessage();
?>
<?php if ($purchase_l_list->TotalRecs > 0 || $purchase_l->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($purchase_l_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> purchase_l">
<?php if (!$purchase_l->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$purchase_l->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($purchase_l_list->Pager)) $purchase_l_list->Pager = new PrevNextPager($purchase_l_list->StartRec, $purchase_l_list->DisplayRecs, $purchase_l_list->TotalRecs, $purchase_l_list->AutoHidePager) ?>
<?php if ($purchase_l_list->Pager->RecordCount > 0 && $purchase_l_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($purchase_l_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $purchase_l_list->pageUrl() ?>start=<?php echo $purchase_l_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($purchase_l_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $purchase_l_list->pageUrl() ?>start=<?php echo $purchase_l_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $purchase_l_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($purchase_l_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $purchase_l_list->pageUrl() ?>start=<?php echo $purchase_l_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($purchase_l_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $purchase_l_list->pageUrl() ?>start=<?php echo $purchase_l_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $purchase_l_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($purchase_l_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $purchase_l_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $purchase_l_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $purchase_l_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($purchase_l_list->TotalRecs > 0 && (!$purchase_l_list->AutoHidePageSizeSelector || $purchase_l_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="purchase_l">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($purchase_l_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($purchase_l_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($purchase_l_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($purchase_l_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($purchase_l_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($purchase_l->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $purchase_l_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpurchase_llist" id="fpurchase_llist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($purchase_l_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $purchase_l_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="purchase_l">
<div id="gmp_purchase_l" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($purchase_l_list->TotalRecs > 0 || $purchase_l->isGridEdit()) { ?>
<table id="tbl_purchase_llist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$purchase_l_list->RowType = ROWTYPE_HEADER;

// Render list options
$purchase_l_list->renderListOptions();

// Render list options (header, left)
$purchase_l_list->ListOptions->render("header", "left");
?>
<?php if ($purchase_l->id->Visible) { // id ?>
	<?php if ($purchase_l->sortUrl($purchase_l->id) == "") { ?>
		<th data-name="id" class="<?php echo $purchase_l->id->headerCellClass() ?>"><div id="elh_purchase_l_id" class="purchase_l_id"><div class="ew-table-header-caption"><?php echo $purchase_l->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $purchase_l->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->id) ?>',2);"><div id="elh_purchase_l_id" class="purchase_l_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->type->Visible) { // type ?>
	<?php if ($purchase_l->sortUrl($purchase_l->type) == "") { ?>
		<th data-name="type" class="<?php echo $purchase_l->type->headerCellClass() ?>"><div id="elh_purchase_l_type" class="purchase_l_type"><div class="ew-table-header-caption"><?php echo $purchase_l->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $purchase_l->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->type) ?>',2);"><div id="elh_purchase_l_type" class="purchase_l_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->supplier->Visible) { // supplier ?>
	<?php if ($purchase_l->sortUrl($purchase_l->supplier) == "") { ?>
		<th data-name="supplier" class="<?php echo $purchase_l->supplier->headerCellClass() ?>"><div id="elh_purchase_l_supplier" class="purchase_l_supplier"><div class="ew-table-header-caption"><?php echo $purchase_l->supplier->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="supplier" class="<?php echo $purchase_l->supplier->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->supplier) ?>',2);"><div id="elh_purchase_l_supplier" class="purchase_l_supplier">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->supplier->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->supplier->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->supplier->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->po->Visible) { // po ?>
	<?php if ($purchase_l->sortUrl($purchase_l->po) == "") { ?>
		<th data-name="po" class="<?php echo $purchase_l->po->headerCellClass() ?>"><div id="elh_purchase_l_po" class="purchase_l_po"><div class="ew-table-header-caption"><?php echo $purchase_l->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $purchase_l->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->po) ?>',2);"><div id="elh_purchase_l_po" class="purchase_l_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->company_id->Visible) { // company_id ?>
	<?php if ($purchase_l->sortUrl($purchase_l->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $purchase_l->company_id->headerCellClass() ?>"><div id="elh_purchase_l_company_id" class="purchase_l_company_id"><div class="ew-table-header-caption"><?php echo $purchase_l->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $purchase_l->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->company_id) ?>',2);"><div id="elh_purchase_l_company_id" class="purchase_l_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->rid->Visible) { // rid ?>
	<?php if ($purchase_l->sortUrl($purchase_l->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $purchase_l->rid->headerCellClass() ?>"><div id="elh_purchase_l_rid" class="purchase_l_rid"><div class="ew-table-header-caption"><?php echo $purchase_l->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $purchase_l->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->rid) ?>',2);"><div id="elh_purchase_l_rid" class="purchase_l_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->packing_type->Visible) { // packing_type ?>
	<?php if ($purchase_l->sortUrl($purchase_l->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $purchase_l->packing_type->headerCellClass() ?>"><div id="elh_purchase_l_packing_type" class="purchase_l_packing_type"><div class="ew-table-header-caption"><?php echo $purchase_l->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $purchase_l->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->packing_type) ?>',2);"><div id="elh_purchase_l_packing_type" class="purchase_l_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->lot_no->Visible) { // lot_no ?>
	<?php if ($purchase_l->sortUrl($purchase_l->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $purchase_l->lot_no->headerCellClass() ?>"><div id="elh_purchase_l_lot_no" class="purchase_l_lot_no"><div class="ew-table-header-caption"><?php echo $purchase_l->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $purchase_l->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->lot_no) ?>',2);"><div id="elh_purchase_l_lot_no" class="purchase_l_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->packets->Visible) { // packets ?>
	<?php if ($purchase_l->sortUrl($purchase_l->packets) == "") { ?>
		<th data-name="packets" class="<?php echo $purchase_l->packets->headerCellClass() ?>"><div id="elh_purchase_l_packets" class="purchase_l_packets"><div class="ew-table-header-caption"><?php echo $purchase_l->packets->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packets" class="<?php echo $purchase_l->packets->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->packets) ?>',2);"><div id="elh_purchase_l_packets" class="purchase_l_packets">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->packets->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->packets->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->packets->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->net_weight->Visible) { // net_weight ?>
	<?php if ($purchase_l->sortUrl($purchase_l->net_weight) == "") { ?>
		<th data-name="net_weight" class="<?php echo $purchase_l->net_weight->headerCellClass() ?>"><div id="elh_purchase_l_net_weight" class="purchase_l_net_weight"><div class="ew-table-header-caption"><?php echo $purchase_l->net_weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="net_weight" class="<?php echo $purchase_l->net_weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->net_weight) ?>',2);"><div id="elh_purchase_l_net_weight" class="purchase_l_net_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->net_weight->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->net_weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->net_weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->amount->Visible) { // amount ?>
	<?php if ($purchase_l->sortUrl($purchase_l->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $purchase_l->amount->headerCellClass() ?>"><div id="elh_purchase_l_amount" class="purchase_l_amount"><div class="ew-table-header-caption"><?php echo $purchase_l->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $purchase_l->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->amount) ?>',2);"><div id="elh_purchase_l_amount" class="purchase_l_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->godown->Visible) { // godown ?>
	<?php if ($purchase_l->sortUrl($purchase_l->godown) == "") { ?>
		<th data-name="godown" class="<?php echo $purchase_l->godown->headerCellClass() ?>"><div id="elh_purchase_l_godown" class="purchase_l_godown"><div class="ew-table-header-caption"><?php echo $purchase_l->godown->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown" class="<?php echo $purchase_l->godown->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->godown) ?>',2);"><div id="elh_purchase_l_godown" class="purchase_l_godown">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->godown->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->godown->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->godown->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->dated->Visible) { // dated ?>
	<?php if ($purchase_l->sortUrl($purchase_l->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $purchase_l->dated->headerCellClass() ?>"><div id="elh_purchase_l_dated" class="purchase_l_dated"><div class="ew-table-header-caption"><?php echo $purchase_l->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $purchase_l->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->dated) ?>',2);"><div id="elh_purchase_l_dated" class="purchase_l_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->operator->Visible) { // operator ?>
	<?php if ($purchase_l->sortUrl($purchase_l->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $purchase_l->operator->headerCellClass() ?>"><div id="elh_purchase_l_operator" class="purchase_l_operator"><div class="ew-table-header-caption"><?php echo $purchase_l->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $purchase_l->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->operator) ?>',2);"><div id="elh_purchase_l_operator" class="purchase_l_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->datetime->Visible) { // datetime ?>
	<?php if ($purchase_l->sortUrl($purchase_l->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $purchase_l->datetime->headerCellClass() ?>"><div id="elh_purchase_l_datetime" class="purchase_l_datetime"><div class="ew-table-header-caption"><?php echo $purchase_l->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $purchase_l->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->datetime) ?>',2);"><div id="elh_purchase_l_datetime" class="purchase_l_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->remarks->Visible) { // remarks ?>
	<?php if ($purchase_l->sortUrl($purchase_l->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $purchase_l->remarks->headerCellClass() ?>"><div id="elh_purchase_l_remarks" class="purchase_l_remarks"><div class="ew-table-header-caption"><?php echo $purchase_l->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $purchase_l->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->remarks) ?>',2);"><div id="elh_purchase_l_remarks" class="purchase_l_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->goods_inward->Visible) { // goods_inward ?>
	<?php if ($purchase_l->sortUrl($purchase_l->goods_inward) == "") { ?>
		<th data-name="goods_inward" class="<?php echo $purchase_l->goods_inward->headerCellClass() ?>"><div id="elh_purchase_l_goods_inward" class="purchase_l_goods_inward"><div class="ew-table-header-caption"><?php echo $purchase_l->goods_inward->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="goods_inward" class="<?php echo $purchase_l->goods_inward->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->goods_inward) ?>',2);"><div id="elh_purchase_l_goods_inward" class="purchase_l_goods_inward">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->goods_inward->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->goods_inward->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->goods_inward->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->invoice_details->Visible) { // invoice_details ?>
	<?php if ($purchase_l->sortUrl($purchase_l->invoice_details) == "") { ?>
		<th data-name="invoice_details" class="<?php echo $purchase_l->invoice_details->headerCellClass() ?>"><div id="elh_purchase_l_invoice_details" class="purchase_l_invoice_details"><div class="ew-table-header-caption"><?php echo $purchase_l->invoice_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="invoice_details" class="<?php echo $purchase_l->invoice_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->invoice_details) ?>',2);"><div id="elh_purchase_l_invoice_details" class="purchase_l_invoice_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->invoice_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->invoice_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->invoice_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->invoice_dated->Visible) { // invoice_dated ?>
	<?php if ($purchase_l->sortUrl($purchase_l->invoice_dated) == "") { ?>
		<th data-name="invoice_dated" class="<?php echo $purchase_l->invoice_dated->headerCellClass() ?>"><div id="elh_purchase_l_invoice_dated" class="purchase_l_invoice_dated"><div class="ew-table-header-caption"><?php echo $purchase_l->invoice_dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="invoice_dated" class="<?php echo $purchase_l->invoice_dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->invoice_dated) ?>',2);"><div id="elh_purchase_l_invoice_dated" class="purchase_l_invoice_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->invoice_dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->invoice_dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->invoice_dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->_barcode->Visible) { // barcode ?>
	<?php if ($purchase_l->sortUrl($purchase_l->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $purchase_l->_barcode->headerCellClass() ?>"><div id="elh_purchase_l__barcode" class="purchase_l__barcode"><div class="ew-table-header-caption"><?php echo $purchase_l->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $purchase_l->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->_barcode) ?>',2);"><div id="elh_purchase_l__barcode" class="purchase_l__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->return_details->Visible) { // return_details ?>
	<?php if ($purchase_l->sortUrl($purchase_l->return_details) == "") { ?>
		<th data-name="return_details" class="<?php echo $purchase_l->return_details->headerCellClass() ?>"><div id="elh_purchase_l_return_details" class="purchase_l_return_details"><div class="ew-table-header-caption"><?php echo $purchase_l->return_details->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="return_details" class="<?php echo $purchase_l->return_details->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->return_details) ?>',2);"><div id="elh_purchase_l_return_details" class="purchase_l_return_details">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->return_details->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->return_details->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->return_details->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->qc_status->Visible) { // qc_status ?>
	<?php if ($purchase_l->sortUrl($purchase_l->qc_status) == "") { ?>
		<th data-name="qc_status" class="<?php echo $purchase_l->qc_status->headerCellClass() ?>"><div id="elh_purchase_l_qc_status" class="purchase_l_qc_status"><div class="ew-table-header-caption"><?php echo $purchase_l->qc_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qc_status" class="<?php echo $purchase_l->qc_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->qc_status) ?>',2);"><div id="elh_purchase_l_qc_status" class="purchase_l_qc_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->qc_status->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->qc_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->qc_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->qc_operator->Visible) { // qc_operator ?>
	<?php if ($purchase_l->sortUrl($purchase_l->qc_operator) == "") { ?>
		<th data-name="qc_operator" class="<?php echo $purchase_l->qc_operator->headerCellClass() ?>"><div id="elh_purchase_l_qc_operator" class="purchase_l_qc_operator"><div class="ew-table-header-caption"><?php echo $purchase_l->qc_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qc_operator" class="<?php echo $purchase_l->qc_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->qc_operator) ?>',2);"><div id="elh_purchase_l_qc_operator" class="purchase_l_qc_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->qc_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->qc_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->qc_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->qc_datetime->Visible) { // qc_datetime ?>
	<?php if ($purchase_l->sortUrl($purchase_l->qc_datetime) == "") { ?>
		<th data-name="qc_datetime" class="<?php echo $purchase_l->qc_datetime->headerCellClass() ?>"><div id="elh_purchase_l_qc_datetime" class="purchase_l_qc_datetime"><div class="ew-table-header-caption"><?php echo $purchase_l->qc_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qc_datetime" class="<?php echo $purchase_l->qc_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->qc_datetime) ?>',2);"><div id="elh_purchase_l_qc_datetime" class="purchase_l_qc_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->qc_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->qc_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->qc_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($purchase_l->age->Visible) { // age ?>
	<?php if ($purchase_l->sortUrl($purchase_l->age) == "") { ?>
		<th data-name="age" class="<?php echo $purchase_l->age->headerCellClass() ?>"><div id="elh_purchase_l_age" class="purchase_l_age"><div class="ew-table-header-caption"><?php echo $purchase_l->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $purchase_l->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $purchase_l->SortUrl($purchase_l->age) ?>',2);"><div id="elh_purchase_l_age" class="purchase_l_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $purchase_l->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($purchase_l->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($purchase_l->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$purchase_l_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($purchase_l->ExportAll && $purchase_l->isExport()) {
	$purchase_l_list->StopRec = $purchase_l_list->TotalRecs;
} else {

	// Set the last record to display
	if ($purchase_l_list->TotalRecs > $purchase_l_list->StartRec + $purchase_l_list->DisplayRecs - 1)
		$purchase_l_list->StopRec = $purchase_l_list->StartRec + $purchase_l_list->DisplayRecs - 1;
	else
		$purchase_l_list->StopRec = $purchase_l_list->TotalRecs;
}
$purchase_l_list->RecCnt = $purchase_l_list->StartRec - 1;
if ($purchase_l_list->Recordset && !$purchase_l_list->Recordset->EOF) {
	$purchase_l_list->Recordset->moveFirst();
	$selectLimit = $purchase_l_list->UseSelectLimit;
	if (!$selectLimit && $purchase_l_list->StartRec > 1)
		$purchase_l_list->Recordset->move($purchase_l_list->StartRec - 1);
} elseif (!$purchase_l->AllowAddDeleteRow && $purchase_l_list->StopRec == 0) {
	$purchase_l_list->StopRec = $purchase_l->GridAddRowCount;
}

// Initialize aggregate
$purchase_l->RowType = ROWTYPE_AGGREGATEINIT;
$purchase_l->resetAttributes();
$purchase_l_list->renderRow();
while ($purchase_l_list->RecCnt < $purchase_l_list->StopRec) {
	$purchase_l_list->RecCnt++;
	if ($purchase_l_list->RecCnt >= $purchase_l_list->StartRec) {
		$purchase_l_list->RowCnt++;

		// Set up key count
		$purchase_l_list->KeyCount = $purchase_l_list->RowIndex;

		// Init row class and style
		$purchase_l->resetAttributes();
		$purchase_l->CssClass = "";
		if ($purchase_l->isGridAdd()) {
		} else {
			$purchase_l_list->loadRowValues($purchase_l_list->Recordset); // Load row values
		}
		$purchase_l->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$purchase_l->RowAttrs = array_merge($purchase_l->RowAttrs, array('data-rowindex'=>$purchase_l_list->RowCnt, 'id'=>'r' . $purchase_l_list->RowCnt . '_purchase_l', 'data-rowtype'=>$purchase_l->RowType));

		// Render row
		$purchase_l_list->renderRow();

		// Render list options
		$purchase_l_list->renderListOptions();
?>
	<tr<?php echo $purchase_l->rowAttributes() ?>>
<?php

// Render list options (body, left)
$purchase_l_list->ListOptions->render("body", "left", $purchase_l_list->RowCnt);
?>
	<?php if ($purchase_l->id->Visible) { // id ?>
		<td data-name="id"<?php echo $purchase_l->id->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_id" class="purchase_l_id">
<span<?php echo $purchase_l->id->viewAttributes() ?>>
<?php echo $purchase_l->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->type->Visible) { // type ?>
		<td data-name="type"<?php echo $purchase_l->type->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_type" class="purchase_l_type">
<span<?php echo $purchase_l->type->viewAttributes() ?>>
<?php echo $purchase_l->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->supplier->Visible) { // supplier ?>
		<td data-name="supplier"<?php echo $purchase_l->supplier->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_supplier" class="purchase_l_supplier">
<span<?php echo $purchase_l->supplier->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l->supplier->getViewValue())) && $purchase_l->supplier->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l->supplier->linkAttributes() ?>><?php echo $purchase_l->supplier->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l->supplier->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->po->Visible) { // po ?>
		<td data-name="po"<?php echo $purchase_l->po->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_po" class="purchase_l_po">
<span<?php echo $purchase_l->po->viewAttributes() ?>>
<?php echo $purchase_l->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $purchase_l->company_id->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_company_id" class="purchase_l_company_id">
<span<?php echo $purchase_l->company_id->viewAttributes() ?>>
<?php echo $purchase_l->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $purchase_l->rid->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_rid" class="purchase_l_rid">
<span<?php echo $purchase_l->rid->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l->rid->getViewValue())) && $purchase_l->rid->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l->rid->linkAttributes() ?>><?php echo $purchase_l->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $purchase_l->packing_type->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_packing_type" class="purchase_l_packing_type">
<span<?php echo $purchase_l->packing_type->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l->packing_type->getViewValue())) && $purchase_l->packing_type->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l->packing_type->linkAttributes() ?>><?php echo $purchase_l->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $purchase_l->lot_no->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_lot_no" class="purchase_l_lot_no">
<span<?php echo $purchase_l->lot_no->viewAttributes() ?>>
<?php echo $purchase_l->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->packets->Visible) { // packets ?>
		<td data-name="packets"<?php echo $purchase_l->packets->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_packets" class="purchase_l_packets">
<span<?php echo $purchase_l->packets->viewAttributes() ?>>
<?php echo $purchase_l->packets->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->net_weight->Visible) { // net_weight ?>
		<td data-name="net_weight"<?php echo $purchase_l->net_weight->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_net_weight" class="purchase_l_net_weight">
<span<?php echo $purchase_l->net_weight->viewAttributes() ?>>
<?php echo $purchase_l->net_weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $purchase_l->amount->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_amount" class="purchase_l_amount">
<span<?php echo $purchase_l->amount->viewAttributes() ?>>
<?php echo $purchase_l->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->godown->Visible) { // godown ?>
		<td data-name="godown"<?php echo $purchase_l->godown->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_godown" class="purchase_l_godown">
<span<?php echo $purchase_l->godown->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l->godown->getViewValue())) && $purchase_l->godown->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l->godown->linkAttributes() ?>><?php echo $purchase_l->godown->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $purchase_l->dated->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_dated" class="purchase_l_dated">
<span<?php echo $purchase_l->dated->viewAttributes() ?>>
<?php echo $purchase_l->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $purchase_l->operator->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_operator" class="purchase_l_operator">
<span<?php echo $purchase_l->operator->viewAttributes() ?>>
<?php echo $purchase_l->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $purchase_l->datetime->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_datetime" class="purchase_l_datetime">
<span<?php echo $purchase_l->datetime->viewAttributes() ?>>
<?php echo $purchase_l->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $purchase_l->remarks->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_remarks" class="purchase_l_remarks">
<span<?php echo $purchase_l->remarks->viewAttributes() ?>>
<?php echo $purchase_l->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->goods_inward->Visible) { // goods_inward ?>
		<td data-name="goods_inward"<?php echo $purchase_l->goods_inward->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_goods_inward" class="purchase_l_goods_inward">
<span<?php echo $purchase_l->goods_inward->viewAttributes() ?>>
<?php echo $purchase_l->goods_inward->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->invoice_details->Visible) { // invoice_details ?>
		<td data-name="invoice_details"<?php echo $purchase_l->invoice_details->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_invoice_details" class="purchase_l_invoice_details">
<span<?php echo $purchase_l->invoice_details->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l->invoice_details->getViewValue())) && $purchase_l->invoice_details->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l->invoice_details->linkAttributes() ?>><?php echo $purchase_l->invoice_details->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l->invoice_details->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->invoice_dated->Visible) { // invoice_dated ?>
		<td data-name="invoice_dated"<?php echo $purchase_l->invoice_dated->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_invoice_dated" class="purchase_l_invoice_dated">
<span<?php echo $purchase_l->invoice_dated->viewAttributes() ?>>
<?php if ((!EmptyString($purchase_l->invoice_dated->getViewValue())) && $purchase_l->invoice_dated->linkAttributes() <> "") { ?>
<a<?php echo $purchase_l->invoice_dated->linkAttributes() ?>><?php echo $purchase_l->invoice_dated->getViewValue() ?></a>
<?php } else { ?>
<?php echo $purchase_l->invoice_dated->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $purchase_l->_barcode->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l__barcode" class="purchase_l__barcode">
<span<?php echo $purchase_l->_barcode->viewAttributes() ?>>
<?php echo $purchase_l->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->return_details->Visible) { // return_details ?>
		<td data-name="return_details"<?php echo $purchase_l->return_details->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_return_details" class="purchase_l_return_details">
<span<?php echo $purchase_l->return_details->viewAttributes() ?>>
<?php echo $purchase_l->return_details->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->qc_status->Visible) { // qc_status ?>
		<td data-name="qc_status"<?php echo $purchase_l->qc_status->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_qc_status" class="purchase_l_qc_status">
<span<?php echo $purchase_l->qc_status->viewAttributes() ?>>
<?php echo $purchase_l->qc_status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->qc_operator->Visible) { // qc_operator ?>
		<td data-name="qc_operator"<?php echo $purchase_l->qc_operator->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_qc_operator" class="purchase_l_qc_operator">
<span<?php echo $purchase_l->qc_operator->viewAttributes() ?>>
<?php echo $purchase_l->qc_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->qc_datetime->Visible) { // qc_datetime ?>
		<td data-name="qc_datetime"<?php echo $purchase_l->qc_datetime->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_qc_datetime" class="purchase_l_qc_datetime">
<span<?php echo $purchase_l->qc_datetime->viewAttributes() ?>>
<?php echo $purchase_l->qc_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($purchase_l->age->Visible) { // age ?>
		<td data-name="age"<?php echo $purchase_l->age->cellAttributes() ?>>
<span id="el<?php echo $purchase_l_list->RowCnt ?>_purchase_l_age" class="purchase_l_age">
<span<?php echo $purchase_l->age->viewAttributes() ?>>
<?php echo $purchase_l->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$purchase_l_list->ListOptions->render("body", "right", $purchase_l_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$purchase_l->isGridAdd())
		$purchase_l_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$purchase_l->RowType = ROWTYPE_AGGREGATE;
$purchase_l->resetAttributes();
$purchase_l_list->renderRow();
?>
<?php if ($purchase_l_list->TotalRecs > 0 && !$purchase_l->isGridAdd() && !$purchase_l->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$purchase_l_list->renderListOptions();

// Render list options (footer, left)
$purchase_l_list->ListOptions->render("footer", "left");
?>
	<?php if ($purchase_l->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $purchase_l->id->footerCellClass() ?>"><span id="elf_purchase_l_id" class="purchase_l_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $purchase_l->type->footerCellClass() ?>"><span id="elf_purchase_l_type" class="purchase_l_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->supplier->Visible) { // supplier ?>
		<td data-name="supplier" class="<?php echo $purchase_l->supplier->footerCellClass() ?>"><span id="elf_purchase_l_supplier" class="purchase_l_supplier">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $purchase_l->po->footerCellClass() ?>"><span id="elf_purchase_l_po" class="purchase_l_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->company_id->Visible) { // company_id ?>
		<td data-name="company_id" class="<?php echo $purchase_l->company_id->footerCellClass() ?>"><span id="elf_purchase_l_company_id" class="purchase_l_company_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->rid->Visible) { // rid ?>
		<td data-name="rid" class="<?php echo $purchase_l->rid->footerCellClass() ?>"><span id="elf_purchase_l_rid" class="purchase_l_rid">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $purchase_l->packing_type->footerCellClass() ?>"><span id="elf_purchase_l_packing_type" class="purchase_l_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no" class="<?php echo $purchase_l->lot_no->footerCellClass() ?>"><span id="elf_purchase_l_lot_no" class="purchase_l_lot_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->packets->Visible) { // packets ?>
		<td data-name="packets" class="<?php echo $purchase_l->packets->footerCellClass() ?>"><span id="elf_purchase_l_packets" class="purchase_l_packets">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $purchase_l->packets->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->net_weight->Visible) { // net_weight ?>
		<td data-name="net_weight" class="<?php echo $purchase_l->net_weight->footerCellClass() ?>"><span id="elf_purchase_l_net_weight" class="purchase_l_net_weight">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $purchase_l->net_weight->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->amount->Visible) { // amount ?>
		<td data-name="amount" class="<?php echo $purchase_l->amount->footerCellClass() ?>"><span id="elf_purchase_l_amount" class="purchase_l_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $purchase_l->amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->godown->Visible) { // godown ?>
		<td data-name="godown" class="<?php echo $purchase_l->godown->footerCellClass() ?>"><span id="elf_purchase_l_godown" class="purchase_l_godown">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $purchase_l->dated->footerCellClass() ?>"><span id="elf_purchase_l_dated" class="purchase_l_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $purchase_l->operator->footerCellClass() ?>"><span id="elf_purchase_l_operator" class="purchase_l_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $purchase_l->datetime->footerCellClass() ?>"><span id="elf_purchase_l_datetime" class="purchase_l_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $purchase_l->remarks->footerCellClass() ?>"><span id="elf_purchase_l_remarks" class="purchase_l_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->goods_inward->Visible) { // goods_inward ?>
		<td data-name="goods_inward" class="<?php echo $purchase_l->goods_inward->footerCellClass() ?>"><span id="elf_purchase_l_goods_inward" class="purchase_l_goods_inward">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->invoice_details->Visible) { // invoice_details ?>
		<td data-name="invoice_details" class="<?php echo $purchase_l->invoice_details->footerCellClass() ?>"><span id="elf_purchase_l_invoice_details" class="purchase_l_invoice_details">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->invoice_dated->Visible) { // invoice_dated ?>
		<td data-name="invoice_dated" class="<?php echo $purchase_l->invoice_dated->footerCellClass() ?>"><span id="elf_purchase_l_invoice_dated" class="purchase_l_invoice_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode" class="<?php echo $purchase_l->_barcode->footerCellClass() ?>"><span id="elf_purchase_l__barcode" class="purchase_l__barcode">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->return_details->Visible) { // return_details ?>
		<td data-name="return_details" class="<?php echo $purchase_l->return_details->footerCellClass() ?>"><span id="elf_purchase_l_return_details" class="purchase_l_return_details">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->qc_status->Visible) { // qc_status ?>
		<td data-name="qc_status" class="<?php echo $purchase_l->qc_status->footerCellClass() ?>"><span id="elf_purchase_l_qc_status" class="purchase_l_qc_status">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->qc_operator->Visible) { // qc_operator ?>
		<td data-name="qc_operator" class="<?php echo $purchase_l->qc_operator->footerCellClass() ?>"><span id="elf_purchase_l_qc_operator" class="purchase_l_qc_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->qc_datetime->Visible) { // qc_datetime ?>
		<td data-name="qc_datetime" class="<?php echo $purchase_l->qc_datetime->footerCellClass() ?>"><span id="elf_purchase_l_qc_datetime" class="purchase_l_qc_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($purchase_l->age->Visible) { // age ?>
		<td data-name="age" class="<?php echo $purchase_l->age->footerCellClass() ?>"><span id="elf_purchase_l_age" class="purchase_l_age">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$purchase_l_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$purchase_l->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($purchase_l_list->Recordset)
	$purchase_l_list->Recordset->Close();
?>
<?php if (!$purchase_l->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$purchase_l->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($purchase_l_list->Pager)) $purchase_l_list->Pager = new PrevNextPager($purchase_l_list->StartRec, $purchase_l_list->DisplayRecs, $purchase_l_list->TotalRecs, $purchase_l_list->AutoHidePager) ?>
<?php if ($purchase_l_list->Pager->RecordCount > 0 && $purchase_l_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($purchase_l_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $purchase_l_list->pageUrl() ?>start=<?php echo $purchase_l_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($purchase_l_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $purchase_l_list->pageUrl() ?>start=<?php echo $purchase_l_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $purchase_l_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($purchase_l_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $purchase_l_list->pageUrl() ?>start=<?php echo $purchase_l_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($purchase_l_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $purchase_l_list->pageUrl() ?>start=<?php echo $purchase_l_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $purchase_l_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($purchase_l_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $purchase_l_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $purchase_l_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $purchase_l_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($purchase_l_list->TotalRecs > 0 && (!$purchase_l_list->AutoHidePageSizeSelector || $purchase_l_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="purchase_l">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($purchase_l_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($purchase_l_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($purchase_l_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($purchase_l_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($purchase_l_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($purchase_l->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $purchase_l_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($purchase_l_list->TotalRecs == 0 && !$purchase_l->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $purchase_l_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$purchase_l_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$purchase_l->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$purchase_l->isExport()) { ?>
<script>
ew.scrollableTable("gmp_purchase_l", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$purchase_l_list->terminate();
?>