<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$purchase_l_search = new purchase_l_search();

// Run the page
$purchase_l_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$purchase_l_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($purchase_l_search->IsModal) { ?>
var fpurchase_lsearch = currentAdvancedSearchForm = new ew.Form("fpurchase_lsearch", "search");
<?php } else { ?>
var fpurchase_lsearch = currentForm = new ew.Form("fpurchase_lsearch", "search");
<?php } ?>

// Form_CustomValidate event
fpurchase_lsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fpurchase_lsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fpurchase_lsearch.lists["x_type"] = <?php echo $purchase_l_search->type->Lookup->toClientList() ?>;
fpurchase_lsearch.lists["x_type"].options = <?php echo JsonEncode($purchase_l_search->type->lookupOptions()) ?>;
fpurchase_lsearch.lists["x_po"] = <?php echo $purchase_l_search->po->Lookup->toClientList() ?>;
fpurchase_lsearch.lists["x_po"].options = <?php echo JsonEncode($purchase_l_search->po->lookupOptions()) ?>;
fpurchase_lsearch.autoSuggests["x_po"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_lsearch.lists["x_po_return"] = <?php echo $purchase_l_search->po_return->Lookup->toClientList() ?>;
fpurchase_lsearch.lists["x_po_return"].options = <?php echo JsonEncode($purchase_l_search->po_return->lookupOptions()) ?>;
fpurchase_lsearch.autoSuggests["x_po_return"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_lsearch.lists["x_grp"] = <?php echo $purchase_l_search->grp->Lookup->toClientList() ?>;
fpurchase_lsearch.lists["x_grp"].options = <?php echo JsonEncode($purchase_l_search->grp->lookupOptions()) ?>;
fpurchase_lsearch.lists["x_s_grp"] = <?php echo $purchase_l_search->s_grp->Lookup->toClientList() ?>;
fpurchase_lsearch.lists["x_s_grp"].options = <?php echo JsonEncode($purchase_l_search->s_grp->lookupOptions()) ?>;
fpurchase_lsearch.lists["x_product"] = <?php echo $purchase_l_search->product->Lookup->toClientList() ?>;
fpurchase_lsearch.lists["x_product"].options = <?php echo JsonEncode($purchase_l_search->product->lookupOptions()) ?>;
fpurchase_lsearch.lists["x_rid_return"] = <?php echo $purchase_l_search->rid_return->Lookup->toClientList() ?>;
fpurchase_lsearch.lists["x_rid_return"].options = <?php echo JsonEncode($purchase_l_search->rid_return->lookupOptions()) ?>;
fpurchase_lsearch.lists["x_rid"] = <?php echo $purchase_l_search->rid->Lookup->toClientList() ?>;
fpurchase_lsearch.lists["x_rid"].options = <?php echo JsonEncode($purchase_l_search->rid->lookupOptions()) ?>;
fpurchase_lsearch.autoSuggests["x_rid"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_lsearch.lists["x_packing_type"] = <?php echo $purchase_l_search->packing_type->Lookup->toClientList() ?>;
fpurchase_lsearch.lists["x_packing_type"].options = <?php echo JsonEncode($purchase_l_search->packing_type->lookupOptions()) ?>;
fpurchase_lsearch.lists["x_lot_no"] = <?php echo $purchase_l_search->lot_no->Lookup->toClientList() ?>;
fpurchase_lsearch.lists["x_lot_no"].options = <?php echo JsonEncode($purchase_l_search->lot_no->lookupOptions()) ?>;
fpurchase_lsearch.autoSuggests["x_lot_no"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fpurchase_lsearch.lists["x_godown"] = <?php echo $purchase_l_search->godown->Lookup->toClientList() ?>;
fpurchase_lsearch.lists["x_godown"].options = <?php echo JsonEncode($purchase_l_search->godown->lookupOptions()) ?>;
fpurchase_lsearch.lists["x_operator"] = <?php echo $purchase_l_search->operator->Lookup->toClientList() ?>;
fpurchase_lsearch.lists["x_operator"].options = <?php echo JsonEncode($purchase_l_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fpurchase_lsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_supplier");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->supplier->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po_return");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->po_return->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packets");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->packets->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_net_weight");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->net_weight->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__40");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->_40->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_audit");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->audit->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_a_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->a_operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_a_datetime");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->a_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qc_status");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->qc_status->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qc_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->qc_operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qc_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->qc_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_age");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($purchase_l->age->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $purchase_l_search->showPageHeader(); ?>
<?php
$purchase_l_search->showMessage();
?>
<form name="fpurchase_lsearch" id="fpurchase_lsearch" class="<?php echo $purchase_l_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($purchase_l_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $purchase_l_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="purchase_l">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$purchase_l_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($purchase_l->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_id"><?php echo $purchase_l->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->id->cellAttributes() ?>>
			<span id="el_purchase_l_id">
<input type="text" data-table="purchase_l" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($purchase_l->id->getPlaceHolder()) ?>" value="<?php echo $purchase_l->id->EditValue ?>"<?php echo $purchase_l->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_type"><?php echo $purchase_l->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->type->cellAttributes() ?>>
			<span id="el_purchase_l_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l" data-field="x_type" data-value-separator="<?php echo $purchase_l->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $purchase_l->type->editAttributes() ?>>
		<?php echo $purchase_l->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $purchase_l->type->Lookup->getParamTag("p_x_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_po"><?php echo $purchase_l->po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po" id="z_po" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->po->cellAttributes() ?>>
			<span id="el_purchase_l_po">
<?php
$wrkonchange = "" . trim(@$purchase_l->po->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l->po->EditAttrs["onchange"] = "";
?>
<span id="as_x_po" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_po" id="sv_x_po" value="<?php echo RemoveHtml($purchase_l->po->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l->po->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l->po->getPlaceHolder()) ?>"<?php echo $purchase_l->po->editAttributes() ?>>
</span>
<input type="hidden" data-table="purchase_l" data-field="x_po" data-value-separator="<?php echo $purchase_l->po->displayValueSeparatorAttribute() ?>" name="x_po" id="x_po" value="<?php echo HtmlEncode($purchase_l->po->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_lsearch.createAutoSuggest({"id":"x_po","forceSelect":false});
</script>
<?php echo $purchase_l->po->Lookup->getParamTag("p_x_po") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->po_return->Visible) { // po_return ?>
	<div id="r_po_return" class="form-group row">
		<label class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_po_return"><?php echo $purchase_l->po_return->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_po_return" id="z_po_return" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->po_return->cellAttributes() ?>>
			<span id="el_purchase_l_po_return">
<?php
$wrkonchange = "" . trim(@$purchase_l->po_return->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l->po_return->EditAttrs["onchange"] = "";
?>
<span id="as_x_po_return" class="text-nowrap" style="z-index: 8950">
	<input type="text" class="form-control" name="sv_x_po_return" id="sv_x_po_return" value="<?php echo RemoveHtml($purchase_l->po_return->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l->po_return->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l->po_return->getPlaceHolder()) ?>"<?php echo $purchase_l->po_return->editAttributes() ?>>
</span>
<input type="hidden" data-table="purchase_l" data-field="x_po_return" data-value-separator="<?php echo $purchase_l->po_return->displayValueSeparatorAttribute() ?>" name="x_po_return" id="x_po_return" value="<?php echo HtmlEncode($purchase_l->po_return->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_lsearch.createAutoSuggest({"id":"x_po_return","forceSelect":true});
</script>
<?php echo $purchase_l->po_return->Lookup->getParamTag("p_x_po_return") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_grp"><?php echo $purchase_l->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->grp->cellAttributes() ?>>
			<span id="el_purchase_l_grp">
<?php $purchase_l->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$purchase_l->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l" data-field="x_grp" data-value-separator="<?php echo $purchase_l->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $purchase_l->grp->editAttributes() ?>>
		<?php echo $purchase_l->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $purchase_l->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label for="x_s_grp" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_s_grp"><?php echo $purchase_l->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->s_grp->cellAttributes() ?>>
			<span id="el_purchase_l_s_grp">
<?php $purchase_l->s_grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$purchase_l->s_grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l" data-field="x_s_grp" data-value-separator="<?php echo $purchase_l->s_grp->displayValueSeparatorAttribute() ?>" id="x_s_grp" name="x_s_grp"<?php echo $purchase_l->s_grp->editAttributes() ?>>
		<?php echo $purchase_l->s_grp->selectOptionListHtml("x_s_grp") ?>
	</select>
</div>
<?php echo $purchase_l->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_product"><?php echo $purchase_l->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->product->cellAttributes() ?>>
			<span id="el_purchase_l_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l" data-field="x_product" data-value-separator="<?php echo $purchase_l->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $purchase_l->product->editAttributes() ?>>
		<?php echo $purchase_l->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $purchase_l->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->rid_return->Visible) { // rid_return ?>
	<div id="r_rid_return" class="form-group row">
		<label for="x_rid_return" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_rid_return"><?php echo $purchase_l->rid_return->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid_return" id="z_rid_return" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->rid_return->cellAttributes() ?>>
			<span id="el_purchase_l_rid_return">
<input type="text" data-table="purchase_l" data-field="x_rid_return" name="x_rid_return" id="x_rid_return" size="30" placeholder="<?php echo HtmlEncode($purchase_l->rid_return->getPlaceHolder()) ?>" value="<?php echo $purchase_l->rid_return->EditValue ?>"<?php echo $purchase_l->rid_return->editAttributes() ?>>
<?php echo $purchase_l->rid_return->Lookup->getParamTag("p_x_rid_return") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_rid"><?php echo $purchase_l->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->rid->cellAttributes() ?>>
			<span id="el_purchase_l_rid">
<?php
$wrkonchange = "" . trim(@$purchase_l->rid->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l->rid->EditAttrs["onchange"] = "";
?>
<span id="as_x_rid" class="text-nowrap" style="z-index: 8890">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?php echo RemoveHtml($purchase_l->rid->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l->rid->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l->rid->getPlaceHolder()) ?>"<?php echo $purchase_l->rid->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($purchase_l->rid->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_rid',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($purchase_l->rid->ReadOnly || $purchase_l->rid->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="purchase_l" data-field="x_rid" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $purchase_l->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?php echo HtmlEncode($purchase_l->rid->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_lsearch.createAutoSuggest({"id":"x_rid","forceSelect":false});
</script>
<?php echo $purchase_l->rid->Lookup->getParamTag("p_x_rid") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_packing_type"><?php echo $purchase_l->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->packing_type->cellAttributes() ?>>
			<span id="el_purchase_l_packing_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l" data-field="x_packing_type" data-value-separator="<?php echo $purchase_l->packing_type->displayValueSeparatorAttribute() ?>" id="x_packing_type" name="x_packing_type"<?php echo $purchase_l->packing_type->editAttributes() ?>>
		<?php echo $purchase_l->packing_type->selectOptionListHtml("x_packing_type") ?>
	</select>
</div>
<?php echo $purchase_l->packing_type->Lookup->getParamTag("p_x_packing_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->lot_no->Visible) { // lot_no ?>
	<div id="r_lot_no" class="form-group row">
		<label class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_lot_no"><?php echo $purchase_l->lot_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lot_no" id="z_lot_no" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->lot_no->cellAttributes() ?>>
			<span id="el_purchase_l_lot_no">
<?php
$wrkonchange = "" . trim(@$purchase_l->lot_no->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$purchase_l->lot_no->EditAttrs["onchange"] = "";
?>
<span id="as_x_lot_no" class="text-nowrap" style="z-index: 8870">
	<input type="text" class="form-control" name="sv_x_lot_no" id="sv_x_lot_no" value="<?php echo RemoveHtml($purchase_l->lot_no->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($purchase_l->lot_no->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($purchase_l->lot_no->getPlaceHolder()) ?>"<?php echo $purchase_l->lot_no->editAttributes() ?>>
</span>
<input type="hidden" data-table="purchase_l" data-field="x_lot_no" data-value-separator="<?php echo $purchase_l->lot_no->displayValueSeparatorAttribute() ?>" name="x_lot_no" id="x_lot_no" value="<?php echo HtmlEncode($purchase_l->lot_no->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fpurchase_lsearch.createAutoSuggest({"id":"x_lot_no","forceSelect":false});
</script>
<?php echo $purchase_l->lot_no->Lookup->getParamTag("p_x_lot_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->packets->Visible) { // packets ?>
	<div id="r_packets" class="form-group row">
		<label for="x_packets" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_packets"><?php echo $purchase_l->packets->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->packets->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_packets" id="z_packets" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_l->packets->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_l->packets->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_l->packets->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_l->packets->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_l->packets->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_l->packets->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($purchase_l->packets->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($purchase_l->packets->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($purchase_l->packets->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_l_packets">
<input type="text" data-table="purchase_l" data-field="x_packets" name="x_packets" id="x_packets" size="30" placeholder="<?php echo HtmlEncode($purchase_l->packets->getPlaceHolder()) ?>" value="<?php echo $purchase_l->packets->EditValue ?>"<?php echo $purchase_l->packets->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_packets d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_l_packets" class="btw1_packets d-none">
<input type="text" data-table="purchase_l" data-field="x_packets" name="y_packets" id="y_packets" size="30" placeholder="<?php echo HtmlEncode($purchase_l->packets->getPlaceHolder()) ?>" value="<?php echo $purchase_l->packets->EditValue2 ?>"<?php echo $purchase_l->packets->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->net_weight->Visible) { // net_weight ?>
	<div id="r_net_weight" class="form-group row">
		<label for="x_net_weight" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_net_weight"><?php echo $purchase_l->net_weight->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->net_weight->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_net_weight" id="z_net_weight" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_l->net_weight->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_l->net_weight->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_l->net_weight->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_l->net_weight->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_l->net_weight->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_l->net_weight->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($purchase_l->net_weight->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($purchase_l->net_weight->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($purchase_l->net_weight->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_l_net_weight">
<input type="text" data-table="purchase_l" data-field="x_net_weight" name="x_net_weight" id="x_net_weight" size="30" placeholder="<?php echo HtmlEncode($purchase_l->net_weight->getPlaceHolder()) ?>" value="<?php echo $purchase_l->net_weight->EditValue ?>"<?php echo $purchase_l->net_weight->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_net_weight d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_l_net_weight" class="btw1_net_weight d-none">
<input type="text" data-table="purchase_l" data-field="x_net_weight" name="y_net_weight" id="y_net_weight" size="30" placeholder="<?php echo HtmlEncode($purchase_l->net_weight->getPlaceHolder()) ?>" value="<?php echo $purchase_l->net_weight->EditValue2 ?>"<?php echo $purchase_l->net_weight->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->_40->Visible) { // @ ?>
	<div id="r__40" class="form-group row">
		<label for="x__40" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l__40"><?php echo $purchase_l->_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__40" id="z__40" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->_40->cellAttributes() ?>>
			<span id="el_purchase_l__40">
<input type="text" data-table="purchase_l" data-field="x__40" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($purchase_l->_40->getPlaceHolder()) ?>" value="<?php echo $purchase_l->_40->EditValue ?>"<?php echo $purchase_l->_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_amount"><?php echo $purchase_l->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->amount->cellAttributes() ?>>
			<span id="el_purchase_l_amount">
<input type="text" data-table="purchase_l" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($purchase_l->amount->getPlaceHolder()) ?>" value="<?php echo $purchase_l->amount->EditValue ?>"<?php echo $purchase_l->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->godown->Visible) { // godown ?>
	<div id="r_godown" class="form-group row">
		<label for="x_godown" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_godown"><?php echo $purchase_l->godown->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown" id="z_godown" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->godown->cellAttributes() ?>>
			<span id="el_purchase_l_godown">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l" data-field="x_godown" data-value-separator="<?php echo $purchase_l->godown->displayValueSeparatorAttribute() ?>" id="x_godown" name="x_godown"<?php echo $purchase_l->godown->editAttributes() ?>>
		<?php echo $purchase_l->godown->selectOptionListHtml("x_godown") ?>
	</select>
</div>
<?php echo $purchase_l->godown->Lookup->getParamTag("p_x_godown") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_dated"><?php echo $purchase_l->dated->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_l->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_l->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_l->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_l->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_l->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_l->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($purchase_l->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($purchase_l->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($purchase_l->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_l_dated">
<input type="text" data-table="purchase_l" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($purchase_l->dated->getPlaceHolder()) ?>" value="<?php echo $purchase_l->dated->EditValue ?>"<?php echo $purchase_l->dated->editAttributes() ?>>
<?php if (!$purchase_l->dated->ReadOnly && !$purchase_l->dated->Disabled && !isset($purchase_l->dated->EditAttrs["readonly"]) && !isset($purchase_l->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_lsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_l_dated" class="btw1_dated d-none">
<input type="text" data-table="purchase_l" data-field="x_dated" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($purchase_l->dated->getPlaceHolder()) ?>" value="<?php echo $purchase_l->dated->EditValue2 ?>"<?php echo $purchase_l->dated->editAttributes() ?>>
<?php if (!$purchase_l->dated->ReadOnly && !$purchase_l->dated->Disabled && !isset($purchase_l->dated->EditAttrs["readonly"]) && !isset($purchase_l->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_lsearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_operator"><?php echo $purchase_l->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->operator->cellAttributes() ?>>
			<span id="el_purchase_l_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="purchase_l" data-field="x_operator" data-value-separator="<?php echo $purchase_l->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $purchase_l->operator->editAttributes() ?>>
		<?php echo $purchase_l->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $purchase_l->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->rack->Visible) { // rack ?>
	<div id="r_rack" class="form-group row">
		<label for="x_rack" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_rack"><?php echo $purchase_l->rack->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_rack" id="z_rack" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->rack->cellAttributes() ?>>
			<span id="el_purchase_l_rack">
<input type="text" data-table="purchase_l" data-field="x_rack" name="x_rack" id="x_rack" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($purchase_l->rack->getPlaceHolder()) ?>" value="<?php echo $purchase_l->rack->EditValue ?>"<?php echo $purchase_l->rack->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_datetime"><?php echo $purchase_l->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($purchase_l->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($purchase_l->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($purchase_l->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($purchase_l->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($purchase_l->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($purchase_l->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($purchase_l->datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($purchase_l->datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($purchase_l->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_purchase_l_datetime">
<input type="text" data-table="purchase_l" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($purchase_l->datetime->getPlaceHolder()) ?>" value="<?php echo $purchase_l->datetime->EditValue ?>"<?php echo $purchase_l->datetime->editAttributes() ?>>
<?php if (!$purchase_l->datetime->ReadOnly && !$purchase_l->datetime->Disabled && !isset($purchase_l->datetime->EditAttrs["readonly"]) && !isset($purchase_l->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_lsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_purchase_l_datetime" class="btw1_datetime d-none">
<input type="text" data-table="purchase_l" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($purchase_l->datetime->getPlaceHolder()) ?>" value="<?php echo $purchase_l->datetime->EditValue2 ?>"<?php echo $purchase_l->datetime->editAttributes() ?>>
<?php if (!$purchase_l->datetime->ReadOnly && !$purchase_l->datetime->Disabled && !isset($purchase_l->datetime->EditAttrs["readonly"]) && !isset($purchase_l->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_lsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_remarks"><?php echo $purchase_l->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->remarks->cellAttributes() ?>>
			<span id="el_purchase_l_remarks">
<input type="text" data-table="purchase_l" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($purchase_l->remarks->getPlaceHolder()) ?>" value="<?php echo $purchase_l->remarks->EditValue ?>"<?php echo $purchase_l->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->goods_inward->Visible) { // goods_inward ?>
	<div id="r_goods_inward" class="form-group row">
		<label for="x_goods_inward" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_goods_inward"><?php echo $purchase_l->goods_inward->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_goods_inward" id="z_goods_inward" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->goods_inward->cellAttributes() ?>>
			<span id="el_purchase_l_goods_inward">
<input type="text" data-table="purchase_l" data-field="x_goods_inward" name="x_goods_inward" id="x_goods_inward" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($purchase_l->goods_inward->getPlaceHolder()) ?>" value="<?php echo $purchase_l->goods_inward->EditValue ?>"<?php echo $purchase_l->goods_inward->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->invoice_details->Visible) { // invoice_details ?>
	<div id="r_invoice_details" class="form-group row">
		<label for="x_invoice_details" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_invoice_details"><?php echo $purchase_l->invoice_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_invoice_details" id="z_invoice_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->invoice_details->cellAttributes() ?>>
			<span id="el_purchase_l_invoice_details">
<input type="text" data-table="purchase_l" data-field="x_invoice_details" name="x_invoice_details" id="x_invoice_details" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($purchase_l->invoice_details->getPlaceHolder()) ?>" value="<?php echo $purchase_l->invoice_details->EditValue ?>"<?php echo $purchase_l->invoice_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l__barcode"><?php echo $purchase_l->_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__barcode" id="z__barcode" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->_barcode->cellAttributes() ?>>
			<span id="el_purchase_l__barcode">
<input type="text" data-table="purchase_l" data-field="x__barcode" name="x__barcode" id="x__barcode" size="35" placeholder="<?php echo HtmlEncode($purchase_l->_barcode->getPlaceHolder()) ?>" value="<?php echo $purchase_l->_barcode->EditValue ?>"<?php echo $purchase_l->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->return_details->Visible) { // return_details ?>
	<div id="r_return_details" class="form-group row">
		<label for="x_return_details" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_return_details"><?php echo $purchase_l->return_details->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_return_details" id="z_return_details" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->return_details->cellAttributes() ?>>
			<span id="el_purchase_l_return_details">
<input type="text" data-table="purchase_l" data-field="x_return_details" name="x_return_details" id="x_return_details" maxlength="250" placeholder="<?php echo HtmlEncode($purchase_l->return_details->getPlaceHolder()) ?>" value="<?php echo $purchase_l->return_details->EditValue ?>"<?php echo $purchase_l->return_details->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->audit->Visible) { // audit ?>
	<div id="r_audit" class="form-group row">
		<label for="x_audit" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_audit"><?php echo $purchase_l->audit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_audit" id="z_audit" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->audit->cellAttributes() ?>>
			<span id="el_purchase_l_audit">
<input type="text" data-table="purchase_l" data-field="x_audit" name="x_audit" id="x_audit" size="30" placeholder="<?php echo HtmlEncode($purchase_l->audit->getPlaceHolder()) ?>" value="<?php echo $purchase_l->audit->EditValue ?>"<?php echo $purchase_l->audit->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->a_operator->Visible) { // a_operator ?>
	<div id="r_a_operator" class="form-group row">
		<label for="x_a_operator" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_a_operator"><?php echo $purchase_l->a_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_operator" id="z_a_operator" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->a_operator->cellAttributes() ?>>
			<span id="el_purchase_l_a_operator">
<input type="text" data-table="purchase_l" data-field="x_a_operator" name="x_a_operator" id="x_a_operator" size="30" placeholder="<?php echo HtmlEncode($purchase_l->a_operator->getPlaceHolder()) ?>" value="<?php echo $purchase_l->a_operator->EditValue ?>"<?php echo $purchase_l->a_operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->a_datetime->Visible) { // a_datetime ?>
	<div id="r_a_datetime" class="form-group row">
		<label for="x_a_datetime" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_a_datetime"><?php echo $purchase_l->a_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_datetime" id="z_a_datetime" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->a_datetime->cellAttributes() ?>>
			<span id="el_purchase_l_a_datetime">
<input type="text" data-table="purchase_l" data-field="x_a_datetime" name="x_a_datetime" id="x_a_datetime" size="30" placeholder="<?php echo HtmlEncode($purchase_l->a_datetime->getPlaceHolder()) ?>" value="<?php echo $purchase_l->a_datetime->EditValue ?>"<?php echo $purchase_l->a_datetime->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->qc_remarks->Visible) { // qc_remarks ?>
	<div id="r_qc_remarks" class="form-group row">
		<label for="x_qc_remarks" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_qc_remarks"><?php echo $purchase_l->qc_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_qc_remarks" id="z_qc_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->qc_remarks->cellAttributes() ?>>
			<span id="el_purchase_l_qc_remarks">
<input type="text" data-table="purchase_l" data-field="x_qc_remarks" name="x_qc_remarks" id="x_qc_remarks" size="35" placeholder="<?php echo HtmlEncode($purchase_l->qc_remarks->getPlaceHolder()) ?>" value="<?php echo $purchase_l->qc_remarks->EditValue ?>"<?php echo $purchase_l->qc_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->qc_status->Visible) { // qc_status ?>
	<div id="r_qc_status" class="form-group row">
		<label for="x_qc_status" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_qc_status"><?php echo $purchase_l->qc_status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qc_status" id="z_qc_status" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->qc_status->cellAttributes() ?>>
			<span id="el_purchase_l_qc_status">
<input type="text" data-table="purchase_l" data-field="x_qc_status" name="x_qc_status" id="x_qc_status" size="30" placeholder="<?php echo HtmlEncode($purchase_l->qc_status->getPlaceHolder()) ?>" value="<?php echo $purchase_l->qc_status->EditValue ?>"<?php echo $purchase_l->qc_status->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->qc_operator->Visible) { // qc_operator ?>
	<div id="r_qc_operator" class="form-group row">
		<label for="x_qc_operator" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_qc_operator"><?php echo $purchase_l->qc_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qc_operator" id="z_qc_operator" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->qc_operator->cellAttributes() ?>>
			<span id="el_purchase_l_qc_operator">
<input type="text" data-table="purchase_l" data-field="x_qc_operator" name="x_qc_operator" id="x_qc_operator" size="30" placeholder="<?php echo HtmlEncode($purchase_l->qc_operator->getPlaceHolder()) ?>" value="<?php echo $purchase_l->qc_operator->EditValue ?>"<?php echo $purchase_l->qc_operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->qc_datetime->Visible) { // qc_datetime ?>
	<div id="r_qc_datetime" class="form-group row">
		<label for="x_qc_datetime" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_qc_datetime"><?php echo $purchase_l->qc_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qc_datetime" id="z_qc_datetime" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->qc_datetime->cellAttributes() ?>>
			<span id="el_purchase_l_qc_datetime">
<input type="text" data-table="purchase_l" data-field="x_qc_datetime" name="x_qc_datetime" id="x_qc_datetime" placeholder="<?php echo HtmlEncode($purchase_l->qc_datetime->getPlaceHolder()) ?>" value="<?php echo $purchase_l->qc_datetime->EditValue ?>"<?php echo $purchase_l->qc_datetime->editAttributes() ?>>
<?php if (!$purchase_l->qc_datetime->ReadOnly && !$purchase_l->qc_datetime->Disabled && !isset($purchase_l->qc_datetime->EditAttrs["readonly"]) && !isset($purchase_l->qc_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fpurchase_lsearch", "x_qc_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($purchase_l->age->Visible) { // age ?>
	<div id="r_age" class="form-group row">
		<label for="x_age" class="<?php echo $purchase_l_search->LeftColumnClass ?>"><span id="elh_purchase_l_age"><?php echo $purchase_l->age->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_age" id="z_age" value="="></span>
		</label>
		<div class="<?php echo $purchase_l_search->RightColumnClass ?>"><div<?php echo $purchase_l->age->cellAttributes() ?>>
			<span id="el_purchase_l_age">
<input type="text" data-table="purchase_l" data-field="x_age" name="x_age" id="x_age" size="30" placeholder="<?php echo HtmlEncode($purchase_l->age->getPlaceHolder()) ?>" value="<?php echo $purchase_l->age->EditValue ?>"<?php echo $purchase_l->age->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$purchase_l_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $purchase_l_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$purchase_l_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$purchase_l_search->terminate();
?>