<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_authorised_list = new qc_authorised_list();

// Run the page
$qc_authorised_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_authorised_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$qc_authorised->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fqc_authorisedlist = currentForm = new ew.Form("fqc_authorisedlist", "list");
fqc_authorisedlist.formKeyCountName = '<?php echo $qc_authorised_list->FormKeyCountName ?>';

// Form_CustomValidate event
fqc_authorisedlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_authorisedlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_authorisedlist.lists["x_location"] = <?php echo $qc_authorised_list->location->Lookup->toClientList() ?>;
fqc_authorisedlist.lists["x_location"].options = <?php echo JsonEncode($qc_authorised_list->location->lookupOptions()) ?>;
fqc_authorisedlist.lists["x_defect_nature"] = <?php echo $qc_authorised_list->defect_nature->Lookup->toClientList() ?>;
fqc_authorisedlist.lists["x_defect_nature"].options = <?php echo JsonEncode($qc_authorised_list->defect_nature->lookupOptions()) ?>;
fqc_authorisedlist.lists["x_qc_stage"] = <?php echo $qc_authorised_list->qc_stage->Lookup->toClientList() ?>;
fqc_authorisedlist.lists["x_qc_stage"].options = <?php echo JsonEncode($qc_authorised_list->qc_stage->lookupOptions()) ?>;
fqc_authorisedlist.lists["x_defect_percentage"] = <?php echo $qc_authorised_list->defect_percentage->Lookup->toClientList() ?>;
fqc_authorisedlist.lists["x_defect_percentage"].options = <?php echo JsonEncode($qc_authorised_list->defect_percentage->lookupOptions()) ?>;
fqc_authorisedlist.lists["x_status"] = <?php echo $qc_authorised_list->status->Lookup->toClientList() ?>;
fqc_authorisedlist.lists["x_status"].options = <?php echo JsonEncode($qc_authorised_list->status->lookupOptions()) ?>;
fqc_authorisedlist.lists["x__action"] = <?php echo $qc_authorised_list->_action->Lookup->toClientList() ?>;
fqc_authorisedlist.lists["x__action"].options = <?php echo JsonEncode($qc_authorised_list->_action->lookupOptions()) ?>;
fqc_authorisedlist.lists["x_operator"] = <?php echo $qc_authorised_list->operator->Lookup->toClientList() ?>;
fqc_authorisedlist.lists["x_operator"].options = <?php echo JsonEncode($qc_authorised_list->operator->lookupOptions()) ?>;
fqc_authorisedlist.lists["x_a_operator"] = <?php echo $qc_authorised_list->a_operator->Lookup->toClientList() ?>;
fqc_authorisedlist.lists["x_a_operator"].options = <?php echo JsonEncode($qc_authorised_list->a_operator->lookupOptions()) ?>;

// Form object for search
var fqc_authorisedlistsrch = currentSearchForm = new ew.Form("fqc_authorisedlistsrch");

// Validate function for search
fqc_authorisedlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_authorised->_barcode->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fqc_authorisedlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_authorisedlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_authorisedlistsrch.lists["x_location"] = <?php echo $qc_authorised_list->location->Lookup->toClientList() ?>;
fqc_authorisedlistsrch.lists["x_location"].options = <?php echo JsonEncode($qc_authorised_list->location->lookupOptions()) ?>;
fqc_authorisedlistsrch.lists["x_defect_nature"] = <?php echo $qc_authorised_list->defect_nature->Lookup->toClientList() ?>;
fqc_authorisedlistsrch.lists["x_defect_nature"].options = <?php echo JsonEncode($qc_authorised_list->defect_nature->lookupOptions()) ?>;
fqc_authorisedlistsrch.lists["x_qc_stage"] = <?php echo $qc_authorised_list->qc_stage->Lookup->toClientList() ?>;
fqc_authorisedlistsrch.lists["x_qc_stage"].options = <?php echo JsonEncode($qc_authorised_list->qc_stage->lookupOptions()) ?>;
fqc_authorisedlistsrch.lists["x_status"] = <?php echo $qc_authorised_list->status->Lookup->toClientList() ?>;
fqc_authorisedlistsrch.lists["x_status"].options = <?php echo JsonEncode($qc_authorised_list->status->lookupOptions()) ?>;

// Filters
fqc_authorisedlistsrch.filterList = <?php echo $qc_authorised_list->getFilterList() ?>;

// Init search panel as collapsed
fqc_authorisedlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$qc_authorised->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($qc_authorised_list->TotalRecs > 0 && $qc_authorised_list->ExportOptions->visible()) { ?>
<?php $qc_authorised_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($qc_authorised_list->ImportOptions->visible()) { ?>
<?php $qc_authorised_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($qc_authorised_list->SearchOptions->visible()) { ?>
<?php $qc_authorised_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($qc_authorised_list->FilterOptions->visible()) { ?>
<?php $qc_authorised_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$qc_authorised_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$qc_authorised->isExport() && !$qc_authorised->CurrentAction) { ?>
<form name="fqc_authorisedlistsrch" id="fqc_authorisedlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($qc_authorised_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fqc_authorisedlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="qc_authorised">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$qc_authorised_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$qc_authorised->RowType = ROWTYPE_SEARCH;

// Render row
$qc_authorised->resetAttributes();
$qc_authorised_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($qc_authorised->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $qc_authorised->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_authorised" data-field="x_location" data-value-separator="<?php echo $qc_authorised->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $qc_authorised->location->editAttributes() ?>>
		<?php echo $qc_authorised->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $qc_authorised->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($qc_authorised->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $qc_authorised->_barcode->caption() ?></label>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_authorised->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_authorised->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_authorised->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_authorised->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_authorised->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_authorised->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($qc_authorised->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="qc_authorised" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($qc_authorised->_barcode->getPlaceHolder()) ?>" value="<?php echo $qc_authorised->_barcode->EditValue ?>"<?php echo $qc_authorised->_barcode->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1__barcode style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1__barcode style="d-none"">
<input type="text" data-table="qc_authorised" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($qc_authorised->_barcode->getPlaceHolder()) ?>" value="<?php echo $qc_authorised->_barcode->EditValue2 ?>"<?php echo $qc_authorised->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($qc_authorised->defect_nature->Visible) { // defect_nature ?>
	<div id="xsc_defect_nature" class="ew-cell form-group">
		<label for="x_defect_nature" class="ew-search-caption ew-label"><?php echo $qc_authorised->defect_nature->caption() ?></label>
		<span class="ew-search-operator"><select name="z_defect_nature" id="z_defect_nature" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="BETWEEN"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_authorised" data-field="x_defect_nature" data-value-separator="<?php echo $qc_authorised->defect_nature->displayValueSeparatorAttribute() ?>" id="x_defect_nature" name="x_defect_nature"<?php echo $qc_authorised->defect_nature->editAttributes() ?>>
		<?php echo $qc_authorised->defect_nature->selectOptionListHtml("x_defect_nature") ?>
	</select>
</div>
<?php echo $qc_authorised->defect_nature->Lookup->getParamTag("p_x_defect_nature") ?>
</span>
		<span class="ew-search-cond btw1_defect_nature style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_defect_nature style="d-none"">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_authorised" data-field="x_defect_nature" data-value-separator="<?php echo $qc_authorised->defect_nature->displayValueSeparatorAttribute() ?>" id="y_defect_nature" name="y_defect_nature"<?php echo $qc_authorised->defect_nature->editAttributes() ?>>
		<?php echo $qc_authorised->defect_nature->selectOptionListHtml("y_defect_nature") ?>
	</select>
</div>
<?php echo $qc_authorised->defect_nature->Lookup->getParamTag("p_y_defect_nature") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($qc_authorised->qc_stage->Visible) { // qc_stage ?>
	<div id="xsc_qc_stage" class="ew-cell form-group">
		<label for="x_qc_stage" class="ew-search-caption ew-label"><?php echo $qc_authorised->qc_stage->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qc_stage" id="z_qc_stage" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_authorised" data-field="x_qc_stage" data-value-separator="<?php echo $qc_authorised->qc_stage->displayValueSeparatorAttribute() ?>" id="x_qc_stage" name="x_qc_stage"<?php echo $qc_authorised->qc_stage->editAttributes() ?>>
		<?php echo $qc_authorised->qc_stage->selectOptionListHtml("x_qc_stage") ?>
	</select>
</div>
<?php echo $qc_authorised->qc_stage->Lookup->getParamTag("p_x_qc_stage") ?>
</span>
	</div>
<?php } ?>
<?php if ($qc_authorised->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $qc_authorised->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_authorised" data-field="x_status" data-value-separator="<?php echo $qc_authorised->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $qc_authorised->status->editAttributes() ?>>
		<?php echo $qc_authorised->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $qc_authorised->status->Lookup->getParamTag("p_x_status") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($qc_authorised_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($qc_authorised_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $qc_authorised_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($qc_authorised_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($qc_authorised_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($qc_authorised_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($qc_authorised_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $qc_authorised_list->showPageHeader(); ?>
<?php
$qc_authorised_list->showMessage();
?>
<?php if ($qc_authorised_list->TotalRecs > 0 || $qc_authorised->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($qc_authorised_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> qc_authorised">
<?php if (!$qc_authorised->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$qc_authorised->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($qc_authorised_list->Pager)) $qc_authorised_list->Pager = new PrevNextPager($qc_authorised_list->StartRec, $qc_authorised_list->DisplayRecs, $qc_authorised_list->TotalRecs, $qc_authorised_list->AutoHidePager) ?>
<?php if ($qc_authorised_list->Pager->RecordCount > 0 && $qc_authorised_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($qc_authorised_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $qc_authorised_list->pageUrl() ?>start=<?php echo $qc_authorised_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($qc_authorised_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $qc_authorised_list->pageUrl() ?>start=<?php echo $qc_authorised_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $qc_authorised_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($qc_authorised_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $qc_authorised_list->pageUrl() ?>start=<?php echo $qc_authorised_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($qc_authorised_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $qc_authorised_list->pageUrl() ?>start=<?php echo $qc_authorised_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $qc_authorised_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($qc_authorised_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $qc_authorised_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $qc_authorised_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $qc_authorised_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($qc_authorised_list->TotalRecs > 0 && (!$qc_authorised_list->AutoHidePageSizeSelector || $qc_authorised_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="qc_authorised">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($qc_authorised_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($qc_authorised_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($qc_authorised_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($qc_authorised_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($qc_authorised_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($qc_authorised->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $qc_authorised_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fqc_authorisedlist" id="fqc_authorisedlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_authorised_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_authorised_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc_authorised">
<div id="gmp_qc_authorised" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($qc_authorised_list->TotalRecs > 0 || $qc_authorised->isGridEdit()) { ?>
<table id="tbl_qc_authorisedlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$qc_authorised_list->RowType = ROWTYPE_HEADER;

// Render list options
$qc_authorised_list->renderListOptions();

// Render list options (header, left)
$qc_authorised_list->ListOptions->render("header", "left");
?>
<?php if ($qc_authorised->id->Visible) { // id ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->id) == "") { ?>
		<th data-name="id" class="<?php echo $qc_authorised->id->headerCellClass() ?>"><div id="elh_qc_authorised_id" class="qc_authorised_id"><div class="ew-table-header-caption"><?php echo $qc_authorised->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $qc_authorised->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->id) ?>',2);"><div id="elh_qc_authorised_id" class="qc_authorised_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->location->Visible) { // location ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->location) == "") { ?>
		<th data-name="location" class="<?php echo $qc_authorised->location->headerCellClass() ?>"><div id="elh_qc_authorised_location" class="qc_authorised_location"><div class="ew-table-header-caption"><?php echo $qc_authorised->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $qc_authorised->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->location) ?>',2);"><div id="elh_qc_authorised_location" class="qc_authorised_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->_barcode->Visible) { // barcode ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $qc_authorised->_barcode->headerCellClass() ?>"><div id="elh_qc_authorised__barcode" class="qc_authorised__barcode"><div class="ew-table-header-caption"><?php echo $qc_authorised->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $qc_authorised->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->_barcode) ?>',2);"><div id="elh_qc_authorised__barcode" class="qc_authorised__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->defect_nature->Visible) { // defect_nature ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->defect_nature) == "") { ?>
		<th data-name="defect_nature" class="<?php echo $qc_authorised->defect_nature->headerCellClass() ?>"><div id="elh_qc_authorised_defect_nature" class="qc_authorised_defect_nature"><div class="ew-table-header-caption"><?php echo $qc_authorised->defect_nature->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="defect_nature" class="<?php echo $qc_authorised->defect_nature->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->defect_nature) ?>',2);"><div id="elh_qc_authorised_defect_nature" class="qc_authorised_defect_nature">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->defect_nature->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->defect_nature->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->defect_nature->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->qc_stage->Visible) { // qc_stage ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->qc_stage) == "") { ?>
		<th data-name="qc_stage" class="<?php echo $qc_authorised->qc_stage->headerCellClass() ?>"><div id="elh_qc_authorised_qc_stage" class="qc_authorised_qc_stage"><div class="ew-table-header-caption"><?php echo $qc_authorised->qc_stage->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qc_stage" class="<?php echo $qc_authorised->qc_stage->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->qc_stage) ?>',2);"><div id="elh_qc_authorised_qc_stage" class="qc_authorised_qc_stage">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->qc_stage->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->qc_stage->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->qc_stage->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->defect_percentage->Visible) { // defect_percentage ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->defect_percentage) == "") { ?>
		<th data-name="defect_percentage" class="<?php echo $qc_authorised->defect_percentage->headerCellClass() ?>"><div id="elh_qc_authorised_defect_percentage" class="qc_authorised_defect_percentage"><div class="ew-table-header-caption"><?php echo $qc_authorised->defect_percentage->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="defect_percentage" class="<?php echo $qc_authorised->defect_percentage->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->defect_percentage) ?>',2);"><div id="elh_qc_authorised_defect_percentage" class="qc_authorised_defect_percentage">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->defect_percentage->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->defect_percentage->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->defect_percentage->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->deduction->Visible) { // deduction ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->deduction) == "") { ?>
		<th data-name="deduction" class="<?php echo $qc_authorised->deduction->headerCellClass() ?>"><div id="elh_qc_authorised_deduction" class="qc_authorised_deduction"><div class="ew-table-header-caption"><?php echo $qc_authorised->deduction->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="deduction" class="<?php echo $qc_authorised->deduction->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->deduction) ?>',2);"><div id="elh_qc_authorised_deduction" class="qc_authorised_deduction">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->deduction->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->deduction->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->deduction->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->comments->Visible) { // comments ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->comments) == "") { ?>
		<th data-name="comments" class="<?php echo $qc_authorised->comments->headerCellClass() ?>"><div id="elh_qc_authorised_comments" class="qc_authorised_comments"><div class="ew-table-header-caption"><?php echo $qc_authorised->comments->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="comments" class="<?php echo $qc_authorised->comments->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->comments) ?>',2);"><div id="elh_qc_authorised_comments" class="qc_authorised_comments">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->comments->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->comments->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->comments->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->design->Visible) { // design ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->design) == "") { ?>
		<th data-name="design" class="<?php echo $qc_authorised->design->headerCellClass() ?>"><div id="elh_qc_authorised_design" class="qc_authorised_design"><div class="ew-table-header-caption"><?php echo $qc_authorised->design->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design" class="<?php echo $qc_authorised->design->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->design) ?>',2);"><div id="elh_qc_authorised_design" class="qc_authorised_design">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->design->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->design->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->design->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->size->Visible) { // size ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->size) == "") { ?>
		<th data-name="size" class="<?php echo $qc_authorised->size->headerCellClass() ?>"><div id="elh_qc_authorised_size" class="qc_authorised_size"><div class="ew-table-header-caption"><?php echo $qc_authorised->size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size" class="<?php echo $qc_authorised->size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->size) ?>',2);"><div id="elh_qc_authorised_size" class="qc_authorised_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->status->Visible) { // status ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->status) == "") { ?>
		<th data-name="status" class="<?php echo $qc_authorised->status->headerCellClass() ?>"><div id="elh_qc_authorised_status" class="qc_authorised_status"><div class="ew-table-header-caption"><?php echo $qc_authorised->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $qc_authorised->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->status) ?>',2);"><div id="elh_qc_authorised_status" class="qc_authorised_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->remarks->Visible) { // remarks ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $qc_authorised->remarks->headerCellClass() ?>"><div id="elh_qc_authorised_remarks" class="qc_authorised_remarks"><div class="ew-table-header-caption"><?php echo $qc_authorised->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $qc_authorised->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->remarks) ?>',2);"><div id="elh_qc_authorised_remarks" class="qc_authorised_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->_action->Visible) { // action ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->_action) == "") { ?>
		<th data-name="_action" class="<?php echo $qc_authorised->_action->headerCellClass() ?>"><div id="elh_qc_authorised__action" class="qc_authorised__action"><div class="ew-table-header-caption"><?php echo $qc_authorised->_action->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_action" class="<?php echo $qc_authorised->_action->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->_action) ?>',2);"><div id="elh_qc_authorised__action" class="qc_authorised__action">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->_action->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->_action->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->_action->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->operator->Visible) { // operator ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $qc_authorised->operator->headerCellClass() ?>"><div id="elh_qc_authorised_operator" class="qc_authorised_operator"><div class="ew-table-header-caption"><?php echo $qc_authorised->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $qc_authorised->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->operator) ?>',2);"><div id="elh_qc_authorised_operator" class="qc_authorised_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->datetime->Visible) { // datetime ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $qc_authorised->datetime->headerCellClass() ?>"><div id="elh_qc_authorised_datetime" class="qc_authorised_datetime"><div class="ew-table-header-caption"><?php echo $qc_authorised->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $qc_authorised->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->datetime) ?>',2);"><div id="elh_qc_authorised_datetime" class="qc_authorised_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->a_operator->Visible) { // a_operator ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $qc_authorised->a_operator->headerCellClass() ?>"><div id="elh_qc_authorised_a_operator" class="qc_authorised_a_operator"><div class="ew-table-header-caption"><?php echo $qc_authorised->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $qc_authorised->a_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->a_operator) ?>',2);"><div id="elh_qc_authorised_a_operator" class="qc_authorised_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->a_datetime->Visible) { // a_datetime ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->a_datetime) == "") { ?>
		<th data-name="a_datetime" class="<?php echo $qc_authorised->a_datetime->headerCellClass() ?>"><div id="elh_qc_authorised_a_datetime" class="qc_authorised_a_datetime"><div class="ew-table-header-caption"><?php echo $qc_authorised->a_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_datetime" class="<?php echo $qc_authorised->a_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->a_datetime) ?>',2);"><div id="elh_qc_authorised_a_datetime" class="qc_authorised_a_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->a_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->a_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->a_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_authorised->bcode_status->Visible) { // bcode_status ?>
	<?php if ($qc_authorised->sortUrl($qc_authorised->bcode_status) == "") { ?>
		<th data-name="bcode_status" class="<?php echo $qc_authorised->bcode_status->headerCellClass() ?>"><div id="elh_qc_authorised_bcode_status" class="qc_authorised_bcode_status"><div class="ew-table-header-caption"><?php echo $qc_authorised->bcode_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bcode_status" class="<?php echo $qc_authorised->bcode_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_authorised->SortUrl($qc_authorised->bcode_status) ?>',2);"><div id="elh_qc_authorised_bcode_status" class="qc_authorised_bcode_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_authorised->bcode_status->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_authorised->bcode_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_authorised->bcode_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$qc_authorised_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($qc_authorised->ExportAll && $qc_authorised->isExport()) {
	$qc_authorised_list->StopRec = $qc_authorised_list->TotalRecs;
} else {

	// Set the last record to display
	if ($qc_authorised_list->TotalRecs > $qc_authorised_list->StartRec + $qc_authorised_list->DisplayRecs - 1)
		$qc_authorised_list->StopRec = $qc_authorised_list->StartRec + $qc_authorised_list->DisplayRecs - 1;
	else
		$qc_authorised_list->StopRec = $qc_authorised_list->TotalRecs;
}
$qc_authorised_list->RecCnt = $qc_authorised_list->StartRec - 1;
if ($qc_authorised_list->Recordset && !$qc_authorised_list->Recordset->EOF) {
	$qc_authorised_list->Recordset->moveFirst();
	$selectLimit = $qc_authorised_list->UseSelectLimit;
	if (!$selectLimit && $qc_authorised_list->StartRec > 1)
		$qc_authorised_list->Recordset->move($qc_authorised_list->StartRec - 1);
} elseif (!$qc_authorised->AllowAddDeleteRow && $qc_authorised_list->StopRec == 0) {
	$qc_authorised_list->StopRec = $qc_authorised->GridAddRowCount;
}

// Initialize aggregate
$qc_authorised->RowType = ROWTYPE_AGGREGATEINIT;
$qc_authorised->resetAttributes();
$qc_authorised_list->renderRow();
while ($qc_authorised_list->RecCnt < $qc_authorised_list->StopRec) {
	$qc_authorised_list->RecCnt++;
	if ($qc_authorised_list->RecCnt >= $qc_authorised_list->StartRec) {
		$qc_authorised_list->RowCnt++;

		// Set up key count
		$qc_authorised_list->KeyCount = $qc_authorised_list->RowIndex;

		// Init row class and style
		$qc_authorised->resetAttributes();
		$qc_authorised->CssClass = "";
		if ($qc_authorised->isGridAdd()) {
		} else {
			$qc_authorised_list->loadRowValues($qc_authorised_list->Recordset); // Load row values
		}
		$qc_authorised->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$qc_authorised->RowAttrs = array_merge($qc_authorised->RowAttrs, array('data-rowindex'=>$qc_authorised_list->RowCnt, 'id'=>'r' . $qc_authorised_list->RowCnt . '_qc_authorised', 'data-rowtype'=>$qc_authorised->RowType));

		// Render row
		$qc_authorised_list->renderRow();

		// Render list options
		$qc_authorised_list->renderListOptions();
?>
	<tr<?php echo $qc_authorised->rowAttributes() ?>>
<?php

// Render list options (body, left)
$qc_authorised_list->ListOptions->render("body", "left", $qc_authorised_list->RowCnt);
?>
	<?php if ($qc_authorised->id->Visible) { // id ?>
		<td data-name="id"<?php echo $qc_authorised->id->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_id" class="qc_authorised_id">
<span<?php echo $qc_authorised->id->viewAttributes() ?>>
<?php echo $qc_authorised->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->location->Visible) { // location ?>
		<td data-name="location"<?php echo $qc_authorised->location->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_location" class="qc_authorised_location">
<span<?php echo $qc_authorised->location->viewAttributes() ?>>
<?php echo $qc_authorised->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $qc_authorised->_barcode->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised__barcode" class="qc_authorised__barcode">
<span<?php echo $qc_authorised->_barcode->viewAttributes() ?>>
<?php echo $qc_authorised->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->defect_nature->Visible) { // defect_nature ?>
		<td data-name="defect_nature"<?php echo $qc_authorised->defect_nature->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_defect_nature" class="qc_authorised_defect_nature">
<span<?php echo $qc_authorised->defect_nature->viewAttributes() ?>>
<?php echo $qc_authorised->defect_nature->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->qc_stage->Visible) { // qc_stage ?>
		<td data-name="qc_stage"<?php echo $qc_authorised->qc_stage->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_qc_stage" class="qc_authorised_qc_stage">
<span<?php echo $qc_authorised->qc_stage->viewAttributes() ?>>
<?php echo $qc_authorised->qc_stage->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->defect_percentage->Visible) { // defect_percentage ?>
		<td data-name="defect_percentage"<?php echo $qc_authorised->defect_percentage->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_defect_percentage" class="qc_authorised_defect_percentage">
<span<?php echo $qc_authorised->defect_percentage->viewAttributes() ?>>
<?php echo $qc_authorised->defect_percentage->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->deduction->Visible) { // deduction ?>
		<td data-name="deduction"<?php echo $qc_authorised->deduction->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_deduction" class="qc_authorised_deduction">
<span<?php echo $qc_authorised->deduction->viewAttributes() ?>>
<?php echo $qc_authorised->deduction->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->comments->Visible) { // comments ?>
		<td data-name="comments"<?php echo $qc_authorised->comments->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_comments" class="qc_authorised_comments">
<span<?php echo $qc_authorised->comments->viewAttributes() ?>>
<?php echo $qc_authorised->comments->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->design->Visible) { // design ?>
		<td data-name="design"<?php echo $qc_authorised->design->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_design" class="qc_authorised_design">
<span<?php echo $qc_authorised->design->viewAttributes() ?>>
<?php echo $qc_authorised->design->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->size->Visible) { // size ?>
		<td data-name="size"<?php echo $qc_authorised->size->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_size" class="qc_authorised_size">
<span<?php echo $qc_authorised->size->viewAttributes() ?>>
<?php echo $qc_authorised->size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->status->Visible) { // status ?>
		<td data-name="status"<?php echo $qc_authorised->status->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_status" class="qc_authorised_status">
<span<?php echo $qc_authorised->status->viewAttributes() ?>>
<?php echo $qc_authorised->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $qc_authorised->remarks->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_remarks" class="qc_authorised_remarks">
<span<?php echo $qc_authorised->remarks->viewAttributes() ?>>
<?php echo $qc_authorised->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->_action->Visible) { // action ?>
		<td data-name="_action"<?php echo $qc_authorised->_action->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised__action" class="qc_authorised__action">
<span<?php echo $qc_authorised->_action->viewAttributes() ?>>
<?php echo $qc_authorised->_action->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $qc_authorised->operator->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_operator" class="qc_authorised_operator">
<span<?php echo $qc_authorised->operator->viewAttributes() ?>>
<?php echo $qc_authorised->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $qc_authorised->datetime->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_datetime" class="qc_authorised_datetime">
<span<?php echo $qc_authorised->datetime->viewAttributes() ?>>
<?php echo $qc_authorised->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $qc_authorised->a_operator->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_a_operator" class="qc_authorised_a_operator">
<span<?php echo $qc_authorised->a_operator->viewAttributes() ?>>
<?php echo $qc_authorised->a_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime"<?php echo $qc_authorised->a_datetime->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_a_datetime" class="qc_authorised_a_datetime">
<span<?php echo $qc_authorised->a_datetime->viewAttributes() ?>>
<?php echo $qc_authorised->a_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_authorised->bcode_status->Visible) { // bcode_status ?>
		<td data-name="bcode_status"<?php echo $qc_authorised->bcode_status->cellAttributes() ?>>
<span id="el<?php echo $qc_authorised_list->RowCnt ?>_qc_authorised_bcode_status" class="qc_authorised_bcode_status">
<span<?php echo $qc_authorised->bcode_status->viewAttributes() ?>>
<?php echo $qc_authorised->bcode_status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$qc_authorised_list->ListOptions->render("body", "right", $qc_authorised_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$qc_authorised->isGridAdd())
		$qc_authorised_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$qc_authorised->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($qc_authorised_list->Recordset)
	$qc_authorised_list->Recordset->Close();
?>
<?php if (!$qc_authorised->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$qc_authorised->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($qc_authorised_list->Pager)) $qc_authorised_list->Pager = new PrevNextPager($qc_authorised_list->StartRec, $qc_authorised_list->DisplayRecs, $qc_authorised_list->TotalRecs, $qc_authorised_list->AutoHidePager) ?>
<?php if ($qc_authorised_list->Pager->RecordCount > 0 && $qc_authorised_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($qc_authorised_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $qc_authorised_list->pageUrl() ?>start=<?php echo $qc_authorised_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($qc_authorised_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $qc_authorised_list->pageUrl() ?>start=<?php echo $qc_authorised_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $qc_authorised_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($qc_authorised_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $qc_authorised_list->pageUrl() ?>start=<?php echo $qc_authorised_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($qc_authorised_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $qc_authorised_list->pageUrl() ?>start=<?php echo $qc_authorised_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $qc_authorised_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($qc_authorised_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $qc_authorised_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $qc_authorised_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $qc_authorised_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($qc_authorised_list->TotalRecs > 0 && (!$qc_authorised_list->AutoHidePageSizeSelector || $qc_authorised_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="qc_authorised">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($qc_authorised_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($qc_authorised_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($qc_authorised_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($qc_authorised_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($qc_authorised_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($qc_authorised->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $qc_authorised_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($qc_authorised_list->TotalRecs == 0 && !$qc_authorised->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $qc_authorised_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$qc_authorised_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$qc_authorised->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$qc_authorised->isExport()) { ?>
<script>
ew.scrollableTable("gmp_qc_authorised", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$qc_authorised_list->terminate();
?>