<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_authorised_search = new qc_authorised_search();

// Run the page
$qc_authorised_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_authorised_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($qc_authorised_search->IsModal) { ?>
var fqc_authorisedsearch = currentAdvancedSearchForm = new ew.Form("fqc_authorisedsearch", "search");
<?php } else { ?>
var fqc_authorisedsearch = currentForm = new ew.Form("fqc_authorisedsearch", "search");
<?php } ?>

// Form_CustomValidate event
fqc_authorisedsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_authorisedsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_authorisedsearch.lists["x_location"] = <?php echo $qc_authorised_search->location->Lookup->toClientList() ?>;
fqc_authorisedsearch.lists["x_location"].options = <?php echo JsonEncode($qc_authorised_search->location->lookupOptions()) ?>;
fqc_authorisedsearch.lists["x_defect_nature"] = <?php echo $qc_authorised_search->defect_nature->Lookup->toClientList() ?>;
fqc_authorisedsearch.lists["x_defect_nature"].options = <?php echo JsonEncode($qc_authorised_search->defect_nature->lookupOptions()) ?>;
fqc_authorisedsearch.lists["x_qc_stage"] = <?php echo $qc_authorised_search->qc_stage->Lookup->toClientList() ?>;
fqc_authorisedsearch.lists["x_qc_stage"].options = <?php echo JsonEncode($qc_authorised_search->qc_stage->lookupOptions()) ?>;
fqc_authorisedsearch.lists["x_defect_percentage"] = <?php echo $qc_authorised_search->defect_percentage->Lookup->toClientList() ?>;
fqc_authorisedsearch.lists["x_defect_percentage"].options = <?php echo JsonEncode($qc_authorised_search->defect_percentage->lookupOptions()) ?>;
fqc_authorisedsearch.lists["x_status"] = <?php echo $qc_authorised_search->status->Lookup->toClientList() ?>;
fqc_authorisedsearch.lists["x_status"].options = <?php echo JsonEncode($qc_authorised_search->status->lookupOptions()) ?>;
fqc_authorisedsearch.lists["x__action"] = <?php echo $qc_authorised_search->_action->Lookup->toClientList() ?>;
fqc_authorisedsearch.lists["x__action"].options = <?php echo JsonEncode($qc_authorised_search->_action->lookupOptions()) ?>;
fqc_authorisedsearch.lists["x_operator"] = <?php echo $qc_authorised_search->operator->Lookup->toClientList() ?>;
fqc_authorisedsearch.lists["x_operator"].options = <?php echo JsonEncode($qc_authorised_search->operator->lookupOptions()) ?>;
fqc_authorisedsearch.lists["x_a_operator"] = <?php echo $qc_authorised_search->a_operator->Lookup->toClientList() ?>;
fqc_authorisedsearch.lists["x_a_operator"].options = <?php echo JsonEncode($qc_authorised_search->a_operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fqc_authorisedsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_authorised->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_authorised->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_deduction");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_authorised->deduction->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_authorised->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_a_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_authorised->a_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_bcode_status");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_authorised->bcode_status->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $qc_authorised_search->showPageHeader(); ?>
<?php
$qc_authorised_search->showMessage();
?>
<form name="fqc_authorisedsearch" id="fqc_authorisedsearch" class="<?php echo $qc_authorised_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_authorised_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_authorised_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc_authorised">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$qc_authorised_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($qc_authorised->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_id"><?php echo $qc_authorised->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->id->cellAttributes() ?>>
			<span id="el_qc_authorised_id">
<input type="text" data-table="qc_authorised" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($qc_authorised->id->getPlaceHolder()) ?>" value="<?php echo $qc_authorised->id->EditValue ?>"<?php echo $qc_authorised->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_location"><?php echo $qc_authorised->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->location->cellAttributes() ?>>
			<span id="el_qc_authorised_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_authorised" data-field="x_location" data-value-separator="<?php echo $qc_authorised->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $qc_authorised->location->editAttributes() ?>>
		<?php echo $qc_authorised->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $qc_authorised->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised__barcode"><?php echo $qc_authorised->_barcode->caption() ?></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->_barcode->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_authorised->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_authorised->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_authorised->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_authorised->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_authorised->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_authorised->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($qc_authorised->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_qc_authorised__barcode">
<input type="text" data-table="qc_authorised" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($qc_authorised->_barcode->getPlaceHolder()) ?>" value="<?php echo $qc_authorised->_barcode->EditValue ?>"<?php echo $qc_authorised->_barcode->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1__barcode d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_qc_authorised__barcode" class="btw1__barcode d-none">
<input type="text" data-table="qc_authorised" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($qc_authorised->_barcode->getPlaceHolder()) ?>" value="<?php echo $qc_authorised->_barcode->EditValue2 ?>"<?php echo $qc_authorised->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->defect_nature->Visible) { // defect_nature ?>
	<div id="r_defect_nature" class="form-group row">
		<label for="x_defect_nature" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_defect_nature"><?php echo $qc_authorised->defect_nature->caption() ?></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->defect_nature->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_defect_nature" id="z_defect_nature" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="BETWEEN"<?php echo ($qc_authorised->defect_nature->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_qc_authorised_defect_nature">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_authorised" data-field="x_defect_nature" data-value-separator="<?php echo $qc_authorised->defect_nature->displayValueSeparatorAttribute() ?>" id="x_defect_nature" name="x_defect_nature"<?php echo $qc_authorised->defect_nature->editAttributes() ?>>
		<?php echo $qc_authorised->defect_nature->selectOptionListHtml("x_defect_nature") ?>
	</select>
</div>
<?php echo $qc_authorised->defect_nature->Lookup->getParamTag("p_x_defect_nature") ?>
</span>
			<span class="ew-search-cond btw1_defect_nature d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_qc_authorised_defect_nature" class="btw1_defect_nature d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_authorised" data-field="x_defect_nature" data-value-separator="<?php echo $qc_authorised->defect_nature->displayValueSeparatorAttribute() ?>" id="y_defect_nature" name="y_defect_nature"<?php echo $qc_authorised->defect_nature->editAttributes() ?>>
		<?php echo $qc_authorised->defect_nature->selectOptionListHtml("y_defect_nature") ?>
	</select>
</div>
<?php echo $qc_authorised->defect_nature->Lookup->getParamTag("p_y_defect_nature") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->qc_stage->Visible) { // qc_stage ?>
	<div id="r_qc_stage" class="form-group row">
		<label for="x_qc_stage" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_qc_stage"><?php echo $qc_authorised->qc_stage->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qc_stage" id="z_qc_stage" value="="></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->qc_stage->cellAttributes() ?>>
			<span id="el_qc_authorised_qc_stage">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_authorised" data-field="x_qc_stage" data-value-separator="<?php echo $qc_authorised->qc_stage->displayValueSeparatorAttribute() ?>" id="x_qc_stage" name="x_qc_stage"<?php echo $qc_authorised->qc_stage->editAttributes() ?>>
		<?php echo $qc_authorised->qc_stage->selectOptionListHtml("x_qc_stage") ?>
	</select>
</div>
<?php echo $qc_authorised->qc_stage->Lookup->getParamTag("p_x_qc_stage") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->defect_percentage->Visible) { // defect_percentage ?>
	<div id="r_defect_percentage" class="form-group row">
		<label for="x_defect_percentage" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_defect_percentage"><?php echo $qc_authorised->defect_percentage->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_defect_percentage" id="z_defect_percentage" value="="></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->defect_percentage->cellAttributes() ?>>
			<span id="el_qc_authorised_defect_percentage">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_authorised" data-field="x_defect_percentage" data-value-separator="<?php echo $qc_authorised->defect_percentage->displayValueSeparatorAttribute() ?>" id="x_defect_percentage" name="x_defect_percentage"<?php echo $qc_authorised->defect_percentage->editAttributes() ?>>
		<?php echo $qc_authorised->defect_percentage->selectOptionListHtml("x_defect_percentage") ?>
	</select>
</div>
<?php echo $qc_authorised->defect_percentage->Lookup->getParamTag("p_x_defect_percentage") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->deduction->Visible) { // deduction ?>
	<div id="r_deduction" class="form-group row">
		<label for="x_deduction" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_deduction"><?php echo $qc_authorised->deduction->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_deduction" id="z_deduction" value="="></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->deduction->cellAttributes() ?>>
			<span id="el_qc_authorised_deduction">
<input type="text" data-table="qc_authorised" data-field="x_deduction" name="x_deduction" id="x_deduction" size="30" placeholder="<?php echo HtmlEncode($qc_authorised->deduction->getPlaceHolder()) ?>" value="<?php echo $qc_authorised->deduction->EditValue ?>"<?php echo $qc_authorised->deduction->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->comments->Visible) { // comments ?>
	<div id="r_comments" class="form-group row">
		<label for="x_comments" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_comments"><?php echo $qc_authorised->comments->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_comments" id="z_comments" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->comments->cellAttributes() ?>>
			<span id="el_qc_authorised_comments">
<input type="text" data-table="qc_authorised" data-field="x_comments" name="x_comments" id="x_comments" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($qc_authorised->comments->getPlaceHolder()) ?>" value="<?php echo $qc_authorised->comments->EditValue ?>"<?php echo $qc_authorised->comments->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->design->Visible) { // design ?>
	<div id="r_design" class="form-group row">
		<label for="x_design" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_design"><?php echo $qc_authorised->design->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design" id="z_design" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->design->cellAttributes() ?>>
			<span id="el_qc_authorised_design">
<input type="text" data-table="qc_authorised" data-field="x_design" name="x_design" id="x_design" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($qc_authorised->design->getPlaceHolder()) ?>" value="<?php echo $qc_authorised->design->EditValue ?>"<?php echo $qc_authorised->design->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->size->Visible) { // size ?>
	<div id="r_size" class="form-group row">
		<label for="x_size" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_size"><?php echo $qc_authorised->size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size" id="z_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->size->cellAttributes() ?>>
			<span id="el_qc_authorised_size">
<input type="text" data-table="qc_authorised" data-field="x_size" name="x_size" id="x_size" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($qc_authorised->size->getPlaceHolder()) ?>" value="<?php echo $qc_authorised->size->EditValue ?>"<?php echo $qc_authorised->size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_status"><?php echo $qc_authorised->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->status->cellAttributes() ?>>
			<span id="el_qc_authorised_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_authorised" data-field="x_status" data-value-separator="<?php echo $qc_authorised->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $qc_authorised->status->editAttributes() ?>>
		<?php echo $qc_authorised->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $qc_authorised->status->Lookup->getParamTag("p_x_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_remarks"><?php echo $qc_authorised->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->remarks->cellAttributes() ?>>
			<span id="el_qc_authorised_remarks">
<input type="text" data-table="qc_authorised" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($qc_authorised->remarks->getPlaceHolder()) ?>" value="<?php echo $qc_authorised->remarks->EditValue ?>"<?php echo $qc_authorised->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->_action->Visible) { // action ?>
	<div id="r__action" class="form-group row">
		<label class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised__action"><?php echo $qc_authorised->_action->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__action" id="z__action" value="="></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->_action->cellAttributes() ?>>
			<span id="el_qc_authorised__action">
<div id="tp_x__action" class="ew-template"><input type="radio" class="form-check-input" data-table="qc_authorised" data-field="x__action" data-value-separator="<?php echo $qc_authorised->_action->displayValueSeparatorAttribute() ?>" name="x__action" id="x__action" value="{value}"<?php echo $qc_authorised->_action->editAttributes() ?>></div>
<div id="dsl_x__action" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $qc_authorised->_action->radioButtonListHtml(FALSE, "x__action") ?>
</div></div>
<?php echo $qc_authorised->_action->Lookup->getParamTag("p_x__action") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_operator"><?php echo $qc_authorised->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->operator->cellAttributes() ?>>
			<span id="el_qc_authorised_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_authorised" data-field="x_operator" data-value-separator="<?php echo $qc_authorised->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $qc_authorised->operator->editAttributes() ?>>
		<?php echo $qc_authorised->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $qc_authorised->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_datetime"><?php echo $qc_authorised->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->datetime->cellAttributes() ?>>
			<span id="el_qc_authorised_datetime">
<input type="text" data-table="qc_authorised" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($qc_authorised->datetime->getPlaceHolder()) ?>" value="<?php echo $qc_authorised->datetime->EditValue ?>"<?php echo $qc_authorised->datetime->editAttributes() ?>>
<?php if (!$qc_authorised->datetime->ReadOnly && !$qc_authorised->datetime->Disabled && !isset($qc_authorised->datetime->EditAttrs["readonly"]) && !isset($qc_authorised->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fqc_authorisedsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->a_operator->Visible) { // a_operator ?>
	<div id="r_a_operator" class="form-group row">
		<label for="x_a_operator" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_a_operator"><?php echo $qc_authorised->a_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_operator" id="z_a_operator" value="="></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->a_operator->cellAttributes() ?>>
			<span id="el_qc_authorised_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_authorised" data-field="x_a_operator" data-value-separator="<?php echo $qc_authorised->a_operator->displayValueSeparatorAttribute() ?>" id="x_a_operator" name="x_a_operator"<?php echo $qc_authorised->a_operator->editAttributes() ?>>
		<?php echo $qc_authorised->a_operator->selectOptionListHtml("x_a_operator") ?>
	</select>
</div>
<?php echo $qc_authorised->a_operator->Lookup->getParamTag("p_x_a_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->a_datetime->Visible) { // a_datetime ?>
	<div id="r_a_datetime" class="form-group row">
		<label for="x_a_datetime" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_a_datetime"><?php echo $qc_authorised->a_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_datetime" id="z_a_datetime" value="="></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->a_datetime->cellAttributes() ?>>
			<span id="el_qc_authorised_a_datetime">
<input type="text" data-table="qc_authorised" data-field="x_a_datetime" data-format="117" name="x_a_datetime" id="x_a_datetime" placeholder="<?php echo HtmlEncode($qc_authorised->a_datetime->getPlaceHolder()) ?>" value="<?php echo $qc_authorised->a_datetime->EditValue ?>"<?php echo $qc_authorised->a_datetime->editAttributes() ?>>
<?php if (!$qc_authorised->a_datetime->ReadOnly && !$qc_authorised->a_datetime->Disabled && !isset($qc_authorised->a_datetime->EditAttrs["readonly"]) && !isset($qc_authorised->a_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fqc_authorisedsearch", "x_a_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_authorised->bcode_status->Visible) { // bcode_status ?>
	<div id="r_bcode_status" class="form-group row">
		<label for="x_bcode_status" class="<?php echo $qc_authorised_search->LeftColumnClass ?>"><span id="elh_qc_authorised_bcode_status"><?php echo $qc_authorised->bcode_status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_bcode_status" id="z_bcode_status" value="="></span>
		</label>
		<div class="<?php echo $qc_authorised_search->RightColumnClass ?>"><div<?php echo $qc_authorised->bcode_status->cellAttributes() ?>>
			<span id="el_qc_authorised_bcode_status">
<input type="text" data-table="qc_authorised" data-field="x_bcode_status" name="x_bcode_status" id="x_bcode_status" size="30" placeholder="<?php echo HtmlEncode($qc_authorised->bcode_status->getPlaceHolder()) ?>" value="<?php echo $qc_authorised->bcode_status->EditValue ?>"<?php echo $qc_authorised->bcode_status->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$qc_authorised_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $qc_authorised_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$qc_authorised_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$qc_authorised_search->terminate();
?>