<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_authorised_view = new qc_authorised_view();

// Run the page
$qc_authorised_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_authorised_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$qc_authorised->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fqc_authorisedview = currentForm = new ew.Form("fqc_authorisedview", "view");

// Form_CustomValidate event
fqc_authorisedview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_authorisedview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_authorisedview.lists["x_location"] = <?php echo $qc_authorised_view->location->Lookup->toClientList() ?>;
fqc_authorisedview.lists["x_location"].options = <?php echo JsonEncode($qc_authorised_view->location->lookupOptions()) ?>;
fqc_authorisedview.lists["x_defect_nature"] = <?php echo $qc_authorised_view->defect_nature->Lookup->toClientList() ?>;
fqc_authorisedview.lists["x_defect_nature"].options = <?php echo JsonEncode($qc_authorised_view->defect_nature->lookupOptions()) ?>;
fqc_authorisedview.lists["x_qc_stage"] = <?php echo $qc_authorised_view->qc_stage->Lookup->toClientList() ?>;
fqc_authorisedview.lists["x_qc_stage"].options = <?php echo JsonEncode($qc_authorised_view->qc_stage->lookupOptions()) ?>;
fqc_authorisedview.lists["x_defect_percentage"] = <?php echo $qc_authorised_view->defect_percentage->Lookup->toClientList() ?>;
fqc_authorisedview.lists["x_defect_percentage"].options = <?php echo JsonEncode($qc_authorised_view->defect_percentage->lookupOptions()) ?>;
fqc_authorisedview.lists["x_status"] = <?php echo $qc_authorised_view->status->Lookup->toClientList() ?>;
fqc_authorisedview.lists["x_status"].options = <?php echo JsonEncode($qc_authorised_view->status->lookupOptions()) ?>;
fqc_authorisedview.lists["x__action"] = <?php echo $qc_authorised_view->_action->Lookup->toClientList() ?>;
fqc_authorisedview.lists["x__action"].options = <?php echo JsonEncode($qc_authorised_view->_action->lookupOptions()) ?>;
fqc_authorisedview.lists["x_operator"] = <?php echo $qc_authorised_view->operator->Lookup->toClientList() ?>;
fqc_authorisedview.lists["x_operator"].options = <?php echo JsonEncode($qc_authorised_view->operator->lookupOptions()) ?>;
fqc_authorisedview.lists["x_a_operator"] = <?php echo $qc_authorised_view->a_operator->Lookup->toClientList() ?>;
fqc_authorisedview.lists["x_a_operator"].options = <?php echo JsonEncode($qc_authorised_view->a_operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$qc_authorised->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $qc_authorised_view->ExportOptions->render("body") ?>
<?php $qc_authorised_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $qc_authorised_view->showPageHeader(); ?>
<?php
$qc_authorised_view->showMessage();
?>
<form name="fqc_authorisedview" id="fqc_authorisedview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_authorised_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_authorised_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc_authorised">
<input type="hidden" name="modal" value="<?php echo (int)$qc_authorised_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($qc_authorised->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_id"><?php echo $qc_authorised->id->caption() ?></span></td>
		<td data-name="id"<?php echo $qc_authorised->id->cellAttributes() ?>>
<span id="el_qc_authorised_id">
<span<?php echo $qc_authorised->id->viewAttributes() ?>>
<?php echo $qc_authorised->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->location->Visible) { // location ?>
	<tr id="r_location">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_location"><?php echo $qc_authorised->location->caption() ?></span></td>
		<td data-name="location"<?php echo $qc_authorised->location->cellAttributes() ?>>
<span id="el_qc_authorised_location">
<span<?php echo $qc_authorised->location->viewAttributes() ?>>
<?php echo $qc_authorised->location->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->_barcode->Visible) { // barcode ?>
	<tr id="r__barcode">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised__barcode"><?php echo $qc_authorised->_barcode->caption() ?></span></td>
		<td data-name="_barcode"<?php echo $qc_authorised->_barcode->cellAttributes() ?>>
<span id="el_qc_authorised__barcode">
<span<?php echo $qc_authorised->_barcode->viewAttributes() ?>>
<?php echo $qc_authorised->_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->defect_nature->Visible) { // defect_nature ?>
	<tr id="r_defect_nature">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_defect_nature"><?php echo $qc_authorised->defect_nature->caption() ?></span></td>
		<td data-name="defect_nature"<?php echo $qc_authorised->defect_nature->cellAttributes() ?>>
<span id="el_qc_authorised_defect_nature">
<span<?php echo $qc_authorised->defect_nature->viewAttributes() ?>>
<?php echo $qc_authorised->defect_nature->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->qc_stage->Visible) { // qc_stage ?>
	<tr id="r_qc_stage">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_qc_stage"><?php echo $qc_authorised->qc_stage->caption() ?></span></td>
		<td data-name="qc_stage"<?php echo $qc_authorised->qc_stage->cellAttributes() ?>>
<span id="el_qc_authorised_qc_stage">
<span<?php echo $qc_authorised->qc_stage->viewAttributes() ?>>
<?php echo $qc_authorised->qc_stage->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->defect_percentage->Visible) { // defect_percentage ?>
	<tr id="r_defect_percentage">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_defect_percentage"><?php echo $qc_authorised->defect_percentage->caption() ?></span></td>
		<td data-name="defect_percentage"<?php echo $qc_authorised->defect_percentage->cellAttributes() ?>>
<span id="el_qc_authorised_defect_percentage">
<span<?php echo $qc_authorised->defect_percentage->viewAttributes() ?>>
<?php echo $qc_authorised->defect_percentage->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->deduction->Visible) { // deduction ?>
	<tr id="r_deduction">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_deduction"><?php echo $qc_authorised->deduction->caption() ?></span></td>
		<td data-name="deduction"<?php echo $qc_authorised->deduction->cellAttributes() ?>>
<span id="el_qc_authorised_deduction">
<span<?php echo $qc_authorised->deduction->viewAttributes() ?>>
<?php echo $qc_authorised->deduction->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->comments->Visible) { // comments ?>
	<tr id="r_comments">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_comments"><?php echo $qc_authorised->comments->caption() ?></span></td>
		<td data-name="comments"<?php echo $qc_authorised->comments->cellAttributes() ?>>
<span id="el_qc_authorised_comments">
<span<?php echo $qc_authorised->comments->viewAttributes() ?>>
<?php echo $qc_authorised->comments->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->design->Visible) { // design ?>
	<tr id="r_design">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_design"><?php echo $qc_authorised->design->caption() ?></span></td>
		<td data-name="design"<?php echo $qc_authorised->design->cellAttributes() ?>>
<span id="el_qc_authorised_design">
<span<?php echo $qc_authorised->design->viewAttributes() ?>>
<?php echo $qc_authorised->design->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->size->Visible) { // size ?>
	<tr id="r_size">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_size"><?php echo $qc_authorised->size->caption() ?></span></td>
		<td data-name="size"<?php echo $qc_authorised->size->cellAttributes() ?>>
<span id="el_qc_authorised_size">
<span<?php echo $qc_authorised->size->viewAttributes() ?>>
<?php echo $qc_authorised->size->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_status"><?php echo $qc_authorised->status->caption() ?></span></td>
		<td data-name="status"<?php echo $qc_authorised->status->cellAttributes() ?>>
<span id="el_qc_authorised_status">
<span<?php echo $qc_authorised->status->viewAttributes() ?>>
<?php echo $qc_authorised->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_remarks"><?php echo $qc_authorised->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $qc_authorised->remarks->cellAttributes() ?>>
<span id="el_qc_authorised_remarks">
<span<?php echo $qc_authorised->remarks->viewAttributes() ?>>
<?php echo $qc_authorised->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->_action->Visible) { // action ?>
	<tr id="r__action">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised__action"><?php echo $qc_authorised->_action->caption() ?></span></td>
		<td data-name="_action"<?php echo $qc_authorised->_action->cellAttributes() ?>>
<span id="el_qc_authorised__action">
<span<?php echo $qc_authorised->_action->viewAttributes() ?>>
<?php echo $qc_authorised->_action->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_operator"><?php echo $qc_authorised->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $qc_authorised->operator->cellAttributes() ?>>
<span id="el_qc_authorised_operator">
<span<?php echo $qc_authorised->operator->viewAttributes() ?>>
<?php echo $qc_authorised->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_datetime"><?php echo $qc_authorised->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $qc_authorised->datetime->cellAttributes() ?>>
<span id="el_qc_authorised_datetime">
<span<?php echo $qc_authorised->datetime->viewAttributes() ?>>
<?php echo $qc_authorised->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->a_operator->Visible) { // a_operator ?>
	<tr id="r_a_operator">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_a_operator"><?php echo $qc_authorised->a_operator->caption() ?></span></td>
		<td data-name="a_operator"<?php echo $qc_authorised->a_operator->cellAttributes() ?>>
<span id="el_qc_authorised_a_operator">
<span<?php echo $qc_authorised->a_operator->viewAttributes() ?>>
<?php echo $qc_authorised->a_operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->a_datetime->Visible) { // a_datetime ?>
	<tr id="r_a_datetime">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_a_datetime"><?php echo $qc_authorised->a_datetime->caption() ?></span></td>
		<td data-name="a_datetime"<?php echo $qc_authorised->a_datetime->cellAttributes() ?>>
<span id="el_qc_authorised_a_datetime">
<span<?php echo $qc_authorised->a_datetime->viewAttributes() ?>>
<?php echo $qc_authorised->a_datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_authorised->bcode_status->Visible) { // bcode_status ?>
	<tr id="r_bcode_status">
		<td class="<?php echo $qc_authorised_view->TableLeftColumnClass ?>"><span id="elh_qc_authorised_bcode_status"><?php echo $qc_authorised->bcode_status->caption() ?></span></td>
		<td data-name="bcode_status"<?php echo $qc_authorised->bcode_status->cellAttributes() ?>>
<span id="el_qc_authorised_bcode_status">
<span<?php echo $qc_authorised->bcode_status->viewAttributes() ?>>
<?php echo $qc_authorised->bcode_status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$qc_authorised_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$qc_authorised->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$qc_authorised_view->terminate();
?>