<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_items_add = new qc_items_add();

// Run the page
$qc_items_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_items_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fqc_itemsadd = currentForm = new ew.Form("fqc_itemsadd", "add");

// Validate form
fqc_itemsadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($qc_items_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc_items->grp->caption(), $qc_items->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_items_add->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc_items->item->caption(), $qc_items->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_items_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc_items->status->caption(), $qc_items->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_items_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc_items->operator->caption(), $qc_items->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_items_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc_items->datetime->caption(), $qc_items->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fqc_itemsadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_itemsadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_itemsadd.lists["x_grp"] = <?php echo $qc_items_add->grp->Lookup->toClientList() ?>;
fqc_itemsadd.lists["x_grp"].options = <?php echo JsonEncode($qc_items_add->grp->lookupOptions()) ?>;
fqc_itemsadd.lists["x_status"] = <?php echo $qc_items_add->status->Lookup->toClientList() ?>;
fqc_itemsadd.lists["x_status"].options = <?php echo JsonEncode($qc_items_add->status->options(FALSE, TRUE)) ?>;
fqc_itemsadd.lists["x_operator"] = <?php echo $qc_items_add->operator->Lookup->toClientList() ?>;
fqc_itemsadd.lists["x_operator"].options = <?php echo JsonEncode($qc_items_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $qc_items_add->showPageHeader(); ?>
<?php
$qc_items_add->showMessage();
?>
<form name="fqc_itemsadd" id="fqc_itemsadd" class="<?php echo $qc_items_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_items_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_items_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc_items">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$qc_items_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($qc_items->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_qc_items_grp" for="x_grp" class="<?php echo $qc_items_add->LeftColumnClass ?>"><?php echo $qc_items->grp->caption() ?><?php echo ($qc_items->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_items_add->RightColumnClass ?>"><div<?php echo $qc_items->grp->cellAttributes() ?>>
<span id="el_qc_items_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_items" data-field="x_grp" data-value-separator="<?php echo $qc_items->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $qc_items->grp->editAttributes() ?>>
		<?php echo $qc_items->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $qc_items->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $qc_items->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc_items->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_qc_items_item" for="x_item" class="<?php echo $qc_items_add->LeftColumnClass ?>"><?php echo $qc_items->item->caption() ?><?php echo ($qc_items->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_items_add->RightColumnClass ?>"><div<?php echo $qc_items->item->cellAttributes() ?>>
<span id="el_qc_items_item">
<input type="text" data-table="qc_items" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($qc_items->item->getPlaceHolder()) ?>" value="<?php echo $qc_items->item->EditValue ?>"<?php echo $qc_items->item->editAttributes() ?>>
</span>
<?php echo $qc_items->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc_items->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_qc_items_status" for="x_status" class="<?php echo $qc_items_add->LeftColumnClass ?>"><?php echo $qc_items->status->caption() ?><?php echo ($qc_items->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_items_add->RightColumnClass ?>"><div<?php echo $qc_items->status->cellAttributes() ?>>
<span id="el_qc_items_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_items" data-field="x_status" data-value-separator="<?php echo $qc_items->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $qc_items->status->editAttributes() ?>>
		<?php echo $qc_items->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $qc_items->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$qc_items_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $qc_items_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $qc_items_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$qc_items_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$qc_items_add->terminate();
?>