<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_items_delete = new qc_items_delete();

// Run the page
$qc_items_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_items_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fqc_itemsdelete = currentForm = new ew.Form("fqc_itemsdelete", "delete");

// Form_CustomValidate event
fqc_itemsdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_itemsdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_itemsdelete.lists["x_grp"] = <?php echo $qc_items_delete->grp->Lookup->toClientList() ?>;
fqc_itemsdelete.lists["x_grp"].options = <?php echo JsonEncode($qc_items_delete->grp->lookupOptions()) ?>;
fqc_itemsdelete.lists["x_status"] = <?php echo $qc_items_delete->status->Lookup->toClientList() ?>;
fqc_itemsdelete.lists["x_status"].options = <?php echo JsonEncode($qc_items_delete->status->options(FALSE, TRUE)) ?>;
fqc_itemsdelete.lists["x_operator"] = <?php echo $qc_items_delete->operator->Lookup->toClientList() ?>;
fqc_itemsdelete.lists["x_operator"].options = <?php echo JsonEncode($qc_items_delete->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $qc_items_delete->showPageHeader(); ?>
<?php
$qc_items_delete->showMessage();
?>
<form name="fqc_itemsdelete" id="fqc_itemsdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_items_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_items_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc_items">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($qc_items_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($qc_items->id->Visible) { // id ?>
		<th class="<?php echo $qc_items->id->headerCellClass() ?>"><span id="elh_qc_items_id" class="qc_items_id"><?php echo $qc_items->id->caption() ?></span></th>
<?php } ?>
<?php if ($qc_items->grp->Visible) { // grp ?>
		<th class="<?php echo $qc_items->grp->headerCellClass() ?>"><span id="elh_qc_items_grp" class="qc_items_grp"><?php echo $qc_items->grp->caption() ?></span></th>
<?php } ?>
<?php if ($qc_items->item->Visible) { // item ?>
		<th class="<?php echo $qc_items->item->headerCellClass() ?>"><span id="elh_qc_items_item" class="qc_items_item"><?php echo $qc_items->item->caption() ?></span></th>
<?php } ?>
<?php if ($qc_items->status->Visible) { // status ?>
		<th class="<?php echo $qc_items->status->headerCellClass() ?>"><span id="elh_qc_items_status" class="qc_items_status"><?php echo $qc_items->status->caption() ?></span></th>
<?php } ?>
<?php if ($qc_items->operator->Visible) { // operator ?>
		<th class="<?php echo $qc_items->operator->headerCellClass() ?>"><span id="elh_qc_items_operator" class="qc_items_operator"><?php echo $qc_items->operator->caption() ?></span></th>
<?php } ?>
<?php if ($qc_items->datetime->Visible) { // datetime ?>
		<th class="<?php echo $qc_items->datetime->headerCellClass() ?>"><span id="elh_qc_items_datetime" class="qc_items_datetime"><?php echo $qc_items->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$qc_items_delete->RecCnt = 0;
$i = 0;
while (!$qc_items_delete->Recordset->EOF) {
	$qc_items_delete->RecCnt++;
	$qc_items_delete->RowCnt++;

	// Set row properties
	$qc_items->resetAttributes();
	$qc_items->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$qc_items_delete->loadRowValues($qc_items_delete->Recordset);

	// Render row
	$qc_items_delete->renderRow();
?>
	<tr<?php echo $qc_items->rowAttributes() ?>>
<?php if ($qc_items->id->Visible) { // id ?>
		<td<?php echo $qc_items->id->cellAttributes() ?>>
<span id="el<?php echo $qc_items_delete->RowCnt ?>_qc_items_id" class="qc_items_id">
<span<?php echo $qc_items->id->viewAttributes() ?>>
<?php echo $qc_items->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($qc_items->grp->Visible) { // grp ?>
		<td<?php echo $qc_items->grp->cellAttributes() ?>>
<span id="el<?php echo $qc_items_delete->RowCnt ?>_qc_items_grp" class="qc_items_grp">
<span<?php echo $qc_items->grp->viewAttributes() ?>>
<?php echo $qc_items->grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($qc_items->item->Visible) { // item ?>
		<td<?php echo $qc_items->item->cellAttributes() ?>>
<span id="el<?php echo $qc_items_delete->RowCnt ?>_qc_items_item" class="qc_items_item">
<span<?php echo $qc_items->item->viewAttributes() ?>>
<?php echo $qc_items->item->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($qc_items->status->Visible) { // status ?>
		<td<?php echo $qc_items->status->cellAttributes() ?>>
<span id="el<?php echo $qc_items_delete->RowCnt ?>_qc_items_status" class="qc_items_status">
<span<?php echo $qc_items->status->viewAttributes() ?>>
<?php echo $qc_items->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($qc_items->operator->Visible) { // operator ?>
		<td<?php echo $qc_items->operator->cellAttributes() ?>>
<span id="el<?php echo $qc_items_delete->RowCnt ?>_qc_items_operator" class="qc_items_operator">
<span<?php echo $qc_items->operator->viewAttributes() ?>>
<?php echo $qc_items->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($qc_items->datetime->Visible) { // datetime ?>
		<td<?php echo $qc_items->datetime->cellAttributes() ?>>
<span id="el<?php echo $qc_items_delete->RowCnt ?>_qc_items_datetime" class="qc_items_datetime">
<span<?php echo $qc_items->datetime->viewAttributes() ?>>
<?php echo $qc_items->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$qc_items_delete->Recordset->moveNext();
}
$qc_items_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $qc_items_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$qc_items_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$qc_items_delete->terminate();
?>