<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_items_edit = new qc_items_edit();

// Run the page
$qc_items_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_items_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fqc_itemsedit = currentForm = new ew.Form("fqc_itemsedit", "edit");

// Validate form
fqc_itemsedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($qc_items_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc_items->id->caption(), $qc_items->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_items_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc_items->grp->caption(), $qc_items->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_items_edit->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc_items->item->caption(), $qc_items->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_items_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc_items->status->caption(), $qc_items->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_items_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc_items->operator->caption(), $qc_items->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_items_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc_items->datetime->caption(), $qc_items->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fqc_itemsedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_itemsedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_itemsedit.lists["x_grp"] = <?php echo $qc_items_edit->grp->Lookup->toClientList() ?>;
fqc_itemsedit.lists["x_grp"].options = <?php echo JsonEncode($qc_items_edit->grp->lookupOptions()) ?>;
fqc_itemsedit.lists["x_status"] = <?php echo $qc_items_edit->status->Lookup->toClientList() ?>;
fqc_itemsedit.lists["x_status"].options = <?php echo JsonEncode($qc_items_edit->status->options(FALSE, TRUE)) ?>;
fqc_itemsedit.lists["x_operator"] = <?php echo $qc_items_edit->operator->Lookup->toClientList() ?>;
fqc_itemsedit.lists["x_operator"].options = <?php echo JsonEncode($qc_items_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $qc_items_edit->showPageHeader(); ?>
<?php
$qc_items_edit->showMessage();
?>
<form name="fqc_itemsedit" id="fqc_itemsedit" class="<?php echo $qc_items_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_items_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_items_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc_items">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$qc_items_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($qc_items->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_qc_items_id" class="<?php echo $qc_items_edit->LeftColumnClass ?>"><?php echo $qc_items->id->caption() ?><?php echo ($qc_items->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_items_edit->RightColumnClass ?>"><div<?php echo $qc_items->id->cellAttributes() ?>>
<span id="el_qc_items_id">
<span<?php echo $qc_items->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($qc_items->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="qc_items" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($qc_items->id->CurrentValue) ?>">
<?php echo $qc_items->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc_items->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_qc_items_grp" for="x_grp" class="<?php echo $qc_items_edit->LeftColumnClass ?>"><?php echo $qc_items->grp->caption() ?><?php echo ($qc_items->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_items_edit->RightColumnClass ?>"><div<?php echo $qc_items->grp->cellAttributes() ?>>
<span id="el_qc_items_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_items" data-field="x_grp" data-value-separator="<?php echo $qc_items->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $qc_items->grp->editAttributes() ?>>
		<?php echo $qc_items->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $qc_items->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $qc_items->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc_items->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_qc_items_item" for="x_item" class="<?php echo $qc_items_edit->LeftColumnClass ?>"><?php echo $qc_items->item->caption() ?><?php echo ($qc_items->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_items_edit->RightColumnClass ?>"><div<?php echo $qc_items->item->cellAttributes() ?>>
<span id="el_qc_items_item">
<input type="text" data-table="qc_items" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($qc_items->item->getPlaceHolder()) ?>" value="<?php echo $qc_items->item->EditValue ?>"<?php echo $qc_items->item->editAttributes() ?>>
</span>
<?php echo $qc_items->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc_items->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_qc_items_status" for="x_status" class="<?php echo $qc_items_edit->LeftColumnClass ?>"><?php echo $qc_items->status->caption() ?><?php echo ($qc_items->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_items_edit->RightColumnClass ?>"><div<?php echo $qc_items->status->cellAttributes() ?>>
<span id="el_qc_items_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_items" data-field="x_status" data-value-separator="<?php echo $qc_items->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $qc_items->status->editAttributes() ?>>
		<?php echo $qc_items->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $qc_items->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$qc_items_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $qc_items_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $qc_items_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$qc_items_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$qc_items_edit->terminate();
?>