<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_items_list = new qc_items_list();

// Run the page
$qc_items_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_items_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$qc_items->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fqc_itemslist = currentForm = new ew.Form("fqc_itemslist", "list");
fqc_itemslist.formKeyCountName = '<?php echo $qc_items_list->FormKeyCountName ?>';

// Form_CustomValidate event
fqc_itemslist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_itemslist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_itemslist.lists["x_grp"] = <?php echo $qc_items_list->grp->Lookup->toClientList() ?>;
fqc_itemslist.lists["x_grp"].options = <?php echo JsonEncode($qc_items_list->grp->lookupOptions()) ?>;
fqc_itemslist.lists["x_status"] = <?php echo $qc_items_list->status->Lookup->toClientList() ?>;
fqc_itemslist.lists["x_status"].options = <?php echo JsonEncode($qc_items_list->status->options(FALSE, TRUE)) ?>;
fqc_itemslist.lists["x_operator"] = <?php echo $qc_items_list->operator->Lookup->toClientList() ?>;
fqc_itemslist.lists["x_operator"].options = <?php echo JsonEncode($qc_items_list->operator->lookupOptions()) ?>;

// Form object for search
var fqc_itemslistsrch = currentSearchForm = new ew.Form("fqc_itemslistsrch");

// Filters
fqc_itemslistsrch.filterList = <?php echo $qc_items_list->getFilterList() ?>;

// Init search panel as collapsed
fqc_itemslistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$qc_items->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($qc_items_list->TotalRecs > 0 && $qc_items_list->ExportOptions->visible()) { ?>
<?php $qc_items_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($qc_items_list->ImportOptions->visible()) { ?>
<?php $qc_items_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($qc_items_list->SearchOptions->visible()) { ?>
<?php $qc_items_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($qc_items_list->FilterOptions->visible()) { ?>
<?php $qc_items_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$qc_items_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$qc_items->isExport() && !$qc_items->CurrentAction) { ?>
<form name="fqc_itemslistsrch" id="fqc_itemslistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($qc_items_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fqc_itemslistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="qc_items">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($qc_items_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($qc_items_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $qc_items_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($qc_items_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($qc_items_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($qc_items_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($qc_items_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $qc_items_list->showPageHeader(); ?>
<?php
$qc_items_list->showMessage();
?>
<?php if ($qc_items_list->TotalRecs > 0 || $qc_items->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($qc_items_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> qc_items">
<?php if (!$qc_items->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$qc_items->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($qc_items_list->Pager)) $qc_items_list->Pager = new PrevNextPager($qc_items_list->StartRec, $qc_items_list->DisplayRecs, $qc_items_list->TotalRecs, $qc_items_list->AutoHidePager) ?>
<?php if ($qc_items_list->Pager->RecordCount > 0 && $qc_items_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($qc_items_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $qc_items_list->pageUrl() ?>start=<?php echo $qc_items_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($qc_items_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $qc_items_list->pageUrl() ?>start=<?php echo $qc_items_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $qc_items_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($qc_items_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $qc_items_list->pageUrl() ?>start=<?php echo $qc_items_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($qc_items_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $qc_items_list->pageUrl() ?>start=<?php echo $qc_items_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $qc_items_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($qc_items_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $qc_items_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $qc_items_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $qc_items_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($qc_items_list->TotalRecs > 0 && (!$qc_items_list->AutoHidePageSizeSelector || $qc_items_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="qc_items">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($qc_items_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($qc_items_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($qc_items_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($qc_items_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($qc_items_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($qc_items->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $qc_items_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fqc_itemslist" id="fqc_itemslist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_items_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_items_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc_items">
<div id="gmp_qc_items" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($qc_items_list->TotalRecs > 0 || $qc_items->isGridEdit()) { ?>
<table id="tbl_qc_itemslist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$qc_items_list->RowType = ROWTYPE_HEADER;

// Render list options
$qc_items_list->renderListOptions();

// Render list options (header, left)
$qc_items_list->ListOptions->render("header", "left");
?>
<?php if ($qc_items->id->Visible) { // id ?>
	<?php if ($qc_items->sortUrl($qc_items->id) == "") { ?>
		<th data-name="id" class="<?php echo $qc_items->id->headerCellClass() ?>"><div id="elh_qc_items_id" class="qc_items_id"><div class="ew-table-header-caption"><?php echo $qc_items->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $qc_items->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_items->SortUrl($qc_items->id) ?>',2);"><div id="elh_qc_items_id" class="qc_items_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_items->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_items->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_items->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_items->grp->Visible) { // grp ?>
	<?php if ($qc_items->sortUrl($qc_items->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $qc_items->grp->headerCellClass() ?>"><div id="elh_qc_items_grp" class="qc_items_grp"><div class="ew-table-header-caption"><?php echo $qc_items->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $qc_items->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_items->SortUrl($qc_items->grp) ?>',2);"><div id="elh_qc_items_grp" class="qc_items_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_items->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_items->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_items->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_items->item->Visible) { // item ?>
	<?php if ($qc_items->sortUrl($qc_items->item) == "") { ?>
		<th data-name="item" class="<?php echo $qc_items->item->headerCellClass() ?>"><div id="elh_qc_items_item" class="qc_items_item"><div class="ew-table-header-caption"><?php echo $qc_items->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $qc_items->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_items->SortUrl($qc_items->item) ?>',2);"><div id="elh_qc_items_item" class="qc_items_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_items->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_items->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_items->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_items->status->Visible) { // status ?>
	<?php if ($qc_items->sortUrl($qc_items->status) == "") { ?>
		<th data-name="status" class="<?php echo $qc_items->status->headerCellClass() ?>"><div id="elh_qc_items_status" class="qc_items_status"><div class="ew-table-header-caption"><?php echo $qc_items->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $qc_items->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_items->SortUrl($qc_items->status) ?>',2);"><div id="elh_qc_items_status" class="qc_items_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_items->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_items->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_items->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_items->operator->Visible) { // operator ?>
	<?php if ($qc_items->sortUrl($qc_items->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $qc_items->operator->headerCellClass() ?>"><div id="elh_qc_items_operator" class="qc_items_operator"><div class="ew-table-header-caption"><?php echo $qc_items->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $qc_items->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_items->SortUrl($qc_items->operator) ?>',2);"><div id="elh_qc_items_operator" class="qc_items_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_items->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_items->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_items->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_items->datetime->Visible) { // datetime ?>
	<?php if ($qc_items->sortUrl($qc_items->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $qc_items->datetime->headerCellClass() ?>"><div id="elh_qc_items_datetime" class="qc_items_datetime"><div class="ew-table-header-caption"><?php echo $qc_items->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $qc_items->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_items->SortUrl($qc_items->datetime) ?>',2);"><div id="elh_qc_items_datetime" class="qc_items_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_items->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_items->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_items->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$qc_items_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($qc_items->ExportAll && $qc_items->isExport()) {
	$qc_items_list->StopRec = $qc_items_list->TotalRecs;
} else {

	// Set the last record to display
	if ($qc_items_list->TotalRecs > $qc_items_list->StartRec + $qc_items_list->DisplayRecs - 1)
		$qc_items_list->StopRec = $qc_items_list->StartRec + $qc_items_list->DisplayRecs - 1;
	else
		$qc_items_list->StopRec = $qc_items_list->TotalRecs;
}
$qc_items_list->RecCnt = $qc_items_list->StartRec - 1;
if ($qc_items_list->Recordset && !$qc_items_list->Recordset->EOF) {
	$qc_items_list->Recordset->moveFirst();
	$selectLimit = $qc_items_list->UseSelectLimit;
	if (!$selectLimit && $qc_items_list->StartRec > 1)
		$qc_items_list->Recordset->move($qc_items_list->StartRec - 1);
} elseif (!$qc_items->AllowAddDeleteRow && $qc_items_list->StopRec == 0) {
	$qc_items_list->StopRec = $qc_items->GridAddRowCount;
}

// Initialize aggregate
$qc_items->RowType = ROWTYPE_AGGREGATEINIT;
$qc_items->resetAttributes();
$qc_items_list->renderRow();
while ($qc_items_list->RecCnt < $qc_items_list->StopRec) {
	$qc_items_list->RecCnt++;
	if ($qc_items_list->RecCnt >= $qc_items_list->StartRec) {
		$qc_items_list->RowCnt++;

		// Set up key count
		$qc_items_list->KeyCount = $qc_items_list->RowIndex;

		// Init row class and style
		$qc_items->resetAttributes();
		$qc_items->CssClass = "";
		if ($qc_items->isGridAdd()) {
		} else {
			$qc_items_list->loadRowValues($qc_items_list->Recordset); // Load row values
		}
		$qc_items->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$qc_items->RowAttrs = array_merge($qc_items->RowAttrs, array('data-rowindex'=>$qc_items_list->RowCnt, 'id'=>'r' . $qc_items_list->RowCnt . '_qc_items', 'data-rowtype'=>$qc_items->RowType));

		// Render row
		$qc_items_list->renderRow();

		// Render list options
		$qc_items_list->renderListOptions();
?>
	<tr<?php echo $qc_items->rowAttributes() ?>>
<?php

// Render list options (body, left)
$qc_items_list->ListOptions->render("body", "left", $qc_items_list->RowCnt);
?>
	<?php if ($qc_items->id->Visible) { // id ?>
		<td data-name="id"<?php echo $qc_items->id->cellAttributes() ?>>
<span id="el<?php echo $qc_items_list->RowCnt ?>_qc_items_id" class="qc_items_id">
<span<?php echo $qc_items->id->viewAttributes() ?>>
<?php echo $qc_items->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_items->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $qc_items->grp->cellAttributes() ?>>
<span id="el<?php echo $qc_items_list->RowCnt ?>_qc_items_grp" class="qc_items_grp">
<span<?php echo $qc_items->grp->viewAttributes() ?>>
<?php echo $qc_items->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_items->item->Visible) { // item ?>
		<td data-name="item"<?php echo $qc_items->item->cellAttributes() ?>>
<span id="el<?php echo $qc_items_list->RowCnt ?>_qc_items_item" class="qc_items_item">
<span<?php echo $qc_items->item->viewAttributes() ?>>
<?php echo $qc_items->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_items->status->Visible) { // status ?>
		<td data-name="status"<?php echo $qc_items->status->cellAttributes() ?>>
<span id="el<?php echo $qc_items_list->RowCnt ?>_qc_items_status" class="qc_items_status">
<span<?php echo $qc_items->status->viewAttributes() ?>>
<?php echo $qc_items->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_items->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $qc_items->operator->cellAttributes() ?>>
<span id="el<?php echo $qc_items_list->RowCnt ?>_qc_items_operator" class="qc_items_operator">
<span<?php echo $qc_items->operator->viewAttributes() ?>>
<?php echo $qc_items->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_items->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $qc_items->datetime->cellAttributes() ?>>
<span id="el<?php echo $qc_items_list->RowCnt ?>_qc_items_datetime" class="qc_items_datetime">
<span<?php echo $qc_items->datetime->viewAttributes() ?>>
<?php echo $qc_items->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$qc_items_list->ListOptions->render("body", "right", $qc_items_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$qc_items->isGridAdd())
		$qc_items_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$qc_items->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($qc_items_list->Recordset)
	$qc_items_list->Recordset->Close();
?>
<?php if (!$qc_items->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$qc_items->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($qc_items_list->Pager)) $qc_items_list->Pager = new PrevNextPager($qc_items_list->StartRec, $qc_items_list->DisplayRecs, $qc_items_list->TotalRecs, $qc_items_list->AutoHidePager) ?>
<?php if ($qc_items_list->Pager->RecordCount > 0 && $qc_items_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($qc_items_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $qc_items_list->pageUrl() ?>start=<?php echo $qc_items_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($qc_items_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $qc_items_list->pageUrl() ?>start=<?php echo $qc_items_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $qc_items_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($qc_items_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $qc_items_list->pageUrl() ?>start=<?php echo $qc_items_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($qc_items_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $qc_items_list->pageUrl() ?>start=<?php echo $qc_items_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $qc_items_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($qc_items_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $qc_items_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $qc_items_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $qc_items_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($qc_items_list->TotalRecs > 0 && (!$qc_items_list->AutoHidePageSizeSelector || $qc_items_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="qc_items">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($qc_items_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($qc_items_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($qc_items_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($qc_items_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($qc_items_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($qc_items->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $qc_items_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($qc_items_list->TotalRecs == 0 && !$qc_items->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $qc_items_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$qc_items_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$qc_items->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$qc_items->isExport()) { ?>
<script>
ew.scrollableTable("gmp_qc_items", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$qc_items_list->terminate();
?>