<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_items_search = new qc_items_search();

// Run the page
$qc_items_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_items_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($qc_items_search->IsModal) { ?>
var fqc_itemssearch = currentAdvancedSearchForm = new ew.Form("fqc_itemssearch", "search");
<?php } else { ?>
var fqc_itemssearch = currentForm = new ew.Form("fqc_itemssearch", "search");
<?php } ?>

// Form_CustomValidate event
fqc_itemssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_itemssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_itemssearch.lists["x_grp"] = <?php echo $qc_items_search->grp->Lookup->toClientList() ?>;
fqc_itemssearch.lists["x_grp"].options = <?php echo JsonEncode($qc_items_search->grp->lookupOptions()) ?>;
fqc_itemssearch.lists["x_status"] = <?php echo $qc_items_search->status->Lookup->toClientList() ?>;
fqc_itemssearch.lists["x_status"].options = <?php echo JsonEncode($qc_items_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fqc_itemssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_items->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $qc_items_search->showPageHeader(); ?>
<?php
$qc_items_search->showMessage();
?>
<form name="fqc_itemssearch" id="fqc_itemssearch" class="<?php echo $qc_items_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_items_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_items_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc_items">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$qc_items_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($qc_items->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $qc_items_search->LeftColumnClass ?>"><span id="elh_qc_items_id"><?php echo $qc_items->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $qc_items_search->RightColumnClass ?>"><div<?php echo $qc_items->id->cellAttributes() ?>>
			<span id="el_qc_items_id">
<input type="text" data-table="qc_items" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($qc_items->id->getPlaceHolder()) ?>" value="<?php echo $qc_items->id->EditValue ?>"<?php echo $qc_items->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_items->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $qc_items_search->LeftColumnClass ?>"><span id="elh_qc_items_grp"><?php echo $qc_items->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $qc_items_search->RightColumnClass ?>"><div<?php echo $qc_items->grp->cellAttributes() ?>>
			<span id="el_qc_items_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_items" data-field="x_grp" data-value-separator="<?php echo $qc_items->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $qc_items->grp->editAttributes() ?>>
		<?php echo $qc_items->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $qc_items->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_items->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $qc_items_search->LeftColumnClass ?>"><span id="elh_qc_items_item"><?php echo $qc_items->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_items_search->RightColumnClass ?>"><div<?php echo $qc_items->item->cellAttributes() ?>>
			<span id="el_qc_items_item">
<input type="text" data-table="qc_items" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($qc_items->item->getPlaceHolder()) ?>" value="<?php echo $qc_items->item->EditValue ?>"<?php echo $qc_items->item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_items->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $qc_items_search->LeftColumnClass ?>"><span id="elh_qc_items_status"><?php echo $qc_items->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $qc_items_search->RightColumnClass ?>"><div<?php echo $qc_items->status->cellAttributes() ?>>
			<span id="el_qc_items_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_items" data-field="x_status" data-value-separator="<?php echo $qc_items->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $qc_items->status->editAttributes() ?>>
		<?php echo $qc_items->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$qc_items_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $qc_items_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$qc_items_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$qc_items_search->terminate();
?>