<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_items_view = new qc_items_view();

// Run the page
$qc_items_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_items_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$qc_items->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fqc_itemsview = currentForm = new ew.Form("fqc_itemsview", "view");

// Form_CustomValidate event
fqc_itemsview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_itemsview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_itemsview.lists["x_grp"] = <?php echo $qc_items_view->grp->Lookup->toClientList() ?>;
fqc_itemsview.lists["x_grp"].options = <?php echo JsonEncode($qc_items_view->grp->lookupOptions()) ?>;
fqc_itemsview.lists["x_status"] = <?php echo $qc_items_view->status->Lookup->toClientList() ?>;
fqc_itemsview.lists["x_status"].options = <?php echo JsonEncode($qc_items_view->status->options(FALSE, TRUE)) ?>;
fqc_itemsview.lists["x_operator"] = <?php echo $qc_items_view->operator->Lookup->toClientList() ?>;
fqc_itemsview.lists["x_operator"].options = <?php echo JsonEncode($qc_items_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$qc_items->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $qc_items_view->ExportOptions->render("body") ?>
<?php $qc_items_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $qc_items_view->showPageHeader(); ?>
<?php
$qc_items_view->showMessage();
?>
<form name="fqc_itemsview" id="fqc_itemsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_items_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_items_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc_items">
<input type="hidden" name="modal" value="<?php echo (int)$qc_items_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($qc_items->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $qc_items_view->TableLeftColumnClass ?>"><span id="elh_qc_items_id"><?php echo $qc_items->id->caption() ?></span></td>
		<td data-name="id"<?php echo $qc_items->id->cellAttributes() ?>>
<span id="el_qc_items_id">
<span<?php echo $qc_items->id->viewAttributes() ?>>
<?php echo $qc_items->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_items->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $qc_items_view->TableLeftColumnClass ?>"><span id="elh_qc_items_grp"><?php echo $qc_items->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $qc_items->grp->cellAttributes() ?>>
<span id="el_qc_items_grp">
<span<?php echo $qc_items->grp->viewAttributes() ?>>
<?php echo $qc_items->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_items->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $qc_items_view->TableLeftColumnClass ?>"><span id="elh_qc_items_item"><?php echo $qc_items->item->caption() ?></span></td>
		<td data-name="item"<?php echo $qc_items->item->cellAttributes() ?>>
<span id="el_qc_items_item">
<span<?php echo $qc_items->item->viewAttributes() ?>>
<?php echo $qc_items->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_items->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $qc_items_view->TableLeftColumnClass ?>"><span id="elh_qc_items_status"><?php echo $qc_items->status->caption() ?></span></td>
		<td data-name="status"<?php echo $qc_items->status->cellAttributes() ?>>
<span id="el_qc_items_status">
<span<?php echo $qc_items->status->viewAttributes() ?>>
<?php echo $qc_items->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_items->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $qc_items_view->TableLeftColumnClass ?>"><span id="elh_qc_items_operator"><?php echo $qc_items->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $qc_items->operator->cellAttributes() ?>>
<span id="el_qc_items_operator">
<span<?php echo $qc_items->operator->viewAttributes() ?>>
<?php echo $qc_items->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc_items->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $qc_items_view->TableLeftColumnClass ?>"><span id="elh_qc_items_datetime"><?php echo $qc_items->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $qc_items->datetime->cellAttributes() ?>>
<span id="el_qc_items_datetime">
<span<?php echo $qc_items->datetime->viewAttributes() ?>>
<?php echo $qc_items->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$qc_items_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$qc_items->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$qc_items_view->terminate();
?>