<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_missing_list = new qc_missing_list();

// Run the page
$qc_missing_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_missing_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$qc_missing->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fqc_missinglist = currentForm = new ew.Form("fqc_missinglist", "list");
fqc_missinglist.formKeyCountName = '<?php echo $qc_missing_list->FormKeyCountName ?>';

// Form_CustomValidate event
fqc_missinglist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_missinglist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_missinglist.lists["x_process"] = <?php echo $qc_missing_list->process->Lookup->toClientList() ?>;
fqc_missinglist.lists["x_process"].options = <?php echo JsonEncode($qc_missing_list->process->lookupOptions()) ?>;
fqc_missinglist.lists["x_process_c[]"] = <?php echo $qc_missing_list->process_c->Lookup->toClientList() ?>;
fqc_missinglist.lists["x_process_c[]"].options = <?php echo JsonEncode($qc_missing_list->process_c->lookupOptions()) ?>;

// Form object for search
var fqc_missinglistsrch = currentSearchForm = new ew.Form("fqc_missinglistsrch");

// Validate function for search
fqc_missinglistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_missing->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending_days");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_missing->pending_days->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fqc_missinglistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_missinglistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_missinglistsrch.lists["x_process_c[]"] = <?php echo $qc_missing_list->process_c->Lookup->toClientList() ?>;
fqc_missinglistsrch.lists["x_process_c[]"].options = <?php echo JsonEncode($qc_missing_list->process_c->lookupOptions()) ?>;

// Filters
fqc_missinglistsrch.filterList = <?php echo $qc_missing_list->getFilterList() ?>;

// Init search panel as collapsed
fqc_missinglistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$qc_missing->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($qc_missing_list->TotalRecs > 0 && $qc_missing_list->ExportOptions->visible()) { ?>
<?php $qc_missing_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($qc_missing_list->ImportOptions->visible()) { ?>
<?php $qc_missing_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($qc_missing_list->SearchOptions->visible()) { ?>
<?php $qc_missing_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($qc_missing_list->FilterOptions->visible()) { ?>
<?php $qc_missing_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$qc_missing_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$qc_missing->isExport() && !$qc_missing->CurrentAction) { ?>
<form name="fqc_missinglistsrch" id="fqc_missinglistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($qc_missing_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fqc_missinglistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="qc_missing">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$qc_missing_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$qc_missing->RowType = ROWTYPE_SEARCH;

// Render row
$qc_missing->resetAttributes();
$qc_missing_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($qc_missing->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $qc_missing->_barcode->caption() ?></label>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_missing->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_missing->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_missing->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_missing->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_missing->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_missing->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($qc_missing->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="qc_missing" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($qc_missing->_barcode->getPlaceHolder()) ?>" value="<?php echo $qc_missing->_barcode->EditValue ?>"<?php echo $qc_missing->_barcode->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1__barcode style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1__barcode style="d-none"">
<input type="text" data-table="qc_missing" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($qc_missing->_barcode->getPlaceHolder()) ?>" value="<?php echo $qc_missing->_barcode->EditValue2 ?>"<?php echo $qc_missing->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($qc_missing->pending_days->Visible) { // pending_days ?>
	<div id="xsc_pending_days" class="ew-cell form-group">
		<label for="x_pending_days" class="ew-search-caption ew-label"><?php echo $qc_missing->pending_days->caption() ?></label>
		<span class="ew-search-operator"><select name="z_pending_days" id="z_pending_days" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="qc_missing" data-field="x_pending_days" name="x_pending_days" id="x_pending_days" size="30" placeholder="<?php echo HtmlEncode($qc_missing->pending_days->getPlaceHolder()) ?>" value="<?php echo $qc_missing->pending_days->EditValue ?>"<?php echo $qc_missing->pending_days->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_pending_days style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_pending_days style="d-none"">
<input type="text" data-table="qc_missing" data-field="x_pending_days" name="y_pending_days" id="y_pending_days" size="30" placeholder="<?php echo HtmlEncode($qc_missing->pending_days->getPlaceHolder()) ?>" value="<?php echo $qc_missing->pending_days->EditValue2 ?>"<?php echo $qc_missing->pending_days->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($qc_missing->process_c->Visible) { // process_c ?>
	<div id="xsc_process_c" class="ew-cell form-group">
		<label for="x_process_c" class="ew-search-caption ew-label"><?php echo $qc_missing->process_c->caption() ?></label>
		<span class="ew-search-operator"><select name="z_process_c" id="z_process_c" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_missing" data-field="x_process_c" data-value-separator="<?php echo $qc_missing->process_c->displayValueSeparatorAttribute() ?>" id="x_process_c[]" name="x_process_c[]" multiple="multiple"<?php echo $qc_missing->process_c->editAttributes() ?>>
		<?php echo $qc_missing->process_c->selectOptionListHtml("x_process_c[]") ?>
	</select>
</div>
<?php echo $qc_missing->process_c->Lookup->getParamTag("p_x_process_c") ?>
</span>
		<span class="ew-search-cond btw1_process_c style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_process_c style="d-none"">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_missing" data-field="x_process_c" data-value-separator="<?php echo $qc_missing->process_c->displayValueSeparatorAttribute() ?>" id="y_process_c[]" name="y_process_c[]" multiple="multiple"<?php echo $qc_missing->process_c->editAttributes() ?>>
		<?php echo $qc_missing->process_c->selectOptionListHtml("y_process_c[]") ?>
	</select>
</div>
<?php echo $qc_missing->process_c->Lookup->getParamTag("p_y_process_c") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($qc_missing_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($qc_missing_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $qc_missing_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($qc_missing_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($qc_missing_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($qc_missing_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($qc_missing_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $qc_missing_list->showPageHeader(); ?>
<?php
$qc_missing_list->showMessage();
?>
<?php if ($qc_missing_list->TotalRecs > 0 || $qc_missing->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($qc_missing_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> qc_missing">
<?php if (!$qc_missing->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$qc_missing->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($qc_missing_list->Pager)) $qc_missing_list->Pager = new PrevNextPager($qc_missing_list->StartRec, $qc_missing_list->DisplayRecs, $qc_missing_list->TotalRecs, $qc_missing_list->AutoHidePager) ?>
<?php if ($qc_missing_list->Pager->RecordCount > 0 && $qc_missing_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($qc_missing_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $qc_missing_list->pageUrl() ?>start=<?php echo $qc_missing_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($qc_missing_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $qc_missing_list->pageUrl() ?>start=<?php echo $qc_missing_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $qc_missing_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($qc_missing_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $qc_missing_list->pageUrl() ?>start=<?php echo $qc_missing_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($qc_missing_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $qc_missing_list->pageUrl() ?>start=<?php echo $qc_missing_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $qc_missing_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($qc_missing_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $qc_missing_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $qc_missing_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $qc_missing_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($qc_missing_list->TotalRecs > 0 && (!$qc_missing_list->AutoHidePageSizeSelector || $qc_missing_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="qc_missing">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($qc_missing_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($qc_missing_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($qc_missing_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($qc_missing_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($qc_missing_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($qc_missing->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $qc_missing_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fqc_missinglist" id="fqc_missinglist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_missing_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_missing_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc_missing">
<div id="gmp_qc_missing" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($qc_missing_list->TotalRecs > 0 || $qc_missing->isGridEdit()) { ?>
<table id="tbl_qc_missinglist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$qc_missing_list->RowType = ROWTYPE_HEADER;

// Render list options
$qc_missing_list->renderListOptions();

// Render list options (header, left)
$qc_missing_list->ListOptions->render("header", "left");
?>
<?php if ($qc_missing->_barcode->Visible) { // barcode ?>
	<?php if ($qc_missing->sortUrl($qc_missing->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $qc_missing->_barcode->headerCellClass() ?>"><div id="elh_qc_missing__barcode" class="qc_missing__barcode"><div class="ew-table-header-caption"><?php echo $qc_missing->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $qc_missing->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_missing->SortUrl($qc_missing->_barcode) ?>',2);"><div id="elh_qc_missing__barcode" class="qc_missing__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_missing->_barcode->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_missing->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_missing->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_missing->pending_days->Visible) { // pending_days ?>
	<?php if ($qc_missing->sortUrl($qc_missing->pending_days) == "") { ?>
		<th data-name="pending_days" class="<?php echo $qc_missing->pending_days->headerCellClass() ?>"><div id="elh_qc_missing_pending_days" class="qc_missing_pending_days"><div class="ew-table-header-caption"><?php echo $qc_missing->pending_days->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending_days" class="<?php echo $qc_missing->pending_days->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_missing->SortUrl($qc_missing->pending_days) ?>',2);"><div id="elh_qc_missing_pending_days" class="qc_missing_pending_days">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_missing->pending_days->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_missing->pending_days->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_missing->pending_days->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_missing->design->Visible) { // design ?>
	<?php if ($qc_missing->sortUrl($qc_missing->design) == "") { ?>
		<th data-name="design" class="<?php echo $qc_missing->design->headerCellClass() ?>"><div id="elh_qc_missing_design" class="qc_missing_design"><div class="ew-table-header-caption"><?php echo $qc_missing->design->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design" class="<?php echo $qc_missing->design->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_missing->SortUrl($qc_missing->design) ?>',2);"><div id="elh_qc_missing_design" class="qc_missing_design">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_missing->design->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_missing->design->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_missing->design->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_missing->size_cm->Visible) { // size_cm ?>
	<?php if ($qc_missing->sortUrl($qc_missing->size_cm) == "") { ?>
		<th data-name="size_cm" class="<?php echo $qc_missing->size_cm->headerCellClass() ?>"><div id="elh_qc_missing_size_cm" class="qc_missing_size_cm"><div class="ew-table-header-caption"><?php echo $qc_missing->size_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_cm" class="<?php echo $qc_missing->size_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_missing->SortUrl($qc_missing->size_cm) ?>',2);"><div id="elh_qc_missing_size_cm" class="qc_missing_size_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_missing->size_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_missing->size_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_missing->size_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_missing->pl_no->Visible) { // pl_no ?>
	<?php if ($qc_missing->sortUrl($qc_missing->pl_no) == "") { ?>
		<th data-name="pl_no" class="<?php echo $qc_missing->pl_no->headerCellClass() ?>"><div id="elh_qc_missing_pl_no" class="qc_missing_pl_no"><div class="ew-table-header-caption"><?php echo $qc_missing->pl_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pl_no" class="<?php echo $qc_missing->pl_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_missing->SortUrl($qc_missing->pl_no) ?>',2);"><div id="elh_qc_missing_pl_no" class="qc_missing_pl_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_missing->pl_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_missing->pl_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_missing->pl_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_missing->process_datetime->Visible) { // process_datetime ?>
	<?php if ($qc_missing->sortUrl($qc_missing->process_datetime) == "") { ?>
		<th data-name="process_datetime" class="<?php echo $qc_missing->process_datetime->headerCellClass() ?>"><div id="elh_qc_missing_process_datetime" class="qc_missing_process_datetime"><div class="ew-table-header-caption"><?php echo $qc_missing->process_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_datetime" class="<?php echo $qc_missing->process_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_missing->SortUrl($qc_missing->process_datetime) ?>',2);"><div id="elh_qc_missing_process_datetime" class="qc_missing_process_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_missing->process_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_missing->process_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_missing->process_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_missing->process->Visible) { // process ?>
	<?php if ($qc_missing->sortUrl($qc_missing->process) == "") { ?>
		<th data-name="process" class="<?php echo $qc_missing->process->headerCellClass() ?>"><div id="elh_qc_missing_process" class="qc_missing_process"><div class="ew-table-header-caption"><?php echo $qc_missing->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $qc_missing->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_missing->SortUrl($qc_missing->process) ?>',2);"><div id="elh_qc_missing_process" class="qc_missing_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_missing->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_missing->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_missing->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_missing->process_c->Visible) { // process_c ?>
	<?php if ($qc_missing->sortUrl($qc_missing->process_c) == "") { ?>
		<th data-name="process_c" class="<?php echo $qc_missing->process_c->headerCellClass() ?>"><div id="elh_qc_missing_process_c" class="qc_missing_process_c"><div class="ew-table-header-caption"><?php echo $qc_missing->process_c->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_c" class="<?php echo $qc_missing->process_c->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_missing->SortUrl($qc_missing->process_c) ?>',2);"><div id="elh_qc_missing_process_c" class="qc_missing_process_c">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_missing->process_c->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_missing->process_c->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_missing->process_c->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$qc_missing_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($qc_missing->ExportAll && $qc_missing->isExport()) {
	$qc_missing_list->StopRec = $qc_missing_list->TotalRecs;
} else {

	// Set the last record to display
	if ($qc_missing_list->TotalRecs > $qc_missing_list->StartRec + $qc_missing_list->DisplayRecs - 1)
		$qc_missing_list->StopRec = $qc_missing_list->StartRec + $qc_missing_list->DisplayRecs - 1;
	else
		$qc_missing_list->StopRec = $qc_missing_list->TotalRecs;
}
$qc_missing_list->RecCnt = $qc_missing_list->StartRec - 1;
if ($qc_missing_list->Recordset && !$qc_missing_list->Recordset->EOF) {
	$qc_missing_list->Recordset->moveFirst();
	$selectLimit = $qc_missing_list->UseSelectLimit;
	if (!$selectLimit && $qc_missing_list->StartRec > 1)
		$qc_missing_list->Recordset->move($qc_missing_list->StartRec - 1);
} elseif (!$qc_missing->AllowAddDeleteRow && $qc_missing_list->StopRec == 0) {
	$qc_missing_list->StopRec = $qc_missing->GridAddRowCount;
}

// Initialize aggregate
$qc_missing->RowType = ROWTYPE_AGGREGATEINIT;
$qc_missing->resetAttributes();
$qc_missing_list->renderRow();
while ($qc_missing_list->RecCnt < $qc_missing_list->StopRec) {
	$qc_missing_list->RecCnt++;
	if ($qc_missing_list->RecCnt >= $qc_missing_list->StartRec) {
		$qc_missing_list->RowCnt++;

		// Set up key count
		$qc_missing_list->KeyCount = $qc_missing_list->RowIndex;

		// Init row class and style
		$qc_missing->resetAttributes();
		$qc_missing->CssClass = "";
		if ($qc_missing->isGridAdd()) {
		} else {
			$qc_missing_list->loadRowValues($qc_missing_list->Recordset); // Load row values
		}
		$qc_missing->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$qc_missing->RowAttrs = array_merge($qc_missing->RowAttrs, array('data-rowindex'=>$qc_missing_list->RowCnt, 'id'=>'r' . $qc_missing_list->RowCnt . '_qc_missing', 'data-rowtype'=>$qc_missing->RowType));

		// Render row
		$qc_missing_list->renderRow();

		// Render list options
		$qc_missing_list->renderListOptions();
?>
	<tr<?php echo $qc_missing->rowAttributes() ?>>
<?php

// Render list options (body, left)
$qc_missing_list->ListOptions->render("body", "left", $qc_missing_list->RowCnt);
?>
	<?php if ($qc_missing->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $qc_missing->_barcode->cellAttributes() ?>>
<span id="el<?php echo $qc_missing_list->RowCnt ?>_qc_missing__barcode" class="qc_missing__barcode">
<span<?php echo $qc_missing->_barcode->viewAttributes() ?>>
<?php if ((!EmptyString($qc_missing->_barcode->getViewValue())) && $qc_missing->_barcode->linkAttributes() <> "") { ?>
<a<?php echo $qc_missing->_barcode->linkAttributes() ?>><?php echo $qc_missing->_barcode->getViewValue() ?></a>
<?php } else { ?>
<?php echo $qc_missing->_barcode->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_missing->pending_days->Visible) { // pending_days ?>
		<td data-name="pending_days"<?php echo $qc_missing->pending_days->cellAttributes() ?>>
<span id="el<?php echo $qc_missing_list->RowCnt ?>_qc_missing_pending_days" class="qc_missing_pending_days">
<span<?php echo $qc_missing->pending_days->viewAttributes() ?>>
<?php echo $qc_missing->pending_days->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_missing->design->Visible) { // design ?>
		<td data-name="design"<?php echo $qc_missing->design->cellAttributes() ?>>
<span id="el<?php echo $qc_missing_list->RowCnt ?>_qc_missing_design" class="qc_missing_design">
<span<?php echo $qc_missing->design->viewAttributes() ?>>
<?php echo $qc_missing->design->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_missing->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm"<?php echo $qc_missing->size_cm->cellAttributes() ?>>
<span id="el<?php echo $qc_missing_list->RowCnt ?>_qc_missing_size_cm" class="qc_missing_size_cm">
<span<?php echo $qc_missing->size_cm->viewAttributes() ?>>
<?php echo $qc_missing->size_cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_missing->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no"<?php echo $qc_missing->pl_no->cellAttributes() ?>>
<span id="el<?php echo $qc_missing_list->RowCnt ?>_qc_missing_pl_no" class="qc_missing_pl_no">
<span<?php echo $qc_missing->pl_no->viewAttributes() ?>>
<?php echo $qc_missing->pl_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_missing->process_datetime->Visible) { // process_datetime ?>
		<td data-name="process_datetime"<?php echo $qc_missing->process_datetime->cellAttributes() ?>>
<span id="el<?php echo $qc_missing_list->RowCnt ?>_qc_missing_process_datetime" class="qc_missing_process_datetime">
<span<?php echo $qc_missing->process_datetime->viewAttributes() ?>>
<?php echo $qc_missing->process_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_missing->process->Visible) { // process ?>
		<td data-name="process"<?php echo $qc_missing->process->cellAttributes() ?>>
<span id="el<?php echo $qc_missing_list->RowCnt ?>_qc_missing_process" class="qc_missing_process">
<span<?php echo $qc_missing->process->viewAttributes() ?>>
<?php echo $qc_missing->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_missing->process_c->Visible) { // process_c ?>
		<td data-name="process_c"<?php echo $qc_missing->process_c->cellAttributes() ?>>
<span id="el<?php echo $qc_missing_list->RowCnt ?>_qc_missing_process_c" class="qc_missing_process_c">
<span<?php echo $qc_missing->process_c->viewAttributes() ?>>
<?php echo $qc_missing->process_c->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$qc_missing_list->ListOptions->render("body", "right", $qc_missing_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$qc_missing->isGridAdd())
		$qc_missing_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$qc_missing->RowType = ROWTYPE_AGGREGATE;
$qc_missing->resetAttributes();
$qc_missing_list->renderRow();
?>
<?php if ($qc_missing_list->TotalRecs > 0 && !$qc_missing->isGridAdd() && !$qc_missing->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$qc_missing_list->renderListOptions();

// Render list options (footer, left)
$qc_missing_list->ListOptions->render("footer", "left");
?>
	<?php if ($qc_missing->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode" class="<?php echo $qc_missing->_barcode->footerCellClass() ?>"><span id="elf_qc_missing__barcode" class="qc_missing__barcode">
		<span class="ew-aggregate"><?php echo $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
		<?php echo $qc_missing->_barcode->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($qc_missing->pending_days->Visible) { // pending_days ?>
		<td data-name="pending_days" class="<?php echo $qc_missing->pending_days->footerCellClass() ?>"><span id="elf_qc_missing_pending_days" class="qc_missing_pending_days">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($qc_missing->design->Visible) { // design ?>
		<td data-name="design" class="<?php echo $qc_missing->design->footerCellClass() ?>"><span id="elf_qc_missing_design" class="qc_missing_design">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($qc_missing->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm" class="<?php echo $qc_missing->size_cm->footerCellClass() ?>"><span id="elf_qc_missing_size_cm" class="qc_missing_size_cm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($qc_missing->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no" class="<?php echo $qc_missing->pl_no->footerCellClass() ?>"><span id="elf_qc_missing_pl_no" class="qc_missing_pl_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($qc_missing->process_datetime->Visible) { // process_datetime ?>
		<td data-name="process_datetime" class="<?php echo $qc_missing->process_datetime->footerCellClass() ?>"><span id="elf_qc_missing_process_datetime" class="qc_missing_process_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($qc_missing->process->Visible) { // process ?>
		<td data-name="process" class="<?php echo $qc_missing->process->footerCellClass() ?>"><span id="elf_qc_missing_process" class="qc_missing_process">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($qc_missing->process_c->Visible) { // process_c ?>
		<td data-name="process_c" class="<?php echo $qc_missing->process_c->footerCellClass() ?>"><span id="elf_qc_missing_process_c" class="qc_missing_process_c">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$qc_missing_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$qc_missing->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($qc_missing_list->Recordset)
	$qc_missing_list->Recordset->Close();
?>
<?php if (!$qc_missing->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$qc_missing->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($qc_missing_list->Pager)) $qc_missing_list->Pager = new PrevNextPager($qc_missing_list->StartRec, $qc_missing_list->DisplayRecs, $qc_missing_list->TotalRecs, $qc_missing_list->AutoHidePager) ?>
<?php if ($qc_missing_list->Pager->RecordCount > 0 && $qc_missing_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($qc_missing_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $qc_missing_list->pageUrl() ?>start=<?php echo $qc_missing_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($qc_missing_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $qc_missing_list->pageUrl() ?>start=<?php echo $qc_missing_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $qc_missing_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($qc_missing_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $qc_missing_list->pageUrl() ?>start=<?php echo $qc_missing_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($qc_missing_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $qc_missing_list->pageUrl() ?>start=<?php echo $qc_missing_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $qc_missing_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($qc_missing_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $qc_missing_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $qc_missing_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $qc_missing_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($qc_missing_list->TotalRecs > 0 && (!$qc_missing_list->AutoHidePageSizeSelector || $qc_missing_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="qc_missing">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($qc_missing_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($qc_missing_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($qc_missing_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($qc_missing_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($qc_missing_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($qc_missing->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $qc_missing_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($qc_missing_list->TotalRecs == 0 && !$qc_missing->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $qc_missing_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$qc_missing_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$qc_missing->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$qc_missing->isExport()) { ?>
<script>
ew.scrollableTable("gmp_qc_missing", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$qc_missing_list->terminate();
?>