<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_missing_search = new qc_missing_search();

// Run the page
$qc_missing_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_missing_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($qc_missing_search->IsModal) { ?>
var fqc_missingsearch = currentAdvancedSearchForm = new ew.Form("fqc_missingsearch", "search");
<?php } else { ?>
var fqc_missingsearch = currentForm = new ew.Form("fqc_missingsearch", "search");
<?php } ?>

// Form_CustomValidate event
fqc_missingsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_missingsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_missingsearch.lists["x_process"] = <?php echo $qc_missing_search->process->Lookup->toClientList() ?>;
fqc_missingsearch.lists["x_process"].options = <?php echo JsonEncode($qc_missing_search->process->lookupOptions()) ?>;
fqc_missingsearch.lists["x_process_c[]"] = <?php echo $qc_missing_search->process_c->Lookup->toClientList() ?>;
fqc_missingsearch.lists["x_process_c[]"].options = <?php echo JsonEncode($qc_missing_search->process_c->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fqc_missingsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_missing->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending_days");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_missing->pending_days->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pl_no");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_missing->pl_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_process_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_missing->process_datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $qc_missing_search->showPageHeader(); ?>
<?php
$qc_missing_search->showMessage();
?>
<form name="fqc_missingsearch" id="fqc_missingsearch" class="<?php echo $qc_missing_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_missing_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_missing_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc_missing">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$qc_missing_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($qc_missing->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $qc_missing_search->LeftColumnClass ?>"><span id="elh_qc_missing__barcode"><?php echo $qc_missing->_barcode->caption() ?></span>
		</label>
		<div class="<?php echo $qc_missing_search->RightColumnClass ?>"><div<?php echo $qc_missing->_barcode->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_missing->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_missing->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_missing->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_missing->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_missing->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_missing->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($qc_missing->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_qc_missing__barcode">
<input type="text" data-table="qc_missing" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($qc_missing->_barcode->getPlaceHolder()) ?>" value="<?php echo $qc_missing->_barcode->EditValue ?>"<?php echo $qc_missing->_barcode->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1__barcode d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_qc_missing__barcode" class="btw1__barcode d-none">
<input type="text" data-table="qc_missing" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($qc_missing->_barcode->getPlaceHolder()) ?>" value="<?php echo $qc_missing->_barcode->EditValue2 ?>"<?php echo $qc_missing->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_missing->pending_days->Visible) { // pending_days ?>
	<div id="r_pending_days" class="form-group row">
		<label for="x_pending_days" class="<?php echo $qc_missing_search->LeftColumnClass ?>"><span id="elh_qc_missing_pending_days"><?php echo $qc_missing->pending_days->caption() ?></span>
		</label>
		<div class="<?php echo $qc_missing_search->RightColumnClass ?>"><div<?php echo $qc_missing->pending_days->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_pending_days" id="z_pending_days" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($qc_missing->pending_days->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_qc_missing_pending_days">
<input type="text" data-table="qc_missing" data-field="x_pending_days" name="x_pending_days" id="x_pending_days" size="30" placeholder="<?php echo HtmlEncode($qc_missing->pending_days->getPlaceHolder()) ?>" value="<?php echo $qc_missing->pending_days->EditValue ?>"<?php echo $qc_missing->pending_days->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_pending_days d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_qc_missing_pending_days" class="btw1_pending_days d-none">
<input type="text" data-table="qc_missing" data-field="x_pending_days" name="y_pending_days" id="y_pending_days" size="30" placeholder="<?php echo HtmlEncode($qc_missing->pending_days->getPlaceHolder()) ?>" value="<?php echo $qc_missing->pending_days->EditValue2 ?>"<?php echo $qc_missing->pending_days->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_missing->design->Visible) { // design ?>
	<div id="r_design" class="form-group row">
		<label for="x_design" class="<?php echo $qc_missing_search->LeftColumnClass ?>"><span id="elh_qc_missing_design"><?php echo $qc_missing->design->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design" id="z_design" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_missing_search->RightColumnClass ?>"><div<?php echo $qc_missing->design->cellAttributes() ?>>
			<span id="el_qc_missing_design">
<input type="text" data-table="qc_missing" data-field="x_design" name="x_design" id="x_design" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($qc_missing->design->getPlaceHolder()) ?>" value="<?php echo $qc_missing->design->EditValue ?>"<?php echo $qc_missing->design->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_missing->size_cm->Visible) { // size_cm ?>
	<div id="r_size_cm" class="form-group row">
		<label for="x_size_cm" class="<?php echo $qc_missing_search->LeftColumnClass ?>"><span id="elh_qc_missing_size_cm"><?php echo $qc_missing->size_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_missing_search->RightColumnClass ?>"><div<?php echo $qc_missing->size_cm->cellAttributes() ?>>
			<span id="el_qc_missing_size_cm">
<input type="text" data-table="qc_missing" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($qc_missing->size_cm->getPlaceHolder()) ?>" value="<?php echo $qc_missing->size_cm->EditValue ?>"<?php echo $qc_missing->size_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_missing->pl_no->Visible) { // pl_no ?>
	<div id="r_pl_no" class="form-group row">
		<label for="x_pl_no" class="<?php echo $qc_missing_search->LeftColumnClass ?>"><span id="elh_qc_missing_pl_no"><?php echo $qc_missing->pl_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pl_no" id="z_pl_no" value="="></span>
		</label>
		<div class="<?php echo $qc_missing_search->RightColumnClass ?>"><div<?php echo $qc_missing->pl_no->cellAttributes() ?>>
			<span id="el_qc_missing_pl_no">
<input type="text" data-table="qc_missing" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" size="30" placeholder="<?php echo HtmlEncode($qc_missing->pl_no->getPlaceHolder()) ?>" value="<?php echo $qc_missing->pl_no->EditValue ?>"<?php echo $qc_missing->pl_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_missing->process_datetime->Visible) { // process_datetime ?>
	<div id="r_process_datetime" class="form-group row">
		<label for="x_process_datetime" class="<?php echo $qc_missing_search->LeftColumnClass ?>"><span id="elh_qc_missing_process_datetime"><?php echo $qc_missing->process_datetime->caption() ?></span>
		</label>
		<div class="<?php echo $qc_missing_search->RightColumnClass ?>"><div<?php echo $qc_missing->process_datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_process_datetime" id="z_process_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_missing->process_datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_missing->process_datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_missing->process_datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_missing->process_datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_missing->process_datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_missing->process_datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($qc_missing->process_datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($qc_missing->process_datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($qc_missing->process_datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_qc_missing_process_datetime">
<input type="text" data-table="qc_missing" data-field="x_process_datetime" name="x_process_datetime" id="x_process_datetime" placeholder="<?php echo HtmlEncode($qc_missing->process_datetime->getPlaceHolder()) ?>" value="<?php echo $qc_missing->process_datetime->EditValue ?>"<?php echo $qc_missing->process_datetime->editAttributes() ?>>
<?php if (!$qc_missing->process_datetime->ReadOnly && !$qc_missing->process_datetime->Disabled && !isset($qc_missing->process_datetime->EditAttrs["readonly"]) && !isset($qc_missing->process_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fqc_missingsearch", "x_process_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_process_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_qc_missing_process_datetime" class="btw1_process_datetime d-none">
<input type="text" data-table="qc_missing" data-field="x_process_datetime" name="y_process_datetime" id="y_process_datetime" placeholder="<?php echo HtmlEncode($qc_missing->process_datetime->getPlaceHolder()) ?>" value="<?php echo $qc_missing->process_datetime->EditValue2 ?>"<?php echo $qc_missing->process_datetime->editAttributes() ?>>
<?php if (!$qc_missing->process_datetime->ReadOnly && !$qc_missing->process_datetime->Disabled && !isset($qc_missing->process_datetime->EditAttrs["readonly"]) && !isset($qc_missing->process_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fqc_missingsearch", "y_process_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_missing->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $qc_missing_search->LeftColumnClass ?>"><span id="elh_qc_missing_process"><?php echo $qc_missing->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process" id="z_process" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_missing_search->RightColumnClass ?>"><div<?php echo $qc_missing->process->cellAttributes() ?>>
			<span id="el_qc_missing_process">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_missing" data-field="x_process" data-value-separator="<?php echo $qc_missing->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $qc_missing->process->editAttributes() ?>>
		<?php echo $qc_missing->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $qc_missing->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_missing->process_c->Visible) { // process_c ?>
	<div id="r_process_c" class="form-group row">
		<label for="x_process_c" class="<?php echo $qc_missing_search->LeftColumnClass ?>"><span id="elh_qc_missing_process_c"><?php echo $qc_missing->process_c->caption() ?></span>
		</label>
		<div class="<?php echo $qc_missing_search->RightColumnClass ?>"><div<?php echo $qc_missing->process_c->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_process_c" id="z_process_c" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($qc_missing->process_c->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_qc_missing_process_c">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_missing" data-field="x_process_c" data-value-separator="<?php echo $qc_missing->process_c->displayValueSeparatorAttribute() ?>" id="x_process_c[]" name="x_process_c[]" multiple="multiple"<?php echo $qc_missing->process_c->editAttributes() ?>>
		<?php echo $qc_missing->process_c->selectOptionListHtml("x_process_c[]") ?>
	</select>
</div>
<?php echo $qc_missing->process_c->Lookup->getParamTag("p_x_process_c") ?>
</span>
			<span class="ew-search-cond btw1_process_c d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_qc_missing_process_c" class="btw1_process_c d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_missing" data-field="x_process_c" data-value-separator="<?php echo $qc_missing->process_c->displayValueSeparatorAttribute() ?>" id="y_process_c[]" name="y_process_c[]" multiple="multiple"<?php echo $qc_missing->process_c->editAttributes() ?>>
		<?php echo $qc_missing->process_c->selectOptionListHtml("y_process_c[]") ?>
	</select>
</div>
<?php echo $qc_missing->process_c->Lookup->getParamTag("p_y_process_c") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$qc_missing_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $qc_missing_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$qc_missing_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$qc_missing_search->terminate();
?>