<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_old_list = new qc_old_list();

// Run the page
$qc_old_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_old_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$qc_old->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fqc_oldlist = currentForm = new ew.Form("fqc_oldlist", "list");
fqc_oldlist.formKeyCountName = '<?php echo $qc_old_list->FormKeyCountName ?>';

// Form_CustomValidate event
fqc_oldlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_oldlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_oldlist.lists["x_location"] = <?php echo $qc_old_list->location->Lookup->toClientList() ?>;
fqc_oldlist.lists["x_location"].options = <?php echo JsonEncode($qc_old_list->location->lookupOptions()) ?>;
fqc_oldlist.lists["x_defect_nature"] = <?php echo $qc_old_list->defect_nature->Lookup->toClientList() ?>;
fqc_oldlist.lists["x_defect_nature"].options = <?php echo JsonEncode($qc_old_list->defect_nature->lookupOptions()) ?>;
fqc_oldlist.lists["x_qc_stage"] = <?php echo $qc_old_list->qc_stage->Lookup->toClientList() ?>;
fqc_oldlist.lists["x_qc_stage"].options = <?php echo JsonEncode($qc_old_list->qc_stage->lookupOptions()) ?>;
fqc_oldlist.lists["x_defect_percentage"] = <?php echo $qc_old_list->defect_percentage->Lookup->toClientList() ?>;
fqc_oldlist.lists["x_defect_percentage"].options = <?php echo JsonEncode($qc_old_list->defect_percentage->lookupOptions()) ?>;
fqc_oldlist.lists["x_status"] = <?php echo $qc_old_list->status->Lookup->toClientList() ?>;
fqc_oldlist.lists["x_status"].options = <?php echo JsonEncode($qc_old_list->status->lookupOptions()) ?>;
fqc_oldlist.lists["x_operator"] = <?php echo $qc_old_list->operator->Lookup->toClientList() ?>;
fqc_oldlist.lists["x_operator"].options = <?php echo JsonEncode($qc_old_list->operator->lookupOptions()) ?>;
fqc_oldlist.lists["x_e_operator"] = <?php echo $qc_old_list->e_operator->Lookup->toClientList() ?>;
fqc_oldlist.lists["x_e_operator"].options = <?php echo JsonEncode($qc_old_list->e_operator->lookupOptions()) ?>;
fqc_oldlist.lists["x_a_operator"] = <?php echo $qc_old_list->a_operator->Lookup->toClientList() ?>;
fqc_oldlist.lists["x_a_operator"].options = <?php echo JsonEncode($qc_old_list->a_operator->lookupOptions()) ?>;

// Form object for search
var fqc_oldlistsrch = currentSearchForm = new ew.Form("fqc_oldlistsrch");

// Validate function for search
fqc_oldlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_old->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_deduction");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_old->deduction->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fqc_oldlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_oldlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_oldlistsrch.lists["x_location"] = <?php echo $qc_old_list->location->Lookup->toClientList() ?>;
fqc_oldlistsrch.lists["x_location"].options = <?php echo JsonEncode($qc_old_list->location->lookupOptions()) ?>;

// Filters
fqc_oldlistsrch.filterList = <?php echo $qc_old_list->getFilterList() ?>;

// Init search panel as collapsed
fqc_oldlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$qc_old->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($qc_old_list->TotalRecs > 0 && $qc_old_list->ExportOptions->visible()) { ?>
<?php $qc_old_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($qc_old_list->ImportOptions->visible()) { ?>
<?php $qc_old_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($qc_old_list->SearchOptions->visible()) { ?>
<?php $qc_old_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($qc_old_list->FilterOptions->visible()) { ?>
<?php $qc_old_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$qc_old_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$qc_old->isExport() && !$qc_old->CurrentAction) { ?>
<form name="fqc_oldlistsrch" id="fqc_oldlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($qc_old_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fqc_oldlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="qc_old">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$qc_old_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$qc_old->RowType = ROWTYPE_SEARCH;

// Render row
$qc_old->resetAttributes();
$qc_old_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($qc_old->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $qc_old->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_old" data-field="x_location" data-value-separator="<?php echo $qc_old->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $qc_old->location->editAttributes() ?>>
		<?php echo $qc_old->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $qc_old->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($qc_old->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $qc_old->_barcode->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__barcode" id="z__barcode" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="qc_old" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($qc_old->_barcode->getPlaceHolder()) ?>" value="<?php echo $qc_old->_barcode->EditValue ?>"<?php echo $qc_old->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($qc_old->deduction->Visible) { // deduction ?>
	<div id="xsc_deduction" class="ew-cell form-group">
		<label for="x_deduction" class="ew-search-caption ew-label"><?php echo $qc_old->deduction->caption() ?></label>
		<span class="ew-search-operator"><select name="z_deduction" id="z_deduction" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="qc_old" data-field="x_deduction" name="x_deduction" id="x_deduction" size="30" placeholder="<?php echo HtmlEncode($qc_old->deduction->getPlaceHolder()) ?>" value="<?php echo $qc_old->deduction->EditValue ?>"<?php echo $qc_old->deduction->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_deduction style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_deduction style="d-none"">
<input type="text" data-table="qc_old" data-field="x_deduction" name="y_deduction" id="y_deduction" size="30" placeholder="<?php echo HtmlEncode($qc_old->deduction->getPlaceHolder()) ?>" value="<?php echo $qc_old->deduction->EditValue2 ?>"<?php echo $qc_old->deduction->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($qc_old_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($qc_old_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $qc_old_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($qc_old_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($qc_old_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($qc_old_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($qc_old_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $qc_old_list->showPageHeader(); ?>
<?php
$qc_old_list->showMessage();
?>
<?php if ($qc_old_list->TotalRecs > 0 || $qc_old->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($qc_old_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> qc_old">
<?php if (!$qc_old->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$qc_old->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($qc_old_list->Pager)) $qc_old_list->Pager = new PrevNextPager($qc_old_list->StartRec, $qc_old_list->DisplayRecs, $qc_old_list->TotalRecs, $qc_old_list->AutoHidePager) ?>
<?php if ($qc_old_list->Pager->RecordCount > 0 && $qc_old_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($qc_old_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $qc_old_list->pageUrl() ?>start=<?php echo $qc_old_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($qc_old_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $qc_old_list->pageUrl() ?>start=<?php echo $qc_old_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $qc_old_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($qc_old_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $qc_old_list->pageUrl() ?>start=<?php echo $qc_old_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($qc_old_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $qc_old_list->pageUrl() ?>start=<?php echo $qc_old_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $qc_old_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($qc_old_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $qc_old_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $qc_old_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $qc_old_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($qc_old_list->TotalRecs > 0 && (!$qc_old_list->AutoHidePageSizeSelector || $qc_old_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="qc_old">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($qc_old_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($qc_old_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($qc_old_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($qc_old_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($qc_old_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($qc_old->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $qc_old_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fqc_oldlist" id="fqc_oldlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_old_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_old_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc_old">
<div id="gmp_qc_old" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($qc_old_list->TotalRecs > 0 || $qc_old->isGridEdit()) { ?>
<table id="tbl_qc_oldlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$qc_old_list->RowType = ROWTYPE_HEADER;

// Render list options
$qc_old_list->renderListOptions();

// Render list options (header, left)
$qc_old_list->ListOptions->render("header", "left");
?>
<?php if ($qc_old->id->Visible) { // id ?>
	<?php if ($qc_old->sortUrl($qc_old->id) == "") { ?>
		<th data-name="id" class="<?php echo $qc_old->id->headerCellClass() ?>"><div id="elh_qc_old_id" class="qc_old_id"><div class="ew-table-header-caption"><?php echo $qc_old->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $qc_old->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->id) ?>',2);"><div id="elh_qc_old_id" class="qc_old_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_old->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->location->Visible) { // location ?>
	<?php if ($qc_old->sortUrl($qc_old->location) == "") { ?>
		<th data-name="location" class="<?php echo $qc_old->location->headerCellClass() ?>"><div id="elh_qc_old_location" class="qc_old_location"><div class="ew-table-header-caption"><?php echo $qc_old->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $qc_old->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->location) ?>',2);"><div id="elh_qc_old_location" class="qc_old_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_old->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->_barcode->Visible) { // barcode ?>
	<?php if ($qc_old->sortUrl($qc_old->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $qc_old->_barcode->headerCellClass() ?>"><div id="elh_qc_old__barcode" class="qc_old__barcode"><div class="ew-table-header-caption"><?php echo $qc_old->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $qc_old->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->_barcode) ?>',2);"><div id="elh_qc_old__barcode" class="qc_old__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_old->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->defect_nature->Visible) { // defect_nature ?>
	<?php if ($qc_old->sortUrl($qc_old->defect_nature) == "") { ?>
		<th data-name="defect_nature" class="<?php echo $qc_old->defect_nature->headerCellClass() ?>"><div id="elh_qc_old_defect_nature" class="qc_old_defect_nature"><div class="ew-table-header-caption"><?php echo $qc_old->defect_nature->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="defect_nature" class="<?php echo $qc_old->defect_nature->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->defect_nature) ?>',2);"><div id="elh_qc_old_defect_nature" class="qc_old_defect_nature">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->defect_nature->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_old->defect_nature->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->defect_nature->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->qc_stage->Visible) { // qc_stage ?>
	<?php if ($qc_old->sortUrl($qc_old->qc_stage) == "") { ?>
		<th data-name="qc_stage" class="<?php echo $qc_old->qc_stage->headerCellClass() ?>"><div id="elh_qc_old_qc_stage" class="qc_old_qc_stage"><div class="ew-table-header-caption"><?php echo $qc_old->qc_stage->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qc_stage" class="<?php echo $qc_old->qc_stage->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->qc_stage) ?>',2);"><div id="elh_qc_old_qc_stage" class="qc_old_qc_stage">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->qc_stage->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_old->qc_stage->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->qc_stage->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->defect_percentage->Visible) { // defect_percentage ?>
	<?php if ($qc_old->sortUrl($qc_old->defect_percentage) == "") { ?>
		<th data-name="defect_percentage" class="<?php echo $qc_old->defect_percentage->headerCellClass() ?>"><div id="elh_qc_old_defect_percentage" class="qc_old_defect_percentage"><div class="ew-table-header-caption"><?php echo $qc_old->defect_percentage->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="defect_percentage" class="<?php echo $qc_old->defect_percentage->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->defect_percentage) ?>',2);"><div id="elh_qc_old_defect_percentage" class="qc_old_defect_percentage">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->defect_percentage->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_old->defect_percentage->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->defect_percentage->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->deduction->Visible) { // deduction ?>
	<?php if ($qc_old->sortUrl($qc_old->deduction) == "") { ?>
		<th data-name="deduction" class="<?php echo $qc_old->deduction->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_qc_old_deduction" class="qc_old_deduction"><div class="ew-table-header-caption"><?php echo $qc_old->deduction->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="deduction" class="<?php echo $qc_old->deduction->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->deduction) ?>',2);"><div id="elh_qc_old_deduction" class="qc_old_deduction">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->deduction->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_old->deduction->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->deduction->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->comments->Visible) { // comments ?>
	<?php if ($qc_old->sortUrl($qc_old->comments) == "") { ?>
		<th data-name="comments" class="<?php echo $qc_old->comments->headerCellClass() ?>"><div id="elh_qc_old_comments" class="qc_old_comments"><div class="ew-table-header-caption"><?php echo $qc_old->comments->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="comments" class="<?php echo $qc_old->comments->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->comments) ?>',2);"><div id="elh_qc_old_comments" class="qc_old_comments">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->comments->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_old->comments->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->comments->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->status->Visible) { // status ?>
	<?php if ($qc_old->sortUrl($qc_old->status) == "") { ?>
		<th data-name="status" class="<?php echo $qc_old->status->headerCellClass() ?>"><div id="elh_qc_old_status" class="qc_old_status"><div class="ew-table-header-caption"><?php echo $qc_old->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $qc_old->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->status) ?>',2);"><div id="elh_qc_old_status" class="qc_old_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_old->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->operator->Visible) { // operator ?>
	<?php if ($qc_old->sortUrl($qc_old->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $qc_old->operator->headerCellClass() ?>"><div id="elh_qc_old_operator" class="qc_old_operator"><div class="ew-table-header-caption"><?php echo $qc_old->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $qc_old->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->operator) ?>',2);"><div id="elh_qc_old_operator" class="qc_old_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_old->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->datetime->Visible) { // datetime ?>
	<?php if ($qc_old->sortUrl($qc_old->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $qc_old->datetime->headerCellClass() ?>"><div id="elh_qc_old_datetime" class="qc_old_datetime"><div class="ew-table-header-caption"><?php echo $qc_old->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $qc_old->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->datetime) ?>',2);"><div id="elh_qc_old_datetime" class="qc_old_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_old->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->e_operator->Visible) { // e_operator ?>
	<?php if ($qc_old->sortUrl($qc_old->e_operator) == "") { ?>
		<th data-name="e_operator" class="<?php echo $qc_old->e_operator->headerCellClass() ?>"><div id="elh_qc_old_e_operator" class="qc_old_e_operator"><div class="ew-table-header-caption"><?php echo $qc_old->e_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="e_operator" class="<?php echo $qc_old->e_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->e_operator) ?>',2);"><div id="elh_qc_old_e_operator" class="qc_old_e_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->e_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_old->e_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->e_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->e_datetime->Visible) { // e_datetime ?>
	<?php if ($qc_old->sortUrl($qc_old->e_datetime) == "") { ?>
		<th data-name="e_datetime" class="<?php echo $qc_old->e_datetime->headerCellClass() ?>"><div id="elh_qc_old_e_datetime" class="qc_old_e_datetime"><div class="ew-table-header-caption"><?php echo $qc_old->e_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="e_datetime" class="<?php echo $qc_old->e_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->e_datetime) ?>',2);"><div id="elh_qc_old_e_datetime" class="qc_old_e_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->e_datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_old->e_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->e_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->_action->Visible) { // action ?>
	<?php if ($qc_old->sortUrl($qc_old->_action) == "") { ?>
		<th data-name="_action" class="<?php echo $qc_old->_action->headerCellClass() ?>"><div id="elh_qc_old__action" class="qc_old__action"><div class="ew-table-header-caption"><?php echo $qc_old->_action->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_action" class="<?php echo $qc_old->_action->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->_action) ?>',2);"><div id="elh_qc_old__action" class="qc_old__action">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->_action->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_old->_action->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->_action->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->remarks->Visible) { // remarks ?>
	<?php if ($qc_old->sortUrl($qc_old->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $qc_old->remarks->headerCellClass() ?>"><div id="elh_qc_old_remarks" class="qc_old_remarks"><div class="ew-table-header-caption"><?php echo $qc_old->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $qc_old->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->remarks) ?>',2);"><div id="elh_qc_old_remarks" class="qc_old_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_old->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->a_operator->Visible) { // a_operator ?>
	<?php if ($qc_old->sortUrl($qc_old->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $qc_old->a_operator->headerCellClass() ?>"><div id="elh_qc_old_a_operator" class="qc_old_a_operator"><div class="ew-table-header-caption"><?php echo $qc_old->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $qc_old->a_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->a_operator) ?>',2);"><div id="elh_qc_old_a_operator" class="qc_old_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_old->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->a_datetime->Visible) { // a_datetime ?>
	<?php if ($qc_old->sortUrl($qc_old->a_datetime) == "") { ?>
		<th data-name="a_datetime" class="<?php echo $qc_old->a_datetime->headerCellClass() ?>"><div id="elh_qc_old_a_datetime" class="qc_old_a_datetime"><div class="ew-table-header-caption"><?php echo $qc_old->a_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_datetime" class="<?php echo $qc_old->a_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->a_datetime) ?>',2);"><div id="elh_qc_old_a_datetime" class="qc_old_a_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->a_datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_old->a_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->a_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->design->Visible) { // design ?>
	<?php if ($qc_old->sortUrl($qc_old->design) == "") { ?>
		<th data-name="design" class="<?php echo $qc_old->design->headerCellClass() ?>"><div id="elh_qc_old_design" class="qc_old_design"><div class="ew-table-header-caption"><?php echo $qc_old->design->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design" class="<?php echo $qc_old->design->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->design) ?>',2);"><div id="elh_qc_old_design" class="qc_old_design">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->design->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_old->design->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->design->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->size->Visible) { // size ?>
	<?php if ($qc_old->sortUrl($qc_old->size) == "") { ?>
		<th data-name="size" class="<?php echo $qc_old->size->headerCellClass() ?>"><div id="elh_qc_old_size" class="qc_old_size"><div class="ew-table-header-caption"><?php echo $qc_old->size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size" class="<?php echo $qc_old->size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->size) ?>',2);"><div id="elh_qc_old_size" class="qc_old_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_old->size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->lines_in_30cm->Visible) { // lines_in_30cm ?>
	<?php if ($qc_old->sortUrl($qc_old->lines_in_30cm) == "") { ?>
		<th data-name="lines_in_30cm" class="<?php echo $qc_old->lines_in_30cm->headerCellClass() ?>"><div id="elh_qc_old_lines_in_30cm" class="qc_old_lines_in_30cm"><div class="ew-table-header-caption"><?php echo $qc_old->lines_in_30cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lines_in_30cm" class="<?php echo $qc_old->lines_in_30cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->lines_in_30cm) ?>',2);"><div id="elh_qc_old_lines_in_30cm" class="qc_old_lines_in_30cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->lines_in_30cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_old->lines_in_30cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->lines_in_30cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->size_actual->Visible) { // size_actual ?>
	<?php if ($qc_old->sortUrl($qc_old->size_actual) == "") { ?>
		<th data-name="size_actual" class="<?php echo $qc_old->size_actual->headerCellClass() ?>"><div id="elh_qc_old_size_actual" class="qc_old_size_actual"><div class="ew-table-header-caption"><?php echo $qc_old->size_actual->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_actual" class="<?php echo $qc_old->size_actual->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->size_actual) ?>',2);"><div id="elh_qc_old_size_actual" class="qc_old_size_actual">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->size_actual->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_old->size_actual->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->size_actual->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->weight_actual->Visible) { // weight_actual ?>
	<?php if ($qc_old->sortUrl($qc_old->weight_actual) == "") { ?>
		<th data-name="weight_actual" class="<?php echo $qc_old->weight_actual->headerCellClass() ?>"><div id="elh_qc_old_weight_actual" class="qc_old_weight_actual"><div class="ew-table-header-caption"><?php echo $qc_old->weight_actual->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weight_actual" class="<?php echo $qc_old->weight_actual->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->weight_actual) ?>',2);"><div id="elh_qc_old_weight_actual" class="qc_old_weight_actual">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->weight_actual->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_old->weight_actual->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->weight_actual->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->bcode_status->Visible) { // bcode_status ?>
	<?php if ($qc_old->sortUrl($qc_old->bcode_status) == "") { ?>
		<th data-name="bcode_status" class="<?php echo $qc_old->bcode_status->headerCellClass() ?>"><div id="elh_qc_old_bcode_status" class="qc_old_bcode_status"><div class="ew-table-header-caption"><?php echo $qc_old->bcode_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bcode_status" class="<?php echo $qc_old->bcode_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->bcode_status) ?>',2);"><div id="elh_qc_old_bcode_status" class="qc_old_bcode_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->bcode_status->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc_old->bcode_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->bcode_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc_old->product_image->Visible) { // product_image ?>
	<?php if ($qc_old->sortUrl($qc_old->product_image) == "") { ?>
		<th data-name="product_image" class="<?php echo $qc_old->product_image->headerCellClass() ?>"><div id="elh_qc_old_product_image" class="qc_old_product_image"><div class="ew-table-header-caption"><?php echo $qc_old->product_image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_image" class="<?php echo $qc_old->product_image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc_old->SortUrl($qc_old->product_image) ?>',2);"><div id="elh_qc_old_product_image" class="qc_old_product_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc_old->product_image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc_old->product_image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc_old->product_image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$qc_old_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($qc_old->ExportAll && $qc_old->isExport()) {
	$qc_old_list->StopRec = $qc_old_list->TotalRecs;
} else {

	// Set the last record to display
	if ($qc_old_list->TotalRecs > $qc_old_list->StartRec + $qc_old_list->DisplayRecs - 1)
		$qc_old_list->StopRec = $qc_old_list->StartRec + $qc_old_list->DisplayRecs - 1;
	else
		$qc_old_list->StopRec = $qc_old_list->TotalRecs;
}
$qc_old_list->RecCnt = $qc_old_list->StartRec - 1;
if ($qc_old_list->Recordset && !$qc_old_list->Recordset->EOF) {
	$qc_old_list->Recordset->moveFirst();
	$selectLimit = $qc_old_list->UseSelectLimit;
	if (!$selectLimit && $qc_old_list->StartRec > 1)
		$qc_old_list->Recordset->move($qc_old_list->StartRec - 1);
} elseif (!$qc_old->AllowAddDeleteRow && $qc_old_list->StopRec == 0) {
	$qc_old_list->StopRec = $qc_old->GridAddRowCount;
}

// Initialize aggregate
$qc_old->RowType = ROWTYPE_AGGREGATEINIT;
$qc_old->resetAttributes();
$qc_old_list->renderRow();
while ($qc_old_list->RecCnt < $qc_old_list->StopRec) {
	$qc_old_list->RecCnt++;
	if ($qc_old_list->RecCnt >= $qc_old_list->StartRec) {
		$qc_old_list->RowCnt++;

		// Set up key count
		$qc_old_list->KeyCount = $qc_old_list->RowIndex;

		// Init row class and style
		$qc_old->resetAttributes();
		$qc_old->CssClass = "";
		if ($qc_old->isGridAdd()) {
		} else {
			$qc_old_list->loadRowValues($qc_old_list->Recordset); // Load row values
		}
		$qc_old->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$qc_old->RowAttrs = array_merge($qc_old->RowAttrs, array('data-rowindex'=>$qc_old_list->RowCnt, 'id'=>'r' . $qc_old_list->RowCnt . '_qc_old', 'data-rowtype'=>$qc_old->RowType));

		// Render row
		$qc_old_list->renderRow();

		// Render list options
		$qc_old_list->renderListOptions();
?>
	<tr<?php echo $qc_old->rowAttributes() ?>>
<?php

// Render list options (body, left)
$qc_old_list->ListOptions->render("body", "left", $qc_old_list->RowCnt);
?>
	<?php if ($qc_old->id->Visible) { // id ?>
		<td data-name="id"<?php echo $qc_old->id->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_id" class="qc_old_id">
<span<?php echo $qc_old->id->viewAttributes() ?>>
<?php echo $qc_old->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->location->Visible) { // location ?>
		<td data-name="location"<?php echo $qc_old->location->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_location" class="qc_old_location">
<span<?php echo $qc_old->location->viewAttributes() ?>>
<?php echo $qc_old->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $qc_old->_barcode->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old__barcode" class="qc_old__barcode">
<span<?php echo $qc_old->_barcode->viewAttributes() ?>>
<?php echo $qc_old->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->defect_nature->Visible) { // defect_nature ?>
		<td data-name="defect_nature"<?php echo $qc_old->defect_nature->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_defect_nature" class="qc_old_defect_nature">
<span<?php echo $qc_old->defect_nature->viewAttributes() ?>>
<?php echo $qc_old->defect_nature->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->qc_stage->Visible) { // qc_stage ?>
		<td data-name="qc_stage"<?php echo $qc_old->qc_stage->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_qc_stage" class="qc_old_qc_stage">
<span<?php echo $qc_old->qc_stage->viewAttributes() ?>>
<?php echo $qc_old->qc_stage->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->defect_percentage->Visible) { // defect_percentage ?>
		<td data-name="defect_percentage"<?php echo $qc_old->defect_percentage->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_defect_percentage" class="qc_old_defect_percentage">
<span<?php echo $qc_old->defect_percentage->viewAttributes() ?>>
<?php echo $qc_old->defect_percentage->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->deduction->Visible) { // deduction ?>
		<td data-name="deduction"<?php echo $qc_old->deduction->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_deduction" class="qc_old_deduction">
<span<?php echo $qc_old->deduction->viewAttributes() ?>>
<?php echo $qc_old->deduction->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->comments->Visible) { // comments ?>
		<td data-name="comments"<?php echo $qc_old->comments->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_comments" class="qc_old_comments">
<span<?php echo $qc_old->comments->viewAttributes() ?>>
<?php echo $qc_old->comments->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->status->Visible) { // status ?>
		<td data-name="status"<?php echo $qc_old->status->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_status" class="qc_old_status">
<span<?php echo $qc_old->status->viewAttributes() ?>>
<?php echo $qc_old->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $qc_old->operator->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_operator" class="qc_old_operator">
<span<?php echo $qc_old->operator->viewAttributes() ?>>
<?php echo $qc_old->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $qc_old->datetime->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_datetime" class="qc_old_datetime">
<span<?php echo $qc_old->datetime->viewAttributes() ?>>
<?php echo $qc_old->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->e_operator->Visible) { // e_operator ?>
		<td data-name="e_operator"<?php echo $qc_old->e_operator->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_e_operator" class="qc_old_e_operator">
<span<?php echo $qc_old->e_operator->viewAttributes() ?>>
<?php echo $qc_old->e_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->e_datetime->Visible) { // e_datetime ?>
		<td data-name="e_datetime"<?php echo $qc_old->e_datetime->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_e_datetime" class="qc_old_e_datetime">
<span<?php echo $qc_old->e_datetime->viewAttributes() ?>>
<?php echo $qc_old->e_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->_action->Visible) { // action ?>
		<td data-name="_action"<?php echo $qc_old->_action->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old__action" class="qc_old__action">
<span<?php echo $qc_old->_action->viewAttributes() ?>>
<?php echo $qc_old->_action->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $qc_old->remarks->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_remarks" class="qc_old_remarks">
<span<?php echo $qc_old->remarks->viewAttributes() ?>>
<?php echo $qc_old->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $qc_old->a_operator->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_a_operator" class="qc_old_a_operator">
<span<?php echo $qc_old->a_operator->viewAttributes() ?>>
<?php echo $qc_old->a_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime"<?php echo $qc_old->a_datetime->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_a_datetime" class="qc_old_a_datetime">
<span<?php echo $qc_old->a_datetime->viewAttributes() ?>>
<?php echo $qc_old->a_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->design->Visible) { // design ?>
		<td data-name="design"<?php echo $qc_old->design->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_design" class="qc_old_design">
<span<?php echo $qc_old->design->viewAttributes() ?>>
<?php echo $qc_old->design->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->size->Visible) { // size ?>
		<td data-name="size"<?php echo $qc_old->size->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_size" class="qc_old_size">
<span<?php echo $qc_old->size->viewAttributes() ?>>
<?php echo $qc_old->size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->lines_in_30cm->Visible) { // lines_in_30cm ?>
		<td data-name="lines_in_30cm"<?php echo $qc_old->lines_in_30cm->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_lines_in_30cm" class="qc_old_lines_in_30cm">
<span<?php echo $qc_old->lines_in_30cm->viewAttributes() ?>>
<?php echo $qc_old->lines_in_30cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->size_actual->Visible) { // size_actual ?>
		<td data-name="size_actual"<?php echo $qc_old->size_actual->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_size_actual" class="qc_old_size_actual">
<span<?php echo $qc_old->size_actual->viewAttributes() ?>>
<?php echo $qc_old->size_actual->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->weight_actual->Visible) { // weight_actual ?>
		<td data-name="weight_actual"<?php echo $qc_old->weight_actual->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_weight_actual" class="qc_old_weight_actual">
<span<?php echo $qc_old->weight_actual->viewAttributes() ?>>
<?php echo $qc_old->weight_actual->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->bcode_status->Visible) { // bcode_status ?>
		<td data-name="bcode_status"<?php echo $qc_old->bcode_status->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_bcode_status" class="qc_old_bcode_status">
<span<?php echo $qc_old->bcode_status->viewAttributes() ?>>
<?php echo $qc_old->bcode_status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc_old->product_image->Visible) { // product_image ?>
		<td data-name="product_image"<?php echo $qc_old->product_image->cellAttributes() ?>>
<span id="el<?php echo $qc_old_list->RowCnt ?>_qc_old_product_image" class="qc_old_product_image">
<span<?php echo $qc_old->product_image->viewAttributes() ?>>
<?php echo $qc_old->product_image->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$qc_old_list->ListOptions->render("body", "right", $qc_old_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$qc_old->isGridAdd())
		$qc_old_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$qc_old->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($qc_old_list->Recordset)
	$qc_old_list->Recordset->Close();
?>
<?php if (!$qc_old->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$qc_old->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($qc_old_list->Pager)) $qc_old_list->Pager = new PrevNextPager($qc_old_list->StartRec, $qc_old_list->DisplayRecs, $qc_old_list->TotalRecs, $qc_old_list->AutoHidePager) ?>
<?php if ($qc_old_list->Pager->RecordCount > 0 && $qc_old_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($qc_old_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $qc_old_list->pageUrl() ?>start=<?php echo $qc_old_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($qc_old_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $qc_old_list->pageUrl() ?>start=<?php echo $qc_old_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $qc_old_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($qc_old_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $qc_old_list->pageUrl() ?>start=<?php echo $qc_old_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($qc_old_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $qc_old_list->pageUrl() ?>start=<?php echo $qc_old_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $qc_old_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($qc_old_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $qc_old_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $qc_old_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $qc_old_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($qc_old_list->TotalRecs > 0 && (!$qc_old_list->AutoHidePageSizeSelector || $qc_old_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="qc_old">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($qc_old_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($qc_old_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($qc_old_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($qc_old_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($qc_old_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($qc_old->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $qc_old_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($qc_old_list->TotalRecs == 0 && !$qc_old->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $qc_old_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$qc_old_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$qc_old->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$qc_old->isExport()) { ?>
<script>
ew.scrollableTable("gmp_qc_old", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$qc_old_list->terminate();
?>