<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_old_search = new qc_old_search();

// Run the page
$qc_old_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_old_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($qc_old_search->IsModal) { ?>
var fqc_oldsearch = currentAdvancedSearchForm = new ew.Form("fqc_oldsearch", "search");
<?php } else { ?>
var fqc_oldsearch = currentForm = new ew.Form("fqc_oldsearch", "search");
<?php } ?>

// Form_CustomValidate event
fqc_oldsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqc_oldsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqc_oldsearch.lists["x_location"] = <?php echo $qc_old_search->location->Lookup->toClientList() ?>;
fqc_oldsearch.lists["x_location"].options = <?php echo JsonEncode($qc_old_search->location->lookupOptions()) ?>;
fqc_oldsearch.lists["x_defect_nature"] = <?php echo $qc_old_search->defect_nature->Lookup->toClientList() ?>;
fqc_oldsearch.lists["x_defect_nature"].options = <?php echo JsonEncode($qc_old_search->defect_nature->lookupOptions()) ?>;
fqc_oldsearch.lists["x_qc_stage"] = <?php echo $qc_old_search->qc_stage->Lookup->toClientList() ?>;
fqc_oldsearch.lists["x_qc_stage"].options = <?php echo JsonEncode($qc_old_search->qc_stage->lookupOptions()) ?>;
fqc_oldsearch.lists["x_defect_percentage"] = <?php echo $qc_old_search->defect_percentage->Lookup->toClientList() ?>;
fqc_oldsearch.lists["x_defect_percentage"].options = <?php echo JsonEncode($qc_old_search->defect_percentage->lookupOptions()) ?>;
fqc_oldsearch.lists["x_status"] = <?php echo $qc_old_search->status->Lookup->toClientList() ?>;
fqc_oldsearch.lists["x_status"].options = <?php echo JsonEncode($qc_old_search->status->lookupOptions()) ?>;
fqc_oldsearch.lists["x_operator"] = <?php echo $qc_old_search->operator->Lookup->toClientList() ?>;
fqc_oldsearch.lists["x_operator"].options = <?php echo JsonEncode($qc_old_search->operator->lookupOptions()) ?>;
fqc_oldsearch.lists["x_e_operator"] = <?php echo $qc_old_search->e_operator->Lookup->toClientList() ?>;
fqc_oldsearch.lists["x_e_operator"].options = <?php echo JsonEncode($qc_old_search->e_operator->lookupOptions()) ?>;
fqc_oldsearch.lists["x_a_operator"] = <?php echo $qc_old_search->a_operator->Lookup->toClientList() ?>;
fqc_oldsearch.lists["x_a_operator"].options = <?php echo JsonEncode($qc_old_search->a_operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fqc_oldsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_old->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_old->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_deduction");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_old->deduction->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_old->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_e_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_old->e_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__action");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_old->_action->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_a_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_old->a_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_lines_in_30cm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_old->lines_in_30cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_weight_actual");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_old->weight_actual->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_bcode_status");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc_old->bcode_status->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $qc_old_search->showPageHeader(); ?>
<?php
$qc_old_search->showMessage();
?>
<form name="fqc_oldsearch" id="fqc_oldsearch" class="<?php echo $qc_old_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_old_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_old_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc_old">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$qc_old_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($qc_old->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_id"><?php echo $qc_old->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->id->cellAttributes() ?>>
			<span id="el_qc_old_id">
<input type="text" data-table="qc_old" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($qc_old->id->getPlaceHolder()) ?>" value="<?php echo $qc_old->id->EditValue ?>"<?php echo $qc_old->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_location"><?php echo $qc_old->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->location->cellAttributes() ?>>
			<span id="el_qc_old_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_old" data-field="x_location" data-value-separator="<?php echo $qc_old->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $qc_old->location->editAttributes() ?>>
		<?php echo $qc_old->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $qc_old->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old__barcode"><?php echo $qc_old->_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__barcode" id="z__barcode" value="="></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->_barcode->cellAttributes() ?>>
			<span id="el_qc_old__barcode">
<input type="text" data-table="qc_old" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($qc_old->_barcode->getPlaceHolder()) ?>" value="<?php echo $qc_old->_barcode->EditValue ?>"<?php echo $qc_old->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->defect_nature->Visible) { // defect_nature ?>
	<div id="r_defect_nature" class="form-group row">
		<label for="x_defect_nature" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_defect_nature"><?php echo $qc_old->defect_nature->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_defect_nature" id="z_defect_nature" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->defect_nature->cellAttributes() ?>>
			<span id="el_qc_old_defect_nature">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_old" data-field="x_defect_nature" data-value-separator="<?php echo $qc_old->defect_nature->displayValueSeparatorAttribute() ?>" id="x_defect_nature" name="x_defect_nature"<?php echo $qc_old->defect_nature->editAttributes() ?>>
		<?php echo $qc_old->defect_nature->selectOptionListHtml("x_defect_nature") ?>
	</select>
</div>
<?php echo $qc_old->defect_nature->Lookup->getParamTag("p_x_defect_nature") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->qc_stage->Visible) { // qc_stage ?>
	<div id="r_qc_stage" class="form-group row">
		<label for="x_qc_stage" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_qc_stage"><?php echo $qc_old->qc_stage->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qc_stage" id="z_qc_stage" value="="></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->qc_stage->cellAttributes() ?>>
			<span id="el_qc_old_qc_stage">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_old" data-field="x_qc_stage" data-value-separator="<?php echo $qc_old->qc_stage->displayValueSeparatorAttribute() ?>" id="x_qc_stage" name="x_qc_stage"<?php echo $qc_old->qc_stage->editAttributes() ?>>
		<?php echo $qc_old->qc_stage->selectOptionListHtml("x_qc_stage") ?>
	</select>
</div>
<?php echo $qc_old->qc_stage->Lookup->getParamTag("p_x_qc_stage") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->defect_percentage->Visible) { // defect_percentage ?>
	<div id="r_defect_percentage" class="form-group row">
		<label for="x_defect_percentage" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_defect_percentage"><?php echo $qc_old->defect_percentage->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_defect_percentage" id="z_defect_percentage" value="="></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->defect_percentage->cellAttributes() ?>>
			<span id="el_qc_old_defect_percentage">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_old" data-field="x_defect_percentage" data-value-separator="<?php echo $qc_old->defect_percentage->displayValueSeparatorAttribute() ?>" id="x_defect_percentage" name="x_defect_percentage"<?php echo $qc_old->defect_percentage->editAttributes() ?>>
		<?php echo $qc_old->defect_percentage->selectOptionListHtml("x_defect_percentage") ?>
	</select>
</div>
<?php echo $qc_old->defect_percentage->Lookup->getParamTag("p_x_defect_percentage") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->deduction->Visible) { // deduction ?>
	<div id="r_deduction" class="form-group row">
		<label for="x_deduction" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_deduction"><?php echo $qc_old->deduction->caption() ?></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->deduction->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_deduction" id="z_deduction" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($qc_old->deduction->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_qc_old_deduction">
<input type="text" data-table="qc_old" data-field="x_deduction" name="x_deduction" id="x_deduction" size="30" placeholder="<?php echo HtmlEncode($qc_old->deduction->getPlaceHolder()) ?>" value="<?php echo $qc_old->deduction->EditValue ?>"<?php echo $qc_old->deduction->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_deduction d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_qc_old_deduction" class="btw1_deduction d-none">
<input type="text" data-table="qc_old" data-field="x_deduction" name="y_deduction" id="y_deduction" size="30" placeholder="<?php echo HtmlEncode($qc_old->deduction->getPlaceHolder()) ?>" value="<?php echo $qc_old->deduction->EditValue2 ?>"<?php echo $qc_old->deduction->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->comments->Visible) { // comments ?>
	<div id="r_comments" class="form-group row">
		<label for="x_comments" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_comments"><?php echo $qc_old->comments->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_comments" id="z_comments" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->comments->cellAttributes() ?>>
			<span id="el_qc_old_comments">
<input type="text" data-table="qc_old" data-field="x_comments" name="x_comments" id="x_comments" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($qc_old->comments->getPlaceHolder()) ?>" value="<?php echo $qc_old->comments->EditValue ?>"<?php echo $qc_old->comments->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_status"><?php echo $qc_old->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->status->cellAttributes() ?>>
			<span id="el_qc_old_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_old" data-field="x_status" data-value-separator="<?php echo $qc_old->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $qc_old->status->editAttributes() ?>>
		<?php echo $qc_old->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $qc_old->status->Lookup->getParamTag("p_x_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_operator"><?php echo $qc_old->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->operator->cellAttributes() ?>>
			<span id="el_qc_old_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_old" data-field="x_operator" data-value-separator="<?php echo $qc_old->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $qc_old->operator->editAttributes() ?>>
		<?php echo $qc_old->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $qc_old->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_datetime"><?php echo $qc_old->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_old->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_old->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_old->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_old->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_old->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_old->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($qc_old->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_qc_old_datetime">
<input type="text" data-table="qc_old" data-field="x_datetime" data-format="117" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($qc_old->datetime->getPlaceHolder()) ?>" value="<?php echo $qc_old->datetime->EditValue ?>"<?php echo $qc_old->datetime->editAttributes() ?>>
<?php if (!$qc_old->datetime->ReadOnly && !$qc_old->datetime->Disabled && !isset($qc_old->datetime->EditAttrs["readonly"]) && !isset($qc_old->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fqc_oldsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_qc_old_datetime" class="btw1_datetime d-none">
<input type="text" data-table="qc_old" data-field="x_datetime" data-format="117" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($qc_old->datetime->getPlaceHolder()) ?>" value="<?php echo $qc_old->datetime->EditValue2 ?>"<?php echo $qc_old->datetime->editAttributes() ?>>
<?php if (!$qc_old->datetime->ReadOnly && !$qc_old->datetime->Disabled && !isset($qc_old->datetime->EditAttrs["readonly"]) && !isset($qc_old->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fqc_oldsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->e_operator->Visible) { // e_operator ?>
	<div id="r_e_operator" class="form-group row">
		<label for="x_e_operator" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_e_operator"><?php echo $qc_old->e_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_e_operator" id="z_e_operator" value="="></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->e_operator->cellAttributes() ?>>
			<span id="el_qc_old_e_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_old" data-field="x_e_operator" data-value-separator="<?php echo $qc_old->e_operator->displayValueSeparatorAttribute() ?>" id="x_e_operator" name="x_e_operator"<?php echo $qc_old->e_operator->editAttributes() ?>>
		<?php echo $qc_old->e_operator->selectOptionListHtml("x_e_operator") ?>
	</select>
</div>
<?php echo $qc_old->e_operator->Lookup->getParamTag("p_x_e_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->e_datetime->Visible) { // e_datetime ?>
	<div id="r_e_datetime" class="form-group row">
		<label for="x_e_datetime" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_e_datetime"><?php echo $qc_old->e_datetime->caption() ?></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->e_datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_e_datetime" id="z_e_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_old->e_datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_old->e_datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_old->e_datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_old->e_datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_old->e_datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_old->e_datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($qc_old->e_datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($qc_old->e_datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($qc_old->e_datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_qc_old_e_datetime">
<input type="text" data-table="qc_old" data-field="x_e_datetime" data-format="117" name="x_e_datetime" id="x_e_datetime" placeholder="<?php echo HtmlEncode($qc_old->e_datetime->getPlaceHolder()) ?>" value="<?php echo $qc_old->e_datetime->EditValue ?>"<?php echo $qc_old->e_datetime->editAttributes() ?>>
<?php if (!$qc_old->e_datetime->ReadOnly && !$qc_old->e_datetime->Disabled && !isset($qc_old->e_datetime->EditAttrs["readonly"]) && !isset($qc_old->e_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fqc_oldsearch", "x_e_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_e_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_qc_old_e_datetime" class="btw1_e_datetime d-none">
<input type="text" data-table="qc_old" data-field="x_e_datetime" data-format="117" name="y_e_datetime" id="y_e_datetime" placeholder="<?php echo HtmlEncode($qc_old->e_datetime->getPlaceHolder()) ?>" value="<?php echo $qc_old->e_datetime->EditValue2 ?>"<?php echo $qc_old->e_datetime->editAttributes() ?>>
<?php if (!$qc_old->e_datetime->ReadOnly && !$qc_old->e_datetime->Disabled && !isset($qc_old->e_datetime->EditAttrs["readonly"]) && !isset($qc_old->e_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fqc_oldsearch", "y_e_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->_action->Visible) { // action ?>
	<div id="r__action" class="form-group row">
		<label for="x__action" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old__action"><?php echo $qc_old->_action->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__action" id="z__action" value="="></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->_action->cellAttributes() ?>>
			<span id="el_qc_old__action">
<input type="text" data-table="qc_old" data-field="x__action" name="x__action" id="x__action" size="30" placeholder="<?php echo HtmlEncode($qc_old->_action->getPlaceHolder()) ?>" value="<?php echo $qc_old->_action->EditValue ?>"<?php echo $qc_old->_action->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_remarks"><?php echo $qc_old->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->remarks->cellAttributes() ?>>
			<span id="el_qc_old_remarks">
<input type="text" data-table="qc_old" data-field="x_remarks" name="x_remarks" id="x_remarks" maxlength="96" placeholder="<?php echo HtmlEncode($qc_old->remarks->getPlaceHolder()) ?>" value="<?php echo $qc_old->remarks->EditValue ?>"<?php echo $qc_old->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->a_operator->Visible) { // a_operator ?>
	<div id="r_a_operator" class="form-group row">
		<label for="x_a_operator" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_a_operator"><?php echo $qc_old->a_operator->caption() ?></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->a_operator->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_a_operator" id="z_a_operator" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc_old->a_operator->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc_old->a_operator->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc_old->a_operator->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc_old->a_operator->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc_old->a_operator->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc_old->a_operator->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($qc_old->a_operator->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($qc_old->a_operator->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($qc_old->a_operator->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_qc_old_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_old" data-field="x_a_operator" data-value-separator="<?php echo $qc_old->a_operator->displayValueSeparatorAttribute() ?>" id="x_a_operator" name="x_a_operator"<?php echo $qc_old->a_operator->editAttributes() ?>>
		<?php echo $qc_old->a_operator->selectOptionListHtml("x_a_operator") ?>
	</select>
</div>
<?php echo $qc_old->a_operator->Lookup->getParamTag("p_x_a_operator") ?>
</span>
			<span class="ew-search-cond btw1_a_operator d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_qc_old_a_operator" class="btw1_a_operator d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc_old" data-field="x_a_operator" data-value-separator="<?php echo $qc_old->a_operator->displayValueSeparatorAttribute() ?>" id="y_a_operator" name="y_a_operator"<?php echo $qc_old->a_operator->editAttributes() ?>>
		<?php echo $qc_old->a_operator->selectOptionListHtml("y_a_operator") ?>
	</select>
</div>
<?php echo $qc_old->a_operator->Lookup->getParamTag("p_y_a_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->a_datetime->Visible) { // a_datetime ?>
	<div id="r_a_datetime" class="form-group row">
		<label for="x_a_datetime" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_a_datetime"><?php echo $qc_old->a_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_datetime" id="z_a_datetime" value="="></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->a_datetime->cellAttributes() ?>>
			<span id="el_qc_old_a_datetime">
<input type="text" data-table="qc_old" data-field="x_a_datetime" data-format="117" name="x_a_datetime" id="x_a_datetime" placeholder="<?php echo HtmlEncode($qc_old->a_datetime->getPlaceHolder()) ?>" value="<?php echo $qc_old->a_datetime->EditValue ?>"<?php echo $qc_old->a_datetime->editAttributes() ?>>
<?php if (!$qc_old->a_datetime->ReadOnly && !$qc_old->a_datetime->Disabled && !isset($qc_old->a_datetime->EditAttrs["readonly"]) && !isset($qc_old->a_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fqc_oldsearch", "x_a_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->design->Visible) { // design ?>
	<div id="r_design" class="form-group row">
		<label for="x_design" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_design"><?php echo $qc_old->design->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design" id="z_design" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->design->cellAttributes() ?>>
			<span id="el_qc_old_design">
<input type="text" data-table="qc_old" data-field="x_design" name="x_design" id="x_design" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($qc_old->design->getPlaceHolder()) ?>" value="<?php echo $qc_old->design->EditValue ?>"<?php echo $qc_old->design->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->size->Visible) { // size ?>
	<div id="r_size" class="form-group row">
		<label for="x_size" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_size"><?php echo $qc_old->size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size" id="z_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->size->cellAttributes() ?>>
			<span id="el_qc_old_size">
<input type="text" data-table="qc_old" data-field="x_size" name="x_size" id="x_size" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($qc_old->size->getPlaceHolder()) ?>" value="<?php echo $qc_old->size->EditValue ?>"<?php echo $qc_old->size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->lines_in_30cm->Visible) { // lines_in_30cm ?>
	<div id="r_lines_in_30cm" class="form-group row">
		<label for="x_lines_in_30cm" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_lines_in_30cm"><?php echo $qc_old->lines_in_30cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lines_in_30cm" id="z_lines_in_30cm" value="="></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->lines_in_30cm->cellAttributes() ?>>
			<span id="el_qc_old_lines_in_30cm">
<input type="text" data-table="qc_old" data-field="x_lines_in_30cm" name="x_lines_in_30cm" id="x_lines_in_30cm" size="30" placeholder="<?php echo HtmlEncode($qc_old->lines_in_30cm->getPlaceHolder()) ?>" value="<?php echo $qc_old->lines_in_30cm->EditValue ?>"<?php echo $qc_old->lines_in_30cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->size_actual->Visible) { // size_actual ?>
	<div id="r_size_actual" class="form-group row">
		<label for="x_size_actual" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_size_actual"><?php echo $qc_old->size_actual->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_actual" id="z_size_actual" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->size_actual->cellAttributes() ?>>
			<span id="el_qc_old_size_actual">
<input type="text" data-table="qc_old" data-field="x_size_actual" name="x_size_actual" id="x_size_actual" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($qc_old->size_actual->getPlaceHolder()) ?>" value="<?php echo $qc_old->size_actual->EditValue ?>"<?php echo $qc_old->size_actual->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->weight_actual->Visible) { // weight_actual ?>
	<div id="r_weight_actual" class="form-group row">
		<label for="x_weight_actual" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_weight_actual"><?php echo $qc_old->weight_actual->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weight_actual" id="z_weight_actual" value="="></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->weight_actual->cellAttributes() ?>>
			<span id="el_qc_old_weight_actual">
<input type="text" data-table="qc_old" data-field="x_weight_actual" name="x_weight_actual" id="x_weight_actual" size="30" placeholder="<?php echo HtmlEncode($qc_old->weight_actual->getPlaceHolder()) ?>" value="<?php echo $qc_old->weight_actual->EditValue ?>"<?php echo $qc_old->weight_actual->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->bcode_status->Visible) { // bcode_status ?>
	<div id="r_bcode_status" class="form-group row">
		<label for="x_bcode_status" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_bcode_status"><?php echo $qc_old->bcode_status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_bcode_status" id="z_bcode_status" value="="></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->bcode_status->cellAttributes() ?>>
			<span id="el_qc_old_bcode_status">
<input type="text" data-table="qc_old" data-field="x_bcode_status" name="x_bcode_status" id="x_bcode_status" size="30" placeholder="<?php echo HtmlEncode($qc_old->bcode_status->getPlaceHolder()) ?>" value="<?php echo $qc_old->bcode_status->EditValue ?>"<?php echo $qc_old->bcode_status->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc_old->product_image->Visible) { // product_image ?>
	<div id="r_product_image" class="form-group row">
		<label for="x_product_image" class="<?php echo $qc_old_search->LeftColumnClass ?>"><span id="elh_qc_old_product_image"><?php echo $qc_old->product_image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_image" id="z_product_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_old_search->RightColumnClass ?>"><div<?php echo $qc_old->product_image->cellAttributes() ?>>
			<span id="el_qc_old_product_image">
<input type="text" data-table="qc_old" data-field="x_product_image" name="x_product_image" id="x_product_image" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($qc_old->product_image->getPlaceHolder()) ?>" value="<?php echo $qc_old->product_image->EditValue ?>"<?php echo $qc_old->product_image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$qc_old_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $qc_old_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$qc_old_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$qc_old_search->terminate();
?>