<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_edit = new qc_edit();

// Run the page
$qc_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fqcedit = currentForm = new ew.Form("fqcedit", "edit");

// Validate form
fqcedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($qc_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc->id->caption(), $qc->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_edit->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc->location->caption(), $qc->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_edit->qc_stage->Required) { ?>
			elm = this.getElements("x" + infix + "_qc_stage");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc->qc_stage->caption(), $qc->qc_stage->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_edit->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc->_barcode->caption(), $qc->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_edit->lines_in_30cm->Required) { ?>
			elm = this.getElements("x" + infix + "_lines_in_30cm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc->lines_in_30cm->caption(), $qc->lines_in_30cm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_lines_in_30cm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($qc->lines_in_30cm->errorMessage()) ?>");
		<?php if ($qc_edit->size_actual->Required) { ?>
			elm = this.getElements("x" + infix + "_size_actual");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc->size_actual->caption(), $qc->size_actual->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_edit->weight_actual->Required) { ?>
			elm = this.getElements("x" + infix + "_weight_actual");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc->weight_actual->caption(), $qc->weight_actual->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_weight_actual");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($qc->weight_actual->errorMessage()) ?>");
		<?php if ($qc_edit->defect_nature->Required) { ?>
			elm = this.getElements("x" + infix + "_defect_nature");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc->defect_nature->caption(), $qc->defect_nature->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_edit->defect_percentage->Required) { ?>
			elm = this.getElements("x" + infix + "_defect_percentage");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc->defect_percentage->caption(), $qc->defect_percentage->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_edit->deduction->Required) { ?>
			elm = this.getElements("x" + infix + "_deduction");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc->deduction->caption(), $qc->deduction->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_edit->comments->Required) { ?>
			elm = this.getElements("x" + infix + "_comments");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc->comments->caption(), $qc->comments->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_edit->e_operator->Required) { ?>
			elm = this.getElements("x" + infix + "_e_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc->e_operator->caption(), $qc->e_operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_edit->e_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_e_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc->e_datetime->caption(), $qc->e_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qc_edit->bcode_status->Required) { ?>
			elm = this.getElements("x" + infix + "_bcode_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc->bcode_status->caption(), $qc->bcode_status->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_bcode_status");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($qc->bcode_status->errorMessage()) ?>");
		<?php if ($qc_edit->product_image->Required) { ?>
			elm = this.getElements("x" + infix + "_product_image");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qc->product_image->caption(), $qc->product_image->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fqcedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqcedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqcedit.lists["x_location"] = <?php echo $qc_edit->location->Lookup->toClientList() ?>;
fqcedit.lists["x_location"].options = <?php echo JsonEncode($qc_edit->location->lookupOptions()) ?>;
fqcedit.lists["x_qc_stage"] = <?php echo $qc_edit->qc_stage->Lookup->toClientList() ?>;
fqcedit.lists["x_qc_stage"].options = <?php echo JsonEncode($qc_edit->qc_stage->lookupOptions()) ?>;
fqcedit.lists["x_defect_nature"] = <?php echo $qc_edit->defect_nature->Lookup->toClientList() ?>;
fqcedit.lists["x_defect_nature"].options = <?php echo JsonEncode($qc_edit->defect_nature->lookupOptions()) ?>;
fqcedit.lists["x_defect_percentage"] = <?php echo $qc_edit->defect_percentage->Lookup->toClientList() ?>;
fqcedit.lists["x_defect_percentage"].options = <?php echo JsonEncode($qc_edit->defect_percentage->lookupOptions()) ?>;
fqcedit.lists["x_e_operator"] = <?php echo $qc_edit->e_operator->Lookup->toClientList() ?>;
fqcedit.lists["x_e_operator"].options = <?php echo JsonEncode($qc_edit->e_operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $qc_edit->showPageHeader(); ?>
<?php
$qc_edit->showMessage();
?>
<form name="fqcedit" id="fqcedit" class="<?php echo $qc_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$qc_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($qc->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_qc_id" class="<?php echo $qc_edit->LeftColumnClass ?>"><?php echo $qc->id->caption() ?><?php echo ($qc->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_edit->RightColumnClass ?>"><div<?php echo $qc->id->cellAttributes() ?>>
<span id="el_qc_id">
<span<?php echo $qc->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($qc->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="qc" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($qc->id->CurrentValue) ?>">
<?php echo $qc->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_qc_location" for="x_location" class="<?php echo $qc_edit->LeftColumnClass ?>"><?php echo $qc->location->caption() ?><?php echo ($qc->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_edit->RightColumnClass ?>"><div<?php echo $qc->location->cellAttributes() ?>>
<span id="el_qc_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc" data-field="x_location" data-value-separator="<?php echo $qc->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $qc->location->editAttributes() ?>>
		<?php echo $qc->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $qc->location->Lookup->getParamTag("p_x_location") ?>
</span>
<?php echo $qc->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc->qc_stage->Visible) { // qc_stage ?>
	<div id="r_qc_stage" class="form-group row">
		<label id="elh_qc_qc_stage" for="x_qc_stage" class="<?php echo $qc_edit->LeftColumnClass ?>"><?php echo $qc->qc_stage->caption() ?><?php echo ($qc->qc_stage->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_edit->RightColumnClass ?>"><div<?php echo $qc->qc_stage->cellAttributes() ?>>
<span id="el_qc_qc_stage">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc" data-field="x_qc_stage" data-value-separator="<?php echo $qc->qc_stage->displayValueSeparatorAttribute() ?>" id="x_qc_stage" name="x_qc_stage"<?php echo $qc->qc_stage->editAttributes() ?>>
		<?php echo $qc->qc_stage->selectOptionListHtml("x_qc_stage") ?>
	</select>
</div>
<?php echo $qc->qc_stage->Lookup->getParamTag("p_x_qc_stage") ?>
</span>
<?php echo $qc->qc_stage->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_qc__barcode" for="x__barcode" class="<?php echo $qc_edit->LeftColumnClass ?>"><?php echo $qc->_barcode->caption() ?><?php echo ($qc->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_edit->RightColumnClass ?>"><div<?php echo $qc->_barcode->cellAttributes() ?>>
<span id="el_qc__barcode">
<span<?php echo $qc->_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($qc->_barcode->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="qc" data-field="x__barcode" name="x__barcode" id="x__barcode" value="<?php echo HtmlEncode($qc->_barcode->CurrentValue) ?>">
<?php echo $qc->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc->lines_in_30cm->Visible) { // lines_in_30cm ?>
	<div id="r_lines_in_30cm" class="form-group row">
		<label id="elh_qc_lines_in_30cm" for="x_lines_in_30cm" class="<?php echo $qc_edit->LeftColumnClass ?>"><?php echo $qc->lines_in_30cm->caption() ?><?php echo ($qc->lines_in_30cm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_edit->RightColumnClass ?>"><div<?php echo $qc->lines_in_30cm->cellAttributes() ?>>
<span id="el_qc_lines_in_30cm">
<input type="text" data-table="qc" data-field="x_lines_in_30cm" name="x_lines_in_30cm" id="x_lines_in_30cm" size="30" placeholder="<?php echo HtmlEncode($qc->lines_in_30cm->getPlaceHolder()) ?>" value="<?php echo $qc->lines_in_30cm->EditValue ?>"<?php echo $qc->lines_in_30cm->editAttributes() ?>>
</span>
<?php echo $qc->lines_in_30cm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc->size_actual->Visible) { // size_actual ?>
	<div id="r_size_actual" class="form-group row">
		<label id="elh_qc_size_actual" for="x_size_actual" class="<?php echo $qc_edit->LeftColumnClass ?>"><?php echo $qc->size_actual->caption() ?><?php echo ($qc->size_actual->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_edit->RightColumnClass ?>"><div<?php echo $qc->size_actual->cellAttributes() ?>>
<span id="el_qc_size_actual">
<input type="text" data-table="qc" data-field="x_size_actual" name="x_size_actual" id="x_size_actual" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($qc->size_actual->getPlaceHolder()) ?>" value="<?php echo $qc->size_actual->EditValue ?>"<?php echo $qc->size_actual->editAttributes() ?>>
</span>
<?php echo $qc->size_actual->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc->weight_actual->Visible) { // weight_actual ?>
	<div id="r_weight_actual" class="form-group row">
		<label id="elh_qc_weight_actual" for="x_weight_actual" class="<?php echo $qc_edit->LeftColumnClass ?>"><?php echo $qc->weight_actual->caption() ?><?php echo ($qc->weight_actual->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_edit->RightColumnClass ?>"><div<?php echo $qc->weight_actual->cellAttributes() ?>>
<span id="el_qc_weight_actual">
<input type="text" data-table="qc" data-field="x_weight_actual" name="x_weight_actual" id="x_weight_actual" size="30" placeholder="<?php echo HtmlEncode($qc->weight_actual->getPlaceHolder()) ?>" value="<?php echo $qc->weight_actual->EditValue ?>"<?php echo $qc->weight_actual->editAttributes() ?>>
</span>
<?php echo $qc->weight_actual->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc->defect_nature->Visible) { // defect_nature ?>
	<div id="r_defect_nature" class="form-group row">
		<label id="elh_qc_defect_nature" for="x_defect_nature" class="<?php echo $qc_edit->LeftColumnClass ?>"><?php echo $qc->defect_nature->caption() ?><?php echo ($qc->defect_nature->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_edit->RightColumnClass ?>"><div<?php echo $qc->defect_nature->cellAttributes() ?>>
<span id="el_qc_defect_nature">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc" data-field="x_defect_nature" data-value-separator="<?php echo $qc->defect_nature->displayValueSeparatorAttribute() ?>" id="x_defect_nature" name="x_defect_nature"<?php echo $qc->defect_nature->editAttributes() ?>>
		<?php echo $qc->defect_nature->selectOptionListHtml("x_defect_nature") ?>
	</select>
</div>
<?php echo $qc->defect_nature->Lookup->getParamTag("p_x_defect_nature") ?>
</span>
<?php echo $qc->defect_nature->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc->defect_percentage->Visible) { // defect_percentage ?>
	<div id="r_defect_percentage" class="form-group row">
		<label id="elh_qc_defect_percentage" for="x_defect_percentage" class="<?php echo $qc_edit->LeftColumnClass ?>"><?php echo $qc->defect_percentage->caption() ?><?php echo ($qc->defect_percentage->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_edit->RightColumnClass ?>"><div<?php echo $qc->defect_percentage->cellAttributes() ?>>
<span id="el_qc_defect_percentage">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc" data-field="x_defect_percentage" data-value-separator="<?php echo $qc->defect_percentage->displayValueSeparatorAttribute() ?>" id="x_defect_percentage" name="x_defect_percentage"<?php echo $qc->defect_percentage->editAttributes() ?>>
		<?php echo $qc->defect_percentage->selectOptionListHtml("x_defect_percentage") ?>
	</select>
</div>
<?php echo $qc->defect_percentage->Lookup->getParamTag("p_x_defect_percentage") ?>
</span>
<?php echo $qc->defect_percentage->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc->deduction->Visible) { // deduction ?>
	<div id="r_deduction" class="form-group row">
		<label id="elh_qc_deduction" for="x_deduction" class="<?php echo $qc_edit->LeftColumnClass ?>"><?php echo $qc->deduction->caption() ?><?php echo ($qc->deduction->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_edit->RightColumnClass ?>"><div<?php echo $qc->deduction->cellAttributes() ?>>
<span id="el_qc_deduction">
<span<?php echo $qc->deduction->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($qc->deduction->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="qc" data-field="x_deduction" name="x_deduction" id="x_deduction" value="<?php echo HtmlEncode($qc->deduction->CurrentValue) ?>">
<?php echo $qc->deduction->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc->comments->Visible) { // comments ?>
	<div id="r_comments" class="form-group row">
		<label id="elh_qc_comments" for="x_comments" class="<?php echo $qc_edit->LeftColumnClass ?>"><?php echo $qc->comments->caption() ?><?php echo ($qc->comments->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_edit->RightColumnClass ?>"><div<?php echo $qc->comments->cellAttributes() ?>>
<span id="el_qc_comments">
<input type="text" data-table="qc" data-field="x_comments" name="x_comments" id="x_comments" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($qc->comments->getPlaceHolder()) ?>" value="<?php echo $qc->comments->EditValue ?>"<?php echo $qc->comments->editAttributes() ?>>
</span>
<?php echo $qc->comments->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc->bcode_status->Visible) { // bcode_status ?>
	<div id="r_bcode_status" class="form-group row">
		<label id="elh_qc_bcode_status" for="x_bcode_status" class="<?php echo $qc_edit->LeftColumnClass ?>"><?php echo $qc->bcode_status->caption() ?><?php echo ($qc->bcode_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_edit->RightColumnClass ?>"><div<?php echo $qc->bcode_status->cellAttributes() ?>>
<span id="el_qc_bcode_status">
<input type="text" data-table="qc" data-field="x_bcode_status" name="x_bcode_status" id="x_bcode_status" size="30" placeholder="<?php echo HtmlEncode($qc->bcode_status->getPlaceHolder()) ?>" value="<?php echo $qc->bcode_status->EditValue ?>"<?php echo $qc->bcode_status->editAttributes() ?>>
</span>
<?php echo $qc->bcode_status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qc->product_image->Visible) { // product_image ?>
	<div id="r_product_image" class="form-group row">
		<label id="elh_qc_product_image" for="x_product_image" class="<?php echo $qc_edit->LeftColumnClass ?>"><?php echo $qc->product_image->caption() ?><?php echo ($qc->product_image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qc_edit->RightColumnClass ?>"><div<?php echo $qc->product_image->cellAttributes() ?>>
<span id="el_qc_product_image">
<input type="text" data-table="qc" data-field="x_product_image" name="x_product_image" id="x_product_image" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($qc->product_image->getPlaceHolder()) ?>" value="<?php echo $qc->product_image->EditValue ?>"<?php echo $qc->product_image->editAttributes() ?>>
</span>
<?php echo $qc->product_image->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$qc_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $qc_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $qc_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$qc_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var defect_nature = $("#x_defect_nature").val();
		if (defect_nature == 30)
		{
		$("#x_defect_percentage").val('');
		$("#x_deduction").val('');
		$("#x_comments").val('');
		$("#x_status").val('');
		$("#r_defect_percentage").hide();
		$("#r_comments").hide();
		$("#r_status").hide();
		$("#r_deduction").hide();
		}
		else if (defect_nature == 31)
		{
		$("#r_deduction").hide();
		$("#r_defect_percentage").show();
		$("#r_comments").show();
		$("#r_status").show();
		}
		else
		{
		$("#r_defect_percentage").show();
		$("#r_comments").show();
		$("#r_status").show();
		$("#r_deduction").show();
		}
		var qcs = $('#x_qc_stage').val();
		var bc = $('#x__barcode').val();
			$.getJSON('apcajax.php?qcs='+qcs+'&qcbc='+bc,function(data){
				$("#error").remove();
				$("#imagev").remove();
				if((data.qcs.match(/qcs/i) == qcs) && (window.location.href.match(/add/i) == 'add'))
				{
					alert('Barcode Already Exist for Selected Stage;  Opening Old Entry for Editing');
					location.href = "qcedit.php?id="+data.qcid;
					$('#x__barcode').val('')
				}
				else
				{
					if (data.code == 0)
					{
					alert(bc + ' Not Available in Process Action');
					}
					else
					{
						$("#r__barcode").append('<span id="error">'+data.size+data.weight+data.valuation+data.deduction+data.remarks+'</span>')
						if (data.image.length > 1)
						{
							$('#r_barcode').append('<span id="imagev" style="overflow-x: auto"><img src='+data.image+' height="200px" style="padding: 10px;">');
						}
					}
				}
		});
</script>
<?php include_once "footer.php" ?>
<?php
$qc_edit->terminate();
?>