<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_list = new qc_list();

// Run the page
$qc_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$qc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fqclist = currentForm = new ew.Form("fqclist", "list");
fqclist.formKeyCountName = '<?php echo $qc_list->FormKeyCountName ?>';

// Form_CustomValidate event
fqclist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqclist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqclist.lists["x_location"] = <?php echo $qc_list->location->Lookup->toClientList() ?>;
fqclist.lists["x_location"].options = <?php echo JsonEncode($qc_list->location->lookupOptions()) ?>;
fqclist.lists["x_qc_stage"] = <?php echo $qc_list->qc_stage->Lookup->toClientList() ?>;
fqclist.lists["x_qc_stage"].options = <?php echo JsonEncode($qc_list->qc_stage->lookupOptions()) ?>;
fqclist.lists["x_defect_nature"] = <?php echo $qc_list->defect_nature->Lookup->toClientList() ?>;
fqclist.lists["x_defect_nature"].options = <?php echo JsonEncode($qc_list->defect_nature->lookupOptions()) ?>;
fqclist.lists["x_defect_percentage"] = <?php echo $qc_list->defect_percentage->Lookup->toClientList() ?>;
fqclist.lists["x_defect_percentage"].options = <?php echo JsonEncode($qc_list->defect_percentage->lookupOptions()) ?>;
fqclist.lists["x_status"] = <?php echo $qc_list->status->Lookup->toClientList() ?>;
fqclist.lists["x_status"].options = <?php echo JsonEncode($qc_list->status->lookupOptions()) ?>;
fqclist.lists["x_operator"] = <?php echo $qc_list->operator->Lookup->toClientList() ?>;
fqclist.lists["x_operator"].options = <?php echo JsonEncode($qc_list->operator->lookupOptions()) ?>;
fqclist.lists["x_e_operator"] = <?php echo $qc_list->e_operator->Lookup->toClientList() ?>;
fqclist.lists["x_e_operator"].options = <?php echo JsonEncode($qc_list->e_operator->lookupOptions()) ?>;
fqclist.lists["x_a_operator"] = <?php echo $qc_list->a_operator->Lookup->toClientList() ?>;
fqclist.lists["x_a_operator"].options = <?php echo JsonEncode($qc_list->a_operator->lookupOptions()) ?>;

// Form object for search
var fqclistsrch = currentSearchForm = new ew.Form("fqclistsrch");

// Validate function for search
fqclistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkByRegEx(elm.value, /^([0-9])*$/))
		return this.onError(elm, "<?php echo JsEncode($qc->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_deduction");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc->deduction->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fqclistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqclistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqclistsrch.lists["x_location"] = <?php echo $qc_list->location->Lookup->toClientList() ?>;
fqclistsrch.lists["x_location"].options = <?php echo JsonEncode($qc_list->location->lookupOptions()) ?>;

// Filters
fqclistsrch.filterList = <?php echo $qc_list->getFilterList() ?>;

// Init search panel as collapsed
fqclistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$qc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($qc_list->TotalRecs > 0 && $qc_list->ExportOptions->visible()) { ?>
<?php $qc_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($qc_list->ImportOptions->visible()) { ?>
<?php $qc_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($qc_list->SearchOptions->visible()) { ?>
<?php $qc_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($qc_list->FilterOptions->visible()) { ?>
<?php $qc_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$qc_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$qc->isExport() && !$qc->CurrentAction) { ?>
<form name="fqclistsrch" id="fqclistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($qc_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fqclistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="qc">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$qc_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$qc->RowType = ROWTYPE_SEARCH;

// Render row
$qc->resetAttributes();
$qc_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($qc->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $qc->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc" data-field="x_location" data-value-separator="<?php echo $qc->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $qc->location->editAttributes() ?>>
		<?php echo $qc->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $qc->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($qc->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $qc->_barcode->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__barcode" id="z__barcode" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="qc" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($qc->_barcode->getPlaceHolder()) ?>" value="<?php echo $qc->_barcode->EditValue ?>"<?php echo $qc->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($qc->deduction->Visible) { // deduction ?>
	<div id="xsc_deduction" class="ew-cell form-group">
		<label for="x_deduction" class="ew-search-caption ew-label"><?php echo $qc->deduction->caption() ?></label>
		<span class="ew-search-operator"><select name="z_deduction" id="z_deduction" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="qc" data-field="x_deduction" name="x_deduction" id="x_deduction" size="30" placeholder="<?php echo HtmlEncode($qc->deduction->getPlaceHolder()) ?>" value="<?php echo $qc->deduction->EditValue ?>"<?php echo $qc->deduction->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_deduction style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_deduction style="d-none"">
<input type="text" data-table="qc" data-field="x_deduction" name="y_deduction" id="y_deduction" size="30" placeholder="<?php echo HtmlEncode($qc->deduction->getPlaceHolder()) ?>" value="<?php echo $qc->deduction->EditValue2 ?>"<?php echo $qc->deduction->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($qc_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($qc_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $qc_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($qc_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($qc_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($qc_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($qc_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $qc_list->showPageHeader(); ?>
<?php
$qc_list->showMessage();
?>
<?php if ($qc_list->TotalRecs > 0 || $qc->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($qc_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> qc">
<?php if (!$qc->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$qc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($qc_list->Pager)) $qc_list->Pager = new PrevNextPager($qc_list->StartRec, $qc_list->DisplayRecs, $qc_list->TotalRecs, $qc_list->AutoHidePager) ?>
<?php if ($qc_list->Pager->RecordCount > 0 && $qc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($qc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $qc_list->pageUrl() ?>start=<?php echo $qc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($qc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $qc_list->pageUrl() ?>start=<?php echo $qc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $qc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($qc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $qc_list->pageUrl() ?>start=<?php echo $qc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($qc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $qc_list->pageUrl() ?>start=<?php echo $qc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $qc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($qc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $qc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $qc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $qc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($qc_list->TotalRecs > 0 && (!$qc_list->AutoHidePageSizeSelector || $qc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="qc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($qc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($qc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($qc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($qc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($qc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($qc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $qc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fqclist" id="fqclist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc">
<div id="gmp_qc" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($qc_list->TotalRecs > 0 || $qc->isGridEdit()) { ?>
<table id="tbl_qclist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$qc_list->RowType = ROWTYPE_HEADER;

// Render list options
$qc_list->renderListOptions();

// Render list options (header, left)
$qc_list->ListOptions->render("header", "left");
?>
<?php if ($qc->id->Visible) { // id ?>
	<?php if ($qc->sortUrl($qc->id) == "") { ?>
		<th data-name="id" class="<?php echo $qc->id->headerCellClass() ?>"><div id="elh_qc_id" class="qc_id"><div class="ew-table-header-caption"><?php echo $qc->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $qc->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->id) ?>',2);"><div id="elh_qc_id" class="qc_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->location->Visible) { // location ?>
	<?php if ($qc->sortUrl($qc->location) == "") { ?>
		<th data-name="location" class="<?php echo $qc->location->headerCellClass() ?>"><div id="elh_qc_location" class="qc_location"><div class="ew-table-header-caption"><?php echo $qc->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $qc->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->location) ?>',2);"><div id="elh_qc_location" class="qc_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->qc_stage->Visible) { // qc_stage ?>
	<?php if ($qc->sortUrl($qc->qc_stage) == "") { ?>
		<th data-name="qc_stage" class="<?php echo $qc->qc_stage->headerCellClass() ?>"><div id="elh_qc_qc_stage" class="qc_qc_stage"><div class="ew-table-header-caption"><?php echo $qc->qc_stage->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qc_stage" class="<?php echo $qc->qc_stage->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->qc_stage) ?>',2);"><div id="elh_qc_qc_stage" class="qc_qc_stage">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->qc_stage->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc->qc_stage->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->qc_stage->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->_barcode->Visible) { // barcode ?>
	<?php if ($qc->sortUrl($qc->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $qc->_barcode->headerCellClass() ?>"><div id="elh_qc__barcode" class="qc__barcode"><div class="ew-table-header-caption"><?php echo $qc->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $qc->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->_barcode) ?>',2);"><div id="elh_qc__barcode" class="qc__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->lines_in_30cm->Visible) { // lines_in_30cm ?>
	<?php if ($qc->sortUrl($qc->lines_in_30cm) == "") { ?>
		<th data-name="lines_in_30cm" class="<?php echo $qc->lines_in_30cm->headerCellClass() ?>"><div id="elh_qc_lines_in_30cm" class="qc_lines_in_30cm"><div class="ew-table-header-caption"><?php echo $qc->lines_in_30cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lines_in_30cm" class="<?php echo $qc->lines_in_30cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->lines_in_30cm) ?>',2);"><div id="elh_qc_lines_in_30cm" class="qc_lines_in_30cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->lines_in_30cm->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc->lines_in_30cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->lines_in_30cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->size_actual->Visible) { // size_actual ?>
	<?php if ($qc->sortUrl($qc->size_actual) == "") { ?>
		<th data-name="size_actual" class="<?php echo $qc->size_actual->headerCellClass() ?>"><div id="elh_qc_size_actual" class="qc_size_actual"><div class="ew-table-header-caption"><?php echo $qc->size_actual->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_actual" class="<?php echo $qc->size_actual->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->size_actual) ?>',2);"><div id="elh_qc_size_actual" class="qc_size_actual">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->size_actual->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc->size_actual->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->size_actual->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->weight_actual->Visible) { // weight_actual ?>
	<?php if ($qc->sortUrl($qc->weight_actual) == "") { ?>
		<th data-name="weight_actual" class="<?php echo $qc->weight_actual->headerCellClass() ?>"><div id="elh_qc_weight_actual" class="qc_weight_actual"><div class="ew-table-header-caption"><?php echo $qc->weight_actual->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weight_actual" class="<?php echo $qc->weight_actual->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->weight_actual) ?>',2);"><div id="elh_qc_weight_actual" class="qc_weight_actual">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->weight_actual->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc->weight_actual->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->weight_actual->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->defect_nature->Visible) { // defect_nature ?>
	<?php if ($qc->sortUrl($qc->defect_nature) == "") { ?>
		<th data-name="defect_nature" class="<?php echo $qc->defect_nature->headerCellClass() ?>"><div id="elh_qc_defect_nature" class="qc_defect_nature"><div class="ew-table-header-caption"><?php echo $qc->defect_nature->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="defect_nature" class="<?php echo $qc->defect_nature->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->defect_nature) ?>',2);"><div id="elh_qc_defect_nature" class="qc_defect_nature">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->defect_nature->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc->defect_nature->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->defect_nature->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->defect_percentage->Visible) { // defect_percentage ?>
	<?php if ($qc->sortUrl($qc->defect_percentage) == "") { ?>
		<th data-name="defect_percentage" class="<?php echo $qc->defect_percentage->headerCellClass() ?>"><div id="elh_qc_defect_percentage" class="qc_defect_percentage"><div class="ew-table-header-caption"><?php echo $qc->defect_percentage->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="defect_percentage" class="<?php echo $qc->defect_percentage->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->defect_percentage) ?>',2);"><div id="elh_qc_defect_percentage" class="qc_defect_percentage">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->defect_percentage->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc->defect_percentage->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->defect_percentage->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->deduction->Visible) { // deduction ?>
	<?php if ($qc->sortUrl($qc->deduction) == "") { ?>
		<th data-name="deduction" class="<?php echo $qc->deduction->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_qc_deduction" class="qc_deduction"><div class="ew-table-header-caption"><?php echo $qc->deduction->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="deduction" class="<?php echo $qc->deduction->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->deduction) ?>',2);"><div id="elh_qc_deduction" class="qc_deduction">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->deduction->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc->deduction->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->deduction->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->comments->Visible) { // comments ?>
	<?php if ($qc->sortUrl($qc->comments) == "") { ?>
		<th data-name="comments" class="<?php echo $qc->comments->headerCellClass() ?>"><div id="elh_qc_comments" class="qc_comments"><div class="ew-table-header-caption"><?php echo $qc->comments->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="comments" class="<?php echo $qc->comments->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->comments) ?>',2);"><div id="elh_qc_comments" class="qc_comments">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->comments->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc->comments->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->comments->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->status->Visible) { // status ?>
	<?php if ($qc->sortUrl($qc->status) == "") { ?>
		<th data-name="status" class="<?php echo $qc->status->headerCellClass() ?>"><div id="elh_qc_status" class="qc_status"><div class="ew-table-header-caption"><?php echo $qc->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $qc->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->status) ?>',2);"><div id="elh_qc_status" class="qc_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->operator->Visible) { // operator ?>
	<?php if ($qc->sortUrl($qc->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $qc->operator->headerCellClass() ?>"><div id="elh_qc_operator" class="qc_operator"><div class="ew-table-header-caption"><?php echo $qc->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $qc->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->operator) ?>',2);"><div id="elh_qc_operator" class="qc_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->datetime->Visible) { // datetime ?>
	<?php if ($qc->sortUrl($qc->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $qc->datetime->headerCellClass() ?>"><div id="elh_qc_datetime" class="qc_datetime"><div class="ew-table-header-caption"><?php echo $qc->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $qc->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->datetime) ?>',2);"><div id="elh_qc_datetime" class="qc_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->e_operator->Visible) { // e_operator ?>
	<?php if ($qc->sortUrl($qc->e_operator) == "") { ?>
		<th data-name="e_operator" class="<?php echo $qc->e_operator->headerCellClass() ?>"><div id="elh_qc_e_operator" class="qc_e_operator"><div class="ew-table-header-caption"><?php echo $qc->e_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="e_operator" class="<?php echo $qc->e_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->e_operator) ?>',2);"><div id="elh_qc_e_operator" class="qc_e_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->e_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc->e_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->e_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->e_datetime->Visible) { // e_datetime ?>
	<?php if ($qc->sortUrl($qc->e_datetime) == "") { ?>
		<th data-name="e_datetime" class="<?php echo $qc->e_datetime->headerCellClass() ?>"><div id="elh_qc_e_datetime" class="qc_e_datetime"><div class="ew-table-header-caption"><?php echo $qc->e_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="e_datetime" class="<?php echo $qc->e_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->e_datetime) ?>',2);"><div id="elh_qc_e_datetime" class="qc_e_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->e_datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc->e_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->e_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->_action->Visible) { // action ?>
	<?php if ($qc->sortUrl($qc->_action) == "") { ?>
		<th data-name="_action" class="<?php echo $qc->_action->headerCellClass() ?>"><div id="elh_qc__action" class="qc__action"><div class="ew-table-header-caption"><?php echo $qc->_action->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_action" class="<?php echo $qc->_action->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->_action) ?>',2);"><div id="elh_qc__action" class="qc__action">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->_action->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc->_action->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->_action->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->remarks->Visible) { // remarks ?>
	<?php if ($qc->sortUrl($qc->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $qc->remarks->headerCellClass() ?>"><div id="elh_qc_remarks" class="qc_remarks"><div class="ew-table-header-caption"><?php echo $qc->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $qc->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->remarks) ?>',2);"><div id="elh_qc_remarks" class="qc_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->design->Visible) { // design ?>
	<?php if ($qc->sortUrl($qc->design) == "") { ?>
		<th data-name="design" class="<?php echo $qc->design->headerCellClass() ?>"><div id="elh_qc_design" class="qc_design"><div class="ew-table-header-caption"><?php echo $qc->design->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design" class="<?php echo $qc->design->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->design) ?>',2);"><div id="elh_qc_design" class="qc_design">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->design->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc->design->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->design->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->size->Visible) { // size ?>
	<?php if ($qc->sortUrl($qc->size) == "") { ?>
		<th data-name="size" class="<?php echo $qc->size->headerCellClass() ?>"><div id="elh_qc_size" class="qc_size"><div class="ew-table-header-caption"><?php echo $qc->size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size" class="<?php echo $qc->size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->size) ?>',2);"><div id="elh_qc_size" class="qc_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc->size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->a_operator->Visible) { // a_operator ?>
	<?php if ($qc->sortUrl($qc->a_operator) == "") { ?>
		<th data-name="a_operator" class="<?php echo $qc->a_operator->headerCellClass() ?>"><div id="elh_qc_a_operator" class="qc_a_operator"><div class="ew-table-header-caption"><?php echo $qc->a_operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_operator" class="<?php echo $qc->a_operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->a_operator) ?>',2);"><div id="elh_qc_a_operator" class="qc_a_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->a_operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc->a_operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->a_operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->a_datetime->Visible) { // a_datetime ?>
	<?php if ($qc->sortUrl($qc->a_datetime) == "") { ?>
		<th data-name="a_datetime" class="<?php echo $qc->a_datetime->headerCellClass() ?>"><div id="elh_qc_a_datetime" class="qc_a_datetime"><div class="ew-table-header-caption"><?php echo $qc->a_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_datetime" class="<?php echo $qc->a_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->a_datetime) ?>',2);"><div id="elh_qc_a_datetime" class="qc_a_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->a_datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc->a_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->a_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->bcode_status->Visible) { // bcode_status ?>
	<?php if ($qc->sortUrl($qc->bcode_status) == "") { ?>
		<th data-name="bcode_status" class="<?php echo $qc->bcode_status->headerCellClass() ?>"><div id="elh_qc_bcode_status" class="qc_bcode_status"><div class="ew-table-header-caption"><?php echo $qc->bcode_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bcode_status" class="<?php echo $qc->bcode_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->bcode_status) ?>',2);"><div id="elh_qc_bcode_status" class="qc_bcode_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->bcode_status->caption() ?></span><span class="ew-table-header-sort"><?php if ($qc->bcode_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->bcode_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($qc->product_image->Visible) { // product_image ?>
	<?php if ($qc->sortUrl($qc->product_image) == "") { ?>
		<th data-name="product_image" class="<?php echo $qc->product_image->headerCellClass() ?>"><div id="elh_qc_product_image" class="qc_product_image"><div class="ew-table-header-caption"><?php echo $qc->product_image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_image" class="<?php echo $qc->product_image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $qc->SortUrl($qc->product_image) ?>',2);"><div id="elh_qc_product_image" class="qc_product_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $qc->product_image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($qc->product_image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($qc->product_image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$qc_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($qc->ExportAll && $qc->isExport()) {
	$qc_list->StopRec = $qc_list->TotalRecs;
} else {

	// Set the last record to display
	if ($qc_list->TotalRecs > $qc_list->StartRec + $qc_list->DisplayRecs - 1)
		$qc_list->StopRec = $qc_list->StartRec + $qc_list->DisplayRecs - 1;
	else
		$qc_list->StopRec = $qc_list->TotalRecs;
}
$qc_list->RecCnt = $qc_list->StartRec - 1;
if ($qc_list->Recordset && !$qc_list->Recordset->EOF) {
	$qc_list->Recordset->moveFirst();
	$selectLimit = $qc_list->UseSelectLimit;
	if (!$selectLimit && $qc_list->StartRec > 1)
		$qc_list->Recordset->move($qc_list->StartRec - 1);
} elseif (!$qc->AllowAddDeleteRow && $qc_list->StopRec == 0) {
	$qc_list->StopRec = $qc->GridAddRowCount;
}

// Initialize aggregate
$qc->RowType = ROWTYPE_AGGREGATEINIT;
$qc->resetAttributes();
$qc_list->renderRow();
while ($qc_list->RecCnt < $qc_list->StopRec) {
	$qc_list->RecCnt++;
	if ($qc_list->RecCnt >= $qc_list->StartRec) {
		$qc_list->RowCnt++;

		// Set up key count
		$qc_list->KeyCount = $qc_list->RowIndex;

		// Init row class and style
		$qc->resetAttributes();
		$qc->CssClass = "";
		if ($qc->isGridAdd()) {
		} else {
			$qc_list->loadRowValues($qc_list->Recordset); // Load row values
		}
		$qc->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$qc->RowAttrs = array_merge($qc->RowAttrs, array('data-rowindex'=>$qc_list->RowCnt, 'id'=>'r' . $qc_list->RowCnt . '_qc', 'data-rowtype'=>$qc->RowType));

		// Render row
		$qc_list->renderRow();

		// Render list options
		$qc_list->renderListOptions();
?>
	<tr<?php echo $qc->rowAttributes() ?>>
<?php

// Render list options (body, left)
$qc_list->ListOptions->render("body", "left", $qc_list->RowCnt);
?>
	<?php if ($qc->id->Visible) { // id ?>
		<td data-name="id"<?php echo $qc->id->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_id" class="qc_id">
<span<?php echo $qc->id->viewAttributes() ?>>
<?php echo $qc->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->location->Visible) { // location ?>
		<td data-name="location"<?php echo $qc->location->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_location" class="qc_location">
<span<?php echo $qc->location->viewAttributes() ?>>
<?php echo $qc->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->qc_stage->Visible) { // qc_stage ?>
		<td data-name="qc_stage"<?php echo $qc->qc_stage->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_qc_stage" class="qc_qc_stage">
<span<?php echo $qc->qc_stage->viewAttributes() ?>>
<?php echo $qc->qc_stage->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $qc->_barcode->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc__barcode" class="qc__barcode">
<span<?php echo $qc->_barcode->viewAttributes() ?>>
<?php echo $qc->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->lines_in_30cm->Visible) { // lines_in_30cm ?>
		<td data-name="lines_in_30cm"<?php echo $qc->lines_in_30cm->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_lines_in_30cm" class="qc_lines_in_30cm">
<span<?php echo $qc->lines_in_30cm->viewAttributes() ?>>
<?php echo $qc->lines_in_30cm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->size_actual->Visible) { // size_actual ?>
		<td data-name="size_actual"<?php echo $qc->size_actual->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_size_actual" class="qc_size_actual">
<span<?php echo $qc->size_actual->viewAttributes() ?>>
<?php echo $qc->size_actual->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->weight_actual->Visible) { // weight_actual ?>
		<td data-name="weight_actual"<?php echo $qc->weight_actual->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_weight_actual" class="qc_weight_actual">
<span<?php echo $qc->weight_actual->viewAttributes() ?>>
<?php echo $qc->weight_actual->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->defect_nature->Visible) { // defect_nature ?>
		<td data-name="defect_nature"<?php echo $qc->defect_nature->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_defect_nature" class="qc_defect_nature">
<span<?php echo $qc->defect_nature->viewAttributes() ?>>
<?php echo $qc->defect_nature->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->defect_percentage->Visible) { // defect_percentage ?>
		<td data-name="defect_percentage"<?php echo $qc->defect_percentage->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_defect_percentage" class="qc_defect_percentage">
<span<?php echo $qc->defect_percentage->viewAttributes() ?>>
<?php echo $qc->defect_percentage->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->deduction->Visible) { // deduction ?>
		<td data-name="deduction"<?php echo $qc->deduction->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_deduction" class="qc_deduction">
<span<?php echo $qc->deduction->viewAttributes() ?>>
<?php echo $qc->deduction->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->comments->Visible) { // comments ?>
		<td data-name="comments"<?php echo $qc->comments->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_comments" class="qc_comments">
<span<?php echo $qc->comments->viewAttributes() ?>>
<?php echo $qc->comments->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->status->Visible) { // status ?>
		<td data-name="status"<?php echo $qc->status->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_status" class="qc_status">
<span<?php echo $qc->status->viewAttributes() ?>>
<?php echo $qc->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $qc->operator->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_operator" class="qc_operator">
<span<?php echo $qc->operator->viewAttributes() ?>>
<?php echo $qc->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $qc->datetime->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_datetime" class="qc_datetime">
<span<?php echo $qc->datetime->viewAttributes() ?>>
<?php echo $qc->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->e_operator->Visible) { // e_operator ?>
		<td data-name="e_operator"<?php echo $qc->e_operator->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_e_operator" class="qc_e_operator">
<span<?php echo $qc->e_operator->viewAttributes() ?>>
<?php echo $qc->e_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->e_datetime->Visible) { // e_datetime ?>
		<td data-name="e_datetime"<?php echo $qc->e_datetime->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_e_datetime" class="qc_e_datetime">
<span<?php echo $qc->e_datetime->viewAttributes() ?>>
<?php echo $qc->e_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->_action->Visible) { // action ?>
		<td data-name="_action"<?php echo $qc->_action->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc__action" class="qc__action">
<span<?php echo $qc->_action->viewAttributes() ?>>
<?php echo $qc->_action->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $qc->remarks->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_remarks" class="qc_remarks">
<span<?php echo $qc->remarks->viewAttributes() ?>>
<?php echo $qc->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->design->Visible) { // design ?>
		<td data-name="design"<?php echo $qc->design->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_design" class="qc_design">
<span<?php echo $qc->design->viewAttributes() ?>>
<?php echo $qc->design->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->size->Visible) { // size ?>
		<td data-name="size"<?php echo $qc->size->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_size" class="qc_size">
<span<?php echo $qc->size->viewAttributes() ?>>
<?php echo $qc->size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->a_operator->Visible) { // a_operator ?>
		<td data-name="a_operator"<?php echo $qc->a_operator->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_a_operator" class="qc_a_operator">
<span<?php echo $qc->a_operator->viewAttributes() ?>>
<?php echo $qc->a_operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->a_datetime->Visible) { // a_datetime ?>
		<td data-name="a_datetime"<?php echo $qc->a_datetime->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_a_datetime" class="qc_a_datetime">
<span<?php echo $qc->a_datetime->viewAttributes() ?>>
<?php echo $qc->a_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->bcode_status->Visible) { // bcode_status ?>
		<td data-name="bcode_status"<?php echo $qc->bcode_status->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_bcode_status" class="qc_bcode_status">
<span<?php echo $qc->bcode_status->viewAttributes() ?>>
<?php echo $qc->bcode_status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($qc->product_image->Visible) { // product_image ?>
		<td data-name="product_image"<?php echo $qc->product_image->cellAttributes() ?>>
<span id="el<?php echo $qc_list->RowCnt ?>_qc_product_image" class="qc_product_image">
<span<?php echo $qc->product_image->viewAttributes() ?>>
<?php echo $qc->product_image->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$qc_list->ListOptions->render("body", "right", $qc_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$qc->isGridAdd())
		$qc_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$qc->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($qc_list->Recordset)
	$qc_list->Recordset->Close();
?>
<?php if (!$qc->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$qc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($qc_list->Pager)) $qc_list->Pager = new PrevNextPager($qc_list->StartRec, $qc_list->DisplayRecs, $qc_list->TotalRecs, $qc_list->AutoHidePager) ?>
<?php if ($qc_list->Pager->RecordCount > 0 && $qc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($qc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $qc_list->pageUrl() ?>start=<?php echo $qc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($qc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $qc_list->pageUrl() ?>start=<?php echo $qc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $qc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($qc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $qc_list->pageUrl() ?>start=<?php echo $qc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($qc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $qc_list->pageUrl() ?>start=<?php echo $qc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $qc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($qc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $qc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $qc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $qc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($qc_list->TotalRecs > 0 && (!$qc_list->AutoHidePageSizeSelector || $qc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="qc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($qc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($qc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($qc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($qc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($qc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($qc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $qc_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($qc_list->TotalRecs == 0 && !$qc->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $qc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$qc_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$qc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$qc->isExport()) { ?>
<script>
ew.scrollableTable("gmp_qc", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$qc_list->terminate();
?>