<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_search = new qc_search();

// Run the page
$qc_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($qc_search->IsModal) { ?>
var fqcsearch = currentAdvancedSearchForm = new ew.Form("fqcsearch", "search");
<?php } else { ?>
var fqcsearch = currentForm = new ew.Form("fqcsearch", "search");
<?php } ?>

// Form_CustomValidate event
fqcsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqcsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqcsearch.lists["x_location"] = <?php echo $qc_search->location->Lookup->toClientList() ?>;
fqcsearch.lists["x_location"].options = <?php echo JsonEncode($qc_search->location->lookupOptions()) ?>;
fqcsearch.lists["x_qc_stage"] = <?php echo $qc_search->qc_stage->Lookup->toClientList() ?>;
fqcsearch.lists["x_qc_stage"].options = <?php echo JsonEncode($qc_search->qc_stage->lookupOptions()) ?>;
fqcsearch.lists["x_defect_nature"] = <?php echo $qc_search->defect_nature->Lookup->toClientList() ?>;
fqcsearch.lists["x_defect_nature"].options = <?php echo JsonEncode($qc_search->defect_nature->lookupOptions()) ?>;
fqcsearch.lists["x_defect_percentage"] = <?php echo $qc_search->defect_percentage->Lookup->toClientList() ?>;
fqcsearch.lists["x_defect_percentage"].options = <?php echo JsonEncode($qc_search->defect_percentage->lookupOptions()) ?>;
fqcsearch.lists["x_status"] = <?php echo $qc_search->status->Lookup->toClientList() ?>;
fqcsearch.lists["x_status"].options = <?php echo JsonEncode($qc_search->status->lookupOptions()) ?>;
fqcsearch.lists["x_operator"] = <?php echo $qc_search->operator->Lookup->toClientList() ?>;
fqcsearch.lists["x_operator"].options = <?php echo JsonEncode($qc_search->operator->lookupOptions()) ?>;
fqcsearch.lists["x_e_operator"] = <?php echo $qc_search->e_operator->Lookup->toClientList() ?>;
fqcsearch.lists["x_e_operator"].options = <?php echo JsonEncode($qc_search->e_operator->lookupOptions()) ?>;
fqcsearch.lists["x_a_operator"] = <?php echo $qc_search->a_operator->Lookup->toClientList() ?>;
fqcsearch.lists["x_a_operator"].options = <?php echo JsonEncode($qc_search->a_operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fqcsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkByRegEx(elm.value, /^([0-9])*$/))
		return this.onError(elm, "<?php echo JsEncode($qc->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_lines_in_30cm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc->lines_in_30cm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_weight_actual");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc->weight_actual->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_deduction");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc->deduction->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_e_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc->e_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__action");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc->_action->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_a_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc->a_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_bcode_status");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($qc->bcode_status->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $qc_search->showPageHeader(); ?>
<?php
$qc_search->showMessage();
?>
<form name="fqcsearch" id="fqcsearch" class="<?php echo $qc_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$qc_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($qc->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_id"><?php echo $qc->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->id->cellAttributes() ?>>
			<span id="el_qc_id">
<input type="text" data-table="qc" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($qc->id->getPlaceHolder()) ?>" value="<?php echo $qc->id->EditValue ?>"<?php echo $qc->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_location"><?php echo $qc->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->location->cellAttributes() ?>>
			<span id="el_qc_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc" data-field="x_location" data-value-separator="<?php echo $qc->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $qc->location->editAttributes() ?>>
		<?php echo $qc->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $qc->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->qc_stage->Visible) { // qc_stage ?>
	<div id="r_qc_stage" class="form-group row">
		<label for="x_qc_stage" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_qc_stage"><?php echo $qc->qc_stage->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qc_stage" id="z_qc_stage" value="="></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->qc_stage->cellAttributes() ?>>
			<span id="el_qc_qc_stage">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc" data-field="x_qc_stage" data-value-separator="<?php echo $qc->qc_stage->displayValueSeparatorAttribute() ?>" id="x_qc_stage" name="x_qc_stage"<?php echo $qc->qc_stage->editAttributes() ?>>
		<?php echo $qc->qc_stage->selectOptionListHtml("x_qc_stage") ?>
	</select>
</div>
<?php echo $qc->qc_stage->Lookup->getParamTag("p_x_qc_stage") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc__barcode"><?php echo $qc->_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__barcode" id="z__barcode" value="="></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->_barcode->cellAttributes() ?>>
			<span id="el_qc__barcode">
<input type="text" data-table="qc" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($qc->_barcode->getPlaceHolder()) ?>" value="<?php echo $qc->_barcode->EditValue ?>"<?php echo $qc->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->lines_in_30cm->Visible) { // lines_in_30cm ?>
	<div id="r_lines_in_30cm" class="form-group row">
		<label for="x_lines_in_30cm" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_lines_in_30cm"><?php echo $qc->lines_in_30cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_lines_in_30cm" id="z_lines_in_30cm" value="="></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->lines_in_30cm->cellAttributes() ?>>
			<span id="el_qc_lines_in_30cm">
<input type="text" data-table="qc" data-field="x_lines_in_30cm" name="x_lines_in_30cm" id="x_lines_in_30cm" size="30" placeholder="<?php echo HtmlEncode($qc->lines_in_30cm->getPlaceHolder()) ?>" value="<?php echo $qc->lines_in_30cm->EditValue ?>"<?php echo $qc->lines_in_30cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->size_actual->Visible) { // size_actual ?>
	<div id="r_size_actual" class="form-group row">
		<label for="x_size_actual" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_size_actual"><?php echo $qc->size_actual->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_actual" id="z_size_actual" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->size_actual->cellAttributes() ?>>
			<span id="el_qc_size_actual">
<input type="text" data-table="qc" data-field="x_size_actual" name="x_size_actual" id="x_size_actual" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($qc->size_actual->getPlaceHolder()) ?>" value="<?php echo $qc->size_actual->EditValue ?>"<?php echo $qc->size_actual->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->weight_actual->Visible) { // weight_actual ?>
	<div id="r_weight_actual" class="form-group row">
		<label for="x_weight_actual" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_weight_actual"><?php echo $qc->weight_actual->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weight_actual" id="z_weight_actual" value="="></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->weight_actual->cellAttributes() ?>>
			<span id="el_qc_weight_actual">
<input type="text" data-table="qc" data-field="x_weight_actual" name="x_weight_actual" id="x_weight_actual" size="30" placeholder="<?php echo HtmlEncode($qc->weight_actual->getPlaceHolder()) ?>" value="<?php echo $qc->weight_actual->EditValue ?>"<?php echo $qc->weight_actual->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->defect_nature->Visible) { // defect_nature ?>
	<div id="r_defect_nature" class="form-group row">
		<label for="x_defect_nature" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_defect_nature"><?php echo $qc->defect_nature->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_defect_nature" id="z_defect_nature" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->defect_nature->cellAttributes() ?>>
			<span id="el_qc_defect_nature">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc" data-field="x_defect_nature" data-value-separator="<?php echo $qc->defect_nature->displayValueSeparatorAttribute() ?>" id="x_defect_nature" name="x_defect_nature"<?php echo $qc->defect_nature->editAttributes() ?>>
		<?php echo $qc->defect_nature->selectOptionListHtml("x_defect_nature") ?>
	</select>
</div>
<?php echo $qc->defect_nature->Lookup->getParamTag("p_x_defect_nature") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->defect_percentage->Visible) { // defect_percentage ?>
	<div id="r_defect_percentage" class="form-group row">
		<label for="x_defect_percentage" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_defect_percentage"><?php echo $qc->defect_percentage->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_defect_percentage" id="z_defect_percentage" value="="></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->defect_percentage->cellAttributes() ?>>
			<span id="el_qc_defect_percentage">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc" data-field="x_defect_percentage" data-value-separator="<?php echo $qc->defect_percentage->displayValueSeparatorAttribute() ?>" id="x_defect_percentage" name="x_defect_percentage"<?php echo $qc->defect_percentage->editAttributes() ?>>
		<?php echo $qc->defect_percentage->selectOptionListHtml("x_defect_percentage") ?>
	</select>
</div>
<?php echo $qc->defect_percentage->Lookup->getParamTag("p_x_defect_percentage") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->deduction->Visible) { // deduction ?>
	<div id="r_deduction" class="form-group row">
		<label for="x_deduction" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_deduction"><?php echo $qc->deduction->caption() ?></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->deduction->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_deduction" id="z_deduction" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($qc->deduction->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_qc_deduction">
<input type="text" data-table="qc" data-field="x_deduction" name="x_deduction" id="x_deduction" size="30" placeholder="<?php echo HtmlEncode($qc->deduction->getPlaceHolder()) ?>" value="<?php echo $qc->deduction->EditValue ?>"<?php echo $qc->deduction->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_deduction d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_qc_deduction" class="btw1_deduction d-none">
<input type="text" data-table="qc" data-field="x_deduction" name="y_deduction" id="y_deduction" size="30" placeholder="<?php echo HtmlEncode($qc->deduction->getPlaceHolder()) ?>" value="<?php echo $qc->deduction->EditValue2 ?>"<?php echo $qc->deduction->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->comments->Visible) { // comments ?>
	<div id="r_comments" class="form-group row">
		<label for="x_comments" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_comments"><?php echo $qc->comments->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_comments" id="z_comments" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->comments->cellAttributes() ?>>
			<span id="el_qc_comments">
<input type="text" data-table="qc" data-field="x_comments" name="x_comments" id="x_comments" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($qc->comments->getPlaceHolder()) ?>" value="<?php echo $qc->comments->EditValue ?>"<?php echo $qc->comments->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_status"><?php echo $qc->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->status->cellAttributes() ?>>
			<span id="el_qc_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc" data-field="x_status" data-value-separator="<?php echo $qc->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $qc->status->editAttributes() ?>>
		<?php echo $qc->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $qc->status->Lookup->getParamTag("p_x_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_operator"><?php echo $qc->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->operator->cellAttributes() ?>>
			<span id="el_qc_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc" data-field="x_operator" data-value-separator="<?php echo $qc->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $qc->operator->editAttributes() ?>>
		<?php echo $qc->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $qc->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_datetime"><?php echo $qc->datetime->caption() ?></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($qc->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_qc_datetime">
<input type="text" data-table="qc" data-field="x_datetime" data-format="117" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($qc->datetime->getPlaceHolder()) ?>" value="<?php echo $qc->datetime->EditValue ?>"<?php echo $qc->datetime->editAttributes() ?>>
<?php if (!$qc->datetime->ReadOnly && !$qc->datetime->Disabled && !isset($qc->datetime->EditAttrs["readonly"]) && !isset($qc->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fqcsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_qc_datetime" class="btw1_datetime d-none">
<input type="text" data-table="qc" data-field="x_datetime" data-format="117" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($qc->datetime->getPlaceHolder()) ?>" value="<?php echo $qc->datetime->EditValue2 ?>"<?php echo $qc->datetime->editAttributes() ?>>
<?php if (!$qc->datetime->ReadOnly && !$qc->datetime->Disabled && !isset($qc->datetime->EditAttrs["readonly"]) && !isset($qc->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fqcsearch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->e_operator->Visible) { // e_operator ?>
	<div id="r_e_operator" class="form-group row">
		<label for="x_e_operator" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_e_operator"><?php echo $qc->e_operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_e_operator" id="z_e_operator" value="="></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->e_operator->cellAttributes() ?>>
			<span id="el_qc_e_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc" data-field="x_e_operator" data-value-separator="<?php echo $qc->e_operator->displayValueSeparatorAttribute() ?>" id="x_e_operator" name="x_e_operator"<?php echo $qc->e_operator->editAttributes() ?>>
		<?php echo $qc->e_operator->selectOptionListHtml("x_e_operator") ?>
	</select>
</div>
<?php echo $qc->e_operator->Lookup->getParamTag("p_x_e_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->e_datetime->Visible) { // e_datetime ?>
	<div id="r_e_datetime" class="form-group row">
		<label for="x_e_datetime" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_e_datetime"><?php echo $qc->e_datetime->caption() ?></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->e_datetime->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_e_datetime" id="z_e_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc->e_datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc->e_datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc->e_datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc->e_datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc->e_datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc->e_datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($qc->e_datetime->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($qc->e_datetime->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($qc->e_datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_qc_e_datetime">
<input type="text" data-table="qc" data-field="x_e_datetime" data-format="117" name="x_e_datetime" id="x_e_datetime" placeholder="<?php echo HtmlEncode($qc->e_datetime->getPlaceHolder()) ?>" value="<?php echo $qc->e_datetime->EditValue ?>"<?php echo $qc->e_datetime->editAttributes() ?>>
<?php if (!$qc->e_datetime->ReadOnly && !$qc->e_datetime->Disabled && !isset($qc->e_datetime->EditAttrs["readonly"]) && !isset($qc->e_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fqcsearch", "x_e_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_e_datetime d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_qc_e_datetime" class="btw1_e_datetime d-none">
<input type="text" data-table="qc" data-field="x_e_datetime" data-format="117" name="y_e_datetime" id="y_e_datetime" placeholder="<?php echo HtmlEncode($qc->e_datetime->getPlaceHolder()) ?>" value="<?php echo $qc->e_datetime->EditValue2 ?>"<?php echo $qc->e_datetime->editAttributes() ?>>
<?php if (!$qc->e_datetime->ReadOnly && !$qc->e_datetime->Disabled && !isset($qc->e_datetime->EditAttrs["readonly"]) && !isset($qc->e_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fqcsearch", "y_e_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->_action->Visible) { // action ?>
	<div id="r__action" class="form-group row">
		<label for="x__action" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc__action"><?php echo $qc->_action->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__action" id="z__action" value="="></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->_action->cellAttributes() ?>>
			<span id="el_qc__action">
<input type="text" data-table="qc" data-field="x__action" name="x__action" id="x__action" size="30" placeholder="<?php echo HtmlEncode($qc->_action->getPlaceHolder()) ?>" value="<?php echo $qc->_action->EditValue ?>"<?php echo $qc->_action->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_remarks"><?php echo $qc->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->remarks->cellAttributes() ?>>
			<span id="el_qc_remarks">
<input type="text" data-table="qc" data-field="x_remarks" name="x_remarks" id="x_remarks" maxlength="96" placeholder="<?php echo HtmlEncode($qc->remarks->getPlaceHolder()) ?>" value="<?php echo $qc->remarks->EditValue ?>"<?php echo $qc->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->design->Visible) { // design ?>
	<div id="r_design" class="form-group row">
		<label for="x_design" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_design"><?php echo $qc->design->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design" id="z_design" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->design->cellAttributes() ?>>
			<span id="el_qc_design">
<input type="text" data-table="qc" data-field="x_design" name="x_design" id="x_design" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($qc->design->getPlaceHolder()) ?>" value="<?php echo $qc->design->EditValue ?>"<?php echo $qc->design->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->size->Visible) { // size ?>
	<div id="r_size" class="form-group row">
		<label for="x_size" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_size"><?php echo $qc->size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size" id="z_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->size->cellAttributes() ?>>
			<span id="el_qc_size">
<input type="text" data-table="qc" data-field="x_size" name="x_size" id="x_size" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($qc->size->getPlaceHolder()) ?>" value="<?php echo $qc->size->EditValue ?>"<?php echo $qc->size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->a_operator->Visible) { // a_operator ?>
	<div id="r_a_operator" class="form-group row">
		<label for="x_a_operator" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_a_operator"><?php echo $qc->a_operator->caption() ?></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->a_operator->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_a_operator" id="z_a_operator" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($qc->a_operator->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($qc->a_operator->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($qc->a_operator->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($qc->a_operator->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($qc->a_operator->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($qc->a_operator->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($qc->a_operator->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($qc->a_operator->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($qc->a_operator->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_qc_a_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc" data-field="x_a_operator" data-value-separator="<?php echo $qc->a_operator->displayValueSeparatorAttribute() ?>" id="x_a_operator" name="x_a_operator"<?php echo $qc->a_operator->editAttributes() ?>>
		<?php echo $qc->a_operator->selectOptionListHtml("x_a_operator") ?>
	</select>
</div>
<?php echo $qc->a_operator->Lookup->getParamTag("p_x_a_operator") ?>
</span>
			<span class="ew-search-cond btw1_a_operator d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_qc_a_operator" class="btw1_a_operator d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qc" data-field="x_a_operator" data-value-separator="<?php echo $qc->a_operator->displayValueSeparatorAttribute() ?>" id="y_a_operator" name="y_a_operator"<?php echo $qc->a_operator->editAttributes() ?>>
		<?php echo $qc->a_operator->selectOptionListHtml("y_a_operator") ?>
	</select>
</div>
<?php echo $qc->a_operator->Lookup->getParamTag("p_y_a_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->a_datetime->Visible) { // a_datetime ?>
	<div id="r_a_datetime" class="form-group row">
		<label for="x_a_datetime" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_a_datetime"><?php echo $qc->a_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_a_datetime" id="z_a_datetime" value="="></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->a_datetime->cellAttributes() ?>>
			<span id="el_qc_a_datetime">
<input type="text" data-table="qc" data-field="x_a_datetime" data-format="117" name="x_a_datetime" id="x_a_datetime" placeholder="<?php echo HtmlEncode($qc->a_datetime->getPlaceHolder()) ?>" value="<?php echo $qc->a_datetime->EditValue ?>"<?php echo $qc->a_datetime->editAttributes() ?>>
<?php if (!$qc->a_datetime->ReadOnly && !$qc->a_datetime->Disabled && !isset($qc->a_datetime->EditAttrs["readonly"]) && !isset($qc->a_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fqcsearch", "x_a_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->bcode_status->Visible) { // bcode_status ?>
	<div id="r_bcode_status" class="form-group row">
		<label for="x_bcode_status" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_bcode_status"><?php echo $qc->bcode_status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_bcode_status" id="z_bcode_status" value="="></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->bcode_status->cellAttributes() ?>>
			<span id="el_qc_bcode_status">
<input type="text" data-table="qc" data-field="x_bcode_status" name="x_bcode_status" id="x_bcode_status" size="30" placeholder="<?php echo HtmlEncode($qc->bcode_status->getPlaceHolder()) ?>" value="<?php echo $qc->bcode_status->EditValue ?>"<?php echo $qc->bcode_status->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($qc->product_image->Visible) { // product_image ?>
	<div id="r_product_image" class="form-group row">
		<label for="x_product_image" class="<?php echo $qc_search->LeftColumnClass ?>"><span id="elh_qc_product_image"><?php echo $qc->product_image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_image" id="z_product_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $qc_search->RightColumnClass ?>"><div<?php echo $qc->product_image->cellAttributes() ?>>
			<span id="el_qc_product_image">
<input type="text" data-table="qc" data-field="x_product_image" name="x_product_image" id="x_product_image" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($qc->product_image->getPlaceHolder()) ?>" value="<?php echo $qc->product_image->EditValue ?>"<?php echo $qc->product_image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$qc_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $qc_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$qc_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$qc_search->terminate();
?>