<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qc_view = new qc_view();

// Run the page
$qc_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qc_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$qc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fqcview = currentForm = new ew.Form("fqcview", "view");

// Form_CustomValidate event
fqcview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqcview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqcview.lists["x_location"] = <?php echo $qc_view->location->Lookup->toClientList() ?>;
fqcview.lists["x_location"].options = <?php echo JsonEncode($qc_view->location->lookupOptions()) ?>;
fqcview.lists["x_qc_stage"] = <?php echo $qc_view->qc_stage->Lookup->toClientList() ?>;
fqcview.lists["x_qc_stage"].options = <?php echo JsonEncode($qc_view->qc_stage->lookupOptions()) ?>;
fqcview.lists["x_defect_nature"] = <?php echo $qc_view->defect_nature->Lookup->toClientList() ?>;
fqcview.lists["x_defect_nature"].options = <?php echo JsonEncode($qc_view->defect_nature->lookupOptions()) ?>;
fqcview.lists["x_defect_percentage"] = <?php echo $qc_view->defect_percentage->Lookup->toClientList() ?>;
fqcview.lists["x_defect_percentage"].options = <?php echo JsonEncode($qc_view->defect_percentage->lookupOptions()) ?>;
fqcview.lists["x_status"] = <?php echo $qc_view->status->Lookup->toClientList() ?>;
fqcview.lists["x_status"].options = <?php echo JsonEncode($qc_view->status->lookupOptions()) ?>;
fqcview.lists["x_operator"] = <?php echo $qc_view->operator->Lookup->toClientList() ?>;
fqcview.lists["x_operator"].options = <?php echo JsonEncode($qc_view->operator->lookupOptions()) ?>;
fqcview.lists["x_e_operator"] = <?php echo $qc_view->e_operator->Lookup->toClientList() ?>;
fqcview.lists["x_e_operator"].options = <?php echo JsonEncode($qc_view->e_operator->lookupOptions()) ?>;
fqcview.lists["x_a_operator"] = <?php echo $qc_view->a_operator->Lookup->toClientList() ?>;
fqcview.lists["x_a_operator"].options = <?php echo JsonEncode($qc_view->a_operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$qc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $qc_view->ExportOptions->render("body") ?>
<?php $qc_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $qc_view->showPageHeader(); ?>
<?php
$qc_view->showMessage();
?>
<form name="fqcview" id="fqcview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qc_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qc_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qc">
<input type="hidden" name="modal" value="<?php echo (int)$qc_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($qc->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_id"><?php echo $qc->id->caption() ?></span></td>
		<td data-name="id"<?php echo $qc->id->cellAttributes() ?>>
<span id="el_qc_id">
<span<?php echo $qc->id->viewAttributes() ?>>
<?php echo $qc->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->location->Visible) { // location ?>
	<tr id="r_location">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_location"><?php echo $qc->location->caption() ?></span></td>
		<td data-name="location"<?php echo $qc->location->cellAttributes() ?>>
<span id="el_qc_location">
<span<?php echo $qc->location->viewAttributes() ?>>
<?php echo $qc->location->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->qc_stage->Visible) { // qc_stage ?>
	<tr id="r_qc_stage">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_qc_stage"><?php echo $qc->qc_stage->caption() ?></span></td>
		<td data-name="qc_stage"<?php echo $qc->qc_stage->cellAttributes() ?>>
<span id="el_qc_qc_stage">
<span<?php echo $qc->qc_stage->viewAttributes() ?>>
<?php echo $qc->qc_stage->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->_barcode->Visible) { // barcode ?>
	<tr id="r__barcode">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc__barcode"><?php echo $qc->_barcode->caption() ?></span></td>
		<td data-name="_barcode"<?php echo $qc->_barcode->cellAttributes() ?>>
<span id="el_qc__barcode">
<span<?php echo $qc->_barcode->viewAttributes() ?>>
<?php echo $qc->_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->lines_in_30cm->Visible) { // lines_in_30cm ?>
	<tr id="r_lines_in_30cm">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_lines_in_30cm"><?php echo $qc->lines_in_30cm->caption() ?></span></td>
		<td data-name="lines_in_30cm"<?php echo $qc->lines_in_30cm->cellAttributes() ?>>
<span id="el_qc_lines_in_30cm">
<span<?php echo $qc->lines_in_30cm->viewAttributes() ?>>
<?php echo $qc->lines_in_30cm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->size_actual->Visible) { // size_actual ?>
	<tr id="r_size_actual">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_size_actual"><?php echo $qc->size_actual->caption() ?></span></td>
		<td data-name="size_actual"<?php echo $qc->size_actual->cellAttributes() ?>>
<span id="el_qc_size_actual">
<span<?php echo $qc->size_actual->viewAttributes() ?>>
<?php echo $qc->size_actual->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->weight_actual->Visible) { // weight_actual ?>
	<tr id="r_weight_actual">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_weight_actual"><?php echo $qc->weight_actual->caption() ?></span></td>
		<td data-name="weight_actual"<?php echo $qc->weight_actual->cellAttributes() ?>>
<span id="el_qc_weight_actual">
<span<?php echo $qc->weight_actual->viewAttributes() ?>>
<?php echo $qc->weight_actual->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->defect_nature->Visible) { // defect_nature ?>
	<tr id="r_defect_nature">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_defect_nature"><?php echo $qc->defect_nature->caption() ?></span></td>
		<td data-name="defect_nature"<?php echo $qc->defect_nature->cellAttributes() ?>>
<span id="el_qc_defect_nature">
<span<?php echo $qc->defect_nature->viewAttributes() ?>>
<?php echo $qc->defect_nature->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->defect_percentage->Visible) { // defect_percentage ?>
	<tr id="r_defect_percentage">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_defect_percentage"><?php echo $qc->defect_percentage->caption() ?></span></td>
		<td data-name="defect_percentage"<?php echo $qc->defect_percentage->cellAttributes() ?>>
<span id="el_qc_defect_percentage">
<span<?php echo $qc->defect_percentage->viewAttributes() ?>>
<?php echo $qc->defect_percentage->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->deduction->Visible) { // deduction ?>
	<tr id="r_deduction">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_deduction"><?php echo $qc->deduction->caption() ?></span></td>
		<td data-name="deduction"<?php echo $qc->deduction->cellAttributes() ?>>
<span id="el_qc_deduction">
<span<?php echo $qc->deduction->viewAttributes() ?>>
<?php echo $qc->deduction->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->comments->Visible) { // comments ?>
	<tr id="r_comments">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_comments"><?php echo $qc->comments->caption() ?></span></td>
		<td data-name="comments"<?php echo $qc->comments->cellAttributes() ?>>
<span id="el_qc_comments">
<span<?php echo $qc->comments->viewAttributes() ?>>
<?php echo $qc->comments->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_status"><?php echo $qc->status->caption() ?></span></td>
		<td data-name="status"<?php echo $qc->status->cellAttributes() ?>>
<span id="el_qc_status">
<span<?php echo $qc->status->viewAttributes() ?>>
<?php echo $qc->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_operator"><?php echo $qc->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $qc->operator->cellAttributes() ?>>
<span id="el_qc_operator">
<span<?php echo $qc->operator->viewAttributes() ?>>
<?php echo $qc->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_datetime"><?php echo $qc->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $qc->datetime->cellAttributes() ?>>
<span id="el_qc_datetime">
<span<?php echo $qc->datetime->viewAttributes() ?>>
<?php echo $qc->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->e_operator->Visible) { // e_operator ?>
	<tr id="r_e_operator">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_e_operator"><?php echo $qc->e_operator->caption() ?></span></td>
		<td data-name="e_operator"<?php echo $qc->e_operator->cellAttributes() ?>>
<span id="el_qc_e_operator">
<span<?php echo $qc->e_operator->viewAttributes() ?>>
<?php echo $qc->e_operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->e_datetime->Visible) { // e_datetime ?>
	<tr id="r_e_datetime">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_e_datetime"><?php echo $qc->e_datetime->caption() ?></span></td>
		<td data-name="e_datetime"<?php echo $qc->e_datetime->cellAttributes() ?>>
<span id="el_qc_e_datetime">
<span<?php echo $qc->e_datetime->viewAttributes() ?>>
<?php echo $qc->e_datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->_action->Visible) { // action ?>
	<tr id="r__action">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc__action"><?php echo $qc->_action->caption() ?></span></td>
		<td data-name="_action"<?php echo $qc->_action->cellAttributes() ?>>
<span id="el_qc__action">
<span<?php echo $qc->_action->viewAttributes() ?>>
<?php echo $qc->_action->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_remarks"><?php echo $qc->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $qc->remarks->cellAttributes() ?>>
<span id="el_qc_remarks">
<span<?php echo $qc->remarks->viewAttributes() ?>>
<?php echo $qc->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->design->Visible) { // design ?>
	<tr id="r_design">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_design"><?php echo $qc->design->caption() ?></span></td>
		<td data-name="design"<?php echo $qc->design->cellAttributes() ?>>
<span id="el_qc_design">
<span<?php echo $qc->design->viewAttributes() ?>>
<?php echo $qc->design->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->size->Visible) { // size ?>
	<tr id="r_size">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_size"><?php echo $qc->size->caption() ?></span></td>
		<td data-name="size"<?php echo $qc->size->cellAttributes() ?>>
<span id="el_qc_size">
<span<?php echo $qc->size->viewAttributes() ?>>
<?php echo $qc->size->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->a_operator->Visible) { // a_operator ?>
	<tr id="r_a_operator">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_a_operator"><?php echo $qc->a_operator->caption() ?></span></td>
		<td data-name="a_operator"<?php echo $qc->a_operator->cellAttributes() ?>>
<span id="el_qc_a_operator">
<span<?php echo $qc->a_operator->viewAttributes() ?>>
<?php echo $qc->a_operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->a_datetime->Visible) { // a_datetime ?>
	<tr id="r_a_datetime">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_a_datetime"><?php echo $qc->a_datetime->caption() ?></span></td>
		<td data-name="a_datetime"<?php echo $qc->a_datetime->cellAttributes() ?>>
<span id="el_qc_a_datetime">
<span<?php echo $qc->a_datetime->viewAttributes() ?>>
<?php echo $qc->a_datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->bcode_status->Visible) { // bcode_status ?>
	<tr id="r_bcode_status">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_bcode_status"><?php echo $qc->bcode_status->caption() ?></span></td>
		<td data-name="bcode_status"<?php echo $qc->bcode_status->cellAttributes() ?>>
<span id="el_qc_bcode_status">
<span<?php echo $qc->bcode_status->viewAttributes() ?>>
<?php echo $qc->bcode_status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qc->product_image->Visible) { // product_image ?>
	<tr id="r_product_image">
		<td class="<?php echo $qc_view->TableLeftColumnClass ?>"><span id="elh_qc_product_image"><?php echo $qc->product_image->caption() ?></span></td>
		<td data-name="product_image"<?php echo $qc->product_image->cellAttributes() ?>>
<span id="el_qc_product_image">
<span<?php echo $qc->product_image->viewAttributes() ?>>
<?php echo $qc->product_image->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$qc_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$qc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$qc_view->terminate();
?>