<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qpb_setup_add = new qpb_setup_add();

// Run the page
$qpb_setup_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qpb_setup_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fqpb_setupadd = currentForm = new ew.Form("fqpb_setupadd", "add");

// Validate form
fqpb_setupadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($qpb_setup_add->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qpb_setup->id->caption(), $qpb_setup->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($qpb_setup->id->errorMessage()) ?>");
		<?php if ($qpb_setup_add->buyer->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qpb_setup->buyer->caption(), $qpb_setup->buyer->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qpb_setup_add->refresh->Required) { ?>
			elm = this.getElements("x" + infix + "_refresh");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qpb_setup->refresh->caption(), $qpb_setup->refresh->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_refresh");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($qpb_setup->refresh->errorMessage()) ?>");
		<?php if ($qpb_setup_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qpb_setup->operator->caption(), $qpb_setup->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qpb_setup_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qpb_setup->datetime->caption(), $qpb_setup->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fqpb_setupadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqpb_setupadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqpb_setupadd.lists["x_buyer"] = <?php echo $qpb_setup_add->buyer->Lookup->toClientList() ?>;
fqpb_setupadd.lists["x_buyer"].options = <?php echo JsonEncode($qpb_setup_add->buyer->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $qpb_setup_add->showPageHeader(); ?>
<?php
$qpb_setup_add->showMessage();
?>
<form name="fqpb_setupadd" id="fqpb_setupadd" class="<?php echo $qpb_setup_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qpb_setup_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qpb_setup_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qpb_setup">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$qpb_setup_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($qpb_setup->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_qpb_setup_id" for="x_id" class="<?php echo $qpb_setup_add->LeftColumnClass ?>"><?php echo $qpb_setup->id->caption() ?><?php echo ($qpb_setup->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qpb_setup_add->RightColumnClass ?>"><div<?php echo $qpb_setup->id->cellAttributes() ?>>
<span id="el_qpb_setup_id">
<input type="text" data-table="qpb_setup" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($qpb_setup->id->getPlaceHolder()) ?>" value="<?php echo $qpb_setup->id->EditValue ?>"<?php echo $qpb_setup->id->editAttributes() ?>>
</span>
<?php echo $qpb_setup->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qpb_setup->buyer->Visible) { // buyer ?>
	<div id="r_buyer" class="form-group row">
		<label id="elh_qpb_setup_buyer" for="x_buyer" class="<?php echo $qpb_setup_add->LeftColumnClass ?>"><?php echo $qpb_setup->buyer->caption() ?><?php echo ($qpb_setup->buyer->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qpb_setup_add->RightColumnClass ?>"><div<?php echo $qpb_setup->buyer->cellAttributes() ?>>
<span id="el_qpb_setup_buyer">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qpb_setup" data-field="x_buyer" data-value-separator="<?php echo $qpb_setup->buyer->displayValueSeparatorAttribute() ?>" id="x_buyer" name="x_buyer"<?php echo $qpb_setup->buyer->editAttributes() ?>>
		<?php echo $qpb_setup->buyer->selectOptionListHtml("x_buyer") ?>
	</select>
</div>
<?php echo $qpb_setup->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
<?php echo $qpb_setup->buyer->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qpb_setup->refresh->Visible) { // refresh ?>
	<div id="r_refresh" class="form-group row">
		<label id="elh_qpb_setup_refresh" for="x_refresh" class="<?php echo $qpb_setup_add->LeftColumnClass ?>"><?php echo $qpb_setup->refresh->caption() ?><?php echo ($qpb_setup->refresh->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qpb_setup_add->RightColumnClass ?>"><div<?php echo $qpb_setup->refresh->cellAttributes() ?>>
<span id="el_qpb_setup_refresh">
<input type="text" data-table="qpb_setup" data-field="x_refresh" name="x_refresh" id="x_refresh" size="30" placeholder="<?php echo HtmlEncode($qpb_setup->refresh->getPlaceHolder()) ?>" value="<?php echo $qpb_setup->refresh->EditValue ?>"<?php echo $qpb_setup->refresh->editAttributes() ?>>
</span>
<?php echo $qpb_setup->refresh->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$qpb_setup_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $qpb_setup_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $qpb_setup_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$qpb_setup_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$qpb_setup_add->terminate();
?>