<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qpb_setup_edit = new qpb_setup_edit();

// Run the page
$qpb_setup_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qpb_setup_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fqpb_setupedit = currentForm = new ew.Form("fqpb_setupedit", "edit");

// Validate form
fqpb_setupedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($qpb_setup_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qpb_setup->id->caption(), $qpb_setup->id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($qpb_setup->id->errorMessage()) ?>");
		<?php if ($qpb_setup_edit->buyer->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qpb_setup->buyer->caption(), $qpb_setup->buyer->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qpb_setup_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qpb_setup->operator->caption(), $qpb_setup->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($qpb_setup_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $qpb_setup->datetime->caption(), $qpb_setup->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fqpb_setupedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqpb_setupedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqpb_setupedit.lists["x_buyer"] = <?php echo $qpb_setup_edit->buyer->Lookup->toClientList() ?>;
fqpb_setupedit.lists["x_buyer"].options = <?php echo JsonEncode($qpb_setup_edit->buyer->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $qpb_setup_edit->showPageHeader(); ?>
<?php
$qpb_setup_edit->showMessage();
?>
<form name="fqpb_setupedit" id="fqpb_setupedit" class="<?php echo $qpb_setup_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qpb_setup_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qpb_setup_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qpb_setup">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$qpb_setup_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($qpb_setup->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_qpb_setup_id" for="x_id" class="<?php echo $qpb_setup_edit->LeftColumnClass ?>"><?php echo $qpb_setup->id->caption() ?><?php echo ($qpb_setup->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qpb_setup_edit->RightColumnClass ?>"><div<?php echo $qpb_setup->id->cellAttributes() ?>>
<span id="el_qpb_setup_id">
<span<?php echo $qpb_setup->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($qpb_setup->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="qpb_setup" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($qpb_setup->id->CurrentValue) ?>">
<?php echo $qpb_setup->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($qpb_setup->buyer->Visible) { // buyer ?>
	<div id="r_buyer" class="form-group row">
		<label id="elh_qpb_setup_buyer" for="x_buyer" class="<?php echo $qpb_setup_edit->LeftColumnClass ?>"><?php echo $qpb_setup->buyer->caption() ?><?php echo ($qpb_setup->buyer->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $qpb_setup_edit->RightColumnClass ?>"><div<?php echo $qpb_setup->buyer->cellAttributes() ?>>
<span id="el_qpb_setup_buyer">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="qpb_setup" data-field="x_buyer" data-value-separator="<?php echo $qpb_setup->buyer->displayValueSeparatorAttribute() ?>" id="x_buyer" name="x_buyer"<?php echo $qpb_setup->buyer->editAttributes() ?>>
		<?php echo $qpb_setup->buyer->selectOptionListHtml("x_buyer") ?>
	</select>
</div>
<?php echo $qpb_setup->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
<?php echo $qpb_setup->buyer->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$qpb_setup_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $qpb_setup_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $qpb_setup_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$qpb_setup_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$qpb_setup_edit->terminate();
?>