<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$qpb_setup_view = new qpb_setup_view();

// Run the page
$qpb_setup_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$qpb_setup_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$qpb_setup->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fqpb_setupview = currentForm = new ew.Form("fqpb_setupview", "view");

// Form_CustomValidate event
fqpb_setupview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fqpb_setupview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fqpb_setupview.lists["x_buyer"] = <?php echo $qpb_setup_view->buyer->Lookup->toClientList() ?>;
fqpb_setupview.lists["x_buyer"].options = <?php echo JsonEncode($qpb_setup_view->buyer->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$qpb_setup->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $qpb_setup_view->ExportOptions->render("body") ?>
<?php $qpb_setup_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $qpb_setup_view->showPageHeader(); ?>
<?php
$qpb_setup_view->showMessage();
?>
<form name="fqpb_setupview" id="fqpb_setupview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($qpb_setup_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $qpb_setup_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="qpb_setup">
<input type="hidden" name="modal" value="<?php echo (int)$qpb_setup_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($qpb_setup->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $qpb_setup_view->TableLeftColumnClass ?>"><span id="elh_qpb_setup_id"><?php echo $qpb_setup->id->caption() ?></span></td>
		<td data-name="id"<?php echo $qpb_setup->id->cellAttributes() ?>>
<span id="el_qpb_setup_id">
<span<?php echo $qpb_setup->id->viewAttributes() ?>>
<?php echo $qpb_setup->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qpb_setup->buyer->Visible) { // buyer ?>
	<tr id="r_buyer">
		<td class="<?php echo $qpb_setup_view->TableLeftColumnClass ?>"><span id="elh_qpb_setup_buyer"><?php echo $qpb_setup->buyer->caption() ?></span></td>
		<td data-name="buyer"<?php echo $qpb_setup->buyer->cellAttributes() ?>>
<span id="el_qpb_setup_buyer">
<span<?php echo $qpb_setup->buyer->viewAttributes() ?>>
<?php echo $qpb_setup->buyer->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qpb_setup->refresh->Visible) { // refresh ?>
	<tr id="r_refresh">
		<td class="<?php echo $qpb_setup_view->TableLeftColumnClass ?>"><span id="elh_qpb_setup_refresh"><?php echo $qpb_setup->refresh->caption() ?></span></td>
		<td data-name="refresh"<?php echo $qpb_setup->refresh->cellAttributes() ?>>
<span id="el_qpb_setup_refresh">
<span<?php echo $qpb_setup->refresh->viewAttributes() ?>>
<?php echo $qpb_setup->refresh->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qpb_setup->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $qpb_setup_view->TableLeftColumnClass ?>"><span id="elh_qpb_setup_operator"><?php echo $qpb_setup->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $qpb_setup->operator->cellAttributes() ?>>
<span id="el_qpb_setup_operator">
<span<?php echo $qpb_setup->operator->viewAttributes() ?>>
<?php echo $qpb_setup->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($qpb_setup->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $qpb_setup_view->TableLeftColumnClass ?>"><span id="elh_qpb_setup_datetime"><?php echo $qpb_setup->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $qpb_setup->datetime->cellAttributes() ?>>
<span id="el_qpb_setup_datetime">
<span<?php echo $qpb_setup->datetime->viewAttributes() ?>>
<?php echo $qpb_setup->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$qpb_setup_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$qpb_setup->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$qpb_setup_view->terminate();
?>