<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$query_oms_2_list = new query_oms_2_list();

// Run the page
$query_oms_2_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$query_oms_2_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$query_oms_2->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fquery_oms_2list = currentForm = new ew.Form("fquery_oms_2list", "list");
fquery_oms_2list.formKeyCountName = '<?php echo $query_oms_2_list->FormKeyCountName ?>';

// Form_CustomValidate event
fquery_oms_2list.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fquery_oms_2list.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fquery_oms_2list.lists["x_buyers_id"] = <?php echo $query_oms_2_list->buyers_id->Lookup->toClientList() ?>;
fquery_oms_2list.lists["x_buyers_id"].options = <?php echo JsonEncode($query_oms_2_list->buyers_id->lookupOptions()) ?>;
fquery_oms_2list.lists["x_reports_to"] = <?php echo $query_oms_2_list->reports_to->Lookup->toClientList() ?>;
fquery_oms_2list.lists["x_reports_to"].options = <?php echo JsonEncode($query_oms_2_list->reports_to->lookupOptions()) ?>;
fquery_oms_2list.lists["x_order_week"] = <?php echo $query_oms_2_list->order_week->Lookup->toClientList() ?>;
fquery_oms_2list.lists["x_order_week"].options = <?php echo JsonEncode($query_oms_2_list->order_week->lookupOptions()) ?>;
fquery_oms_2list.lists["x_category"] = <?php echo $query_oms_2_list->category->Lookup->toClientList() ?>;
fquery_oms_2list.lists["x_category"].options = <?php echo JsonEncode($query_oms_2_list->category->lookupOptions()) ?>;
fquery_oms_2list.lists["x_current_works"] = <?php echo $query_oms_2_list->current_works->Lookup->toClientList() ?>;
fquery_oms_2list.lists["x_current_works"].options = <?php echo JsonEncode($query_oms_2_list->current_works->lookupOptions()) ?>;
fquery_oms_2list.lists["x_ex_factory"] = <?php echo $query_oms_2_list->ex_factory->Lookup->toClientList() ?>;
fquery_oms_2list.lists["x_ex_factory"].options = <?php echo JsonEncode($query_oms_2_list->ex_factory->lookupOptions()) ?>;
fquery_oms_2list.lists["x_status[]"] = <?php echo $query_oms_2_list->status->Lookup->toClientList() ?>;
fquery_oms_2list.lists["x_status[]"].options = <?php echo JsonEncode($query_oms_2_list->status->lookupOptions()) ?>;
fquery_oms_2list.lists["x_completed[]"] = <?php echo $query_oms_2_list->completed->Lookup->toClientList() ?>;
fquery_oms_2list.lists["x_completed[]"].options = <?php echo JsonEncode($query_oms_2_list->completed->options(FALSE, TRUE)) ?>;

// Form object for search
var fquery_oms_2listsrch = currentSearchForm = new ew.Form("fquery_oms_2listsrch");

// Validate function for search
fquery_oms_2listsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms_2->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_width");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms_2->width->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_length");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms_2->length->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fquery_oms_2listsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fquery_oms_2listsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fquery_oms_2listsrch.lists["x_buyers_id"] = <?php echo $query_oms_2_list->buyers_id->Lookup->toClientList() ?>;
fquery_oms_2listsrch.lists["x_buyers_id"].options = <?php echo JsonEncode($query_oms_2_list->buyers_id->lookupOptions()) ?>;
fquery_oms_2listsrch.lists["x_category"] = <?php echo $query_oms_2_list->category->Lookup->toClientList() ?>;
fquery_oms_2listsrch.lists["x_category"].options = <?php echo JsonEncode($query_oms_2_list->category->lookupOptions()) ?>;
fquery_oms_2listsrch.lists["x_current_works"] = <?php echo $query_oms_2_list->current_works->Lookup->toClientList() ?>;
fquery_oms_2listsrch.lists["x_current_works"].options = <?php echo JsonEncode($query_oms_2_list->current_works->lookupOptions()) ?>;

// Filters
fquery_oms_2listsrch.filterList = <?php echo $query_oms_2_list->getFilterList() ?>;

// Init search panel as collapsed
fquery_oms_2listsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$query_oms_2->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($query_oms_2_list->TotalRecs > 0 && $query_oms_2_list->ExportOptions->visible()) { ?>
<?php $query_oms_2_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($query_oms_2_list->ImportOptions->visible()) { ?>
<?php $query_oms_2_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($query_oms_2_list->SearchOptions->visible()) { ?>
<?php $query_oms_2_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($query_oms_2_list->FilterOptions->visible()) { ?>
<?php $query_oms_2_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$query_oms_2_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$query_oms_2->isExport() && !$query_oms_2->CurrentAction) { ?>
<form name="fquery_oms_2listsrch" id="fquery_oms_2listsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($query_oms_2_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fquery_oms_2listsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="query_oms_2">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$query_oms_2_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$query_oms_2->RowType = ROWTYPE_SEARCH;

// Render row
$query_oms_2->resetAttributes();
$query_oms_2_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($query_oms_2->buyers_id->Visible) { // buyers_id ?>
	<div id="xsc_buyers_id" class="ew-cell form-group">
		<label for="x_buyers_id" class="ew-search-caption ew-label"><?php echo $query_oms_2->buyers_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_oms_2" data-field="x_buyers_id" data-value-separator="<?php echo $query_oms_2->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $query_oms_2->buyers_id->editAttributes() ?>>
		<?php echo $query_oms_2->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $query_oms_2->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($query_oms_2->category->Visible) { // category ?>
	<div id="xsc_category" class="ew-cell form-group">
		<label for="x_category" class="ew-search-caption ew-label"><?php echo $query_oms_2->category->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_category" id="z_category" value="LIKE"></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_oms_2" data-field="x_category" data-value-separator="<?php echo $query_oms_2->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $query_oms_2->category->editAttributes() ?>>
		<?php echo $query_oms_2->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $query_oms_2->category->Lookup->getParamTag("p_x_category") ?>
</span>
	</div>
<?php } ?>
<?php if ($query_oms_2->current_works->Visible) { // current_works ?>
	<div id="xsc_current_works" class="ew-cell form-group">
		<label for="x_current_works" class="ew-search-caption ew-label"><?php echo $query_oms_2->current_works->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_current_works" id="z_current_works" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_oms_2" data-field="x_current_works" data-value-separator="<?php echo $query_oms_2->current_works->displayValueSeparatorAttribute() ?>" id="x_current_works" name="x_current_works"<?php echo $query_oms_2->current_works->editAttributes() ?>>
		<?php echo $query_oms_2->current_works->selectOptionListHtml("x_current_works") ?>
	</select>
</div>
<?php echo $query_oms_2->current_works->Lookup->getParamTag("p_x_current_works") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($query_oms_2->buyer_order->Visible) { // buyer_order ?>
	<div id="xsc_buyer_order" class="ew-cell form-group">
		<label for="x_buyer_order" class="ew-search-caption ew-label"><?php echo $query_oms_2->buyer_order->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_order" id="z_buyer_order" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="query_oms_2" data-field="x_buyer_order" name="x_buyer_order" id="x_buyer_order" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($query_oms_2->buyer_order->getPlaceHolder()) ?>" value="<?php echo $query_oms_2->buyer_order->EditValue ?>"<?php echo $query_oms_2->buyer_order->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($query_oms_2->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $query_oms_2->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($query_oms_2->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($query_oms_2->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($query_oms_2->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($query_oms_2->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($query_oms_2->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($query_oms_2->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($query_oms_2->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($query_oms_2->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($query_oms_2->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="query_oms_2" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($query_oms_2->po->getPlaceHolder()) ?>" value="<?php echo $query_oms_2->po->EditValue ?>"<?php echo $query_oms_2->po->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<input type="text" data-table="query_oms_2" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($query_oms_2->po->getPlaceHolder()) ?>" value="<?php echo $query_oms_2->po->EditValue2 ?>"<?php echo $query_oms_2->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($query_oms_2->design->Visible) { // design ?>
	<div id="xsc_design" class="ew-cell form-group">
		<label for="x_design" class="ew-search-caption ew-label"><?php echo $query_oms_2->design->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design" id="z_design" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="query_oms_2" data-field="x_design" name="x_design" id="x_design" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($query_oms_2->design->getPlaceHolder()) ?>" value="<?php echo $query_oms_2->design->EditValue ?>"<?php echo $query_oms_2->design->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($query_oms_2->width->Visible) { // width ?>
	<div id="xsc_width" class="ew-cell form-group">
		<label for="x_width" class="ew-search-caption ew-label"><?php echo $query_oms_2->width->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_width" id="z_width" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="query_oms_2" data-field="x_width" name="x_width" id="x_width" size="30" placeholder="<?php echo HtmlEncode($query_oms_2->width->getPlaceHolder()) ?>" value="<?php echo $query_oms_2->width->EditValue ?>"<?php echo $query_oms_2->width->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($query_oms_2->length->Visible) { // length ?>
	<div id="xsc_length" class="ew-cell form-group">
		<label for="x_length" class="ew-search-caption ew-label"><?php echo $query_oms_2->length->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_length" id="z_length" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="query_oms_2" data-field="x_length" name="x_length" id="x_length" size="30" placeholder="<?php echo HtmlEncode($query_oms_2->length->getPlaceHolder()) ?>" value="<?php echo $query_oms_2->length->EditValue ?>"<?php echo $query_oms_2->length->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($query_oms_2_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($query_oms_2_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $query_oms_2_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($query_oms_2_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($query_oms_2_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($query_oms_2_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($query_oms_2_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $query_oms_2_list->showPageHeader(); ?>
<?php
$query_oms_2_list->showMessage();
?>
<?php if ($query_oms_2_list->TotalRecs > 0 || $query_oms_2->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($query_oms_2_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> query_oms_2">
<?php if (!$query_oms_2->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$query_oms_2->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($query_oms_2_list->Pager)) $query_oms_2_list->Pager = new PrevNextPager($query_oms_2_list->StartRec, $query_oms_2_list->DisplayRecs, $query_oms_2_list->TotalRecs, $query_oms_2_list->AutoHidePager) ?>
<?php if ($query_oms_2_list->Pager->RecordCount > 0 && $query_oms_2_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($query_oms_2_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $query_oms_2_list->pageUrl() ?>start=<?php echo $query_oms_2_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($query_oms_2_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $query_oms_2_list->pageUrl() ?>start=<?php echo $query_oms_2_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $query_oms_2_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($query_oms_2_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $query_oms_2_list->pageUrl() ?>start=<?php echo $query_oms_2_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($query_oms_2_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $query_oms_2_list->pageUrl() ?>start=<?php echo $query_oms_2_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $query_oms_2_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($query_oms_2_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $query_oms_2_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $query_oms_2_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $query_oms_2_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($query_oms_2_list->TotalRecs > 0 && (!$query_oms_2_list->AutoHidePageSizeSelector || $query_oms_2_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="query_oms_2">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($query_oms_2_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($query_oms_2_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($query_oms_2_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($query_oms_2_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($query_oms_2_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($query_oms_2->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $query_oms_2_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fquery_oms_2list" id="fquery_oms_2list" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($query_oms_2_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $query_oms_2_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="query_oms_2">
<div id="gmp_query_oms_2" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($query_oms_2_list->TotalRecs > 0 || $query_oms_2->isGridEdit()) { ?>
<table id="tbl_query_oms_2list" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$query_oms_2_list->RowType = ROWTYPE_HEADER;

// Render list options
$query_oms_2_list->renderListOptions();

// Render list options (header, left)
$query_oms_2_list->ListOptions->render("header", "left");
?>
<?php if ($query_oms_2->id->Visible) { // id ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->id) == "") { ?>
		<th data-name="id" class="<?php echo $query_oms_2->id->headerCellClass() ?>"><div id="elh_query_oms_2_id" class="query_oms_2_id"><div class="ew-table-header-caption"><?php echo $query_oms_2->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $query_oms_2->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->id) ?>',2);"><div id="elh_query_oms_2_id" class="query_oms_2_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->buyers_id->Visible) { // buyers_id ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->buyers_id) == "") { ?>
		<th data-name="buyers_id" class="<?php echo $query_oms_2->buyers_id->headerCellClass() ?>"><div id="elh_query_oms_2_buyers_id" class="query_oms_2_buyers_id"><div class="ew-table-header-caption"><?php echo $query_oms_2->buyers_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyers_id" class="<?php echo $query_oms_2->buyers_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->buyers_id) ?>',2);"><div id="elh_query_oms_2_buyers_id" class="query_oms_2_buyers_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->buyers_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->buyers_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->buyers_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->reports_to->Visible) { // reports_to ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->reports_to) == "") { ?>
		<th data-name="reports_to" class="<?php echo $query_oms_2->reports_to->headerCellClass() ?>"><div id="elh_query_oms_2_reports_to" class="query_oms_2_reports_to"><div class="ew-table-header-caption"><?php echo $query_oms_2->reports_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reports_to" class="<?php echo $query_oms_2->reports_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->reports_to) ?>',2);"><div id="elh_query_oms_2_reports_to" class="query_oms_2_reports_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->reports_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->reports_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->reports_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->order_week->Visible) { // order_week ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->order_week) == "") { ?>
		<th data-name="order_week" class="<?php echo $query_oms_2->order_week->headerCellClass() ?>"><div id="elh_query_oms_2_order_week" class="query_oms_2_order_week"><div class="ew-table-header-caption"><?php echo $query_oms_2->order_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_week" class="<?php echo $query_oms_2->order_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->order_week) ?>',2);"><div id="elh_query_oms_2_order_week" class="query_oms_2_order_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->order_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->order_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->order_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->order_date->Visible) { // order_date ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->order_date) == "") { ?>
		<th data-name="order_date" class="<?php echo $query_oms_2->order_date->headerCellClass() ?>"><div id="elh_query_oms_2_order_date" class="query_oms_2_order_date"><div class="ew-table-header-caption"><?php echo $query_oms_2->order_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_date" class="<?php echo $query_oms_2->order_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->order_date) ?>',2);"><div id="elh_query_oms_2_order_date" class="query_oms_2_order_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->order_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->order_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->order_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->category->Visible) { // category ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->category) == "") { ?>
		<th data-name="category" class="<?php echo $query_oms_2->category->headerCellClass() ?>"><div id="elh_query_oms_2_category" class="query_oms_2_category"><div class="ew-table-header-caption"><?php echo $query_oms_2->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $query_oms_2->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->category) ?>',2);"><div id="elh_query_oms_2_category" class="query_oms_2_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->current_works->Visible) { // current_works ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->current_works) == "") { ?>
		<th data-name="current_works" class="<?php echo $query_oms_2->current_works->headerCellClass() ?>"><div id="elh_query_oms_2_current_works" class="query_oms_2_current_works"><div class="ew-table-header-caption"><?php echo $query_oms_2->current_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="current_works" class="<?php echo $query_oms_2->current_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->current_works) ?>',2);"><div id="elh_query_oms_2_current_works" class="query_oms_2_current_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->current_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->current_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->current_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->buyer_order->Visible) { // buyer_order ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->buyer_order) == "") { ?>
		<th data-name="buyer_order" class="<?php echo $query_oms_2->buyer_order->headerCellClass() ?>"><div id="elh_query_oms_2_buyer_order" class="query_oms_2_buyer_order"><div class="ew-table-header-caption"><?php echo $query_oms_2->buyer_order->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_order" class="<?php echo $query_oms_2->buyer_order->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->buyer_order) ?>',2);"><div id="elh_query_oms_2_buyer_order" class="query_oms_2_buyer_order">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->buyer_order->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->buyer_order->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->buyer_order->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->po->Visible) { // po ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->po) == "") { ?>
		<th data-name="po" class="<?php echo $query_oms_2->po->headerCellClass() ?>"><div id="elh_query_oms_2_po" class="query_oms_2_po"><div class="ew-table-header-caption"><?php echo $query_oms_2->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $query_oms_2->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->po) ?>',2);"><div id="elh_query_oms_2_po" class="query_oms_2_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->item->Visible) { // item ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->item) == "") { ?>
		<th data-name="item" class="<?php echo $query_oms_2->item->headerCellClass() ?>"><div id="elh_query_oms_2_item" class="query_oms_2_item"><div class="ew-table-header-caption"><?php echo $query_oms_2->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $query_oms_2->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->item) ?>',2);"><div id="elh_query_oms_2_item" class="query_oms_2_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->buyer_ref->Visible) { // buyer_ref ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->buyer_ref) == "") { ?>
		<th data-name="buyer_ref" class="<?php echo $query_oms_2->buyer_ref->headerCellClass() ?>"><div id="elh_query_oms_2_buyer_ref" class="query_oms_2_buyer_ref"><div class="ew-table-header-caption"><?php echo $query_oms_2->buyer_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_ref" class="<?php echo $query_oms_2->buyer_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->buyer_ref) ?>',2);"><div id="elh_query_oms_2_buyer_ref" class="query_oms_2_buyer_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->buyer_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->buyer_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->buyer_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->design->Visible) { // design ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->design) == "") { ?>
		<th data-name="design" class="<?php echo $query_oms_2->design->headerCellClass() ?>"><div id="elh_query_oms_2_design" class="query_oms_2_design"><div class="ew-table-header-caption"><?php echo $query_oms_2->design->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design" class="<?php echo $query_oms_2->design->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->design) ?>',2);"><div id="elh_query_oms_2_design" class="query_oms_2_design">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->design->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->design->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->design->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->size_buyer->Visible) { // size_buyer ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->size_buyer) == "") { ?>
		<th data-name="size_buyer" class="<?php echo $query_oms_2->size_buyer->headerCellClass() ?>"><div id="elh_query_oms_2_size_buyer" class="query_oms_2_size_buyer"><div class="ew-table-header-caption"><?php echo $query_oms_2->size_buyer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_buyer" class="<?php echo $query_oms_2->size_buyer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->size_buyer) ?>',2);"><div id="elh_query_oms_2_size_buyer" class="query_oms_2_size_buyer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->size_buyer->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->size_buyer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->size_buyer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->width->Visible) { // width ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->width) == "") { ?>
		<th data-name="width" class="<?php echo $query_oms_2->width->headerCellClass() ?>"><div id="elh_query_oms_2_width" class="query_oms_2_width"><div class="ew-table-header-caption"><?php echo $query_oms_2->width->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="width" class="<?php echo $query_oms_2->width->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->width) ?>',2);"><div id="elh_query_oms_2_width" class="query_oms_2_width">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->width->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->width->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->width->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->length->Visible) { // length ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->length) == "") { ?>
		<th data-name="length" class="<?php echo $query_oms_2->length->headerCellClass() ?>"><div id="elh_query_oms_2_length" class="query_oms_2_length"><div class="ew-table-header-caption"><?php echo $query_oms_2->length->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="length" class="<?php echo $query_oms_2->length->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->length) ?>',2);"><div id="elh_query_oms_2_length" class="query_oms_2_length">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->length->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->length->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->length->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->qty->Visible) { // qty ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->qty) == "") { ?>
		<th data-name="qty" class="<?php echo $query_oms_2->qty->headerCellClass() ?>"><div id="elh_query_oms_2_qty" class="query_oms_2_qty"><div class="ew-table-header-caption"><?php echo $query_oms_2->qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="qty" class="<?php echo $query_oms_2->qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->qty) ?>',2);"><div id="elh_query_oms_2_qty" class="query_oms_2_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->revised_qty->Visible) { // revised_qty ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->revised_qty) == "") { ?>
		<th data-name="revised_qty" class="<?php echo $query_oms_2->revised_qty->headerCellClass() ?>"><div id="elh_query_oms_2_revised_qty" class="query_oms_2_revised_qty"><div class="ew-table-header-caption"><?php echo $query_oms_2->revised_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="revised_qty" class="<?php echo $query_oms_2->revised_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->revised_qty) ?>',2);"><div id="elh_query_oms_2_revised_qty" class="query_oms_2_revised_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->revised_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->revised_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->revised_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->sqm->Visible) { // sqm ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $query_oms_2->sqm->headerCellClass() ?>"><div id="elh_query_oms_2_sqm" class="query_oms_2_sqm"><div class="ew-table-header-caption"><?php echo $query_oms_2->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $query_oms_2->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->sqm) ?>',2);"><div id="elh_query_oms_2_sqm" class="query_oms_2_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->ex_factory->Visible) { // ex_factory ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->ex_factory) == "") { ?>
		<th data-name="ex_factory" class="<?php echo $query_oms_2->ex_factory->headerCellClass() ?>"><div id="elh_query_oms_2_ex_factory" class="query_oms_2_ex_factory"><div class="ew-table-header-caption"><?php echo $query_oms_2->ex_factory->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ex_factory" class="<?php echo $query_oms_2->ex_factory->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->ex_factory) ?>',2);"><div id="elh_query_oms_2_ex_factory" class="query_oms_2_ex_factory">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->ex_factory->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->ex_factory->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->ex_factory->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->ex_factory_p->Visible) { // ex_factory_p ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->ex_factory_p) == "") { ?>
		<th data-name="ex_factory_p" class="<?php echo $query_oms_2->ex_factory_p->headerCellClass() ?>"><div id="elh_query_oms_2_ex_factory_p" class="query_oms_2_ex_factory_p"><div class="ew-table-header-caption"><?php echo $query_oms_2->ex_factory_p->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ex_factory_p" class="<?php echo $query_oms_2->ex_factory_p->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->ex_factory_p) ?>',2);"><div id="elh_query_oms_2_ex_factory_p" class="query_oms_2_ex_factory_p">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->ex_factory_p->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->ex_factory_p->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->ex_factory_p->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->shipping_mode->Visible) { // shipping_mode ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->shipping_mode) == "") { ?>
		<th data-name="shipping_mode" class="<?php echo $query_oms_2->shipping_mode->headerCellClass() ?>"><div id="elh_query_oms_2_shipping_mode" class="query_oms_2_shipping_mode"><div class="ew-table-header-caption"><?php echo $query_oms_2->shipping_mode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shipping_mode" class="<?php echo $query_oms_2->shipping_mode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->shipping_mode) ?>',2);"><div id="elh_query_oms_2_shipping_mode" class="query_oms_2_shipping_mode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->shipping_mode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->shipping_mode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->shipping_mode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->remarks->Visible) { // remarks ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $query_oms_2->remarks->headerCellClass() ?>"><div id="elh_query_oms_2_remarks" class="query_oms_2_remarks"><div class="ew-table-header-caption"><?php echo $query_oms_2->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $query_oms_2->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->remarks) ?>',2);"><div id="elh_query_oms_2_remarks" class="query_oms_2_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->d_qty->Visible) { // d_qty ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->d_qty) == "") { ?>
		<th data-name="d_qty" class="<?php echo $query_oms_2->d_qty->headerCellClass() ?>"><div id="elh_query_oms_2_d_qty" class="query_oms_2_d_qty"><div class="ew-table-header-caption"><?php echo $query_oms_2->d_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_qty" class="<?php echo $query_oms_2->d_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->d_qty) ?>',2);"><div id="elh_query_oms_2_d_qty" class="query_oms_2_d_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->d_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->d_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->d_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->pl_no->Visible) { // pl_no ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->pl_no) == "") { ?>
		<th data-name="pl_no" class="<?php echo $query_oms_2->pl_no->headerCellClass() ?>"><div id="elh_query_oms_2_pl_no" class="query_oms_2_pl_no"><div class="ew-table-header-caption"><?php echo $query_oms_2->pl_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pl_no" class="<?php echo $query_oms_2->pl_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->pl_no) ?>',2);"><div id="elh_query_oms_2_pl_no" class="query_oms_2_pl_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->pl_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->pl_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->pl_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->invoice_date->Visible) { // invoice_date ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->invoice_date) == "") { ?>
		<th data-name="invoice_date" class="<?php echo $query_oms_2->invoice_date->headerCellClass() ?>"><div id="elh_query_oms_2_invoice_date" class="query_oms_2_invoice_date"><div class="ew-table-header-caption"><?php echo $query_oms_2->invoice_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="invoice_date" class="<?php echo $query_oms_2->invoice_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->invoice_date) ?>',2);"><div id="elh_query_oms_2_invoice_date" class="query_oms_2_invoice_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->invoice_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->invoice_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->invoice_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->sailing_week->Visible) { // sailing_week ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->sailing_week) == "") { ?>
		<th data-name="sailing_week" class="<?php echo $query_oms_2->sailing_week->headerCellClass() ?>"><div id="elh_query_oms_2_sailing_week" class="query_oms_2_sailing_week"><div class="ew-table-header-caption"><?php echo $query_oms_2->sailing_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sailing_week" class="<?php echo $query_oms_2->sailing_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->sailing_week) ?>',2);"><div id="elh_query_oms_2_sailing_week" class="query_oms_2_sailing_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->sailing_week->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->sailing_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->sailing_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->pending->Visible) { // pending ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->pending) == "") { ?>
		<th data-name="pending" class="<?php echo $query_oms_2->pending->headerCellClass() ?>"><div id="elh_query_oms_2_pending" class="query_oms_2_pending"><div class="ew-table-header-caption"><?php echo $query_oms_2->pending->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending" class="<?php echo $query_oms_2->pending->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->pending) ?>',2);"><div id="elh_query_oms_2_pending" class="query_oms_2_pending">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->pending->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->pending->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->pending->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->pending_sqm->Visible) { // pending_sqm ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->pending_sqm) == "") { ?>
		<th data-name="pending_sqm" class="<?php echo $query_oms_2->pending_sqm->headerCellClass() ?>"><div id="elh_query_oms_2_pending_sqm" class="query_oms_2_pending_sqm"><div class="ew-table-header-caption"><?php echo $query_oms_2->pending_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending_sqm" class="<?php echo $query_oms_2->pending_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->pending_sqm) ?>',2);"><div id="elh_query_oms_2_pending_sqm" class="query_oms_2_pending_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->pending_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->pending_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->pending_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->cbm->Visible) { // cbm ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->cbm) == "") { ?>
		<th data-name="cbm" class="<?php echo $query_oms_2->cbm->headerCellClass() ?>"><div id="elh_query_oms_2_cbm" class="query_oms_2_cbm"><div class="ew-table-header-caption"><?php echo $query_oms_2->cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cbm" class="<?php echo $query_oms_2->cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->cbm) ?>',2);"><div id="elh_query_oms_2_cbm" class="query_oms_2_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->cbm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->total_cbm->Visible) { // total_cbm ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->total_cbm) == "") { ?>
		<th data-name="total_cbm" class="<?php echo $query_oms_2->total_cbm->headerCellClass() ?>"><div id="elh_query_oms_2_total_cbm" class="query_oms_2_total_cbm"><div class="ew-table-header-caption"><?php echo $query_oms_2->total_cbm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="total_cbm" class="<?php echo $query_oms_2->total_cbm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->total_cbm) ?>',2);"><div id="elh_query_oms_2_total_cbm" class="query_oms_2_total_cbm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->total_cbm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->total_cbm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->total_cbm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->offloom->Visible) { // offloom ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->offloom) == "") { ?>
		<th data-name="offloom" class="<?php echo $query_oms_2->offloom->headerCellClass() ?>"><div id="elh_query_oms_2_offloom" class="query_oms_2_offloom"><div class="ew-table-header-caption"><?php echo $query_oms_2->offloom->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="offloom" class="<?php echo $query_oms_2->offloom->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->offloom) ?>',2);"><div id="elh_query_oms_2_offloom" class="query_oms_2_offloom">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->offloom->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->offloom->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->offloom->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->status->Visible) { // status ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->status) == "") { ?>
		<th data-name="status" class="<?php echo $query_oms_2->status->headerCellClass() ?>"><div id="elh_query_oms_2_status" class="query_oms_2_status"><div class="ew-table-header-caption"><?php echo $query_oms_2->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $query_oms_2->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->status) ?>',2);"><div id="elh_query_oms_2_status" class="query_oms_2_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->rejection->Visible) { // rejection ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->rejection) == "") { ?>
		<th data-name="rejection" class="<?php echo $query_oms_2->rejection->headerCellClass() ?>"><div id="elh_query_oms_2_rejection" class="query_oms_2_rejection"><div class="ew-table-header-caption"><?php echo $query_oms_2->rejection->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rejection" class="<?php echo $query_oms_2->rejection->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->rejection) ?>',2);"><div id="elh_query_oms_2_rejection" class="query_oms_2_rejection">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->rejection->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->rejection->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->rejection->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->completed->Visible) { // completed ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->completed) == "") { ?>
		<th data-name="completed" class="<?php echo $query_oms_2->completed->headerCellClass() ?>"><div id="elh_query_oms_2_completed" class="query_oms_2_completed"><div class="ew-table-header-caption"><?php echo $query_oms_2->completed->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="completed" class="<?php echo $query_oms_2->completed->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->completed) ?>',2);"><div id="elh_query_oms_2_completed" class="query_oms_2_completed">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->completed->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->completed->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->completed->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->weaving_works->Visible) { // weaving_works ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->weaving_works) == "") { ?>
		<th data-name="weaving_works" class="<?php echo $query_oms_2->weaving_works->headerCellClass() ?>"><div id="elh_query_oms_2_weaving_works" class="query_oms_2_weaving_works"><div class="ew-table-header-caption"><?php echo $query_oms_2->weaving_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weaving_works" class="<?php echo $query_oms_2->weaving_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->weaving_works) ?>',2);"><div id="elh_query_oms_2_weaving_works" class="query_oms_2_weaving_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->weaving_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->weaving_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->weaving_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->cs->Visible) { // cs ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->cs) == "") { ?>
		<th data-name="cs" class="<?php echo $query_oms_2->cs->headerCellClass() ?>"><div id="elh_query_oms_2_cs" class="query_oms_2_cs"><div class="ew-table-header-caption"><?php echo $query_oms_2->cs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cs" class="<?php echo $query_oms_2->cs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->cs) ?>',2);"><div id="elh_query_oms_2_cs" class="query_oms_2_cs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->cs->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->cs->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->cs->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_oms_2->weight_sqm->Visible) { // weight_sqm ?>
	<?php if ($query_oms_2->sortUrl($query_oms_2->weight_sqm) == "") { ?>
		<th data-name="weight_sqm" class="<?php echo $query_oms_2->weight_sqm->headerCellClass() ?>"><div id="elh_query_oms_2_weight_sqm" class="query_oms_2_weight_sqm"><div class="ew-table-header-caption"><?php echo $query_oms_2->weight_sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weight_sqm" class="<?php echo $query_oms_2->weight_sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_oms_2->SortUrl($query_oms_2->weight_sqm) ?>',2);"><div id="elh_query_oms_2_weight_sqm" class="query_oms_2_weight_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_oms_2->weight_sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_oms_2->weight_sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_oms_2->weight_sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$query_oms_2_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($query_oms_2->ExportAll && $query_oms_2->isExport()) {
	$query_oms_2_list->StopRec = $query_oms_2_list->TotalRecs;
} else {

	// Set the last record to display
	if ($query_oms_2_list->TotalRecs > $query_oms_2_list->StartRec + $query_oms_2_list->DisplayRecs - 1)
		$query_oms_2_list->StopRec = $query_oms_2_list->StartRec + $query_oms_2_list->DisplayRecs - 1;
	else
		$query_oms_2_list->StopRec = $query_oms_2_list->TotalRecs;
}
$query_oms_2_list->RecCnt = $query_oms_2_list->StartRec - 1;
if ($query_oms_2_list->Recordset && !$query_oms_2_list->Recordset->EOF) {
	$query_oms_2_list->Recordset->moveFirst();
	$selectLimit = $query_oms_2_list->UseSelectLimit;
	if (!$selectLimit && $query_oms_2_list->StartRec > 1)
		$query_oms_2_list->Recordset->move($query_oms_2_list->StartRec - 1);
} elseif (!$query_oms_2->AllowAddDeleteRow && $query_oms_2_list->StopRec == 0) {
	$query_oms_2_list->StopRec = $query_oms_2->GridAddRowCount;
}

// Initialize aggregate
$query_oms_2->RowType = ROWTYPE_AGGREGATEINIT;
$query_oms_2->resetAttributes();
$query_oms_2_list->renderRow();
while ($query_oms_2_list->RecCnt < $query_oms_2_list->StopRec) {
	$query_oms_2_list->RecCnt++;
	if ($query_oms_2_list->RecCnt >= $query_oms_2_list->StartRec) {
		$query_oms_2_list->RowCnt++;

		// Set up key count
		$query_oms_2_list->KeyCount = $query_oms_2_list->RowIndex;

		// Init row class and style
		$query_oms_2->resetAttributes();
		$query_oms_2->CssClass = "";
		if ($query_oms_2->isGridAdd()) {
		} else {
			$query_oms_2_list->loadRowValues($query_oms_2_list->Recordset); // Load row values
		}
		$query_oms_2->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$query_oms_2->RowAttrs = array_merge($query_oms_2->RowAttrs, array('data-rowindex'=>$query_oms_2_list->RowCnt, 'id'=>'r' . $query_oms_2_list->RowCnt . '_query_oms_2', 'data-rowtype'=>$query_oms_2->RowType));

		// Render row
		$query_oms_2_list->renderRow();

		// Render list options
		$query_oms_2_list->renderListOptions();
?>
	<tr<?php echo $query_oms_2->rowAttributes() ?>>
<?php

// Render list options (body, left)
$query_oms_2_list->ListOptions->render("body", "left", $query_oms_2_list->RowCnt);
?>
	<?php if ($query_oms_2->id->Visible) { // id ?>
		<td data-name="id"<?php echo $query_oms_2->id->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_id" class="query_oms_2_id">
<span<?php echo $query_oms_2->id->viewAttributes() ?>>
<?php echo $query_oms_2->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id"<?php echo $query_oms_2->buyers_id->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_buyers_id" class="query_oms_2_buyers_id">
<span<?php echo $query_oms_2->buyers_id->viewAttributes() ?>>
<?php echo $query_oms_2->buyers_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to"<?php echo $query_oms_2->reports_to->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_reports_to" class="query_oms_2_reports_to">
<span<?php echo $query_oms_2->reports_to->viewAttributes() ?>>
<?php echo $query_oms_2->reports_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->order_week->Visible) { // order_week ?>
		<td data-name="order_week"<?php echo $query_oms_2->order_week->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_order_week" class="query_oms_2_order_week">
<span<?php echo $query_oms_2->order_week->viewAttributes() ?>>
<?php echo $query_oms_2->order_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->order_date->Visible) { // order_date ?>
		<td data-name="order_date"<?php echo $query_oms_2->order_date->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_order_date" class="query_oms_2_order_date">
<span<?php echo $query_oms_2->order_date->viewAttributes() ?>>
<?php echo $query_oms_2->order_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->category->Visible) { // category ?>
		<td data-name="category"<?php echo $query_oms_2->category->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_category" class="query_oms_2_category">
<span<?php echo $query_oms_2->category->viewAttributes() ?>>
<?php echo $query_oms_2->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->current_works->Visible) { // current_works ?>
		<td data-name="current_works"<?php echo $query_oms_2->current_works->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_current_works" class="query_oms_2_current_works">
<span<?php echo $query_oms_2->current_works->viewAttributes() ?>>
<?php echo $query_oms_2->current_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->buyer_order->Visible) { // buyer_order ?>
		<td data-name="buyer_order"<?php echo $query_oms_2->buyer_order->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_buyer_order" class="query_oms_2_buyer_order">
<span<?php echo $query_oms_2->buyer_order->viewAttributes() ?>>
<?php echo $query_oms_2->buyer_order->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->po->Visible) { // po ?>
		<td data-name="po"<?php echo $query_oms_2->po->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_po" class="query_oms_2_po">
<span<?php echo $query_oms_2->po->viewAttributes() ?>>
<?php echo $query_oms_2->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->item->Visible) { // item ?>
		<td data-name="item"<?php echo $query_oms_2->item->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_item" class="query_oms_2_item">
<span<?php echo $query_oms_2->item->viewAttributes() ?>>
<?php echo $query_oms_2->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref"<?php echo $query_oms_2->buyer_ref->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_buyer_ref" class="query_oms_2_buyer_ref">
<span<?php echo $query_oms_2->buyer_ref->viewAttributes() ?>>
<?php echo $query_oms_2->buyer_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->design->Visible) { // design ?>
		<td data-name="design"<?php echo $query_oms_2->design->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_design" class="query_oms_2_design">
<span<?php echo $query_oms_2->design->viewAttributes() ?>>
<?php echo $query_oms_2->design->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->size_buyer->Visible) { // size_buyer ?>
		<td data-name="size_buyer"<?php echo $query_oms_2->size_buyer->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_size_buyer" class="query_oms_2_size_buyer">
<span<?php echo $query_oms_2->size_buyer->viewAttributes() ?>>
<?php echo $query_oms_2->size_buyer->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->width->Visible) { // width ?>
		<td data-name="width"<?php echo $query_oms_2->width->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_width" class="query_oms_2_width">
<span<?php echo $query_oms_2->width->viewAttributes() ?>>
<?php echo $query_oms_2->width->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->length->Visible) { // length ?>
		<td data-name="length"<?php echo $query_oms_2->length->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_length" class="query_oms_2_length">
<span<?php echo $query_oms_2->length->viewAttributes() ?>>
<?php echo $query_oms_2->length->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->qty->Visible) { // qty ?>
		<td data-name="qty"<?php echo $query_oms_2->qty->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_qty" class="query_oms_2_qty">
<span<?php echo $query_oms_2->qty->viewAttributes() ?>>
<?php echo $query_oms_2->qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->revised_qty->Visible) { // revised_qty ?>
		<td data-name="revised_qty"<?php echo $query_oms_2->revised_qty->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_revised_qty" class="query_oms_2_revised_qty">
<span<?php echo $query_oms_2->revised_qty->viewAttributes() ?>>
<?php echo $query_oms_2->revised_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $query_oms_2->sqm->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_sqm" class="query_oms_2_sqm">
<span<?php echo $query_oms_2->sqm->viewAttributes() ?>>
<?php echo $query_oms_2->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->ex_factory->Visible) { // ex_factory ?>
		<td data-name="ex_factory"<?php echo $query_oms_2->ex_factory->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_ex_factory" class="query_oms_2_ex_factory">
<span<?php echo $query_oms_2->ex_factory->viewAttributes() ?>>
<?php echo $query_oms_2->ex_factory->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->ex_factory_p->Visible) { // ex_factory_p ?>
		<td data-name="ex_factory_p"<?php echo $query_oms_2->ex_factory_p->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_ex_factory_p" class="query_oms_2_ex_factory_p">
<span<?php echo $query_oms_2->ex_factory_p->viewAttributes() ?>>
<?php echo $query_oms_2->ex_factory_p->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->shipping_mode->Visible) { // shipping_mode ?>
		<td data-name="shipping_mode"<?php echo $query_oms_2->shipping_mode->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_shipping_mode" class="query_oms_2_shipping_mode">
<span<?php echo $query_oms_2->shipping_mode->viewAttributes() ?>>
<?php echo $query_oms_2->shipping_mode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $query_oms_2->remarks->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_remarks" class="query_oms_2_remarks">
<span<?php echo $query_oms_2->remarks->viewAttributes() ?>>
<?php echo $query_oms_2->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->d_qty->Visible) { // d_qty ?>
		<td data-name="d_qty"<?php echo $query_oms_2->d_qty->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_d_qty" class="query_oms_2_d_qty">
<span<?php echo $query_oms_2->d_qty->viewAttributes() ?>>
<?php echo $query_oms_2->d_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no"<?php echo $query_oms_2->pl_no->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_pl_no" class="query_oms_2_pl_no">
<span<?php echo $query_oms_2->pl_no->viewAttributes() ?>>
<?php echo $query_oms_2->pl_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->invoice_date->Visible) { // invoice_date ?>
		<td data-name="invoice_date"<?php echo $query_oms_2->invoice_date->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_invoice_date" class="query_oms_2_invoice_date">
<span<?php echo $query_oms_2->invoice_date->viewAttributes() ?>>
<?php echo $query_oms_2->invoice_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->sailing_week->Visible) { // sailing_week ?>
		<td data-name="sailing_week"<?php echo $query_oms_2->sailing_week->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_sailing_week" class="query_oms_2_sailing_week">
<span<?php echo $query_oms_2->sailing_week->viewAttributes() ?>>
<?php echo $query_oms_2->sailing_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->pending->Visible) { // pending ?>
		<td data-name="pending"<?php echo $query_oms_2->pending->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_pending" class="query_oms_2_pending">
<span<?php echo $query_oms_2->pending->viewAttributes() ?>>
<?php echo $query_oms_2->pending->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->pending_sqm->Visible) { // pending_sqm ?>
		<td data-name="pending_sqm"<?php echo $query_oms_2->pending_sqm->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_pending_sqm" class="query_oms_2_pending_sqm">
<span<?php echo $query_oms_2->pending_sqm->viewAttributes() ?>>
<?php echo $query_oms_2->pending_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->cbm->Visible) { // cbm ?>
		<td data-name="cbm"<?php echo $query_oms_2->cbm->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_cbm" class="query_oms_2_cbm">
<span<?php echo $query_oms_2->cbm->viewAttributes() ?>>
<?php echo $query_oms_2->cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->total_cbm->Visible) { // total_cbm ?>
		<td data-name="total_cbm"<?php echo $query_oms_2->total_cbm->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_total_cbm" class="query_oms_2_total_cbm">
<span<?php echo $query_oms_2->total_cbm->viewAttributes() ?>>
<?php echo $query_oms_2->total_cbm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->offloom->Visible) { // offloom ?>
		<td data-name="offloom"<?php echo $query_oms_2->offloom->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_offloom" class="query_oms_2_offloom">
<span<?php echo $query_oms_2->offloom->viewAttributes() ?>>
<?php echo $query_oms_2->offloom->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->status->Visible) { // status ?>
		<td data-name="status"<?php echo $query_oms_2->status->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_status" class="query_oms_2_status">
<span<?php echo $query_oms_2->status->viewAttributes() ?>>
<?php echo $query_oms_2->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->rejection->Visible) { // rejection ?>
		<td data-name="rejection"<?php echo $query_oms_2->rejection->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_rejection" class="query_oms_2_rejection">
<span<?php echo $query_oms_2->rejection->viewAttributes() ?>>
<?php echo $query_oms_2->rejection->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->completed->Visible) { // completed ?>
		<td data-name="completed"<?php echo $query_oms_2->completed->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_completed" class="query_oms_2_completed">
<span<?php echo $query_oms_2->completed->viewAttributes() ?>>
<?php echo $query_oms_2->completed->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works"<?php echo $query_oms_2->weaving_works->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_weaving_works" class="query_oms_2_weaving_works">
<span<?php echo $query_oms_2->weaving_works->viewAttributes() ?>>
<?php echo $query_oms_2->weaving_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->cs->Visible) { // cs ?>
		<td data-name="cs"<?php echo $query_oms_2->cs->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_cs" class="query_oms_2_cs">
<span<?php echo $query_oms_2->cs->viewAttributes() ?>>
<?php echo $query_oms_2->cs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_oms_2->weight_sqm->Visible) { // weight_sqm ?>
		<td data-name="weight_sqm"<?php echo $query_oms_2->weight_sqm->cellAttributes() ?>>
<span id="el<?php echo $query_oms_2_list->RowCnt ?>_query_oms_2_weight_sqm" class="query_oms_2_weight_sqm">
<span<?php echo $query_oms_2->weight_sqm->viewAttributes() ?>>
<?php echo $query_oms_2->weight_sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$query_oms_2_list->ListOptions->render("body", "right", $query_oms_2_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$query_oms_2->isGridAdd())
		$query_oms_2_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$query_oms_2->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($query_oms_2_list->Recordset)
	$query_oms_2_list->Recordset->Close();
?>
<?php if (!$query_oms_2->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$query_oms_2->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($query_oms_2_list->Pager)) $query_oms_2_list->Pager = new PrevNextPager($query_oms_2_list->StartRec, $query_oms_2_list->DisplayRecs, $query_oms_2_list->TotalRecs, $query_oms_2_list->AutoHidePager) ?>
<?php if ($query_oms_2_list->Pager->RecordCount > 0 && $query_oms_2_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($query_oms_2_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $query_oms_2_list->pageUrl() ?>start=<?php echo $query_oms_2_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($query_oms_2_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $query_oms_2_list->pageUrl() ?>start=<?php echo $query_oms_2_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $query_oms_2_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($query_oms_2_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $query_oms_2_list->pageUrl() ?>start=<?php echo $query_oms_2_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($query_oms_2_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $query_oms_2_list->pageUrl() ?>start=<?php echo $query_oms_2_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $query_oms_2_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($query_oms_2_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $query_oms_2_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $query_oms_2_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $query_oms_2_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($query_oms_2_list->TotalRecs > 0 && (!$query_oms_2_list->AutoHidePageSizeSelector || $query_oms_2_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="query_oms_2">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($query_oms_2_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($query_oms_2_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($query_oms_2_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($query_oms_2_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($query_oms_2_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($query_oms_2->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $query_oms_2_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($query_oms_2_list->TotalRecs == 0 && !$query_oms_2->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $query_oms_2_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$query_oms_2_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$query_oms_2->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$query_oms_2->isExport()) { ?>
<script>
ew.scrollableTable("gmp_query_oms_2", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$query_oms_2_list->terminate();
?>