<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$query_oms_search = new query_oms_search();

// Run the page
$query_oms_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$query_oms_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($query_oms_search->IsModal) { ?>
var fquery_omssearch = currentAdvancedSearchForm = new ew.Form("fquery_omssearch", "search");
<?php } else { ?>
var fquery_omssearch = currentForm = new ew.Form("fquery_omssearch", "search");
<?php } ?>

// Form_CustomValidate event
fquery_omssearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fquery_omssearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fquery_omssearch.lists["x_buyers_id"] = <?php echo $query_oms_search->buyers_id->Lookup->toClientList() ?>;
fquery_omssearch.lists["x_buyers_id"].options = <?php echo JsonEncode($query_oms_search->buyers_id->lookupOptions()) ?>;
fquery_omssearch.lists["x_order_week"] = <?php echo $query_oms_search->order_week->Lookup->toClientList() ?>;
fquery_omssearch.lists["x_order_week"].options = <?php echo JsonEncode($query_oms_search->order_week->lookupOptions()) ?>;
fquery_omssearch.lists["x_ex_factory"] = <?php echo $query_oms_search->ex_factory->Lookup->toClientList() ?>;
fquery_omssearch.lists["x_ex_factory"].options = <?php echo JsonEncode($query_oms_search->ex_factory->lookupOptions()) ?>;
fquery_omssearch.lists["x_status[]"] = <?php echo $query_oms_search->status->Lookup->toClientList() ?>;
fquery_omssearch.lists["x_status[]"].options = <?php echo JsonEncode($query_oms_search->status->lookupOptions()) ?>;
fquery_omssearch.lists["x_completed[]"] = <?php echo $query_oms_search->completed->Lookup->toClientList() ?>;
fquery_omssearch.lists["x_completed[]"].options = <?php echo JsonEncode($query_oms_search->completed->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fquery_omssearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_order_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms->order_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_width");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms->width->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_length");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms->length->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_qty");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms->qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_revised_qty");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms->revised_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_d_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms->d_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms->pending->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms->pending_sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_offloom");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms->offloom->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_rejection");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms->rejection->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_weight_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_oms->weight_sqm->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $query_oms_search->showPageHeader(); ?>
<?php
$query_oms_search->showMessage();
?>
<form name="fquery_omssearch" id="fquery_omssearch" class="<?php echo $query_oms_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($query_oms_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $query_oms_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="query_oms">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$query_oms_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($query_oms->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_id"><?php echo $query_oms->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->id->cellAttributes() ?>>
			<span id="el_query_oms_id">
<input type="text" data-table="query_oms" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($query_oms->id->getPlaceHolder()) ?>" value="<?php echo $query_oms->id->EditValue ?>"<?php echo $query_oms->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label for="x_buyers_id" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_buyers_id"><?php echo $query_oms->buyers_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->buyers_id->cellAttributes() ?>>
			<span id="el_query_oms_buyers_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_oms" data-field="x_buyers_id" data-value-separator="<?php echo $query_oms->buyers_id->displayValueSeparatorAttribute() ?>" id="x_buyers_id" name="x_buyers_id"<?php echo $query_oms->buyers_id->editAttributes() ?>>
		<?php echo $query_oms->buyers_id->selectOptionListHtml("x_buyers_id") ?>
	</select>
</div>
<?php echo $query_oms->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->order_week->Visible) { // order_week ?>
	<div id="r_order_week" class="form-group row">
		<label for="x_order_week" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_order_week"><?php echo $query_oms->order_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_week" id="z_order_week" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->order_week->cellAttributes() ?>>
			<span id="el_query_oms_order_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_oms" data-field="x_order_week" data-value-separator="<?php echo $query_oms->order_week->displayValueSeparatorAttribute() ?>" id="x_order_week" name="x_order_week"<?php echo $query_oms->order_week->editAttributes() ?>>
		<?php echo $query_oms->order_week->selectOptionListHtml("x_order_week") ?>
	</select>
</div>
<?php echo $query_oms->order_week->Lookup->getParamTag("p_x_order_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->order_date->Visible) { // order_date ?>
	<div id="r_order_date" class="form-group row">
		<label for="x_order_date" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_order_date"><?php echo $query_oms->order_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_date" id="z_order_date" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->order_date->cellAttributes() ?>>
			<span id="el_query_oms_order_date">
<input type="text" data-table="query_oms" data-field="x_order_date" data-format="2" name="x_order_date" id="x_order_date" placeholder="<?php echo HtmlEncode($query_oms->order_date->getPlaceHolder()) ?>" value="<?php echo $query_oms->order_date->EditValue ?>"<?php echo $query_oms->order_date->editAttributes() ?>>
<?php if (!$query_oms->order_date->ReadOnly && !$query_oms->order_date->Disabled && !isset($query_oms->order_date->EditAttrs["readonly"]) && !isset($query_oms->order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fquery_omssearch", "x_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->buyer_order->Visible) { // buyer_order ?>
	<div id="r_buyer_order" class="form-group row">
		<label for="x_buyer_order" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_buyer_order"><?php echo $query_oms->buyer_order->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_order" id="z_buyer_order" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->buyer_order->cellAttributes() ?>>
			<span id="el_query_oms_buyer_order">
<input type="text" data-table="query_oms" data-field="x_buyer_order" name="x_buyer_order" id="x_buyer_order" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($query_oms->buyer_order->getPlaceHolder()) ?>" value="<?php echo $query_oms->buyer_order->EditValue ?>"<?php echo $query_oms->buyer_order->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_po"><?php echo $query_oms->po->caption() ?></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->po->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($query_oms->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($query_oms->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($query_oms->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($query_oms->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($query_oms->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($query_oms->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($query_oms->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($query_oms->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($query_oms->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_query_oms_po">
<input type="text" data-table="query_oms" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($query_oms->po->getPlaceHolder()) ?>" value="<?php echo $query_oms->po->EditValue ?>"<?php echo $query_oms->po->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_po d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_query_oms_po" class="btw1_po d-none">
<input type="text" data-table="query_oms" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($query_oms->po->getPlaceHolder()) ?>" value="<?php echo $query_oms->po->EditValue2 ?>"<?php echo $query_oms->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_item"><?php echo $query_oms->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->item->cellAttributes() ?>>
			<span id="el_query_oms_item">
<input type="text" data-table="query_oms" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($query_oms->item->getPlaceHolder()) ?>" value="<?php echo $query_oms->item->EditValue ?>"<?php echo $query_oms->item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label for="x_buyer_ref" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_buyer_ref"><?php echo $query_oms->buyer_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->buyer_ref->cellAttributes() ?>>
			<span id="el_query_oms_buyer_ref">
<input type="text" data-table="query_oms" data-field="x_buyer_ref" name="x_buyer_ref" id="x_buyer_ref" size="30" maxlength="144" placeholder="<?php echo HtmlEncode($query_oms->buyer_ref->getPlaceHolder()) ?>" value="<?php echo $query_oms->buyer_ref->EditValue ?>"<?php echo $query_oms->buyer_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->design->Visible) { // design ?>
	<div id="r_design" class="form-group row">
		<label for="x_design" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_design"><?php echo $query_oms->design->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design" id="z_design" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->design->cellAttributes() ?>>
			<span id="el_query_oms_design">
<input type="text" data-table="query_oms" data-field="x_design" name="x_design" id="x_design" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($query_oms->design->getPlaceHolder()) ?>" value="<?php echo $query_oms->design->EditValue ?>"<?php echo $query_oms->design->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->size_buyer->Visible) { // size_buyer ?>
	<div id="r_size_buyer" class="form-group row">
		<label for="x_size_buyer" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_size_buyer"><?php echo $query_oms->size_buyer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_buyer" id="z_size_buyer" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->size_buyer->cellAttributes() ?>>
			<span id="el_query_oms_size_buyer">
<input type="text" data-table="query_oms" data-field="x_size_buyer" name="x_size_buyer" id="x_size_buyer" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($query_oms->size_buyer->getPlaceHolder()) ?>" value="<?php echo $query_oms->size_buyer->EditValue ?>"<?php echo $query_oms->size_buyer->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->width->Visible) { // width ?>
	<div id="r_width" class="form-group row">
		<label for="x_width" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_width"><?php echo $query_oms->width->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_width" id="z_width" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->width->cellAttributes() ?>>
			<span id="el_query_oms_width">
<input type="text" data-table="query_oms" data-field="x_width" name="x_width" id="x_width" size="30" placeholder="<?php echo HtmlEncode($query_oms->width->getPlaceHolder()) ?>" value="<?php echo $query_oms->width->EditValue ?>"<?php echo $query_oms->width->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->length->Visible) { // length ?>
	<div id="r_length" class="form-group row">
		<label for="x_length" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_length"><?php echo $query_oms->length->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_length" id="z_length" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->length->cellAttributes() ?>>
			<span id="el_query_oms_length">
<input type="text" data-table="query_oms" data-field="x_length" name="x_length" id="x_length" size="30" placeholder="<?php echo HtmlEncode($query_oms->length->getPlaceHolder()) ?>" value="<?php echo $query_oms->length->EditValue ?>"<?php echo $query_oms->length->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->qty->Visible) { // qty ?>
	<div id="r_qty" class="form-group row">
		<label for="x_qty" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_qty"><?php echo $query_oms->qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_qty" id="z_qty" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->qty->cellAttributes() ?>>
			<span id="el_query_oms_qty">
<input type="text" data-table="query_oms" data-field="x_qty" name="x_qty" id="x_qty" size="30" placeholder="<?php echo HtmlEncode($query_oms->qty->getPlaceHolder()) ?>" value="<?php echo $query_oms->qty->EditValue ?>"<?php echo $query_oms->qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->revised_qty->Visible) { // revised_qty ?>
	<div id="r_revised_qty" class="form-group row">
		<label for="x_revised_qty" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_revised_qty"><?php echo $query_oms->revised_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_revised_qty" id="z_revised_qty" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->revised_qty->cellAttributes() ?>>
			<span id="el_query_oms_revised_qty">
<input type="text" data-table="query_oms" data-field="x_revised_qty" name="x_revised_qty" id="x_revised_qty" size="30" placeholder="<?php echo HtmlEncode($query_oms->revised_qty->getPlaceHolder()) ?>" value="<?php echo $query_oms->revised_qty->EditValue ?>"<?php echo $query_oms->revised_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_sqm"><?php echo $query_oms->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->sqm->cellAttributes() ?>>
			<span id="el_query_oms_sqm">
<input type="text" data-table="query_oms" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($query_oms->sqm->getPlaceHolder()) ?>" value="<?php echo $query_oms->sqm->EditValue ?>"<?php echo $query_oms->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->ex_factory->Visible) { // ex_factory ?>
	<div id="r_ex_factory" class="form-group row">
		<label for="x_ex_factory" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_ex_factory"><?php echo $query_oms->ex_factory->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ex_factory" id="z_ex_factory" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->ex_factory->cellAttributes() ?>>
			<span id="el_query_oms_ex_factory">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_oms" data-field="x_ex_factory" data-value-separator="<?php echo $query_oms->ex_factory->displayValueSeparatorAttribute() ?>" id="x_ex_factory" name="x_ex_factory"<?php echo $query_oms->ex_factory->editAttributes() ?>>
		<?php echo $query_oms->ex_factory->selectOptionListHtml("x_ex_factory") ?>
	</select>
</div>
<?php echo $query_oms->ex_factory->Lookup->getParamTag("p_x_ex_factory") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->ex_factory_p->Visible) { // ex_factory_p ?>
	<div id="r_ex_factory_p" class="form-group row">
		<label for="x_ex_factory_p" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_ex_factory_p"><?php echo $query_oms->ex_factory_p->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ex_factory_p" id="z_ex_factory_p" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->ex_factory_p->cellAttributes() ?>>
			<span id="el_query_oms_ex_factory_p">
<input type="text" data-table="query_oms" data-field="x_ex_factory_p" name="x_ex_factory_p" id="x_ex_factory_p" size="35" placeholder="<?php echo HtmlEncode($query_oms->ex_factory_p->getPlaceHolder()) ?>" value="<?php echo $query_oms->ex_factory_p->EditValue ?>"<?php echo $query_oms->ex_factory_p->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->shipping_mode->Visible) { // shipping_mode ?>
	<div id="r_shipping_mode" class="form-group row">
		<label for="x_shipping_mode" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_shipping_mode"><?php echo $query_oms->shipping_mode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_shipping_mode" id="z_shipping_mode" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->shipping_mode->cellAttributes() ?>>
			<span id="el_query_oms_shipping_mode">
<input type="text" data-table="query_oms" data-field="x_shipping_mode" name="x_shipping_mode" id="x_shipping_mode" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($query_oms->shipping_mode->getPlaceHolder()) ?>" value="<?php echo $query_oms->shipping_mode->EditValue ?>"<?php echo $query_oms->shipping_mode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_remarks"><?php echo $query_oms->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->remarks->cellAttributes() ?>>
			<span id="el_query_oms_remarks">
<input type="text" data-table="query_oms" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($query_oms->remarks->getPlaceHolder()) ?>" value="<?php echo $query_oms->remarks->EditValue ?>"<?php echo $query_oms->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->d_qty->Visible) { // d_qty ?>
	<div id="r_d_qty" class="form-group row">
		<label for="x_d_qty" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_d_qty"><?php echo $query_oms->d_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_qty" id="z_d_qty" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->d_qty->cellAttributes() ?>>
			<span id="el_query_oms_d_qty">
<input type="text" data-table="query_oms" data-field="x_d_qty" name="x_d_qty" id="x_d_qty" size="30" placeholder="<?php echo HtmlEncode($query_oms->d_qty->getPlaceHolder()) ?>" value="<?php echo $query_oms->d_qty->EditValue ?>"<?php echo $query_oms->d_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->pl_no->Visible) { // pl_no ?>
	<div id="r_pl_no" class="form-group row">
		<label for="x_pl_no" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_pl_no"><?php echo $query_oms->pl_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_pl_no" id="z_pl_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->pl_no->cellAttributes() ?>>
			<span id="el_query_oms_pl_no">
<input type="text" data-table="query_oms" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" size="35" placeholder="<?php echo HtmlEncode($query_oms->pl_no->getPlaceHolder()) ?>" value="<?php echo $query_oms->pl_no->EditValue ?>"<?php echo $query_oms->pl_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->invoice_date->Visible) { // invoice_date ?>
	<div id="r_invoice_date" class="form-group row">
		<label for="x_invoice_date" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_invoice_date"><?php echo $query_oms->invoice_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_invoice_date" id="z_invoice_date" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->invoice_date->cellAttributes() ?>>
			<span id="el_query_oms_invoice_date">
<input type="text" data-table="query_oms" data-field="x_invoice_date" name="x_invoice_date" id="x_invoice_date" size="35" placeholder="<?php echo HtmlEncode($query_oms->invoice_date->getPlaceHolder()) ?>" value="<?php echo $query_oms->invoice_date->EditValue ?>"<?php echo $query_oms->invoice_date->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->sailing_week->Visible) { // sailing_week ?>
	<div id="r_sailing_week" class="form-group row">
		<label for="x_sailing_week" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_sailing_week"><?php echo $query_oms->sailing_week->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_sailing_week" id="z_sailing_week" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->sailing_week->cellAttributes() ?>>
			<span id="el_query_oms_sailing_week">
<input type="text" data-table="query_oms" data-field="x_sailing_week" name="x_sailing_week" id="x_sailing_week" size="35" placeholder="<?php echo HtmlEncode($query_oms->sailing_week->getPlaceHolder()) ?>" value="<?php echo $query_oms->sailing_week->EditValue ?>"<?php echo $query_oms->sailing_week->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->pending->Visible) { // pending ?>
	<div id="r_pending" class="form-group row">
		<label for="x_pending" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_pending"><?php echo $query_oms->pending->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pending" id="z_pending" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->pending->cellAttributes() ?>>
			<span id="el_query_oms_pending">
<input type="text" data-table="query_oms" data-field="x_pending" name="x_pending" id="x_pending" size="30" placeholder="<?php echo HtmlEncode($query_oms->pending->getPlaceHolder()) ?>" value="<?php echo $query_oms->pending->EditValue ?>"<?php echo $query_oms->pending->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->pending_sqm->Visible) { // pending_sqm ?>
	<div id="r_pending_sqm" class="form-group row">
		<label for="x_pending_sqm" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_pending_sqm"><?php echo $query_oms->pending_sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pending_sqm" id="z_pending_sqm" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->pending_sqm->cellAttributes() ?>>
			<span id="el_query_oms_pending_sqm">
<input type="text" data-table="query_oms" data-field="x_pending_sqm" name="x_pending_sqm" id="x_pending_sqm" size="30" placeholder="<?php echo HtmlEncode($query_oms->pending_sqm->getPlaceHolder()) ?>" value="<?php echo $query_oms->pending_sqm->EditValue ?>"<?php echo $query_oms->pending_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->cbm->Visible) { // cbm ?>
	<div id="r_cbm" class="form-group row">
		<label for="x_cbm" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_cbm"><?php echo $query_oms->cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_cbm" id="z_cbm" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->cbm->cellAttributes() ?>>
			<span id="el_query_oms_cbm">
<input type="text" data-table="query_oms" data-field="x_cbm" name="x_cbm" id="x_cbm" size="35" placeholder="<?php echo HtmlEncode($query_oms->cbm->getPlaceHolder()) ?>" value="<?php echo $query_oms->cbm->EditValue ?>"<?php echo $query_oms->cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->total_cbm->Visible) { // total_cbm ?>
	<div id="r_total_cbm" class="form-group row">
		<label for="x_total_cbm" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_total_cbm"><?php echo $query_oms->total_cbm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_total_cbm" id="z_total_cbm" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->total_cbm->cellAttributes() ?>>
			<span id="el_query_oms_total_cbm">
<input type="text" data-table="query_oms" data-field="x_total_cbm" name="x_total_cbm" id="x_total_cbm" size="35" placeholder="<?php echo HtmlEncode($query_oms->total_cbm->getPlaceHolder()) ?>" value="<?php echo $query_oms->total_cbm->EditValue ?>"<?php echo $query_oms->total_cbm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->offloom->Visible) { // offloom ?>
	<div id="r_offloom" class="form-group row">
		<label for="x_offloom" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_offloom"><?php echo $query_oms->offloom->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_offloom" id="z_offloom" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->offloom->cellAttributes() ?>>
			<span id="el_query_oms_offloom">
<input type="text" data-table="query_oms" data-field="x_offloom" name="x_offloom" id="x_offloom" size="30" placeholder="<?php echo HtmlEncode($query_oms->offloom->getPlaceHolder()) ?>" value="<?php echo $query_oms->offloom->EditValue ?>"<?php echo $query_oms->offloom->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_status"><?php echo $query_oms->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_status" id="z_status" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->status->cellAttributes() ?>>
			<span id="el_query_oms_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_oms" data-field="x_status" data-value-separator="<?php echo $query_oms->status->displayValueSeparatorAttribute() ?>" id="x_status[]" name="x_status[]" multiple="multiple"<?php echo $query_oms->status->editAttributes() ?>>
		<?php echo $query_oms->status->selectOptionListHtml("x_status[]") ?>
	</select>
</div>
<?php echo $query_oms->status->Lookup->getParamTag("p_x_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->rejection->Visible) { // rejection ?>
	<div id="r_rejection" class="form-group row">
		<label for="x_rejection" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_rejection"><?php echo $query_oms->rejection->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rejection" id="z_rejection" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->rejection->cellAttributes() ?>>
			<span id="el_query_oms_rejection">
<input type="text" data-table="query_oms" data-field="x_rejection" name="x_rejection" id="x_rejection" size="30" placeholder="<?php echo HtmlEncode($query_oms->rejection->getPlaceHolder()) ?>" value="<?php echo $query_oms->rejection->EditValue ?>"<?php echo $query_oms->rejection->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->completed->Visible) { // completed ?>
	<div id="r_completed" class="form-group row">
		<label class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_completed"><?php echo $query_oms->completed->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_completed" id="z_completed" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->completed->cellAttributes() ?>>
			<span id="el_query_oms_completed">
<div id="tp_x_completed" class="ew-template"><input type="checkbox" class="form-check-input" data-table="query_oms" data-field="x_completed" data-value-separator="<?php echo $query_oms->completed->displayValueSeparatorAttribute() ?>" name="x_completed[]" id="x_completed[]" value="{value}"<?php echo $query_oms->completed->editAttributes() ?>></div>
<div id="dsl_x_completed" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $query_oms->completed->checkBoxListHtml(FALSE, "x_completed[]") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label for="x_reports_to" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_reports_to"><?php echo $query_oms->reports_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_reports_to" id="z_reports_to" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->reports_to->cellAttributes() ?>>
			<span id="el_query_oms_reports_to">
<input type="text" data-table="query_oms" data-field="x_reports_to" name="x_reports_to" id="x_reports_to" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($query_oms->reports_to->getPlaceHolder()) ?>" value="<?php echo $query_oms->reports_to->EditValue ?>"<?php echo $query_oms->reports_to->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_oms->weight_sqm->Visible) { // weight_sqm ?>
	<div id="r_weight_sqm" class="form-group row">
		<label for="x_weight_sqm" class="<?php echo $query_oms_search->LeftColumnClass ?>"><span id="elh_query_oms_weight_sqm"><?php echo $query_oms->weight_sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weight_sqm" id="z_weight_sqm" value="="></span>
		</label>
		<div class="<?php echo $query_oms_search->RightColumnClass ?>"><div<?php echo $query_oms->weight_sqm->cellAttributes() ?>>
			<span id="el_query_oms_weight_sqm">
<input type="text" data-table="query_oms" data-field="x_weight_sqm" name="x_weight_sqm" id="x_weight_sqm" size="30" placeholder="<?php echo HtmlEncode($query_oms->weight_sqm->getPlaceHolder()) ?>" value="<?php echo $query_oms->weight_sqm->EditValue ?>"<?php echo $query_oms->weight_sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$query_oms_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $query_oms_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$query_oms_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$query_oms_search->terminate();
?>