<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$query_production_table_list = new query_production_table_list();

// Run the page
$query_production_table_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$query_production_table_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$query_production_table->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fquery_production_tablelist = currentForm = new ew.Form("fquery_production_tablelist", "list");
fquery_production_tablelist.formKeyCountName = '<?php echo $query_production_table_list->FormKeyCountName ?>';

// Form_CustomValidate event
fquery_production_tablelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fquery_production_tablelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fquery_production_tablelist.lists["x_buyer"] = <?php echo $query_production_table_list->buyer->Lookup->toClientList() ?>;
fquery_production_tablelist.lists["x_buyer"].options = <?php echo JsonEncode($query_production_table_list->buyer->lookupOptions()) ?>;
fquery_production_tablelist.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fquery_production_tablelist.lists["x_Weaving"] = <?php echo $query_production_table_list->Weaving->Lookup->toClientList() ?>;
fquery_production_tablelist.lists["x_Weaving"].options = <?php echo JsonEncode($query_production_table_list->Weaving->options(FALSE, TRUE)) ?>;
fquery_production_tablelist.lists["x_Packing"] = <?php echo $query_production_table_list->Packing->Lookup->toClientList() ?>;
fquery_production_tablelist.lists["x_Packing"].options = <?php echo JsonEncode($query_production_table_list->Packing->options(FALSE, TRUE)) ?>;
fquery_production_tablelist.lists["x_status"] = <?php echo $query_production_table_list->status->Lookup->toClientList() ?>;
fquery_production_tablelist.lists["x_status"].options = <?php echo JsonEncode($query_production_table_list->status->lookupOptions()) ?>;
fquery_production_tablelist.lists["x_dispatch_week_p"] = <?php echo $query_production_table_list->dispatch_week_p->Lookup->toClientList() ?>;
fquery_production_tablelist.lists["x_dispatch_week_p"].options = <?php echo JsonEncode($query_production_table_list->dispatch_week_p->lookupOptions()) ?>;
fquery_production_tablelist.lists["x_current_works"] = <?php echo $query_production_table_list->current_works->Lookup->toClientList() ?>;
fquery_production_tablelist.lists["x_current_works"].options = <?php echo JsonEncode($query_production_table_list->current_works->lookupOptions()) ?>;
fquery_production_tablelist.lists["x_batch_no"] = <?php echo $query_production_table_list->batch_no->Lookup->toClientList() ?>;
fquery_production_tablelist.lists["x_batch_no"].options = <?php echo JsonEncode($query_production_table_list->batch_no->lookupOptions()) ?>;

// Form object for search
var fquery_production_tablelistsrch = currentSearchForm = new ew.Form("fquery_production_tablelistsrch");

// Validate function for search
fquery_production_tablelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fquery_production_tablelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fquery_production_tablelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fquery_production_tablelistsrch.lists["x_Weaving"] = <?php echo $query_production_table_list->Weaving->Lookup->toClientList() ?>;
fquery_production_tablelistsrch.lists["x_Weaving"].options = <?php echo JsonEncode($query_production_table_list->Weaving->options(FALSE, TRUE)) ?>;
fquery_production_tablelistsrch.lists["x_Packing"] = <?php echo $query_production_table_list->Packing->Lookup->toClientList() ?>;
fquery_production_tablelistsrch.lists["x_Packing"].options = <?php echo JsonEncode($query_production_table_list->Packing->options(FALSE, TRUE)) ?>;
fquery_production_tablelistsrch.lists["x_current_works"] = <?php echo $query_production_table_list->current_works->Lookup->toClientList() ?>;
fquery_production_tablelistsrch.lists["x_current_works"].options = <?php echo JsonEncode($query_production_table_list->current_works->lookupOptions()) ?>;

// Filters
fquery_production_tablelistsrch.filterList = <?php echo $query_production_table_list->getFilterList() ?>;

// Init search panel as collapsed
fquery_production_tablelistsrch.initSearchPanel = true;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$query_production_table->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($query_production_table_list->TotalRecs > 0 && $query_production_table_list->ExportOptions->visible()) { ?>
<?php $query_production_table_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($query_production_table_list->ImportOptions->visible()) { ?>
<?php $query_production_table_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($query_production_table_list->SearchOptions->visible()) { ?>
<?php $query_production_table_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($query_production_table_list->FilterOptions->visible()) { ?>
<?php $query_production_table_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$query_production_table_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$query_production_table->isExport() && !$query_production_table->CurrentAction) { ?>
<form name="fquery_production_tablelistsrch" id="fquery_production_tablelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($query_production_table_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fquery_production_tablelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="query_production_table">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$query_production_table_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$query_production_table->RowType = ROWTYPE_SEARCH;

// Render row
$query_production_table->resetAttributes();
$query_production_table_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($query_production_table->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $query_production_table->po->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_po" id="z_po" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="query_production_table" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($query_production_table->po->getPlaceHolder()) ?>" value="<?php echo $query_production_table->po->EditValue ?>"<?php echo $query_production_table->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($query_production_table->buyer_ref->Visible) { // buyer_ref ?>
	<div id="xsc_buyer_ref" class="ew-cell form-group">
		<label for="x_buyer_ref" class="ew-search-caption ew-label"><?php echo $query_production_table->buyer_ref->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="query_production_table" data-field="x_buyer_ref" name="x_buyer_ref" id="x_buyer_ref" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($query_production_table->buyer_ref->getPlaceHolder()) ?>" value="<?php echo $query_production_table->buyer_ref->EditValue ?>"<?php echo $query_production_table->buyer_ref->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($query_production_table->size_cm->Visible) { // size_cm ?>
	<div id="xsc_size_cm" class="ew-cell form-group">
		<label for="x_size_cm" class="ew-search-caption ew-label"><?php echo $query_production_table->size_cm->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="query_production_table" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($query_production_table->size_cm->getPlaceHolder()) ?>" value="<?php echo $query_production_table->size_cm->EditValue ?>"<?php echo $query_production_table->size_cm->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($query_production_table->Weaving->Visible) { // Weaving ?>
	<div id="xsc_Weaving" class="ew-cell form-group">
		<label for="x_Weaving" class="ew-search-caption ew-label"><?php echo $query_production_table->Weaving->caption() ?></label>
		<span class="ew-search-operator"><select name="z_Weaving" id="z_Weaving" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($query_production_table->Weaving->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($query_production_table->Weaving->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($query_production_table->Weaving->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($query_production_table->Weaving->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($query_production_table->Weaving->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($query_production_table->Weaving->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($query_production_table->Weaving->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($query_production_table->Weaving->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($query_production_table->Weaving->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($query_production_table->Weaving->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($query_production_table->Weaving->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($query_production_table->Weaving->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($query_production_table->Weaving->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production_table" data-field="x_Weaving" data-value-separator="<?php echo $query_production_table->Weaving->displayValueSeparatorAttribute() ?>" id="x_Weaving" name="x_Weaving"<?php echo $query_production_table->Weaving->editAttributes() ?>>
		<?php echo $query_production_table->Weaving->selectOptionListHtml("x_Weaving") ?>
	</select>
</div>
</span>
		<span class="ew-search-cond btw1_Weaving style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_Weaving style="d-none"">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production_table" data-field="x_Weaving" data-value-separator="<?php echo $query_production_table->Weaving->displayValueSeparatorAttribute() ?>" id="y_Weaving" name="y_Weaving"<?php echo $query_production_table->Weaving->editAttributes() ?>>
		<?php echo $query_production_table->Weaving->selectOptionListHtml("y_Weaving") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($query_production_table->Packing->Visible) { // Packing ?>
	<div id="xsc_Packing" class="ew-cell form-group">
		<label for="x_Packing" class="ew-search-caption ew-label"><?php echo $query_production_table->Packing->caption() ?></label>
		<span class="ew-search-operator"><select name="z_Packing" id="z_Packing" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($query_production_table->Packing->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($query_production_table->Packing->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($query_production_table->Packing->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($query_production_table->Packing->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($query_production_table->Packing->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($query_production_table->Packing->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($query_production_table->Packing->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($query_production_table->Packing->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($query_production_table->Packing->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($query_production_table->Packing->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($query_production_table->Packing->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($query_production_table->Packing->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($query_production_table->Packing->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production_table" data-field="x_Packing" data-value-separator="<?php echo $query_production_table->Packing->displayValueSeparatorAttribute() ?>" id="x_Packing" name="x_Packing"<?php echo $query_production_table->Packing->editAttributes() ?>>
		<?php echo $query_production_table->Packing->selectOptionListHtml("x_Packing") ?>
	</select>
</div>
</span>
		<span class="ew-search-cond btw1_Packing style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_Packing style="d-none"">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production_table" data-field="x_Packing" data-value-separator="<?php echo $query_production_table->Packing->displayValueSeparatorAttribute() ?>" id="y_Packing" name="y_Packing"<?php echo $query_production_table->Packing->editAttributes() ?>>
		<?php echo $query_production_table->Packing->selectOptionListHtml("y_Packing") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($query_production_table->process_c->Visible) { // process_c ?>
	<div id="xsc_process_c" class="ew-cell form-group">
		<label for="x_process_c" class="ew-search-caption ew-label"><?php echo $query_production_table->process_c->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process_c" id="z_process_c" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="query_production_table" data-field="x_process_c" name="x_process_c" id="x_process_c" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($query_production_table->process_c->getPlaceHolder()) ?>" value="<?php echo $query_production_table->process_c->EditValue ?>"<?php echo $query_production_table->process_c->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($query_production_table->process_d->Visible) { // process_d ?>
	<div id="xsc_process_d" class="ew-cell form-group">
		<label for="x_process_d" class="ew-search-caption ew-label"><?php echo $query_production_table->process_d->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process_d" id="z_process_d" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="query_production_table" data-field="x_process_d" name="x_process_d" id="x_process_d" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($query_production_table->process_d->getPlaceHolder()) ?>" value="<?php echo $query_production_table->process_d->EditValue ?>"<?php echo $query_production_table->process_d->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($query_production_table->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $query_production_table->_barcode->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__barcode" id="z__barcode" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="query_production_table" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($query_production_table->_barcode->getPlaceHolder()) ?>" value="<?php echo $query_production_table->_barcode->EditValue ?>"<?php echo $query_production_table->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($query_production_table->current_works->Visible) { // current_works ?>
	<div id="xsc_current_works" class="ew-cell form-group">
		<label for="x_current_works" class="ew-search-caption ew-label"><?php echo $query_production_table->current_works->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_current_works" id="z_current_works" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production_table" data-field="x_current_works" data-value-separator="<?php echo $query_production_table->current_works->displayValueSeparatorAttribute() ?>" id="x_current_works" name="x_current_works"<?php echo $query_production_table->current_works->editAttributes() ?>>
		<?php echo $query_production_table->current_works->selectOptionListHtml("x_current_works") ?>
	</select>
</div>
<?php echo $query_production_table->current_works->Lookup->getParamTag("p_x_current_works") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($query_production_table_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($query_production_table_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $query_production_table_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($query_production_table_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($query_production_table_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($query_production_table_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($query_production_table_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $query_production_table_list->showPageHeader(); ?>
<?php
$query_production_table_list->showMessage();
?>
<?php if ($query_production_table_list->TotalRecs > 0 || $query_production_table->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($query_production_table_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> query_production_table">
<?php if (!$query_production_table->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$query_production_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($query_production_table_list->Pager)) $query_production_table_list->Pager = new PrevNextPager($query_production_table_list->StartRec, $query_production_table_list->DisplayRecs, $query_production_table_list->TotalRecs, $query_production_table_list->AutoHidePager) ?>
<?php if ($query_production_table_list->Pager->RecordCount > 0 && $query_production_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($query_production_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $query_production_table_list->pageUrl() ?>start=<?php echo $query_production_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($query_production_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $query_production_table_list->pageUrl() ?>start=<?php echo $query_production_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $query_production_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($query_production_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $query_production_table_list->pageUrl() ?>start=<?php echo $query_production_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($query_production_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $query_production_table_list->pageUrl() ?>start=<?php echo $query_production_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $query_production_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($query_production_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $query_production_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $query_production_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $query_production_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($query_production_table_list->TotalRecs > 0 && (!$query_production_table_list->AutoHidePageSizeSelector || $query_production_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="query_production_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($query_production_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($query_production_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($query_production_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($query_production_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $query_production_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fquery_production_tablelist" id="fquery_production_tablelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($query_production_table_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $query_production_table_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="query_production_table">
<div id="gmp_query_production_table" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($query_production_table_list->TotalRecs > 0 || $query_production_table->isGridEdit()) { ?>
<table id="tbl_query_production_tablelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$query_production_table_list->RowType = ROWTYPE_HEADER;

// Render list options
$query_production_table_list->renderListOptions();

// Render list options (header, left)
$query_production_table_list->ListOptions->render("header", "left");
?>
<?php if ($query_production_table->buyer->Visible) { // buyer ?>
	<?php if ($query_production_table->sortUrl($query_production_table->buyer) == "") { ?>
		<th data-name="buyer" class="<?php echo $query_production_table->buyer->headerCellClass() ?>"><div id="elh_query_production_table_buyer" class="query_production_table_buyer"><div class="ew-table-header-caption"><?php echo $query_production_table->buyer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer" class="<?php echo $query_production_table->buyer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->buyer) ?>',2);"><div id="elh_query_production_table_buyer" class="query_production_table_buyer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->buyer->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->buyer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->buyer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->po->Visible) { // po ?>
	<?php if ($query_production_table->sortUrl($query_production_table->po) == "") { ?>
		<th data-name="po" class="<?php echo $query_production_table->po->headerCellClass() ?>"><div id="elh_query_production_table_po" class="query_production_table_po"><div class="ew-table-header-caption"><?php echo $query_production_table->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $query_production_table->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->po) ?>',2);"><div id="elh_query_production_table_po" class="query_production_table_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->buyer_ref->Visible) { // buyer_ref ?>
	<?php if ($query_production_table->sortUrl($query_production_table->buyer_ref) == "") { ?>
		<th data-name="buyer_ref" class="<?php echo $query_production_table->buyer_ref->headerCellClass() ?>"><div id="elh_query_production_table_buyer_ref" class="query_production_table_buyer_ref"><div class="ew-table-header-caption"><?php echo $query_production_table->buyer_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_ref" class="<?php echo $query_production_table->buyer_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->buyer_ref) ?>',2);"><div id="elh_query_production_table_buyer_ref" class="query_production_table_buyer_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->buyer_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->buyer_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->buyer_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->size_cm->Visible) { // size_cm ?>
	<?php if ($query_production_table->sortUrl($query_production_table->size_cm) == "") { ?>
		<th data-name="size_cm" class="<?php echo $query_production_table->size_cm->headerCellClass() ?>"><div id="elh_query_production_table_size_cm" class="query_production_table_size_cm"><div class="ew-table-header-caption"><?php echo $query_production_table->size_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_cm" class="<?php echo $query_production_table->size_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->size_cm) ?>',2);"><div id="elh_query_production_table_size_cm" class="query_production_table_size_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->size_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->size_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->size_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->Weaving->Visible) { // Weaving ?>
	<?php if ($query_production_table->sortUrl($query_production_table->Weaving) == "") { ?>
		<th data-name="Weaving" class="<?php echo $query_production_table->Weaving->headerCellClass() ?>"><div id="elh_query_production_table_Weaving" class="query_production_table_Weaving"><div class="ew-table-header-caption"><?php echo $query_production_table->Weaving->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Weaving" class="<?php echo $query_production_table->Weaving->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->Weaving) ?>',2);"><div id="elh_query_production_table_Weaving" class="query_production_table_Weaving">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->Weaving->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->Weaving->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->Weaving->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->Packing->Visible) { // Packing ?>
	<?php if ($query_production_table->sortUrl($query_production_table->Packing) == "") { ?>
		<th data-name="Packing" class="<?php echo $query_production_table->Packing->headerCellClass() ?>"><div id="elh_query_production_table_Packing" class="query_production_table_Packing"><div class="ew-table-header-caption"><?php echo $query_production_table->Packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Packing" class="<?php echo $query_production_table->Packing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->Packing) ?>',2);"><div id="elh_query_production_table_Packing" class="query_production_table_Packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->Packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->Packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->Packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->order_quantity->Visible) { // order_quantity ?>
	<?php if ($query_production_table->sortUrl($query_production_table->order_quantity) == "") { ?>
		<th data-name="order_quantity" class="<?php echo $query_production_table->order_quantity->headerCellClass() ?>"><div id="elh_query_production_table_order_quantity" class="query_production_table_order_quantity"><div class="ew-table-header-caption"><?php echo $query_production_table->order_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_quantity" class="<?php echo $query_production_table->order_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->order_quantity) ?>',2);"><div id="elh_query_production_table_order_quantity" class="query_production_table_order_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->order_quantity->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->order_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->order_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->count->Visible) { // count ?>
	<?php if ($query_production_table->sortUrl($query_production_table->count) == "") { ?>
		<th data-name="count" class="<?php echo $query_production_table->count->headerCellClass() ?>"><div id="elh_query_production_table_count" class="query_production_table_count"><div class="ew-table-header-caption"><?php echo $query_production_table->count->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="count" class="<?php echo $query_production_table->count->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->count) ?>',2);"><div id="elh_query_production_table_count" class="query_production_table_count">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->count->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->count->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->count->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->sqm->Visible) { // sqm ?>
	<?php if ($query_production_table->sortUrl($query_production_table->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $query_production_table->sqm->headerCellClass() ?>"><div id="elh_query_production_table_sqm" class="query_production_table_sqm"><div class="ew-table-header-caption"><?php echo $query_production_table->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $query_production_table->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->sqm) ?>',2);"><div id="elh_query_production_table_sqm" class="query_production_table_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->sqm_a->Visible) { // sqm_a ?>
	<?php if ($query_production_table->sortUrl($query_production_table->sqm_a) == "") { ?>
		<th data-name="sqm_a" class="<?php echo $query_production_table->sqm_a->headerCellClass() ?>"><div id="elh_query_production_table_sqm_a" class="query_production_table_sqm_a"><div class="ew-table-header-caption"><?php echo $query_production_table->sqm_a->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm_a" class="<?php echo $query_production_table->sqm_a->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->sqm_a) ?>',2);"><div id="elh_query_production_table_sqm_a" class="query_production_table_sqm_a">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->sqm_a->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->sqm_a->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->sqm_a->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->process_c->Visible) { // process_c ?>
	<?php if ($query_production_table->sortUrl($query_production_table->process_c) == "") { ?>
		<th data-name="process_c" class="<?php echo $query_production_table->process_c->headerCellClass() ?>"><div id="elh_query_production_table_process_c" class="query_production_table_process_c"><div class="ew-table-header-caption"><?php echo $query_production_table->process_c->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_c" class="<?php echo $query_production_table->process_c->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->process_c) ?>',2);"><div id="elh_query_production_table_process_c" class="query_production_table_process_c">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->process_c->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->process_c->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->process_c->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->process_d->Visible) { // process_d ?>
	<?php if ($query_production_table->sortUrl($query_production_table->process_d) == "") { ?>
		<th data-name="process_d" class="<?php echo $query_production_table->process_d->headerCellClass() ?>"><div id="elh_query_production_table_process_d" class="query_production_table_process_d"><div class="ew-table-header-caption"><?php echo $query_production_table->process_d->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_d" class="<?php echo $query_production_table->process_d->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->process_d) ?>',2);"><div id="elh_query_production_table_process_d" class="query_production_table_process_d">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->process_d->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->process_d->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->process_d->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->_barcode->Visible) { // barcode ?>
	<?php if ($query_production_table->sortUrl($query_production_table->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $query_production_table->_barcode->headerCellClass() ?>" style="width: 300px;"><div id="elh_query_production_table__barcode" class="query_production_table__barcode"><div class="ew-table-header-caption"><?php echo $query_production_table->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $query_production_table->_barcode->headerCellClass() ?>" style="width: 300px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->_barcode) ?>',2);"><div id="elh_query_production_table__barcode" class="query_production_table__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->status->Visible) { // status ?>
	<?php if ($query_production_table->sortUrl($query_production_table->status) == "") { ?>
		<th data-name="status" class="<?php echo $query_production_table->status->headerCellClass() ?>"><div id="elh_query_production_table_status" class="query_production_table_status"><div class="ew-table-header-caption"><?php echo $query_production_table->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $query_production_table->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->status) ?>',2);"><div id="elh_query_production_table_status" class="query_production_table_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->dispatch_week_p->Visible) { // dispatch_week_p ?>
	<?php if ($query_production_table->sortUrl($query_production_table->dispatch_week_p) == "") { ?>
		<th data-name="dispatch_week_p" class="<?php echo $query_production_table->dispatch_week_p->headerCellClass() ?>"><div id="elh_query_production_table_dispatch_week_p" class="query_production_table_dispatch_week_p"><div class="ew-table-header-caption"><?php echo $query_production_table->dispatch_week_p->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dispatch_week_p" class="<?php echo $query_production_table->dispatch_week_p->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->dispatch_week_p) ?>',2);"><div id="elh_query_production_table_dispatch_week_p" class="query_production_table_dispatch_week_p">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->dispatch_week_p->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->dispatch_week_p->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->dispatch_week_p->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->current_works->Visible) { // current_works ?>
	<?php if ($query_production_table->sortUrl($query_production_table->current_works) == "") { ?>
		<th data-name="current_works" class="<?php echo $query_production_table->current_works->headerCellClass() ?>"><div id="elh_query_production_table_current_works" class="query_production_table_current_works"><div class="ew-table-header-caption"><?php echo $query_production_table->current_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="current_works" class="<?php echo $query_production_table->current_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->current_works) ?>',2);"><div id="elh_query_production_table_current_works" class="query_production_table_current_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->current_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->current_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->current_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->batch_no->Visible) { // batch_no ?>
	<?php if ($query_production_table->sortUrl($query_production_table->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $query_production_table->batch_no->headerCellClass() ?>"><div id="elh_query_production_table_batch_no" class="query_production_table_batch_no"><div class="ew-table-header-caption"><?php echo $query_production_table->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $query_production_table->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->batch_no) ?>',2);"><div id="elh_query_production_table_batch_no" class="query_production_table_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production_table->buyer_barcode->Visible) { // buyer_barcode ?>
	<?php if ($query_production_table->sortUrl($query_production_table->buyer_barcode) == "") { ?>
		<th data-name="buyer_barcode" class="<?php echo $query_production_table->buyer_barcode->headerCellClass() ?>"><div id="elh_query_production_table_buyer_barcode" class="query_production_table_buyer_barcode"><div class="ew-table-header-caption"><?php echo $query_production_table->buyer_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_barcode" class="<?php echo $query_production_table->buyer_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production_table->SortUrl($query_production_table->buyer_barcode) ?>',2);"><div id="elh_query_production_table_buyer_barcode" class="query_production_table_buyer_barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production_table->buyer_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production_table->buyer_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production_table->buyer_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$query_production_table_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($query_production_table->ExportAll && $query_production_table->isExport()) {
	$query_production_table_list->StopRec = $query_production_table_list->TotalRecs;
} else {

	// Set the last record to display
	if ($query_production_table_list->TotalRecs > $query_production_table_list->StartRec + $query_production_table_list->DisplayRecs - 1)
		$query_production_table_list->StopRec = $query_production_table_list->StartRec + $query_production_table_list->DisplayRecs - 1;
	else
		$query_production_table_list->StopRec = $query_production_table_list->TotalRecs;
}
$query_production_table_list->RecCnt = $query_production_table_list->StartRec - 1;
if ($query_production_table_list->Recordset && !$query_production_table_list->Recordset->EOF) {
	$query_production_table_list->Recordset->moveFirst();
	$selectLimit = $query_production_table_list->UseSelectLimit;
	if (!$selectLimit && $query_production_table_list->StartRec > 1)
		$query_production_table_list->Recordset->move($query_production_table_list->StartRec - 1);
} elseif (!$query_production_table->AllowAddDeleteRow && $query_production_table_list->StopRec == 0) {
	$query_production_table_list->StopRec = $query_production_table->GridAddRowCount;
}

// Initialize aggregate
$query_production_table->RowType = ROWTYPE_AGGREGATEINIT;
$query_production_table->resetAttributes();
$query_production_table_list->renderRow();
while ($query_production_table_list->RecCnt < $query_production_table_list->StopRec) {
	$query_production_table_list->RecCnt++;
	if ($query_production_table_list->RecCnt >= $query_production_table_list->StartRec) {
		$query_production_table_list->RowCnt++;

		// Set up key count
		$query_production_table_list->KeyCount = $query_production_table_list->RowIndex;

		// Init row class and style
		$query_production_table->resetAttributes();
		$query_production_table->CssClass = "";
		if ($query_production_table->isGridAdd()) {
		} else {
			$query_production_table_list->loadRowValues($query_production_table_list->Recordset); // Load row values
		}
		$query_production_table->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$query_production_table->RowAttrs = array_merge($query_production_table->RowAttrs, array('data-rowindex'=>$query_production_table_list->RowCnt, 'id'=>'r' . $query_production_table_list->RowCnt . '_query_production_table', 'data-rowtype'=>$query_production_table->RowType));

		// Render row
		$query_production_table_list->renderRow();

		// Render list options
		$query_production_table_list->renderListOptions();
?>
	<tr<?php echo $query_production_table->rowAttributes() ?>>
<?php

// Render list options (body, left)
$query_production_table_list->ListOptions->render("body", "left", $query_production_table_list->RowCnt);
?>
	<?php if ($query_production_table->buyer->Visible) { // buyer ?>
		<td data-name="buyer"<?php echo $query_production_table->buyer->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_buyer" class="query_production_table_buyer">
<span<?php echo $query_production_table->buyer->viewAttributes() ?>>
<?php echo $query_production_table->buyer->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->po->Visible) { // po ?>
		<td data-name="po"<?php echo $query_production_table->po->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_po" class="query_production_table_po">
<span<?php echo $query_production_table->po->viewAttributes() ?>>
<?php if ((!EmptyString($query_production_table->po->getViewValue())) && $query_production_table->po->linkAttributes() <> "") { ?>
<a<?php echo $query_production_table->po->linkAttributes() ?>><?php echo $query_production_table->po->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production_table->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref"<?php echo $query_production_table->buyer_ref->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_buyer_ref" class="query_production_table_buyer_ref">
<span<?php echo $query_production_table->buyer_ref->viewAttributes() ?>>
<?php echo $query_production_table->buyer_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm"<?php echo $query_production_table->size_cm->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_size_cm" class="query_production_table_size_cm">
<span<?php echo $query_production_table->size_cm->viewAttributes() ?>>
<?php if ((!EmptyString($query_production_table->size_cm->getViewValue())) && $query_production_table->size_cm->linkAttributes() <> "") { ?>
<a<?php echo $query_production_table->size_cm->linkAttributes() ?>><?php echo $query_production_table->size_cm->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production_table->size_cm->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->Weaving->Visible) { // Weaving ?>
		<td data-name="Weaving"<?php echo $query_production_table->Weaving->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_Weaving" class="query_production_table_Weaving">
<span<?php echo $query_production_table->Weaving->viewAttributes() ?>>
<?php if ((!EmptyString($query_production_table->Weaving->getViewValue())) && $query_production_table->Weaving->linkAttributes() <> "") { ?>
<a<?php echo $query_production_table->Weaving->linkAttributes() ?>><?php echo $query_production_table->Weaving->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production_table->Weaving->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->Packing->Visible) { // Packing ?>
		<td data-name="Packing"<?php echo $query_production_table->Packing->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_Packing" class="query_production_table_Packing">
<span<?php echo $query_production_table->Packing->viewAttributes() ?>>
<?php if ((!EmptyString($query_production_table->Packing->getViewValue())) && $query_production_table->Packing->linkAttributes() <> "") { ?>
<a<?php echo $query_production_table->Packing->linkAttributes() ?>><?php echo $query_production_table->Packing->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production_table->Packing->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->order_quantity->Visible) { // order_quantity ?>
		<td data-name="order_quantity"<?php echo $query_production_table->order_quantity->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_order_quantity" class="query_production_table_order_quantity">
<span<?php echo $query_production_table->order_quantity->viewAttributes() ?>>
<?php echo $query_production_table->order_quantity->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->count->Visible) { // count ?>
		<td data-name="count"<?php echo $query_production_table->count->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_count" class="query_production_table_count">
<span<?php echo $query_production_table->count->viewAttributes() ?>>
<?php echo $query_production_table->count->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $query_production_table->sqm->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_sqm" class="query_production_table_sqm">
<span<?php echo $query_production_table->sqm->viewAttributes() ?>>
<?php echo $query_production_table->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->sqm_a->Visible) { // sqm_a ?>
		<td data-name="sqm_a"<?php echo $query_production_table->sqm_a->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_sqm_a" class="query_production_table_sqm_a">
<span<?php echo $query_production_table->sqm_a->viewAttributes() ?>>
<?php echo $query_production_table->sqm_a->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->process_c->Visible) { // process_c ?>
		<td data-name="process_c"<?php echo $query_production_table->process_c->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_process_c" class="query_production_table_process_c">
<span<?php echo $query_production_table->process_c->viewAttributes() ?>>
<?php echo $query_production_table->process_c->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->process_d->Visible) { // process_d ?>
		<td data-name="process_d"<?php echo $query_production_table->process_d->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_process_d" class="query_production_table_process_d">
<span<?php echo $query_production_table->process_d->viewAttributes() ?>>
<?php echo $query_production_table->process_d->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $query_production_table->_barcode->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table__barcode" class="query_production_table__barcode">
<span<?php echo $query_production_table->_barcode->viewAttributes() ?>>
<?php if ((!EmptyString($query_production_table->_barcode->getViewValue())) && $query_production_table->_barcode->linkAttributes() <> "") { ?>
<a<?php echo $query_production_table->_barcode->linkAttributes() ?>><?php echo $query_production_table->_barcode->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production_table->_barcode->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->status->Visible) { // status ?>
		<td data-name="status"<?php echo $query_production_table->status->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_status" class="query_production_table_status">
<span<?php echo $query_production_table->status->viewAttributes() ?>>
<?php echo $query_production_table->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->dispatch_week_p->Visible) { // dispatch_week_p ?>
		<td data-name="dispatch_week_p"<?php echo $query_production_table->dispatch_week_p->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_dispatch_week_p" class="query_production_table_dispatch_week_p">
<span<?php echo $query_production_table->dispatch_week_p->viewAttributes() ?>>
<?php echo $query_production_table->dispatch_week_p->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->current_works->Visible) { // current_works ?>
		<td data-name="current_works"<?php echo $query_production_table->current_works->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_current_works" class="query_production_table_current_works">
<span<?php echo $query_production_table->current_works->viewAttributes() ?>>
<?php if ((!EmptyString($query_production_table->current_works->getViewValue())) && $query_production_table->current_works->linkAttributes() <> "") { ?>
<a<?php echo $query_production_table->current_works->linkAttributes() ?>><?php echo $query_production_table->current_works->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production_table->current_works->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $query_production_table->batch_no->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_batch_no" class="query_production_table_batch_no">
<span<?php echo $query_production_table->batch_no->viewAttributes() ?>>
<?php echo $query_production_table->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production_table->buyer_barcode->Visible) { // buyer_barcode ?>
		<td data-name="buyer_barcode"<?php echo $query_production_table->buyer_barcode->cellAttributes() ?>>
<span id="el<?php echo $query_production_table_list->RowCnt ?>_query_production_table_buyer_barcode" class="query_production_table_buyer_barcode">
<span<?php echo $query_production_table->buyer_barcode->viewAttributes() ?>>
<?php echo $query_production_table->buyer_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$query_production_table_list->ListOptions->render("body", "right", $query_production_table_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$query_production_table->isGridAdd())
		$query_production_table_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$query_production_table->RowType = ROWTYPE_AGGREGATE;
$query_production_table->resetAttributes();
$query_production_table_list->renderRow();
?>
<?php if ($query_production_table_list->TotalRecs > 0 && !$query_production_table->isGridAdd() && !$query_production_table->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$query_production_table_list->renderListOptions();

// Render list options (footer, left)
$query_production_table_list->ListOptions->render("footer", "left");
?>
	<?php if ($query_production_table->buyer->Visible) { // buyer ?>
		<td data-name="buyer" class="<?php echo $query_production_table->buyer->footerCellClass() ?>"><span id="elf_query_production_table_buyer" class="query_production_table_buyer">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $query_production_table->po->footerCellClass() ?>"><span id="elf_query_production_table_po" class="query_production_table_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref" class="<?php echo $query_production_table->buyer_ref->footerCellClass() ?>"><span id="elf_query_production_table_buyer_ref" class="query_production_table_buyer_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm" class="<?php echo $query_production_table->size_cm->footerCellClass() ?>"><span id="elf_query_production_table_size_cm" class="query_production_table_size_cm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->Weaving->Visible) { // Weaving ?>
		<td data-name="Weaving" class="<?php echo $query_production_table->Weaving->footerCellClass() ?>"><span id="elf_query_production_table_Weaving" class="query_production_table_Weaving">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->Packing->Visible) { // Packing ?>
		<td data-name="Packing" class="<?php echo $query_production_table->Packing->footerCellClass() ?>"><span id="elf_query_production_table_Packing" class="query_production_table_Packing">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->order_quantity->Visible) { // order_quantity ?>
		<td data-name="order_quantity" class="<?php echo $query_production_table->order_quantity->footerCellClass() ?>"><span id="elf_query_production_table_order_quantity" class="query_production_table_order_quantity">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->count->Visible) { // count ?>
		<td data-name="count" class="<?php echo $query_production_table->count->footerCellClass() ?>"><span id="elf_query_production_table_count" class="query_production_table_count">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $query_production_table->count->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $query_production_table->sqm->footerCellClass() ?>"><span id="elf_query_production_table_sqm" class="query_production_table_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $query_production_table->sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->sqm_a->Visible) { // sqm_a ?>
		<td data-name="sqm_a" class="<?php echo $query_production_table->sqm_a->footerCellClass() ?>"><span id="elf_query_production_table_sqm_a" class="query_production_table_sqm_a">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $query_production_table->sqm_a->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->process_c->Visible) { // process_c ?>
		<td data-name="process_c" class="<?php echo $query_production_table->process_c->footerCellClass() ?>"><span id="elf_query_production_table_process_c" class="query_production_table_process_c">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->process_d->Visible) { // process_d ?>
		<td data-name="process_d" class="<?php echo $query_production_table->process_d->footerCellClass() ?>"><span id="elf_query_production_table_process_d" class="query_production_table_process_d">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode" class="<?php echo $query_production_table->_barcode->footerCellClass() ?>"><span id="elf_query_production_table__barcode" class="query_production_table__barcode">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->status->Visible) { // status ?>
		<td data-name="status" class="<?php echo $query_production_table->status->footerCellClass() ?>"><span id="elf_query_production_table_status" class="query_production_table_status">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->dispatch_week_p->Visible) { // dispatch_week_p ?>
		<td data-name="dispatch_week_p" class="<?php echo $query_production_table->dispatch_week_p->footerCellClass() ?>"><span id="elf_query_production_table_dispatch_week_p" class="query_production_table_dispatch_week_p">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->current_works->Visible) { // current_works ?>
		<td data-name="current_works" class="<?php echo $query_production_table->current_works->footerCellClass() ?>"><span id="elf_query_production_table_current_works" class="query_production_table_current_works">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no" class="<?php echo $query_production_table->batch_no->footerCellClass() ?>"><span id="elf_query_production_table_batch_no" class="query_production_table_batch_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production_table->buyer_barcode->Visible) { // buyer_barcode ?>
		<td data-name="buyer_barcode" class="<?php echo $query_production_table->buyer_barcode->footerCellClass() ?>"><span id="elf_query_production_table_buyer_barcode" class="query_production_table_buyer_barcode">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$query_production_table_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$query_production_table->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($query_production_table_list->Recordset)
	$query_production_table_list->Recordset->Close();
?>
<?php if (!$query_production_table->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$query_production_table->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($query_production_table_list->Pager)) $query_production_table_list->Pager = new PrevNextPager($query_production_table_list->StartRec, $query_production_table_list->DisplayRecs, $query_production_table_list->TotalRecs, $query_production_table_list->AutoHidePager) ?>
<?php if ($query_production_table_list->Pager->RecordCount > 0 && $query_production_table_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($query_production_table_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $query_production_table_list->pageUrl() ?>start=<?php echo $query_production_table_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($query_production_table_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $query_production_table_list->pageUrl() ?>start=<?php echo $query_production_table_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $query_production_table_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($query_production_table_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $query_production_table_list->pageUrl() ?>start=<?php echo $query_production_table_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($query_production_table_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $query_production_table_list->pageUrl() ?>start=<?php echo $query_production_table_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $query_production_table_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($query_production_table_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $query_production_table_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $query_production_table_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $query_production_table_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($query_production_table_list->TotalRecs > 0 && (!$query_production_table_list->AutoHidePageSizeSelector || $query_production_table_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="query_production_table">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($query_production_table_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($query_production_table_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($query_production_table_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($query_production_table->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $query_production_table_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($query_production_table_list->TotalRecs == 0 && !$query_production_table->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $query_production_table_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$query_production_table_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$query_production_table->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$query_production_table->isExport()) { ?>
<script>
ew.scrollableTable("gmp_query_production_table", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$query_production_table_list->terminate();
?>