<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$query_production_table_view = new query_production_table_view();

// Run the page
$query_production_table_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$query_production_table_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$query_production_table->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fquery_production_tableview = currentForm = new ew.Form("fquery_production_tableview", "view");

// Form_CustomValidate event
fquery_production_tableview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fquery_production_tableview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fquery_production_tableview.lists["x_buyer"] = <?php echo $query_production_table_view->buyer->Lookup->toClientList() ?>;
fquery_production_tableview.lists["x_buyer"].options = <?php echo JsonEncode($query_production_table_view->buyer->lookupOptions()) ?>;
fquery_production_tableview.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fquery_production_tableview.lists["x_design_id"] = <?php echo $query_production_table_view->design_id->Lookup->toClientList() ?>;
fquery_production_tableview.lists["x_design_id"].options = <?php echo JsonEncode($query_production_table_view->design_id->lookupOptions()) ?>;
fquery_production_tableview.lists["x_Weaving"] = <?php echo $query_production_table_view->Weaving->Lookup->toClientList() ?>;
fquery_production_tableview.lists["x_Weaving"].options = <?php echo JsonEncode($query_production_table_view->Weaving->options(FALSE, TRUE)) ?>;
fquery_production_tableview.lists["x_Packing"] = <?php echo $query_production_table_view->Packing->Lookup->toClientList() ?>;
fquery_production_tableview.lists["x_Packing"].options = <?php echo JsonEncode($query_production_table_view->Packing->options(FALSE, TRUE)) ?>;
fquery_production_tableview.lists["x_status"] = <?php echo $query_production_table_view->status->Lookup->toClientList() ?>;
fquery_production_tableview.lists["x_status"].options = <?php echo JsonEncode($query_production_table_view->status->lookupOptions()) ?>;
fquery_production_tableview.lists["x_dispatch_week_p"] = <?php echo $query_production_table_view->dispatch_week_p->Lookup->toClientList() ?>;
fquery_production_tableview.lists["x_dispatch_week_p"].options = <?php echo JsonEncode($query_production_table_view->dispatch_week_p->lookupOptions()) ?>;
fquery_production_tableview.lists["x_current_works"] = <?php echo $query_production_table_view->current_works->Lookup->toClientList() ?>;
fquery_production_tableview.lists["x_current_works"].options = <?php echo JsonEncode($query_production_table_view->current_works->lookupOptions()) ?>;
fquery_production_tableview.lists["x_batch_no"] = <?php echo $query_production_table_view->batch_no->Lookup->toClientList() ?>;
fquery_production_tableview.lists["x_batch_no"].options = <?php echo JsonEncode($query_production_table_view->batch_no->lookupOptions()) ?>;
fquery_production_tableview.lists["x_process[]"] = <?php echo $query_production_table_view->process->Lookup->toClientList() ?>;
fquery_production_tableview.lists["x_process[]"].options = <?php echo JsonEncode($query_production_table_view->process->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$query_production_table->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $query_production_table_view->ExportOptions->render("body") ?>
<?php $query_production_table_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $query_production_table_view->showPageHeader(); ?>
<?php
$query_production_table_view->showMessage();
?>
<form name="fquery_production_tableview" id="fquery_production_tableview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($query_production_table_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $query_production_table_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="query_production_table">
<input type="hidden" name="modal" value="<?php echo (int)$query_production_table_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($query_production_table->buyer->Visible) { // buyer ?>
	<tr id="r_buyer">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_buyer"><?php echo $query_production_table->buyer->caption() ?></span></td>
		<td data-name="buyer"<?php echo $query_production_table->buyer->cellAttributes() ?>>
<span id="el_query_production_table_buyer">
<span<?php echo $query_production_table->buyer->viewAttributes() ?>>
<?php echo $query_production_table->buyer->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->po->Visible) { // po ?>
	<tr id="r_po">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_po"><?php echo $query_production_table->po->caption() ?></span></td>
		<td data-name="po"<?php echo $query_production_table->po->cellAttributes() ?>>
<span id="el_query_production_table_po">
<span<?php echo $query_production_table->po->viewAttributes() ?>>
<?php if ((!EmptyString($query_production_table->po->getViewValue())) && $query_production_table->po->linkAttributes() <> "") { ?>
<a<?php echo $query_production_table->po->linkAttributes() ?>><?php echo $query_production_table->po->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production_table->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->buyer_ref->Visible) { // buyer_ref ?>
	<tr id="r_buyer_ref">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_buyer_ref"><?php echo $query_production_table->buyer_ref->caption() ?></span></td>
		<td data-name="buyer_ref"<?php echo $query_production_table->buyer_ref->cellAttributes() ?>>
<span id="el_query_production_table_buyer_ref">
<span<?php echo $query_production_table->buyer_ref->viewAttributes() ?>>
<?php echo $query_production_table->buyer_ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->design_id->Visible) { // design_id ?>
	<tr id="r_design_id">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_design_id"><?php echo $query_production_table->design_id->caption() ?></span></td>
		<td data-name="design_id"<?php echo $query_production_table->design_id->cellAttributes() ?>>
<span id="el_query_production_table_design_id">
<span<?php echo $query_production_table->design_id->viewAttributes() ?>>
<?php echo $query_production_table->design_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->size_cm->Visible) { // size_cm ?>
	<tr id="r_size_cm">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_size_cm"><?php echo $query_production_table->size_cm->caption() ?></span></td>
		<td data-name="size_cm"<?php echo $query_production_table->size_cm->cellAttributes() ?>>
<span id="el_query_production_table_size_cm">
<span<?php echo $query_production_table->size_cm->viewAttributes() ?>>
<?php if ((!EmptyString($query_production_table->size_cm->getViewValue())) && $query_production_table->size_cm->linkAttributes() <> "") { ?>
<a<?php echo $query_production_table->size_cm->linkAttributes() ?>><?php echo $query_production_table->size_cm->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production_table->size_cm->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->Weaving->Visible) { // Weaving ?>
	<tr id="r_Weaving">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_Weaving"><?php echo $query_production_table->Weaving->caption() ?></span></td>
		<td data-name="Weaving"<?php echo $query_production_table->Weaving->cellAttributes() ?>>
<span id="el_query_production_table_Weaving">
<span<?php echo $query_production_table->Weaving->viewAttributes() ?>>
<?php if ((!EmptyString($query_production_table->Weaving->getViewValue())) && $query_production_table->Weaving->linkAttributes() <> "") { ?>
<a<?php echo $query_production_table->Weaving->linkAttributes() ?>><?php echo $query_production_table->Weaving->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production_table->Weaving->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->Packing->Visible) { // Packing ?>
	<tr id="r_Packing">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_Packing"><?php echo $query_production_table->Packing->caption() ?></span></td>
		<td data-name="Packing"<?php echo $query_production_table->Packing->cellAttributes() ?>>
<span id="el_query_production_table_Packing">
<span<?php echo $query_production_table->Packing->viewAttributes() ?>>
<?php if ((!EmptyString($query_production_table->Packing->getViewValue())) && $query_production_table->Packing->linkAttributes() <> "") { ?>
<a<?php echo $query_production_table->Packing->linkAttributes() ?>><?php echo $query_production_table->Packing->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production_table->Packing->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->order_quantity->Visible) { // order_quantity ?>
	<tr id="r_order_quantity">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_order_quantity"><?php echo $query_production_table->order_quantity->caption() ?></span></td>
		<td data-name="order_quantity"<?php echo $query_production_table->order_quantity->cellAttributes() ?>>
<span id="el_query_production_table_order_quantity">
<span<?php echo $query_production_table->order_quantity->viewAttributes() ?>>
<?php echo $query_production_table->order_quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->count->Visible) { // count ?>
	<tr id="r_count">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_count"><?php echo $query_production_table->count->caption() ?></span></td>
		<td data-name="count"<?php echo $query_production_table->count->cellAttributes() ?>>
<span id="el_query_production_table_count">
<span<?php echo $query_production_table->count->viewAttributes() ?>>
<?php echo $query_production_table->count->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->sqm->Visible) { // sqm ?>
	<tr id="r_sqm">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_sqm"><?php echo $query_production_table->sqm->caption() ?></span></td>
		<td data-name="sqm"<?php echo $query_production_table->sqm->cellAttributes() ?>>
<span id="el_query_production_table_sqm">
<span<?php echo $query_production_table->sqm->viewAttributes() ?>>
<?php echo $query_production_table->sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->sqm_a->Visible) { // sqm_a ?>
	<tr id="r_sqm_a">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_sqm_a"><?php echo $query_production_table->sqm_a->caption() ?></span></td>
		<td data-name="sqm_a"<?php echo $query_production_table->sqm_a->cellAttributes() ?>>
<span id="el_query_production_table_sqm_a">
<span<?php echo $query_production_table->sqm_a->viewAttributes() ?>>
<?php echo $query_production_table->sqm_a->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->process_c->Visible) { // process_c ?>
	<tr id="r_process_c">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_process_c"><?php echo $query_production_table->process_c->caption() ?></span></td>
		<td data-name="process_c"<?php echo $query_production_table->process_c->cellAttributes() ?>>
<span id="el_query_production_table_process_c">
<span<?php echo $query_production_table->process_c->viewAttributes() ?>>
<?php echo $query_production_table->process_c->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->process_d->Visible) { // process_d ?>
	<tr id="r_process_d">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_process_d"><?php echo $query_production_table->process_d->caption() ?></span></td>
		<td data-name="process_d"<?php echo $query_production_table->process_d->cellAttributes() ?>>
<span id="el_query_production_table_process_d">
<span<?php echo $query_production_table->process_d->viewAttributes() ?>>
<?php echo $query_production_table->process_d->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->_barcode->Visible) { // barcode ?>
	<tr id="r__barcode">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table__barcode"><?php echo $query_production_table->_barcode->caption() ?></span></td>
		<td data-name="_barcode"<?php echo $query_production_table->_barcode->cellAttributes() ?>>
<span id="el_query_production_table__barcode">
<span<?php echo $query_production_table->_barcode->viewAttributes() ?>>
<?php if ((!EmptyString($query_production_table->_barcode->getViewValue())) && $query_production_table->_barcode->linkAttributes() <> "") { ?>
<a<?php echo $query_production_table->_barcode->linkAttributes() ?>><?php echo $query_production_table->_barcode->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production_table->_barcode->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_status"><?php echo $query_production_table->status->caption() ?></span></td>
		<td data-name="status"<?php echo $query_production_table->status->cellAttributes() ?>>
<span id="el_query_production_table_status">
<span<?php echo $query_production_table->status->viewAttributes() ?>>
<?php echo $query_production_table->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->dispatch_week_p->Visible) { // dispatch_week_p ?>
	<tr id="r_dispatch_week_p">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_dispatch_week_p"><?php echo $query_production_table->dispatch_week_p->caption() ?></span></td>
		<td data-name="dispatch_week_p"<?php echo $query_production_table->dispatch_week_p->cellAttributes() ?>>
<span id="el_query_production_table_dispatch_week_p">
<span<?php echo $query_production_table->dispatch_week_p->viewAttributes() ?>>
<?php echo $query_production_table->dispatch_week_p->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->current_works->Visible) { // current_works ?>
	<tr id="r_current_works">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_current_works"><?php echo $query_production_table->current_works->caption() ?></span></td>
		<td data-name="current_works"<?php echo $query_production_table->current_works->cellAttributes() ?>>
<span id="el_query_production_table_current_works">
<span<?php echo $query_production_table->current_works->viewAttributes() ?>>
<?php if ((!EmptyString($query_production_table->current_works->getViewValue())) && $query_production_table->current_works->linkAttributes() <> "") { ?>
<a<?php echo $query_production_table->current_works->linkAttributes() ?>><?php echo $query_production_table->current_works->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production_table->current_works->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->batch_no->Visible) { // batch_no ?>
	<tr id="r_batch_no">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_batch_no"><?php echo $query_production_table->batch_no->caption() ?></span></td>
		<td data-name="batch_no"<?php echo $query_production_table->batch_no->cellAttributes() ?>>
<span id="el_query_production_table_batch_no">
<span<?php echo $query_production_table->batch_no->viewAttributes() ?>>
<?php echo $query_production_table->batch_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_process"><?php echo $query_production_table->process->caption() ?></span></td>
		<td data-name="process"<?php echo $query_production_table->process->cellAttributes() ?>>
<span id="el_query_production_table_process">
<span<?php echo $query_production_table->process->viewAttributes() ?>>
<?php echo $query_production_table->process->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->URL_DSP->Visible) { // URL_DSP ?>
	<tr id="r_URL_DSP">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_URL_DSP"><?php echo $query_production_table->URL_DSP->caption() ?></span></td>
		<td data-name="URL_DSP"<?php echo $query_production_table->URL_DSP->cellAttributes() ?>>
<span id="el_query_production_table_URL_DSP">
<span<?php echo $query_production_table->URL_DSP->viewAttributes() ?>>
<?php echo $query_production_table->URL_DSP->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production_table->buyer_barcode->Visible) { // buyer_barcode ?>
	<tr id="r_buyer_barcode">
		<td class="<?php echo $query_production_table_view->TableLeftColumnClass ?>"><span id="elh_query_production_table_buyer_barcode"><?php echo $query_production_table->buyer_barcode->caption() ?></span></td>
		<td data-name="buyer_barcode"<?php echo $query_production_table->buyer_barcode->cellAttributes() ?>>
<span id="el_query_production_table_buyer_barcode">
<span<?php echo $query_production_table->buyer_barcode->viewAttributes() ?>>
<?php echo $query_production_table->buyer_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$query_production_table_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$query_production_table->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$query_production_table_view->terminate();
?>