<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$query_production_list = new query_production_list();

// Run the page
$query_production_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$query_production_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$query_production->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fquery_productionlist = currentForm = new ew.Form("fquery_productionlist", "list");
fquery_productionlist.formKeyCountName = '<?php echo $query_production_list->FormKeyCountName ?>';

// Form_CustomValidate event
fquery_productionlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fquery_productionlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fquery_productionlist.lists["x_buyer"] = <?php echo $query_production_list->buyer->Lookup->toClientList() ?>;
fquery_productionlist.lists["x_buyer"].options = <?php echo JsonEncode($query_production_list->buyer->lookupOptions()) ?>;
fquery_productionlist.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fquery_productionlist.lists["x_po"] = <?php echo $query_production_list->po->Lookup->toClientList() ?>;
fquery_productionlist.lists["x_po"].options = <?php echo JsonEncode($query_production_list->po->lookupOptions()) ?>;
fquery_productionlist.autoSuggests["x_po"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fquery_productionlist.lists["x_Weaving"] = <?php echo $query_production_list->Weaving->Lookup->toClientList() ?>;
fquery_productionlist.lists["x_Weaving"].options = <?php echo JsonEncode($query_production_list->Weaving->options(FALSE, TRUE)) ?>;
fquery_productionlist.lists["x_Packing"] = <?php echo $query_production_list->Packing->Lookup->toClientList() ?>;
fquery_productionlist.lists["x_Packing"].options = <?php echo JsonEncode($query_production_list->Packing->options(FALSE, TRUE)) ?>;
fquery_productionlist.lists["x_status"] = <?php echo $query_production_list->status->Lookup->toClientList() ?>;
fquery_productionlist.lists["x_status"].options = <?php echo JsonEncode($query_production_list->status->lookupOptions()) ?>;
fquery_productionlist.lists["x_dispatch_week_p"] = <?php echo $query_production_list->dispatch_week_p->Lookup->toClientList() ?>;
fquery_productionlist.lists["x_dispatch_week_p"].options = <?php echo JsonEncode($query_production_list->dispatch_week_p->lookupOptions()) ?>;
fquery_productionlist.lists["x_current_works"] = <?php echo $query_production_list->current_works->Lookup->toClientList() ?>;
fquery_productionlist.lists["x_current_works"].options = <?php echo JsonEncode($query_production_list->current_works->lookupOptions()) ?>;
fquery_productionlist.lists["x_shipping_type"] = <?php echo $query_production_list->shipping_type->Lookup->toClientList() ?>;
fquery_productionlist.lists["x_shipping_type"].options = <?php echo JsonEncode($query_production_list->shipping_type->lookupOptions()) ?>;
fquery_productionlist.lists["x_batch_no"] = <?php echo $query_production_list->batch_no->Lookup->toClientList() ?>;
fquery_productionlist.lists["x_batch_no"].options = <?php echo JsonEncode($query_production_list->batch_no->lookupOptions()) ?>;

// Form object for search
var fquery_productionlistsrch = currentSearchForm = new ew.Form("fquery_productionlistsrch");

// Validate function for search
fquery_productionlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fquery_productionlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fquery_productionlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fquery_productionlistsrch.lists["x_buyer"] = <?php echo $query_production_list->buyer->Lookup->toClientList() ?>;
fquery_productionlistsrch.lists["x_buyer"].options = <?php echo JsonEncode($query_production_list->buyer->lookupOptions()) ?>;
fquery_productionlistsrch.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fquery_productionlistsrch.lists["x_po"] = <?php echo $query_production_list->po->Lookup->toClientList() ?>;
fquery_productionlistsrch.lists["x_po"].options = <?php echo JsonEncode($query_production_list->po->lookupOptions()) ?>;
fquery_productionlistsrch.autoSuggests["x_po"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fquery_productionlistsrch.lists["x_Weaving"] = <?php echo $query_production_list->Weaving->Lookup->toClientList() ?>;
fquery_productionlistsrch.lists["x_Weaving"].options = <?php echo JsonEncode($query_production_list->Weaving->options(FALSE, TRUE)) ?>;
fquery_productionlistsrch.lists["x_Packing"] = <?php echo $query_production_list->Packing->Lookup->toClientList() ?>;
fquery_productionlistsrch.lists["x_Packing"].options = <?php echo JsonEncode($query_production_list->Packing->options(FALSE, TRUE)) ?>;
fquery_productionlistsrch.lists["x_dispatch_week_p"] = <?php echo $query_production_list->dispatch_week_p->Lookup->toClientList() ?>;
fquery_productionlistsrch.lists["x_dispatch_week_p"].options = <?php echo JsonEncode($query_production_list->dispatch_week_p->lookupOptions()) ?>;
fquery_productionlistsrch.lists["x_current_works"] = <?php echo $query_production_list->current_works->Lookup->toClientList() ?>;
fquery_productionlistsrch.lists["x_current_works"].options = <?php echo JsonEncode($query_production_list->current_works->lookupOptions()) ?>;

// Filters
fquery_productionlistsrch.filterList = <?php echo $query_production_list->getFilterList() ?>;

// Init search panel as collapsed
fquery_productionlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$query_production->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($query_production_list->TotalRecs > 0 && $query_production_list->ExportOptions->visible()) { ?>
<?php $query_production_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($query_production_list->ImportOptions->visible()) { ?>
<?php $query_production_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($query_production_list->SearchOptions->visible()) { ?>
<?php $query_production_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($query_production_list->FilterOptions->visible()) { ?>
<?php $query_production_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$query_production_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$query_production->isExport() && !$query_production->CurrentAction) { ?>
<form name="fquery_productionlistsrch" id="fquery_productionlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($query_production_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fquery_productionlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="query_production">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$query_production_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$query_production->RowType = ROWTYPE_SEARCH;

// Render row
$query_production->resetAttributes();
$query_production_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($query_production->buyer->Visible) { // buyer ?>
	<div id="xsc_buyer" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $query_production->buyer->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer" id="z_buyer" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$query_production->buyer->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$query_production->buyer->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer" class="text-nowrap" style="z-index: 8990">
	<input type="text" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?php echo RemoveHtml($query_production->buyer->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($query_production->buyer->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($query_production->buyer->getPlaceHolder()) ?>"<?php echo $query_production->buyer->editAttributes() ?>>
</span>
<input type="hidden" data-table="query_production" data-field="x_buyer" data-value-separator="<?php echo $query_production->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?php echo HtmlEncode($query_production->buyer->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fquery_productionlistsrch.createAutoSuggest({"id":"x_buyer","forceSelect":false});
</script>
<?php echo $query_production->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
	</div>
<?php } ?>
<?php if ($query_production->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $query_production->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($query_production->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($query_production->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($query_production->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($query_production->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($query_production->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($query_production->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($query_production->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($query_production->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($query_production->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$query_production->po->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$query_production->po->EditAttrs["onchange"] = "";
?>
<span id="as_x_po" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_po" id="sv_x_po" value="<?php echo RemoveHtml($query_production->po->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($query_production->po->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($query_production->po->getPlaceHolder()) ?>"<?php echo $query_production->po->editAttributes() ?>>
</span>
<input type="hidden" data-table="query_production" data-field="x_po" data-value-separator="<?php echo $query_production->po->displayValueSeparatorAttribute() ?>" name="x_po" id="x_po" value="<?php echo HtmlEncode($query_production->po->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fquery_productionlistsrch.createAutoSuggest({"id":"x_po","forceSelect":false});
</script>
<?php echo $query_production->po->Lookup->getParamTag("p_x_po") ?>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<?php
$wrkonchange = "" . trim(@$query_production->po->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$query_production->po->EditAttrs["onchange"] = "";
?>
<span id="as_y_po" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_y_po" id="sv_y_po" value="<?php echo RemoveHtml($query_production->po->EditValue2) ?>" size="30" placeholder="<?php echo HtmlEncode($query_production->po->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($query_production->po->getPlaceHolder()) ?>"<?php echo $query_production->po->editAttributes() ?>>
</span>
<input type="hidden" data-table="query_production" data-field="x_po" data-value-separator="<?php echo $query_production->po->displayValueSeparatorAttribute() ?>" name="y_po" id="y_po" value="<?php echo HtmlEncode($query_production->po->AdvancedSearch->SearchValue2) ?>"<?php echo $wrkonchange ?>>
<script>
fquery_productionlistsrch.createAutoSuggest({"id":"y_po","forceSelect":false});
</script>
<?php echo $query_production->po->Lookup->getParamTag("p_y_po") ?>
</span>
	</div>
<?php } ?>
<?php if ($query_production->buyer_ref->Visible) { // buyer_ref ?>
	<div id="xsc_buyer_ref" class="ew-cell form-group">
		<label for="x_buyer_ref" class="ew-search-caption ew-label"><?php echo $query_production->buyer_ref->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="query_production" data-field="x_buyer_ref" name="x_buyer_ref" id="x_buyer_ref" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($query_production->buyer_ref->getPlaceHolder()) ?>" value="<?php echo $query_production->buyer_ref->EditValue ?>"<?php echo $query_production->buyer_ref->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($query_production->size_cm->Visible) { // size_cm ?>
	<div id="xsc_size_cm" class="ew-cell form-group">
		<label for="x_size_cm" class="ew-search-caption ew-label"><?php echo $query_production->size_cm->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="query_production" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($query_production->size_cm->getPlaceHolder()) ?>" value="<?php echo $query_production->size_cm->EditValue ?>"<?php echo $query_production->size_cm->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($query_production->Weaving->Visible) { // Weaving ?>
	<div id="xsc_Weaving" class="ew-cell form-group">
		<label for="x_Weaving" class="ew-search-caption ew-label"><?php echo $query_production->Weaving->caption() ?></label>
		<span class="ew-search-operator"><select name="z_Weaving" id="z_Weaving" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="BETWEEN"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_Weaving" data-value-separator="<?php echo $query_production->Weaving->displayValueSeparatorAttribute() ?>" id="x_Weaving" name="x_Weaving"<?php echo $query_production->Weaving->editAttributes() ?>>
		<?php echo $query_production->Weaving->selectOptionListHtml("x_Weaving") ?>
	</select>
</div>
</span>
		<span class="ew-search-cond btw1_Weaving style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_Weaving style="d-none"">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_Weaving" data-value-separator="<?php echo $query_production->Weaving->displayValueSeparatorAttribute() ?>" id="y_Weaving" name="y_Weaving"<?php echo $query_production->Weaving->editAttributes() ?>>
		<?php echo $query_production->Weaving->selectOptionListHtml("y_Weaving") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($query_production->Packing->Visible) { // Packing ?>
	<div id="xsc_Packing" class="ew-cell form-group">
		<label for="x_Packing" class="ew-search-caption ew-label"><?php echo $query_production->Packing->caption() ?></label>
		<span class="ew-search-operator"><select name="z_Packing" id="z_Packing" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_Packing" data-value-separator="<?php echo $query_production->Packing->displayValueSeparatorAttribute() ?>" id="x_Packing" name="x_Packing"<?php echo $query_production->Packing->editAttributes() ?>>
		<?php echo $query_production->Packing->selectOptionListHtml("x_Packing") ?>
	</select>
</div>
</span>
		<span class="ew-search-cond btw1_Packing style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_Packing style="d-none"">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_Packing" data-value-separator="<?php echo $query_production->Packing->displayValueSeparatorAttribute() ?>" id="y_Packing" name="y_Packing"<?php echo $query_production->Packing->editAttributes() ?>>
		<?php echo $query_production->Packing->selectOptionListHtml("y_Packing") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($query_production->process_c->Visible) { // process_c ?>
	<div id="xsc_process_c" class="ew-cell form-group">
		<label for="x_process_c" class="ew-search-caption ew-label"><?php echo $query_production->process_c->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process_c" id="z_process_c" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="query_production" data-field="x_process_c" name="x_process_c" id="x_process_c" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($query_production->process_c->getPlaceHolder()) ?>" value="<?php echo $query_production->process_c->EditValue ?>"<?php echo $query_production->process_c->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($query_production->process_d->Visible) { // process_d ?>
	<div id="xsc_process_d" class="ew-cell form-group">
		<label for="x_process_d" class="ew-search-caption ew-label"><?php echo $query_production->process_d->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process_d" id="z_process_d" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="query_production" data-field="x_process_d" name="x_process_d" id="x_process_d" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($query_production->process_d->getPlaceHolder()) ?>" value="<?php echo $query_production->process_d->EditValue ?>"<?php echo $query_production->process_d->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($query_production->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $query_production->_barcode->caption() ?></label>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="query_production" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($query_production->_barcode->getPlaceHolder()) ?>" value="<?php echo $query_production->_barcode->EditValue ?>"<?php echo $query_production->_barcode->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1__barcode style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1__barcode style="d-none"">
<input type="text" data-table="query_production" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($query_production->_barcode->getPlaceHolder()) ?>" value="<?php echo $query_production->_barcode->EditValue2 ?>"<?php echo $query_production->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
<?php if ($query_production->dispatch_week_p->Visible) { // dispatch_week_p ?>
	<div id="xsc_dispatch_week_p" class="ew-cell form-group">
		<label for="x_dispatch_week_p" class="ew-search-caption ew-label"><?php echo $query_production->dispatch_week_p->caption() ?></label>
		<span class="ew-search-operator"><select name="z_dispatch_week_p" id="z_dispatch_week_p" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_dispatch_week_p" data-value-separator="<?php echo $query_production->dispatch_week_p->displayValueSeparatorAttribute() ?>" id="x_dispatch_week_p" name="x_dispatch_week_p"<?php echo $query_production->dispatch_week_p->editAttributes() ?>>
		<?php echo $query_production->dispatch_week_p->selectOptionListHtml("x_dispatch_week_p") ?>
	</select>
</div>
<?php echo $query_production->dispatch_week_p->Lookup->getParamTag("p_x_dispatch_week_p") ?>
</span>
		<span class="ew-search-cond btw1_dispatch_week_p style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_dispatch_week_p style="d-none"">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_dispatch_week_p" data-value-separator="<?php echo $query_production->dispatch_week_p->displayValueSeparatorAttribute() ?>" id="y_dispatch_week_p" name="y_dispatch_week_p"<?php echo $query_production->dispatch_week_p->editAttributes() ?>>
		<?php echo $query_production->dispatch_week_p->selectOptionListHtml("y_dispatch_week_p") ?>
	</select>
</div>
<?php echo $query_production->dispatch_week_p->Lookup->getParamTag("p_y_dispatch_week_p") ?>
</span>
	</div>
<?php } ?>
<?php if ($query_production->current_works->Visible) { // current_works ?>
	<div id="xsc_current_works" class="ew-cell form-group">
		<label for="x_current_works" class="ew-search-caption ew-label"><?php echo $query_production->current_works->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_current_works" id="z_current_works" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_current_works" data-value-separator="<?php echo $query_production->current_works->displayValueSeparatorAttribute() ?>" id="x_current_works" name="x_current_works"<?php echo $query_production->current_works->editAttributes() ?>>
		<?php echo $query_production->current_works->selectOptionListHtml("x_current_works") ?>
	</select>
</div>
<?php echo $query_production->current_works->Lookup->getParamTag("p_x_current_works") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($query_production_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($query_production_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $query_production_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($query_production_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($query_production_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($query_production_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($query_production_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $query_production_list->showPageHeader(); ?>
<?php
$query_production_list->showMessage();
?>
<?php if ($query_production_list->TotalRecs > 0 || $query_production->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($query_production_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> query_production">
<?php if (!$query_production->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$query_production->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($query_production_list->Pager)) $query_production_list->Pager = new PrevNextPager($query_production_list->StartRec, $query_production_list->DisplayRecs, $query_production_list->TotalRecs, $query_production_list->AutoHidePager) ?>
<?php if ($query_production_list->Pager->RecordCount > 0 && $query_production_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($query_production_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $query_production_list->pageUrl() ?>start=<?php echo $query_production_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($query_production_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $query_production_list->pageUrl() ?>start=<?php echo $query_production_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $query_production_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($query_production_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $query_production_list->pageUrl() ?>start=<?php echo $query_production_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($query_production_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $query_production_list->pageUrl() ?>start=<?php echo $query_production_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $query_production_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($query_production_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $query_production_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $query_production_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $query_production_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($query_production_list->TotalRecs > 0 && (!$query_production_list->AutoHidePageSizeSelector || $query_production_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="query_production">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($query_production_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($query_production_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($query_production_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($query_production_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($query_production_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($query_production->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $query_production_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fquery_productionlist" id="fquery_productionlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($query_production_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $query_production_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="query_production">
<div id="gmp_query_production" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($query_production_list->TotalRecs > 0 || $query_production->isGridEdit()) { ?>
<table id="tbl_query_productionlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$query_production_list->RowType = ROWTYPE_HEADER;

// Render list options
$query_production_list->renderListOptions();

// Render list options (header, left)
$query_production_list->ListOptions->render("header", "left");
?>
<?php if ($query_production->buyer->Visible) { // buyer ?>
	<?php if ($query_production->sortUrl($query_production->buyer) == "") { ?>
		<th data-name="buyer" class="<?php echo $query_production->buyer->headerCellClass() ?>"><div id="elh_query_production_buyer" class="query_production_buyer"><div class="ew-table-header-caption"><?php echo $query_production->buyer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer" class="<?php echo $query_production->buyer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->buyer) ?>',2);"><div id="elh_query_production_buyer" class="query_production_buyer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->buyer->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production->buyer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->buyer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->po->Visible) { // po ?>
	<?php if ($query_production->sortUrl($query_production->po) == "") { ?>
		<th data-name="po" class="<?php echo $query_production->po->headerCellClass() ?>"><div id="elh_query_production_po" class="query_production_po"><div class="ew-table-header-caption"><?php echo $query_production->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $query_production->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->po) ?>',2);"><div id="elh_query_production_po" class="query_production_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->buyer_ref->Visible) { // buyer_ref ?>
	<?php if ($query_production->sortUrl($query_production->buyer_ref) == "") { ?>
		<th data-name="buyer_ref" class="<?php echo $query_production->buyer_ref->headerCellClass() ?>"><div id="elh_query_production_buyer_ref" class="query_production_buyer_ref"><div class="ew-table-header-caption"><?php echo $query_production->buyer_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_ref" class="<?php echo $query_production->buyer_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->buyer_ref) ?>',2);"><div id="elh_query_production_buyer_ref" class="query_production_buyer_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->buyer_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production->buyer_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->buyer_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->size_cm->Visible) { // size_cm ?>
	<?php if ($query_production->sortUrl($query_production->size_cm) == "") { ?>
		<th data-name="size_cm" class="<?php echo $query_production->size_cm->headerCellClass() ?>"><div id="elh_query_production_size_cm" class="query_production_size_cm"><div class="ew-table-header-caption"><?php echo $query_production->size_cm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_cm" class="<?php echo $query_production->size_cm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->size_cm) ?>',2);"><div id="elh_query_production_size_cm" class="query_production_size_cm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->size_cm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production->size_cm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->size_cm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->Weaving->Visible) { // Weaving ?>
	<?php if ($query_production->sortUrl($query_production->Weaving) == "") { ?>
		<th data-name="Weaving" class="<?php echo $query_production->Weaving->headerCellClass() ?>"><div id="elh_query_production_Weaving" class="query_production_Weaving"><div class="ew-table-header-caption"><?php echo $query_production->Weaving->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Weaving" class="<?php echo $query_production->Weaving->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->Weaving) ?>',2);"><div id="elh_query_production_Weaving" class="query_production_Weaving">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->Weaving->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production->Weaving->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->Weaving->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->Packing->Visible) { // Packing ?>
	<?php if ($query_production->sortUrl($query_production->Packing) == "") { ?>
		<th data-name="Packing" class="<?php echo $query_production->Packing->headerCellClass() ?>"><div id="elh_query_production_Packing" class="query_production_Packing"><div class="ew-table-header-caption"><?php echo $query_production->Packing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Packing" class="<?php echo $query_production->Packing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->Packing) ?>',2);"><div id="elh_query_production_Packing" class="query_production_Packing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->Packing->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production->Packing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->Packing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->order_quantity->Visible) { // order_quantity ?>
	<?php if ($query_production->sortUrl($query_production->order_quantity) == "") { ?>
		<th data-name="order_quantity" class="<?php echo $query_production->order_quantity->headerCellClass() ?>"><div id="elh_query_production_order_quantity" class="query_production_order_quantity"><div class="ew-table-header-caption"><?php echo $query_production->order_quantity->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_quantity" class="<?php echo $query_production->order_quantity->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->order_quantity) ?>',2);"><div id="elh_query_production_order_quantity" class="query_production_order_quantity">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->order_quantity->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production->order_quantity->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->order_quantity->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->count->Visible) { // count ?>
	<?php if ($query_production->sortUrl($query_production->count) == "") { ?>
		<th data-name="count" class="<?php echo $query_production->count->headerCellClass() ?>"><div id="elh_query_production_count" class="query_production_count"><div class="ew-table-header-caption"><?php echo $query_production->count->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="count" class="<?php echo $query_production->count->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->count) ?>',2);"><div id="elh_query_production_count" class="query_production_count">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->count->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production->count->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->count->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->sqm->Visible) { // sqm ?>
	<?php if ($query_production->sortUrl($query_production->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $query_production->sqm->headerCellClass() ?>"><div id="elh_query_production_sqm" class="query_production_sqm"><div class="ew-table-header-caption"><?php echo $query_production->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $query_production->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->sqm) ?>',2);"><div id="elh_query_production_sqm" class="query_production_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->sqm->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->sqm_a->Visible) { // sqm_a ?>
	<?php if ($query_production->sortUrl($query_production->sqm_a) == "") { ?>
		<th data-name="sqm_a" class="<?php echo $query_production->sqm_a->headerCellClass() ?>"><div id="elh_query_production_sqm_a" class="query_production_sqm_a"><div class="ew-table-header-caption"><?php echo $query_production->sqm_a->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm_a" class="<?php echo $query_production->sqm_a->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->sqm_a) ?>',2);"><div id="elh_query_production_sqm_a" class="query_production_sqm_a">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->sqm_a->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production->sqm_a->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->sqm_a->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->process_c->Visible) { // process_c ?>
	<?php if ($query_production->sortUrl($query_production->process_c) == "") { ?>
		<th data-name="process_c" class="<?php echo $query_production->process_c->headerCellClass() ?>"><div id="elh_query_production_process_c" class="query_production_process_c"><div class="ew-table-header-caption"><?php echo $query_production->process_c->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_c" class="<?php echo $query_production->process_c->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->process_c) ?>',2);"><div id="elh_query_production_process_c" class="query_production_process_c">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->process_c->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production->process_c->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->process_c->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->process_d->Visible) { // process_d ?>
	<?php if ($query_production->sortUrl($query_production->process_d) == "") { ?>
		<th data-name="process_d" class="<?php echo $query_production->process_d->headerCellClass() ?>"><div id="elh_query_production_process_d" class="query_production_process_d"><div class="ew-table-header-caption"><?php echo $query_production->process_d->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_d" class="<?php echo $query_production->process_d->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->process_d) ?>',2);"><div id="elh_query_production_process_d" class="query_production_process_d">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->process_d->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production->process_d->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->process_d->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->status->Visible) { // status ?>
	<?php if ($query_production->sortUrl($query_production->status) == "") { ?>
		<th data-name="status" class="<?php echo $query_production->status->headerCellClass() ?>"><div id="elh_query_production_status" class="query_production_status"><div class="ew-table-header-caption"><?php echo $query_production->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $query_production->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->status) ?>',2);"><div id="elh_query_production_status" class="query_production_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->_barcode->Visible) { // barcode ?>
	<?php if ($query_production->sortUrl($query_production->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $query_production->_barcode->headerCellClass() ?>" style="width: 300px;"><div id="elh_query_production__barcode" class="query_production__barcode"><div class="ew-table-header-caption"><?php echo $query_production->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $query_production->_barcode->headerCellClass() ?>" style="width: 300px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->_barcode) ?>',2);"><div id="elh_query_production__barcode" class="query_production__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->dispatch_week_p->Visible) { // dispatch_week_p ?>
	<?php if ($query_production->sortUrl($query_production->dispatch_week_p) == "") { ?>
		<th data-name="dispatch_week_p" class="<?php echo $query_production->dispatch_week_p->headerCellClass() ?>"><div id="elh_query_production_dispatch_week_p" class="query_production_dispatch_week_p"><div class="ew-table-header-caption"><?php echo $query_production->dispatch_week_p->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dispatch_week_p" class="<?php echo $query_production->dispatch_week_p->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->dispatch_week_p) ?>',2);"><div id="elh_query_production_dispatch_week_p" class="query_production_dispatch_week_p">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->dispatch_week_p->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production->dispatch_week_p->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->dispatch_week_p->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->current_works->Visible) { // current_works ?>
	<?php if ($query_production->sortUrl($query_production->current_works) == "") { ?>
		<th data-name="current_works" class="<?php echo $query_production->current_works->headerCellClass() ?>"><div id="elh_query_production_current_works" class="query_production_current_works"><div class="ew-table-header-caption"><?php echo $query_production->current_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="current_works" class="<?php echo $query_production->current_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->current_works) ?>',2);"><div id="elh_query_production_current_works" class="query_production_current_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->current_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production->current_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->current_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->shipping_type->Visible) { // shipping_type ?>
	<?php if ($query_production->sortUrl($query_production->shipping_type) == "") { ?>
		<th data-name="shipping_type" class="<?php echo $query_production->shipping_type->headerCellClass() ?>"><div id="elh_query_production_shipping_type" class="query_production_shipping_type"><div class="ew-table-header-caption"><?php echo $query_production->shipping_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="shipping_type" class="<?php echo $query_production->shipping_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->shipping_type) ?>',2);"><div id="elh_query_production_shipping_type" class="query_production_shipping_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->shipping_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production->shipping_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->shipping_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->batch_no->Visible) { // batch_no ?>
	<?php if ($query_production->sortUrl($query_production->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $query_production->batch_no->headerCellClass() ?>"><div id="elh_query_production_batch_no" class="query_production_batch_no"><div class="ew-table-header-caption"><?php echo $query_production->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $query_production->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->batch_no) ?>',2);"><div id="elh_query_production_batch_no" class="query_production_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($query_production->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($query_production->buyer_barcode->Visible) { // buyer_barcode ?>
	<?php if ($query_production->sortUrl($query_production->buyer_barcode) == "") { ?>
		<th data-name="buyer_barcode" class="<?php echo $query_production->buyer_barcode->headerCellClass() ?>"><div id="elh_query_production_buyer_barcode" class="query_production_buyer_barcode"><div class="ew-table-header-caption"><?php echo $query_production->buyer_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_barcode" class="<?php echo $query_production->buyer_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $query_production->SortUrl($query_production->buyer_barcode) ?>',2);"><div id="elh_query_production_buyer_barcode" class="query_production_buyer_barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $query_production->buyer_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($query_production->buyer_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($query_production->buyer_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$query_production_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($query_production->ExportAll && $query_production->isExport()) {
	$query_production_list->StopRec = $query_production_list->TotalRecs;
} else {

	// Set the last record to display
	if ($query_production_list->TotalRecs > $query_production_list->StartRec + $query_production_list->DisplayRecs - 1)
		$query_production_list->StopRec = $query_production_list->StartRec + $query_production_list->DisplayRecs - 1;
	else
		$query_production_list->StopRec = $query_production_list->TotalRecs;
}
$query_production_list->RecCnt = $query_production_list->StartRec - 1;
if ($query_production_list->Recordset && !$query_production_list->Recordset->EOF) {
	$query_production_list->Recordset->moveFirst();
	$selectLimit = $query_production_list->UseSelectLimit;
	if (!$selectLimit && $query_production_list->StartRec > 1)
		$query_production_list->Recordset->move($query_production_list->StartRec - 1);
} elseif (!$query_production->AllowAddDeleteRow && $query_production_list->StopRec == 0) {
	$query_production_list->StopRec = $query_production->GridAddRowCount;
}

// Initialize aggregate
$query_production->RowType = ROWTYPE_AGGREGATEINIT;
$query_production->resetAttributes();
$query_production_list->renderRow();
while ($query_production_list->RecCnt < $query_production_list->StopRec) {
	$query_production_list->RecCnt++;
	if ($query_production_list->RecCnt >= $query_production_list->StartRec) {
		$query_production_list->RowCnt++;

		// Set up key count
		$query_production_list->KeyCount = $query_production_list->RowIndex;

		// Init row class and style
		$query_production->resetAttributes();
		$query_production->CssClass = "";
		if ($query_production->isGridAdd()) {
		} else {
			$query_production_list->loadRowValues($query_production_list->Recordset); // Load row values
		}
		$query_production->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$query_production->RowAttrs = array_merge($query_production->RowAttrs, array('data-rowindex'=>$query_production_list->RowCnt, 'id'=>'r' . $query_production_list->RowCnt . '_query_production', 'data-rowtype'=>$query_production->RowType));

		// Render row
		$query_production_list->renderRow();

		// Render list options
		$query_production_list->renderListOptions();
?>
	<tr<?php echo $query_production->rowAttributes() ?>>
<?php

// Render list options (body, left)
$query_production_list->ListOptions->render("body", "left", $query_production_list->RowCnt);
?>
	<?php if ($query_production->buyer->Visible) { // buyer ?>
		<td data-name="buyer"<?php echo $query_production->buyer->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_buyer" class="query_production_buyer">
<span<?php echo $query_production->buyer->viewAttributes() ?>>
<?php if ((!EmptyString($query_production->buyer->getViewValue())) && $query_production->buyer->linkAttributes() <> "") { ?>
<a<?php echo $query_production->buyer->linkAttributes() ?>><?php echo $query_production->buyer->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production->buyer->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->po->Visible) { // po ?>
		<td data-name="po"<?php echo $query_production->po->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_po" class="query_production_po">
<span<?php echo $query_production->po->viewAttributes() ?>>
<?php if ((!EmptyString($query_production->po->getViewValue())) && $query_production->po->linkAttributes() <> "") { ?>
<a<?php echo $query_production->po->linkAttributes() ?>><?php echo $query_production->po->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref"<?php echo $query_production->buyer_ref->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_buyer_ref" class="query_production_buyer_ref">
<span<?php echo $query_production->buyer_ref->viewAttributes() ?>>
<?php echo $query_production->buyer_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm"<?php echo $query_production->size_cm->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_size_cm" class="query_production_size_cm">
<span<?php echo $query_production->size_cm->viewAttributes() ?>>
<?php if ((!EmptyString($query_production->size_cm->getViewValue())) && $query_production->size_cm->linkAttributes() <> "") { ?>
<a<?php echo $query_production->size_cm->linkAttributes() ?>><?php echo $query_production->size_cm->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production->size_cm->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->Weaving->Visible) { // Weaving ?>
		<td data-name="Weaving"<?php echo $query_production->Weaving->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_Weaving" class="query_production_Weaving">
<span<?php echo $query_production->Weaving->viewAttributes() ?>>
<?php if ((!EmptyString($query_production->Weaving->getViewValue())) && $query_production->Weaving->linkAttributes() <> "") { ?>
<a<?php echo $query_production->Weaving->linkAttributes() ?>><?php echo $query_production->Weaving->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production->Weaving->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->Packing->Visible) { // Packing ?>
		<td data-name="Packing"<?php echo $query_production->Packing->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_Packing" class="query_production_Packing">
<span<?php echo $query_production->Packing->viewAttributes() ?>>
<?php if ((!EmptyString($query_production->Packing->getViewValue())) && $query_production->Packing->linkAttributes() <> "") { ?>
<a<?php echo $query_production->Packing->linkAttributes() ?>><?php echo $query_production->Packing->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production->Packing->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->order_quantity->Visible) { // order_quantity ?>
		<td data-name="order_quantity"<?php echo $query_production->order_quantity->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_order_quantity" class="query_production_order_quantity">
<span<?php echo $query_production->order_quantity->viewAttributes() ?>>
<?php if ((!EmptyString($query_production->order_quantity->getViewValue())) && $query_production->order_quantity->linkAttributes() <> "") { ?>
<a<?php echo $query_production->order_quantity->linkAttributes() ?>><?php echo $query_production->order_quantity->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production->order_quantity->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->count->Visible) { // count ?>
		<td data-name="count"<?php echo $query_production->count->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_count" class="query_production_count">
<span<?php echo $query_production->count->viewAttributes() ?>>
<?php echo $query_production->count->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $query_production->sqm->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_sqm" class="query_production_sqm">
<span<?php echo $query_production->sqm->viewAttributes() ?>>
<?php echo $query_production->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->sqm_a->Visible) { // sqm_a ?>
		<td data-name="sqm_a"<?php echo $query_production->sqm_a->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_sqm_a" class="query_production_sqm_a">
<span<?php echo $query_production->sqm_a->viewAttributes() ?>>
<?php echo $query_production->sqm_a->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->process_c->Visible) { // process_c ?>
		<td data-name="process_c"<?php echo $query_production->process_c->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_process_c" class="query_production_process_c">
<span<?php echo $query_production->process_c->viewAttributes() ?>>
<?php echo $query_production->process_c->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->process_d->Visible) { // process_d ?>
		<td data-name="process_d"<?php echo $query_production->process_d->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_process_d" class="query_production_process_d">
<span<?php echo $query_production->process_d->viewAttributes() ?>>
<?php echo $query_production->process_d->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->status->Visible) { // status ?>
		<td data-name="status"<?php echo $query_production->status->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_status" class="query_production_status">
<span<?php echo $query_production->status->viewAttributes() ?>>
<?php echo $query_production->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $query_production->_barcode->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production__barcode" class="query_production__barcode">
<span<?php echo $query_production->_barcode->viewAttributes() ?>>
<?php if ((!EmptyString($query_production->_barcode->getViewValue())) && $query_production->_barcode->linkAttributes() <> "") { ?>
<a<?php echo $query_production->_barcode->linkAttributes() ?>><?php echo $query_production->_barcode->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production->_barcode->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->dispatch_week_p->Visible) { // dispatch_week_p ?>
		<td data-name="dispatch_week_p"<?php echo $query_production->dispatch_week_p->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_dispatch_week_p" class="query_production_dispatch_week_p">
<span<?php echo $query_production->dispatch_week_p->viewAttributes() ?>>
<?php echo $query_production->dispatch_week_p->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->current_works->Visible) { // current_works ?>
		<td data-name="current_works"<?php echo $query_production->current_works->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_current_works" class="query_production_current_works">
<span<?php echo $query_production->current_works->viewAttributes() ?>>
<?php echo $query_production->current_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->shipping_type->Visible) { // shipping_type ?>
		<td data-name="shipping_type"<?php echo $query_production->shipping_type->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_shipping_type" class="query_production_shipping_type">
<span<?php echo $query_production->shipping_type->viewAttributes() ?>>
<?php echo $query_production->shipping_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $query_production->batch_no->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_batch_no" class="query_production_batch_no">
<span<?php echo $query_production->batch_no->viewAttributes() ?>>
<?php echo $query_production->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($query_production->buyer_barcode->Visible) { // buyer_barcode ?>
		<td data-name="buyer_barcode"<?php echo $query_production->buyer_barcode->cellAttributes() ?>>
<span id="el<?php echo $query_production_list->RowCnt ?>_query_production_buyer_barcode" class="query_production_buyer_barcode">
<span<?php echo $query_production->buyer_barcode->viewAttributes() ?>>
<?php echo $query_production->buyer_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$query_production_list->ListOptions->render("body", "right", $query_production_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$query_production->isGridAdd())
		$query_production_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$query_production->RowType = ROWTYPE_AGGREGATE;
$query_production->resetAttributes();
$query_production_list->renderRow();
?>
<?php if ($query_production_list->TotalRecs > 0 && !$query_production->isGridAdd() && !$query_production->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$query_production_list->renderListOptions();

// Render list options (footer, left)
$query_production_list->ListOptions->render("footer", "left");
?>
	<?php if ($query_production->buyer->Visible) { // buyer ?>
		<td data-name="buyer" class="<?php echo $query_production->buyer->footerCellClass() ?>"><span id="elf_query_production_buyer" class="query_production_buyer">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $query_production->po->footerCellClass() ?>"><span id="elf_query_production_po" class="query_production_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref" class="<?php echo $query_production->buyer_ref->footerCellClass() ?>"><span id="elf_query_production_buyer_ref" class="query_production_buyer_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production->size_cm->Visible) { // size_cm ?>
		<td data-name="size_cm" class="<?php echo $query_production->size_cm->footerCellClass() ?>"><span id="elf_query_production_size_cm" class="query_production_size_cm">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production->Weaving->Visible) { // Weaving ?>
		<td data-name="Weaving" class="<?php echo $query_production->Weaving->footerCellClass() ?>"><span id="elf_query_production_Weaving" class="query_production_Weaving">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production->Packing->Visible) { // Packing ?>
		<td data-name="Packing" class="<?php echo $query_production->Packing->footerCellClass() ?>"><span id="elf_query_production_Packing" class="query_production_Packing">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production->order_quantity->Visible) { // order_quantity ?>
		<td data-name="order_quantity" class="<?php echo $query_production->order_quantity->footerCellClass() ?>"><span id="elf_query_production_order_quantity" class="query_production_order_quantity">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production->count->Visible) { // count ?>
		<td data-name="count" class="<?php echo $query_production->count->footerCellClass() ?>"><span id="elf_query_production_count" class="query_production_count">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $query_production->count->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($query_production->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $query_production->sqm->footerCellClass() ?>"><span id="elf_query_production_sqm" class="query_production_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $query_production->sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($query_production->sqm_a->Visible) { // sqm_a ?>
		<td data-name="sqm_a" class="<?php echo $query_production->sqm_a->footerCellClass() ?>"><span id="elf_query_production_sqm_a" class="query_production_sqm_a">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $query_production->sqm_a->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($query_production->process_c->Visible) { // process_c ?>
		<td data-name="process_c" class="<?php echo $query_production->process_c->footerCellClass() ?>"><span id="elf_query_production_process_c" class="query_production_process_c">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production->process_d->Visible) { // process_d ?>
		<td data-name="process_d" class="<?php echo $query_production->process_d->footerCellClass() ?>"><span id="elf_query_production_process_d" class="query_production_process_d">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production->status->Visible) { // status ?>
		<td data-name="status" class="<?php echo $query_production->status->footerCellClass() ?>"><span id="elf_query_production_status" class="query_production_status">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode" class="<?php echo $query_production->_barcode->footerCellClass() ?>"><span id="elf_query_production__barcode" class="query_production__barcode">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production->dispatch_week_p->Visible) { // dispatch_week_p ?>
		<td data-name="dispatch_week_p" class="<?php echo $query_production->dispatch_week_p->footerCellClass() ?>"><span id="elf_query_production_dispatch_week_p" class="query_production_dispatch_week_p">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production->current_works->Visible) { // current_works ?>
		<td data-name="current_works" class="<?php echo $query_production->current_works->footerCellClass() ?>"><span id="elf_query_production_current_works" class="query_production_current_works">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production->shipping_type->Visible) { // shipping_type ?>
		<td data-name="shipping_type" class="<?php echo $query_production->shipping_type->footerCellClass() ?>"><span id="elf_query_production_shipping_type" class="query_production_shipping_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no" class="<?php echo $query_production->batch_no->footerCellClass() ?>"><span id="elf_query_production_batch_no" class="query_production_batch_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($query_production->buyer_barcode->Visible) { // buyer_barcode ?>
		<td data-name="buyer_barcode" class="<?php echo $query_production->buyer_barcode->footerCellClass() ?>"><span id="elf_query_production_buyer_barcode" class="query_production_buyer_barcode">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$query_production_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$query_production->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($query_production_list->Recordset)
	$query_production_list->Recordset->Close();
?>
<?php if (!$query_production->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$query_production->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($query_production_list->Pager)) $query_production_list->Pager = new PrevNextPager($query_production_list->StartRec, $query_production_list->DisplayRecs, $query_production_list->TotalRecs, $query_production_list->AutoHidePager) ?>
<?php if ($query_production_list->Pager->RecordCount > 0 && $query_production_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($query_production_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $query_production_list->pageUrl() ?>start=<?php echo $query_production_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($query_production_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $query_production_list->pageUrl() ?>start=<?php echo $query_production_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $query_production_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($query_production_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $query_production_list->pageUrl() ?>start=<?php echo $query_production_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($query_production_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $query_production_list->pageUrl() ?>start=<?php echo $query_production_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $query_production_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($query_production_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $query_production_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $query_production_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $query_production_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($query_production_list->TotalRecs > 0 && (!$query_production_list->AutoHidePageSizeSelector || $query_production_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="query_production">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($query_production_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($query_production_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($query_production_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($query_production_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($query_production_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($query_production->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $query_production_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($query_production_list->TotalRecs == 0 && !$query_production->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $query_production_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$query_production_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$query_production->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$query_production->isExport()) { ?>
<script>
ew.scrollableTable("gmp_query_production", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$query_production_list->terminate();
?>