<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$query_production_search = new query_production_search();

// Run the page
$query_production_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$query_production_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($query_production_search->IsModal) { ?>
var fquery_productionsearch = currentAdvancedSearchForm = new ew.Form("fquery_productionsearch", "search");
<?php } else { ?>
var fquery_productionsearch = currentForm = new ew.Form("fquery_productionsearch", "search");
<?php } ?>

// Form_CustomValidate event
fquery_productionsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fquery_productionsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fquery_productionsearch.lists["x_buyer"] = <?php echo $query_production_search->buyer->Lookup->toClientList() ?>;
fquery_productionsearch.lists["x_buyer"].options = <?php echo JsonEncode($query_production_search->buyer->lookupOptions()) ?>;
fquery_productionsearch.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fquery_productionsearch.lists["x_po"] = <?php echo $query_production_search->po->Lookup->toClientList() ?>;
fquery_productionsearch.lists["x_po"].options = <?php echo JsonEncode($query_production_search->po->lookupOptions()) ?>;
fquery_productionsearch.autoSuggests["x_po"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fquery_productionsearch.lists["x_design_id"] = <?php echo $query_production_search->design_id->Lookup->toClientList() ?>;
fquery_productionsearch.lists["x_design_id"].options = <?php echo JsonEncode($query_production_search->design_id->lookupOptions()) ?>;
fquery_productionsearch.lists["x_Weaving"] = <?php echo $query_production_search->Weaving->Lookup->toClientList() ?>;
fquery_productionsearch.lists["x_Weaving"].options = <?php echo JsonEncode($query_production_search->Weaving->options(FALSE, TRUE)) ?>;
fquery_productionsearch.lists["x_Packing"] = <?php echo $query_production_search->Packing->Lookup->toClientList() ?>;
fquery_productionsearch.lists["x_Packing"].options = <?php echo JsonEncode($query_production_search->Packing->options(FALSE, TRUE)) ?>;
fquery_productionsearch.lists["x_status"] = <?php echo $query_production_search->status->Lookup->toClientList() ?>;
fquery_productionsearch.lists["x_status"].options = <?php echo JsonEncode($query_production_search->status->lookupOptions()) ?>;
fquery_productionsearch.lists["x_dispatch_week_p"] = <?php echo $query_production_search->dispatch_week_p->Lookup->toClientList() ?>;
fquery_productionsearch.lists["x_dispatch_week_p"].options = <?php echo JsonEncode($query_production_search->dispatch_week_p->lookupOptions()) ?>;
fquery_productionsearch.lists["x_current_works"] = <?php echo $query_production_search->current_works->Lookup->toClientList() ?>;
fquery_productionsearch.lists["x_current_works"].options = <?php echo JsonEncode($query_production_search->current_works->lookupOptions()) ?>;
fquery_productionsearch.lists["x_shipping_type"] = <?php echo $query_production_search->shipping_type->Lookup->toClientList() ?>;
fquery_productionsearch.lists["x_shipping_type"].options = <?php echo JsonEncode($query_production_search->shipping_type->lookupOptions()) ?>;
fquery_productionsearch.lists["x_batch_no"] = <?php echo $query_production_search->batch_no->Lookup->toClientList() ?>;
fquery_productionsearch.lists["x_batch_no"].options = <?php echo JsonEncode($query_production_search->batch_no->lookupOptions()) ?>;
fquery_productionsearch.lists["x_process[]"] = <?php echo $query_production_search->process->Lookup->toClientList() ?>;
fquery_productionsearch.lists["x_process[]"].options = <?php echo JsonEncode($query_production_search->process->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fquery_productionsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_order_quantity");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_production->order_quantity->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_count");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_production->count->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_production->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm_a");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($query_production->sqm_a->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $query_production_search->showPageHeader(); ?>
<?php
$query_production_search->showMessage();
?>
<form name="fquery_productionsearch" id="fquery_productionsearch" class="<?php echo $query_production_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($query_production_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $query_production_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="query_production">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$query_production_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($query_production->buyer->Visible) { // buyer ?>
	<div id="r_buyer" class="form-group row">
		<label class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_buyer"><?php echo $query_production->buyer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer" id="z_buyer" value="="></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->buyer->cellAttributes() ?>>
			<span id="el_query_production_buyer">
<?php
$wrkonchange = "" . trim(@$query_production->buyer->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$query_production->buyer->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer" class="text-nowrap" style="z-index: 8990">
	<input type="text" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?php echo RemoveHtml($query_production->buyer->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($query_production->buyer->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($query_production->buyer->getPlaceHolder()) ?>"<?php echo $query_production->buyer->editAttributes() ?>>
</span>
<input type="hidden" data-table="query_production" data-field="x_buyer" data-value-separator="<?php echo $query_production->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?php echo HtmlEncode($query_production->buyer->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fquery_productionsearch.createAutoSuggest({"id":"x_buyer","forceSelect":false});
</script>
<?php echo $query_production->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_po"><?php echo $query_production->po->caption() ?></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->po->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($query_production->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($query_production->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($query_production->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($query_production->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($query_production->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($query_production->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($query_production->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($query_production->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($query_production->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_query_production_po">
<?php
$wrkonchange = "" . trim(@$query_production->po->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$query_production->po->EditAttrs["onchange"] = "";
?>
<span id="as_x_po" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_po" id="sv_x_po" value="<?php echo RemoveHtml($query_production->po->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($query_production->po->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($query_production->po->getPlaceHolder()) ?>"<?php echo $query_production->po->editAttributes() ?>>
</span>
<input type="hidden" data-table="query_production" data-field="x_po" data-value-separator="<?php echo $query_production->po->displayValueSeparatorAttribute() ?>" name="x_po" id="x_po" value="<?php echo HtmlEncode($query_production->po->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fquery_productionsearch.createAutoSuggest({"id":"x_po","forceSelect":false});
</script>
<?php echo $query_production->po->Lookup->getParamTag("p_x_po") ?>
</span>
			<span class="ew-search-cond btw1_po d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_query_production_po" class="btw1_po d-none">
<?php
$wrkonchange = "" . trim(@$query_production->po->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$query_production->po->EditAttrs["onchange"] = "";
?>
<span id="as_y_po" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_y_po" id="sv_y_po" value="<?php echo RemoveHtml($query_production->po->EditValue2) ?>" size="30" placeholder="<?php echo HtmlEncode($query_production->po->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($query_production->po->getPlaceHolder()) ?>"<?php echo $query_production->po->editAttributes() ?>>
</span>
<input type="hidden" data-table="query_production" data-field="x_po" data-value-separator="<?php echo $query_production->po->displayValueSeparatorAttribute() ?>" name="y_po" id="y_po" value="<?php echo HtmlEncode($query_production->po->AdvancedSearch->SearchValue2) ?>"<?php echo $wrkonchange ?>>
<script>
fquery_productionsearch.createAutoSuggest({"id":"y_po","forceSelect":false});
</script>
<?php echo $query_production->po->Lookup->getParamTag("p_y_po") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label for="x_buyer_ref" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_buyer_ref"><?php echo $query_production->buyer_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->buyer_ref->cellAttributes() ?>>
			<span id="el_query_production_buyer_ref">
<input type="text" data-table="query_production" data-field="x_buyer_ref" name="x_buyer_ref" id="x_buyer_ref" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($query_production->buyer_ref->getPlaceHolder()) ?>" value="<?php echo $query_production->buyer_ref->EditValue ?>"<?php echo $query_production->buyer_ref->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->design_id->Visible) { // design_id ?>
	<div id="r_design_id" class="form-group row">
		<label for="x_design_id" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_design_id"><?php echo $query_production->design_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design_id" id="z_design_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->design_id->cellAttributes() ?>>
			<span id="el_query_production_design_id">
<input type="text" data-table="query_production" data-field="x_design_id" name="x_design_id" id="x_design_id" size="30" placeholder="<?php echo HtmlEncode($query_production->design_id->getPlaceHolder()) ?>" value="<?php echo $query_production->design_id->EditValue ?>"<?php echo $query_production->design_id->editAttributes() ?>>
<?php echo $query_production->design_id->Lookup->getParamTag("p_x_design_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->size_cm->Visible) { // size_cm ?>
	<div id="r_size_cm" class="form-group row">
		<label for="x_size_cm" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_size_cm"><?php echo $query_production->size_cm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->size_cm->cellAttributes() ?>>
			<span id="el_query_production_size_cm">
<input type="text" data-table="query_production" data-field="x_size_cm" name="x_size_cm" id="x_size_cm" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($query_production->size_cm->getPlaceHolder()) ?>" value="<?php echo $query_production->size_cm->EditValue ?>"<?php echo $query_production->size_cm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->Weaving->Visible) { // Weaving ?>
	<div id="r_Weaving" class="form-group row">
		<label for="x_Weaving" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_Weaving"><?php echo $query_production->Weaving->caption() ?></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->Weaving->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_Weaving" id="z_Weaving" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="BETWEEN"<?php echo ($query_production->Weaving->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_query_production_Weaving">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_Weaving" data-value-separator="<?php echo $query_production->Weaving->displayValueSeparatorAttribute() ?>" id="x_Weaving" name="x_Weaving"<?php echo $query_production->Weaving->editAttributes() ?>>
		<?php echo $query_production->Weaving->selectOptionListHtml("x_Weaving") ?>
	</select>
</div>
</span>
			<span class="ew-search-cond btw1_Weaving d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_query_production_Weaving" class="btw1_Weaving d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_Weaving" data-value-separator="<?php echo $query_production->Weaving->displayValueSeparatorAttribute() ?>" id="y_Weaving" name="y_Weaving"<?php echo $query_production->Weaving->editAttributes() ?>>
		<?php echo $query_production->Weaving->selectOptionListHtml("y_Weaving") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->Packing->Visible) { // Packing ?>
	<div id="r_Packing" class="form-group row">
		<label for="x_Packing" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_Packing"><?php echo $query_production->Packing->caption() ?></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->Packing->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_Packing" id="z_Packing" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($query_production->Packing->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_query_production_Packing">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_Packing" data-value-separator="<?php echo $query_production->Packing->displayValueSeparatorAttribute() ?>" id="x_Packing" name="x_Packing"<?php echo $query_production->Packing->editAttributes() ?>>
		<?php echo $query_production->Packing->selectOptionListHtml("x_Packing") ?>
	</select>
</div>
</span>
			<span class="ew-search-cond btw1_Packing d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_query_production_Packing" class="btw1_Packing d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_Packing" data-value-separator="<?php echo $query_production->Packing->displayValueSeparatorAttribute() ?>" id="y_Packing" name="y_Packing"<?php echo $query_production->Packing->editAttributes() ?>>
		<?php echo $query_production->Packing->selectOptionListHtml("y_Packing") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->order_quantity->Visible) { // order_quantity ?>
	<div id="r_order_quantity" class="form-group row">
		<label for="x_order_quantity" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_order_quantity"><?php echo $query_production->order_quantity->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_quantity" id="z_order_quantity" value="="></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->order_quantity->cellAttributes() ?>>
			<span id="el_query_production_order_quantity">
<input type="text" data-table="query_production" data-field="x_order_quantity" name="x_order_quantity" id="x_order_quantity" size="30" placeholder="<?php echo HtmlEncode($query_production->order_quantity->getPlaceHolder()) ?>" value="<?php echo $query_production->order_quantity->EditValue ?>"<?php echo $query_production->order_quantity->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->count->Visible) { // count ?>
	<div id="r_count" class="form-group row">
		<label for="x_count" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_count"><?php echo $query_production->count->caption() ?></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->count->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_count" id="z_count" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($query_production->count->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($query_production->count->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($query_production->count->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($query_production->count->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($query_production->count->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($query_production->count->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($query_production->count->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_query_production_count">
<input type="text" data-table="query_production" data-field="x_count" name="x_count" id="x_count" size="30" placeholder="<?php echo HtmlEncode($query_production->count->getPlaceHolder()) ?>" value="<?php echo $query_production->count->EditValue ?>"<?php echo $query_production->count->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_count d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_query_production_count" class="btw1_count d-none">
<input type="text" data-table="query_production" data-field="x_count" name="y_count" id="y_count" size="30" placeholder="<?php echo HtmlEncode($query_production->count->getPlaceHolder()) ?>" value="<?php echo $query_production->count->EditValue2 ?>"<?php echo $query_production->count->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_sqm"><?php echo $query_production->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->sqm->cellAttributes() ?>>
			<span id="el_query_production_sqm">
<input type="text" data-table="query_production" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($query_production->sqm->getPlaceHolder()) ?>" value="<?php echo $query_production->sqm->EditValue ?>"<?php echo $query_production->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->sqm_a->Visible) { // sqm_a ?>
	<div id="r_sqm_a" class="form-group row">
		<label for="x_sqm_a" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_sqm_a"><?php echo $query_production->sqm_a->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm_a" id="z_sqm_a" value="="></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->sqm_a->cellAttributes() ?>>
			<span id="el_query_production_sqm_a">
<input type="text" data-table="query_production" data-field="x_sqm_a" name="x_sqm_a" id="x_sqm_a" size="30" placeholder="<?php echo HtmlEncode($query_production->sqm_a->getPlaceHolder()) ?>" value="<?php echo $query_production->sqm_a->EditValue ?>"<?php echo $query_production->sqm_a->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_status"><?php echo $query_production->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->status->cellAttributes() ?>>
			<span id="el_query_production_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_status" data-value-separator="<?php echo $query_production->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $query_production->status->editAttributes() ?>>
		<?php echo $query_production->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $query_production->status->Lookup->getParamTag("p_x_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production__barcode"><?php echo $query_production->_barcode->caption() ?></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->_barcode->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($query_production->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_query_production__barcode">
<input type="text" data-table="query_production" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($query_production->_barcode->getPlaceHolder()) ?>" value="<?php echo $query_production->_barcode->EditValue ?>"<?php echo $query_production->_barcode->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1__barcode d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_query_production__barcode" class="btw1__barcode d-none">
<input type="text" data-table="query_production" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($query_production->_barcode->getPlaceHolder()) ?>" value="<?php echo $query_production->_barcode->EditValue2 ?>"<?php echo $query_production->_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->dispatch_week_p->Visible) { // dispatch_week_p ?>
	<div id="r_dispatch_week_p" class="form-group row">
		<label for="x_dispatch_week_p" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_dispatch_week_p"><?php echo $query_production->dispatch_week_p->caption() ?></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->dispatch_week_p->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dispatch_week_p" id="z_dispatch_week_p" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($query_production->dispatch_week_p->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_query_production_dispatch_week_p">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_dispatch_week_p" data-value-separator="<?php echo $query_production->dispatch_week_p->displayValueSeparatorAttribute() ?>" id="x_dispatch_week_p" name="x_dispatch_week_p"<?php echo $query_production->dispatch_week_p->editAttributes() ?>>
		<?php echo $query_production->dispatch_week_p->selectOptionListHtml("x_dispatch_week_p") ?>
	</select>
</div>
<?php echo $query_production->dispatch_week_p->Lookup->getParamTag("p_x_dispatch_week_p") ?>
</span>
			<span class="ew-search-cond btw1_dispatch_week_p d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_query_production_dispatch_week_p" class="btw1_dispatch_week_p d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_dispatch_week_p" data-value-separator="<?php echo $query_production->dispatch_week_p->displayValueSeparatorAttribute() ?>" id="y_dispatch_week_p" name="y_dispatch_week_p"<?php echo $query_production->dispatch_week_p->editAttributes() ?>>
		<?php echo $query_production->dispatch_week_p->selectOptionListHtml("y_dispatch_week_p") ?>
	</select>
</div>
<?php echo $query_production->dispatch_week_p->Lookup->getParamTag("p_y_dispatch_week_p") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->current_works->Visible) { // current_works ?>
	<div id="r_current_works" class="form-group row">
		<label for="x_current_works" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_current_works"><?php echo $query_production->current_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_current_works" id="z_current_works" value="="></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->current_works->cellAttributes() ?>>
			<span id="el_query_production_current_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_current_works" data-value-separator="<?php echo $query_production->current_works->displayValueSeparatorAttribute() ?>" id="x_current_works" name="x_current_works"<?php echo $query_production->current_works->editAttributes() ?>>
		<?php echo $query_production->current_works->selectOptionListHtml("x_current_works") ?>
	</select>
</div>
<?php echo $query_production->current_works->Lookup->getParamTag("p_x_current_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->shipping_type->Visible) { // shipping_type ?>
	<div id="r_shipping_type" class="form-group row">
		<label for="x_shipping_type" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_shipping_type"><?php echo $query_production->shipping_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_shipping_type" id="z_shipping_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->shipping_type->cellAttributes() ?>>
			<span id="el_query_production_shipping_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_shipping_type" data-value-separator="<?php echo $query_production->shipping_type->displayValueSeparatorAttribute() ?>" id="x_shipping_type" name="x_shipping_type"<?php echo $query_production->shipping_type->editAttributes() ?>>
		<?php echo $query_production->shipping_type->selectOptionListHtml("x_shipping_type") ?>
	</select>
</div>
<?php echo $query_production->shipping_type->Lookup->getParamTag("p_x_shipping_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_batch_no"><?php echo $query_production->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->batch_no->cellAttributes() ?>>
			<span id="el_query_production_batch_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="query_production" data-field="x_batch_no" data-value-separator="<?php echo $query_production->batch_no->displayValueSeparatorAttribute() ?>" id="x_batch_no" name="x_batch_no"<?php echo $query_production->batch_no->editAttributes() ?>>
		<?php echo $query_production->batch_no->selectOptionListHtml("x_batch_no") ?>
	</select>
</div>
<?php echo $query_production->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_process"><?php echo $query_production->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->process->cellAttributes() ?>>
			<span id="el_query_production_process">
<input type="text" data-table="query_production" data-field="x_process" name="x_process" id="x_process" size="30" placeholder="<?php echo HtmlEncode($query_production->process->getPlaceHolder()) ?>" value="<?php echo $query_production->process->EditValue ?>"<?php echo $query_production->process->editAttributes() ?>>
<?php echo $query_production->process->Lookup->getParamTag("p_x_process") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($query_production->buyer_barcode->Visible) { // buyer_barcode ?>
	<div id="r_buyer_barcode" class="form-group row">
		<label for="x_buyer_barcode" class="<?php echo $query_production_search->LeftColumnClass ?>"><span id="elh_query_production_buyer_barcode"><?php echo $query_production->buyer_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_barcode" id="z_buyer_barcode" value="LIKE"></span>
		</label>
		<div class="<?php echo $query_production_search->RightColumnClass ?>"><div<?php echo $query_production->buyer_barcode->cellAttributes() ?>>
			<span id="el_query_production_buyer_barcode">
<input type="text" data-table="query_production" data-field="x_buyer_barcode" name="x_buyer_barcode" id="x_buyer_barcode" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($query_production->buyer_barcode->getPlaceHolder()) ?>" value="<?php echo $query_production->buyer_barcode->EditValue ?>"<?php echo $query_production->buyer_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$query_production_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $query_production_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$query_production_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$query_production_search->terminate();
?>