<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$query_production_view = new query_production_view();

// Run the page
$query_production_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$query_production_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$query_production->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fquery_productionview = currentForm = new ew.Form("fquery_productionview", "view");

// Form_CustomValidate event
fquery_productionview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fquery_productionview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fquery_productionview.lists["x_buyer"] = <?php echo $query_production_view->buyer->Lookup->toClientList() ?>;
fquery_productionview.lists["x_buyer"].options = <?php echo JsonEncode($query_production_view->buyer->lookupOptions()) ?>;
fquery_productionview.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fquery_productionview.lists["x_po"] = <?php echo $query_production_view->po->Lookup->toClientList() ?>;
fquery_productionview.lists["x_po"].options = <?php echo JsonEncode($query_production_view->po->lookupOptions()) ?>;
fquery_productionview.autoSuggests["x_po"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fquery_productionview.lists["x_design_id"] = <?php echo $query_production_view->design_id->Lookup->toClientList() ?>;
fquery_productionview.lists["x_design_id"].options = <?php echo JsonEncode($query_production_view->design_id->lookupOptions()) ?>;
fquery_productionview.lists["x_Weaving"] = <?php echo $query_production_view->Weaving->Lookup->toClientList() ?>;
fquery_productionview.lists["x_Weaving"].options = <?php echo JsonEncode($query_production_view->Weaving->options(FALSE, TRUE)) ?>;
fquery_productionview.lists["x_Packing"] = <?php echo $query_production_view->Packing->Lookup->toClientList() ?>;
fquery_productionview.lists["x_Packing"].options = <?php echo JsonEncode($query_production_view->Packing->options(FALSE, TRUE)) ?>;
fquery_productionview.lists["x_status"] = <?php echo $query_production_view->status->Lookup->toClientList() ?>;
fquery_productionview.lists["x_status"].options = <?php echo JsonEncode($query_production_view->status->lookupOptions()) ?>;
fquery_productionview.lists["x_dispatch_week_p"] = <?php echo $query_production_view->dispatch_week_p->Lookup->toClientList() ?>;
fquery_productionview.lists["x_dispatch_week_p"].options = <?php echo JsonEncode($query_production_view->dispatch_week_p->lookupOptions()) ?>;
fquery_productionview.lists["x_current_works"] = <?php echo $query_production_view->current_works->Lookup->toClientList() ?>;
fquery_productionview.lists["x_current_works"].options = <?php echo JsonEncode($query_production_view->current_works->lookupOptions()) ?>;
fquery_productionview.lists["x_shipping_type"] = <?php echo $query_production_view->shipping_type->Lookup->toClientList() ?>;
fquery_productionview.lists["x_shipping_type"].options = <?php echo JsonEncode($query_production_view->shipping_type->lookupOptions()) ?>;
fquery_productionview.lists["x_batch_no"] = <?php echo $query_production_view->batch_no->Lookup->toClientList() ?>;
fquery_productionview.lists["x_batch_no"].options = <?php echo JsonEncode($query_production_view->batch_no->lookupOptions()) ?>;
fquery_productionview.lists["x_process[]"] = <?php echo $query_production_view->process->Lookup->toClientList() ?>;
fquery_productionview.lists["x_process[]"].options = <?php echo JsonEncode($query_production_view->process->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$query_production->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $query_production_view->ExportOptions->render("body") ?>
<?php $query_production_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $query_production_view->showPageHeader(); ?>
<?php
$query_production_view->showMessage();
?>
<form name="fquery_productionview" id="fquery_productionview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($query_production_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $query_production_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="query_production">
<input type="hidden" name="modal" value="<?php echo (int)$query_production_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($query_production->buyer->Visible) { // buyer ?>
	<tr id="r_buyer">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_buyer"><?php echo $query_production->buyer->caption() ?></span></td>
		<td data-name="buyer"<?php echo $query_production->buyer->cellAttributes() ?>>
<span id="el_query_production_buyer">
<span<?php echo $query_production->buyer->viewAttributes() ?>>
<?php if ((!EmptyString($query_production->buyer->getViewValue())) && $query_production->buyer->linkAttributes() <> "") { ?>
<a<?php echo $query_production->buyer->linkAttributes() ?>><?php echo $query_production->buyer->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production->buyer->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->po->Visible) { // po ?>
	<tr id="r_po">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_po"><?php echo $query_production->po->caption() ?></span></td>
		<td data-name="po"<?php echo $query_production->po->cellAttributes() ?>>
<span id="el_query_production_po">
<span<?php echo $query_production->po->viewAttributes() ?>>
<?php if ((!EmptyString($query_production->po->getViewValue())) && $query_production->po->linkAttributes() <> "") { ?>
<a<?php echo $query_production->po->linkAttributes() ?>><?php echo $query_production->po->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->buyer_ref->Visible) { // buyer_ref ?>
	<tr id="r_buyer_ref">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_buyer_ref"><?php echo $query_production->buyer_ref->caption() ?></span></td>
		<td data-name="buyer_ref"<?php echo $query_production->buyer_ref->cellAttributes() ?>>
<span id="el_query_production_buyer_ref">
<span<?php echo $query_production->buyer_ref->viewAttributes() ?>>
<?php echo $query_production->buyer_ref->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->design_id->Visible) { // design_id ?>
	<tr id="r_design_id">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_design_id"><?php echo $query_production->design_id->caption() ?></span></td>
		<td data-name="design_id"<?php echo $query_production->design_id->cellAttributes() ?>>
<span id="el_query_production_design_id">
<span<?php echo $query_production->design_id->viewAttributes() ?>>
<?php if ((!EmptyString($query_production->design_id->getViewValue())) && $query_production->design_id->linkAttributes() <> "") { ?>
<a<?php echo $query_production->design_id->linkAttributes() ?>><?php echo $query_production->design_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production->design_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->size_cm->Visible) { // size_cm ?>
	<tr id="r_size_cm">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_size_cm"><?php echo $query_production->size_cm->caption() ?></span></td>
		<td data-name="size_cm"<?php echo $query_production->size_cm->cellAttributes() ?>>
<span id="el_query_production_size_cm">
<span<?php echo $query_production->size_cm->viewAttributes() ?>>
<?php if ((!EmptyString($query_production->size_cm->getViewValue())) && $query_production->size_cm->linkAttributes() <> "") { ?>
<a<?php echo $query_production->size_cm->linkAttributes() ?>><?php echo $query_production->size_cm->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production->size_cm->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->Weaving->Visible) { // Weaving ?>
	<tr id="r_Weaving">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_Weaving"><?php echo $query_production->Weaving->caption() ?></span></td>
		<td data-name="Weaving"<?php echo $query_production->Weaving->cellAttributes() ?>>
<span id="el_query_production_Weaving">
<span<?php echo $query_production->Weaving->viewAttributes() ?>>
<?php if ((!EmptyString($query_production->Weaving->getViewValue())) && $query_production->Weaving->linkAttributes() <> "") { ?>
<a<?php echo $query_production->Weaving->linkAttributes() ?>><?php echo $query_production->Weaving->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production->Weaving->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->Packing->Visible) { // Packing ?>
	<tr id="r_Packing">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_Packing"><?php echo $query_production->Packing->caption() ?></span></td>
		<td data-name="Packing"<?php echo $query_production->Packing->cellAttributes() ?>>
<span id="el_query_production_Packing">
<span<?php echo $query_production->Packing->viewAttributes() ?>>
<?php if ((!EmptyString($query_production->Packing->getViewValue())) && $query_production->Packing->linkAttributes() <> "") { ?>
<a<?php echo $query_production->Packing->linkAttributes() ?>><?php echo $query_production->Packing->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production->Packing->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->order_quantity->Visible) { // order_quantity ?>
	<tr id="r_order_quantity">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_order_quantity"><?php echo $query_production->order_quantity->caption() ?></span></td>
		<td data-name="order_quantity"<?php echo $query_production->order_quantity->cellAttributes() ?>>
<span id="el_query_production_order_quantity">
<span<?php echo $query_production->order_quantity->viewAttributes() ?>>
<?php if ((!EmptyString($query_production->order_quantity->getViewValue())) && $query_production->order_quantity->linkAttributes() <> "") { ?>
<a<?php echo $query_production->order_quantity->linkAttributes() ?>><?php echo $query_production->order_quantity->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production->order_quantity->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->count->Visible) { // count ?>
	<tr id="r_count">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_count"><?php echo $query_production->count->caption() ?></span></td>
		<td data-name="count"<?php echo $query_production->count->cellAttributes() ?>>
<span id="el_query_production_count">
<span<?php echo $query_production->count->viewAttributes() ?>>
<?php echo $query_production->count->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->sqm->Visible) { // sqm ?>
	<tr id="r_sqm">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_sqm"><?php echo $query_production->sqm->caption() ?></span></td>
		<td data-name="sqm"<?php echo $query_production->sqm->cellAttributes() ?>>
<span id="el_query_production_sqm">
<span<?php echo $query_production->sqm->viewAttributes() ?>>
<?php echo $query_production->sqm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->sqm_a->Visible) { // sqm_a ?>
	<tr id="r_sqm_a">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_sqm_a"><?php echo $query_production->sqm_a->caption() ?></span></td>
		<td data-name="sqm_a"<?php echo $query_production->sqm_a->cellAttributes() ?>>
<span id="el_query_production_sqm_a">
<span<?php echo $query_production->sqm_a->viewAttributes() ?>>
<?php echo $query_production->sqm_a->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->process_c->Visible) { // process_c ?>
	<tr id="r_process_c">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_process_c"><?php echo $query_production->process_c->caption() ?></span></td>
		<td data-name="process_c"<?php echo $query_production->process_c->cellAttributes() ?>>
<span id="el_query_production_process_c">
<span<?php echo $query_production->process_c->viewAttributes() ?>>
<?php echo $query_production->process_c->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->process_d->Visible) { // process_d ?>
	<tr id="r_process_d">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_process_d"><?php echo $query_production->process_d->caption() ?></span></td>
		<td data-name="process_d"<?php echo $query_production->process_d->cellAttributes() ?>>
<span id="el_query_production_process_d">
<span<?php echo $query_production->process_d->viewAttributes() ?>>
<?php echo $query_production->process_d->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_status"><?php echo $query_production->status->caption() ?></span></td>
		<td data-name="status"<?php echo $query_production->status->cellAttributes() ?>>
<span id="el_query_production_status">
<span<?php echo $query_production->status->viewAttributes() ?>>
<?php echo $query_production->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->_barcode->Visible) { // barcode ?>
	<tr id="r__barcode">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production__barcode"><?php echo $query_production->_barcode->caption() ?></span></td>
		<td data-name="_barcode"<?php echo $query_production->_barcode->cellAttributes() ?>>
<span id="el_query_production__barcode">
<span<?php echo $query_production->_barcode->viewAttributes() ?>>
<?php if ((!EmptyString($query_production->_barcode->getViewValue())) && $query_production->_barcode->linkAttributes() <> "") { ?>
<a<?php echo $query_production->_barcode->linkAttributes() ?>><?php echo $query_production->_barcode->getViewValue() ?></a>
<?php } else { ?>
<?php echo $query_production->_barcode->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->dispatch_week_p->Visible) { // dispatch_week_p ?>
	<tr id="r_dispatch_week_p">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_dispatch_week_p"><?php echo $query_production->dispatch_week_p->caption() ?></span></td>
		<td data-name="dispatch_week_p"<?php echo $query_production->dispatch_week_p->cellAttributes() ?>>
<span id="el_query_production_dispatch_week_p">
<span<?php echo $query_production->dispatch_week_p->viewAttributes() ?>>
<?php echo $query_production->dispatch_week_p->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->current_works->Visible) { // current_works ?>
	<tr id="r_current_works">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_current_works"><?php echo $query_production->current_works->caption() ?></span></td>
		<td data-name="current_works"<?php echo $query_production->current_works->cellAttributes() ?>>
<span id="el_query_production_current_works">
<span<?php echo $query_production->current_works->viewAttributes() ?>>
<?php echo $query_production->current_works->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->shipping_type->Visible) { // shipping_type ?>
	<tr id="r_shipping_type">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_shipping_type"><?php echo $query_production->shipping_type->caption() ?></span></td>
		<td data-name="shipping_type"<?php echo $query_production->shipping_type->cellAttributes() ?>>
<span id="el_query_production_shipping_type">
<span<?php echo $query_production->shipping_type->viewAttributes() ?>>
<?php echo $query_production->shipping_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->batch_no->Visible) { // batch_no ?>
	<tr id="r_batch_no">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_batch_no"><?php echo $query_production->batch_no->caption() ?></span></td>
		<td data-name="batch_no"<?php echo $query_production->batch_no->cellAttributes() ?>>
<span id="el_query_production_batch_no">
<span<?php echo $query_production->batch_no->viewAttributes() ?>>
<?php echo $query_production->batch_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->process->Visible) { // process ?>
	<tr id="r_process">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_process"><?php echo $query_production->process->caption() ?></span></td>
		<td data-name="process"<?php echo $query_production->process->cellAttributes() ?>>
<span id="el_query_production_process">
<span<?php echo $query_production->process->viewAttributes() ?>>
<?php echo $query_production->process->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($query_production->buyer_barcode->Visible) { // buyer_barcode ?>
	<tr id="r_buyer_barcode">
		<td class="<?php echo $query_production_view->TableLeftColumnClass ?>"><span id="elh_query_production_buyer_barcode"><?php echo $query_production->buyer_barcode->caption() ?></span></td>
		<td data-name="buyer_barcode"<?php echo $query_production->buyer_barcode->cellAttributes() ?>>
<span id="el_query_production_buyer_barcode">
<span<?php echo $query_production->buyer_barcode->viewAttributes() ?>>
<?php echo $query_production->buyer_barcode->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$query_production_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$query_production->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$query_production_view->terminate();
?>