<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$quotation_setup_edit = new quotation_setup_edit();

// Run the page
$quotation_setup_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$quotation_setup_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fquotation_setupedit = currentForm = new ew.Form("fquotation_setupedit", "edit");

// Validate form
fquotation_setupedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($quotation_setup_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $quotation_setup->id->caption(), $quotation_setup->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($quotation_setup_edit->company->Required) { ?>
			elm = this.getElements("x" + infix + "_company");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $quotation_setup->company->caption(), $quotation_setup->company->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($quotation_setup_edit->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $quotation_setup->image->caption(), $quotation_setup->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($quotation_setup_edit->header->Required) { ?>
			elm = this.getElements("x" + infix + "_header");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $quotation_setup->header->caption(), $quotation_setup->header->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($quotation_setup_edit->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $quotation_setup->description->caption(), $quotation_setup->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($quotation_setup_edit->footer->Required) { ?>
			elm = this.getElements("x" + infix + "_footer");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $quotation_setup->footer->caption(), $quotation_setup->footer->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($quotation_setup_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $quotation_setup->operator->caption(), $quotation_setup->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($quotation_setup_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $quotation_setup->datetime->caption(), $quotation_setup->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fquotation_setupedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fquotation_setupedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $quotation_setup_edit->showPageHeader(); ?>
<?php
$quotation_setup_edit->showMessage();
?>
<form name="fquotation_setupedit" id="fquotation_setupedit" class="<?php echo $quotation_setup_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($quotation_setup_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $quotation_setup_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="quotation_setup">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$quotation_setup_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($quotation_setup->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_quotation_setup_id" class="<?php echo $quotation_setup_edit->LeftColumnClass ?>"><?php echo $quotation_setup->id->caption() ?><?php echo ($quotation_setup->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $quotation_setup_edit->RightColumnClass ?>"><div<?php echo $quotation_setup->id->cellAttributes() ?>>
<span id="el_quotation_setup_id">
<span<?php echo $quotation_setup->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($quotation_setup->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="quotation_setup" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($quotation_setup->id->CurrentValue) ?>">
<?php echo $quotation_setup->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($quotation_setup->company->Visible) { // company ?>
	<div id="r_company" class="form-group row">
		<label id="elh_quotation_setup_company" for="x_company" class="<?php echo $quotation_setup_edit->LeftColumnClass ?>"><?php echo $quotation_setup->company->caption() ?><?php echo ($quotation_setup->company->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $quotation_setup_edit->RightColumnClass ?>"><div<?php echo $quotation_setup->company->cellAttributes() ?>>
<span id="el_quotation_setup_company">
<input type="text" data-table="quotation_setup" data-field="x_company" name="x_company" id="x_company" size="30" placeholder="<?php echo HtmlEncode($quotation_setup->company->getPlaceHolder()) ?>" value="<?php echo $quotation_setup->company->EditValue ?>"<?php echo $quotation_setup->company->editAttributes() ?>>
</span>
<?php echo $quotation_setup->company->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($quotation_setup->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh_quotation_setup_image" class="<?php echo $quotation_setup_edit->LeftColumnClass ?>"><?php echo $quotation_setup->image->caption() ?><?php echo ($quotation_setup->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $quotation_setup_edit->RightColumnClass ?>"><div<?php echo $quotation_setup->image->cellAttributes() ?>>
<span id="el_quotation_setup_image">
<div id="fd_x_image">
<span title="<?php echo $quotation_setup->image->title() ? $quotation_setup->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($quotation_setup->image->ReadOnly || $quotation_setup->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="quotation_setup" data-field="x_image" name="x_image" id="x_image"<?php echo $quotation_setup->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $quotation_setup->image->Upload->FileName ?>">
<?php if (Post("fa_x_image") == "0") { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="254">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $quotation_setup->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $quotation_setup->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $quotation_setup->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($quotation_setup->header->Visible) { // header ?>
	<div id="r_header" class="form-group row">
		<label id="elh_quotation_setup_header" class="<?php echo $quotation_setup_edit->LeftColumnClass ?>"><?php echo $quotation_setup->header->caption() ?><?php echo ($quotation_setup->header->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $quotation_setup_edit->RightColumnClass ?>"><div<?php echo $quotation_setup->header->cellAttributes() ?>>
<span id="el_quotation_setup_header">
<?php AppendClass($quotation_setup->header->EditAttrs["class"], "editor"); ?>
<textarea data-table="quotation_setup" data-field="x_header" name="x_header" id="x_header" cols="50" rows="4" placeholder="<?php echo HtmlEncode($quotation_setup->header->getPlaceHolder()) ?>"<?php echo $quotation_setup->header->editAttributes() ?>><?php echo $quotation_setup->header->EditValue ?></textarea>
<script>
ew.createEditor("fquotation_setupedit", "x_header", 50, 4, <?php echo ($quotation_setup->header->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $quotation_setup->header->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($quotation_setup->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_quotation_setup_description" class="<?php echo $quotation_setup_edit->LeftColumnClass ?>"><?php echo $quotation_setup->description->caption() ?><?php echo ($quotation_setup->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $quotation_setup_edit->RightColumnClass ?>"><div<?php echo $quotation_setup->description->cellAttributes() ?>>
<span id="el_quotation_setup_description">
<?php AppendClass($quotation_setup->description->EditAttrs["class"], "editor"); ?>
<textarea data-table="quotation_setup" data-field="x_description" name="x_description" id="x_description" cols="50" rows="4" placeholder="<?php echo HtmlEncode($quotation_setup->description->getPlaceHolder()) ?>"<?php echo $quotation_setup->description->editAttributes() ?>><?php echo $quotation_setup->description->EditValue ?></textarea>
<script>
ew.createEditor("fquotation_setupedit", "x_description", 50, 4, <?php echo ($quotation_setup->description->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $quotation_setup->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($quotation_setup->footer->Visible) { // footer ?>
	<div id="r_footer" class="form-group row">
		<label id="elh_quotation_setup_footer" class="<?php echo $quotation_setup_edit->LeftColumnClass ?>"><?php echo $quotation_setup->footer->caption() ?><?php echo ($quotation_setup->footer->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $quotation_setup_edit->RightColumnClass ?>"><div<?php echo $quotation_setup->footer->cellAttributes() ?>>
<span id="el_quotation_setup_footer">
<?php AppendClass($quotation_setup->footer->EditAttrs["class"], "editor"); ?>
<textarea data-table="quotation_setup" data-field="x_footer" name="x_footer" id="x_footer" cols="50" rows="4" placeholder="<?php echo HtmlEncode($quotation_setup->footer->getPlaceHolder()) ?>"<?php echo $quotation_setup->footer->editAttributes() ?>><?php echo $quotation_setup->footer->EditValue ?></textarea>
<script>
ew.createEditor("fquotation_setupedit", "x_footer", 50, 4, <?php echo ($quotation_setup->footer->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $quotation_setup->footer->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$quotation_setup_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $quotation_setup_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $quotation_setup_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$quotation_setup_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$quotation_setup_edit->terminate();
?>