<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$quotation_setup_search = new quotation_setup_search();

// Run the page
$quotation_setup_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$quotation_setup_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($quotation_setup_search->IsModal) { ?>
var fquotation_setupsearch = currentAdvancedSearchForm = new ew.Form("fquotation_setupsearch", "search");
<?php } else { ?>
var fquotation_setupsearch = currentForm = new ew.Form("fquotation_setupsearch", "search");
<?php } ?>

// Form_CustomValidate event
fquotation_setupsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fquotation_setupsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search
// Validate function for search

fquotation_setupsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($quotation_setup->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($quotation_setup->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($quotation_setup->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $quotation_setup_search->showPageHeader(); ?>
<?php
$quotation_setup_search->showMessage();
?>
<form name="fquotation_setupsearch" id="fquotation_setupsearch" class="<?php echo $quotation_setup_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($quotation_setup_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $quotation_setup_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="quotation_setup">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$quotation_setup_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($quotation_setup->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $quotation_setup_search->LeftColumnClass ?>"><span id="elh_quotation_setup_id"><?php echo $quotation_setup->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $quotation_setup_search->RightColumnClass ?>"><div<?php echo $quotation_setup->id->cellAttributes() ?>>
			<span id="el_quotation_setup_id">
<input type="text" data-table="quotation_setup" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($quotation_setup->id->getPlaceHolder()) ?>" value="<?php echo $quotation_setup->id->EditValue ?>"<?php echo $quotation_setup->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation_setup->company->Visible) { // company ?>
	<div id="r_company" class="form-group row">
		<label for="x_company" class="<?php echo $quotation_setup_search->LeftColumnClass ?>"><span id="elh_quotation_setup_company"><?php echo $quotation_setup->company->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_company" id="z_company" value="="></span>
		</label>
		<div class="<?php echo $quotation_setup_search->RightColumnClass ?>"><div<?php echo $quotation_setup->company->cellAttributes() ?>>
			<span id="el_quotation_setup_company">
<input type="text" data-table="quotation_setup" data-field="x_company" name="x_company" id="x_company" size="30" placeholder="<?php echo HtmlEncode($quotation_setup->company->getPlaceHolder()) ?>" value="<?php echo $quotation_setup->company->EditValue ?>"<?php echo $quotation_setup->company->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation_setup->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label class="<?php echo $quotation_setup_search->LeftColumnClass ?>"><span id="elh_quotation_setup_image"><?php echo $quotation_setup->image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_image" id="z_image" value="="></span>
		</label>
		<div class="<?php echo $quotation_setup_search->RightColumnClass ?>"><div<?php echo $quotation_setup->image->cellAttributes() ?>>
			<span id="el_quotation_setup_image">
<input type="text" data-table="quotation_setup" data-field="x_image" name="x_image" id="x_image" size="30" placeholder="<?php echo HtmlEncode($quotation_setup->image->getPlaceHolder()) ?>" value="<?php echo $quotation_setup->image->EditValue ?>"<?php echo $quotation_setup->image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation_setup->header->Visible) { // header ?>
	<div id="r_header" class="form-group row">
		<label class="<?php echo $quotation_setup_search->LeftColumnClass ?>"><span id="elh_quotation_setup_header"><?php echo $quotation_setup->header->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_header" id="z_header" value="="></span>
		</label>
		<div class="<?php echo $quotation_setup_search->RightColumnClass ?>"><div<?php echo $quotation_setup->header->cellAttributes() ?>>
			<span id="el_quotation_setup_header">
<input type="text" data-table="quotation_setup" data-field="x_header" name="x_header" id="x_header" size="50" placeholder="<?php echo HtmlEncode($quotation_setup->header->getPlaceHolder()) ?>" value="<?php echo $quotation_setup->header->EditValue ?>"<?php echo $quotation_setup->header->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation_setup->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label class="<?php echo $quotation_setup_search->LeftColumnClass ?>"><span id="elh_quotation_setup_description"><?php echo $quotation_setup->description->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_description" id="z_description" value="="></span>
		</label>
		<div class="<?php echo $quotation_setup_search->RightColumnClass ?>"><div<?php echo $quotation_setup->description->cellAttributes() ?>>
			<span id="el_quotation_setup_description">
<input type="text" data-table="quotation_setup" data-field="x_description" name="x_description" id="x_description" size="50" placeholder="<?php echo HtmlEncode($quotation_setup->description->getPlaceHolder()) ?>" value="<?php echo $quotation_setup->description->EditValue ?>"<?php echo $quotation_setup->description->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation_setup->footer->Visible) { // footer ?>
	<div id="r_footer" class="form-group row">
		<label class="<?php echo $quotation_setup_search->LeftColumnClass ?>"><span id="elh_quotation_setup_footer"><?php echo $quotation_setup->footer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_footer" id="z_footer" value="="></span>
		</label>
		<div class="<?php echo $quotation_setup_search->RightColumnClass ?>"><div<?php echo $quotation_setup->footer->cellAttributes() ?>>
			<span id="el_quotation_setup_footer">
<input type="text" data-table="quotation_setup" data-field="x_footer" name="x_footer" id="x_footer" size="50" placeholder="<?php echo HtmlEncode($quotation_setup->footer->getPlaceHolder()) ?>" value="<?php echo $quotation_setup->footer->EditValue ?>"<?php echo $quotation_setup->footer->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation_setup->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $quotation_setup_search->LeftColumnClass ?>"><span id="elh_quotation_setup_operator"><?php echo $quotation_setup->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $quotation_setup_search->RightColumnClass ?>"><div<?php echo $quotation_setup->operator->cellAttributes() ?>>
			<span id="el_quotation_setup_operator">
<input type="text" data-table="quotation_setup" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($quotation_setup->operator->getPlaceHolder()) ?>" value="<?php echo $quotation_setup->operator->EditValue ?>"<?php echo $quotation_setup->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation_setup->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $quotation_setup_search->LeftColumnClass ?>"><span id="elh_quotation_setup_datetime"><?php echo $quotation_setup->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $quotation_setup_search->RightColumnClass ?>"><div<?php echo $quotation_setup->datetime->cellAttributes() ?>>
			<span id="el_quotation_setup_datetime">
<input type="text" data-table="quotation_setup" data-field="x_datetime" name="x_datetime" id="x_datetime" size="30" placeholder="<?php echo HtmlEncode($quotation_setup->datetime->getPlaceHolder()) ?>" value="<?php echo $quotation_setup->datetime->EditValue ?>"<?php echo $quotation_setup->datetime->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$quotation_setup_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $quotation_setup_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$quotation_setup_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$quotation_setup_search->terminate();
?>