<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$quotation_list = new quotation_list();

// Run the page
$quotation_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$quotation_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$quotation->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fquotationlist = currentForm = new ew.Form("fquotationlist", "list");
fquotationlist.formKeyCountName = '<?php echo $quotation_list->FormKeyCountName ?>';

// Form_CustomValidate event
fquotationlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fquotationlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fquotationlist.lists["x_godown_id[]"] = <?php echo $quotation_list->godown_id->Lookup->toClientList() ?>;
fquotationlist.lists["x_godown_id[]"].options = <?php echo JsonEncode($quotation_list->godown_id->lookupOptions()) ?>;
fquotationlist.lists["x_product"] = <?php echo $quotation_list->product->Lookup->toClientList() ?>;
fquotationlist.lists["x_product"].options = <?php echo JsonEncode($quotation_list->product->lookupOptions()) ?>;
fquotationlist.lists["x_v_01[]"] = <?php echo $quotation_list->v_01->Lookup->toClientList() ?>;
fquotationlist.lists["x_v_01[]"].options = <?php echo JsonEncode($quotation_list->v_01->lookupOptions()) ?>;
fquotationlist.lists["x_v_02[]"] = <?php echo $quotation_list->v_02->Lookup->toClientList() ?>;
fquotationlist.lists["x_v_02[]"].options = <?php echo JsonEncode($quotation_list->v_02->lookupOptions()) ?>;
fquotationlist.lists["x_v_03[]"] = <?php echo $quotation_list->v_03->Lookup->toClientList() ?>;
fquotationlist.lists["x_v_03[]"].options = <?php echo JsonEncode($quotation_list->v_03->lookupOptions()) ?>;
fquotationlist.lists["x_v_04[]"] = <?php echo $quotation_list->v_04->Lookup->toClientList() ?>;
fquotationlist.lists["x_v_04[]"].options = <?php echo JsonEncode($quotation_list->v_04->lookupOptions()) ?>;
fquotationlist.lists["x_v_05[]"] = <?php echo $quotation_list->v_05->Lookup->toClientList() ?>;
fquotationlist.lists["x_v_05[]"].options = <?php echo JsonEncode($quotation_list->v_05->lookupOptions()) ?>;

// Form object for search
var fquotationlistsrch = currentSearchForm = new ew.Form("fquotationlistsrch");

// Validate function for search
fquotationlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fquotationlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fquotationlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fquotationlistsrch.lists["x_godown_id[]"] = <?php echo $quotation_list->godown_id->Lookup->toClientList() ?>;
fquotationlistsrch.lists["x_godown_id[]"].options = <?php echo JsonEncode($quotation_list->godown_id->lookupOptions()) ?>;
fquotationlistsrch.lists["x_product"] = <?php echo $quotation_list->product->Lookup->toClientList() ?>;
fquotationlistsrch.lists["x_product"].options = <?php echo JsonEncode($quotation_list->product->lookupOptions()) ?>;
fquotationlistsrch.lists["x_v_01[]"] = <?php echo $quotation_list->v_01->Lookup->toClientList() ?>;
fquotationlistsrch.lists["x_v_01[]"].options = <?php echo JsonEncode($quotation_list->v_01->lookupOptions()) ?>;
fquotationlistsrch.lists["x_v_02[]"] = <?php echo $quotation_list->v_02->Lookup->toClientList() ?>;
fquotationlistsrch.lists["x_v_02[]"].options = <?php echo JsonEncode($quotation_list->v_02->lookupOptions()) ?>;
fquotationlistsrch.lists["x_v_03[]"] = <?php echo $quotation_list->v_03->Lookup->toClientList() ?>;
fquotationlistsrch.lists["x_v_03[]"].options = <?php echo JsonEncode($quotation_list->v_03->lookupOptions()) ?>;
fquotationlistsrch.lists["x_v_04[]"] = <?php echo $quotation_list->v_04->Lookup->toClientList() ?>;
fquotationlistsrch.lists["x_v_04[]"].options = <?php echo JsonEncode($quotation_list->v_04->lookupOptions()) ?>;
fquotationlistsrch.lists["x_v_05[]"] = <?php echo $quotation_list->v_05->Lookup->toClientList() ?>;
fquotationlistsrch.lists["x_v_05[]"].options = <?php echo JsonEncode($quotation_list->v_05->lookupOptions()) ?>;

// Filters
fquotationlistsrch.filterList = <?php echo $quotation_list->getFilterList() ?>;

// Init search panel as collapsed
fquotationlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$quotation->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($quotation_list->TotalRecs > 0 && $quotation_list->ExportOptions->visible()) { ?>
<?php $quotation_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($quotation_list->ImportOptions->visible()) { ?>
<?php $quotation_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($quotation_list->SearchOptions->visible()) { ?>
<?php $quotation_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($quotation_list->FilterOptions->visible()) { ?>
<?php $quotation_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$quotation_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$quotation->isExport() && !$quotation->CurrentAction) { ?>
<form name="fquotationlistsrch" id="fquotationlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($quotation_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fquotationlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="quotation">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$quotation_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$quotation->RowType = ROWTYPE_SEARCH;

// Render row
$quotation->resetAttributes();
$quotation_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($quotation->godown_id->Visible) { // godown_id ?>
	<div id="xsc_godown_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $quotation->godown_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown_id" id="z_godown_id" value="="></span>
		<span class="ew-search-field">
<div id="tp_x_godown_id" class="ew-template"><input type="checkbox" class="form-check-input" data-table="quotation" data-field="x_godown_id" data-value-separator="<?php echo $quotation->godown_id->displayValueSeparatorAttribute() ?>" name="x_godown_id[]" id="x_godown_id[]" value="{value}"<?php echo $quotation->godown_id->editAttributes() ?>></div>
<div id="dsl_x_godown_id" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $quotation->godown_id->checkBoxListHtml(FALSE, "x_godown_id[]") ?>
</div></div>
<?php echo $quotation->godown_id->Lookup->getParamTag("p_x_godown_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($quotation->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $quotation->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="quotation" data-field="x_product" data-value-separator="<?php echo $quotation->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $quotation->product->editAttributes() ?>>
		<?php echo $quotation->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $quotation->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($quotation->product_code->Visible) { // product_code ?>
	<div id="xsc_product_code" class="ew-cell form-group">
		<label for="x_product_code" class="ew-search-caption ew-label"><?php echo $quotation->product_code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="quotation" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($quotation->product_code->getPlaceHolder()) ?>" value="<?php echo $quotation->product_code->EditValue ?>"<?php echo $quotation->product_code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($quotation->v_01->Visible) { // v_01 ?>
	<div id="xsc_v_01" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $quotation->v_01->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_v_01" id="z_v_01" value="="></span>
		<span class="ew-search-field">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($quotation->v_01->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $quotation->v_01->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_v_01" data-repeatcolumn="3" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $quotation->v_01->checkBoxListHtml(TRUE, "x_v_01[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_v_01" class="ew-template"><input type="checkbox" class="form-check-input" data-table="quotation" data-field="x_v_01" data-value-separator="<?php echo $quotation->v_01->displayValueSeparatorAttribute() ?>" name="x_v_01[]" id="x_v_01[]" value="{value}"<?php echo $quotation->v_01->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$quotation->v_01->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $quotation->v_01->Lookup->getParamTag("p_x_v_01") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
	</div>
<?php } ?>
<?php if ($quotation->v_02->Visible) { // v_02 ?>
	<div id="xsc_v_02" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $quotation->v_02->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_v_02" id="z_v_02" value="="></span>
		<span class="ew-search-field">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($quotation->v_02->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $quotation->v_02->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_v_02" data-repeatcolumn="3" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $quotation->v_02->checkBoxListHtml(TRUE, "x_v_02[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_v_02" class="ew-template"><input type="checkbox" class="form-check-input" data-table="quotation" data-field="x_v_02" data-value-separator="<?php echo $quotation->v_02->displayValueSeparatorAttribute() ?>" name="x_v_02[]" id="x_v_02[]" value="{value}"<?php echo $quotation->v_02->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$quotation->v_02->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $quotation->v_02->Lookup->getParamTag("p_x_v_02") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
	</div>
<?php } ?>
<?php if ($quotation->v_03->Visible) { // v_03 ?>
	<div id="xsc_v_03" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $quotation->v_03->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_v_03" id="z_v_03" value="="></span>
		<span class="ew-search-field">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($quotation->v_03->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $quotation->v_03->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_v_03" data-repeatcolumn="3" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $quotation->v_03->checkBoxListHtml(TRUE, "x_v_03[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_v_03" class="ew-template"><input type="checkbox" class="form-check-input" data-table="quotation" data-field="x_v_03" data-value-separator="<?php echo $quotation->v_03->displayValueSeparatorAttribute() ?>" name="x_v_03[]" id="x_v_03[]" value="{value}"<?php echo $quotation->v_03->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$quotation->v_03->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $quotation->v_03->Lookup->getParamTag("p_x_v_03") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($quotation->v_04->Visible) { // v_04 ?>
	<div id="xsc_v_04" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $quotation->v_04->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_v_04" id="z_v_04" value="="></span>
		<span class="ew-search-field">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($quotation->v_04->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $quotation->v_04->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_v_04" data-repeatcolumn="3" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $quotation->v_04->checkBoxListHtml(TRUE, "x_v_04[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_v_04" class="ew-template"><input type="checkbox" class="form-check-input" data-table="quotation" data-field="x_v_04" data-value-separator="<?php echo $quotation->v_04->displayValueSeparatorAttribute() ?>" name="x_v_04[]" id="x_v_04[]" value="{value}"<?php echo $quotation->v_04->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$quotation->v_04->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $quotation->v_04->Lookup->getParamTag("p_x_v_04") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
	</div>
<?php } ?>
<?php if ($quotation->v_05->Visible) { // v_05 ?>
	<div id="xsc_v_05" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $quotation->v_05->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_v_05" id="z_v_05" value="="></span>
		<span class="ew-search-field">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($quotation->v_05->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $quotation->v_05->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_v_05" data-repeatcolumn="3" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $quotation->v_05->checkBoxListHtml(TRUE, "x_v_05[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_v_05" class="ew-template"><input type="checkbox" class="form-check-input" data-table="quotation" data-field="x_v_05" data-value-separator="<?php echo $quotation->v_05->displayValueSeparatorAttribute() ?>" name="x_v_05[]" id="x_v_05[]" value="{value}"<?php echo $quotation->v_05->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$quotation->v_05->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $quotation->v_05->Lookup->getParamTag("p_x_v_05") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($quotation_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($quotation_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $quotation_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($quotation_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($quotation_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($quotation_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($quotation_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $quotation_list->showPageHeader(); ?>
<?php
$quotation_list->showMessage();
?>
<?php if ($quotation_list->TotalRecs > 0 || $quotation->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($quotation_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> quotation">
<?php if (!$quotation->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$quotation->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($quotation_list->Pager)) $quotation_list->Pager = new PrevNextPager($quotation_list->StartRec, $quotation_list->DisplayRecs, $quotation_list->TotalRecs, $quotation_list->AutoHidePager) ?>
<?php if ($quotation_list->Pager->RecordCount > 0 && $quotation_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($quotation_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $quotation_list->pageUrl() ?>start=<?php echo $quotation_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($quotation_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $quotation_list->pageUrl() ?>start=<?php echo $quotation_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $quotation_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($quotation_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $quotation_list->pageUrl() ?>start=<?php echo $quotation_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($quotation_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $quotation_list->pageUrl() ?>start=<?php echo $quotation_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $quotation_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($quotation_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $quotation_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $quotation_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $quotation_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($quotation_list->TotalRecs > 0 && (!$quotation_list->AutoHidePageSizeSelector || $quotation_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="quotation">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($quotation_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($quotation_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($quotation_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($quotation_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($quotation_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($quotation->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $quotation_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fquotationlist" id="fquotationlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($quotation_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $quotation_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="quotation">
<div id="gmp_quotation" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($quotation_list->TotalRecs > 0 || $quotation->isGridEdit()) { ?>
<table id="tbl_quotationlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$quotation_list->RowType = ROWTYPE_HEADER;

// Render list options
$quotation_list->renderListOptions();

// Render list options (header, left)
$quotation_list->ListOptions->render("header", "left");
?>
<?php if ($quotation->id->Visible) { // id ?>
	<?php if ($quotation->sortUrl($quotation->id) == "") { ?>
		<th data-name="id" class="<?php echo $quotation->id->headerCellClass() ?>"><div id="elh_quotation_id" class="quotation_id"><div class="ew-table-header-caption"><?php echo $quotation->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $quotation->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->id) ?>',2);"><div id="elh_quotation_id" class="quotation_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($quotation->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->main_image->Visible) { // main_image ?>
	<?php if ($quotation->sortUrl($quotation->main_image) == "") { ?>
		<th data-name="main_image" class="<?php echo $quotation->main_image->headerCellClass() ?>"><div id="elh_quotation_main_image" class="quotation_main_image"><div class="ew-table-header-caption"><?php echo $quotation->main_image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="main_image" class="<?php echo $quotation->main_image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->main_image) ?>',2);"><div id="elh_quotation_main_image" class="quotation_main_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->main_image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($quotation->main_image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->main_image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->godown_id->Visible) { // godown_id ?>
	<?php if ($quotation->sortUrl($quotation->godown_id) == "") { ?>
		<th data-name="godown_id" class="<?php echo $quotation->godown_id->headerCellClass() ?>"><div id="elh_quotation_godown_id" class="quotation_godown_id"><div class="ew-table-header-caption"><?php echo $quotation->godown_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="godown_id" class="<?php echo $quotation->godown_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->godown_id) ?>',2);"><div id="elh_quotation_godown_id" class="quotation_godown_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->godown_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($quotation->godown_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->godown_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->product->Visible) { // product ?>
	<?php if ($quotation->sortUrl($quotation->product) == "") { ?>
		<th data-name="product" class="<?php echo $quotation->product->headerCellClass() ?>"><div id="elh_quotation_product" class="quotation_product"><div class="ew-table-header-caption"><?php echo $quotation->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $quotation->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->product) ?>',2);"><div id="elh_quotation_product" class="quotation_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($quotation->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->product_code->Visible) { // product_code ?>
	<?php if ($quotation->sortUrl($quotation->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $quotation->product_code->headerCellClass() ?>"><div id="elh_quotation_product_code" class="quotation_product_code"><div class="ew-table-header-caption"><?php echo $quotation->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $quotation->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->product_code) ?>',2);"><div id="elh_quotation_product_code" class="quotation_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($quotation->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->Balance->Visible) { // Balance ?>
	<?php if ($quotation->sortUrl($quotation->Balance) == "") { ?>
		<th data-name="Balance" class="<?php echo $quotation->Balance->headerCellClass() ?>"><div id="elh_quotation_Balance" class="quotation_Balance"><div class="ew-table-header-caption"><?php echo $quotation->Balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Balance" class="<?php echo $quotation->Balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->Balance) ?>',2);"><div id="elh_quotation_Balance" class="quotation_Balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->Balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($quotation->Balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->Balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->price->Visible) { // price ?>
	<?php if ($quotation->sortUrl($quotation->price) == "") { ?>
		<th data-name="price" class="<?php echo $quotation->price->headerCellClass() ?>"><div id="elh_quotation_price" class="quotation_price"><div class="ew-table-header-caption"><?php echo $quotation->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $quotation->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->price) ?>',2);"><div id="elh_quotation_price" class="quotation_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($quotation->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->price_kg->Visible) { // price_kg ?>
	<?php if ($quotation->sortUrl($quotation->price_kg) == "") { ?>
		<th data-name="price_kg" class="<?php echo $quotation->price_kg->headerCellClass() ?>"><div id="elh_quotation_price_kg" class="quotation_price_kg"><div class="ew-table-header-caption"><?php echo $quotation->price_kg->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price_kg" class="<?php echo $quotation->price_kg->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->price_kg) ?>',2);"><div id="elh_quotation_price_kg" class="quotation_price_kg">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->price_kg->caption() ?></span><span class="ew-table-header-sort"><?php if ($quotation->price_kg->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->price_kg->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->price_unit->Visible) { // price_unit ?>
	<?php if ($quotation->sortUrl($quotation->price_unit) == "") { ?>
		<th data-name="price_unit" class="<?php echo $quotation->price_unit->headerCellClass() ?>"><div id="elh_quotation_price_unit" class="quotation_price_unit"><div class="ew-table-header-caption"><?php echo $quotation->price_unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price_unit" class="<?php echo $quotation->price_unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->price_unit) ?>',2);"><div id="elh_quotation_price_unit" class="quotation_price_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->price_unit->caption() ?></span><span class="ew-table-header-sort"><?php if ($quotation->price_unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->price_unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->b_12->Visible) { // b_12 ?>
	<?php if ($quotation->sortUrl($quotation->b_12) == "") { ?>
		<th data-name="b_12" class="<?php echo $quotation->b_12->headerCellClass() ?>"><div id="elh_quotation_b_12" class="quotation_b_12"><div class="ew-table-header-caption"><?php echo $quotation->b_12->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_12" class="<?php echo $quotation->b_12->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->b_12) ?>',2);"><div id="elh_quotation_b_12" class="quotation_b_12">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->b_12->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($quotation->b_12->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->b_12->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->b_01->Visible) { // b_01 ?>
	<?php if ($quotation->sortUrl($quotation->b_01) == "") { ?>
		<th data-name="b_01" class="<?php echo $quotation->b_01->headerCellClass() ?>"><div id="elh_quotation_b_01" class="quotation_b_01"><div class="ew-table-header-caption"><?php echo $quotation->b_01->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_01" class="<?php echo $quotation->b_01->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->b_01) ?>',2);"><div id="elh_quotation_b_01" class="quotation_b_01">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->b_01->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($quotation->b_01->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->b_01->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->v_01->Visible) { // v_01 ?>
	<?php if ($quotation->sortUrl($quotation->v_01) == "") { ?>
		<th data-name="v_01" class="<?php echo $quotation->v_01->headerCellClass() ?>"><div id="elh_quotation_v_01" class="quotation_v_01"><div class="ew-table-header-caption"><?php echo $quotation->v_01->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_01" class="<?php echo $quotation->v_01->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->v_01) ?>',2);"><div id="elh_quotation_v_01" class="quotation_v_01">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->v_01->caption() ?></span><span class="ew-table-header-sort"><?php if ($quotation->v_01->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->v_01->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->v_02->Visible) { // v_02 ?>
	<?php if ($quotation->sortUrl($quotation->v_02) == "") { ?>
		<th data-name="v_02" class="<?php echo $quotation->v_02->headerCellClass() ?>"><div id="elh_quotation_v_02" class="quotation_v_02"><div class="ew-table-header-caption"><?php echo $quotation->v_02->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_02" class="<?php echo $quotation->v_02->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->v_02) ?>',2);"><div id="elh_quotation_v_02" class="quotation_v_02">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->v_02->caption() ?></span><span class="ew-table-header-sort"><?php if ($quotation->v_02->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->v_02->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->v_03->Visible) { // v_03 ?>
	<?php if ($quotation->sortUrl($quotation->v_03) == "") { ?>
		<th data-name="v_03" class="<?php echo $quotation->v_03->headerCellClass() ?>"><div id="elh_quotation_v_03" class="quotation_v_03"><div class="ew-table-header-caption"><?php echo $quotation->v_03->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_03" class="<?php echo $quotation->v_03->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->v_03) ?>',2);"><div id="elh_quotation_v_03" class="quotation_v_03">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->v_03->caption() ?></span><span class="ew-table-header-sort"><?php if ($quotation->v_03->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->v_03->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->v_04->Visible) { // v_04 ?>
	<?php if ($quotation->sortUrl($quotation->v_04) == "") { ?>
		<th data-name="v_04" class="<?php echo $quotation->v_04->headerCellClass() ?>"><div id="elh_quotation_v_04" class="quotation_v_04"><div class="ew-table-header-caption"><?php echo $quotation->v_04->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_04" class="<?php echo $quotation->v_04->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->v_04) ?>',2);"><div id="elh_quotation_v_04" class="quotation_v_04">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->v_04->caption() ?></span><span class="ew-table-header-sort"><?php if ($quotation->v_04->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->v_04->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->v_05->Visible) { // v_05 ?>
	<?php if ($quotation->sortUrl($quotation->v_05) == "") { ?>
		<th data-name="v_05" class="<?php echo $quotation->v_05->headerCellClass() ?>"><div id="elh_quotation_v_05" class="quotation_v_05"><div class="ew-table-header-caption"><?php echo $quotation->v_05->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="v_05" class="<?php echo $quotation->v_05->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->v_05) ?>',2);"><div id="elh_quotation_v_05" class="quotation_v_05">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->v_05->caption() ?></span><span class="ew-table-header-sort"><?php if ($quotation->v_05->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->v_05->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->Amount->Visible) { // Amount ?>
	<?php if ($quotation->sortUrl($quotation->Amount) == "") { ?>
		<th data-name="Amount" class="<?php echo $quotation->Amount->headerCellClass() ?>"><div id="elh_quotation_Amount" class="quotation_Amount"><div class="ew-table-header-caption"><?php echo $quotation->Amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Amount" class="<?php echo $quotation->Amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->Amount) ?>',2);"><div id="elh_quotation_Amount" class="quotation_Amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->Amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($quotation->Amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->Amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($quotation->packing_type->Visible) { // packing_type ?>
	<?php if ($quotation->sortUrl($quotation->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $quotation->packing_type->headerCellClass() ?>"><div id="elh_quotation_packing_type" class="quotation_packing_type"><div class="ew-table-header-caption"><?php echo $quotation->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $quotation->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $quotation->SortUrl($quotation->packing_type) ?>',2);"><div id="elh_quotation_packing_type" class="quotation_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $quotation->packing_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($quotation->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($quotation->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$quotation_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($quotation->ExportAll && $quotation->isExport()) {
	$quotation_list->StopRec = $quotation_list->TotalRecs;
} else {

	// Set the last record to display
	if ($quotation_list->TotalRecs > $quotation_list->StartRec + $quotation_list->DisplayRecs - 1)
		$quotation_list->StopRec = $quotation_list->StartRec + $quotation_list->DisplayRecs - 1;
	else
		$quotation_list->StopRec = $quotation_list->TotalRecs;
}
$quotation_list->RecCnt = $quotation_list->StartRec - 1;
if ($quotation_list->Recordset && !$quotation_list->Recordset->EOF) {
	$quotation_list->Recordset->moveFirst();
	$selectLimit = $quotation_list->UseSelectLimit;
	if (!$selectLimit && $quotation_list->StartRec > 1)
		$quotation_list->Recordset->move($quotation_list->StartRec - 1);
} elseif (!$quotation->AllowAddDeleteRow && $quotation_list->StopRec == 0) {
	$quotation_list->StopRec = $quotation->GridAddRowCount;
}

// Initialize aggregate
$quotation->RowType = ROWTYPE_AGGREGATEINIT;
$quotation->resetAttributes();
$quotation_list->renderRow();
while ($quotation_list->RecCnt < $quotation_list->StopRec) {
	$quotation_list->RecCnt++;
	if ($quotation_list->RecCnt >= $quotation_list->StartRec) {
		$quotation_list->RowCnt++;

		// Set up key count
		$quotation_list->KeyCount = $quotation_list->RowIndex;

		// Init row class and style
		$quotation->resetAttributes();
		$quotation->CssClass = "";
		if ($quotation->isGridAdd()) {
		} else {
			$quotation_list->loadRowValues($quotation_list->Recordset); // Load row values
		}
		$quotation->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$quotation->RowAttrs = array_merge($quotation->RowAttrs, array('data-rowindex'=>$quotation_list->RowCnt, 'id'=>'r' . $quotation_list->RowCnt . '_quotation', 'data-rowtype'=>$quotation->RowType));

		// Render row
		$quotation_list->renderRow();

		// Render list options
		$quotation_list->renderListOptions();
?>
	<tr<?php echo $quotation->rowAttributes() ?>>
<?php

// Render list options (body, left)
$quotation_list->ListOptions->render("body", "left", $quotation_list->RowCnt);
?>
	<?php if ($quotation->id->Visible) { // id ?>
		<td data-name="id"<?php echo $quotation->id->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_id" class="quotation_id">
<span<?php echo $quotation->id->viewAttributes() ?>>
<?php echo $quotation->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->main_image->Visible) { // main_image ?>
		<td data-name="main_image"<?php echo $quotation->main_image->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_main_image" class="quotation_main_image">
<span>
<?php echo GetFileViewTag($quotation->main_image, $quotation->main_image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->godown_id->Visible) { // godown_id ?>
		<td data-name="godown_id"<?php echo $quotation->godown_id->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_godown_id" class="quotation_godown_id">
<span<?php echo $quotation->godown_id->viewAttributes() ?>>
<?php if ((!EmptyString($quotation->godown_id->getViewValue())) && $quotation->godown_id->linkAttributes() <> "") { ?>
<a<?php echo $quotation->godown_id->linkAttributes() ?>><?php echo $quotation->godown_id->getViewValue() ?></a>
<?php } else { ?>
<?php echo $quotation->godown_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->product->Visible) { // product ?>
		<td data-name="product"<?php echo $quotation->product->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_product" class="quotation_product">
<span<?php echo $quotation->product->viewAttributes() ?>>
<?php if ((!EmptyString($quotation->product->getViewValue())) && $quotation->product->linkAttributes() <> "") { ?>
<a<?php echo $quotation->product->linkAttributes() ?>><?php echo $quotation->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $quotation->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $quotation->product_code->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_product_code" class="quotation_product_code">
<span<?php echo $quotation->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($quotation->product_code->getViewValue())) && $quotation->product_code->linkAttributes() <> "") { ?>
<a<?php echo $quotation->product_code->linkAttributes() ?>><?php echo $quotation->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $quotation->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->Balance->Visible) { // Balance ?>
		<td data-name="Balance"<?php echo $quotation->Balance->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_Balance" class="quotation_Balance">
<span<?php echo $quotation->Balance->viewAttributes() ?>>
<?php echo $quotation->Balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->price->Visible) { // price ?>
		<td data-name="price"<?php echo $quotation->price->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_price" class="quotation_price">
<span<?php echo $quotation->price->viewAttributes() ?>>
<?php echo $quotation->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->price_kg->Visible) { // price_kg ?>
		<td data-name="price_kg"<?php echo $quotation->price_kg->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_price_kg" class="quotation_price_kg">
<span<?php echo $quotation->price_kg->viewAttributes() ?>>
<?php echo $quotation->price_kg->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->price_unit->Visible) { // price_unit ?>
		<td data-name="price_unit"<?php echo $quotation->price_unit->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_price_unit" class="quotation_price_unit">
<span<?php echo $quotation->price_unit->viewAttributes() ?>>
<?php echo $quotation->price_unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->b_12->Visible) { // b_12 ?>
		<td data-name="b_12"<?php echo $quotation->b_12->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_b_12" class="quotation_b_12">
<span<?php echo $quotation->b_12->viewAttributes() ?>>
<?php echo $quotation->b_12->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->b_01->Visible) { // b_01 ?>
		<td data-name="b_01"<?php echo $quotation->b_01->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_b_01" class="quotation_b_01">
<span<?php echo $quotation->b_01->viewAttributes() ?>>
<?php echo $quotation->b_01->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->v_01->Visible) { // v_01 ?>
		<td data-name="v_01"<?php echo $quotation->v_01->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_v_01" class="quotation_v_01">
<span<?php echo $quotation->v_01->viewAttributes() ?>>
<?php if ((!EmptyString($quotation->v_01->getViewValue())) && $quotation->v_01->linkAttributes() <> "") { ?>
<a<?php echo $quotation->v_01->linkAttributes() ?>><?php echo $quotation->v_01->getViewValue() ?></a>
<?php } else { ?>
<?php echo $quotation->v_01->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->v_02->Visible) { // v_02 ?>
		<td data-name="v_02"<?php echo $quotation->v_02->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_v_02" class="quotation_v_02">
<span<?php echo $quotation->v_02->viewAttributes() ?>>
<?php if ((!EmptyString($quotation->v_02->getViewValue())) && $quotation->v_02->linkAttributes() <> "") { ?>
<a<?php echo $quotation->v_02->linkAttributes() ?>><?php echo $quotation->v_02->getViewValue() ?></a>
<?php } else { ?>
<?php echo $quotation->v_02->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->v_03->Visible) { // v_03 ?>
		<td data-name="v_03"<?php echo $quotation->v_03->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_v_03" class="quotation_v_03">
<span<?php echo $quotation->v_03->viewAttributes() ?>>
<?php if ((!EmptyString($quotation->v_03->getViewValue())) && $quotation->v_03->linkAttributes() <> "") { ?>
<a<?php echo $quotation->v_03->linkAttributes() ?>><?php echo $quotation->v_03->getViewValue() ?></a>
<?php } else { ?>
<?php echo $quotation->v_03->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->v_04->Visible) { // v_04 ?>
		<td data-name="v_04"<?php echo $quotation->v_04->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_v_04" class="quotation_v_04">
<span<?php echo $quotation->v_04->viewAttributes() ?>>
<?php if ((!EmptyString($quotation->v_04->getViewValue())) && $quotation->v_04->linkAttributes() <> "") { ?>
<a<?php echo $quotation->v_04->linkAttributes() ?>><?php echo $quotation->v_04->getViewValue() ?></a>
<?php } else { ?>
<?php echo $quotation->v_04->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->v_05->Visible) { // v_05 ?>
		<td data-name="v_05"<?php echo $quotation->v_05->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_v_05" class="quotation_v_05">
<span<?php echo $quotation->v_05->viewAttributes() ?>>
<?php if ((!EmptyString($quotation->v_05->getViewValue())) && $quotation->v_05->linkAttributes() <> "") { ?>
<a<?php echo $quotation->v_05->linkAttributes() ?>><?php echo $quotation->v_05->getViewValue() ?></a>
<?php } else { ?>
<?php echo $quotation->v_05->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->Amount->Visible) { // Amount ?>
		<td data-name="Amount"<?php echo $quotation->Amount->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_Amount" class="quotation_Amount">
<span<?php echo $quotation->Amount->viewAttributes() ?>>
<?php echo $quotation->Amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($quotation->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $quotation->packing_type->cellAttributes() ?>>
<span id="el<?php echo $quotation_list->RowCnt ?>_quotation_packing_type" class="quotation_packing_type">
<span<?php echo $quotation->packing_type->viewAttributes() ?>>
<?php echo $quotation->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$quotation_list->ListOptions->render("body", "right", $quotation_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$quotation->isGridAdd())
		$quotation_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$quotation->RowType = ROWTYPE_AGGREGATE;
$quotation->resetAttributes();
$quotation_list->renderRow();
?>
<?php if ($quotation_list->TotalRecs > 0 && !$quotation->isGridAdd() && !$quotation->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$quotation_list->renderListOptions();

// Render list options (footer, left)
$quotation_list->ListOptions->render("footer", "left");
?>
	<?php if ($quotation->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $quotation->id->footerCellClass() ?>"><span id="elf_quotation_id" class="quotation_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($quotation->main_image->Visible) { // main_image ?>
		<td data-name="main_image" class="<?php echo $quotation->main_image->footerCellClass() ?>"><span id="elf_quotation_main_image" class="quotation_main_image">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($quotation->godown_id->Visible) { // godown_id ?>
		<td data-name="godown_id" class="<?php echo $quotation->godown_id->footerCellClass() ?>"><span id="elf_quotation_godown_id" class="quotation_godown_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($quotation->product->Visible) { // product ?>
		<td data-name="product" class="<?php echo $quotation->product->footerCellClass() ?>"><span id="elf_quotation_product" class="quotation_product">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($quotation->product_code->Visible) { // product_code ?>
		<td data-name="product_code" class="<?php echo $quotation->product_code->footerCellClass() ?>"><span id="elf_quotation_product_code" class="quotation_product_code">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($quotation->Balance->Visible) { // Balance ?>
		<td data-name="Balance" class="<?php echo $quotation->Balance->footerCellClass() ?>"><span id="elf_quotation_Balance" class="quotation_Balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $quotation->Balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($quotation->price->Visible) { // price ?>
		<td data-name="price" class="<?php echo $quotation->price->footerCellClass() ?>"><span id="elf_quotation_price" class="quotation_price">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($quotation->price_kg->Visible) { // price_kg ?>
		<td data-name="price_kg" class="<?php echo $quotation->price_kg->footerCellClass() ?>"><span id="elf_quotation_price_kg" class="quotation_price_kg">
		<span class="ew-aggregate"><?php echo $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
		<?php echo $quotation->price_kg->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($quotation->price_unit->Visible) { // price_unit ?>
		<td data-name="price_unit" class="<?php echo $quotation->price_unit->footerCellClass() ?>"><span id="elf_quotation_price_unit" class="quotation_price_unit">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($quotation->b_12->Visible) { // b_12 ?>
		<td data-name="b_12" class="<?php echo $quotation->b_12->footerCellClass() ?>"><span id="elf_quotation_b_12" class="quotation_b_12">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($quotation->b_01->Visible) { // b_01 ?>
		<td data-name="b_01" class="<?php echo $quotation->b_01->footerCellClass() ?>"><span id="elf_quotation_b_01" class="quotation_b_01">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($quotation->v_01->Visible) { // v_01 ?>
		<td data-name="v_01" class="<?php echo $quotation->v_01->footerCellClass() ?>"><span id="elf_quotation_v_01" class="quotation_v_01">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($quotation->v_02->Visible) { // v_02 ?>
		<td data-name="v_02" class="<?php echo $quotation->v_02->footerCellClass() ?>"><span id="elf_quotation_v_02" class="quotation_v_02">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($quotation->v_03->Visible) { // v_03 ?>
		<td data-name="v_03" class="<?php echo $quotation->v_03->footerCellClass() ?>"><span id="elf_quotation_v_03" class="quotation_v_03">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($quotation->v_04->Visible) { // v_04 ?>
		<td data-name="v_04" class="<?php echo $quotation->v_04->footerCellClass() ?>"><span id="elf_quotation_v_04" class="quotation_v_04">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($quotation->v_05->Visible) { // v_05 ?>
		<td data-name="v_05" class="<?php echo $quotation->v_05->footerCellClass() ?>"><span id="elf_quotation_v_05" class="quotation_v_05">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($quotation->Amount->Visible) { // Amount ?>
		<td data-name="Amount" class="<?php echo $quotation->Amount->footerCellClass() ?>"><span id="elf_quotation_Amount" class="quotation_Amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $quotation->Amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($quotation->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type" class="<?php echo $quotation->packing_type->footerCellClass() ?>"><span id="elf_quotation_packing_type" class="quotation_packing_type">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$quotation_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$quotation->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($quotation_list->Recordset)
	$quotation_list->Recordset->Close();
?>
<?php if (!$quotation->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$quotation->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($quotation_list->Pager)) $quotation_list->Pager = new PrevNextPager($quotation_list->StartRec, $quotation_list->DisplayRecs, $quotation_list->TotalRecs, $quotation_list->AutoHidePager) ?>
<?php if ($quotation_list->Pager->RecordCount > 0 && $quotation_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($quotation_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $quotation_list->pageUrl() ?>start=<?php echo $quotation_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($quotation_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $quotation_list->pageUrl() ?>start=<?php echo $quotation_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $quotation_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($quotation_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $quotation_list->pageUrl() ?>start=<?php echo $quotation_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($quotation_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $quotation_list->pageUrl() ?>start=<?php echo $quotation_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $quotation_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($quotation_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $quotation_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $quotation_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $quotation_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($quotation_list->TotalRecs > 0 && (!$quotation_list->AutoHidePageSizeSelector || $quotation_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="quotation">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($quotation_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($quotation_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($quotation_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($quotation_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($quotation_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($quotation->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $quotation_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($quotation_list->TotalRecs == 0 && !$quotation->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $quotation_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$quotation_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$quotation->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$quotation->isExport()) { ?>
<script>
ew.scrollableTable("gmp_quotation", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$quotation_list->terminate();
?>