<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$quotation_search = new quotation_search();

// Run the page
$quotation_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$quotation_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($quotation_search->IsModal) { ?>
var fquotationsearch = currentAdvancedSearchForm = new ew.Form("fquotationsearch", "search");
<?php } else { ?>
var fquotationsearch = currentForm = new ew.Form("fquotationsearch", "search");
<?php } ?>

// Form_CustomValidate event
fquotationsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fquotationsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fquotationsearch.lists["x_godown_id[]"] = <?php echo $quotation_search->godown_id->Lookup->toClientList() ?>;
fquotationsearch.lists["x_godown_id[]"].options = <?php echo JsonEncode($quotation_search->godown_id->lookupOptions()) ?>;
fquotationsearch.lists["x_product"] = <?php echo $quotation_search->product->Lookup->toClientList() ?>;
fquotationsearch.lists["x_product"].options = <?php echo JsonEncode($quotation_search->product->lookupOptions()) ?>;
fquotationsearch.lists["x_v_01[]"] = <?php echo $quotation_search->v_01->Lookup->toClientList() ?>;
fquotationsearch.lists["x_v_01[]"].options = <?php echo JsonEncode($quotation_search->v_01->lookupOptions()) ?>;
fquotationsearch.lists["x_v_02[]"] = <?php echo $quotation_search->v_02->Lookup->toClientList() ?>;
fquotationsearch.lists["x_v_02[]"].options = <?php echo JsonEncode($quotation_search->v_02->lookupOptions()) ?>;
fquotationsearch.lists["x_v_03[]"] = <?php echo $quotation_search->v_03->Lookup->toClientList() ?>;
fquotationsearch.lists["x_v_03[]"].options = <?php echo JsonEncode($quotation_search->v_03->lookupOptions()) ?>;
fquotationsearch.lists["x_v_04[]"] = <?php echo $quotation_search->v_04->Lookup->toClientList() ?>;
fquotationsearch.lists["x_v_04[]"].options = <?php echo JsonEncode($quotation_search->v_04->lookupOptions()) ?>;
fquotationsearch.lists["x_v_05[]"] = <?php echo $quotation_search->v_05->Lookup->toClientList() ?>;
fquotationsearch.lists["x_v_05[]"].options = <?php echo JsonEncode($quotation_search->v_05->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fquotationsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($quotation->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_Balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($quotation->Balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($quotation->price->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price_kg");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($quotation->price_kg->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price_unit");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($quotation->price_unit->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_Amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($quotation->Amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_packing_type");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($quotation->packing_type->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $quotation_search->showPageHeader(); ?>
<?php
$quotation_search->showMessage();
?>
<form name="fquotationsearch" id="fquotationsearch" class="<?php echo $quotation_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($quotation_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $quotation_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="quotation">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$quotation_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($quotation->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_id"><?php echo $quotation->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->id->cellAttributes() ?>>
			<span id="el_quotation_id">
<input type="text" data-table="quotation" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($quotation->id->getPlaceHolder()) ?>" value="<?php echo $quotation->id->EditValue ?>"<?php echo $quotation->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->main_image->Visible) { // main_image ?>
	<div id="r_main_image" class="form-group row">
		<label class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_main_image"><?php echo $quotation->main_image->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_main_image" id="z_main_image" value="LIKE"></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->main_image->cellAttributes() ?>>
			<span id="el_quotation_main_image">
<input type="text" data-table="quotation" data-field="x_main_image" name="x_main_image" id="x_main_image" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($quotation->main_image->getPlaceHolder()) ?>" value="<?php echo $quotation->main_image->EditValue ?>"<?php echo $quotation->main_image->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->godown_id->Visible) { // godown_id ?>
	<div id="r_godown_id" class="form-group row">
		<label class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_godown_id"><?php echo $quotation->godown_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_godown_id" id="z_godown_id" value="="></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->godown_id->cellAttributes() ?>>
			<span id="el_quotation_godown_id">
<div id="tp_x_godown_id" class="ew-template"><input type="checkbox" class="form-check-input" data-table="quotation" data-field="x_godown_id" data-value-separator="<?php echo $quotation->godown_id->displayValueSeparatorAttribute() ?>" name="x_godown_id[]" id="x_godown_id[]" value="{value}"<?php echo $quotation->godown_id->editAttributes() ?>></div>
<div id="dsl_x_godown_id" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $quotation->godown_id->checkBoxListHtml(FALSE, "x_godown_id[]") ?>
</div></div>
<?php echo $quotation->godown_id->Lookup->getParamTag("p_x_godown_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_product"><?php echo $quotation->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->product->cellAttributes() ?>>
			<span id="el_quotation_product">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="quotation" data-field="x_product" data-value-separator="<?php echo $quotation->product->displayValueSeparatorAttribute() ?>" id="x_product" name="x_product"<?php echo $quotation->product->editAttributes() ?>>
		<?php echo $quotation->product->selectOptionListHtml("x_product") ?>
	</select>
</div>
<?php echo $quotation->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label for="x_product_code" class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_product_code"><?php echo $quotation->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->product_code->cellAttributes() ?>>
			<span id="el_quotation_product_code">
<input type="text" data-table="quotation" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($quotation->product_code->getPlaceHolder()) ?>" value="<?php echo $quotation->product_code->EditValue ?>"<?php echo $quotation->product_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->Balance->Visible) { // Balance ?>
	<div id="r_Balance" class="form-group row">
		<label for="x_Balance" class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_Balance"><?php echo $quotation->Balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Balance" id="z_Balance" value="="></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->Balance->cellAttributes() ?>>
			<span id="el_quotation_Balance">
<input type="text" data-table="quotation" data-field="x_Balance" name="x_Balance" id="x_Balance" size="30" placeholder="<?php echo HtmlEncode($quotation->Balance->getPlaceHolder()) ?>" value="<?php echo $quotation->Balance->EditValue ?>"<?php echo $quotation->Balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_price"><?php echo $quotation->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->price->cellAttributes() ?>>
			<span id="el_quotation_price">
<input type="text" data-table="quotation" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($quotation->price->getPlaceHolder()) ?>" value="<?php echo $quotation->price->EditValue ?>"<?php echo $quotation->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->price_kg->Visible) { // price_kg ?>
	<div id="r_price_kg" class="form-group row">
		<label for="x_price_kg" class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_price_kg"><?php echo $quotation->price_kg->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price_kg" id="z_price_kg" value="="></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->price_kg->cellAttributes() ?>>
			<span id="el_quotation_price_kg">
<input type="text" data-table="quotation" data-field="x_price_kg" name="x_price_kg" id="x_price_kg" size="30" placeholder="<?php echo HtmlEncode($quotation->price_kg->getPlaceHolder()) ?>" value="<?php echo $quotation->price_kg->EditValue ?>"<?php echo $quotation->price_kg->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->price_unit->Visible) { // price_unit ?>
	<div id="r_price_unit" class="form-group row">
		<label for="x_price_unit" class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_price_unit"><?php echo $quotation->price_unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price_unit" id="z_price_unit" value="="></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->price_unit->cellAttributes() ?>>
			<span id="el_quotation_price_unit">
<input type="text" data-table="quotation" data-field="x_price_unit" name="x_price_unit" id="x_price_unit" size="30" placeholder="<?php echo HtmlEncode($quotation->price_unit->getPlaceHolder()) ?>" value="<?php echo $quotation->price_unit->EditValue ?>"<?php echo $quotation->price_unit->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->b_12->Visible) { // b_12 ?>
	<div id="r_b_12" class="form-group row">
		<label for="x_b_12" class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_b_12"><?php echo $quotation->b_12->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_12" id="z_b_12" value="LIKE"></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->b_12->cellAttributes() ?>>
			<span id="el_quotation_b_12">
<input type="text" data-table="quotation" data-field="x_b_12" name="x_b_12" id="x_b_12" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($quotation->b_12->getPlaceHolder()) ?>" value="<?php echo $quotation->b_12->EditValue ?>"<?php echo $quotation->b_12->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->b_01->Visible) { // b_01 ?>
	<div id="r_b_01" class="form-group row">
		<label for="x_b_01" class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_b_01"><?php echo $quotation->b_01->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_01" id="z_b_01" value="LIKE"></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->b_01->cellAttributes() ?>>
			<span id="el_quotation_b_01">
<input type="text" data-table="quotation" data-field="x_b_01" name="x_b_01" id="x_b_01" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($quotation->b_01->getPlaceHolder()) ?>" value="<?php echo $quotation->b_01->EditValue ?>"<?php echo $quotation->b_01->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->v_01->Visible) { // v_01 ?>
	<div id="r_v_01" class="form-group row">
		<label class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_v_01"><?php echo $quotation->v_01->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_v_01" id="z_v_01" value="="></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->v_01->cellAttributes() ?>>
			<span id="el_quotation_v_01">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($quotation->v_01->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $quotation->v_01->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_v_01" data-repeatcolumn="3" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $quotation->v_01->checkBoxListHtml(TRUE, "x_v_01[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_v_01" class="ew-template"><input type="checkbox" class="form-check-input" data-table="quotation" data-field="x_v_01" data-value-separator="<?php echo $quotation->v_01->displayValueSeparatorAttribute() ?>" name="x_v_01[]" id="x_v_01[]" value="{value}"<?php echo $quotation->v_01->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$quotation->v_01->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $quotation->v_01->Lookup->getParamTag("p_x_v_01") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->v_02->Visible) { // v_02 ?>
	<div id="r_v_02" class="form-group row">
		<label class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_v_02"><?php echo $quotation->v_02->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_v_02" id="z_v_02" value="="></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->v_02->cellAttributes() ?>>
			<span id="el_quotation_v_02">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($quotation->v_02->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $quotation->v_02->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_v_02" data-repeatcolumn="3" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $quotation->v_02->checkBoxListHtml(TRUE, "x_v_02[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_v_02" class="ew-template"><input type="checkbox" class="form-check-input" data-table="quotation" data-field="x_v_02" data-value-separator="<?php echo $quotation->v_02->displayValueSeparatorAttribute() ?>" name="x_v_02[]" id="x_v_02[]" value="{value}"<?php echo $quotation->v_02->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$quotation->v_02->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $quotation->v_02->Lookup->getParamTag("p_x_v_02") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->v_03->Visible) { // v_03 ?>
	<div id="r_v_03" class="form-group row">
		<label class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_v_03"><?php echo $quotation->v_03->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_v_03" id="z_v_03" value="="></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->v_03->cellAttributes() ?>>
			<span id="el_quotation_v_03">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($quotation->v_03->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $quotation->v_03->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_v_03" data-repeatcolumn="3" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $quotation->v_03->checkBoxListHtml(TRUE, "x_v_03[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_v_03" class="ew-template"><input type="checkbox" class="form-check-input" data-table="quotation" data-field="x_v_03" data-value-separator="<?php echo $quotation->v_03->displayValueSeparatorAttribute() ?>" name="x_v_03[]" id="x_v_03[]" value="{value}"<?php echo $quotation->v_03->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$quotation->v_03->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $quotation->v_03->Lookup->getParamTag("p_x_v_03") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->v_04->Visible) { // v_04 ?>
	<div id="r_v_04" class="form-group row">
		<label class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_v_04"><?php echo $quotation->v_04->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_v_04" id="z_v_04" value="="></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->v_04->cellAttributes() ?>>
			<span id="el_quotation_v_04">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($quotation->v_04->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $quotation->v_04->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_v_04" data-repeatcolumn="3" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $quotation->v_04->checkBoxListHtml(TRUE, "x_v_04[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_v_04" class="ew-template"><input type="checkbox" class="form-check-input" data-table="quotation" data-field="x_v_04" data-value-separator="<?php echo $quotation->v_04->displayValueSeparatorAttribute() ?>" name="x_v_04[]" id="x_v_04[]" value="{value}"<?php echo $quotation->v_04->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$quotation->v_04->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $quotation->v_04->Lookup->getParamTag("p_x_v_04") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->v_05->Visible) { // v_05 ?>
	<div id="r_v_05" class="form-group row">
		<label class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_v_05"><?php echo $quotation->v_05->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_v_05" id="z_v_05" value="="></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->v_05->cellAttributes() ?>>
			<span id="el_quotation_v_05">
<div class="btn-group ew-dropdown-list" role="group">
	<div class="btn-group" role="group">
		<button type="button" class="btn form-control dropdown-toggle ew-dropdown-toggle" aria-haspopup="true" aria-expanded="false"<?php if ($quotation->v_05->ReadOnly) { ?> readonly<?php } else { ?>data-toggle="dropdown"<?php } ?>><?php echo $quotation->v_05->AdvancedSearch->ViewValue ?></button>
		<div id="dsl_x_v_05" data-repeatcolumn="3" class="dropdown-menu">
			<div class="ew-items" style="overflow-x: hidden;">
<?php echo $quotation->v_05->checkBoxListHtml(TRUE, "x_v_05[]") ?>
			</div><!-- /.ew-items ##-->
		</div><!-- /.dropdown-menu ##-->
		<div id="tp_x_v_05" class="ew-template"><input type="checkbox" class="form-check-input" data-table="quotation" data-field="x_v_05" data-value-separator="<?php echo $quotation->v_05->displayValueSeparatorAttribute() ?>" name="x_v_05[]" id="x_v_05[]" value="{value}"<?php echo $quotation->v_05->editAttributes() ?>></div>
	</div><!-- /.btn-group ##-->
	<?php if (!$quotation->v_05->ReadOnly) { ?>
	<button type="button" class="btn btn-default ew-dropdown-clear" disabled>
		<i class="fa fa-times ew-icon"></i>
	</button>
	<?php } ?>
<?php echo $quotation->v_05->Lookup->getParamTag("p_x_v_05") ?>
</div><!-- /.ew-dropdown-list ##-->
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->Amount->Visible) { // Amount ?>
	<div id="r_Amount" class="form-group row">
		<label for="x_Amount" class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_Amount"><?php echo $quotation->Amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_Amount" id="z_Amount" value="="></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->Amount->cellAttributes() ?>>
			<span id="el_quotation_Amount">
<input type="text" data-table="quotation" data-field="x_Amount" name="x_Amount" id="x_Amount" size="30" placeholder="<?php echo HtmlEncode($quotation->Amount->getPlaceHolder()) ?>" value="<?php echo $quotation->Amount->EditValue ?>"<?php echo $quotation->Amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($quotation->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $quotation_search->LeftColumnClass ?>"><span id="elh_quotation_packing_type"><?php echo $quotation->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="="></span>
		</label>
		<div class="<?php echo $quotation_search->RightColumnClass ?>"><div<?php echo $quotation->packing_type->cellAttributes() ?>>
			<span id="el_quotation_packing_type">
<input type="text" data-table="quotation" data-field="x_packing_type" name="x_packing_type" id="x_packing_type" size="30" placeholder="<?php echo HtmlEncode($quotation->packing_type->getPlaceHolder()) ?>" value="<?php echo $quotation->packing_type->EditValue ?>"<?php echo $quotation->packing_type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$quotation_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $quotation_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$quotation_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$quotation_search->terminate();
?>