<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$receipt_b_add = new receipt_b_add();

// Run the page
$receipt_b_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$receipt_b_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var freceipt_badd = currentForm = new ew.Form("freceipt_badd", "add");

// Validate form
freceipt_badd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($receipt_b_add->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt_b->location->caption(), $receipt_b->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_b_add->from_account->Required) { ?>
			elm = this.getElements("x" + infix + "_from_account");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt_b->from_account->caption(), $receipt_b->from_account->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_from_account");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($receipt_b->from_account->errorMessage()) ?>");
		<?php if ($receipt_b_add->to_account->Required) { ?>
			elm = this.getElements("x" + infix + "_to_account");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt_b->to_account->caption(), $receipt_b->to_account->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_to_account");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($receipt_b->to_account->errorMessage()) ?>");
		<?php if ($receipt_b_add->reference->Required) { ?>
			elm = this.getElements("x" + infix + "_reference");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt_b->reference->caption(), $receipt_b->reference->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_b_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt_b->dated->caption(), $receipt_b->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($receipt_b->dated->errorMessage()) ?>");
		<?php if ($receipt_b_add->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt_b->amount->caption(), $receipt_b->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($receipt_b->amount->errorMessage()) ?>");
		<?php if ($receipt_b_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt_b->remarks->caption(), $receipt_b->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_b_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt_b->operator->caption(), $receipt_b->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_b_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt_b->datetime->caption(), $receipt_b->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
freceipt_badd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
freceipt_badd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
freceipt_badd.lists["x_location"] = <?php echo $receipt_b_add->location->Lookup->toClientList() ?>;
freceipt_badd.lists["x_location"].options = <?php echo JsonEncode($receipt_b_add->location->lookupOptions()) ?>;
freceipt_badd.lists["x_from_account"] = <?php echo $receipt_b_add->from_account->Lookup->toClientList() ?>;
freceipt_badd.lists["x_from_account"].options = <?php echo JsonEncode($receipt_b_add->from_account->lookupOptions()) ?>;
freceipt_badd.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceipt_badd.lists["x_to_account"] = <?php echo $receipt_b_add->to_account->Lookup->toClientList() ?>;
freceipt_badd.lists["x_to_account"].options = <?php echo JsonEncode($receipt_b_add->to_account->lookupOptions()) ?>;
freceipt_badd.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceipt_badd.lists["x_operator"] = <?php echo $receipt_b_add->operator->Lookup->toClientList() ?>;
freceipt_badd.lists["x_operator"].options = <?php echo JsonEncode($receipt_b_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $receipt_b_add->showPageHeader(); ?>
<?php
$receipt_b_add->showMessage();
?>
<form name="freceipt_badd" id="freceipt_badd" class="<?php echo $receipt_b_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($receipt_b_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $receipt_b_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="receipt_b">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$receipt_b_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($receipt_b->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_receipt_b_location" for="x_location" class="<?php echo $receipt_b_add->LeftColumnClass ?>"><?php echo $receipt_b->location->caption() ?><?php echo ($receipt_b->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_b_add->RightColumnClass ?>"><div<?php echo $receipt_b->location->cellAttributes() ?>>
<span id="el_receipt_b_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="receipt_b" data-field="x_location" data-value-separator="<?php echo $receipt_b->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $receipt_b->location->editAttributes() ?>>
		<?php echo $receipt_b->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $receipt_b->location->Lookup->getParamTag("p_x_location") ?>
</span>
<?php echo $receipt_b->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt_b->from_account->Visible) { // from_account ?>
	<div id="r_from_account" class="form-group row">
		<label id="elh_receipt_b_from_account" class="<?php echo $receipt_b_add->LeftColumnClass ?>"><?php echo $receipt_b->from_account->caption() ?><?php echo ($receipt_b->from_account->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_b_add->RightColumnClass ?>"><div<?php echo $receipt_b->from_account->cellAttributes() ?>>
<span id="el_receipt_b_from_account">
<?php
$wrkonchange = "" . trim(@$receipt_b->from_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$receipt_b->from_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_from_account" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_from_account" id="sv_x_from_account" value="<?php echo RemoveHtml($receipt_b->from_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($receipt_b->from_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($receipt_b->from_account->getPlaceHolder()) ?>"<?php echo $receipt_b->from_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($receipt_b->from_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_from_account',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($receipt_b->from_account->ReadOnly || $receipt_b->from_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="receipt_b" data-field="x_from_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $receipt_b->from_account->displayValueSeparatorAttribute() ?>" name="x_from_account" id="x_from_account" value="<?php echo HtmlEncode($receipt_b->from_account->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
freceipt_badd.createAutoSuggest({"id":"x_from_account","forceSelect":true});
</script>
<?php echo $receipt_b->from_account->Lookup->getParamTag("p_x_from_account") ?>
</span>
<?php echo $receipt_b->from_account->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt_b->to_account->Visible) { // to_account ?>
	<div id="r_to_account" class="form-group row">
		<label id="elh_receipt_b_to_account" class="<?php echo $receipt_b_add->LeftColumnClass ?>"><?php echo $receipt_b->to_account->caption() ?><?php echo ($receipt_b->to_account->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_b_add->RightColumnClass ?>"><div<?php echo $receipt_b->to_account->cellAttributes() ?>>
<span id="el_receipt_b_to_account">
<?php
$wrkonchange = "" . trim(@$receipt_b->to_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$receipt_b->to_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_to_account" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_to_account" id="sv_x_to_account" value="<?php echo RemoveHtml($receipt_b->to_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($receipt_b->to_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($receipt_b->to_account->getPlaceHolder()) ?>"<?php echo $receipt_b->to_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($receipt_b->to_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_to_account',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($receipt_b->to_account->ReadOnly || $receipt_b->to_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="receipt_b" data-field="x_to_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $receipt_b->to_account->displayValueSeparatorAttribute() ?>" name="x_to_account" id="x_to_account" value="<?php echo HtmlEncode($receipt_b->to_account->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
freceipt_badd.createAutoSuggest({"id":"x_to_account","forceSelect":true});
</script>
<?php echo $receipt_b->to_account->Lookup->getParamTag("p_x_to_account") ?>
</span>
<?php echo $receipt_b->to_account->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt_b->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label id="elh_receipt_b_reference" for="x_reference" class="<?php echo $receipt_b_add->LeftColumnClass ?>"><?php echo $receipt_b->reference->caption() ?><?php echo ($receipt_b->reference->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_b_add->RightColumnClass ?>"><div<?php echo $receipt_b->reference->cellAttributes() ?>>
<span id="el_receipt_b_reference">
<input type="text" data-table="receipt_b" data-field="x_reference" name="x_reference" id="x_reference" size="30" placeholder="<?php echo HtmlEncode($receipt_b->reference->getPlaceHolder()) ?>" value="<?php echo $receipt_b->reference->EditValue ?>"<?php echo $receipt_b->reference->editAttributes() ?>>
</span>
<?php echo $receipt_b->reference->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt_b->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_receipt_b_dated" for="x_dated" class="<?php echo $receipt_b_add->LeftColumnClass ?>"><?php echo $receipt_b->dated->caption() ?><?php echo ($receipt_b->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_b_add->RightColumnClass ?>"><div<?php echo $receipt_b->dated->cellAttributes() ?>>
<span id="el_receipt_b_dated">
<input type="text" data-table="receipt_b" data-field="x_dated" data-format="2" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($receipt_b->dated->getPlaceHolder()) ?>" value="<?php echo $receipt_b->dated->EditValue ?>"<?php echo $receipt_b->dated->editAttributes() ?>>
<?php if (!$receipt_b->dated->ReadOnly && !$receipt_b->dated->Disabled && !isset($receipt_b->dated->EditAttrs["readonly"]) && !isset($receipt_b->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("freceipt_badd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
<?php echo $receipt_b->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt_b->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_receipt_b_amount" for="x_amount" class="<?php echo $receipt_b_add->LeftColumnClass ?>"><?php echo $receipt_b->amount->caption() ?><?php echo ($receipt_b->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_b_add->RightColumnClass ?>"><div<?php echo $receipt_b->amount->cellAttributes() ?>>
<span id="el_receipt_b_amount">
<input type="text" data-table="receipt_b" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($receipt_b->amount->getPlaceHolder()) ?>" value="<?php echo $receipt_b->amount->EditValue ?>"<?php echo $receipt_b->amount->editAttributes() ?>>
</span>
<?php echo $receipt_b->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt_b->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_receipt_b_remarks" for="x_remarks" class="<?php echo $receipt_b_add->LeftColumnClass ?>"><?php echo $receipt_b->remarks->caption() ?><?php echo ($receipt_b->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_b_add->RightColumnClass ?>"><div<?php echo $receipt_b->remarks->cellAttributes() ?>>
<span id="el_receipt_b_remarks">
<input type="text" data-table="receipt_b" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($receipt_b->remarks->getPlaceHolder()) ?>" value="<?php echo $receipt_b->remarks->EditValue ?>"<?php echo $receipt_b->remarks->editAttributes() ?>>
</span>
<?php echo $receipt_b->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$receipt_b_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $receipt_b_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $receipt_b_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$receipt_b_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$receipt_b_add->terminate();
?>