<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$receipt_b_delete = new receipt_b_delete();

// Run the page
$receipt_b_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$receipt_b_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var freceipt_bdelete = currentForm = new ew.Form("freceipt_bdelete", "delete");

// Form_CustomValidate event
freceipt_bdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
freceipt_bdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
freceipt_bdelete.lists["x_location"] = <?php echo $receipt_b_delete->location->Lookup->toClientList() ?>;
freceipt_bdelete.lists["x_location"].options = <?php echo JsonEncode($receipt_b_delete->location->lookupOptions()) ?>;
freceipt_bdelete.lists["x_from_account"] = <?php echo $receipt_b_delete->from_account->Lookup->toClientList() ?>;
freceipt_bdelete.lists["x_from_account"].options = <?php echo JsonEncode($receipt_b_delete->from_account->lookupOptions()) ?>;
freceipt_bdelete.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceipt_bdelete.lists["x_to_account"] = <?php echo $receipt_b_delete->to_account->Lookup->toClientList() ?>;
freceipt_bdelete.lists["x_to_account"].options = <?php echo JsonEncode($receipt_b_delete->to_account->lookupOptions()) ?>;
freceipt_bdelete.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceipt_bdelete.lists["x_operator"] = <?php echo $receipt_b_delete->operator->Lookup->toClientList() ?>;
freceipt_bdelete.lists["x_operator"].options = <?php echo JsonEncode($receipt_b_delete->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $receipt_b_delete->showPageHeader(); ?>
<?php
$receipt_b_delete->showMessage();
?>
<form name="freceipt_bdelete" id="freceipt_bdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($receipt_b_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $receipt_b_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="receipt_b">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($receipt_b_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($receipt_b->id->Visible) { // id ?>
		<th class="<?php echo $receipt_b->id->headerCellClass() ?>"><span id="elh_receipt_b_id" class="receipt_b_id"><?php echo $receipt_b->id->caption() ?></span></th>
<?php } ?>
<?php if ($receipt_b->location->Visible) { // location ?>
		<th class="<?php echo $receipt_b->location->headerCellClass() ?>"><span id="elh_receipt_b_location" class="receipt_b_location"><?php echo $receipt_b->location->caption() ?></span></th>
<?php } ?>
<?php if ($receipt_b->from_account->Visible) { // from_account ?>
		<th class="<?php echo $receipt_b->from_account->headerCellClass() ?>"><span id="elh_receipt_b_from_account" class="receipt_b_from_account"><?php echo $receipt_b->from_account->caption() ?></span></th>
<?php } ?>
<?php if ($receipt_b->to_account->Visible) { // to_account ?>
		<th class="<?php echo $receipt_b->to_account->headerCellClass() ?>"><span id="elh_receipt_b_to_account" class="receipt_b_to_account"><?php echo $receipt_b->to_account->caption() ?></span></th>
<?php } ?>
<?php if ($receipt_b->reference->Visible) { // reference ?>
		<th class="<?php echo $receipt_b->reference->headerCellClass() ?>"><span id="elh_receipt_b_reference" class="receipt_b_reference"><?php echo $receipt_b->reference->caption() ?></span></th>
<?php } ?>
<?php if ($receipt_b->dated->Visible) { // dated ?>
		<th class="<?php echo $receipt_b->dated->headerCellClass() ?>"><span id="elh_receipt_b_dated" class="receipt_b_dated"><?php echo $receipt_b->dated->caption() ?></span></th>
<?php } ?>
<?php if ($receipt_b->amount->Visible) { // amount ?>
		<th class="<?php echo $receipt_b->amount->headerCellClass() ?>"><span id="elh_receipt_b_amount" class="receipt_b_amount"><?php echo $receipt_b->amount->caption() ?></span></th>
<?php } ?>
<?php if ($receipt_b->remarks->Visible) { // remarks ?>
		<th class="<?php echo $receipt_b->remarks->headerCellClass() ?>"><span id="elh_receipt_b_remarks" class="receipt_b_remarks"><?php echo $receipt_b->remarks->caption() ?></span></th>
<?php } ?>
<?php if ($receipt_b->operator->Visible) { // operator ?>
		<th class="<?php echo $receipt_b->operator->headerCellClass() ?>"><span id="elh_receipt_b_operator" class="receipt_b_operator"><?php echo $receipt_b->operator->caption() ?></span></th>
<?php } ?>
<?php if ($receipt_b->datetime->Visible) { // datetime ?>
		<th class="<?php echo $receipt_b->datetime->headerCellClass() ?>"><span id="elh_receipt_b_datetime" class="receipt_b_datetime"><?php echo $receipt_b->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$receipt_b_delete->RecCnt = 0;
$i = 0;
while (!$receipt_b_delete->Recordset->EOF) {
	$receipt_b_delete->RecCnt++;
	$receipt_b_delete->RowCnt++;

	// Set row properties
	$receipt_b->resetAttributes();
	$receipt_b->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$receipt_b_delete->loadRowValues($receipt_b_delete->Recordset);

	// Render row
	$receipt_b_delete->renderRow();
?>
	<tr<?php echo $receipt_b->rowAttributes() ?>>
<?php if ($receipt_b->id->Visible) { // id ?>
		<td<?php echo $receipt_b->id->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_delete->RowCnt ?>_receipt_b_id" class="receipt_b_id">
<span<?php echo $receipt_b->id->viewAttributes() ?>>
<?php echo $receipt_b->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt_b->location->Visible) { // location ?>
		<td<?php echo $receipt_b->location->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_delete->RowCnt ?>_receipt_b_location" class="receipt_b_location">
<span<?php echo $receipt_b->location->viewAttributes() ?>>
<?php echo $receipt_b->location->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt_b->from_account->Visible) { // from_account ?>
		<td<?php echo $receipt_b->from_account->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_delete->RowCnt ?>_receipt_b_from_account" class="receipt_b_from_account">
<span<?php echo $receipt_b->from_account->viewAttributes() ?>>
<?php echo $receipt_b->from_account->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt_b->to_account->Visible) { // to_account ?>
		<td<?php echo $receipt_b->to_account->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_delete->RowCnt ?>_receipt_b_to_account" class="receipt_b_to_account">
<span<?php echo $receipt_b->to_account->viewAttributes() ?>>
<?php echo $receipt_b->to_account->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt_b->reference->Visible) { // reference ?>
		<td<?php echo $receipt_b->reference->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_delete->RowCnt ?>_receipt_b_reference" class="receipt_b_reference">
<span<?php echo $receipt_b->reference->viewAttributes() ?>>
<?php echo $receipt_b->reference->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt_b->dated->Visible) { // dated ?>
		<td<?php echo $receipt_b->dated->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_delete->RowCnt ?>_receipt_b_dated" class="receipt_b_dated">
<span<?php echo $receipt_b->dated->viewAttributes() ?>>
<?php echo $receipt_b->dated->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt_b->amount->Visible) { // amount ?>
		<td<?php echo $receipt_b->amount->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_delete->RowCnt ?>_receipt_b_amount" class="receipt_b_amount">
<span<?php echo $receipt_b->amount->viewAttributes() ?>>
<?php echo $receipt_b->amount->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt_b->remarks->Visible) { // remarks ?>
		<td<?php echo $receipt_b->remarks->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_delete->RowCnt ?>_receipt_b_remarks" class="receipt_b_remarks">
<span<?php echo $receipt_b->remarks->viewAttributes() ?>>
<?php echo $receipt_b->remarks->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt_b->operator->Visible) { // operator ?>
		<td<?php echo $receipt_b->operator->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_delete->RowCnt ?>_receipt_b_operator" class="receipt_b_operator">
<span<?php echo $receipt_b->operator->viewAttributes() ?>>
<?php echo $receipt_b->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($receipt_b->datetime->Visible) { // datetime ?>
		<td<?php echo $receipt_b->datetime->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_delete->RowCnt ?>_receipt_b_datetime" class="receipt_b_datetime">
<span<?php echo $receipt_b->datetime->viewAttributes() ?>>
<?php echo $receipt_b->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$receipt_b_delete->Recordset->moveNext();
}
$receipt_b_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $receipt_b_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$receipt_b_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$receipt_b_delete->terminate();
?>