<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$receipt_b_list = new receipt_b_list();

// Run the page
$receipt_b_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$receipt_b_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$receipt_b->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var freceipt_blist = currentForm = new ew.Form("freceipt_blist", "list");
freceipt_blist.formKeyCountName = '<?php echo $receipt_b_list->FormKeyCountName ?>';

// Form_CustomValidate event
freceipt_blist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
freceipt_blist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
freceipt_blist.lists["x_location"] = <?php echo $receipt_b_list->location->Lookup->toClientList() ?>;
freceipt_blist.lists["x_location"].options = <?php echo JsonEncode($receipt_b_list->location->lookupOptions()) ?>;
freceipt_blist.lists["x_from_account"] = <?php echo $receipt_b_list->from_account->Lookup->toClientList() ?>;
freceipt_blist.lists["x_from_account"].options = <?php echo JsonEncode($receipt_b_list->from_account->lookupOptions()) ?>;
freceipt_blist.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceipt_blist.lists["x_to_account"] = <?php echo $receipt_b_list->to_account->Lookup->toClientList() ?>;
freceipt_blist.lists["x_to_account"].options = <?php echo JsonEncode($receipt_b_list->to_account->lookupOptions()) ?>;
freceipt_blist.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceipt_blist.lists["x_operator"] = <?php echo $receipt_b_list->operator->Lookup->toClientList() ?>;
freceipt_blist.lists["x_operator"].options = <?php echo JsonEncode($receipt_b_list->operator->lookupOptions()) ?>;

// Form object for search
var freceipt_blistsrch = currentSearchForm = new ew.Form("freceipt_blistsrch");

// Validate function for search
freceipt_blistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_from_account");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt_b->from_account->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_to_account");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt_b->to_account->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt_b->dated->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
freceipt_blistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
freceipt_blistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
freceipt_blistsrch.lists["x_from_account"] = <?php echo $receipt_b_list->from_account->Lookup->toClientList() ?>;
freceipt_blistsrch.lists["x_from_account"].options = <?php echo JsonEncode($receipt_b_list->from_account->lookupOptions()) ?>;
freceipt_blistsrch.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceipt_blistsrch.lists["x_to_account"] = <?php echo $receipt_b_list->to_account->Lookup->toClientList() ?>;
freceipt_blistsrch.lists["x_to_account"].options = <?php echo JsonEncode($receipt_b_list->to_account->lookupOptions()) ?>;
freceipt_blistsrch.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
freceipt_blistsrch.filterList = <?php echo $receipt_b_list->getFilterList() ?>;

// Init search panel as collapsed
freceipt_blistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$receipt_b->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($receipt_b_list->TotalRecs > 0 && $receipt_b_list->ExportOptions->visible()) { ?>
<?php $receipt_b_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($receipt_b_list->ImportOptions->visible()) { ?>
<?php $receipt_b_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($receipt_b_list->SearchOptions->visible()) { ?>
<?php $receipt_b_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($receipt_b_list->FilterOptions->visible()) { ?>
<?php $receipt_b_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$receipt_b_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$receipt_b->isExport() && !$receipt_b->CurrentAction) { ?>
<form name="freceipt_blistsrch" id="freceipt_blistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($receipt_b_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="freceipt_blistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="receipt_b">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$receipt_b_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$receipt_b->RowType = ROWTYPE_SEARCH;

// Render row
$receipt_b->resetAttributes();
$receipt_b_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($receipt_b->from_account->Visible) { // from_account ?>
	<div id="xsc_from_account" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $receipt_b->from_account->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_from_account" id="z_from_account" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$receipt_b->from_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$receipt_b->from_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_from_account" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_from_account" id="sv_x_from_account" value="<?php echo RemoveHtml($receipt_b->from_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($receipt_b->from_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($receipt_b->from_account->getPlaceHolder()) ?>"<?php echo $receipt_b->from_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($receipt_b->from_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_from_account',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($receipt_b->from_account->ReadOnly || $receipt_b->from_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="receipt_b" data-field="x_from_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $receipt_b->from_account->displayValueSeparatorAttribute() ?>" name="x_from_account" id="x_from_account" value="<?php echo HtmlEncode($receipt_b->from_account->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
freceipt_blistsrch.createAutoSuggest({"id":"x_from_account","forceSelect":true});
</script>
<?php echo $receipt_b->from_account->Lookup->getParamTag("p_x_from_account") ?>
</span>
	</div>
<?php } ?>
<?php if ($receipt_b->to_account->Visible) { // to_account ?>
	<div id="xsc_to_account" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $receipt_b->to_account->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_to_account" id="z_to_account" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$receipt_b->to_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$receipt_b->to_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_to_account" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_to_account" id="sv_x_to_account" value="<?php echo RemoveHtml($receipt_b->to_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($receipt_b->to_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($receipt_b->to_account->getPlaceHolder()) ?>"<?php echo $receipt_b->to_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($receipt_b->to_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_to_account',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($receipt_b->to_account->ReadOnly || $receipt_b->to_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="receipt_b" data-field="x_to_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $receipt_b->to_account->displayValueSeparatorAttribute() ?>" name="x_to_account" id="x_to_account" value="<?php echo HtmlEncode($receipt_b->to_account->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
freceipt_blistsrch.createAutoSuggest({"id":"x_to_account","forceSelect":true});
</script>
<?php echo $receipt_b->to_account->Lookup->getParamTag("p_x_to_account") ?>
</span>
	</div>
<?php } ?>
<?php if ($receipt_b->dated->Visible) { // dated ?>
	<div id="xsc_dated" class="ew-cell form-group">
		<label for="x_dated" class="ew-search-caption ew-label"><?php echo $receipt_b->dated->caption() ?></label>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="receipt_b" data-field="x_dated" data-format="2" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($receipt_b->dated->getPlaceHolder()) ?>" value="<?php echo $receipt_b->dated->EditValue ?>"<?php echo $receipt_b->dated->editAttributes() ?>>
<?php if (!$receipt_b->dated->ReadOnly && !$receipt_b->dated->Disabled && !isset($receipt_b->dated->EditAttrs["readonly"]) && !isset($receipt_b->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("freceipt_blistsrch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_dated style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_dated style="d-none"">
<input type="text" data-table="receipt_b" data-field="x_dated" data-format="2" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($receipt_b->dated->getPlaceHolder()) ?>" value="<?php echo $receipt_b->dated->EditValue2 ?>"<?php echo $receipt_b->dated->editAttributes() ?>>
<?php if (!$receipt_b->dated->ReadOnly && !$receipt_b->dated->Disabled && !isset($receipt_b->dated->EditAttrs["readonly"]) && !isset($receipt_b->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("freceipt_blistsrch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($receipt_b_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($receipt_b_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $receipt_b_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($receipt_b_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($receipt_b_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($receipt_b_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($receipt_b_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $receipt_b_list->showPageHeader(); ?>
<?php
$receipt_b_list->showMessage();
?>
<?php if ($receipt_b_list->TotalRecs > 0 || $receipt_b->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($receipt_b_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> receipt_b">
<?php if (!$receipt_b->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$receipt_b->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($receipt_b_list->Pager)) $receipt_b_list->Pager = new PrevNextPager($receipt_b_list->StartRec, $receipt_b_list->DisplayRecs, $receipt_b_list->TotalRecs, $receipt_b_list->AutoHidePager) ?>
<?php if ($receipt_b_list->Pager->RecordCount > 0 && $receipt_b_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($receipt_b_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $receipt_b_list->pageUrl() ?>start=<?php echo $receipt_b_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($receipt_b_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $receipt_b_list->pageUrl() ?>start=<?php echo $receipt_b_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $receipt_b_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($receipt_b_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $receipt_b_list->pageUrl() ?>start=<?php echo $receipt_b_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($receipt_b_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $receipt_b_list->pageUrl() ?>start=<?php echo $receipt_b_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $receipt_b_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($receipt_b_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $receipt_b_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $receipt_b_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $receipt_b_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($receipt_b_list->TotalRecs > 0 && (!$receipt_b_list->AutoHidePageSizeSelector || $receipt_b_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="receipt_b">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($receipt_b_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($receipt_b_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($receipt_b_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($receipt_b_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($receipt_b_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($receipt_b->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $receipt_b_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="freceipt_blist" id="freceipt_blist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($receipt_b_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $receipt_b_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="receipt_b">
<div id="gmp_receipt_b" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($receipt_b_list->TotalRecs > 0 || $receipt_b->isGridEdit()) { ?>
<table id="tbl_receipt_blist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$receipt_b_list->RowType = ROWTYPE_HEADER;

// Render list options
$receipt_b_list->renderListOptions();

// Render list options (header, left)
$receipt_b_list->ListOptions->render("header", "left");
?>
<?php if ($receipt_b->id->Visible) { // id ?>
	<?php if ($receipt_b->sortUrl($receipt_b->id) == "") { ?>
		<th data-name="id" class="<?php echo $receipt_b->id->headerCellClass() ?>"><div id="elh_receipt_b_id" class="receipt_b_id"><div class="ew-table-header-caption"><?php echo $receipt_b->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $receipt_b->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt_b->SortUrl($receipt_b->id) ?>',2);"><div id="elh_receipt_b_id" class="receipt_b_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt_b->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt_b->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt_b->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt_b->location->Visible) { // location ?>
	<?php if ($receipt_b->sortUrl($receipt_b->location) == "") { ?>
		<th data-name="location" class="<?php echo $receipt_b->location->headerCellClass() ?>"><div id="elh_receipt_b_location" class="receipt_b_location"><div class="ew-table-header-caption"><?php echo $receipt_b->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $receipt_b->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt_b->SortUrl($receipt_b->location) ?>',2);"><div id="elh_receipt_b_location" class="receipt_b_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt_b->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($receipt_b->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt_b->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt_b->from_account->Visible) { // from_account ?>
	<?php if ($receipt_b->sortUrl($receipt_b->from_account) == "") { ?>
		<th data-name="from_account" class="<?php echo $receipt_b->from_account->headerCellClass() ?>"><div id="elh_receipt_b_from_account" class="receipt_b_from_account"><div class="ew-table-header-caption"><?php echo $receipt_b->from_account->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="from_account" class="<?php echo $receipt_b->from_account->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt_b->SortUrl($receipt_b->from_account) ?>',2);"><div id="elh_receipt_b_from_account" class="receipt_b_from_account">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt_b->from_account->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt_b->from_account->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt_b->from_account->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt_b->to_account->Visible) { // to_account ?>
	<?php if ($receipt_b->sortUrl($receipt_b->to_account) == "") { ?>
		<th data-name="to_account" class="<?php echo $receipt_b->to_account->headerCellClass() ?>"><div id="elh_receipt_b_to_account" class="receipt_b_to_account"><div class="ew-table-header-caption"><?php echo $receipt_b->to_account->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="to_account" class="<?php echo $receipt_b->to_account->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt_b->SortUrl($receipt_b->to_account) ?>',2);"><div id="elh_receipt_b_to_account" class="receipt_b_to_account">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt_b->to_account->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt_b->to_account->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt_b->to_account->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt_b->reference->Visible) { // reference ?>
	<?php if ($receipt_b->sortUrl($receipt_b->reference) == "") { ?>
		<th data-name="reference" class="<?php echo $receipt_b->reference->headerCellClass() ?>"><div id="elh_receipt_b_reference" class="receipt_b_reference"><div class="ew-table-header-caption"><?php echo $receipt_b->reference->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reference" class="<?php echo $receipt_b->reference->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt_b->SortUrl($receipt_b->reference) ?>',2);"><div id="elh_receipt_b_reference" class="receipt_b_reference">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt_b->reference->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt_b->reference->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt_b->reference->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt_b->dated->Visible) { // dated ?>
	<?php if ($receipt_b->sortUrl($receipt_b->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $receipt_b->dated->headerCellClass() ?>"><div id="elh_receipt_b_dated" class="receipt_b_dated"><div class="ew-table-header-caption"><?php echo $receipt_b->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $receipt_b->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt_b->SortUrl($receipt_b->dated) ?>',2);"><div id="elh_receipt_b_dated" class="receipt_b_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt_b->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt_b->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt_b->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt_b->amount->Visible) { // amount ?>
	<?php if ($receipt_b->sortUrl($receipt_b->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $receipt_b->amount->headerCellClass() ?>"><div id="elh_receipt_b_amount" class="receipt_b_amount"><div class="ew-table-header-caption"><?php echo $receipt_b->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $receipt_b->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt_b->SortUrl($receipt_b->amount) ?>',2);"><div id="elh_receipt_b_amount" class="receipt_b_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt_b->amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt_b->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt_b->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt_b->remarks->Visible) { // remarks ?>
	<?php if ($receipt_b->sortUrl($receipt_b->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $receipt_b->remarks->headerCellClass() ?>"><div id="elh_receipt_b_remarks" class="receipt_b_remarks"><div class="ew-table-header-caption"><?php echo $receipt_b->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $receipt_b->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt_b->SortUrl($receipt_b->remarks) ?>',2);"><div id="elh_receipt_b_remarks" class="receipt_b_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt_b->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt_b->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt_b->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt_b->operator->Visible) { // operator ?>
	<?php if ($receipt_b->sortUrl($receipt_b->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $receipt_b->operator->headerCellClass() ?>"><div id="elh_receipt_b_operator" class="receipt_b_operator"><div class="ew-table-header-caption"><?php echo $receipt_b->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $receipt_b->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt_b->SortUrl($receipt_b->operator) ?>',2);"><div id="elh_receipt_b_operator" class="receipt_b_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt_b->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($receipt_b->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt_b->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($receipt_b->datetime->Visible) { // datetime ?>
	<?php if ($receipt_b->sortUrl($receipt_b->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $receipt_b->datetime->headerCellClass() ?>"><div id="elh_receipt_b_datetime" class="receipt_b_datetime"><div class="ew-table-header-caption"><?php echo $receipt_b->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $receipt_b->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $receipt_b->SortUrl($receipt_b->datetime) ?>',2);"><div id="elh_receipt_b_datetime" class="receipt_b_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $receipt_b->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($receipt_b->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($receipt_b->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$receipt_b_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($receipt_b->ExportAll && $receipt_b->isExport()) {
	$receipt_b_list->StopRec = $receipt_b_list->TotalRecs;
} else {

	// Set the last record to display
	if ($receipt_b_list->TotalRecs > $receipt_b_list->StartRec + $receipt_b_list->DisplayRecs - 1)
		$receipt_b_list->StopRec = $receipt_b_list->StartRec + $receipt_b_list->DisplayRecs - 1;
	else
		$receipt_b_list->StopRec = $receipt_b_list->TotalRecs;
}
$receipt_b_list->RecCnt = $receipt_b_list->StartRec - 1;
if ($receipt_b_list->Recordset && !$receipt_b_list->Recordset->EOF) {
	$receipt_b_list->Recordset->moveFirst();
	$selectLimit = $receipt_b_list->UseSelectLimit;
	if (!$selectLimit && $receipt_b_list->StartRec > 1)
		$receipt_b_list->Recordset->move($receipt_b_list->StartRec - 1);
} elseif (!$receipt_b->AllowAddDeleteRow && $receipt_b_list->StopRec == 0) {
	$receipt_b_list->StopRec = $receipt_b->GridAddRowCount;
}

// Initialize aggregate
$receipt_b->RowType = ROWTYPE_AGGREGATEINIT;
$receipt_b->resetAttributes();
$receipt_b_list->renderRow();
while ($receipt_b_list->RecCnt < $receipt_b_list->StopRec) {
	$receipt_b_list->RecCnt++;
	if ($receipt_b_list->RecCnt >= $receipt_b_list->StartRec) {
		$receipt_b_list->RowCnt++;

		// Set up key count
		$receipt_b_list->KeyCount = $receipt_b_list->RowIndex;

		// Init row class and style
		$receipt_b->resetAttributes();
		$receipt_b->CssClass = "";
		if ($receipt_b->isGridAdd()) {
		} else {
			$receipt_b_list->loadRowValues($receipt_b_list->Recordset); // Load row values
		}
		$receipt_b->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$receipt_b->RowAttrs = array_merge($receipt_b->RowAttrs, array('data-rowindex'=>$receipt_b_list->RowCnt, 'id'=>'r' . $receipt_b_list->RowCnt . '_receipt_b', 'data-rowtype'=>$receipt_b->RowType));

		// Render row
		$receipt_b_list->renderRow();

		// Render list options
		$receipt_b_list->renderListOptions();
?>
	<tr<?php echo $receipt_b->rowAttributes() ?>>
<?php

// Render list options (body, left)
$receipt_b_list->ListOptions->render("body", "left", $receipt_b_list->RowCnt);
?>
	<?php if ($receipt_b->id->Visible) { // id ?>
		<td data-name="id"<?php echo $receipt_b->id->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_list->RowCnt ?>_receipt_b_id" class="receipt_b_id">
<span<?php echo $receipt_b->id->viewAttributes() ?>>
<?php echo $receipt_b->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt_b->location->Visible) { // location ?>
		<td data-name="location"<?php echo $receipt_b->location->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_list->RowCnt ?>_receipt_b_location" class="receipt_b_location">
<span<?php echo $receipt_b->location->viewAttributes() ?>>
<?php echo $receipt_b->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt_b->from_account->Visible) { // from_account ?>
		<td data-name="from_account"<?php echo $receipt_b->from_account->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_list->RowCnt ?>_receipt_b_from_account" class="receipt_b_from_account">
<span<?php echo $receipt_b->from_account->viewAttributes() ?>>
<?php echo $receipt_b->from_account->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt_b->to_account->Visible) { // to_account ?>
		<td data-name="to_account"<?php echo $receipt_b->to_account->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_list->RowCnt ?>_receipt_b_to_account" class="receipt_b_to_account">
<span<?php echo $receipt_b->to_account->viewAttributes() ?>>
<?php echo $receipt_b->to_account->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt_b->reference->Visible) { // reference ?>
		<td data-name="reference"<?php echo $receipt_b->reference->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_list->RowCnt ?>_receipt_b_reference" class="receipt_b_reference">
<span<?php echo $receipt_b->reference->viewAttributes() ?>>
<?php echo $receipt_b->reference->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt_b->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $receipt_b->dated->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_list->RowCnt ?>_receipt_b_dated" class="receipt_b_dated">
<span<?php echo $receipt_b->dated->viewAttributes() ?>>
<?php echo $receipt_b->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt_b->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $receipt_b->amount->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_list->RowCnt ?>_receipt_b_amount" class="receipt_b_amount">
<span<?php echo $receipt_b->amount->viewAttributes() ?>>
<?php echo $receipt_b->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt_b->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $receipt_b->remarks->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_list->RowCnt ?>_receipt_b_remarks" class="receipt_b_remarks">
<span<?php echo $receipt_b->remarks->viewAttributes() ?>>
<?php echo $receipt_b->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt_b->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $receipt_b->operator->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_list->RowCnt ?>_receipt_b_operator" class="receipt_b_operator">
<span<?php echo $receipt_b->operator->viewAttributes() ?>>
<?php echo $receipt_b->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($receipt_b->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $receipt_b->datetime->cellAttributes() ?>>
<span id="el<?php echo $receipt_b_list->RowCnt ?>_receipt_b_datetime" class="receipt_b_datetime">
<span<?php echo $receipt_b->datetime->viewAttributes() ?>>
<?php echo $receipt_b->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$receipt_b_list->ListOptions->render("body", "right", $receipt_b_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$receipt_b->isGridAdd())
		$receipt_b_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$receipt_b->RowType = ROWTYPE_AGGREGATE;
$receipt_b->resetAttributes();
$receipt_b_list->renderRow();
?>
<?php if ($receipt_b_list->TotalRecs > 0 && !$receipt_b->isGridAdd() && !$receipt_b->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$receipt_b_list->renderListOptions();

// Render list options (footer, left)
$receipt_b_list->ListOptions->render("footer", "left");
?>
	<?php if ($receipt_b->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $receipt_b->id->footerCellClass() ?>"><span id="elf_receipt_b_id" class="receipt_b_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt_b->location->Visible) { // location ?>
		<td data-name="location" class="<?php echo $receipt_b->location->footerCellClass() ?>"><span id="elf_receipt_b_location" class="receipt_b_location">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt_b->from_account->Visible) { // from_account ?>
		<td data-name="from_account" class="<?php echo $receipt_b->from_account->footerCellClass() ?>"><span id="elf_receipt_b_from_account" class="receipt_b_from_account">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt_b->to_account->Visible) { // to_account ?>
		<td data-name="to_account" class="<?php echo $receipt_b->to_account->footerCellClass() ?>"><span id="elf_receipt_b_to_account" class="receipt_b_to_account">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt_b->reference->Visible) { // reference ?>
		<td data-name="reference" class="<?php echo $receipt_b->reference->footerCellClass() ?>"><span id="elf_receipt_b_reference" class="receipt_b_reference">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt_b->dated->Visible) { // dated ?>
		<td data-name="dated" class="<?php echo $receipt_b->dated->footerCellClass() ?>"><span id="elf_receipt_b_dated" class="receipt_b_dated">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt_b->amount->Visible) { // amount ?>
		<td data-name="amount" class="<?php echo $receipt_b->amount->footerCellClass() ?>"><span id="elf_receipt_b_amount" class="receipt_b_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $receipt_b->amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($receipt_b->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $receipt_b->remarks->footerCellClass() ?>"><span id="elf_receipt_b_remarks" class="receipt_b_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt_b->operator->Visible) { // operator ?>
		<td data-name="operator" class="<?php echo $receipt_b->operator->footerCellClass() ?>"><span id="elf_receipt_b_operator" class="receipt_b_operator">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($receipt_b->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $receipt_b->datetime->footerCellClass() ?>"><span id="elf_receipt_b_datetime" class="receipt_b_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$receipt_b_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$receipt_b->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($receipt_b_list->Recordset)
	$receipt_b_list->Recordset->Close();
?>
<?php if (!$receipt_b->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$receipt_b->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($receipt_b_list->Pager)) $receipt_b_list->Pager = new PrevNextPager($receipt_b_list->StartRec, $receipt_b_list->DisplayRecs, $receipt_b_list->TotalRecs, $receipt_b_list->AutoHidePager) ?>
<?php if ($receipt_b_list->Pager->RecordCount > 0 && $receipt_b_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($receipt_b_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $receipt_b_list->pageUrl() ?>start=<?php echo $receipt_b_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($receipt_b_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $receipt_b_list->pageUrl() ?>start=<?php echo $receipt_b_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $receipt_b_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($receipt_b_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $receipt_b_list->pageUrl() ?>start=<?php echo $receipt_b_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($receipt_b_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $receipt_b_list->pageUrl() ?>start=<?php echo $receipt_b_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $receipt_b_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($receipt_b_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $receipt_b_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $receipt_b_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $receipt_b_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($receipt_b_list->TotalRecs > 0 && (!$receipt_b_list->AutoHidePageSizeSelector || $receipt_b_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="receipt_b">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($receipt_b_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($receipt_b_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($receipt_b_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($receipt_b_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($receipt_b_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($receipt_b->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $receipt_b_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($receipt_b_list->TotalRecs == 0 && !$receipt_b->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $receipt_b_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$receipt_b_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$receipt_b->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$receipt_b->isExport()) { ?>
<script>
ew.scrollableTable("gmp_receipt_b", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$receipt_b_list->terminate();
?>