<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$receipt_b_search = new receipt_b_search();

// Run the page
$receipt_b_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$receipt_b_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($receipt_b_search->IsModal) { ?>
var freceipt_bsearch = currentAdvancedSearchForm = new ew.Form("freceipt_bsearch", "search");
<?php } else { ?>
var freceipt_bsearch = currentForm = new ew.Form("freceipt_bsearch", "search");
<?php } ?>

// Form_CustomValidate event
freceipt_bsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
freceipt_bsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
freceipt_bsearch.lists["x_location"] = <?php echo $receipt_b_search->location->Lookup->toClientList() ?>;
freceipt_bsearch.lists["x_location"].options = <?php echo JsonEncode($receipt_b_search->location->lookupOptions()) ?>;
freceipt_bsearch.lists["x_from_account"] = <?php echo $receipt_b_search->from_account->Lookup->toClientList() ?>;
freceipt_bsearch.lists["x_from_account"].options = <?php echo JsonEncode($receipt_b_search->from_account->lookupOptions()) ?>;
freceipt_bsearch.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceipt_bsearch.lists["x_to_account"] = <?php echo $receipt_b_search->to_account->Lookup->toClientList() ?>;
freceipt_bsearch.lists["x_to_account"].options = <?php echo JsonEncode($receipt_b_search->to_account->lookupOptions()) ?>;
freceipt_bsearch.autoSuggests["x_to_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceipt_bsearch.lists["x_operator"] = <?php echo $receipt_b_search->operator->Lookup->toClientList() ?>;
freceipt_bsearch.lists["x_operator"].options = <?php echo JsonEncode($receipt_b_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

freceipt_bsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt_b->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_from_account");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt_b->from_account->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_to_account");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt_b->to_account->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dated");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt_b->dated->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt_b->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($receipt_b->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $receipt_b_search->showPageHeader(); ?>
<?php
$receipt_b_search->showMessage();
?>
<form name="freceipt_bsearch" id="freceipt_bsearch" class="<?php echo $receipt_b_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($receipt_b_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $receipt_b_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="receipt_b">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$receipt_b_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($receipt_b->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $receipt_b_search->LeftColumnClass ?>"><span id="elh_receipt_b_id"><?php echo $receipt_b->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $receipt_b_search->RightColumnClass ?>"><div<?php echo $receipt_b->id->cellAttributes() ?>>
			<span id="el_receipt_b_id">
<input type="text" data-table="receipt_b" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($receipt_b->id->getPlaceHolder()) ?>" value="<?php echo $receipt_b->id->EditValue ?>"<?php echo $receipt_b->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt_b->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label for="x_location" class="<?php echo $receipt_b_search->LeftColumnClass ?>"><span id="elh_receipt_b_location"><?php echo $receipt_b->location->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		</label>
		<div class="<?php echo $receipt_b_search->RightColumnClass ?>"><div<?php echo $receipt_b->location->cellAttributes() ?>>
			<span id="el_receipt_b_location">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="receipt_b" data-field="x_location" data-value-separator="<?php echo $receipt_b->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $receipt_b->location->editAttributes() ?>>
		<?php echo $receipt_b->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $receipt_b->location->Lookup->getParamTag("p_x_location") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt_b->from_account->Visible) { // from_account ?>
	<div id="r_from_account" class="form-group row">
		<label class="<?php echo $receipt_b_search->LeftColumnClass ?>"><span id="elh_receipt_b_from_account"><?php echo $receipt_b->from_account->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_from_account" id="z_from_account" value="="></span>
		</label>
		<div class="<?php echo $receipt_b_search->RightColumnClass ?>"><div<?php echo $receipt_b->from_account->cellAttributes() ?>>
			<span id="el_receipt_b_from_account">
<?php
$wrkonchange = "" . trim(@$receipt_b->from_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$receipt_b->from_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_from_account" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_from_account" id="sv_x_from_account" value="<?php echo RemoveHtml($receipt_b->from_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($receipt_b->from_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($receipt_b->from_account->getPlaceHolder()) ?>"<?php echo $receipt_b->from_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($receipt_b->from_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_from_account',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($receipt_b->from_account->ReadOnly || $receipt_b->from_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="receipt_b" data-field="x_from_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $receipt_b->from_account->displayValueSeparatorAttribute() ?>" name="x_from_account" id="x_from_account" value="<?php echo HtmlEncode($receipt_b->from_account->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
freceipt_bsearch.createAutoSuggest({"id":"x_from_account","forceSelect":true});
</script>
<?php echo $receipt_b->from_account->Lookup->getParamTag("p_x_from_account") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt_b->to_account->Visible) { // to_account ?>
	<div id="r_to_account" class="form-group row">
		<label class="<?php echo $receipt_b_search->LeftColumnClass ?>"><span id="elh_receipt_b_to_account"><?php echo $receipt_b->to_account->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_to_account" id="z_to_account" value="="></span>
		</label>
		<div class="<?php echo $receipt_b_search->RightColumnClass ?>"><div<?php echo $receipt_b->to_account->cellAttributes() ?>>
			<span id="el_receipt_b_to_account">
<?php
$wrkonchange = "" . trim(@$receipt_b->to_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$receipt_b->to_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_to_account" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_to_account" id="sv_x_to_account" value="<?php echo RemoveHtml($receipt_b->to_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($receipt_b->to_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($receipt_b->to_account->getPlaceHolder()) ?>"<?php echo $receipt_b->to_account->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($receipt_b->to_account->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_to_account',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($receipt_b->to_account->ReadOnly || $receipt_b->to_account->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="receipt_b" data-field="x_to_account" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $receipt_b->to_account->displayValueSeparatorAttribute() ?>" name="x_to_account" id="x_to_account" value="<?php echo HtmlEncode($receipt_b->to_account->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
freceipt_bsearch.createAutoSuggest({"id":"x_to_account","forceSelect":true});
</script>
<?php echo $receipt_b->to_account->Lookup->getParamTag("p_x_to_account") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt_b->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label for="x_reference" class="<?php echo $receipt_b_search->LeftColumnClass ?>"><span id="elh_receipt_b_reference"><?php echo $receipt_b->reference->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reference" id="z_reference" value="="></span>
		</label>
		<div class="<?php echo $receipt_b_search->RightColumnClass ?>"><div<?php echo $receipt_b->reference->cellAttributes() ?>>
			<span id="el_receipt_b_reference">
<input type="text" data-table="receipt_b" data-field="x_reference" name="x_reference" id="x_reference" size="30" placeholder="<?php echo HtmlEncode($receipt_b->reference->getPlaceHolder()) ?>" value="<?php echo $receipt_b->reference->EditValue ?>"<?php echo $receipt_b->reference->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt_b->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label for="x_dated" class="<?php echo $receipt_b_search->LeftColumnClass ?>"><span id="elh_receipt_b_dated"><?php echo $receipt_b->dated->caption() ?></span>
		</label>
		<div class="<?php echo $receipt_b_search->RightColumnClass ?>"><div<?php echo $receipt_b->dated->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_dated" id="z_dated" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($receipt_b->dated->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_receipt_b_dated">
<input type="text" data-table="receipt_b" data-field="x_dated" data-format="2" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($receipt_b->dated->getPlaceHolder()) ?>" value="<?php echo $receipt_b->dated->EditValue ?>"<?php echo $receipt_b->dated->editAttributes() ?>>
<?php if (!$receipt_b->dated->ReadOnly && !$receipt_b->dated->Disabled && !isset($receipt_b->dated->EditAttrs["readonly"]) && !isset($receipt_b->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("freceipt_bsearch", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_dated d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_receipt_b_dated" class="btw1_dated d-none">
<input type="text" data-table="receipt_b" data-field="x_dated" data-format="2" name="y_dated" id="y_dated" placeholder="<?php echo HtmlEncode($receipt_b->dated->getPlaceHolder()) ?>" value="<?php echo $receipt_b->dated->EditValue2 ?>"<?php echo $receipt_b->dated->editAttributes() ?>>
<?php if (!$receipt_b->dated->ReadOnly && !$receipt_b->dated->Disabled && !isset($receipt_b->dated->EditAttrs["readonly"]) && !isset($receipt_b->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("freceipt_bsearch", "y_dated", {"ignoreReadonly":true,"useCurrent":false,"format":2});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt_b->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $receipt_b_search->LeftColumnClass ?>"><span id="elh_receipt_b_amount"><?php echo $receipt_b->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $receipt_b_search->RightColumnClass ?>"><div<?php echo $receipt_b->amount->cellAttributes() ?>>
			<span id="el_receipt_b_amount">
<input type="text" data-table="receipt_b" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($receipt_b->amount->getPlaceHolder()) ?>" value="<?php echo $receipt_b->amount->EditValue ?>"<?php echo $receipt_b->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt_b->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $receipt_b_search->LeftColumnClass ?>"><span id="elh_receipt_b_remarks"><?php echo $receipt_b->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $receipt_b_search->RightColumnClass ?>"><div<?php echo $receipt_b->remarks->cellAttributes() ?>>
			<span id="el_receipt_b_remarks">
<input type="text" data-table="receipt_b" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($receipt_b->remarks->getPlaceHolder()) ?>" value="<?php echo $receipt_b->remarks->EditValue ?>"<?php echo $receipt_b->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt_b->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $receipt_b_search->LeftColumnClass ?>"><span id="elh_receipt_b_operator"><?php echo $receipt_b->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $receipt_b_search->RightColumnClass ?>"><div<?php echo $receipt_b->operator->cellAttributes() ?>>
			<span id="el_receipt_b_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="receipt_b" data-field="x_operator" data-value-separator="<?php echo $receipt_b->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $receipt_b->operator->editAttributes() ?>>
		<?php echo $receipt_b->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $receipt_b->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($receipt_b->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $receipt_b_search->LeftColumnClass ?>"><span id="elh_receipt_b_datetime"><?php echo $receipt_b->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $receipt_b_search->RightColumnClass ?>"><div<?php echo $receipt_b->datetime->cellAttributes() ?>>
			<span id="el_receipt_b_datetime">
<input type="text" data-table="receipt_b" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($receipt_b->datetime->getPlaceHolder()) ?>" value="<?php echo $receipt_b->datetime->EditValue ?>"<?php echo $receipt_b->datetime->editAttributes() ?>>
<?php if (!$receipt_b->datetime->ReadOnly && !$receipt_b->datetime->Disabled && !isset($receipt_b->datetime->EditAttrs["readonly"]) && !isset($receipt_b->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("freceipt_bsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$receipt_b_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $receipt_b_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$receipt_b_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$receipt_b_search->terminate();
?>