<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$receipt_add = new receipt_add();

// Run the page
$receipt_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$receipt_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var freceiptadd = currentForm = new ew.Form("freceiptadd", "add");

// Validate form
freceiptadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($receipt_add->location->Required) { ?>
			elm = this.getElements("x" + infix + "_location");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->location->caption(), $receipt->location->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_add->dated->Required) { ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->dated->caption(), $receipt->dated->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dated");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($receipt->dated->errorMessage()) ?>");
		<?php if ($receipt_add->from_account->Required) { ?>
			elm = this.getElements("x" + infix + "_from_account");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->from_account->caption(), $receipt->from_account->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_from_account");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($receipt->from_account->errorMessage()) ?>");
		<?php if ($receipt_add->reference->Required) { ?>
			elm = this.getElements("x" + infix + "_reference");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->reference->caption(), $receipt->reference->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_add->total_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->total_amount->caption(), $receipt->total_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($receipt->total_amount->errorMessage()) ?>");
		<?php if ($receipt_add->panel_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_panel_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->panel_amount->caption(), $receipt->panel_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_panel_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($receipt->panel_amount->errorMessage()) ?>");
		<?php if ($receipt_add->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->amount->caption(), $receipt->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($receipt->amount->errorMessage()) ?>");
		<?php if ($receipt_add->balance->Required) { ?>
			elm = this.getElements("x" + infix + "_balance");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->balance->caption(), $receipt->balance->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_balance");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($receipt->balance->errorMessage()) ?>");
		<?php if ($receipt_add->to_account->Required) { ?>
			elm = this.getElements("x" + infix + "_to_account");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->to_account->caption(), $receipt->to_account->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->remarks->caption(), $receipt->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->operator->caption(), $receipt->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($receipt_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $receipt->datetime->caption(), $receipt->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
freceiptadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
freceiptadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
freceiptadd.lists["x_location"] = <?php echo $receipt_add->location->Lookup->toClientList() ?>;
freceiptadd.lists["x_location"].options = <?php echo JsonEncode($receipt_add->location->lookupOptions()) ?>;
freceiptadd.lists["x_from_account"] = <?php echo $receipt_add->from_account->Lookup->toClientList() ?>;
freceiptadd.lists["x_from_account"].options = <?php echo JsonEncode($receipt_add->from_account->lookupOptions()) ?>;
freceiptadd.autoSuggests["x_from_account"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
freceiptadd.lists["x_reference"] = <?php echo $receipt_add->reference->Lookup->toClientList() ?>;
freceiptadd.lists["x_reference"].options = <?php echo JsonEncode($receipt_add->reference->lookupOptions()) ?>;
freceiptadd.lists["x_to_account"] = <?php echo $receipt_add->to_account->Lookup->toClientList() ?>;
freceiptadd.lists["x_to_account"].options = <?php echo JsonEncode($receipt_add->to_account->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $receipt_add->showPageHeader(); ?>
<?php
$receipt_add->showMessage();
?>
<form name="freceiptadd" id="freceiptadd" class="<?php echo $receipt_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($receipt_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $receipt_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="receipt">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$receipt_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($receipt->location->Visible) { // location ?>
	<div id="r_location" class="form-group row">
		<label id="elh_receipt_location" for="x_location" class="<?php echo $receipt_add->LeftColumnClass ?>"><?php echo $receipt->location->caption() ?><?php echo ($receipt->location->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_add->RightColumnClass ?>"><div<?php echo $receipt->location->cellAttributes() ?>>
<span id="el_receipt_location">
<?php $receipt->location->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$receipt->location->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="receipt" data-field="x_location" data-value-separator="<?php echo $receipt->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $receipt->location->editAttributes() ?>>
		<?php echo $receipt->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $receipt->location->Lookup->getParamTag("p_x_location") ?>
</span>
<?php echo $receipt->location->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->dated->Visible) { // dated ?>
	<div id="r_dated" class="form-group row">
		<label id="elh_receipt_dated" for="x_dated" class="<?php echo $receipt_add->LeftColumnClass ?>"><?php echo $receipt->dated->caption() ?><?php echo ($receipt->dated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_add->RightColumnClass ?>"><div<?php echo $receipt->dated->cellAttributes() ?>>
<span id="el_receipt_dated">
<input type="text" data-table="receipt" data-field="x_dated" name="x_dated" id="x_dated" placeholder="<?php echo HtmlEncode($receipt->dated->getPlaceHolder()) ?>" value="<?php echo $receipt->dated->EditValue ?>"<?php echo $receipt->dated->editAttributes() ?>>
<?php if (!$receipt->dated->ReadOnly && !$receipt->dated->Disabled && !isset($receipt->dated->EditAttrs["readonly"]) && !isset($receipt->dated->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("freceiptadd", "x_dated", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $receipt->dated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->from_account->Visible) { // from_account ?>
	<div id="r_from_account" class="form-group row">
		<label id="elh_receipt_from_account" class="<?php echo $receipt_add->LeftColumnClass ?>"><?php echo $receipt->from_account->caption() ?><?php echo ($receipt->from_account->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_add->RightColumnClass ?>"><div<?php echo $receipt->from_account->cellAttributes() ?>>
<span id="el_receipt_from_account">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$receipt->from_account->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$receipt->from_account->EditAttrs["onchange"] = "";
?>
<span id="as_x_from_account" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_from_account" id="sv_x_from_account" value="<?php echo RemoveHtml($receipt->from_account->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($receipt->from_account->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($receipt->from_account->getPlaceHolder()) ?>"<?php echo $receipt->from_account->editAttributes() ?>>
</span>
<input type="hidden" data-table="receipt" data-field="x_from_account" data-value-separator="<?php echo $receipt->from_account->displayValueSeparatorAttribute() ?>" name="x_from_account" id="x_from_account" value="<?php echo HtmlEncode($receipt->from_account->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
freceiptadd.createAutoSuggest({"id":"x_from_account","forceSelect":true});
</script>
<?php echo $receipt->from_account->Lookup->getParamTag("p_x_from_account") ?>
</span>
<?php echo $receipt->from_account->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label id="elh_receipt_reference" class="<?php echo $receipt_add->LeftColumnClass ?>"><?php echo $receipt->reference->caption() ?><?php echo ($receipt->reference->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_add->RightColumnClass ?>"><div<?php echo $receipt->reference->cellAttributes() ?>>
<span id="el_receipt_reference">
<?php $receipt->reference->EditAttrs["onclick"] = "ew.autoFill(this); " . @$receipt->reference->EditAttrs["onclick"]; ?>
<div id="tp_x_reference" class="ew-template"><input type="radio" class="form-check-input" data-table="receipt" data-field="x_reference" data-value-separator="<?php echo $receipt->reference->displayValueSeparatorAttribute() ?>" name="x_reference" id="x_reference" value="{value}"<?php echo $receipt->reference->editAttributes() ?>></div>
<div id="dsl_x_reference" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $receipt->reference->radioButtonListHtml(FALSE, "x_reference") ?>
</div></div>
<?php echo $receipt->reference->Lookup->getParamTag("p_x_reference") ?>
</span>
<?php echo $receipt->reference->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label id="elh_receipt_total_amount" for="x_total_amount" class="<?php echo $receipt_add->LeftColumnClass ?>"><?php echo $receipt->total_amount->caption() ?><?php echo ($receipt->total_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_add->RightColumnClass ?>"><div<?php echo $receipt->total_amount->cellAttributes() ?>>
<span id="el_receipt_total_amount">
<input type="text" data-table="receipt" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" size="30" placeholder="<?php echo HtmlEncode($receipt->total_amount->getPlaceHolder()) ?>" value="<?php echo $receipt->total_amount->EditValue ?>"<?php echo $receipt->total_amount->editAttributes() ?>>
</span>
<?php echo $receipt->total_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->panel_amount->Visible) { // panel_amount ?>
	<div id="r_panel_amount" class="form-group row">
		<label id="elh_receipt_panel_amount" for="x_panel_amount" class="<?php echo $receipt_add->LeftColumnClass ?>"><?php echo $receipt->panel_amount->caption() ?><?php echo ($receipt->panel_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_add->RightColumnClass ?>"><div<?php echo $receipt->panel_amount->cellAttributes() ?>>
<span id="el_receipt_panel_amount">
<input type="text" data-table="receipt" data-field="x_panel_amount" name="x_panel_amount" id="x_panel_amount" size="30" placeholder="<?php echo HtmlEncode($receipt->panel_amount->getPlaceHolder()) ?>" value="<?php echo $receipt->panel_amount->EditValue ?>"<?php echo $receipt->panel_amount->editAttributes() ?>>
</span>
<?php echo $receipt->panel_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_receipt_amount" for="x_amount" class="<?php echo $receipt_add->LeftColumnClass ?>"><?php echo $receipt->amount->caption() ?><?php echo ($receipt->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_add->RightColumnClass ?>"><div<?php echo $receipt->amount->cellAttributes() ?>>
<span id="el_receipt_amount">
<input type="text" data-table="receipt" data-field="x_amount" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($receipt->amount->getPlaceHolder()) ?>" value="<?php echo $receipt->amount->EditValue ?>"<?php echo $receipt->amount->editAttributes() ?>>
</span>
<?php echo $receipt->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label id="elh_receipt_balance" for="x_balance" class="<?php echo $receipt_add->LeftColumnClass ?>"><?php echo $receipt->balance->caption() ?><?php echo ($receipt->balance->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_add->RightColumnClass ?>"><div<?php echo $receipt->balance->cellAttributes() ?>>
<span id="el_receipt_balance">
<input type="text" data-table="receipt" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($receipt->balance->getPlaceHolder()) ?>" value="<?php echo $receipt->balance->EditValue ?>"<?php echo $receipt->balance->editAttributes() ?>>
</span>
<?php echo $receipt->balance->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->to_account->Visible) { // to_account ?>
	<div id="r_to_account" class="form-group row">
		<label id="elh_receipt_to_account" for="x_to_account" class="<?php echo $receipt_add->LeftColumnClass ?>"><?php echo $receipt->to_account->caption() ?><?php echo ($receipt->to_account->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_add->RightColumnClass ?>"><div<?php echo $receipt->to_account->cellAttributes() ?>>
<span id="el_receipt_to_account">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="receipt" data-field="x_to_account" data-value-separator="<?php echo $receipt->to_account->displayValueSeparatorAttribute() ?>" id="x_to_account" name="x_to_account"<?php echo $receipt->to_account->editAttributes() ?>>
		<?php echo $receipt->to_account->selectOptionListHtml("x_to_account") ?>
	</select>
</div>
<?php echo $receipt->to_account->Lookup->getParamTag("p_x_to_account") ?>
</span>
<?php echo $receipt->to_account->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($receipt->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_receipt_remarks" for="x_remarks" class="<?php echo $receipt_add->LeftColumnClass ?>"><?php echo $receipt->remarks->caption() ?><?php echo ($receipt->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $receipt_add->RightColumnClass ?>"><div<?php echo $receipt->remarks->cellAttributes() ?>>
<span id="el_receipt_remarks">
<input type="text" data-table="receipt" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($receipt->remarks->getPlaceHolder()) ?>" value="<?php echo $receipt->remarks->EditValue ?>"<?php echo $receipt->remarks->editAttributes() ?>>
</span>
<?php echo $receipt->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$receipt_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $receipt_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $receipt_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$receipt_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

			$("#r_i_no").hide();
			$("#r_i_date").hide();
			$("#r_ref").hide();
</script>
<?php include_once "footer.php" ?>
<?php
$receipt_add->terminate();
?>